/*
Copyright 2022 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/resolution/pkg/apis/resolution/v1alpha1"
	scheme "github.com/tektoncd/resolution/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ResolutionRequestsGetter has a method to return a ResolutionRequestInterface.
// A group's client should implement this interface.
type ResolutionRequestsGetter interface {
	ResolutionRequests(namespace string) ResolutionRequestInterface
}

// ResolutionRequestInterface has methods to work with ResolutionRequest resources.
type ResolutionRequestInterface interface {
	Create(ctx context.Context, resolutionRequest *v1alpha1.ResolutionRequest, opts v1.CreateOptions) (*v1alpha1.ResolutionRequest, error)
	Update(ctx context.Context, resolutionRequest *v1alpha1.ResolutionRequest, opts v1.UpdateOptions) (*v1alpha1.ResolutionRequest, error)
	UpdateStatus(ctx context.Context, resolutionRequest *v1alpha1.ResolutionRequest, opts v1.UpdateOptions) (*v1alpha1.ResolutionRequest, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ResolutionRequest, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ResolutionRequestList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ResolutionRequest, err error)
	ResolutionRequestExpansion
}

// resolutionRequests implements ResolutionRequestInterface
type resolutionRequests struct {
	client rest.Interface
	ns     string
}

// newResolutionRequests returns a ResolutionRequests
func newResolutionRequests(c *ResolutionV1alpha1Client, namespace string) *resolutionRequests {
	return &resolutionRequests{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the resolutionRequest, and returns the corresponding resolutionRequest object, and an error if there is any.
func (c *resolutionRequests) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ResolutionRequest, err error) {
	result = &v1alpha1.ResolutionRequest{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("resolutionrequests").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ResolutionRequests that match those selectors.
func (c *resolutionRequests) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ResolutionRequestList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ResolutionRequestList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("resolutionrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested resolutionRequests.
func (c *resolutionRequests) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("resolutionrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a resolutionRequest and creates it.  Returns the server's representation of the resolutionRequest, and an error, if there is any.
func (c *resolutionRequests) Create(ctx context.Context, resolutionRequest *v1alpha1.ResolutionRequest, opts v1.CreateOptions) (result *v1alpha1.ResolutionRequest, err error) {
	result = &v1alpha1.ResolutionRequest{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("resolutionrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resolutionRequest).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a resolutionRequest and updates it. Returns the server's representation of the resolutionRequest, and an error, if there is any.
func (c *resolutionRequests) Update(ctx context.Context, resolutionRequest *v1alpha1.ResolutionRequest, opts v1.UpdateOptions) (result *v1alpha1.ResolutionRequest, err error) {
	result = &v1alpha1.ResolutionRequest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("resolutionrequests").
		Name(resolutionRequest.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resolutionRequest).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *resolutionRequests) UpdateStatus(ctx context.Context, resolutionRequest *v1alpha1.ResolutionRequest, opts v1.UpdateOptions) (result *v1alpha1.ResolutionRequest, err error) {
	result = &v1alpha1.ResolutionRequest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("resolutionrequests").
		Name(resolutionRequest.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resolutionRequest).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the resolutionRequest and deletes it. Returns an error if one occurs.
func (c *resolutionRequests) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("resolutionrequests").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *resolutionRequests) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("resolutionrequests").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched resolutionRequest.
func (c *resolutionRequests) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ResolutionRequest, err error) {
	result = &v1alpha1.ResolutionRequest{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("resolutionrequests").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
