# TektonCD CLI Release Process

### Prerequisites

- You need to be a member of tektoncd-cli [OWNERS](OWNERS) and be a member of the [CLI maintainers team](https://github.com/orgs/tektoncd/teams/cli-maintainers) to be able to push a new branch for the release and update the CLI Homebrew formula. 

- You need to have your own Kubernetes cluster (e.g. `minikube`, `gcp`, or other means) with Tekton installed.

- You need to have [these tools](https://github.com/tektoncd/cli/blob/master/tekton/release.sh#L13y) installed locally.

- You will need to have a [GPG key set up](https://help.github.com/en/github/authenticating-to-github/managing-commit-signature-verification) with your git account to push the release branch.

- You will require a github personal access token, which the release script will ask you to provide. You can generate a GitHub token using the following 
[instructions](https://help.github.com/en/github/authenticating-to-github/creating-a-personal-access-token-for-the-command-line). Your token needs following access: `admin:org, read:packages, repo, write:packages`.

- You need to have your user added to the `https://copr.fedorainfracloud.org/coprs/chmouel/tektoncd-cli/`. Request it by going [here](https://copr.fedorainfracloud.org/coprs/chmouel/tektoncd-cli/permissions/) and asking for admin access.

- You need to have your user added to the [launchpad team](https://launchpad.net/~tektoncd), and make sure as well that you have setup your GPG key and add it to your profile on launchpad.

- Set the `GOPATH` environment variable so that the release script will recognize the following path to the cli project: `${GOPATH}/src/github.com/tektoncd/cli`

### Release Steps

The steps below are meant to be followed in order. Some steps can be done in a different order, but it is generally recommended to follow the process outlined below without skipping steps.

- Start reading this [README](tekton/README.md), and you can start a new release
  with the [release.sh](tekton/release.sh) script.

- When the release is done in https://github.com/tektoncd/cli/releases, edit the
  release and change it from pre-release to released. Make sure to do this before 
  the next step for the rpm package. 

- When it's released, you can build the rpm package according to this
  [README](tekton/rpmbuild/README.md). Make sure you have done the prerequisite to be
  able to upload it to the copr repository. This could take some time if copr
  builder is busy.

- While the rpm task is building the rpm package, you can start building the
  debian package according to this [README](tekton/debbuild/README.md). Make sure 
  you have done the prerequisite to be able to upload to the launchpad team.

- You need to edit the Changelog according to the other templates in there.
  Usually you may want to do this in hackmd so you can have other cli
  maintainers do this with you. You can see an example
  [here](https://gist.github.com/chmouel/8a837af3a592df47db9e81da8846c673).

- Get someone with OSX to test the `brew install tektoncd/cli/tektoncd-cli`

- Get someone with Fedora to test the RPM:

```shell
dnf makecache
dnf upgrade tektoncd-cli
```

- Make an update on [homebrew-core](https://github.com/Homebrew/homebrew-core/blob/master/Formula/tektoncd-cli.rb) for tektoncd-cli formula.

  * Make sure you get the proper `sha256sum`. You need to download the `Source Code (tar.gz)` from this [link](https://github.com/Homebrew/homebrew-core/blob/master/Formula/tektoncd-cli.rb#L4), but replace the version number with the version number you have released. After downloading, run the command below on the downloaded file (once again you will need to replace the version shown below with the released version):
  
    ```shell script
    sha256sum cli-0.7.1.tar.gz 
    ```
    
    You will get similar output to what is shown below:
    
    `72df3075303d2b0393bae9a0f9e9b8441060b8a4db57e613ba8f1bfda03809b5  cli-0.7.1.tar.gz`

  * Raise a PR to update like [this](https://github.com/Homebrew/homebrew-core/pull/46492) to Homebrew Core

- Make a version update to the test-runner and `tkn` image in the [plumbing](https://github.com/tektoncd/plumbing/) repo. The test-runner image is used to run the CI on the pipeline project, which uses `tkn`. For both Dockerfiles listed below, search for `ARG TKN_VERSION` in the Dockerfile for where to update the release version. Update the version arg to match the version of `tkn` released (i.e. `ARG TKN_VERSION=<RELEASED_VERSION>`).

  * [test-runner image](https://github.com/tektoncd/plumbing/blob/master/tekton/images/test-runner/Dockerfile) 

  * [tkn image](https://github.com/tektoncd/plumbing/blob/master/tekton/images/tkn/Dockerfile)

- Update the version numbers in the main [README.md](README.md) to the version you are releasing by opening a pull request to the master branch of this repository. Do not worry about updating the README for the release branch.

- Make sure we have a nice ChangeLog before doing the release, listing `features`
and `bugs`, and be thankful to the contributors by listing them. An example is shown [here](https://github.com/tektoncd/cli/releases/tag/v0.13.0).

- Announce and spread the love on twitter. Make sure you tag
  [@tektoncd](https://twitter.com/tektoncd) account so you get retweeted and
  perhaps add the major new features in the tweet. See [here](https://twitter.com/chmouel/status/1177172542144036869) for an example.
  Do not fear to add a bunch of  emojis 🎉🥳. Ask @vdemeester for tips 🤣.

- Notify the cli, pipeline, and general channels on slack.
