// Code generated by github.com/twpayne/chezmoi/internal/cmd/generate-assets. DO NOT EDIT.
// +build !noembeddocs

package cmd

func init() {
	assets["docs/REFERENCE.md"] = []byte("" +
		"# chezmoi Reference Manual\n" +
		"\n" +
		"Manage your dotfiles securely across multiple machines.\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Concepts](#concepts)\n" +
		"* [Global command line flags](#global-command-line-flags)\n" +
		"  * [`--color` *value*](#--color-value)\n" +
		"  * [`-c`, `--config` *filename*](#-c---config-filename)\n" +
		"  * [`--cpu-profile` *filename*](#--cpu-profile-filename)\n" +
		"  * [`--debug`](#--debug)\n" +
		"  * [`-D`, `--destination` *directory*](#-d---destination-directory)\n" +
		"  * [`-n`, `--dry-run`](#-n---dry-run)\n" +
		"  * [`--force`](#--force)\n" +
		"  * [`-h`, `--help`](#-h---help)\n" +
		"  * [`-k`, `--keep-going`](#-k---keep-going)\n" +
		"  * [`--no-pager`](#--no-pager)\n" +
		"  * [`--no-tty`](#--no-tty)\n" +
		"  * [`-o`, `--output` *filename*](#-o---output-filename)\n" +
		"  * [`-r`. `--remove`](#-r---remove)\n" +
		"  * [`-S`, `--source` *directory*](#-s---source-directory)\n" +
		"  * [`--use-builtin-git` *value*](#--use-builtin-git-value)\n" +
		"  * [`-v`, `--verbose`](#-v---verbose)\n" +
		"  * [`--version`](#--version)\n" +
		"* [Common command line flags](#common-command-line-flags)\n" +
		"  * [`--format` *format*](#--format-format)\n" +
		"  * [`--include` *types*](#--include-types)\n" +
		"  * [`-r`, `--recursive`](#-r---recursive)\n" +
		"* [Configuration file](#configuration-file)\n" +
		"  * [Variables](#variables)\n" +
		"  * [Examples](#examples)\n" +
		"* [Source state attributes](#source-state-attributes)\n" +
		"* [Special files and directories](#special-files-and-directories)\n" +
		"  * [`.chezmoi.<format>.tmpl`](#chezmoiformattmpl)\n" +
		"  * [`.chezmoiignore`](#chezmoiignore)\n" +
		"  * [`.chezmoiremove`](#chezmoiremove)\n" +
		"  * [`.chezmoitemplates`](#chezmoitemplates)\n" +
		"  * [`.chezmoiversion`](#chezmoiversion)\n" +
		"* [Commands](#commands)\n" +
		"  * [`add` *targets*](#add-targets)\n" +
		"  * [`--follow`](#--follow)\n" +
		"  * [`apply` [*targets*]](#apply-targets)\n" +
		"  * [`archive`](#archive)\n" +
		"  * [`cat` *targets*](#cat-targets)\n" +
		"  * [`cd`](#cd)\n" +
		"  * [`chattr` *attributes* *targets*](#chattr-attributes-targets)\n" +
		"  * [`completion` *shell*](#completion-shell)\n" +
		"  * [`data`](#data)\n" +
		"  * [`diff` [*targets*]](#diff-targets)\n" +
		"  * [`docs` [*regexp*]](#docs-regexp)\n" +
		"  * [`doctor`](#doctor)\n" +
		"  * [`dump` [*targets*]](#dump-targets)\n" +
		"  * [`edit` [*targets*]](#edit-targets)\n" +
		"  * [`edit-config`](#edit-config)\n" +
		"  * [`execute-template` [*templates*]](#execute-template-templates)\n" +
		"  * [`forget` *targets*](#forget-targets)\n" +
		"  * [`git` [*arguments*]](#git-arguments)\n" +
		"  * [`help` *command*](#help-command)\n" +
		"  * [`init` [*repo*]](#init-repo)\n" +
		"  * [`import` *filename*](#import-filename)\n" +
		"  * [`manage` *targets*](#manage-targets)\n" +
		"  * [`managed`](#managed)\n" +
		"  * [`merge` *targets*](#merge-targets)\n" +
		"  * [`purge`](#purge)\n" +
		"  * [`remove` *targets*](#remove-targets)\n" +
		"  * [`rm` *targets*](#rm-targets)\n" +
		"  * [`secret`](#secret)\n" +
		"  * [`source-path` [*targets*]](#source-path-targets)\n" +
		"  * [`state`](#state)\n" +
		"  * [`status`](#status)\n" +
		"  * [`unmanage` *targets*](#unmanage-targets)\n" +
		"  * [`unmanaged`](#unmanaged)\n" +
		"  * [`update`](#update)\n" +
		"  * [`upgrade`](#upgrade)\n" +
		"  * [`verify` [*targets*]](#verify-targets)\n" +
		"* [Editor configuration](#editor-configuration)\n" +
		"* [Umask configuration](#umask-configuration)\n" +
		"* [Template execution](#template-execution)\n" +
		"* [Template variables](#template-variables)\n" +
		"* [Template functions](#template-functions)\n" +
		"  * [`bitwarden` [*args*]](#bitwarden-args)\n" +
		"  * [`bitwardenAttachment` *filename* *itemid*](#bitwardenattachment-filename-itemid)\n" +
		"  * [`bitwardenFields` [*args*]](#bitwardenfields-args)\n" +
		"  * [`gitHubKeys` *user*](#githubkeys-user)\n" +
		"  * [`gopass` *gopass-name*](#gopass-gopass-name)\n" +
		"  * [`include` *filename*](#include-filename)\n" +
		"  * [`ioreg`](#ioreg)\n" +
		"  * [`joinPath` *elements*](#joinpath-elements)\n" +
		"  * [`keepassxc` *entry*](#keepassxc-entry)\n" +
		"  * [`keepassxcAttribute` *entry* *attribute*](#keepassxcattribute-entry-attribute)\n" +
		"  * [`keyring` *service* *user*](#keyring-service-user)\n" +
		"  * [`lastpass` *id*](#lastpass-id)\n" +
		"  * [`lastpassRaw` *id*](#lastpassraw-id)\n" +
		"  * [`lookPath` *file*](#lookpath-file)\n" +
		"  * [`onepassword` *uuid* [*vault-uuid*]](#onepassword-uuid-vault-uuid)\n" +
		"  * [`onepasswordDocument` *uuid* [*vault-uuid*]](#onepassworddocument-uuid-vault-uuid)\n" +
		"  * [`onepasswordDetailsFields` *uuid* [*vault-uuid*]](#onepassworddetailsfields-uuid-vault-uuid)\n" +
		"  * [`pass` *pass-name*](#pass-pass-name)\n" +
		"  * [`promptBool` *prompt*](#promptbool-prompt)\n" +
		"  * [`promptInt` *prompt*](#promptint-prompt)\n" +
		"  * [`promptString` *prompt*](#promptstring-prompt)\n" +
		"  * [`secret` [*args*]](#secret-args)\n" +
		"  * [`secretJSON` [*args*]](#secretjson-args)\n" +
		"  * [`stat` *name*](#stat-name)\n" +
		"  * [`vault` *key*](#vault-key)\n" +
		"\n" +
		"## Concepts\n" +
		"\n" +
		"chezmoi evaluates the source state for the current machine and then updates the\n" +
		"destination directory, where:\n" +
		"\n" +
		"* The *source state* declares the desired state of your home directory,\n" +
		"  including templates and machine-specific configuration.\n" +
		"\n" +
		"* The *source directory* is where chezmoi stores the source state, by default\n" +
		"  `~/.local/share/chezmoi`.\n" +
		"\n" +
		"* The *target state* is the source state computed for the current machine.\n" +
		"\n" +
		"* The *destination directory* is the directory that chezmoi manages, by default\n" +
		"  `~`, your home directory.\n" +
		"\n" +
		"* A *target* is a file, directory, or symlink in the destination directory.\n" +
		"\n" +
		"* The *destination state* is the current state of all the targets in the\n" +
		"  destination directory.\n" +
		"\n" +
		"* The *config file* contains machine-specific configuration, by default it is\n" +
		"  `~/.config/chezmoi/chezmoi.toml`.\n" +
		"\n" +
		"## Global command line flags\n" +
		"\n" +
		"Command line flags override any values set in the configuration file.\n" +
		"\n" +
		"### `--color` *value*\n" +
		"\n" +
		"Colorize diffs, *value* can be `on`, `off`, `auto`, or any boolean-like value\n" +
		"recognized by `parseBool`. The default is `auto` which will colorize diffs only\n" +
		"if the the environment variable `NO_COLOR` is not set and stdout is a terminal.\n" +
		"\n" +
		"### `-c`, `--config` *filename*\n" +
		"\n" +
		"Read the configuration from *filename*.\n" +
		"\n" +
		"### `--cpu-profile` *filename*\n" +
		"\n" +
		"Write a [CPU profile](https://blog.golang.org/pprof) to *filename*.\n" +
		"\n" +
		"### `--debug`\n" +
		"\n" +
		"Log information helpful for debugging.\n" +
		"\n" +
		"### `-D`, `--destination` *directory*\n" +
		"\n" +
		"Use *directory* as the destination directory.\n" +
		"\n" +
		"### `-n`, `--dry-run`\n" +
		"\n" +
		"Set dry run mode. In dry run mode, the destination directory is never modified.\n" +
		"This is most useful in combination with the `-v` (verbose) flag to print changes\n" +
		"that would be made without making them.\n" +
		"\n" +
		"### `--force`\n" +
		"\n" +
		"Make changes without prompting.\n" +
		"\n" +
		"### `-h`, `--help`\n" +
		"\n" +
		"Print help.\n" +
		"\n" +
		"### `-k`, `--keep-going`\n" +
		"\n" +
		"Keep going as far as possible after a encountering an error.\n" +
		"\n" +
		"### `--no-pager`\n" +
		"\n" +
		"Do not use the pager.\n" +
		"\n" +
		"### `--no-tty`\n" +
		"\n" +
		"Do not attempt to get a TTY to read input and passwords. Instead, read them from\n" +
		"stdin.\n" +
		"\n" +
		"### `-o`, `--output` *filename*\n" +
		"\n" +
		"Write the output to *filename* instead of stdout.\n" +
		"\n" +
		"### `-r`. `--remove`\n" +
		"\n" +
		"Also remove targets according to `.chezmoiremove`.\n" +
		"\n" +
		"### `-S`, `--source` *directory*\n" +
		"\n" +
		"Use *directory* as the source directory.\n" +
		"\n" +
		"### `--use-builtin-git` *value*\n" +
		"\n" +
		"Use chezmoi's builtin git instead of `git.command` for the `init` and `update`\n" +
		"commands. *value* can be `on`, `off`, `auto`, or any boolean-like value\n" +
		"recognized by `parseBool`. The default is `auto` which will only use the builtin\n" +
		"git if `git.command` cannot be found in `$PATH`.\n" +
		"\n" +
		"### `-v`, `--verbose`\n" +
		"\n" +
		"Set verbose mode. In verbose mode, chezmoi prints the changes that it is making\n" +
		"as approximate shell commands, and any differences in files between the target\n" +
		"state and the destination set are printed as unified diffs.\n" +
		"\n" +
		"### `--version`\n" +
		"\n" +
		"Print the version of chezmoi, the commit at which it was built, and the build\n" +
		"timestamp.\n" +
		"\n" +
		"## Common command line flags\n" +
		"\n" +
		"The following flags apply to multiple commands where they are relevant.\n" +
		"\n" +
		"### `--format` *format*\n" +
		"\n" +
		"Set the output format. *format* can be `json` or `yaml`.\n" +
		"\n" +
		"### `--include` *types*\n" +
		"\n" +
		"Only operate on target state entries of type *types*. *types* is a\n" +
		"comma-separated list of target states (`absent`, `all`, `dirs`, `files`,\n" +
		"`scripts`, `symlinks`) and can be excluded by preceeding them with a `!`. For\n" +
		"example, `--include=all,!scripts` will cause the command to apply to all target\n" +
		"state entries except scripts.\n" +
		"\n" +
		"### `-r`, `--recursive`\n" +
		"\n" +
		"Recurse into subdirectories, `true` by default.\n" +
		"\n" +
		"## Configuration file\n" +
		"\n" +
		"chezmoi searches for its configuration file according to the [XDG Base Directory\n" +
		"Specification](https://standards.freedesktop.org/basedir-spec/basedir-spec-latest.html)\n" +
		"and supports all formats supported by\n" +
		"[`github.com/spf13/viper`](https://github.com/spf13/viper), namely\n" +
		"[JSON](https://www.json.org/json-en.html),\n" +
		"[TOML](https://github.com/toml-lang/toml), [YAML](https://yaml.org/), macOS\n" +
		"property file format, and [HCL](https://github.com/hashicorp/hcl). The basename\n" +
		"of the config file is `chezmoi`, and the first config file found is used.\n" +
		"\n" +
		"### Variables\n" +
		"\n" +
		"The following configuration variables are available:\n" +
		"\n" +
		"| Section       | Variable          | Type     | Default value             | Description                                            |\n" +
		"| ------------- | ----------------- | -------- | ------------------------- | ------------------------------------------------------ |\n" +
		"| Top level     | `color`           | string   | `auto`                    | Colorize output                                        |\n" +
		"|               | `data`            | any      | *none*                    | Template data                                          |\n" +
		"|               | `destDir`         | string   | `~`                       | Destination directory                                  |\n" +
		"|               | `encryption`      | string   | *none*                    | Encryption tool, either `age` or `gpg`                 |\n" +
		"|               | `format`          | string   | `json`                    | Format for data output, either `json` or `yaml`        |\n" +
		"|               | `remove`          | bool     | `false`                   | Remove targets                                         |\n" +
		"|               | `sourceDir`       | string   | `~/.local/share/chezmoi`  | Source directory                                       |\n" +
		"|               | `umask`           | int      | *from system*             | Umask                                                  |\n" +
		"|               | `useBuiltinGit`   | string   | `auto`                    | Use builtin git if `git` command is not found in $PATH |\n" +
		"| `age`         | `args`            | []string | *none*                    | Extra args to age CLI command                          |\n" +
		"|               | `command`         | string   | `age`                     | age CLI command                                        |\n" +
		"|               | `identity`        | string   | *none*                    | age identity file                                      |\n" +
		"|               | `identities`      | []string | *none*                    | age identity files                                     |\n" +
		"|               | `recipient`       | string   | *none*                    | age recipient                                          |\n" +
		"|               | `recipients`      | []string | *none*                    | age recipients                                         |\n" +
		"|               | `recipientsFile`  | []string | *none*                    | age recipients file                                    |\n" +
		"|               | `recipientsFiles` | []string | *none*                    | age receipients files                                  |\n" +
		"| `bitwarden`   | `command`         | string   | `bw`                      | Bitwarden CLI command                                  |\n" +
		"| `cd`          | `args`            | []string | *none*                    | Extra args to shell in `cd` command                    |\n" +
		"|               | `command`         | string   | *none*                    | Shell to run in `cd` command                           |\n" +
		"| `diff`        | `pager`           | string   | *none*                    | Pager                                                  |\n" +
		"| `edit`        | `args`            | []string | *none*                    | Extra args to edit command                             |\n" +
		"|               | `command`         | string   | `$EDITOR` / `$VISUAL`     | Edit command                                           |\n" +
		"| `secret`      | `command`         | string   | *none*                    | Generic secret command                                 |\n" +
		"| `git`         | `autoAdd `        | bool     | `false`                   | Add changes to the source state after any change       |\n" +
		"|               | `autoCommit`      | bool     | `false`                   | Commit changes to the source state after any change    |\n" +
		"|               | `autoPush`        | bool     | `false`                   | Push changes to the source state after any change      |\n" +
		"|               | `command`         | string   | `git`                     | Source version control system                          |\n" +
		"| `gopass`      | `command`         | string   | `gopass`                  | gopass CLI command                                     |\n" +
		"| `gpg`         | `args`            | []string | *none*                    | Extra args to GPG CLI command                          |\n" +
		"|               | `command`         | string   | `gpg`                     | GPG CLI command                                        |\n" +
		"|               | `recipient`       | string   | *none*                    | GPG recipient                                          |\n" +
		"|               | `symmetric`       | bool     | `false`                   | Use symmetric GPG encryption                           |\n" +
		"| `keepassxc`   | `args`            | []string | *none*                    | Extra args to KeePassXC CLI command                    |\n" +
		"|               | `command`         | string   | `keepassxc-cli`           | KeePassXC CLI command                                  |\n" +
		"|               | `database`        | string   | *none*                    | KeePassXC database                                     |\n" +
		"| `lastpass`    | `command`         | string   | `lpass`                   | Lastpass CLI command                                   |\n" +
		"| `merge`       | `args`            | []string | *none*                    | Extra args to 3-way merge command                      |\n" +
		"|               | `command`         | string   | `vimdiff`                 | 3-way merge command                                    |\n" +
		"| `onepassword` | `cache`           | bool     | `true`                    | Enable optional caching provided by `op`               |\n" +
		"|               | `command`         | string   | `op`                      | 1Password CLI command                                  |\n" +
		"| `pass`        | `command`         | string   | `pass`                    | Pass CLI command                                       |\n" +
		"| `template`    | `options`         | []string | `[\"missingkey=error\"]`    | Template options                                       |\n" +
		"| `vault`       | `command`         | string   | `vault`                   | Vault CLI command                                      |\n" +
		"\n" +
		"### Examples\n" +
		"\n" +
		"#### JSON\n" +
		"\n" +
		"```json\n" +
		"{\n" +
		"    \"sourceDir\": \"/home/user/.dotfiles\",\n" +
		"    \"git\": {\n" +
		"        \"autoPush\": true\n" +
		"    }\n" +
		"}\n" +
		"```\n" +
		"\n" +
		"#### TOML\n" +
		"\n" +
		"```toml\n" +
		"sourceDir = \"/home/user/.dotfiles\"\n" +
		"[git]\n" +
		"    autoPush = true\n" +
		"```\n" +
		"\n" +
		"#### YAML\n" +
		"\n" +
		"```yaml\n" +
		"sourceDir: /home/user/.dotfiles\n" +
		"git:\n" +
		"    autoPush: true\n" +
		"```\n" +
		"\n" +
		"## Source state attributes\n" +
		"\n" +
		"chezmoi stores the source state of files, symbolic links, and directories in\n" +
		"regular files and directories in the source directory (`~/.local/share/chezmoi`\n" +
		"by default). This location can be overridden with the `-S` flag or by giving a\n" +
		"value for `sourceDir` in `~/.config/chezmoi/chezmoi.toml`.  Some state is\n" +
		"encoded in the source names. chezmoi ignores all files and directories in the\n" +
		"source directory that begin with a `.`. The following prefixes and suffixes are\n" +
		"special, and are collectively referred to as \"attributes\":\n" +
		"\n" +
		"| Prefix       | Effect                                                                         |\n" +
		"| ------------ | ------------------------------------------------------------------------------ |\n" +
		"| `after_`     | Run script after updating the destination.                                     |\n" +
		"| `before_`    | Run script before updating the desintation.                                    |\n" +
		"| `dot_`       | Rename to use a leading dot, e.g. `dot_foo` becomes `.foo`.                    |\n" +
		"| `empty_`     | Ensure the file exists, even if is empty. By default, empty files are removed. |\n" +
		"| `encrypted_` | Encrypt the file in the source state.                                          |\n" +
		"| `exact_`     | Remove anything not managed by chezmoi.                                        |\n" +
		"| `executable_`| Add executable permissions to the target file.                                 |\n" +
		"| `exists_`    | Ensure that the file exists, and initalize its contents if it does not.        |\n" +
		"| `once_`      | Run script once.                                                               |\n" +
		"| `private_`   | Remove all group and world permissions from the target file or directory.      |\n" +
		"| `run_`       | Treat the contents as a script to run.                                         |\n" +
		"| `symlink_`   | Create a symlink instead of a regular file.                                    |\n" +
		"\n" +
		"| Suffix  | Effect                                               |\n" +
		"| ------- | ---------------------------------------------------- |\n" +
		"| `.tmpl` | Treat the contents of the source file as a template. |\n" +
		"\n" +
		"The order of prefixes is important, the order is `run_`, `before_`, `after_`,\n" +
		"`exact_`, `exists_`, `private_`, `empty_`, `executable_`, `symlink_`, `once_`,\n" +
		"`dot_`.\n" +
		"\n" +
		"Different target types allow different prefixes and suffixes:\n" +
		"\n" +
		"| Target type   | Allowed prefixes                                           | Allowed suffixes |\n" +
		"| ------------- | ---------------------------------------------------------- | ---------------- |\n" +
		"| Directory     | `exact_`, `private_`, `dot_`                               | *none*           |\n" +
		"| Present file  | `exists_`, `encrypted_`, `private_`, `executable_`, `dot_` | `.tmpl`          |\n" +
		"| Regular file  | `encrypted_`, `private_`, `empty_`, `executable_`, `dot_`  | `.tmpl`          |\n" +
		"| Script        | `run_`, `once_`, `before_` or `after_`                     | `.tmpl`          |\n" +
		"| Symbolic link | `symlink_`, `dot_`,                                        | `.tmpl`          |\n" +
		"\n" +
		"## Special files and directories\n" +
		"\n" +
		"All files and directories in the source state whose name begins with `.` are\n" +
		"ignored by default, unless they are one of the special files listed here.\n" +
		"\n" +
		"### `.chezmoi.<format>.tmpl`\n" +
		"\n" +
		"If a file called `.chezmoi.<format>.tmpl` exists then `chezmoi init` will use it\n" +
		"to create an initial config file. *format* must be one of the the supported\n" +
		"config file formats.\n" +
		"\n" +
		"#### `.chezmoi.<format>.tmpl` examples\n" +
		"\n" +
		"    {{ $email := promptString \"email\" -}}\n" +
		"    data:\n" +
		"        email: \"{{ $email }}\"\n" +
		"\n" +
		"### `.chezmoiignore`\n" +
		"\n" +
		"If a file called `.chezmoiignore` exists in the source state then it is\n" +
		"interpreted as a set of patterns to ignore. Patterns are matched using\n" +
		"[`doublestar.PathMatch`](https://pkg.go.dev/github.com/bmatcuk/doublestar?tab=doc#PathMatch)\n" +
		"and match against the target path, not the source path.\n" +
		"\n" +
		"Patterns can be excluded by prefixing them with a `!` character. All excludes\n" +
		"take priority over all includes.\n" +
		"\n" +
		"Comments are introduced with the `#` character and run until the end of the\n" +
		"line.\n" +
		"\n" +
		"`.chezmoiignore` is interpreted as a template. This allows different files to be\n" +
		"ignored on different machines.\n" +
		"\n" +
		"`.chezmoiignore` files in subdirectories apply only to that subdirectory.\n" +
		"\n" +
		"#### `.chezmoiignore` examples\n" +
		"\n" +
		"    README.md\n" +
		"\n" +
		"    *.txt   # ignore *.txt in the target directory\n" +
		"    */*.txt # ignore *.txt in subdirectories of the target directory\n" +
		"    backups/** # ignore backups folder in chezmoi directory and all its contents\n" +
		"            # but not in subdirectories of subdirectories;\n" +
		"            # so a/b/c.txt would *not* be ignored\n" +
		"    backups/** # ignore all contents of backups folder in chezmoi directory\n" +
		"               # but not backups folder itself\n" +
		"\n" +
		"    {{- if ne .email \"john.smith@company.com\" }}\n" +
		"    # Ignore .company-directory unless configured with a company email\n" +
		"    .company-directory # note that the pattern is not dot_company-directory\n" +
		"    {{- end }}\n" +
		"\n" +
		"    {{- if ne .email \"john@home.org }}\n" +
		"    .personal-file\n" +
		"    {{- end }}\n" +
		"\n" +
		"### `.chezmoiremove`\n" +
		"\n" +
		"If a file called `.chezmoiremove` exists in the source state then it is\n" +
		"interpreted as a list of targets to remove. `.chezmoiremove` is interpreted as a\n" +
		"template.\n" +
		"\n" +
		"### `.chezmoitemplates`\n" +
		"\n" +
		"If a directory called `.chezmoitemplates` exists, then all files in this\n" +
		"directory are parsed as templates are available as templates with a name equal\n" +
		"to the relative path of the file.\n" +
		"\n" +
		"#### `.chezmoitemplates` examples\n" +
		"\n" +
		"Given:\n" +
		"\n" +
		"    .chezmoitemplates/foo\n" +
		"    {{ if true }}bar{{ end }}\n" +
		"\n" +
		"    dot_config.tmpl\n" +
		"    {{ template \"foo\" }}\n" +
		"\n" +
		"The target state of `.config` will be `bar`.\n" +
		"\n" +
		"### `.chezmoiversion`\n" +
		"\n" +
		"If a file called `.chezmoiversion` exists, then its contents are interpreted as\n" +
		"a semantic version defining the minimum version of chezmoi required to interpret\n" +
		"the source state correctly. chezmoi will refuse to interpret the source state if\n" +
		"the current version is too old.\n" +
		"\n" +
		"#### `.chezmoiversion` examples\n" +
		"\n" +
		"    1.5.0\n" +
		"\n" +
		"## Commands\n" +
		"\n" +
		"### `add` *targets*\n" +
		"\n" +
		"Add *targets* to the source state. If any target is already in the source state,\n" +
		"then its source state is replaced with its current state in the destination\n" +
		"directory. The `add` command accepts additional flags:\n" +
		"\n" +
		"#### `--autotemplate`\n" +
		"\n" +
		"Automatically generate a template by replacing strings with variable names from\n" +
		"the `data` section of the config file. Longer substitutions occur before shorter\n" +
		"ones. This implies the `--template` option.\n" +
		"\n" +
		"#### `-e`, `--empty`\n" +
		"\n" +
		"Set the `empty` attribute on added files.\n" +
		"\n" +
		"#### `-f`, `--force`\n" +
		"\n" +
		"Add *targets*, even if doing so would cause a source template to be overwritten.\n" +
		"\n" +
		"### `--follow`\n" +
		"\n" +
		"If the last part of a target is a symlink, add the target of the symlink instead\n" +
		"of the symlink itself.\n" +
		"\n" +
		"#### `-x`, `--exact`\n" +
		"\n" +
		"Set the `exact` attribute on added directories.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only add entries of type *types*.\n" +
		"\n" +
		"#### `-p`, `--prompt`\n" +
		"\n" +
		"Interactively prompt before adding each file.\n" +
		"\n" +
		"#### `-r`, `--recursive`\n" +
		"\n" +
		"Recursively add all files, directories, and symlinks.\n" +
		"\n" +
		"#### `-T`, `--template`\n" +
		"\n" +
		"Set the `template` attribute on added files and symlinks.\n" +
		"\n" +
		"#### `add` examples\n" +
		"\n" +
		"    chezmoi add ~/.bashrc\n" +
		"    chezmoi add ~/.gitconfig --template\n" +
		"    chezmoi add ~/.vim --recursive\n" +
		"    chezmoi add ~/.oh-my-zsh --exact --recursive\n" +
		"\n" +
		"### `apply` [*targets*]\n" +
		"\n" +
		"Ensure that *targets* are in the target state, updating them if necessary. If no\n" +
		"targets are specified, the state of all targets are ensured. If a target has\n" +
		"been modified since chezmoi last wrote it then the user will be prompted if they\n" +
		"want to overwrite the file.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only add entries of type *types*.\n" +
		"\n" +
		"#### `--source-path`\n" +
		"\n" +
		"Specify targets by source path, rather than target path. This is useful for\n" +
		"applying changes after editing.\n" +
		"\n" +
		"#### `apply` examples\n" +
		"\n" +
		"    chezmoi apply\n" +
		"    chezmoi apply --dry-run --verbose\n" +
		"    chezmoi apply ~/.bashrc\n" +
		"\n" +
		"In `~/.vimrc`:\n" +
		"\n" +
		"    autocmd BufWritePost ~/.local/share/chezmoi/* ! chezmoi apply --source-path %\n" +
		"\n" +
		"### `archive`\n" +
		"\n" +
		"Generate a tar archive of the target state. This can be piped into `tar` to\n" +
		"inspect the target state.\n" +
		"\n" +
		"#### `--format` *format*\n" +
		"\n" +
		"Write the archive in *format*. *format* can be either `tar` (the default) or `zip`.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only include entries of type *types*.\n" +
		"\n" +
		"#### `-z`, `--gzip`\n" +
		"\n" +
		"Compress the output with gzip.\n" +
		"\n" +
		"#### `archive` examples\n" +
		"\n" +
		"    chezmoi archive | tar tvf -\n" +
		"    chezmoi archive --output=dotfiles.tar\n" +
		"    chezmoi archive --format=zip --output=dotfiles.zip\n" +
		"\n" +
		"### `cat` *targets*\n" +
		"\n" +
		"Write the target state of *targets*  to stdout. *targets* must be files or\n" +
		"symlinks. For files, the target file contents are written. For symlinks, the\n" +
		"target target is written.\n" +
		"\n" +
		"#### `cat` examples\n" +
		"\n" +
		"    chezmoi cat ~/.bashrc\n" +
		"\n" +
		"### `cd`\n" +
		"\n" +
		"Launch a shell in the source directory. chezmoi will launch the command set by\n" +
		"the `cd.command` configuration variable with any extra arguments specified by\n" +
		"`cd.args`. If this is not set, chezmoi will attempt to detect your shell and\n" +
		"will finally fall back to an OS-specific default.\n" +
		"\n" +
		"#### `cd` examples\n" +
		"\n" +
		"    chezmoi cd\n" +
		"\n" +
		"### `chattr` *attributes* *targets*\n" +
		"\n" +
		"Change the attributes of *targets*. *attributes* specifies which attributes to\n" +
		"modify. Add attributes by specifying them or their abbreviations directly,\n" +
		"optionally prefixed with a plus sign (`+`). Remove attributes by prefixing them\n" +
		"or their attributes with the string `no` or a minus sign (`-`). The available\n" +
		"attributes and their abbreviations are:\n" +
		"\n" +
		"| Attribute    | Abbreviation |\n" +
		"| ------------ | ------------ |\n" +
		"| `empty`      | `e`          |\n" +
		"| `encrypted`  | *none*       |\n" +
		"| `exact`      | *none*       |\n" +
		"| `executable` | `x`          |\n" +
		"| `private`    | `p`          |\n" +
		"| `template`   | `t`          |\n" +
		"\n" +
		"Multiple attributes modifications may be specified by separating them with a\n" +
		"comma (`,`).\n" +
		"\n" +
		"#### `chattr` examples\n" +
		"\n" +
		"    chezmoi chattr template ~/.bashrc\n" +
		"    chezmoi chattr noempty ~/.profile\n" +
		"    chezmoi chattr private,template ~/.netrc\n" +
		"\n" +
		"### `completion` *shell*\n" +
		"\n" +
		"Generate shell completion code for the specified shell (`bash`, `fish`,\n" +
		"`powershell`, or `zsh`).\n" +
		"\n" +
		"#### `completion` examples\n" +
		"\n" +
		"    chezmoi completion bash\n" +
		"    chezmoi completion fish --output=~/.config/fish/completions/chezmoi.fish\n" +
		"\n" +
		"### `data`\n" +
		"\n" +
		"Write the computed template data to stdout.\n" +
		"\n" +
		"#### `data` examples\n" +
		"\n" +
		"    chezmoi data\n" +
		"    chezmoi data --format=yaml\n" +
		"\n" +
		"### `diff` [*targets*]\n" +
		"\n" +
		"Print the difference between the target state and the destination state for\n" +
		"*targets*. If no targets are specified, print the differences for all targets.\n" +
		"\n" +
		"If a `diff.pager` command is set in the configuration file then the output will\n" +
		"be piped into it.\n" +
		"\n" +
		"#### `diff` examples\n" +
		"\n" +
		"    chezmoi diff\n" +
		"    chezmoi diff ~/.bashrc\n" +
		"\n" +
		"### `docs` [*regexp*]\n" +
		"\n" +
		"Print the documentation page matching the regular expression *regexp*. Matching\n" +
		"is case insensitive. If no pattern is given, print `REFERENCE.md`.\n" +
		"\n" +
		"#### `docs` examples\n" +
		"\n" +
		"    chezmoi docs\n" +
		"    chezmoi docs faq\n" +
		"    chezmoi docs howto\n" +
		"\n" +
		"### `doctor`\n" +
		"\n" +
		"Check for potential problems.\n" +
		"\n" +
		"#### `doctor` examples\n" +
		"\n" +
		"    chezmoi doctor\n" +
		"\n" +
		"### `dump` [*targets*]\n" +
		"\n" +
		"Dump the target state. If no targets are specified, then the entire target\n" +
		"state.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only include entries of type *types*.\n" +
		"\n" +
		"#### `dump` examples\n" +
		"\n" +
		"    chezmoi dump ~/.bashrc\n" +
		"    chezmoi dump --format=yaml\n" +
		"\n" +
		"### `edit` [*targets*]\n" +
		"\n" +
		"Edit the source state of *targets*, which must be files or symlinks. If no\n" +
		"targets are given the the source directory itself is opened with `$EDITOR`. The\n" +
		"`edit` command accepts additional arguments:\n" +
		"\n" +
		"#### `-a`, `--apply`\n" +
		"\n" +
		"Apply target immediately after editing. Ignored if there are no targets.\n" +
		"\n" +
		"#### `edit` examples\n" +
		"\n" +
		"    chezmoi edit ~/.bashrc\n" +
		"    chezmoi edit ~/.bashrc --apply\n" +
		"    chezmoi edit\n" +
		"\n" +
		"### `edit-config`\n" +
		"\n" +
		"Edit the configuration file.\n" +
		"\n" +
		"#### `edit-config` examples\n" +
		"\n" +
		"    chezmoi edit-config\n" +
		"\n" +
		"### `execute-template` [*templates*]\n" +
		"\n" +
		"Execute *templates*. This is useful for testing templates or for calling chezmoi\n" +
		"from other scripts. *templates* are interpreted as literal templates, with no\n" +
		"whitespace added to the output between arguments. If no templates are specified,\n" +
		"the template is read from stdin.\n" +
		"\n" +
		"#### `--init`, `-i`\n" +
		"\n" +
		"Include simulated functions only available during `chezmoi init`.\n" +
		"\n" +
		"#### `--promptBool` *pairs*\n" +
		"\n" +
		"Simulate the `promptBool` function with a function that returns values from\n" +
		"*pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs. If\n" +
		"`promptBool` is called with a *prompt* that does not match any of *pairs*, then\n" +
		"it returns false.\n" +
		"\n" +
		"#### `--promptInt`, `-p` *pairs*\n" +
		"\n" +
		"Simulate the `promptInt` function with a function that returns values from\n" +
		"*pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs. If\n" +
		"`promptInt` is called with a *prompt* that does not match any of *pairs*, then\n" +
		"it returns zero.\n" +
		"\n" +
		"#### `--promptString`, `-p` *pairs*\n" +
		"\n" +
		"Simulate the `promptString` function with a function that returns values from\n" +
		"*pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs. If\n" +
		"`promptString` is called with a *prompt* that does not match any of *pairs*,\n" +
		"then it returns *prompt* unchanged.\n" +
		"\n" +
		"#### `execute-template` examples\n" +
		"\n" +
		"    chezmoi execute-template '{{ .chezmoi.sourceDir }}'\n" +
		"    chezmoi execute-template '{{ .chezmoi.os }}' / '{{ .chezmoi.arch }}'\n" +
		"    echo '{{ .chezmoi | toJson }}' | chezmoi execute-template\n" +
		"    chezmoi execute-template --init --promptString email=john@home.org < ~/.local/share/chezmoi/.chezmoi.toml.tmpl\n" +
		"\n" +
		"### `forget` *targets*\n" +
		"\n" +
		"Remove *targets* from the source state, i.e. stop managing them.\n" +
		"\n" +
		"#### `forget` examples\n" +
		"\n" +
		"    chezmoi forget ~/.bashrc\n" +
		"\n" +
		"### `git` [*arguments*]\n" +
		"\n" +
		"Run `git` *arguments* in the source directory. Note that flags in *arguments*\n" +
		"must occur after `--` to prevent chezmoi from interpreting them.\n" +
		"\n" +
		"#### `git` examples\n" +
		"\n" +
		"    chezmoi git add .\n" +
		"    chezmoi git add dot_gitconfig\n" +
		"    chezmoi git -- commit -m \"Add .gitconfig\"\n" +
		"\n" +
		"### `help` *command*\n" +
		"\n" +
		"Print the help associated with *command*.\n" +
		"\n" +
		"### `init` [*repo*]\n" +
		"\n" +
		"Setup the source directory and update the destination directory to match the\n" +
		"target state. *repo* is expanded to a full git repo URL using the following\n" +
		"rules:\n" +
		"\n" +
		"| Pattern            | Repo                                   |\n" +
		"| ------------------ | -------------------------------------- |\n" +
		"| `user`             | `https://github.com/user/dotfiles.git` |\n" +
		"| `user/repo`        | `https://github.com/user/repo.git`     |\n" +
		"| `site/user/repo`   | `https://site/user/repo.git`           |\n" +
		"| `~sr.ht/user`      | `https://git.sr.ht/~user/dotfiles`     |\n" +
		"| `~sr.ht/user/repo` | `https://git.sr.ht/~user/repo`         |\n" +
		"\n" +
		"First, if the source directory is not already contain a repository, then if\n" +
		"*repo* is given it is checked out into the source directory, otherwise a new\n" +
		"repository is initialized in the source directory.\n" +
		"\n" +
		"Second, if a file called `.chezmoi.<format>.tmpl` exists, where `<format>` is\n" +
		"one of the supported file formats (e.g. `json`, `toml`, or `yaml`) then a new\n" +
		"configuration file is created using that file as a template.\n" +
		"\n" +
		"Then, if the `--apply` flag is passed, `chezmoi apply` is run.\n" +
		"\n" +
		"Then, if the `--purge` flag is passed, chezmoi will remove the source directory\n" +
		"and its config directory.\n" +
		"\n" +
		"Finally, if the `--purge-binary` is passed, chezmoi will attempt to remove its\n" +
		"own binary.\n" +
		"\n" +
		"#### `--apply`\n" +
		"\n" +
		"Run `chezmoi apply` after checking out the repo and creating the config file.\n" +
		"\n" +
		"#### `--depth` *depth*\n" +
		"\n" +
		"Clone the repo with depth *depth*.\n" +
		"\n" +
		"#### `--one-shot`\n" +
		"\n" +
		"`--one-shot` is the equivalent of `--apply`, `--depth=1`, `--purge`,\n" +
		"`--purge-binary`. It attempts to install your dotfiles with chezmoi and then\n" +
		"remove all traces of chezmoi from the system. This is useful for setting up\n" +
		"temporary environments (e.g. Docker containers).\n" +
		"\n" +
		"#### `--purge`\n" +
		"\n" +
		"Remove the source and config directories after applying.\n" +
		"\n" +
		"#### `--purge-binary`\n" +
		"\n" +
		"Attempt to remove the chezmoi binary after applying.\n" +
		"\n" +
		"#### `--skip-encrypted`\n" +
		"\n" +
		"Skip encrypted files. This is useful for setting up machines with an inital set\n" +
		"of dotfiles before private decryption keys are available.\n" +
		"\n" +
		"#### `init` examples\n" +
		"\n" +
		"    chezmoi init user\n" +
		"    chezmoi init user --apply\n" +
		"    chezmoi init user --apply --purge\n" +
		"    chezmoi init user/dots\n" +
		"    chezmoi init gitlab.com/user\n" +
		"\n" +
		"### `import` *filename*\n" +
		"\n" +
		"Import the source state from an archive file in to a directory in the source\n" +
		"state. This is primarily used to make subdirectories of your home directory\n" +
		"exactly match the contents of a downloaded archive. You will generally always\n" +
		"want to set the `--destination`, `--exact`, and `--remove-destination` flags.\n" +
		"\n" +
		"The only supported archive format is `.tar.gz`.\n" +
		"\n" +
		"#### `--destination` *directory*\n" +
		"\n" +
		"Set the destination (in the source state) where the archive will be imported.\n" +
		"\n" +
		"#### `-x`, `--exact`\n" +
		"\n" +
		"Set the `exact` attribute on all imported directories.\n" +
		"\n" +
		"#### `-r`, `--remove-destination`\n" +
		"\n" +
		"Remove destination (in the source state) before importing.\n" +
		"\n" +
		"#### `--strip-components` *n*\n" +
		"\n" +
		"Strip *n* leading components from paths.\n" +
		"\n" +
		"#### `import` examples\n" +
		"\n" +
		"    curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-zsh/archive/master.tar.gz\n" +
		"    chezmoi import --strip-components 1 --destination ~/.oh-my-zsh oh-my-zsh-master.tar.gz\n" +
		"\n" +
		"### `manage` *targets*\n" +
		"\n" +
		"`manage` is an alias for `add` for symmetry with `unmanage`.\n" +
		"\n" +
		"### `managed`\n" +
		"\n" +
		"List all managed entries in the destination directory in alphabetical order.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only include entries of type *types*.\n" +
		"\n" +
		"#### `managed` examples\n" +
		"\n" +
		"    chezmoi managed\n" +
		"    chezmoi managed --include=files\n" +
		"    chezmoi managed --include=files,symlinks\n" +
		"    chezmoi managed -i d\n" +
		"    chezmoi managed -i d,f\n" +
		"\n" +
		"### `merge` *targets*\n" +
		"\n" +
		"Perform a three-way merge between the destination state, the target state, and\n" +
		"the source state. The merge tool is defined by the `merge.command` configuration\n" +
		"variable, and defaults to `vimdiff`. If multiple targets are specified the merge\n" +
		"tool is invoked for each target. If the target state cannot be computed (for\n" +
		"example if source is a template containing errors or an encrypted file that\n" +
		"cannot be decrypted) a two-way merge is performed instead.\n" +
		"\n" +
		"#### `merge` examples\n" +
		"\n" +
		"    chezmoi merge ~/.bashrc\n" +
		"\n" +
		"### `purge`\n" +
		"\n" +
		"Remove chezmoi's configuration, state, and source directory, but leave the\n" +
		"target state intact.\n" +
		"\n" +
		"#### `-f`, `--force`\n" +
		"\n" +
		"Remove without prompting.\n" +
		"\n" +
		"#### `purge` examples\n" +
		"\n" +
		"    chezmoi purge\n" +
		"    chezmoi purge --force\n" +
		"\n" +
		"### `remove` *targets*\n" +
		"\n" +
		"Remove *targets* from both the source state and the destination directory.\n" +
		"\n" +
		"#### `-f`, `--force`\n" +
		"\n" +
		"Remove without prompting.\n" +
		"\n" +
		"### `rm` *targets*\n" +
		"\n" +
		"`rm` is an alias for `remove`.\n" +
		"\n" +
		"### `secret`\n" +
		"\n" +
		"Run a secret manager's CLI, passing any extra arguments to the secret manager's\n" +
		"CLI. This is primarily for verifying chezmoi's integration with your secret\n" +
		"manager. Normally you would use template functions to retrieve secrets. Note\n" +
		"that if you want to pass flags to the secret manager's CLI you will need to\n" +
		"separate them with `--` to prevent chezmoi from interpreting them.\n" +
		"\n" +
		"To get a full list of available commands run:\n" +
		"\n" +
		"    chezmoi secret help\n" +
		"\n" +
		"#### `secret` examples\n" +
		"\n" +
		"    chezmoi secret keyring set --service=service --user=user --value=password\n" +
		"    chezmoi secret keyring get --service=service --user=user\n" +
		"\n" +
		"### `source-path` [*targets*]\n" +
		"\n" +
		"Print the path to each target's source state. If no targets are specified then\n" +
		"print the source directory.\n" +
		"\n" +
		"#### `source-path` examples\n" +
		"\n" +
		"    chezmoi source-path\n" +
		"    chezmoi source-path ~/.bashrc\n" +
		"\n" +
		"### `state`\n" +
		"\n" +
		"Manipulate the persistent state.\n" +
		"\n" +
		"#### `state` examples\n" +
		"\n" +
		"    chezmoi state dump\n" +
		"    chemzoi state reset\n" +
		"\n" +
		"### `status`\n" +
		"\n" +
		"Print the status of the files and scripts managed by chezmoi in a format similar\n" +
		"to [`git status`](https://git-scm.com/docs/git-status).\n" +
		"\n" +
		"The first column of output indicates the difference between the last state\n" +
		"written by chezmoi and the actual state. The second column indicates the\n" +
		"difference between the actual state and the target state.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only include entries of type *types*.\n" +
		"\n" +
		"#### `status` examples\n" +
		"\n" +
		"    chezmoi status\n" +
		"\n" +
		"### `unmanage` *targets*\n" +
		"\n" +
		"`unmanage` is an alias for `forget` for symmetry with `manage`.\n" +
		"\n" +
		"### `unmanaged`\n" +
		"\n" +
		"List all unmanaged files in the destination directory.\n" +
		"\n" +
		"#### `unmanaged` examples\n" +
		"\n" +
		"    chezmoi unmanaged\n" +
		"\n" +
		"### `update`\n" +
		"\n" +
		"Pull changes from the source VCS and apply any changes.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only update entries of type *types*.\n" +
		"\n" +
		"#### `update` examples\n" +
		"\n" +
		"    chezmoi update\n" +
		"\n" +
		"### `upgrade`\n" +
		"\n" +
		"Upgrade chezmoi by downloading and installing the latest released version. This\n" +
		"will call the GitHub API to determine if there is a new version of chezmoi\n" +
		"available, and if so, download and attempt to install it in the same way as\n" +
		"chezmoi was previously installed.\n" +
		"\n" +
		"If chezmoi was installed with a package manager (`dpkg` or `rpm`) then `upgrade`\n" +
		"will download a new package and install it, using `sudo` if it is installed.\n" +
		"Otherwise, chezmoi will download the latest executable and replace the existing\n" +
		"executable with the new version.\n" +
		"\n" +
		"If the `CHEZMOI_GITHUB_API_TOKEN` environment variable is set, then its value\n" +
		"will be used to authenticate requests to the GitHub API, otherwise\n" +
		"unauthenticated requests are used which are subject to stricter [rate\n" +
		"limiting](https://developer.github.com/v3/#rate-limiting). Unauthenticated\n" +
		"requests should be sufficient for most cases.\n" +
		"\n" +
		"#### `upgrade` examples\n" +
		"\n" +
		"    chezmoi upgrade\n" +
		"\n" +
		"### `verify` [*targets*]\n" +
		"\n" +
		"Verify that all *targets* match their target state. chezmoi exits with code 0\n" +
		"(success) if all targets match their target state, or 1 (failure) otherwise. If\n" +
		"no targets are specified then all targets are checked.\n" +
		"\n" +
		"#### `-i`, `--include` *types*\n" +
		"\n" +
		"Only include entries of type *types*.\n" +
		"\n" +
		"#### `verify` examples\n" +
		"\n" +
		"    chezmoi verify\n" +
		"    chezmoi verify ~/.bashrc\n" +
		"\n" +
		"## Editor configuration\n" +
		"\n" +
		"The `edit` and `edit-config` commands use the editor specified by the `VISUAL`\n" +
		"environment variable, the `EDITOR` environment variable, or `vi`, whichever is\n" +
		"specified first.\n" +
		"\n" +
		"## Umask configuration\n" +
		"\n" +
		"By default, chezmoi uses your current umask as set by your operating system and\n" +
		"shell. chezmoi only stores crude permissions in its source state, namely in the\n" +
		"`executable`  and `private` attributes, corresponding to the umasks of `0o111`\n" +
		"and `0o077` respectively.\n" +
		"\n" +
		"For machine-specific control of umask, set the `umask` configuration variable in\n" +
		"chezmoi's configuration file, for example:\n" +
		"\n" +
		"    umask = 0o22\n" +
		"\n" +
		"## Template execution\n" +
		"\n" +
		"chezmoi executes templates using\n" +
		"[`text/template`](https://pkg.go.dev/text/template). The result is treated\n" +
		"differently depending on whether the target is a file or a symlink.\n" +
		"\n" +
		"If target is a file, then:\n" +
		"\n" +
		"* If the result is an empty string, then the file is removed.\n" +
		"* Otherwise, the target file contents are result.\n" +
		"\n" +
		"If the target is a symlink, then:\n" +
		"\n" +
		"* Leading and trailing whitespace are stripped from the result.\n" +
		"* If the result is an empty string, then the symlink is removed.\n" +
		"* Otherwise, the target symlink target is the result.\n" +
		"\n" +
		"chezmoi executes templates using `text/template`'s `missingkey=error` option,\n" +
		"which means that misspelled or missing keys will raise an error. This can be\n" +
		"overridden by setting a list of options in the configuration file, for example:\n" +
		"\n" +
		"    [template]\n" +
		"      options = [\"missingkey=zero\"]\n" +
		"\n" +
		"For a full list of options, see\n" +
		"[`Template.Option`](https://pkg.go.dev/text/template?tab=doc#Template.Option).\n" +
		"\n" +
		"## Template variables\n" +
		"\n" +
		"chezmoi provides the following automatically-populated variables:\n" +
		"\n" +
		"| Variable                | Value                                                                                                                           |\n" +
		"| ----------------------- | ------------------------------------------------------------------------------------------------------------------------------- |\n" +
		"| `.chezmoi.arch`         | Architecture, e.g. `amd64`, `arm`, etc. as returned by [runtime.GOARCH](https://pkg.go.dev/runtime?tab=doc#pkg-constants).      |\n" +
		"| `.chezmoi.fqdnHostname` | The fully-qualified domain name hostname of the machine chezmoi is running on.                                                  |\n" +
		"| `.chezmoi.group`        | The group of the user running chezmoi.                                                                                          |\n" +
		"| `.chezmoi.homeDir`      | The home directory of the user running chezmoi.                                                                                 |\n" +
		"| `.chezmoi.hostname`     | The hostname of the machine chezmoi is running on, up to the first `.`.                                                         |\n" +
		"| `.chezmoi.kernel`       | Contains information from `/proc/sys/kernel`. Linux only, useful for detecting specific kernels (i.e. Microsoft's WSL kernel).  |\n" +
		"| `.chezmoi.os`           | Operating system, e.g. `darwin`, `linux`, etc. as returned by [runtime.GOOS](https://pkg.go.dev/runtime?tab=doc#pkg-constants). |\n" +
		"| `.chezmoi.osRelease`    | The information from `/etc/os-release`, Linux only, run `chezmoi data` to see its output.                                       |\n" +
		"| `.chezmoi.sourceDir`    | The source directory.                                                                                                           |\n" +
		"| `.chezmoi.username`     | The username of the user running chezmoi.                                                                                       |\n" +
		"| `.chezmoi.version`      | The version of chezmoi.                                                                                                         |\n" +
		"\n" +
		"Additional variables can be defined in the config file in the `data` section.\n" +
		"Variable names must consist of a letter and be followed by zero or more letters\n" +
		"and/or digits.\n" +
		"\n" +
		"## Template functions\n" +
		"\n" +
		"All standard [`text/template`](https://pkg.go.dev/text/template) and [text\n" +
		"template functions from `sprig`](http://masterminds.github.io/sprig/) are\n" +
		"included. chezmoi provides some additional functions.\n" +
		"\n" +
		"### `bitwarden` [*args*]\n" +
		"\n" +
		"`bitwarden` returns structured data retrieved from\n" +
		"[Bitwarden](https://bitwarden.com) using the [Bitwarden\n" +
		"CLI](https://github.com/bitwarden/cli) (`bw`). *args* are passed to `bw get`\n" +
		"unchanged and the output from `bw get` is parsed as JSON. The output from `bw\n" +
		"get` is cached so calling `bitwarden` multiple times with the same arguments\n" +
		"will only invoke `bw` once.\n" +
		"\n" +
		"#### `bitwarden` examples\n" +
		"\n" +
		"    username = {{ (bitwarden \"item\" \"<itemid>\").login.username }}\n" +
		"    password = {{ (bitwarden \"item\" \"<itemid>\").login.password }}\n" +
		"\n" +
		"### `bitwardenAttachment` *filename* *itemid*\n" +
		"\n" +
		"`bitwardenAttachment` returns a document from\n" +
		"[Bitwarden](https://bitwarden.com/) using the [Bitwarden\n" +
		"CLI](https://bitwarden.com/help/article/cli/) (`bw`). *filename* and *itemid* is\n" +
		"passed to `bw get attachment <filename> --itemid <itemid>` and the output from\n" +
		"`bw` is returned. The output from `bw` is cached so calling\n" +
		"`bitwardenAttachment` multiple times with the same *filename* and *itemid* will\n" +
		"only invoke `bw` once.\n" +
		"\n" +
		"#### `bitwardenAttachment` examples\n" +
		"\n" +
		"    {{- (bitwardenAttachment \"<filename>\" \"<itemid>\") -}}\n" +
		"\n" +
		"### `bitwardenFields` [*args*]\n" +
		"\n" +
		"`bitwardenFields` returns structured data retrieved from\n" +
		"[Bitwarden](https://bitwarden.com) using the [Bitwarden\n" +
		"CLI](https://github.com/bitwarden/cli) (`bw`). *args* are passed to `bw get`\n" +
		"unchanged, the output from `bw get` is parsed as JSON, and elements of `fields`\n" +
		"are returned as a map indexed by each field's `name`. For example, given the\n" +
		"output from `bw get`:\n" +
		"\n" +
		"```json\n" +
		"{\n" +
		"  \"object\": \"item\",\n" +
		"  \"id\": \"bf22e4b4-ae4a-4d1c-8c98-ac620004b628\",\n" +
		"  \"organizationId\": null,\n" +
		"  \"folderId\": null,\n" +
		"  \"type\": 1,\n" +
		"  \"name\": \"example.com\",\n" +
		"  \"notes\": null,\n" +
		"  \"favorite\": false,\n" +
		"  \"fields\": [\n" +
		"    {\n" +
		"      \"name\": \"text\",\n" +
		"      \"value\": \"text-value\",\n" +
		"      \"type\": 0\n" +
		"    },\n" +
		"    {\n" +
		"      \"name\": \"hidden\",\n" +
		"      \"value\": \"hidden-value\",\n" +
		"      \"type\": 1\n" +
		"    }\n" +
		"  ],\n" +
		"  \"login\": {\n" +
		"    \"username\": \"username-value\",\n" +
		"    \"password\": \"password-value\",\n" +
		"    \"totp\": null,\n" +
		"    \"passwordRevisionDate\": null\n" +
		"  },\n" +
		"  \"collectionIds\": [],\n" +
		"  \"revisionDate\": \"2020-10-28T00:21:02.690Z\"\n" +
		"}\n" +
		"```\n" +
		"\n" +
		"the return value will be the map\n" +
		"\n" +
		"```json\n" +
		"{\n" +
		"  \"hidden\": {\n" +
		"    \"name\": \"hidden\",\n" +
		"    \"type\": 1,\n" +
		"    \"value\": \"hidden-value\"\n" +
		"  },\n" +
		"  \"token\": {\n" +
		"    \"name\": \"token\",\n" +
		"    \"type\": 0,\n" +
		"    \"value\": \"token-value\"\n" +
		"  }\n" +
		"}\n" +
		"```\n" +
		"\n" +
		"The output from `bw get` is cached so calling `bitwarden` multiple times with\n" +
		"the same arguments will only invoke `bw get` once.\n" +
		"\n" +
		"#### `bitwardenFields` examples\n" +
		"\n" +
		"    {{ (bitwardenFields \"item\" \"<itemid>\").token.value }}\n" +
		"\n" +
		"### `gitHubKeys` *user*\n" +
		"\n" +
		"`gitHubKeys` returns *user*'s public SSH keys from GitHub using the GitHub API.\n" +
		"If any of the environment variables `CHEZMOI_GITHUB_ACCESS_TOKEN`,\n" +
		"`GITHUB_ACCESS_TOKEN`, or `GITHUB_TOKEN` are found, then the first one found\n" +
		"will be used to authenticate the API request, otherwise an anonymous API request\n" +
		"will be used, which may be subject to lower rate limits.\n" +
		"\n" +
		"#### `gitHubKeys` examples\n" +
		"\n" +
		"    {{ range (gitHubKeys \"user\") }}\n" +
		"    {{- .Key }}\n" +
		"    {{- end }}\n" +
		"\n" +
		"### `gopass` *gopass-name*\n" +
		"\n" +
		"`gopass` returns passwords stored in [gopass](https://www.gopass.pw/) using the\n" +
		"gopass CLI (`gopass`). *gopass-name* is passed to `gopass show <gopass-name>`\n" +
		"and first line of the output of `gopass` is returned with the trailing newline\n" +
		"stripped. The output from `gopass` is cached so calling `gopass` multiple times\n" +
		"with the same *gopass-name* will only invoke `gopass` once.\n" +
		"\n" +
		"#### `gopass` examples\n" +
		"\n" +
		"    {{ gopass \"<pass-name>\" }}\n" +
		"\n" +
		"### `include` *filename*\n" +
		"\n" +
		"`include` returns the literal contents of the file named `*filename*`, relative\n" +
		"to the source directory.\n" +
		"\n" +
		"### `ioreg`\n" +
		"\n" +
		"On macOS, `ioreg` returns the structured output of the `ioreg -a -l` command,\n" +
		"which includes detailed information about the I/O Kit registry.\n" +
		"\n" +
		"On non-macOS operating systems, `ioreg` returns `nil`.\n" +
		"\n" +
		"The output from `ioreg` is cached so multiple calls to the `ioreg` function will\n" +
		"only execute the `ioreg -a -l` command once.\n" +
		"\n" +
		"#### `ioreg` examples\n" +
		"\n" +
		"    {{ if (eq .chezmoi.os \"darwin\") }}\n" +
		"    {{ $serialNumber := index ioreg \"IORegistryEntryChildren\" 0 \"IOPlatformSerialNumber\" }}\n" +
		"    {{ end }}\n" +
		"\n" +
		"### `joinPath` *elements*\n" +
		"\n" +
		"`joinPath` joins any number of path elements into a single path, separating them\n" +
		"with the OS-specific path separator. Empty elements are ignored. The result is\n" +
		"cleaned. If the argument list is empty or all its elements are empty, `joinPath`\n" +
		"returns an empty string. On Windows, the result will only be a UNC path if the\n" +
		"first non-empty element is a UNC path.\n" +
		"\n" +
		"#### `joinPath` examples\n" +
		"\n" +
		"    {{ joinPath .chezmoi.homeDir \".zshrc\" }}\n" +
		"\n" +
		"### `keepassxc` *entry*\n" +
		"\n" +
		"`keepassxc` returns structured data retrieved from a\n" +
		"[KeePassXC](https://keepassxc.org/) database using the KeePassXC CLI\n" +
		"(`keepassxc-cli`). The database is configured by setting `keepassxc.database` in\n" +
		"the configuration file. *database* and *entry* are passed to `keepassxc-cli\n" +
		"show`. You will be prompted for the database password the first time\n" +
		"`keepassxc-cli` is run, and the password is cached, in plain text, in memory\n" +
		"until chezmoi terminates. The output from `keepassxc-cli` is parsed into\n" +
		"key-value pairs and cached so calling `keepassxc` multiple times with the same\n" +
		"*entry* will only invoke `keepassxc-cli` once.\n" +
		"\n" +
		"#### `keepassxc` examples\n" +
		"\n" +
		"    username = {{ (keepassxc \"example.com\").UserName }}\n" +
		"    password = {{ (keepassxc \"example.com\").Password }}\n" +
		"\n" +
		"### `keepassxcAttribute` *entry* *attribute*\n" +
		"\n" +
		"`keepassxcAttribute` returns the attribute *attribute* of *entry* using\n" +
		"`keepassxc-cli`, with any leading or trailing whitespace removed. It behaves\n" +
		"identically to the `keepassxc` function in terms of configuration, password\n" +
		"prompting, password storage, and result caching.\n" +
		"\n" +
		"#### `keepassxcAttribute` examples\n" +
		"\n" +
		"    {{ keepassxcAttribute \"SSH Key\" \"private-key\" }}\n" +
		"\n" +
		"### `keyring` *service* *user*\n" +
		"\n" +
		"`keyring` retrieves the value associated with *service* and *user* from the\n" +
		"user's keyring.\n" +
		"\n" +
		"| OS      | Keyring                     |\n" +
		"| ------- | --------------------------- |\n" +
		"| macOS   | Keychain                    |\n" +
		"| Linux   | GNOME Keyring               |\n" +
		"| Windows | Windows Credentials Manager |\n" +
		"\n" +
		"#### `keyring` examples\n" +
		"\n" +
		"    [github]\n" +
		"      user = \"{{ .github.user }}\"\n" +
		"      token = \"{{ keyring \"github\" .github.user }}\"\n" +
		"\n" +
		"### `lastpass` *id*\n" +
		"\n" +
		"`lastpass` returns structured data from [LastPass](https://lastpass.com) using\n" +
		"the [LastPass CLI](https://lastpass.github.io/lastpass-cli/lpass.1.html)\n" +
		"(`lpass`). *id* is passed to `lpass show --json <id>` and the output from\n" +
		"`lpass` is parsed as JSON. In addition, the `note` field, if present, is further\n" +
		"parsed as colon-separated key-value pairs. The structured data is an array so\n" +
		"typically the `index` function is used to extract the first item. The output\n" +
		"from `lastpass` is cached so calling `lastpass` multiple times with the same\n" +
		"*id* will only invoke `lpass` once.\n" +
		"\n" +
		"#### `lastpass` examples\n" +
		"\n" +
		"    githubPassword = \"{{ (index (lastpass \"GitHub\") 0).password }}\"\n" +
		"    {{ (index (lastpass \"SSH\") 0).note.privateKey }}\n" +
		"\n" +
		"### `lastpassRaw` *id*\n" +
		"\n" +
		"`lastpassRaw` returns structured data from [LastPass](https://lastpass.com)\n" +
		"using the [LastPass CLI](https://lastpass.github.io/lastpass-cli/lpass.1.html)\n" +
		"(`lpass`). It behaves identically to the `lastpass` function, except that no\n" +
		"further parsing is done on the `note` field.\n" +
		"\n" +
		"#### `lastpassRaw` examples\n" +
		"\n" +
		"    {{ (index (lastpassRaw \"SSH Private Key\") 0).note }}\n" +
		"\n" +
		"### `lookPath` *file*\n" +
		"\n" +
		"`lookPath` searches for an executable named *file* in the directories named by\n" +
		"the `PATH` environment variable. If file contains a slash, it is tried directly\n" +
		"and the `PATH` is not consulted. The result may be an absolute path or a path\n" +
		"relative to the current directory. If *file* is not found, `lookPath` returns an\n" +
		"empty string.\n" +
		"\n" +
		"`lookPath` is not hermetic: its return value depends on the state of the\n" +
		"environment and the filesystem at the moment the template is executed. Exercise\n" +
		"caution when using it in your templates.\n" +
		"\n" +
		"#### `lookPath` examples\n" +
		"\n" +
		"    {{ if lookPath \"diff-so-fancy\" }}\n" +
		"    # diff-so-fancy is in $PATH\n" +
		"    {{ end }}\n" +
		"\n" +
		"### `onepassword` *uuid* [*vault-uuid*]\n" +
		"\n" +
		"`onepassword` returns structured data from [1Password](https://1password.com/)\n" +
		"using the [1Password\n" +
		"CLI](https://support.1password.com/command-line-getting-started/) (`op`). *uuid*\n" +
		"is passed to `op get item <uuid>` and the output from `op` is parsed as JSON.\n" +
		"The output from `op` is cached so calling `onepassword` multiple times with the\n" +
		"same *uuid* will only invoke `op` once.  If the optional *vault-uuid* is supplied,\n" +
		"it will be passed along to the `op get` call, which can significantly improve\n" +
		"performance.\n" +
		"\n" +
		"#### `onepassword` examples\n" +
		"\n" +
		"    {{ (onepassword \"<uuid>\").details.password }}\n" +
		"    {{ (onepassword \"<uuid>\" \"<vault-uuid>\").details.password }}\n" +
		"\n" +
		"### `onepasswordDocument` *uuid* [*vault-uuid*]\n" +
		"\n" +
		"`onepassword` returns a document from [1Password](https://1password.com/)\n" +
		"using the [1Password\n" +
		"CLI](https://support.1password.com/command-line-getting-started/) (`op`). *uuid*\n" +
		"is passed to `op get document <uuid>` and the output from `op` is returned.\n" +
		"The output from `op` is cached so calling `onepasswordDocument` multiple times with the\n" +
		"same *uuid* will only invoke `op` once.  If the optional *vault-uuid* is supplied,\n" +
		"it will be passed along to the `op get` call, which can significantly improve\n" +
		"performance.\n" +
		"\n" +
		"#### `onepasswordDocument` examples\n" +
		"\n" +
		"    {{- onepasswordDocument \"<uuid>\" -}}\n" +
		"    {{- onepasswordDocument \"<uuid>\" \"<vault-uuid>\" -}}\n" +
		"\n" +
		"### `onepasswordDetailsFields` *uuid* [*vault-uuid*]\n" +
		"\n" +
		"`onepasswordDetailsFields` returns structured data from\n" +
		"[1Password](https://1password.com/) using the [1Password\n" +
		"CLI](https://support.1password.com/command-line-getting-started/) (`op`). *uuid*\n" +
		"is passed to `op get item <uuid>`, the output from `op` is parsed as JSON, and\n" +
		"elements of `details.fields` are returned as a map indexed by each field's\n" +
		"`designation`. For example, give the output from `op`:\n" +
		"\n" +
		"```json\n" +
		"{\n" +
		"  \"uuid\": \"<uuid>\",\n" +
		"  \"details\": {\n" +
		"    \"fields\": [\n" +
		"      {\n" +
		"        \"designation\": \"username\",\n" +
		"        \"name\": \"username\",\n" +
		"        \"type\": \"T\",\n" +
		"        \"value\": \"exampleuser\"\n" +
		"      },\n" +
		"      {\n" +
		"        \"designation\": \"password\",\n" +
		"        \"name\": \"password\",\n" +
		"        \"type\": \"P\",\n" +
		"        \"value\": \"examplepassword\"\n" +
		"      }\n" +
		"    ],\n" +
		"  }\n" +
		"}\n" +
		"```\n" +
		"\n" +
		"the return value will be the map:\n" +
		"\n" +
		"```json\n" +
		"{\n" +
		"  \"username\": {\n" +
		"    \"designation\": \"username\",\n" +
		"    \"name\": \"username\",\n" +
		"    \"type\": \"T\",\n" +
		"    \"value\": \"exampleuser\"\n" +
		"  },\n" +
		"  \"password\": {\n" +
		"    \"designation\": \"password\",\n" +
		"    \"name\": \"password\",\n" +
		"    \"type\": \"P\",\n" +
		"    \"value\": \"examplepassword\"\n" +
		"  }\n" +
		"}\n" +
		"```\n" +
		"\n" +
		"The output from `op` is cached so calling `onepassword` multiple times with the\n" +
		"same *uuid* will only invoke `op` once.  If the optional *vault-uuid* is supplied,\n" +
		"it will be passed along to the `op get` call, which can significantly improve\n" +
		"performance.\n" +
		"\n" +
		"#### `onepasswordDetailsFields` examples\n" +
		"\n" +
		"    {{ (onepasswordDetailsFields \"<uuid>\").password.value }}\n" +
		"\n" +
		"### `pass` *pass-name*\n" +
		"\n" +
		"`pass` returns passwords stored in [pass](https://www.passwordstore.org/) using\n" +
		"the pass CLI (`pass`). *pass-name* is passed to `pass show <pass-name>` and\n" +
		"first line of the output of `pass` is returned with the trailing newline\n" +
		"stripped. The output from `pass` is cached so calling `pass` multiple times with\n" +
		"the same *pass-name* will only invoke `pass` once.\n" +
		"\n" +
		"#### `pass` examples\n" +
		"\n" +
		"    {{ pass \"<pass-name>\" }}\n" +
		"\n" +
		"### `promptBool` *prompt*\n" +
		"\n" +
		"`promptBool` prompts the user with *prompt* and returns the user's response with\n" +
		"interpreted as a boolean. It is only available when generating the initial\n" +
		"config file. The user's response is interpreted as follows (case insensitive):\n" +
		"\n" +
		"| Response                | Result  |\n" +
		"| ----------------------- | ------- |\n" +
		"| 1, on, t, true, y, yes  | `true`  |\n" +
		"| 0, off, f, false, n, no | `false` |\n" +
		"\n" +
		"### `promptInt` *prompt*\n" +
		"\n" +
		"`promptInt` prompts the user with *prompt* and returns the user's response with\n" +
		"interpreted as an integer. It is only available when generating the initial\n" +
		"config file.\n" +
		"\n" +
		"### `promptString` *prompt*\n" +
		"\n" +
		"`promptString` prompts the user with *prompt* and returns the user's response\n" +
		"with all leading and trailing spaces stripped. It is only available when\n" +
		"generating the initial config file.\n" +
		"\n" +
		"#### `promptString` examples\n" +
		"\n" +
		"    {{ $email := promptString \"email\" -}}\n" +
		"    [data]\n" +
		"        email = \"{{ $email }}\"\n" +
		"\n" +
		"### `secret` [*args*]\n" +
		"\n" +
		"`secret` returns the output of the generic secret command defined by the\n" +
		"`secret.command` configuration variable with *args* with leading and trailing\n" +
		"whitespace removed. The output is cached so multiple calls to `secret` with the\n" +
		"same *args* will only invoke the generic secret command once.\n" +
		"\n" +
		"### `secretJSON` [*args*]\n" +
		"\n" +
		"`secretJSON` returns structured data from the generic secret command defined by\n" +
		"the `secret.command` configuration variable with *args*. The output is parsed as\n" +
		"JSON. The output is cached so multiple calls to `secret` with the same *args*\n" +
		"will only invoke the generic secret command once.\n" +
		"\n" +
		"### `stat` *name*\n" +
		"\n" +
		"`stat` runs `stat(2)` on *name*. If *name* exists it returns structured data. If\n" +
		"*name* does not exist then it returns a false value. If `stat(2)` returns any\n" +
		"other error then it raises an error. The structured value returned if *name*\n" +
		"exists contains the fields `name`, `size`, `mode`, `perm`, `modTime`, and\n" +
		"`isDir`.\n" +
		"\n" +
		"`stat` is not hermetic: its return value depends on the state of the filesystem\n" +
		"at the moment the template is executed. Exercise caution when using it in your\n" +
		"templates.\n" +
		"\n" +
		"#### `stat` examples\n" +
		"\n" +
		"    {{ if stat (joinPath .chezmoi.homeDir \".pyenv\") }}\n" +
		"    # ~/.pyenv exists\n" +
		"    {{ end }}\n" +
		"\n" +
		"### `vault` *key*\n" +
		"\n" +
		"`vault` returns structured data from [Vault](https://www.vaultproject.io/) using\n" +
		"the [Vault CLI](https://www.vaultproject.io/docs/commands/) (`vault`). *key* is\n" +
		"passed to `vault kv get -format=json <key>` and the output from `vault` is\n" +
		"parsed as JSON. The output from `vault` is cached so calling `vault` multiple\n" +
		"times with the same *key* will only invoke `vault` once.\n" +
		"\n" +
		"#### `vault` examples\n" +
		"\n" +
		"    {{ (vault \"<key>\").data.data.password }}\n" +
		"\n")
}
