// Code generated by github.com/twpayne/chezmoi/internal/cmd/generate-helps. DO NOT EDIT.

package cmd

type help struct {
	long    string
	example string
}

var helps = map[string]help{
	"--follow": {
		long: "" +
			"Description:\n" +
			"  If the last part of a target is a symlink, add the target of the symlink\n" +
			"  instead of the symlink itself.\n" +
			"\n" +
			"  `-x`, `--exact`\n" +
			"\n" +
			"  Set the `exact` attribute on added directories.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only add entries of type *types*.\n" +
			"\n" +
			"  `-p`, `--prompt`\n" +
			"\n" +
			"  Interactively prompt before adding each file.\n" +
			"\n" +
			"  `-r`, `--recursive`\n" +
			"\n" +
			"  Recursively add all files, directories, and symlinks.\n" +
			"\n" +
			"  `-T`, `--template`\n" +
			"\n" +
			"  Set the `template` attribute on added files and symlinks.",
		example: "" +
			"  chezmoi add ~/.bashrc\n" +
			"  chezmoi add ~/.gitconfig --template\n" +
			"  chezmoi add ~/.vim --recursive\n" +
			"  chezmoi add ~/.oh-my-zsh --exact --recursive",
	},
	"add": {
		long: "" +
			"Description:\n" +
			"  Add *targets* to the source state. If any target is already in the source\n" +
			"  state, then its source state is replaced with its current state in the\n" +
			"  destination directory. The `add` command accepts additional flags:\n" +
			"\n" +
			"  `--autotemplate`\n" +
			"\n" +
			"  Automatically generate a template by replacing strings with variable names\n" +
			"  from the `data` section of the config file. Longer substitutions occur\n" +
			"  before shorter ones. This implies the `--template` option.\n" +
			"\n" +
			"  `-e`, `--empty`\n" +
			"\n" +
			"  Set the `empty` attribute on added files.\n" +
			"\n" +
			"  `-f`, `--force`\n" +
			"\n" +
			"  Add *targets*, even if doing so would cause a source template to be\n" +
			"  overwritten.",
	},
	"apply": {
		long: "" +
			"Description:\n" +
			"  Ensure that *targets* are in the target state, updating them if necessary.\n" +
			"  If no targets are specified, the state of all targets are ensured. If a\n" +
			"  target has been modified since chezmoi last wrote it then the user will be\n" +
			"  prompted if they want to overwrite the file.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only add entries of type *types*.\n" +
			"\n" +
			"  `--source-path`\n" +
			"\n" +
			"  Specify targets by source path, rather than target path. This is useful for\n" +
			"  applying changes after editing.",
		example: "" +
			"  chezmoi apply\n" +
			"  chezmoi apply --dry-run --verbose\n" +
			"  chezmoi apply ~/.bashrc\n" +
			"\n" +
			"In `~/.vimrc`:\n" +
			"\n" +
			"  autocmd BufWritePost ~/.local/share/chezmoi/* ! chezmoi apply --source-path %",
	},
	"archive": {
		long: "" +
			"Description:\n" +
			"  Generate a tar archive of the target state. This can be piped into `tar` to\n" +
			"  inspect the target state.\n" +
			"\n" +
			"  `--format` *format*\n" +
			"\n" +
			"  Write the archive in *format*. *format* can be either `tar` (the default) or\n" +
			"  `zip`.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only include entries of type *types*.\n" +
			"\n" +
			"  `-z`, `--gzip`\n" +
			"\n" +
			"  Compress the output with gzip.",
		example: "" +
			"  chezmoi archive | tar tvf -\n" +
			"  chezmoi archive --output=dotfiles.tar\n" +
			"  chezmoi archive --format=zip --output=dotfiles.zip",
	},
	"cat": {
		long: "" +
			"Description:\n" +
			"  Write the target state of *targets*  to stdout. *targets* must be files or\n" +
			"  symlinks. For files, the target file contents are written. For symlinks, the\n" +
			"  target target is written.",
		example: "" +
			"  chezmoi cat ~/.bashrc",
	},
	"cd": {
		long: "" +
			"Description:\n" +
			"  Launch a shell in the source directory. chezmoi will launch the command set\n" +
			"  by the `cd.command` configuration variable with any extra arguments\n" +
			"  specified by `cd.args`. If this is not set, chezmoi will attempt to detect\n" +
			"  your shell and will finally fall back to an OS-specific default.",
		example: "" +
			"  chezmoi cd",
	},
	"chattr": {
		long: "" +
			"Description:\n" +
			"  Change the attributes of *targets*. *attributes* specifies which attributes\n" +
			"  to modify. Add attributes by specifying them or their abbreviations\n" +
			"  directly, optionally prefixed with a plus sign (`+`). Remove attributes by\n" +
			"  prefixing them or their attributes with the string `no` or a minus sign (`-\n" +
			"  `). The available attributes and their abbreviations are:\n" +
			"\n" +
			"    ATTRIBUTE  | ABBREVIATION\n" +
			"  -------------+---------------\n" +
			"    empty      | e\n" +
			"    encrypted  | none\n" +
			"    exact      | none\n" +
			"    executable | x\n" +
			"    private    | p\n" +
			"    template   | t\n" +
			"\n" +
			"  Multiple attributes modifications may be specified by separating them with a\n" +
			"  comma (`,`).",
		example: "" +
			"  chezmoi chattr template ~/.bashrc\n" +
			"  chezmoi chattr noempty ~/.profile\n" +
			"  chezmoi chattr private,template ~/.netrc",
	},
	"completion": {
		long: "" +
			"Description:\n" +
			"  Generate shell completion code for the specified shell (`bash`, `fish`,\n" +
			"  `powershell`, or `zsh`).",
		example: "" +
			"  chezmoi completion bash\n" +
			"  chezmoi completion fish --output=~/.config/fish/completions/chezmoi.fish",
	},
	"data": {
		long: "" +
			"Description:\n" +
			"  Write the computed template data to stdout.",
		example: "" +
			"  chezmoi data\n" +
			"  chezmoi data --format=yaml",
	},
	"diff": {
		long: "" +
			"Description:\n" +
			"  Print the difference between the target state and the destination state for\n" +
			"  *targets*. If no targets are specified, print the differences for all\n" +
			"  targets.\n" +
			"\n" +
			"  If a `diff.pager` command is set in the configuration file then the output\n" +
			"  will be piped into it.",
		example: "" +
			"  chezmoi diff\n" +
			"  chezmoi diff ~/.bashrc",
	},
	"docs": {
		long: "" +
			"Description:\n" +
			"  Print the documentation page matching the regular expression *regexp*.\n" +
			"  Matching is case insensitive. If no pattern is given, print `REFERENCE.md`.",
		example: "" +
			"  chezmoi docs\n" +
			"  chezmoi docs faq\n" +
			"  chezmoi docs howto",
	},
	"doctor": {
		long: "" +
			"Description:\n" +
			"  Check for potential problems.",
		example: "" +
			"  chezmoi doctor",
	},
	"dump": {
		long: "" +
			"Description:\n" +
			"  Dump the target state. If no targets are specified, then the entire target\n" +
			"  state.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only include entries of type *types*.",
		example: "" +
			"  chezmoi dump ~/.bashrc\n" +
			"  chezmoi dump --format=yaml",
	},
	"edit": {
		long: "" +
			"Description:\n" +
			"  Edit the source state of *targets*, which must be files or symlinks. If no\n" +
			"  targets are given the the source directory itself is opened with `$EDITOR`.\n" +
			"  The `edit` command accepts additional arguments:\n" +
			"\n" +
			"  `-a`, `--apply`\n" +
			"\n" +
			"  Apply target immediately after editing. Ignored if there are no targets.",
		example: "" +
			"  chezmoi edit ~/.bashrc\n" +
			"  chezmoi edit ~/.bashrc --apply\n" +
			"  chezmoi edit",
	},
	"edit-config": {
		long: "" +
			"Description:\n" +
			"  Edit the configuration file.\n" +
			"\n" +
			"  `edit-config` examples\n" +
			"\n" +
			"    chezmoi edit-config",
	},
	"execute-template": {
		long: "" +
			"Description:\n" +
			"  Execute *templates*. This is useful for testing templates or for calling\n" +
			"  chezmoi from other scripts. *templates* are interpreted as literal\n" +
			"  templates, with no whitespace added to the output between arguments. If no\n" +
			"  templates are specified, the template is read from stdin.\n" +
			"\n" +
			"  `--init`, `-i`\n" +
			"\n" +
			"  Include simulated functions only available during `chezmoi init`.\n" +
			"\n" +
			"  `--promptBool` *pairs*\n" +
			"\n" +
			"  Simulate the `promptBool` function with a function that returns values from\n" +
			"  *pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs. If\n" +
			"  `promptBool` is called with a *prompt* that does not match any of *pairs*,\n" +
			"  then it returns false.\n" +
			"\n" +
			"  `--promptInt`, `-p` *pairs*\n" +
			"\n" +
			"  Simulate the `promptInt` function with a function that returns values from\n" +
			"  *pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs. If\n" +
			"  `promptInt` is called with a *prompt* that does not match any of *pairs*,\n" +
			"  then it returns zero.\n" +
			"\n" +
			"  `--promptString`, `-p` *pairs*\n" +
			"\n" +
			"  Simulate the `promptString` function with a function that returns values\n" +
			"  from *pairs*. *pairs* is a comma-separated list of *prompt*`=`*value* pairs.\n" +
			"  If `promptString` is called with a *prompt* that does not match any of\n" +
			"  *pairs*, then it returns *prompt* unchanged.\n" +
			"\n" +
			"  `execute-template` examples\n" +
			"\n" +
			"    chezmoi execute-template '{{ .chezmoi.sourceDir }}'\n" +
			"    chezmoi execute-template '{{ .chezmoi.os }}' / '{{ .chezmoi.arch }}'\n" +
			"    echo '{{ .chezmoi | toJson }}' | chezmoi execute-template\n" +
			"    chezmoi execute-template --init --promptString email=john@home.org <\n" +
			"  ~/.local/share/chezmoi/.chezmoi.toml.tmpl",
	},
	"forget": {
		long: "" +
			"Description:\n" +
			"  Remove *targets* from the source state, i.e. stop managing them.",
		example: "" +
			"  chezmoi forget ~/.bashrc",
	},
	"git": {
		long: "" +
			"Description:\n" +
			"  Run `git` *arguments* in the source directory. Note that flags in\n" +
			"  *arguments* must occur after `--` to prevent chezmoi from interpreting them.",
		example: "" +
			"  chezmoi git add .\n" +
			"  chezmoi git add dot_gitconfig\n" +
			"  chezmoi git -- commit -m \"Add .gitconfig\"",
	},
	"help": {
		long: "" +
			"Description:\n" +
			"  Print the help associated with *command*.",
	},
	"import": {
		long: "" +
			"Description:\n" +
			"  Import the source state from an archive file in to a directory in the source\n" +
			"  state. This is primarily used to make subdirectories of your home directory\n" +
			"  exactly match the contents of a downloaded archive. You will generally\n" +
			"  always want to set the `--destination`, `--exact`, and `--remove-destination`\n" +
			"  flags.\n" +
			"\n" +
			"  The only supported archive format is `.tar.gz`.\n" +
			"\n" +
			"  `--destination` *directory*\n" +
			"\n" +
			"  Set the destination (in the source state) where the archive will be\n" +
			"  imported.\n" +
			"\n" +
			"  `-x`, `--exact`\n" +
			"\n" +
			"  Set the `exact` attribute on all imported directories.\n" +
			"\n" +
			"  `-r`, `--remove-destination`\n" +
			"\n" +
			"  Remove destination (in the source state) before importing.\n" +
			"\n" +
			"  `--strip-components` *n*\n" +
			"\n" +
			"  Strip *n* leading components from paths.",
		example: "" +
			"  curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-\n" +
			"zsh/archive/master.tar.gz\n" +
			"  chezmoi import --strip-components 1 --destination ~/.oh-my-zsh oh-my-zsh-master.tar.gz",
	},
	"init": {
		long: "" +
			"Description:\n" +
			"  Setup the source directory and update the destination directory to match the\n" +
			"  target state. *repo* is expanded to a full git repo URL using the following\n" +
			"  rules:\n" +
			"\n" +
			"        PATTERN      |                 REPO\n" +
			"  -------------------+---------------------------------------\n" +
			"    user             | https://github.com/user/dotfiles.git\n" +
			"    user/repo        | https://github.com/user/repo.git\n" +
			"    site/user/repo   | https://site/user/repo.git\n" +
			"    ~sr.ht/user      | https://git.sr.ht/~user/dotfiles\n" +
			"    ~sr.ht/user/repo | https://git.sr.ht/~user/repo\n" +
			"\n" +
			"  First, if the source directory is not already contain a repository, then if\n" +
			"  *repo* is given it is checked out into the source directory, otherwise a new\n" +
			"  repository is initialized in the source directory.\n" +
			"\n" +
			"  Second, if a file called `.chezmoi.<format>.tmpl` exists, where `<format>`\n" +
			"  is one of the supported file formats (e.g. `json`, `toml`, or `yaml`) then a\n" +
			"  new configuration file is created using that file as a template.\n" +
			"\n" +
			"  Then, if the `--apply` flag is passed, `chezmoi apply` is run.\n" +
			"\n" +
			"  Then, if the `--purge` flag is passed, chezmoi will remove the source\n" +
			"  directory and its config directory.\n" +
			"\n" +
			"  Finally, if the `--purge-binary` is passed, chezmoi will attempt to remove its\n" +
			"  own binary.\n" +
			"\n" +
			"  `--apply`\n" +
			"\n" +
			"  Run `chezmoi apply` after checking out the repo and creating the config\n" +
			"  file.\n" +
			"\n" +
			"  `--depth` *depth*\n" +
			"\n" +
			"  Clone the repo with depth *depth*.\n" +
			"\n" +
			"  `--one-shot`\n" +
			"\n" +
			"  `--one-shot` is the equivalent of `--apply`, `--depth=1`, `--purge`, `--purge-binary`.\n" +
			"  It attempts to install your dotfiles with chezmoi and then remove all traces\n" +
			"  of chezmoi from the system. This is useful for setting up temporary\n" +
			"  environments (e.g. Docker containers).\n" +
			"\n" +
			"  `--purge`\n" +
			"\n" +
			"  Remove the source and config directories after applying.\n" +
			"\n" +
			"  `--purge-binary`\n" +
			"\n" +
			"  Attempt to remove the chezmoi binary after applying.\n" +
			"\n" +
			"  `--skip-encrypted`\n" +
			"\n" +
			"  Skip encrypted files. This is useful for setting up machines with an inital\n" +
			"  set of dotfiles before private decryption keys are available.",
		example: "" +
			"  chezmoi init user\n" +
			"  chezmoi init user --apply\n" +
			"  chezmoi init user --apply --purge\n" +
			"  chezmoi init user/dots\n" +
			"  chezmoi init gitlab.com/user",
	},
	"manage": {
		long: "" +
			"Description:\n" +
			"  `manage` is an alias for `add` for symmetry with `unmanage`.",
	},
	"managed": {
		long: "" +
			"Description:\n" +
			"  List all managed entries in the destination directory in alphabetical order.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only include entries of type *types*.",
		example: "" +
			"  chezmoi managed\n" +
			"  chezmoi managed --include=files\n" +
			"  chezmoi managed --include=files,symlinks\n" +
			"  chezmoi managed -i d\n" +
			"  chezmoi managed -i d,f",
	},
	"merge": {
		long: "" +
			"Description:\n" +
			"  Perform a three-way merge between the destination state, the target state,\n" +
			"  and the source state. The merge tool is defined by the `merge.command`\n" +
			"  configuration variable, and defaults to `vimdiff`. If multiple targets are\n" +
			"  specified the merge tool is invoked for each target. If the target state\n" +
			"  cannot be computed (for example if source is a template containing errors or\n" +
			"  an encrypted file that cannot be decrypted) a two-way merge is performed\n" +
			"  instead.",
		example: "" +
			"  chezmoi merge ~/.bashrc",
	},
	"purge": {
		long: "" +
			"Description:\n" +
			"  Remove chezmoi's configuration, state, and source directory, but leave the\n" +
			"  target state intact.\n" +
			"\n" +
			"  `-f`, `--force`\n" +
			"\n" +
			"  Remove without prompting.",
		example: "" +
			"  chezmoi purge\n" +
			"  chezmoi purge --force",
	},
	"remove": {
		long: "" +
			"Description:\n" +
			"  Remove *targets* from both the source state and the destination directory.\n" +
			"\n" +
			"  `-f`, `--force`\n" +
			"\n" +
			"  Remove without prompting.",
	},
	"rm": {
		long: "" +
			"Description:\n" +
			"  `rm` is an alias for `remove`.",
	},
	"secret": {
		long: "" +
			"Description:\n" +
			"  Run a secret manager's CLI, passing any extra arguments to the secret\n" +
			"  manager's CLI. This is primarily for verifying chezmoi's integration with\n" +
			"  your secret manager. Normally you would use template functions to retrieve\n" +
			"  secrets. Note that if you want to pass flags to the secret manager's CLI you\n" +
			"  will need to separate them with `--` to prevent chezmoi from interpreting\n" +
			"  them.\n" +
			"\n" +
			"  To get a full list of available commands run:\n" +
			"\n" +
			"    chezmoi secret help",
		example: "" +
			"  chezmoi secret keyring set --service=service --user=user --value=password\n" +
			"  chezmoi secret keyring get --service=service --user=user",
	},
	"source-path": {
		long: "" +
			"Description:\n" +
			"  Print the path to each target's source state. If no targets are specified\n" +
			"  then print the source directory.\n" +
			"\n" +
			"  `source-path` examples\n" +
			"\n" +
			"    chezmoi source-path\n" +
			"    chezmoi source-path ~/.bashrc",
	},
	"state": {
		long: "" +
			"Description:\n" +
			"  Manipulate the persistent state.",
		example: "" +
			"  chezmoi state dump\n" +
			"  chemzoi state reset",
	},
	"status": {
		long: "" +
			"Description:\n" +
			"  Print the status of the files and scripts managed by chezmoi in a format\n" +
			"  similar to git status https://git-scm.com/docs/git-status.\n" +
			"\n" +
			"  The first column of output indicates the difference between the last state\n" +
			"  written by chezmoi and the actual state. The second column indicates the\n" +
			"  difference between the actual state and the target state.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only include entries of type *types*.",
		example: "" +
			"  chezmoi status",
	},
	"unmanage": {
		long: "" +
			"Description:\n" +
			"  `unmanage` is an alias for `forget` for symmetry with `manage`.",
	},
	"unmanaged": {
		long: "" +
			"Description:\n" +
			"  List all unmanaged files in the destination directory.",
		example: "" +
			"  chezmoi unmanaged",
	},
	"update": {
		long: "" +
			"Description:\n" +
			"  Pull changes from the source VCS and apply any changes.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only update entries of type *types*.",
		example: "" +
			"  chezmoi update",
	},
	"upgrade": {
		long: "" +
			"Description:\n" +
			"  Upgrade chezmoi by downloading and installing the latest released version.\n" +
			"  This will call the GitHub API to determine if there is a new version of\n" +
			"  chezmoi available, and if so, download and attempt to install it in the same\n" +
			"  way as chezmoi was previously installed.\n" +
			"\n" +
			"  If chezmoi was installed with a package manager (`dpkg` or `rpm`) then\n" +
			"  `upgrade` will download a new package and install it, using `sudo` if it is\n" +
			"  installed. Otherwise, chezmoi will download the latest executable and\n" +
			"  replace the existing executable with the new version.\n" +
			"\n" +
			"  If the `CHEZMOI_GITHUB_API_TOKEN` environment variable is set, then its\n" +
			"  value will be used to authenticate requests to the GitHub API, otherwise\n" +
			"  unauthenticated requests are used which are subject to stricter rate\n" +
			"  limiting https://developer.github.com/v3/#rate-limiting. Unauthenticated\n" +
			"  requests should be sufficient for most cases.",
		example: "" +
			"  chezmoi upgrade",
	},
	"verify": {
		long: "" +
			"Description:\n" +
			"  Verify that all *targets* match their target state. chezmoi exits with code\n" +
			"  0 (success) if all targets match their target state, or 1 (failure)\n" +
			"  otherwise. If no targets are specified then all targets are checked.\n" +
			"\n" +
			"  `-i`, `--include` *types*\n" +
			"\n" +
			"  Only include entries of type *types*.",
		example: "" +
			"  chezmoi verify\n" +
			"  chezmoi verify ~/.bashrc",
	},
}
