// Code generated by github.com/twpayne/chezmoi/internal/cmd/generate-assets. DO NOT EDIT.
// +build !noembeddocs

package cmd

func init() {
	assets["docs/CHANGES.md"] = []byte("" +
		"# chezmoi Changes\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Upcoming](#upcoming)\n" +
		"  * [Default diff format changing from `chezmoi` to `git`.](#default-diff-format-changing-from-chezmoi-to-git)\n" +
		"  * [`gpgRecipient` config variable changing to `gpg.recipient`](#gpgrecipient-config-variable-changing-to-gpgrecipient)\n" +
		"\n" +
		"## Upcoming\n" +
		"\n" +
		"### Default diff format changing from `chezmoi` to `git`.\n" +
		"\n" +
		"Currently chezmoi outputs diffs in its own format, containing a mix of unified\n" +
		"diffs and shell commands. This will be replaced with a [git format\n" +
		"diff](https://git-scm.com/docs/diff-format) in version 2.0.0.\n" +
		"\n" +
		"### `gpgRecipient` config variable changing to `gpg.recipient`\n" +
		"\n" +
		"The `gpgRecipient` config variable is changing to `gpg.recipient`. To update,\n" +
		"change your config from:\n" +
		"\n" +
		"    gpgRecipient = \"...\"\n" +
		"\n" +
		"to:\n" +
		"\n" +
		"    [gpg]\n" +
		"      recipient = \"...\"\n" +
		"\n" +
		"Support for the `gpgRecipient` config variable will be removed in version 2.0.0.\n" +
		"\n")
	assets["docs/CONTRIBUTING.md"] = []byte("" +
		"# chezmoi Contributing Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Getting started](#getting-started)\n" +
		"* [Developing locally](#developing-locally)\n" +
		"* [Generated code](#generated-code)\n" +
		"* [Contributing changes](#contributing-changes)\n" +
		"* [Managing releases](#managing-releases)\n" +
		"* [Packaging](#packaging)\n" +
		"* [Updating the website](#updating-the-website)\n" +
		"\n" +
		"## Getting started\n" +
		"\n" +
		"chezmoi is written in [Go](https://golang.org) and development happens on\n" +
		"[GitHub](https://github.com). The rest of this document assumes that you've\n" +
		"checked out chezmoi locally.\n" +
		"\n" +
		"## Developing locally\n" +
		"\n" +
		"chezmoi requires Go 1.14 or later and Go modules enabled. Enable Go modules by\n" +
		"setting the environment variable `GO111MODULE=on`.\n" +
		"\n" +
		"chezmoi is a standard Go project, using standard Go tooling, with a few extra\n" +
		"tools. Ensure that these extra tools are installed with:\n" +
		"\n" +
		"    make ensure-tools\n" +
		"\n" +
		"Build chezmoi:\n" +
		"\n" +
		"    go build .\n" +
		"\n" +
		"Run all tests:\n" +
		"\n" +
		"    go test ./...\n" +
		"\n" +
		"Run chezmoi:\n" +
		"\n" +
		"    go run .\n" +
		"\n" +
		"## Generated code\n" +
		"\n" +
		"chezmoi generates help text, shell completions, embedded files, and the website\n" +
		"from a single source of truth. You must run\n" +
		"\n" +
		"    go generate\n" +
		"\n" +
		"if you change includes any of the following:\n" +
		"\n" +
		"* Modify any documentation in the `docs/` directory.\n" +
		"* Modify any files in the `assets/templates/` directory.\n" +
		"* Add or modify a command.\n" +
		"* Add or modify a command's flags.\n" +
		"\n" +
		"chezmoi's continuous integration verifies that all generated files are up to\n" +
		"date. Changes to generated files should be included in the commit that modifies\n" +
		"the source of truth.\n" +
		"\n" +
		"## Contributing changes\n" +
		"\n" +
		"Bug reports, bug fixes, and documentation improvements are always welcome.\n" +
		"Please [open an issue](https://github.com/twpayne/chezmoi/issues/new/choose) or\n" +
		"[create a pull\n" +
		"request](https://help.github.com/en/articles/creating-a-pull-request) with your\n" +
		"report, fix, or improvement.\n" +
		"\n" +
		"If you want to make a more significant change, please first [open an\n" +
		"issue](https://github.com/twpayne/chezmoi/issues/new/choose) to discuss the\n" +
		"change that you want to make. Dave Cheney gives a [good\n" +
		"rationale](https://dave.cheney.net/2019/02/18/talk-then-code) as to why this is\n" +
		"important.\n" +
		"\n" +
		"All changes are made via pull requests. In your pull request, please make sure\n" +
		"that:\n" +
		"\n" +
		"* All existing tests pass.\n" +
		"\n" +
		"* There are appropriate additional tests that demonstrate that your PR works as\n" +
		"  intended.\n" +
		"\n" +
		"* The documentation is updated, if necessary. For new features you should add an\n" +
		"  entry in `docs/HOWTO.md` and a complete description in `docs/REFERENCE.md`.\n" +
		"\n" +
		"* All generated files are up to date. You can ensure this by running `go\n" +
		"  generate` and including any modified files in your commit.\n" +
		"\n" +
		"* The code is correctly formatted, according to\n" +
		"  [`gofumports`](https://mvdan.cc/gofumpt/gofumports). You can ensure this by\n" +
		"  running `make format`.\n" +
		"\n" +
		"* The code passes [`golangci-lint`](https://github.com/golangci/golangci-lint).\n" +
		"  You can ensure this by running `make lint`.\n" +
		"\n" +
		"* The commit messages match chezmoi's convention, specifically that they begin\n" +
		"  with a capitalized verb in the imperative and give a short description of what\n" +
		"  the commit does. Detailed information or justification can be optionally\n" +
		"  included in the body of the commit message.\n" +
		"\n" +
		"* Commits are logically separate, with no merge or \"fixup\" commits.\n" +
		"\n" +
		"* The branch applies cleanly to `master`.\n" +
		"\n" +
		"## Managing releases\n" +
		"\n" +
		"Releases are managed with [`goreleaser`](https://goreleaser.com/).\n" +
		"\n" +
		"To build a test release, without publishing, (Linux only) run:\n" +
		"\n" +
		"    make test-release\n" +
		"\n" +
		"Publish a new release by creating and pushing a tag, e.g.:\n" +
		"\n" +
		"    git tag v1.2.3\n" +
		"    git push --tags\n" +
		"\n" +
		"This triggers a [GitHub Action](https://github.com/twpayne/chezmoi/actions) that\n" +
		"builds and publishes archives, packages, and snaps, and creates a new [GitHub\n" +
		"Release](https://github.com/twpayne/chezmoi/releases).\n" +
		"\n" +
		"Publishing [Snaps](https://snapcraft.io/) requires a `SNAPCRAFT_LOGIN`\n" +
		"[repository\n" +
		"secret](https://github.com/twpayne/chezmoi/settings/secrets/actions). Snapcraft\n" +
		"logins periodically expire. Create a new snapcraft login by running:\n" +
		"\n" +
		"    snapcraft export-login --snaps=chezmoi --channels=stable --acls=package_upload -\n" +
		"\n" +
		"[brew](https://brew.sh/) formula must be updated manually with the command:\n" +
		"\n" +
		"    brew bump-formula-pr --tag=v1.2.3 chezmoi\n" +
		"\n" +
		"## Packaging\n" +
		"\n" +
		"If you're packaging chezmoi for an operating system or distribution:\n" +
		"\n" +
		"* chezmoi has no build or install dependencies other than the standard Go\n" +
		"  toolchain.\n" +
		"\n" +
		"* Please set the version number, git commit, and build time in the binary. This\n" +
		"  greatly assists debugging when end users report problems or ask for help. You\n" +
		"  can do this by passing the following flags to the Go linker:\n" +
		"\n" +
		"  ```\n" +
		"  -X main.version=$VERSION\n" +
		"  -X main.commit=$COMMIT\n" +
		"  -X main.date=$DATE\n" +
		"  -X main.builtBy=$BUILT_BY\n" +
		"  ```\n" +
		"\n" +
		"  `$VERSION` should be the chezmoi version, e.g. `1.7.3`. Any `v` prefix is\n" +
		"  optional and will be stripped, so you can pass the git tag in directly.\n" +
		"\n" +
		"  `$COMMIT` should be the full git commit hash at which chezmoi is built, e.g.\n" +
		"  `4d678ce6850c9d81c7ab2fe0d8f20c1547688b91`.\n" +
		"\n" +
		"  `$DATE` should be the date of the build in RFC3339 format, e.g.\n" +
		"  `2019-11-23T18:29:25Z`.\n" +
		"\n" +
		"  `$BUILT_BY` should be a string indicating what mechanism was used to build the\n" +
		"  binary, e.g. `goreleaser`.\n" +
		"\n" +
		"* Please enable cgo, if possible. chezmoi can be built and run without cgo, but\n" +
		"  the `.chezmoi.username` and `.chezmoi.group` template variables may not be set\n" +
		"  correctly on some systems.\n" +
		"\n" +
		"* chezmoi includes a `docs` command which prints its documentation. By default,\n" +
		"  the docs are embedded in the binary. You can disable this behavior, and have\n" +
		"  chezmoi read its docs from the filesystem by building with the `noembeddocs`\n" +
		"  build tag and setting the directory where chezmoi can find them with the `-X\n" +
		"  github.com/twpayne/chezmoi/cmd.DocDir=$DOCDIR` linker flag. For example:\n" +
		"\n" +
		"  ```\n" +
		"  go build -tags noembeddocs -ldflags \"-X github.com/twpayne/chezmoi/cmd.DocsDir=/usr/share/doc/chezmoi\" .\n" +
		"  ```\n" +
		"\n" +
		"  To remove the `docs` command completely, use the `nodocs` build tag.\n" +
		"\n" +
		"* chezmoi includes an `upgrade` command which attempts to self-upgrade. You can\n" +
		"  remove this command completely by building chezmoi with the `noupgrade` build\n" +
		"  tag.\n" +
		"\n" +
		"* chezmoi includes shell completions in the `completions` directory. Please\n" +
		"  include these in the package and install them in the shell-appropriate\n" +
		"  directory, if possible.\n" +
		"\n" +
		"* If the instructions for installing chezmoi in chezmoi's [install\n" +
		"  guide](https://github.com/twpayne/chezmoi/blob/master/docs/INSTALL.md) are\n" +
		"  absent or incorrect, please open an issue or submit a PR to correct them.\n" +
		"\n" +
		"## Updating the website\n" +
		"\n" +
		"[The website](https://chezmoi.io) is generated with [Hugo](https://gohugo.io/)\n" +
		"and served with [GitHub pages](https://pages.github.com/) from the [`gh-pages`\n" +
		"branch](https://github.com/twpayne/chezmoi/tree/gh-pages) to GitHub.\n" +
		"\n" +
		"Before building the website, you must download the [Hugo Book\n" +
		"Theme](https://github.com/alex-shpak/hugo-book) by running:\n" +
		"\n" +
		"    git submodule update --init\n" +
		"\n" +
		"Test the website locally by running:\n" +
		"\n" +
		"    ( cd chezmoi.io && hugo serve )\n" +
		"\n" +
		"and visit http://localhost:1313/.\n" +
		"\n" +
		"To build the website in a temporary directory, run:\n" +
		"\n" +
		"    ( cd chezmoi.io && make )\n" +
		"\n" +
		"From here you can run\n" +
		"\n" +
		"    git show\n" +
		"\n" +
		"to show changes and\n" +
		"\n" +
		"    git push\n" +
		"\n" +
		"to push them. You can only push changes if you have write permissions to the\n" +
		"chezmoi GitHub repo.\n" +
		"\n")
	assets["docs/FAQ.md"] = []byte("" +
		"# chezmoi Frequently Asked Questions\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [How can I quickly check for problems with chezmoi on my machine?](#how-can-i-quickly-check-for-problems-with-chezmoi-on-my-machine)\n" +
		"* [What are the consequences of \"bare\" modifications to the target files? If my `.zshrc` is managed by chezmoi and I edit `~/.zshrc` without using `chezmoi edit`, what happens?](#what-are-the-consequences-of-bare-modifications-to-the-target-files-if-my-zshrc-is-managed-by-chezmoi-and-i-edit-zshrc-without-using-chezmoi-edit-what-happens)\n" +
		"* [How can I tell what dotfiles in my home directory aren't managed by chezmoi? Is there an easy way to have chezmoi manage a subset of them?](#how-can-i-tell-what-dotfiles-in-my-home-directory-arent-managed-by-chezmoi-is-there-an-easy-way-to-have-chezmoi-manage-a-subset-of-them)\n" +
		"* [How can I tell what dotfiles in my home directory are currently managed by chezmoi?](#how-can-i-tell-what-dotfiles-in-my-home-directory-are-currently-managed-by-chezmoi)\n" +
		"* [If there's a mechanism in place for the above, is there also a way to tell chezmoi to ignore specific files or groups of files (e.g. by directory name or by glob)?](#if-theres-a-mechanism-in-place-for-the-above-is-there-also-a-way-to-tell-chezmoi-to-ignore-specific-files-or-groups-of-files-eg-by-directory-name-or-by-glob)\n" +
		"* [If the target already exists, but is \"behind\" the source, can chezmoi be configured to preserve the target version before replacing it with one derived from the source?](#if-the-target-already-exists-but-is-behind-the-source-can-chezmoi-be-configured-to-preserve-the-target-version-before-replacing-it-with-one-derived-from-the-source)\n" +
		"* [Once I've made a change to the source directory, how do I commit it?](#once-ive-made-a-change-to-the-source-directory-how-do-i-commit-it)\n" +
		"* [How do I only run a script when a file has changed?](#how-do-i-only-run-a-script-when-a-file-has-changed)\n" +
		"* [I've made changes to both the destination state and the source state that I want to keep. How can I keep them both?](#ive-made-changes-to-both-the-destination-state-and-the-source-state-that-i-want-to-keep-how-can-i-keep-them-both)\n" +
		"* [Why does chezmoi convert all my template variables to lowercase?](#why-does-chezmoi-convert-all-my-template-variables-to-lowercase)\n" +
		"* [chezmoi makes `~/.ssh/config` group writeable. How do I stop this?](#chezmoi-makes-sshconfig-group-writeable-how-do-i-stop-this)\n" +
		"* [Why doesn't chezmoi use symlinks like GNU Stow?](#why-doesnt-chezmoi-use-symlinks-like-gnu-stow)\n" +
		"* [Do I have to use `chezmoi edit` to edit my dotfiles?](#do-i-have-to-use-chezmoi-edit-to-edit-my-dotfiles)\n" +
		"* [Can I change how chezmoi's source state is represented on disk?](#can-i-change-how-chezmois-source-state-is-represented-on-disk)\n" +
		"* [gpg encryption fails. What could be wrong?](#gpg-encryption-fails-what-could-be-wrong)\n" +
		"* [chezmoi reports \"user: lookup userid NNNNN: input/output error\"](#chezmoi-reports-user-lookup-userid-nnnnn-inputoutput-error)\n" +
		"* [I'm getting errors trying to build chezmoi from source](#im-getting-errors-trying-to-build-chezmoi-from-source)\n" +
		"* [What inspired chezmoi?](#what-inspired-chezmoi)\n" +
		"* [Why not use Ansible/Chef/Puppet/Salt, or similar to manage my dotfiles instead?](#why-not-use-ansiblechefpuppetsalt-or-similar-to-manage-my-dotfiles-instead)\n" +
		"* [Can I use chezmoi to manage files outside my home directory?](#can-i-use-chezmoi-to-manage-files-outside-my-home-directory)\n" +
		"* [Where does the name \"chezmoi\" come from?](#where-does-the-name-chezmoi-come-from)\n" +
		"* [What other questions have been asked about chezmoi?](#what-other-questions-have-been-asked-about-chezmoi)\n" +
		"* [Where do I ask a question that isn't answered here?](#where-do-i-ask-a-question-that-isnt-answered-here)\n" +
		"* [I like chezmoi. How do I say thanks?](#i-like-chezmoi-how-do-i-say-thanks)\n" +
		"\n" +
		"## How can I quickly check for problems with chezmoi on my machine?\n" +
		"\n" +
		"Run:\n" +
		"\n" +
		"    chezmoi doctor\n" +
		"\n" +
		"Anything `ok` is fine, anything `warning` is only a problem if you want to use\n" +
		"the related feature, and anything `error` indicates a definite problem.\n" +
		"\n" +
		"## What are the consequences of \"bare\" modifications to the target files? If my `.zshrc` is managed by chezmoi and I edit `~/.zshrc` without using `chezmoi edit`, what happens?\n" +
		"\n" +
		"chezmoi will overwrite the file the next time you run `chezmoi apply`. Until you\n" +
		"run `chezmoi apply` your modified `~/.zshrc` will remain in place.\n" +
		"\n" +
		"## How can I tell what dotfiles in my home directory aren't managed by chezmoi? Is there an easy way to have chezmoi manage a subset of them?\n" +
		"\n" +
		"`chezmoi unmanaged` will list everything not managed by chezmoi. You can add\n" +
		"entire directories with `chezmoi add -r`.\n" +
		"\n" +
		"## How can I tell what dotfiles in my home directory are currently managed by chezmoi?\n" +
		"\n" +
		"`chezmoi managed` will list everything managed by chezmoi.\n" +
		"\n" +
		"## If there's a mechanism in place for the above, is there also a way to tell chezmoi to ignore specific files or groups of files (e.g. by directory name or by glob)?\n" +
		"\n" +
		"By default, chezmoi ignores everything that you haven't explicitly `chezmoi\n" +
		"add`'ed. If you have files in your source directory that you don't want added to\n" +
		"your destination directory when you run `chezmoi apply` add their names to a\n" +
		"file called `.chezmoiignore` in the source state.\n" +
		"\n" +
		"Patterns are supported, and you can change what's ignored from machine to\n" +
		"machine. The full usage and syntax is described in the [reference\n" +
		"manual](https://github.com/twpayne/chezmoi/blob/master/docs/REFERENCE.md#chezmoiignore).\n" +
		"\n" +
		"## If the target already exists, but is \"behind\" the source, can chezmoi be configured to preserve the target version before replacing it with one derived from the source?\n" +
		"\n" +
		"Yes. Run `chezmoi add` will update the source state with the target. To see\n" +
		"diffs of what would change, without actually changing anything, use `chezmoi\n" +
		"diff`.\n" +
		"\n" +
		"## Once I've made a change to the source directory, how do I commit it?\n" +
		"\n" +
		"You have several options:\n" +
		"\n" +
		"* `chezmoi cd` opens a shell in the source directory, where you can run your\n" +
		"  usual version control commands, like `git add` and `git commit`.\n" +
		"* `chezmoi git` and `chezmoi hg` run `git` and `hg` respectively in the source\n" +
		"  directory and pass extra arguments to the command. If you're passing any\n" +
		"  flags, you'll need to use `--` to prevent chezmoi from consuming them, for\n" +
		"  example `chezmoi git -- commit -m \"Update dotfiles\"`.\n" +
		"* `chezmoi source` runs your configured version control system in your source\n" +
		"  directory. It works in the same way as the `chezmoi git` and `chezmoi hg`\n" +
		"  commands, but uses `sourceVCS.command`.\n" +
		"\n" +
		"## How do I only run a script when a file has changed?\n" +
		"\n" +
		"A common example of this is that you're using [Homebrew](https://brew.sh/) and\n" +
		"have `.Brewfile` listing all the packages that you want installed and only want\n" +
		"to run `brew bundle --global` when the contents of `.Brewfile` have changed.\n" +
		"\n" +
		"chezmoi has two types of scripts: scripts that run every time, and scripts that\n" +
		"only run when their contents change. chezmoi does not have a mechanism to run a\n" +
		"script when an arbitrary file has changed, but there are some ways to achieve\n" +
		"the desired behavior:\n" +
		"\n" +
		"1. Have the script create `.Brewfile` instead of chezmoi, e.g. in your\n" +
		"   `run_once_install-packages`:\n" +
		"\n" +
		"   ```sh\n" +
		"   #!/bin/sh\n" +
		"\n" +
		"   cat > $HOME/.Brewfile <<EOF\n" +
		"   brew \"imagemagick\"\n" +
		"   brew \"openssl\"\n" +
		"   EOF\n" +
		"\n" +
		"   brew bundle --global\n" +
		"   ```\n" +
		"\n" +
		"2. Don't use `.Brewfile`, and instead install the packages explicitly in\n" +
		"   `run_once_install-packages`:\n" +
		"\n" +
		"   ```sh\n" +
		"   #!/bin/sh\n" +
		"\n" +
		"   brew install imagemagick || true\n" +
		"   brew install openssl || true\n" +
		"   ```\n" +
		"\n" +
		"   The `|| true` is necessary because `brew install` exits with failure if the\n" +
		"   package is already installed.\n" +
		"\n" +
		"3. Use a script that runs every time (not just once) and rely on `brew bundle\n" +
		"   --global` being idempotent.\n" +
		"\n" +
		"4. Use a script that runs every time, records a checksum of `.Brewfile` in\n" +
		"   another file, and only runs `brew bundle --global` if the checksum has\n" +
		"   changed, and updates the recorded checksum after.\n" +
		"\n" +
		"## I've made changes to both the destination state and the source state that I want to keep. How can I keep them both?\n" +
		"\n" +
		"`chezmoi merge` will open a merge tool to resolve differences between the source\n" +
		"state, target state, and destination state. Copy the changes you want to keep in\n" +
		"to the source state.\n" +
		"\n" +
		"## Why does chezmoi convert all my template variables to lowercase?\n" +
		"\n" +
		"This is due to a feature in\n" +
		"[`github.com/spf13/viper`](https://github.com/spf13/viper), the library that\n" +
		"chezmoi uses to read its configuration file. For more information see [this\n" +
		"GitHub issue](https://github.com/twpayne/chezmoi/issues/463).\n" +
		"\n" +
		"## chezmoi makes `~/.ssh/config` group writeable. How do I stop this?\n" +
		"\n" +
		"By default, chezmoi uses your system's umask when creating files. On most\n" +
		"systems the default umask is `022` but some systems use `002`, which means\n" +
		"that files and directories are group writeable by default.\n" +
		"\n" +
		"You can override this for chezmoi by setting the `umask` configuration variable\n" +
		"in your configuration file, for example:\n" +
		"\n" +
		"    umask = 0o022\n" +
		"\n" +
		"Note that this will apply to all files and directories that chezmoi manages and\n" +
		"will ensure that none of them are group writeable. It is not currently possible\n" +
		"to control group write permissions for individual files or directories. Please\n" +
		"[open an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new?assignees=&labels=enhancement&template=02_feature_request.md&title=)\n" +
		"if you need this.\n" +
		"\n" +
		"## Why doesn't chezmoi use symlinks like GNU Stow?\n" +
		"\n" +
		"Symlinks are first class citizens in chezmoi: chezmoi supports creating them,\n" +
		"updating them, removing them, and even more advanced features not found\n" +
		"elsewhere like having the same symlink point to different targets on different\n" +
		"machines by using templates.\n" +
		"\n" +
		"With chezmoi, you only use symlinks where you really need a symlink, in contrast\n" +
		"to some other dotfile managers (e.g. GNU Stow) which require the use of symlinks\n" +
		"as a layer of indirection between a dotfile's location (which can be anywhere in\n" +
		"your home directory) and a dotfile's content (which needs to be in a centralized\n" +
		"directory that you manage with version control). chezmoi solves this problem in\n" +
		"a different way.\n" +
		"\n" +
		"Instead of using a symlink to redirect from the dotfile's location to the\n" +
		"centralized directory, chezmoi generates the dotfile in its final location from\n" +
		"the contents of the centralized directory. Not only is no symlink is needed,\n" +
		"this has the advantages that chezmoi is better able to cope with differences\n" +
		"from machine to machine (as a dotfile's contents can be unique to that machine)\n" +
		"and the dotfiles that chezmoi creates are just regular files. There's nothing\n" +
		"special about dotfiles managed by chezmoi, whereas dotfiles managed with GNU\n" +
		"Stow are special because they're actually symlinks to somewhere else.\n" +
		"\n" +
		"The only advantage to using GNU Stow-style symlinks is that changes that you\n" +
		"make to the dotfile's contents in the centralized directory are immediately\n" +
		"visible, whereas chezmoi currently requires you to run `chezmoi apply` or\n" +
		"`chezmoi edit --apply`. chezmoi will likely get an alternative solution to this\n" +
		"too, see [#752](https://github.com/twpayne/chezmoi/issues/752).\n" +
		"\n" +
		"You can configure chezmoi to work like GNU Stow and have it create a set of\n" +
		"symlinks back to a central directory, but this currently requires a bit of\n" +
		"manual work (as described in\n" +
		"[#167](https://github.com/twpayne/chezmoi/issues/167)). chezmoi might get some\n" +
		"automation to help (see [#886](https://github.com/twpayne/chezmoi/issues/886)\n" +
		"for example) but it does need some convincing use cases that demonstrate that a\n" +
		"symlink from a dotfile's location to its contents in a central directory is\n" +
		"better than just having the correct dotfile contents.\n" +
		"\n" +
		"## Do I have to use `chezmoi edit` to edit my dotfiles?\n" +
		"\n" +
		"No. `chezmoi edit` is a convenience command that has a couple of useful\n" +
		"features, but you don't have to use it. You can also run `chezmoi cd` and then\n" +
		"just edit the files in the source state directly. After saving an edited file\n" +
		"you can run `chezmoi diff` to check what effect the changes would have, and run\n" +
		"`chezmoi apply` if you're happy with them.\n" +
		"\n" +
		"`chezmoi edit` provides the following useful features:\n" +
		"* It opens the correct file in the source state for you, so you don't have to\n" +
		"  know anything about source state attributes.\n" +
		"* If the dotfille is encrypted in the source state, then `chezmoi edit` will\n" +
		"  decrypt it to a private directory, open that file in your `$EDITOR`, and then\n" +
		"  re-encrypt the file when you quit your editor. That makes encryption more\n" +
		"  transparent to the user. With the `--diff` and `--apply` options you can see what\n" +
		"  would change and apply those changes without having to run `chezmoi diff` or\n" +
		"  `chezmoi apply`. Note also that the arguments to `chezmoi edit` are the files in\n" +
		"  their target location.\n" +
		"\n" +
		"## Can I change how chezmoi's source state is represented on disk?\n" +
		"\n" +
		"There are a number of criticisms of how chezmoi's source state is represented on\n" +
		"disk:\n" +
		"\n" +
		"1. The source file naming system cannot handle all possible filenames.\n" +
		"2. Not all possible file permissions can be represented.\n" +
		"3. The long source file names are verbose.\n" +
		"4. Everything is in a single directory, which can end up containing many entries.\n" +
		"\n" +
		"chezmoi's source state representation is a deliberate, practical compromise.\n" +
		"\n" +
		"Certain target filenames, for example `~/dot_example`, are incompatible with\n" +
		"chezmoi's\n" +
		"[attributes](https://github.com/twpayne/chezmoi/blob/master/docs/REFERENCE.md#source-state-attributes)\n" +
		"used in the source state. In practice, dotfile filenames are unlikely to\n" +
		"conflict with chezmoi's attributes. If this does cause a genuine problem for\n" +
		"you, please [open an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"The `dot_` attribute makes it transparent which dotfiles are managed by chezmoi\n" +
		"and which files are ignored by chezmoi. chezmoi ignores all files and\n" +
		"directories that start with `.` so no special whitelists are needed for version\n" +
		"control systems and their control files (e.g. `.git` and `.gitignore`).\n" +
		"\n" +
		"chezmoi needs per-file metadata to know how to interpret the source file's\n" +
		"contents, for example to know when the source file is a template or if the\n" +
		"file's contents are encrypted. By storing this metadata in the filename, the\n" +
		"metadata is unambiguously associated with a single file and adding, updating, or\n" +
		"removing a single file touches only a single file in the source state. Changes\n" +
		"to the metadata (e.g. `chezmoi chattr +template *target*`) are simple file\n" +
		"renames and isolated to the affected file.\n" +
		"\n" +
		"If chezmoi were to, say, use a common configuration file listing which files\n" +
		"were templates and/or encrypted, then changes to any file would require updates\n" +
		"to the common configuration file. Automating updates to configuration files\n" +
		"requires a round trip (read config file, update config, write config) and it is\n" +
		"not always possible preserve comments and formatting.\n" +
		"\n" +
		"chezmoi's attributes of `executable_` and `private_` only allow a the file\n" +
		"permissions `0o644`, `0o755`, `0o600`, and `0o700` to be represented.\n" +
		"Directories can only have permissions `0o755` or `0o700`. In practice, these\n" +
		"cover all permissions typically used for dotfiles. If this does cause a genuine\n" +
		"problem for you, please [open an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"File permissions and modes like `executable_`, `private_`, and `symlink_` could\n" +
		"also be stored in the filesystem, rather than in the filename. However, this\n" +
		"requires the permissions to be preserved and handled by the underlying version\n" +
		"control system and filesystem. chezmoi provides first-class support for Windows,\n" +
		"where the `executable_` and `private_` attributes have no direct equivalents and\n" +
		"symbolic links are not always permitted. Some version control systems do not\n" +
		"preserve file permissions or handle symbolic links. By using regular files and\n" +
		"directories, chezmoi avoids variations in the operating system, version control\n" +
		"system, and filesystem making it both more robust and more portable.\n" +
		"\n" +
		"chezmoi uses a 1:1 mapping between entries in the source state and entries in\n" +
		"the target state. This mapping is bi-directional and unambiguous.\n" +
		"\n" +
		"However, this also means that dotfiles that in the same directory in the target\n" +
		"state must be in the same directory in the source state. In particular, every\n" +
		"entry managed by chezmoi in the root of your home directory has a corresponding\n" +
		"entry in the root of your source directory, which can mean that you end up with\n" +
		"a lot of entries in the root of your source directory.\n" +
		"\n" +
		"If chezmoi were to permit, say, multiple separate source directories (so you\n" +
		"could, say, put `dot_bashrc` in a `bash/` subdirectory, and `dot_vimrc` in a\n" +
		"`vim/` subdirectory, but have `chezmoi apply` map these to `~/.bashrc` and\n" +
		"`~/.vimrc` in the root of your home directory) then the mapping between source\n" +
		"and target states is no longer bidirectional nor unambiguous, which\n" +
		"significantly increases complexity and requires more user interaction. For\n" +
		"example, if both `bash/dot_bashrc` and `vim/dot_bashrc` exist, what should be\n" +
		"the contents of `~/.bashrc`? If you run `chezmoi add ~/.zshrc`, should\n" +
		"`dot_zshrc` be stored in the source `bash/` directory, the source `vim/`\n" +
		"directory, or somewhere else? How does the user communicate their preferences?\n" +
		"\n" +
		"chezmoi has many users and any changes to the source state representation must\n" +
		"be backwards-compatible.\n" +
		"\n" +
		"In summary, chezmoi's source state representation is a compromise with both\n" +
		"advantages and disadvantages. Changes to the representation will be considered,\n" +
		"but must meet the following criteria, in order of importance:\n" +
		"\n" +
		"1. Be fully backwards-compatible for existing users.\n" +
		"2. Fix a genuine problem encountered in practice.\n" +
		"3. Be independent of the underlying operating system, version control system, and\n" +
		"  filesystem.\n" +
		"4. Not add significant extra complexity to the user interface or underlying\n" +
		"   implementation.\n" +
		"\n" +
		"## gpg encryption fails. What could be wrong?\n" +
		"\n" +
		"The `gpg.recipient` key should be ultimately trusted, otherwise encryption will\n" +
		"fail because gpg will prompt for input, which chezmoi does not handle. You can\n" +
		"check the trust level by running:\n" +
		"\n" +
		"    gpg --export-ownertrust\n" +
		"\n" +
		"The trust level for the recipient's key should be `6`. If it is not, you can\n" +
		"change the trust level by running:\n" +
		"\n" +
		"    gpg --edit-key $recipient\n" +
		"\n" +
		"Enter `trust` at the prompt and chose `5 = I trust ultimately`.\n" +
		"\n" +
		"## chezmoi reports \"user: lookup userid NNNNN: input/output error\"\n" +
		"\n" +
		"This is likely because the chezmoi binary you are using was statically compiled\n" +
		"with [musl](https://musl.libc.org/) and the machine you are running on uses\n" +
		"LDAP or NIS.\n" +
		"\n" +
		"The immediate fix is to use a package built for your distriubtion (e.g a `.deb`\n" +
		"or `.rpm`) which is linked against glibc and includes LDAP/NIS support instead\n" +
		"of the statically-compiled binary.\n" +
		"\n" +
		"If the problem still persists, then please [open an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"## I'm getting errors trying to build chezmoi from source\n" +
		"\n" +
		"chezmoi requires Go version 1.14 or later and Go modules enabled. You can check\n" +
		"the version of Go with:\n" +
		"\n" +
		"    go version\n" +
		"\n" +
		"Enable Go modules by setting `GO111MODULE=on` when running `go get`:\n" +
		"\n" +
		"    GO111MODULE=on go get -u github.com/twpayne/chezmoi\n" +
		"\n" +
		"For more details on building chezmoi, see the [Contributing\n" +
		"Guide](CONTRIBUTING.md).\n" +
		"\n" +
		"## What inspired chezmoi?\n" +
		"\n" +
		"chezmoi was inspired by [Puppet](https://puppet.com/), but created because\n" +
		"Puppet is a slow overkill for managing your personal configuration files. The\n" +
		"focus of chezmoi will always be personal home directory management. If your\n" +
		"needs grow beyond that, switch to a whole system configuration management tool.\n" +
		"\n" +
		"## Why not use Ansible/Chef/Puppet/Salt, or similar to manage my dotfiles instead?\n" +
		"\n" +
		"Whole system management tools are more than capable of managing your dotfiles,\n" +
		"but are large systems that entail several disadvantages. Compared to whole\n" +
		"system management tools, chezmoi offers:\n" +
		"\n" +
		"* Small, focused feature set designed for dotfiles. There's simply less to learn\n" +
		"  with chezmoi compared to whole system management tools.\n" +
		"* Easy installation and execution on every platform, without root access.\n" +
		"  Installing chezmoi requires only copying a single binary file with no external\n" +
		"  dependencies. Executing chezmoi just involves running the binary. In contrast,\n" +
		"  installing and running a whole system management tools typically requires\n" +
		"  installing a scripting language runtime, several packages, and running a\n" +
		"  system service, all typically requiring root access.\n" +
		"\n" +
		"chezmoi's focus and simple installation means that it runs almost everywhere:\n" +
		"from tiny ARM-based Linux systems to Windows desktops, from inside lightweight\n" +
		"containers to FreeBSD-based virtual machines in the cloud.\n" +
		"\n" +
		"## Can I use chezmoi to manage files outside my home directory?\n" +
		"\n" +
		"In practice, yes, you can, but this is strongly discouraged beyond using your\n" +
		"system's package manager to install the packages you need.\n" +
		"\n" +
		"chezmoi is designed to operate on your home directory, and is explicitly not a\n" +
		"full system configuration management tool. That said, there are some ways to\n" +
		"have chezmoi manage a few files outside your home directory.\n" +
		"\n" +
		"chezmoi's scripts can execute arbitrary commands, so you can use a `run_` script\n" +
		"that is run every time you run `chezmoi apply`, to, for example:\n" +
		"\n" +
		"* Make the target file outside your home directory a symlink to a file managed\n" +
		"  by chezmoi in your home directory.\n" +
		"* Copy a file managed by chezmoi inside your home directory to the target file.\n" +
		"* Execute a template with `chezmoi execute-template --output=filename template`\n" +
		"  where `filename` is outside the target directory.\n" +
		"\n" +
		"chezmoi executes all scripts as the user executing chezmoi, so you may need to\n" +
		"add extra privilege elevation commands like `sudo` or `PowerShell start -verb\n" +
		"runas -wait` to your script.\n" +
		"\n" +
		"chezmoi, by default, operates on your home directory but this can be overridden\n" +
		"with the `--destination` command line flag or by specifying `destDir` in your\n" +
		"config file, and could even be the root directory (`/` or `C:\\`). This allows\n" +
		"you, in theory, to use chezmoi to manage any file in your filesystem, but this\n" +
		"usage is extremely strongly discouraged.\n" +
		"\n" +
		"If your needs extend beyond modifying a handful of files outside your target\n" +
		"system, then existing configuration management tools like\n" +
		"[Puppet](https://puppet.com/), [Chef](https://chef.io/),\n" +
		"[Ansible](https://www.ansible.com/), and [Salt](https://www.saltstack.com/) are\n" +
		"much better suited - and of course can be called from a chezmoi `run_` script.\n" +
		"Put your Puppet Manifests, Chef Recipes, Ansible Modules, and Salt Modules in a\n" +
		"directory ignored by `.chezmoiignore` so they do not pollute your home\n" +
		"directory.\n" +
		"\n" +
		"## Where does the name \"chezmoi\" come from?\n" +
		"\n" +
		"\"chezmoi\" splits to \"chez moi\" and pronounced /ʃeɪ mwa/ (shay-moi) meaning \"at\n" +
		"my house\" in French. It's seven letters long, which is an appropriate length for\n" +
		"a command that is only run occasionally.\n" +
		"\n" +
		"## What other questions have been asked about chezmoi?\n" +
		"\n" +
		"See the [issues on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues?utf8=%E2%9C%93&q=is%3Aissue+sort%3Aupdated-desc+label%3Asupport).\n" +
		"\n" +
		"## Where do I ask a question that isn't answered here?\n" +
		"\n" +
		"Please [open an issue on GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"## I like chezmoi. How do I say thanks?\n" +
		"\n" +
		"Thank you! chezmoi was written to scratch a personal itch, and I'm very happy\n" +
		"that it's useful to you. Please give [chezmoi a star on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/stargazers), and if you're happy to\n" +
		"share your public dotfile repo then [tag it with\n" +
		"`chezmoi`](https://github.com/topics/chezmoi?o=desc&s=updated). [Contributions\n" +
		"are very\n" +
		"welcome](https://github.com/twpayne/chezmoi/blob/master/docs/CONTRIBUTING.md)\n" +
		"and every [bug report, support request, and feature\n" +
		"request](https://github.com/twpayne/chezmoi/issues/new/choose) helps make\n" +
		"chezmoi better. Thank you :)\n" +
		"\n")
	assets["docs/HOWTO.md"] = []byte("" +
		"# chezmoi How-To Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Use a hosted repo to manage your dotfiles across multiple machines](#use-a-hosted-repo-to-manage-your-dotfiles-across-multiple-machines)\n" +
		"* [Pull the latest changes from your repo and apply them](#pull-the-latest-changes-from-your-repo-and-apply-them)\n" +
		"* [Pull the latest changes from your repo and see what would change, without actually applying the changes](#pull-the-latest-changes-from-your-repo-and-see-what-would-change-without-actually-applying-the-changes)\n" +
		"* [Automatically commit and push changes to your repo](#automatically-commit-and-push-changes-to-your-repo)\n" +
		"* [Use templates to manage files that vary from machine to machine](#use-templates-to-manage-files-that-vary-from-machine-to-machine)\n" +
		"* [Use completely separate config files on different machines](#use-completely-separate-config-files-on-different-machines)\n" +
		"  * [Without using symlinks](#without-using-symlinks)\n" +
		"* [Create a config file on a new machine automatically](#create-a-config-file-on-a-new-machine-automatically)\n" +
		"* [Have chezmoi create a directory, but ignore its contents](#have-chezmoi-create-a-directory-but-ignore-its-contents)\n" +
		"* [Ensure that a target is removed](#ensure-that-a-target-is-removed)\n" +
		"* [Include a subdirectory from another repository, like Oh My Zsh](#include-a-subdirectory-from-another-repository-like-oh-my-zsh)\n" +
		"* [Handle configuration files which are externally modified](#handle-configuration-files-which-are-externally-modified)\n" +
		"* [Handle different file locations on different systems with the same contents](#handle-different-file-locations-on-different-systems-with-the-same-contents)\n" +
		"* [Keep data private](#keep-data-private)\n" +
		"  * [Use Bitwarden to keep your secrets](#use-bitwarden-to-keep-your-secrets)\n" +
		"  * [Use gopass to keep your secrets](#use-gopass-to-keep-your-secrets)\n" +
		"  * [Use gpg to keep your secrets](#use-gpg-to-keep-your-secrets)\n" +
		"  * [Use KeePassXC to keep your secrets](#use-keepassxc-to-keep-your-secrets)\n" +
		"  * [Use a keyring to keep your secrets](#use-a-keyring-to-keep-your-secrets)\n" +
		"  * [Use LastPass to keep your secrets](#use-lastpass-to-keep-your-secrets)\n" +
		"  * [Use 1Password to keep your secrets](#use-1password-to-keep-your-secrets)\n" +
		"  * [Use pass to keep your secrets](#use-pass-to-keep-your-secrets)\n" +
		"  * [Use Vault to keep your secrets](#use-vault-to-keep-your-secrets)\n" +
		"  * [Use a generic tool to keep your secrets](#use-a-generic-tool-to-keep-your-secrets)\n" +
		"  * [Use templates variables to keep your secrets](#use-templates-variables-to-keep-your-secrets)\n" +
		"* [Use scripts to perform actions](#use-scripts-to-perform-actions)\n" +
		"  * [Understand how scripts work](#understand-how-scripts-work)\n" +
		"  * [Install packages with scripts](#install-packages-with-scripts)\n" +
		"* [Use chezmoi with GitHub Codespaces, Visual Studio Codespaces, Visual Studio Code Remote - Containers](#use-chezmoi-with-github-codespaces-visual-studio-codespaces-visual-studio-code-remote---containers)\n" +
		"* [Detect Windows Subsystem for Linux (WSL)](#detect-windows-subsystem-for-linux-wsl)\n" +
		"* [Run a PowerShell script as admin on Windows](#run-a-powershell-script-as-admin-on-windows)\n" +
		"* [Import archives](#import-archives)\n" +
		"* [Export archives](#export-archives)\n" +
		"* [Use a non-git version control system](#use-a-non-git-version-control-system)\n" +
		"* [Customize the `diff` command](#customize-the-diff-command)\n" +
		"* [Use a merge tool other than vimdiff](#use-a-merge-tool-other-than-vimdiff)\n" +
		"* [Migrate from a dotfile manager that uses symlinks](#migrate-from-a-dotfile-manager-that-uses-symlinks)\n" +
		"\n" +
		"## Use a hosted repo to manage your dotfiles across multiple machines\n" +
		"\n" +
		"chezmoi relies on your version control system and hosted repo to share changes\n" +
		"across multiple machines. You should create a repo on the source code repository\n" +
		"of your choice (e.g. [Bitbucket](https://bitbucket.org),\n" +
		"[GitHub](https://github.com/), or [GitLab](https://gitlab.com), many people call\n" +
		"their repo `dotfiles`) and push the repo in the source directory here. For\n" +
		"example:\n" +
		"\n" +
		"    chezmoi cd\n" +
		"    git remote add origin https://github.com/username/dotfiles.git\n" +
		"    git push -u origin master\n" +
		"    exit\n" +
		"\n" +
		"On another machine you can checkout this repo:\n" +
		"\n" +
		"    chezmoi init https://github.com/username/dotfiles.git\n" +
		"\n" +
		"You can then see what would be changed:\n" +
		"\n" +
		"    chezmoi diff\n" +
		"\n" +
		"If you're happy with the changes then apply them:\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"The above commands can be combined into a single init, checkout, and apply:\n" +
		"\n" +
		"    chezmoi init --apply --verbose https://github.com/username/dotfiles.git\n" +
		"\n" +
		"## Pull the latest changes from your repo and apply them\n" +
		"\n" +
		"You can pull the changes from your repo and apply them in a single command:\n" +
		"\n" +
		"    chezmoi update\n" +
		"\n" +
		"This runs `git pull --rebase` in your source directory and then `chezmoi apply`.\n" +
		"\n" +
		"## Pull the latest changes from your repo and see what would change, without actually applying the changes\n" +
		"\n" +
		"Run:\n" +
		"\n" +
		"    chezmoi source pull -- --rebase && chezmoi diff\n" +
		"\n" +
		"This runs `git pull --rebase` in your source directory and `chezmoi\n" +
		"diff` then shows the difference between the target state computed from your\n" +
		"source directory and the actual state.\n" +
		"\n" +
		"If you're happy with the changes, then you can run\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"to apply them.\n" +
		"\n" +
		"## Automatically commit and push changes to your repo\n" +
		"\n" +
		"chezmoi can automatically commit and push changes to your source directory to\n" +
		"your repo. This feature is disabled by default. To enable it, add the following\n" +
		"to your config file:\n" +
		"\n" +
		"    [sourceVCS]\n" +
		"        autoCommit = true\n" +
		"        autoPush = true\n" +
		"\n" +
		"Whenever a change is made to your source directory, chezmoi will commit the\n" +
		"changes with an automatically-generated commit message (if `autoCommit` is true)\n" +
		"and push them to your repo (if `autoPush` is true). `autoPush` implies\n" +
		"`autoCommit`, i.e. if `autoPush` is true then chezmoi will auto-commit your\n" +
		"changes. If you only set `autoCommit` to true then changes will be committed but\n" +
		"not pushed.\n" +
		"\n" +
		"Be careful when using `autoPush`. If your dotfiles repo is public and you\n" +
		"accidentally add a secret in plain text, that secret will be pushed to your\n" +
		"public repo.\n" +
		"\n" +
		"## Use templates to manage files that vary from machine to machine\n" +
		"\n" +
		"The primary goal of chezmoi is to manage configuration files across multiple\n" +
		"machines, for example your personal macOS laptop, your work Ubuntu desktop, and\n" +
		"your work Linux laptop. You will want to keep much configuration the same across\n" +
		"these, but also need machine-specific configurations for email addresses,\n" +
		"credentials, etc. chezmoi achieves this functionality by using\n" +
		"[`text/template`](https://pkg.go.dev/text/template) for the source state where\n" +
		"needed.\n" +
		"\n" +
		"For example, your home `~/.gitconfig` on your personal machine might look like:\n" +
		"\n" +
		"    [user]\n" +
		"      email = \"john@home.org\"\n" +
		"\n" +
		"Whereas at work it might be:\n" +
		"\n" +
		"    [user]\n" +
		"      email = \"john.smith@company.com\"\n" +
		"\n" +
		"To handle this, on each machine create a configuration file called\n" +
		"`~/.config/chezmoi/chezmoi.toml` defining variables that might vary from machine\n" +
		"to machine. For example, for your home machine:\n" +
		"\n" +
		"    [data]\n" +
		"      email = \"john@home.org\"\n" +
		"\n" +
		"Note that all variable names will be converted to lowercase. This is due to a\n" +
		"feature of a library used by chezmoi.\n" +
		"\n" +
		"If you intend to store private data (e.g. access tokens) in\n" +
		"`~/.config/chezmoi/chezmoi.toml`, make sure it has permissions `0600`.\n" +
		"\n" +
		"If you prefer, you can use any format supported by\n" +
		"[Viper](https://github.com/spf13/viper) for your configuration file. This\n" +
		"includes JSON, YAML, and TOML. Variable names must start with a letter and be\n" +
		"followed by zero or more letters or digits.\n" +
		"\n" +
		"Then, add `~/.gitconfig` to chezmoi using the `--autotemplate` flag to turn it\n" +
		"into a template and automatically detect variables from the `data` section\n" +
		"of your `~/.config/chezmoi/chezmoi.toml` file:\n" +
		"\n" +
		"    chezmoi add --autotemplate ~/.gitconfig\n" +
		"\n" +
		"You can then open the template (which will be saved in the file\n" +
		"`~/.local/share/chezmoi/dot_gitconfig.tmpl`):\n" +
		"\n" +
		"    chezmoi edit ~/.gitconfig\n" +
		"\n" +
		"The file should look something like:\n" +
		"\n" +
		"    [user]\n" +
		"      email = \"{{ .email }}\"\n" +
		"\n" +
		"To disable automatic variable detection, use the `--template` or `-T` option to\n" +
		"`chezmoi add` instead of `--autotemplate`.\n" +
		"\n" +
		"Templates are often used to capture machine-specific differences. For example,\n" +
		"in your `~/.local/share/chezmoi/dot_bashrc.tmpl` you might have:\n" +
		"\n" +
		"    # common config\n" +
		"    export EDITOR=vi\n" +
		"\n" +
		"    # machine-specific configuration\n" +
		"    {{- if eq .chezmoi.hostname \"work-laptop\" }}\n" +
		"    # this will only be included in ~/.bashrc on work-laptop\n" +
		"    {{- end }}\n" +
		"\n" +
		"For a full list of variables, run:\n" +
		"\n" +
		"    chezmoi data\n" +
		"\n" +
		"For more advanced usage, you can use the full power of the\n" +
		"[`text/template`](https://pkg.go.dev/text/template) language. chezmoi includes\n" +
		"all of the text functions from [sprig](http://masterminds.github.io/sprig/) and\n" +
		"its own [functions for interacting with password\n" +
		"managers](https://github.com/twpayne/chezmoi/blob/master/docs/REFERENCE.md#template-functions).\n" +
		"\n" +
		"Templates can be executed directly from the command line, without the need to\n" +
		"create a file on disk, with the `execute-template` command, for example:\n" +
		"\n" +
		"    chezmoi execute-template '{{ .chezmoi.os }}/{{ .chezmoi.arch }}'\n" +
		"\n" +
		"This is useful when developing or debugging templates.\n" +
		"\n" +
		"Some password managers allow you to store complete files. The files can be\n" +
		"retrieved with chezmoi's template functions. For example, if you have a file\n" +
		"stored in 1Password with the UUID `uuid` then you can retrieve it with the\n" +
		"template:\n" +
		"\n" +
		"    {{- onepasswordDocument \"uuid\" -}}\n" +
		"\n" +
		"The `-`s inside the brackets remove any whitespace before or after the template\n" +
		"expression, which is useful if your editor has added any newlines.\n" +
		"\n" +
		"If, after executing the template, the file contents are empty, the target file\n" +
		"will be removed. This can be used to ensure that files are only present on\n" +
		"certain machines. If you want an empty file to be created anyway, you will need\n" +
		"to give it an `empty_` prefix.\n" +
		"\n" +
		"For coarser-grained control of files and entire directories managed on different\n" +
		"machines, or to exclude certain files completely, you can create\n" +
		"`.chezmoiignore` files in the source directory. These specify a list of patterns\n" +
		"that chezmoi should ignore, and are interpreted as templates. An example\n" +
		"`.chezmoiignore` file might look like:\n" +
		"\n" +
		"    README.md\n" +
		"    {{- if ne .chezmoi.hostname \"work-laptop\" }}\n" +
		"    .work # only manage .work on work-laptop\n" +
		"    {{- end }}\n" +
		"\n" +
		"The use of `ne` (not equal) is deliberate. What we want to achieve is \"only\n" +
		"install `.work` if hostname is `work-laptop`\" but chezmoi installs everything by\n" +
		"default, so we have to turn the logic around and instead write \"ignore `.work`\n" +
		"unless the hostname is `work-laptop`\".\n" +
		"\n" +
		"Patterns can be excluded by prefixing them with a `!`, for example:\n" +
		"\n" +
		"    f*\n" +
		"    !foo\n" +
		"\n" +
		"will ignore all files beginning with an `f` except `foo`.\n" +
		"\n" +
		"## Use completely separate config files on different machines\n" +
		"\n" +
		"chezmoi's template functionality allows you to change a file's contents based on\n" +
		"any variable. For example, if you want `~/.bashrc` to be different on Linux and\n" +
		"macOS you would create a file in the source state called `dot_bashrc.tmpl`\n" +
		"containing:\n" +
		"\n" +
		"```\n" +
		"{{ if eq .chezmoi.os \"darwin\" -}}\n" +
		"# macOS .bashrc contents\n" +
		"{{ else if eq .chezmoi.os \"linux\" -}}\n" +
		"# Linux .bashrc contents\n" +
		"{{ end -}}\n" +
		"```\n" +
		"\n" +
		"However, if the differences between the two versions are so large that you'd\n" +
		"prefer to use completely separate files in the source state, you can achieve\n" +
		"this using a symbolic link template. Create the following files:\n" +
		"\n" +
		"`symlink_dot_bashrc.tmpl`:\n" +
		"\n" +
		"```\n" +
		".bashrc_{{ .chezmoi.os }}\n" +
		"```\n" +
		"\n" +
		"`dot_bashrc_darwin`:\n" +
		"\n" +
		"```\n" +
		"# macOS .bashrc contents\n" +
		"```\n" +
		"\n" +
		"`dot_bashrc_linux`:\n" +
		"\n" +
		"```\n" +
		"# Linux .bashrc contents\n" +
		"```\n" +
		"\n" +
		"`.chezmoiignore`\n" +
		"\n" +
		"```\n" +
		"{{ if ne .chezmoi.os \"darwin\" }}\n" +
		".bashrc_darwin\n" +
		"{{ end }}\n" +
		"{{ if ne .chezmoi.os \"linux\" }}\n" +
		".bashrc_linux\n" +
		"{{ end }}\n" +
		"```\n" +
		"\n" +
		"This will make `~/.bashrc` a symlink to `.bashrc_darwin` on `darwin` and to\n" +
		"`.bashrc_linux` on `linux`. The `.chezmoiignore` configuration ensures that only\n" +
		"the OS-specific `.bashrc_os` file will be installed on each OS.\n" +
		"\n" +
		"### Without using symlinks\n" +
		"\n" +
		"The same thing can be achieved using the include function.\n" +
		"\n" +
		"`dot_bashrc.tmpl`\n" +
		"\n" +
		"\t{{ if eq .chezmoi.os \"darwin\" }}\n" +
		"\t{{ include \".bashrc_darwin\" }}\n" +
		"\t{{ end }}\n" +
		"\t{{ if eq .chezmoi.os \"linux\" }}\n" +
		"\t{{ include \".bashrc_linux\" }}\n" +
		"\t{{ end }}\n" +
		"\n" +
		"\n" +
		"## Create a config file on a new machine automatically\n" +
		"\n" +
		"`chezmoi init` can also create a config file automatically, if one does not\n" +
		"already exist. If your repo contains a file called `.chezmoi.<format>.tmpl`\n" +
		"where *format* is one of the supported config file formats (e.g. `json`, `toml`,\n" +
		"or `yaml`) then `chezmoi init` will execute that template to generate your\n" +
		"initial config file.\n" +
		"\n" +
		"Specifically, if you have `.chezmoi.toml.tmpl` that looks like this:\n" +
		"\n" +
		"    {{- $email := promptString \"email\" -}}\n" +
		"    [data]\n" +
		"        email = \"{{ $email }}\"\n" +
		"\n" +
		"Then `chezmoi init` will create an initial `chezmoi.toml` using this template.\n" +
		"`promptString` is a special function that prompts the user (you) for a value.\n" +
		"\n" +
		"To test this template, use `chezmoi execute-template` with the `--init` and\n" +
		"`--promptString` flags, for example:\n" +
		"\n" +
		"    chezmoi execute-template --init --promptString email=john@home.org < ~/.local/share/chezmoi/.chezmoi.toml.tmpl\n" +
		"\n" +
		"## Have chezmoi create a directory, but ignore its contents\n" +
		"\n" +
		"If you want chezmoi to create a directory, but ignore its contents, say `~/src`,\n" +
		"first run:\n" +
		"\n" +
		"    mkdir -p $(chezmoi source-path)/src\n" +
		"\n" +
		"This creates the directory in the source state, which means that chezmoi will\n" +
		"create it (if it does not already exist) when you run `chezmoi apply`.\n" +
		"\n" +
		"However, as this is an empty directory it will be ignored by git. So, create a\n" +
		"file in the directory in the source state that will be seen by git (so git does\n" +
		"not ignore the directory) but ignored by chezmoi (so chezmoi does not include it\n" +
		"in the target state):\n" +
		"\n" +
		"    touch $(chezmoi source-path)/src/.keep\n" +
		"\n" +
		"chezmoi automatically creates `.keep` files when you add an empty directory with\n" +
		"`chezmoi add`.\n" +
		"\n" +
		"## Ensure that a target is removed\n" +
		"\n" +
		"Create a file called `.chezmoiremove` in the source directory containing a list\n" +
		"of patterns of files to remove. When you run\n" +
		"\n" +
		"    chezmoi apply --remove\n" +
		"\n" +
		"chezmoi will remove anything in the target directory that matches the pattern.\n" +
		"As this command is potentially dangerous, you should run chezmoi in verbose,\n" +
		"dry-run mode beforehand to see what would be removed:\n" +
		"\n" +
		"    chezmoi apply --remove --dry-run --verbose\n" +
		"\n" +
		"`.chezmoiremove` is interpreted as a template, so you can remove different files\n" +
		"on different machines. Negative matches (patterns prefixed with a `!`) or\n" +
		"targets listed in `.chezmoiignore` will never be removed.\n" +
		"\n" +
		"## Include a subdirectory from another repository, like Oh My Zsh\n" +
		"\n" +
		"To include a subdirectory from another repository, e.g. [Oh My\n" +
		"Zsh](https://github.com/robbyrussell/oh-my-zsh), you cannot use git submodules\n" +
		"because chezmoi uses its own format for the source state and Oh My Zsh is not\n" +
		"distributed in this format. Instead, you can use the `import` command to import\n" +
		"a snapshot from a tarball:\n" +
		"\n" +
		"    curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-zsh/archive/master.tar.gz\n" +
		"    chezmoi import --strip-components 1 --destination ${HOME}/.oh-my-zsh oh-my-zsh-master.tar.gz\n" +
		"\n" +
		"Add `oh-my-zsh-master.tar.gz` to `.chezmoiignore` if you run these commands in\n" +
		"your source directory so that chezmoi doesn't try to copy the tarball anywhere.\n" +
		"\n" +
		"Disable Oh My Zsh auto-updates by setting `DISABLE_AUTO_UPDATE=\"true\"` in\n" +
		"`~/.zshrc`. Auto updates will cause the `~/.oh-my-zsh` directory to drift out of\n" +
		"sync with chezmoi's source state. To update Oh My Zsh, re-run the `curl` and\n" +
		"`chezmoi import` commands above.\n" +
		"\n" +
		"## Handle configuration files which are externally modified\n" +
		"\n" +
		"Some programs modify their configuration files. When you next run `chezmoi\n" +
		"apply`, any modifications made by the program will be lost.\n" +
		"\n" +
		"You can track changes to these files by replacing with a symlink back to a file\n" +
		"in your source directory, which is under version control. Here is a worked\n" +
		"example for VSCode's `settings.json` on Linux:\n" +
		"\n" +
		"Copy the configuration file to your source directory:\n" +
		"\n" +
		"    cp ~/.config/Code/User/settings.json $(chezmoi source-path)\n" +
		"\n" +
		"Tell chezmoi to ignore this file:\n" +
		"\n" +
		"    echo settings.json >> $(chezmoi source-path)/.chezmoiignore\n" +
		"\n" +
		"Tell chezmoi that `~/.config/Code/User/settings.json` should be a symlink to the\n" +
		"file in your source directory:\n" +
		"\n" +
		"    mkdir -p $(chezmoi source-path)/private_dot_config/private_Code/User\n" +
		"    echo -n \"{{ .chezmoi.sourceDir }}/settings.json\" > $(chezmoi source-path)/private_dot_config/private_Code/User/symlink_settings.json.tmpl\n" +
		"\n" +
		"The prefix `private_` is used because the `~/.config` and `~/.config/Code`\n" +
		"directories are private by default.\n" +
		"\n" +
		"Apply the changes:\n" +
		"\n" +
		"    chezmoi apply -v\n" +
		"\n" +
		"Now, when the program modifies its configuration file it will modify the file in\n" +
		"the source state instead.\n" +
		"\n" +
		"## Handle different file locations on different systems with the same contents\n" +
		"\n" +
		"If you want to have the same file contents in different locations on different\n" +
		"systems, but maintain only a single file in your source state, you can use\n" +
		"a shared template.\n" +
		"\n" +
		"Create the common file in the `.chezmoitemplates` directory in the source state. For\n" +
		"example, create `.chezmoitemplates/file.conf`. The contents of this file are\n" +
		"available in templates with the `template *name*` function where *name* is the\n" +
		"name of the file.\n" +
		"\n" +
		"Then create files for each system, for example `Library/Application\n" +
		"Support/App/file.conf.tmpl` for macOS and `dot_config/app/file.conf.tmpl` for\n" +
		"Linux. Both template files should contain `{{- template \"file.conf\" -}}`.\n" +
		"\n" +
		"Finally, tell chezmoi to ignore files where they are not needed by adding lines\n" +
		"to your `.chezmoiignore` file, for example:\n" +
		"\n" +
		"```\n" +
		"{{ if ne .chezmoi.os \"darwin\" }}\n" +
		"Library/Application Support/App/file.conf\n" +
		"{{ end }}\n" +
		"{{ if ne .chezmoi.os \"linux\" }}\n" +
		".config/app/file.conf\n" +
		"{{ end }}\n" +
		"```\n" +
		"\n" +
		"## Keep data private\n" +
		"\n" +
		"chezmoi automatically detects when files and directories are private when adding\n" +
		"them by inspecting their permissions. Private files and directories are stored\n" +
		"in `~/.local/share/chezmoi` as regular, public files with permissions `0644` and\n" +
		"the name prefix `private_`. For example:\n" +
		"\n" +
		"    chezmoi add ~/.netrc\n" +
		"\n" +
		"will create `~/.local/share/chezmoi/private_dot_netrc` (assuming `~/.netrc` is\n" +
		"not world- or group- readable, as it should be). This file is still private\n" +
		"because `~/.local/share/chezmoi` is not group- or world- readable or executable.\n" +
		"chezmoi checks that the permissions of `~/.local/share/chezmoi` are `0700` on\n" +
		"every run and will print a warning if they are not.\n" +
		"\n" +
		"It is common that you need to store access tokens in config files, e.g. a\n" +
		"[GitHub access\n" +
		"token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/).\n" +
		"There are several ways to keep these tokens secure, and to prevent them leaving\n" +
		"your machine.\n" +
		"\n" +
		"### Use Bitwarden to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [Bitwarden](https://bitwarden.com/) using the\n" +
		"[Bitwarden CLI](https://github.com/bitwarden/cli) to expose data as a template\n" +
		"function.\n" +
		"\n" +
		"Log in to Bitwarden using:\n" +
		"\n" +
		"    bw login <bitwarden-email>\n" +
		"\n" +
		"Unlock your Bitwarden vault:\n" +
		"\n" +
		"    bw unlock\n" +
		"\n" +
		"Set the `BW_SESSION` environment variable, as instructed.\n" +
		"\n" +
		"The structured data from `bw get` is available as the `bitwarden` template\n" +
		"function in your config files, for example:\n" +
		"\n" +
		"    username = {{ (bitwarden \"item\" \"example.com\").login.username }}\n" +
		"    password = {{ (bitwarden \"item\" \"example.com\").login.password }}\n" +
		"\n" +
		"Custom fields can be accessed with the `bitwardenFields` template function. For\n" +
		"example, if you have a custom field named `token` you can retrieve its value\n" +
		"with:\n" +
		"\n" +
		"    {{ (bitwardenFields \"item\" \"example.com\").token.value }}\n" +
		"\n" +
		"### Use gopass to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [gopass](https://www.gopass.pw/) using the gopass CLI.\n" +
		"\n" +
		"The first line of the output of `gopass show <pass-name>` is available as the\n" +
		"`gopass` template function, for example:\n" +
		"\n" +
		"    {{ gopass \"<pass-name>\" }}\n" +
		"\n" +
		"### Use gpg to keep your secrets\n" +
		"\n" +
		"chezmoi supports encrypting files with [gpg](https://www.gnupg.org/). Encrypted\n" +
		"files are stored in the source state and automatically be decrypted when\n" +
		"generating the target state or printing a file's contents with `chezmoi cat`.\n" +
		"`chezmoi edit` will transparently decrypt the file before editing and re-encrypt\n" +
		"it afterwards.\n" +
		"\n" +
		"#### Asymmetric (private/public-key) encryption\n" +
		"\n" +
		"Specify the encryption key to use in your configuration file (`chezmoi.toml`)\n" +
		"with the `gpg.recipient` key:\n" +
		"\n" +
		"    [gpg]\n" +
		"      recipient = \"...\"\n" +
		"\n" +
		"Add files to be encrypted with the `--encrypt` flag, for example:\n" +
		"\n" +
		"    chezmoi add --encrypt ~/.ssh/id_rsa\n" +
		"\n" +
		"chezmoi will encrypt the file with:\n" +
		"\n" +
		"    gpg --armor --recipient ${gpg.recipient} --encrypt\n" +
		"\n" +
		"and store the encrypted file in the source state. The file will automatically be\n" +
		"decrypted when generating the target state.\n" +
		"\n" +
		"#### Symmetric encryption\n" +
		"\n" +
		"Specify symmetric encryption in your configuration file:\n" +
		"\n" +
		"    [gpg]\n" +
		"      symmetric = true\n" +
		"\n" +
		"Add files to be encrypted with the `--encrypt` flag, for example:\n" +
		"\n" +
		"    chezmoi add --encrypt ~/.ssh/id_rsa\n" +
		"\n" +
		"chezmoi will encrypt the file with:\n" +
		"\n" +
		"    gpg --armor --symmetric\n" +
		"\n" +
		"### Use KeePassXC to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [KeePassXC](https://keepassxc.org) using the\n" +
		"KeePassXC CLI (`keepassxc-cli`) to expose data as a template function.\n" +
		"\n" +
		"Provide the path to your KeePassXC database in your configuration file:\n" +
		"\n" +
		"    [keepassxc]\n" +
		"      database = \"/home/user/Passwords.kdbx\"\n" +
		"\n" +
		"The structured data from `keepassxc-cli show $database` is available as the\n" +
		"`keepassxc` template function in your config files, for example:\n" +
		"\n" +
		"    username = {{ (keepassxc \"example.com\").UserName }}\n" +
		"    password = {{ (keepassxc \"example.com\").Password }}\n" +
		"\n" +
		"Additional attributes are available through the `keepassxcAttribute` function.\n" +
		"For example, if you have an entry called `SSH Key` with an additional attribute\n" +
		"called `private-key`, its value is available as:\n" +
		"\n" +
		"    {{ keepassxcAttribute \"SSH Key\" \"private-key\" }}\n" +
		"\n" +
		"### Use a keyring to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for Keychain (on macOS), GNOME Keyring (on Linux), and\n" +
		"Windows Credentials Manager (on Windows) via the\n" +
		"[`zalando/go-keyring`](https://github.com/zalando/go-keyring) library.\n" +
		"\n" +
		"Set values with:\n" +
		"\n" +
		"    $ chezmoi keyring set --service=<service> --user=<user>\n" +
		"    Value: xxxxxxxx\n" +
		"\n" +
		"The value can then be used in templates using the `keyring` function which takes\n" +
		"the service and user as arguments.\n" +
		"\n" +
		"For example, save a GitHub access token in keyring with:\n" +
		"\n" +
		"    $ chezmoi keyring set --service=github --user=<github-username>\n" +
		"    Value: xxxxxxxx\n" +
		"\n" +
		"and then include it in your `~/.gitconfig` file with:\n" +
		"\n" +
		"    [github]\n" +
		"      user = \"{{ .github.user }}\"\n" +
		"      token = \"{{ keyring \"github\" .github.user }}\"\n" +
		"\n" +
		"You can query the keyring from the command line:\n" +
		"\n" +
		"    chezmoi keyring get --service=github --user=<github-username>\n" +
		"\n" +
		"### Use LastPass to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [LastPass](https://lastpass.com) using the\n" +
		"[LastPass CLI](https://lastpass.github.io/lastpass-cli/lpass.1.html) to expose\n" +
		"data as a template function.\n" +
		"\n" +
		"Log in to LastPass using:\n" +
		"\n" +
		"    lpass login <lastpass-username>\n" +
		"\n" +
		"Check that `lpass` is working correctly by showing password data:\n" +
		"\n" +
		"    lpass show --json <lastpass-entry-id>\n" +
		"\n" +
		"where `<lastpass-entry-id>` is a [LastPass Entry\n" +
		"Specification](https://lastpass.github.io/lastpass-cli/lpass.1.html#_entry_specification).\n" +
		"\n" +
		"The structured data from `lpass show --json id` is available as the `lastpass`\n" +
		"template function. The value will be an array of objects. You can use the\n" +
		"`index` function and `.Field` syntax of the `text/template` language to extract\n" +
		"the field you want. For example, to extract the `password` field from first the\n" +
		"\"GitHub\" entry, use:\n" +
		"\n" +
		"    githubPassword = \"{{ (index (lastpass \"GitHub\") 0).password }}\"\n" +
		"\n" +
		"chezmoi automatically parses the `note` value of the Lastpass entry as\n" +
		"colon-separated key-value pairs, so, for example, you can extract a private SSH\n" +
		"key like this:\n" +
		"\n" +
		"    {{ (index (lastpass \"SSH\") 0).note.privateKey }}\n" +
		"\n" +
		"Keys in the `note` section written as `CamelCase Words` are converted to\n" +
		"`camelCaseWords`.\n" +
		"\n" +
		"If the `note` value does not contain colon-separated key-value pairs, then you\n" +
		"can use `lastpassRaw` to get its raw value, for example:\n" +
		"\n" +
		"    {{ (index (lastpassRaw \"SSH Private Key\") 0).note }}\n" +
		"\n" +
		"### Use 1Password to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [1Password](https://1password.com/) using the\n" +
		"[1Password CLI](https://support.1password.com/command-line-getting-started/) to\n" +
		"expose data as a template function.\n" +
		"\n" +
		"Log in and get a session using:\n" +
		"\n" +
		"    eval $(op signin <subdomain>.1password.com <email>)\n" +
		"\n" +
		"The output of `op get item <uuid>` is available as the `onepassword` template\n" +
		"function. chezmoi parses the JSON output and returns it as structured data. For\n" +
		"example, if the output of `op get item \"<uuid>\"` is:\n" +
		"\n" +
		"    {\n" +
		"        \"uuid\": \"<uuid>\",\n" +
		"        \"details\": {\n" +
		"            \"password\": \"xxx\"\n" +
		"        }\n" +
		"    }\n" +
		"\n" +
		"Then you can access `details.password` with the syntax:\n" +
		"\n" +
		"    {{ (onepassword \"<uuid>\").details.password }}\n" +
		"\n" +
		"Login details fields can be retrieved with the `onepasswordDetailsFields`\n" +
		"function, for example:\n" +
		"\n" +
		"    {{- (onepasswordDetailsFields \"uuid\").password.value }}\n" +
		"\n" +
		"Documents can be retrieved with:\n" +
		"\n" +
		"    {{- onepasswordDocument \"uuid\" -}}\n" +
		"\n" +
		"Note the extra `-` after the opening `{{` and before the closing `}}`. This\n" +
		"instructs the template language to remove and whitespace before and after the\n" +
		"substitution. This removes any trailing newline added by your editor when saving\n" +
		"the template.\n" +
		"\n" +
		"### Use pass to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [pass](https://www.passwordstore.org/) using the\n" +
		"pass CLI.\n" +
		"\n" +
		"The first line of the output of `pass show <pass-name>` is available as the\n" +
		"`pass` template function, for example:\n" +
		"\n" +
		"    {{ pass \"<pass-name>\" }}\n" +
		"\n" +
		"### Use Vault to keep your secrets\n" +
		"\n" +
		"chezmoi includes support for [Vault](https://www.vaultproject.io/) using the\n" +
		"[Vault CLI](https://www.vaultproject.io/docs/commands/) to expose data as a\n" +
		"template function.\n" +
		"\n" +
		"The vault CLI needs to be correctly configured on your machine, e.g. the\n" +
		"`VAULT_ADDR` and `VAULT_TOKEN` environment variables must be set correctly.\n" +
		"Verify that this is the case by running:\n" +
		"\n" +
		"    vault kv get -format=json <key>\n" +
		"\n" +
		"The structured data from `vault kv get -format=json` is available as the `vault`\n" +
		"template function. You can use the `.Field` syntax of the `text/template`\n" +
		"language to extract the data you want. For example:\n" +
		"\n" +
		"    {{ (vault \"<key>\").data.data.password }}\n" +
		"\n" +
		"### Use a generic tool to keep your secrets\n" +
		"\n" +
		"You can use any command line tool that outputs secrets either as a string or in\n" +
		"JSON format. Choose the binary by setting `genericSecret.command` in your\n" +
		"configuration file. You can then invoke this command with the `secret` and\n" +
		"`secretJSON` template functions which return the raw output and JSON-decoded\n" +
		"output respectively. All of the above secret managers can be supported in this\n" +
		"way:\n" +
		"\n" +
		"| Secret Manager  | `genericSecret.command` | Template skeleton                                 |\n" +
		"| --------------- | ----------------------- | ------------------------------------------------- |\n" +
		"| 1Password       | `op`                    | `{{ secretJSON \"get\" \"item\" <id> }}`              |\n" +
		"| Bitwarden       | `bw`                    | `{{ secretJSON \"get\" <id> }}`                     |\n" +
		"| Hashicorp Vault | `vault`                 | `{{ secretJSON \"kv\" \"get\" \"-format=json\" <id> }}` |\n" +
		"| LastPass        | `lpass`                 | `{{ secretJSON \"show\" \"--json\" <id> }}`           |\n" +
		"| KeePassXC       | `keepassxc-cli`         | Not possible (interactive command only)           |\n" +
		"| pass            | `pass`                  | `{{ secret \"show\" <id> }}`                        |\n" +
		"\n" +
		"### Use templates variables to keep your secrets\n" +
		"\n" +
		"Typically, `~/.config/chezmoi/chezmoi.toml` is not checked in to version control\n" +
		"and has permissions 0600. You can store tokens as template values in the `data`\n" +
		"section. For example, if your `~/.config/chezmoi/chezmoi.toml` contains:\n" +
		"\n" +
		"    [data]\n" +
		"      [data.github]\n" +
		"        user = \"<github-username>\"\n" +
		"        token = \"<github-token>\"\n" +
		"\n" +
		"Your `~/.local/share/chezmoi/private_dot_gitconfig.tmpl` can then contain:\n" +
		"\n" +
		"    {{- if (index . \"github\") }}\n" +
		"    [github]\n" +
		"      user = \"{{ .github.user }}\"\n" +
		"      token = \"{{ .github.token }}\"\n" +
		"    {{- end }}\n" +
		"\n" +
		"Any config files containing tokens in plain text should be private (permissions\n" +
		"`0600`).\n" +
		"\n" +
		"## Use scripts to perform actions\n" +
		"\n" +
		"### Understand how scripts work\n" +
		"\n" +
		"chezmoi supports scripts, which are executed when you run `chezmoi apply`. The\n" +
		"scripts can either run every time you run `chezmoi apply`, or only when their\n" +
		"contents have changed.\n" +
		"\n" +
		"In verbose mode, the script's contents will be printed before executing it. In\n" +
		"dry-run mode, the script is not executed.\n" +
		"\n" +
		"Scripts are any file in the source directory with the prefix `run_`, and are\n" +
		"executed in alphabetical order. Scripts that should only be run when their\n" +
		"contents change have the prefix `run_once_`.\n" +
		"\n" +
		"Scripts break chezmoi's declarative approach, and as such should be used\n" +
		"sparingly. Any script should be idempotent, even `run_once_` scripts.\n" +
		"\n" +
		"Scripts must be created manually in the source directory, typically by running\n" +
		"`chezmoi cd` and then creating a file with a `run_` prefix. Scripts are executed\n" +
		"directly using `exec` and must include a shebang line or be executable binaries.\n" +
		"There is no need to set the executable bit on the script.\n" +
		"\n" +
		"Scripts with the suffix `.tmpl` are treated as templates, with the usual\n" +
		"template variables available. If, after executing the template, the result is\n" +
		"only whitespace or an empty string, then the script is not executed. This is\n" +
		"useful for disabling scripts.\n" +
		"\n" +
		"### Install packages with scripts\n" +
		"\n" +
		"Change to the source directory and create a file called\n" +
		"`run_once_install-packages.sh`:\n" +
		"\n" +
		"    chezmoi cd\n" +
		"    $EDITOR run_once_install-packages.sh\n" +
		"\n" +
		"In this file create your package installation script, e.g.\n" +
		"\n" +
		"    #!/bin/sh\n" +
		"    sudo apt install ripgrep\n" +
		"\n" +
		"The next time you run `chezmoi apply` or `chezmoi update` this script will be\n" +
		"run. As it has the `run_once_` prefix, it will not be run again unless its\n" +
		"contents change, for example if you add more packages to be installed.\n" +
		"\n" +
		"This script can also be a template. For example, if you create\n" +
		"`run_once_install-packages.sh.tmpl` with the contents:\n" +
		"\n" +
		"    {{ if eq .chezmoi.os \"linux\" -}}\n" +
		"    #!/bin/sh\n" +
		"    sudo apt install ripgrep\n" +
		"    {{ else if eq .chezmoi.os \"darwin\" -}}\n" +
		"    #!/bin/sh\n" +
		"    brew install ripgrep\n" +
		"    {{ end -}}\n" +
		"\n" +
		"This will install `ripgrep` on both Debian/Ubuntu Linux systems and macOS.\n" +
		"\n" +
		"## Use chezmoi with GitHub Codespaces, Visual Studio Codespaces, Visual Studio Code Remote - Containers\n" +
		"\n" +
		"The following assumes you are using chezmoi 1.8.4 or later. It does not work\n" +
		"with earlier versions of chezmoi.\n" +
		"\n" +
		"You can use chezmoi to manage your dotfiles in [GitHub\n" +
		"Codespaces](https://docs.github.com/en/github/developing-online-with-codespaces/personalizing-codespaces-for-your-account),\n" +
		"[Visual Studio\n" +
		"Codespaces](https://docs.microsoft.com/en/visualstudio/codespaces/reference/personalizing),\n" +
		"and [Visual Studio Code Remote -\n" +
		"Containers](https://code.visualstudio.com/docs/remote/containers#_personalizing-with-dotfile-repositories).\n" +
		"\n" +
		"For a quick start, you can clone the [`chezmoi/dotfiles`\n" +
		"repository](https://github.com/chezmoi/dotfiles) which supports Codespaces out\n" +
		"of the box.\n" +
		"\n" +
		"The workflow is different to using chezmoi on a new machine, notably:\n" +
		"* These systems will automatically clone your `dotfiles` repo to `~/dotfiles`,\n" +
		"  so there is no need to clone your repo yourself.\n" +
		"* The installation script must be non-interactive.\n" +
		"* When running in a Codespace, the environment variable `CODESPACES` will be set\n" +
		"  to `true`. You can read its value with the [`env` template\n" +
		"  function](http://masterminds.github.io/sprig/os.html).\n" +
		"\n" +
		"First, if you are using a chezmoi configuration file template, ensure that it is\n" +
		"non-interactive when running in codespaces, for example, `.chezmoi.toml.tmpl`\n" +
		"might contain:\n" +
		"\n" +
		"```\n" +
		"{{- $codespaces:= env \"CODESPACES\" | not | not -}}\n" +
		"sourceDir = \"{{ .chezmoi.sourceDir }}\"\n" +
		"\n" +
		"[data]\n" +
		"  name = \"Your name\"\n" +
		"  codespaces = {{ $codespaces }}\n" +
		"{{- if $codespaces }}{{/* Codespaces dotfiles setup is non-interactive, so set an email address */}}\n" +
		"  email = \"your@email.com\"\n" +
		"{{- else }}{{/* Interactive setup, so prompt for an email address */}}\n" +
		"  email = \"{{ promptString \"email\" }}\"\n" +
		"{{- end }}\n" +
		"```\n" +
		"\n" +
		"This sets the `codespaces` template variable, so you don't have to repeat `(env\n" +
		"\"CODESPACES\")` in your templates. It also sets the `sourceDir` configuration to\n" +
		"the `--source` argument passed in `chezmoi init`.\n" +
		"\n" +
		"Second, create an `install.sh` script that installs chezmoi and your dotfiles:\n" +
		"\n" +
		"```sh\n" +
		"#!/bin/sh\n" +
		"\n" +
		"set -e # -e: exit on error\n" +
		"\n" +
		"if [ ! \"$(command -v chezmoi)\" ]; then\n" +
		"  bin_dir=\"$HOME/.local/bin\"\n" +
		"  chezmoi=\"$bin_dir/chezmoi\"\n" +
		"  if [ \"$(command -v curl)\" ]; then\n" +
		"    sh -c \"$(curl -fsSL https://git.io/chezmoi)\" -- -b \"$bin_dir\"\n" +
		"  elif [ \"$(command -v wget)\" ]; then\n" +
		"    sh -c \"$(wget -qO- https://git.io/chezmoi)\" -- -b \"$bin_dir\"\n" +
		"  else\n" +
		"    echo \"To install chezmoi, you must have curl or wget installed.\" >&2\n" +
		"    exit 1\n" +
		"  fi\n" +
		"else\n" +
		"  chezmoi=chezmoi\n" +
		"fi\n" +
		"\n" +
		"# POSIX way to get script's dir: https://stackoverflow.com/a/29834779/12156188\n" +
		"script_dir=\"$(cd -P -- \"$(dirname -- \"$(command -v -- \"$0\")\")\" && pwd -P)\"\n" +
		"# exec: replace current process with chezmoi init\n" +
		"exec \"$chezmoi\" init --apply \"--source=$script_dir\"\n" +
		"```\n" +
		"\n" +
		"Ensure that this file is executable (`chmod a+x install.sh`), and add\n" +
		"`install.sh` to your `.chezmoiignore` file.\n" +
		"\n" +
		"It installs the latest version of chezmoi in `~/.local/bin` if needed, and then\n" +
		"`chezmoi init ...` invokes chezmoi to create its configuration file and\n" +
		"initialize your dotfiles. `--apply` tells chezmoi to apply the changes\n" +
		"immediately, and `--source=...` tells chezmoi where to find the cloned\n" +
		"`dotfiles` repo, which in this case is the same folder in which the script is\n" +
		"running from.\n" +
		"\n" +
		"If you do not use a chezmoi configuration file template you can use `chezmoi\n" +
		"apply --source=$HOME/dotfiles` instead of `chezmoi init ...` in `install.sh`.\n" +
		"\n" +
		"Finally, modify any of your templates to use the `codespaces` variable if\n" +
		"needed. For example, to install `vim-gtk` on Linux but not in Codespaces, your\n" +
		"`run_once_install-packages.sh.tmpl` might contain:\n" +
		"\n" +
		"```\n" +
		"{{- if (and (eq .chezmoi.os \"linux\")) (not .codespaces))) -}}\n" +
		"#!/bin/sh\n" +
		"sudo apt install -y vim-gtk\n" +
		"{{- end -}}\n" +
		"```\n" +
		"\n" +
		"## Detect Windows Subsystem for Linux (WSL)\n" +
		"\n" +
		"WSL can be detected by looking for the string `Microsoft` in\n" +
		"`/proc/kernel/osrelease`, which is available in the template variable\n" +
		"`.chezmoi.kernel.osrelease`, for example:\n" +
		"\n" +
		"WSL 1:\n" +
		"```\n" +
		"{{ if (contains \"Microsoft\" .chezmoi.kernel.osrelease) }}\n" +
		"# WSL-specific code\n" +
		"{{ end }}\n" +
		"```\n" +
		"\n" +
		"WSL 2:\n" +
		"```\n" +
		"{{ if (contains \"microsoft\" .chezmoi.kernel.osrelease) }}\n" +
		"# WSL-specific code\n" +
		"{{ end }}\n" +
		"```\n" +
		"\n" +
		"WSL 2 since version 4.19.112:\n" +
		"```\n" +
		"{{ if (contains \"microsoft-WSL2\" .chezmoi.kernel.osrelease) }}\n" +
		"# WSL-specific code\n" +
		"{{ end }}\n" +
		"```\n" +
		"\n" +
		"## Run a PowerShell script as admin on Windows\n" +
		"\n" +
		"Put the following at the top of your script:\n" +
		"\n" +
		"```powershell\n" +
		"# Self-elevate the script if required\n" +
		"if (-Not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] 'Administrator')) {\n" +
		"  if ([int](Get-CimInstance -Class Win32_OperatingSystem | Select-Object -ExpandProperty BuildNumber) -ge 6000) {\n" +
		"    $CommandLine = \"-NoExit -File `\"\" + $MyInvocation.MyCommand.Path + \"`\" \" + $MyInvocation.UnboundArguments\n" +
		"    Start-Process -FilePath PowerShell.exe -Verb Runas -ArgumentList $CommandLine\n" +
		"    Exit\n" +
		"  }\n" +
		"}\n" +
		"```\n" +
		"\n" +
		"## Import archives\n" +
		"\n" +
		"It is occasionally useful to import entire archives of configuration into your\n" +
		"source state. The `import` command does this. For example, to import the latest\n" +
		"version\n" +
		"[`github.com/robbyrussell/oh-my-zsh`](https://github.com/robbyrussell/oh-my-zsh)\n" +
		"to `~/.oh-my-zsh` run:\n" +
		"\n" +
		"    curl -s -L -o oh-my-zsh-master.tar.gz https://github.com/robbyrussell/oh-my-zsh/archive/master.tar.gz\n" +
		"    chezmoi import --strip-components 1 --destination ~/.oh-my-zsh oh-my-zsh-master.tar.gz\n" +
		"\n" +
		"Note that this only updates the source state. You will need to run\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"to update your destination directory.\n" +
		"\n" +
		"## Export archives\n" +
		"\n" +
		"chezmoi can create an archive containing the target state. This can be useful\n" +
		"for generating target state on a different machine or for simply inspecting the\n" +
		"target state. A particularly useful command is:\n" +
		"\n" +
		"    chezmoi archive | tar tvf -\n" +
		"\n" +
		"which lists all the targets in the target state.\n" +
		"\n" +
		"## Use a non-git version control system\n" +
		"\n" +
		"By default, chezmoi uses git, but you can use any version control system of your\n" +
		"choice. In your config file, specify the command to use. For example, to use\n" +
		"Mercurial specify:\n" +
		"\n" +
		"    [sourceVCS]\n" +
		"      command = \"hg\"\n" +
		"\n" +
		"The source VCS command is used in the chezmoi commands `init`, `source`, and\n" +
		"`update`, and support for VCSes other than git is limited but easy to add. If\n" +
		"you'd like to see your VCS better supported, please [open an issue on\n" +
		"GitHub](https://github.com/twpayne/chezmoi/issues/new/choose).\n" +
		"\n" +
		"## Customize the `diff` command\n" +
		"\n" +
		"By default, chezmoi uses a built-in diff. You can change the format, and/or pipe\n" +
		"the output into a pager of your choice. For example, to use\n" +
		"[`diff-so-fancy`](https://github.com/so-fancy/diff-so-fancy) specify:\n" +
		"\n" +
		"    [diff]\n" +
		"        format = \"git\"\n" +
		"        pager = \"diff-so-fancy\"\n" +
		"\n" +
		"The format can also be set with the `--format` option to the `diff` command, and\n" +
		"the pager can be disabled using `--no-pager`.\n" +
		"\n" +
		"## Use a merge tool other than vimdiff\n" +
		"\n" +
		"By default, chezmoi uses vimdiff, but you can use any merge tool of your choice.\n" +
		"In your config file, specify the command and args to use. For example, to use\n" +
		"neovim's diff mode specify:\n" +
		"\n" +
		"    [merge]\n" +
		"      command = \"nvim\"\n" +
		"      args = \"-d\"\n" +
		"\n" +
		"## Migrate from a dotfile manager that uses symlinks\n" +
		"\n" +
		"Many dotfile managers replace dotfiles with symbolic links to files in a common\n" +
		"directory. If you `chezmoi add` such a symlink, chezmoi will add the symlink,\n" +
		"not the file. To assist with migrating from symlink-based systems, use the\n" +
		"`--follow` option to `chezmoi add`, for example:\n" +
		"\n" +
		"    chezmoi add --follow ~/.bashrc\n" +
		"\n" +
		"This will tell `chezmoi add` that the target state of `~/.bashrc` is the target\n" +
		"of the `~/.bashrc` symlink, rather than the symlink itself. When you run\n" +
		"`chezmoi apply`, chezmoi will replace the `~/.bashrc` symlink with the file\n" +
		"contents.\n" +
		"\n")
	assets["docs/INSTALL.md"] = []byte("" +
		"# chezmoi Install Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [One-line binary install](#one-line-binary-install)\n" +
		"* [One-line package install](#one-line-package-install)\n" +
		"* [Pre-built Linux packages](#pre-built-linux-packages)\n" +
		"* [Pre-built binaries](#pre-built-binaries)\n" +
		"* [All pre-built Linux packages and binaries](#all-pre-built-linux-packages-and-binaries)\n" +
		"* [From source](#from-source)\n" +
		"* [Upgrading](#upgrading)\n" +
		"\n" +
		"## One-line binary install\n" +
		"\n" +
		"Install the correct binary for your operating system and architecture in `./bin`\n" +
		"with a single command.\n" +
		"\n" +
		"    curl -sfL https://git.io/chezmoi | sh\n" +
		"\n" +
		"Or on systems with Powershell, you can use this command:\n" +
		"\n" +
		"    # To install in ./bin\n" +
		"    (iwr https://git.io/chezmoi.ps1).Content | powershell -c -\n" +
		"\n" +
		"    # To install in another location\n" +
		"    '$params = \"-BinDir ~/other\"', (iwr https://git.io/chezmoi.ps1).Content | powershell -c -\n" +
		"\n" +
		"    # For information about other options, try this:\n" +
		"    '$params = \"-?\"', (iwr https://git.io/chezmoi.ps1).Content | powershell -c -\n" +
		"\n" +
		"## One-line package install\n" +
		"\n" +
		"Install chezmoi with a single command.\n" +
		"\n" +
		"| OS           | Method     | Command                                                                                     |\n" +
		"| ------------ | ---------- | ------------------------------------------------------------------------------------------- |\n" +
		"| Linux        | snap       | `snap install chezmoi --classic`                                                            |\n" +
		"| Linux        | Linuxbrew  | `brew install chezmoi`                                                                      |\n" +
		"| Alpine Linux | apk        | `apk add chezmoi`                                                                           |\n" +
		"| Arch Linux   | pacman     | `pacman -S chezmoi`                                                                         |\n" +
		"| Guix Linux   | guix       | `guix install chezmoi`                                                                      |\n" +
		"| NixOS Linux  | nix-env    | `nix-env -i chezmoi`                                                                        |\n" +
		"| Void Linux   | xbps       | `xbps-install -S chezmoi`                                                                   |\n" +
		"| macOS        | Homebrew   | `brew install chezmoi`                                                                      |\n" +
		"| macOS        | MacPorts   | `sudo port install chezmoi`                                                                 |\n" +
		"| Windows      | Scoop      | `scoop bucket add twpayne https://github.com/twpayne/scoop-bucket && scoop install chezmoi` |\n" +
		"| Windows      | Chocolatey | `choco install chezmoi`                                                                     |\n" +
		"\n" +
		"## Pre-built Linux packages\n" +
		"\n" +
		"Download a package for your operating system and architecture and install it\n" +
		"with your package manager.\n" +
		"\n" +
		"| Distribution | Architectures                                             | Package                                                     |\n" +
		"| ------------ | --------------------------------------------------------- | ----------------------------------------------------------- |\n" +
		"| Alpine       | `386`, `amd64`, `arm64`, `arm`, `ppc64`, `ppc64le`        | [`apk`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| Debian       | `amd64`, `arm64`, `armel`, `i386`, `ppc64`, `ppc64le`     | [`deb`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| RedHat       | `aarch64`, `armhfp`, `i686`, `ppc64`, `ppc64le`, `x86_64` | [`rpm`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| OpenSUSE     | `aarch64`, `armhfp`, `i686`, `ppc64`, `ppc64le`, `x86_64` | [`rpm`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| Ubuntu       | `amd64`, `arm64`, `armel`, `i386`, `ppc64`, `ppc64le`     | [`deb`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"\n" +
		"## Pre-built binaries\n" +
		"\n" +
		"Download an archive for your operating system containing a pre-built binary,\n" +
		"documentation, and shell completions.\n" +
		"\n" +
		"| OS         | Architectures                                       | Archive                                                        |\n" +
		"| ---------- | --------------------------------------------------- | -------------------------------------------------------------- |\n" +
		"| FreeBSD    | `amd64`, `arm`, `arm64`, `i386`                     | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| Linux      | `amd64`, `arm`, `arm64`, `i386`, `ppc64`, `ppc64le` | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| macOS      | `amd64`                                             | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| OpenBSD    | `amd64`, `arm`, `arm64`, `i386`                     | [`tar.gz`](https://github.com/twpayne/chezmoi/releases/latest) |\n" +
		"| Windows    | `amd64`, `i386`                                     | [`zip`](https://github.com/twpayne/chezmoi/releases/latest)    |\n" +
		"\n" +
		"## All pre-built Linux packages and binaries\n" +
		"\n" +
		"All pre-built binaries and packages can be found on the [chezmoi GitHub releases\n" +
		"page](https://github.com/twpayne/chezmoi/releases/latest).\n" +
		"\n" +
		"## From source\n" +
		"\n" +
		"Download, build, and install chezmoi for your system:\n" +
		"\n" +
		"    cd $(mktemp -d)\n" +
		"    git clone --depth=1 https://github.com/twpayne/chezmoi.git\n" +
		"    cd chezmoi\n" +
		"    go install\n" +
		"\n" +
		"Building chezmoi requires Go 1.14 or later.\n" +
		"\n" +
		"## Upgrading\n" +
		"\n" +
		"If you have installed a pre-built binary of chezmoi, you can upgrade it to the\n" +
		"latest release with:\n" +
		"\n" +
		"    chezmoi upgrade\n" +
		"\n" +
		"This will re-use whichever mechanism you used to install chezmoi to install the\n" +
		"latest release.\n" +
		"\n")
	assets["docs/MEDIA.md"] = []byte("" +
		"# chezmoi in the media\n" +
		"\n" +
		"<!-- toc -->\n" +
		"\n" +
		"Recommended article: [Fedora Magazine: Take back your dotfiles with Chezmoi](https://fedoramagazine.org/take-back-your-dotfiles-with-chezmoi/)\n" +
		"\n" +
		"Recommended video: [Conf42: chezmoi: Manage your dotfiles across multiple machines, securely](https://www.youtube.com/watch?v=JrCMCdvoMAw)\n" +
		"\n" +
		"Recommended podcast: [FLOSS weekly episode 556: chezmoi](https://twit.tv/shows/floss-weekly/episodes/556)\n" +
		"\n" +
		"| Date       | Version | Format      | Link                                                                                                                                                                                                                |\n" +
		"| ---------- | ------- | ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n" +
		"| 2021-02-06 | 1.8.10  | Video       | [chezmoi: manage your dotfiles across multiple, diverse machines, securely](https://fosdem.org/2021/schedule/event/chezmoi/)                                                                                        |\n" +
		"| 2021-01-12 | 1.8.10  | Text        | [Automating the Setup of a New Mac With All Your Apps, Preferences, and Development Tools](https://www.moncefbelyamani.com/automating-the-setup-of-a-new-mac-with-all-your-apps-preferences-and-development-tools/) |\n" +
		"| 2020-11-06 | 1.8.8   | Text        | [Chezmoi – Securely Manage dotfiles across multiple machines](https://computingforgeeks.com/chezmoi-manage-dotfiles-across-multiple-machines/)                                                                      |\n" +
		"| 2020-11-05 | 1.8.8   | Text        | [Using chezmoi to manage dotfiles](https://pashinskikh.de/posts/chezmoi/)                                                                                                                                           |\n" +
		"| 2020-10-05 | 1.8.6   | Text        | [Dotfiles with /Chezmoi/](https://blog.lazkani.io/posts/backup/dotfiles-with-chezmoi/)                                                                                                                              |\n" +
		"| 2020-08-13 | 1.8.3   | Text        | [Using BitWarden and Chezmoi to manage SSH keys](https://www.jx0.uk/chezmoi/bitwarden/unix/ssh/2020/08/13/bitwarden-chezmoi-ssh-key.html)                                                                           |\n" +
		"| 2020-08-09 | 1.8.3   | Text        | [Automating and testing dotfiles](https://seds.nl/posts/automating-and-testing-dotfiles/)                                                                                                                           |\n" +
		"| 2020-08-03 | 1.8.3   | Text        | [Automating a Linux in Windows Dev Setup](https://matt.aimonetti.net/posts/2020-08-automating-a-linux-in-windows-dev-setup/)                                                                                        |\n" +
		"| 2020-07-06 | 1.8.3   | Video       | [Conf42: chezmoi: Manage your dotfiles across multiple machines, securely](https://www.youtube.com/watch?v=JrCMCdvoMAw)                                                                                             |\n" +
		"| 2020-07-03 | 1.8.3   | Text        | [Feeling at home in a LXD container](https://ubuntu.com/blog/feeling-at-home-in-a-lxd-container)                                                                                                                    |\n" +
		"| 2020-06-15 | 1.8.2   | Text        | [Dotfiles management using chezmoi - How I Use Linux Desktop at Work Part5](https://blog.benoitj.ca/2020-06-15-how-i-use-linux-desktop-at-work-part5-dotfiles/)                                                     |\n" +
		"| 2020-04-27 | 1.8.0   | Text        | [Managing my dotfiles with chezmoi](http://blog.emilieschario.com/post/managing-my-dotfiles-with-chezmoi/)                                                                                                          |\n" +
		"| 2020-04-19 | 1.7.19  | Text (FR)   | [Git & dotfiles : versionner ses fichiers de configuration](https://www.armandphilippot.com/dotfiles-git-fichiers-configuration/)                                                                                   |\n" +
		"| 2020-04-16 | 1.7.19  | Text (FR)   | [Chezmoi, visite guidée](https://blog.wescale.fr/2020/04/16/chezmoi-visite-guidee/)                                                                                                                                 |\n" +
		"| 2020-04-03 | 1.7.17  | Text        | [Fedora Magazine: Take back your dotfiles with Chezmoi](https://fedoramagazine.org/take-back-your-dotfiles-with-chezmoi/)                                                                                           |\n" +
		"| 2020-04-01 | 1.7.17  | Text        | [Managing dotfiles and secret with chezmoi](https://blog.arkey.fr/2020/04/01/manage_dotfiles_with_chezmoi/)                                                                                                         |\n" +
		"| 2020-03-12 | 1.7.16  | Video       | [Managing Dotfiles with ChezMoi](https://www.youtube.com/watch?v=HXx6ugA98Qo)                                                                                                                                       |\n" +
		"| 2019-11-20 | 1.7.2   | Audio/video | [FLOSS weekly episode 556: chezmoi](https://twit.tv/shows/floss-weekly/episodes/556)                                                                                                                                |\n" +
		"| 2019-01-10 | 0.0.11  | Text        | [Linux Fu: The kitchen sync](https://hackaday.com/2019/01/10/linux-fu-the-kitchen-sync/)                                                                                                                            |\n" +
		"\n" +
		"To add your article to this page please either [open an\n" +
		"issue](https://github.com/twpayne/chezmoi/issues/new/choose) or submit a pull\n" +
		"request that modifies this file\n" +
		"([`docs/MEDIA.md`](https://github.com/twpayne/chezmoi/blob/master/docs/MEDIA.md)).\n" +
		"\n")
	assets["docs/QUICKSTART.md"] = []byte("" +
		"# chezmoi Quick Start Guide\n" +
		"\n" +
		"<!--- toc --->\n" +
		"* [Concepts](#concepts)\n" +
		"* [Start using chezmoi on your current machine](#start-using-chezmoi-on-your-current-machine)\n" +
		"* [Using chezmoi across multiple machines](#using-chezmoi-across-multiple-machines)\n" +
		"* [Next steps](#next-steps)\n" +
		"\n" +
		"## Concepts\n" +
		"\n" +
		"chezmoi stores the desired state of your dotfiles in the directory\n" +
		"`~/.local/share/chezmoi`. When you run `chezmoi apply`, chezmoi calculates the\n" +
		"desired contents and permissions for each dotfile and then makes any changes\n" +
		"necessary so that your dotfiles match that state.\n" +
		"\n" +
		"## Start using chezmoi on your current machine\n" +
		"\n" +
		"Initialize chezmoi:\n" +
		"\n" +
		"    chezmoi init\n" +
		"\n" +
		"This will create a new git repository in `~/.local/share/chezmoi` with\n" +
		"permissions `0700` where chezmoi will store the source state.  chezmoi only\n" +
		"modifies files in the working copy. It is your responsibility to commit changes.\n" +
		"\n" +
		"Manage an existing file with chezmoi:\n" +
		"\n" +
		"    chezmoi add ~/.bashrc\n" +
		"\n" +
		"This will copy `~/.bashrc` to `~/.local/share/chezmoi/dot_bashrc`. If you want\n" +
		"to add a whole folder to chezmoi, you have to add the `-r` argument after `add`.\n" +
		"\n" +
		"Edit the source state:\n" +
		"\n" +
		"    chezmoi edit ~/.bashrc\n" +
		"\n" +
		"This will open `~/.local/share/chezmoi/dot_bashrc` in your `$EDITOR`. Make some\n" +
		"changes and save them.\n" +
		"\n" +
		"See what changes chezmoi would make:\n" +
		"\n" +
		"    chezmoi diff\n" +
		"\n" +
		"Apply the changes:\n" +
		"\n" +
		"    chezmoi -v apply\n" +
		"\n" +
		"All chezmoi commands accept the `-v` (verbose) flag to print out exactly what\n" +
		"changes they will make to the file system, and the `-n` (dry run) flag to not\n" +
		"make any actual changes. The combination `-n` `-v` is very useful if you want to\n" +
		"see exactly what changes would be made.\n" +
		"\n" +
		"Finally, open a shell in the source directory, commit your changes, and return\n" +
		"to where you were:\n" +
		"\n" +
		"    chezmoi cd\n" +
		"    git add dot_bashrc\n" +
		"    git commit -m \"Add .bashrc\"\n" +
		"    exit\n" +
		"\n" +
		"## Using chezmoi across multiple machines\n" +
		"\n" +
		"Clone the git repo in `~/.local/share/chezmoi` to a hosted Git service, e.g.\n" +
		"[GitHub](https://github.com), [GitLab](https://gitlab.com), or\n" +
		"[BitBucket](https://bitbucket.org). Many people call their dotfiles repo\n" +
		"`dotfiles`. You can then setup chezmoi on a second machine:\n" +
		"\n" +
		"    chezmoi init https://github.com/username/dotfiles.git\n" +
		"\n" +
		"This will check out the repo and any submodules and optionally create a chezmoi\n" +
		"config file for you. It won't make any changes to your home directory until you\n" +
		"run:\n" +
		"\n" +
		"    chezmoi apply\n" +
		"\n" +
		"On any machine, you can pull and apply the latest changes from your repo with:\n" +
		"\n" +
		"    chezmoi update\n" +
		"\n" +
		"## Next steps\n" +
		"\n" +
		"For a full list of commands run:\n" +
		"\n" +
		"    chezmoi help\n" +
		"\n" +
		"chezmoi has much more functionality. Read the [how-to\n" +
		"guide](https://github.com/twpayne/chezmoi/blob/master/docs/HOWTO.md) to explore.\n" +
		"\n")
}
