// Code generated by github.com/bobesa/go-domain-util, DO NOT EDIT.

package domainutil

// tld contains single tld info
type tld map[string]*tld

// tlds holds all informations about correct tlds
var tlds = &tld{
	"aaa":      nil,
	"aarp":     nil,
	"abarth":   nil,
	"abb":      nil,
	"abbott":   nil,
	"abbvie":   nil,
	"abc":      nil,
	"able":     nil,
	"abogado":  nil,
	"abudhabi": nil,
	"ac": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
	},
	"academy": &tld{
		"official": nil,
	},
	"accenture":   nil,
	"accountant":  nil,
	"accountants": nil,
	"aco":         nil,
	"actor":       nil,
	"ad": &tld{
		"nom": nil,
	},
	"adac":  nil,
	"ads":   nil,
	"adult": nil,
	"ae": &tld{
		"ac":       nil,
		"blogspot": nil,
		"co":       nil,
		"gov":      nil,
		"mil":      nil,
		"net":      nil,
		"nom":      nil,
		"org":      nil,
		"sch":      nil,
	},
	"aeg": nil,
	"aero": &tld{
		"accident-investigation": nil,
		"accident-prevention":    nil,
		"aerobatic":              nil,
		"aeroclub":               nil,
		"aerodrome":              nil,
		"agents":                 nil,
		"air-surveillance":       nil,
		"air-traffic-control":    nil,
		"aircraft":               nil,
		"airline":                nil,
		"airport":                nil,
		"airtraffic":             nil,
		"ambulance":              nil,
		"amusement":              nil,
		"association":            nil,
		"author":                 nil,
		"ballooning":             nil,
		"broker":                 nil,
		"caa":                    nil,
		"cargo":                  nil,
		"catering":               nil,
		"certification":          nil,
		"championship":           nil,
		"charter":                nil,
		"civilaviation":          nil,
		"club":                   nil,
		"conference":             nil,
		"consultant":             nil,
		"consulting":             nil,
		"control":                nil,
		"council":                nil,
		"crew":                   nil,
		"design":                 nil,
		"dgca":                   nil,
		"educator":               nil,
		"emergency":              nil,
		"engine":                 nil,
		"engineer":               nil,
		"entertainment":          nil,
		"equipment":              nil,
		"exchange":               nil,
		"express":                nil,
		"federation":             nil,
		"flight":                 nil,
		"freight":                nil,
		"fuel":                   nil,
		"gliding":                nil,
		"government":             nil,
		"groundhandling":         nil,
		"group":                  nil,
		"hanggliding":            nil,
		"homebuilt":              nil,
		"insurance":              nil,
		"journal":                nil,
		"journalist":             nil,
		"leasing":                nil,
		"logistics":              nil,
		"magazine":               nil,
		"maintenance":            nil,
		"media":                  nil,
		"microlight":             nil,
		"modelling":              nil,
		"navigation":             nil,
		"parachuting":            nil,
		"paragliding":            nil,
		"passenger-association":  nil,
		"pilot":                  nil,
		"press":                  nil,
		"production":             nil,
		"recreation":             nil,
		"repbody":                nil,
		"res":                    nil,
		"research":               nil,
		"rotorcraft":             nil,
		"safety":                 nil,
		"scientist":              nil,
		"services":               nil,
		"show":                   nil,
		"skydiving":              nil,
		"software":               nil,
		"student":                nil,
		"trader":                 nil,
		"trading":                nil,
		"trainer":                nil,
		"union":                  nil,
		"workinggroup":           nil,
		"works":                  nil,
	},
	"aetna": nil,
	"af": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"afamilycompany": nil,
	"afl":            nil,
	"africa":         nil,
	"ag": &tld{
		"co":  nil,
		"com": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"agakhan": nil,
	"agency":  nil,
	"ai": &tld{
		"com": nil,
		"net": nil,
		"nom": nil,
		"off": nil,
		"org": nil,
		"uwu": nil,
	},
	"aig":      nil,
	"aigo":     nil,
	"airbus":   nil,
	"airforce": nil,
	"airtel":   nil,
	"akdn":     nil,
	"al": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"mil":      nil,
		"net":      nil,
		"nom":      nil,
		"org":      nil,
	},
	"alfaromeo": nil,
	"alibaba":   nil,
	"alipay":    nil,
	"allfinanz": nil,
	"allstate":  nil,
	"ally":      nil,
	"alsace":    nil,
	"alstom":    nil,
	"am": &tld{
		"blogspot": nil,
		"co":       nil,
		"com":      nil,
		"commune":  nil,
		"net":      nil,
		"org":      nil,
	},
	"americanexpress": nil,
	"americanfamily":  nil,
	"amex":            nil,
	"amfam":           nil,
	"amica":           nil,
	"amsterdam":       nil,
	"analytics":       nil,
	"android":         nil,
	"anquan":          nil,
	"anz":             nil,
	"ao": &tld{
		"co": nil,
		"ed": nil,
		"gv": nil,
		"it": nil,
		"og": nil,
		"pb": nil,
	},
	"aol":        nil,
	"apartments": nil,
	"app": &tld{
		"hasura":    nil,
		"loginline": nil,
		"run": &tld{
			"a": nil,
		},
		"telebit": nil,
		"web":     nil,
		"wnext":   nil,
	},
	"apple":     nil,
	"aq":        nil,
	"aquarelle": nil,
	"ar": &tld{
		"com": &tld{
			"blogspot": nil,
		},
		"edu":    nil,
		"gob":    nil,
		"gov":    nil,
		"int":    nil,
		"mil":    nil,
		"musica": nil,
		"net":    nil,
		"org":    nil,
		"tur":    nil,
	},
	"arab":   nil,
	"aramco": nil,
	"archi":  nil,
	"army":   nil,
	"arpa": &tld{
		"e164":    nil,
		"in-addr": nil,
		"ip6":     nil,
		"iris":    nil,
		"uri":     nil,
		"urn":     nil,
	},
	"art":  nil,
	"arte": nil,
	"as": &tld{
		"gov": nil,
	},
	"asda": nil,
	"asia": &tld{
		"cloudns": nil,
	},
	"associates": nil,
	"at": &tld{
		"12hp":  nil,
		"2ix":   nil,
		"4lima": nil,
		"ac":    nil,
		"biz":   nil,
		"co": &tld{
			"blogspot": nil,
		},
		"futurecms": &tld{
			"*": nil,
			"ex": &tld{
				"*": nil,
			},
			"in": &tld{
				"*": nil,
			},
		},
		"futurehosting": nil,
		"futuremailing": nil,
		"gv":            nil,
		"info":          nil,
		"lima-city":     nil,
		"or":            nil,
		"ortsinfo": &tld{
			"ex": &tld{
				"*": nil,
			},
			"kunden": &tld{
				"*": nil,
			},
		},
		"priv": nil,
	},
	"athleta":  nil,
	"attorney": nil,
	"au": &tld{
		"act": nil,
		"asn": nil,
		"com": &tld{
			"blogspot": nil,
		},
		"conf": nil,
		"edu": &tld{
			"act":      nil,
			"catholic": nil,
			"eq":       nil,
			"nsw": &tld{
				"schools": nil,
			},
			"nt":  nil,
			"qld": nil,
			"sa":  nil,
			"tas": &tld{
				"education": nil,
			},
			"vic": nil,
			"wa":  nil,
		},
		"gov": &tld{
			"qld": nil,
			"sa":  nil,
			"tas": nil,
			"vic": nil,
			"wa":  nil,
		},
		"id":   nil,
		"info": nil,
		"net":  nil,
		"nsw":  nil,
		"nt":   nil,
		"org":  nil,
		"oz":   nil,
		"qld":  nil,
		"sa":   nil,
		"tas":  nil,
		"vic":  nil,
		"wa":   nil,
	},
	"auction": nil,
	"audi":    nil,
	"audible": nil,
	"audio":   nil,
	"auspost": nil,
	"author":  nil,
	"auto":    nil,
	"autos":   nil,
	"avianca": nil,
	"aw": &tld{
		"com": nil,
	},
	"aws": nil,
	"ax":  nil,
	"axa": nil,
	"az": &tld{
		"biz":  nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"int":  nil,
		"mil":  nil,
		"name": nil,
		"net":  nil,
		"org":  nil,
		"pp":   nil,
		"pro":  nil,
	},
	"azure": nil,
	"ba": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"mil":      nil,
		"net":      nil,
		"org":      nil,
	},
	"baby":           nil,
	"baidu":          nil,
	"banamex":        nil,
	"bananarepublic": nil,
	"band":           nil,
	"bank":           nil,
	"bar":            nil,
	"barcelona":      nil,
	"barclaycard":    nil,
	"barclays":       nil,
	"barefoot":       nil,
	"bargains":       nil,
	"baseball":       nil,
	"basketball":     nil,
	"bauhaus":        nil,
	"bayern":         nil,
	"bb": &tld{
		"biz":   nil,
		"co":    nil,
		"com":   nil,
		"edu":   nil,
		"gov":   nil,
		"info":  nil,
		"net":   nil,
		"org":   nil,
		"store": nil,
		"tv":    nil,
	},
	"bbc":  nil,
	"bbt":  nil,
	"bbva": nil,
	"bcg":  nil,
	"bcn":  nil,
	"bd": &tld{
		"*": nil,
	},
	"be": &tld{
		"ac":       nil,
		"blogspot": nil,
		"transurl": &tld{
			"*": nil,
		},
		"webhosting": nil,
	},
	"beats":   nil,
	"beauty":  nil,
	"beer":    nil,
	"bentley": nil,
	"berlin":  nil,
	"best":    nil,
	"bestbuy": nil,
	"bet":     nil,
	"bf": &tld{
		"gov": nil,
	},
	"bg": &tld{
		"0":        nil,
		"1":        nil,
		"2":        nil,
		"3":        nil,
		"4":        nil,
		"5":        nil,
		"6":        nil,
		"7":        nil,
		"8":        nil,
		"9":        nil,
		"a":        nil,
		"b":        nil,
		"barsy":    nil,
		"blogspot": nil,
		"c":        nil,
		"d":        nil,
		"e":        nil,
		"f":        nil,
		"g":        nil,
		"h":        nil,
		"i":        nil,
		"j":        nil,
		"k":        nil,
		"l":        nil,
		"m":        nil,
		"n":        nil,
		"o":        nil,
		"p":        nil,
		"q":        nil,
		"r":        nil,
		"s":        nil,
		"t":        nil,
		"u":        nil,
		"v":        nil,
		"w":        nil,
		"x":        nil,
		"y":        nil,
		"z":        nil,
	},
	"bh": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"bharti": nil,
	"bi": &tld{
		"co":  nil,
		"com": nil,
		"edu": nil,
		"or":  nil,
		"org": nil,
	},
	"bible": nil,
	"bid":   nil,
	"bike":  nil,
	"bing":  nil,
	"bingo": nil,
	"bio":   nil,
	"biz": &tld{
		"bpl":        nil,
		"cloudns":    nil,
		"dscloud":    nil,
		"dyndns":     nil,
		"for-better": nil,
		"for-more":   nil,
		"for-some":   nil,
		"for-the":    nil,
		"mmafan":     nil,
		"myftp":      nil,
		"no-ip":      nil,
		"orx":        nil,
		"selfip":     nil,
		"webhop":     nil,
	},
	"bj": &tld{
		"asso":     nil,
		"barreau":  nil,
		"blogspot": nil,
		"gouv":     nil,
	},
	"black":       nil,
	"blackfriday": nil,
	"blockbuster": nil,
	"blog":        nil,
	"bloomberg":   nil,
	"blue":        nil,
	"bm": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"bms": nil,
	"bmw": nil,
	"bn": &tld{
		"co":  nil,
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"bnpparibas": nil,
	"bo": &tld{
		"academia":      nil,
		"agro":          nil,
		"arte":          nil,
		"blog":          nil,
		"bolivia":       nil,
		"ciencia":       nil,
		"com":           nil,
		"cooperativa":   nil,
		"democracia":    nil,
		"deporte":       nil,
		"ecologia":      nil,
		"economia":      nil,
		"edu":           nil,
		"empresa":       nil,
		"gob":           nil,
		"indigena":      nil,
		"industria":     nil,
		"info":          nil,
		"int":           nil,
		"medicina":      nil,
		"mil":           nil,
		"movimiento":    nil,
		"musica":        nil,
		"natural":       nil,
		"net":           nil,
		"nombre":        nil,
		"noticias":      nil,
		"org":           nil,
		"patria":        nil,
		"plurinacional": nil,
		"politica":      nil,
		"profesional":   nil,
		"pueblo":        nil,
		"revista":       nil,
		"salud":         nil,
		"tecnologia":    nil,
		"tksat":         nil,
		"transporte":    nil,
		"tv":            nil,
		"web":           nil,
		"wiki":          nil,
	},
	"boats":      nil,
	"boehringer": nil,
	"bofa":       nil,
	"bom":        nil,
	"bond":       nil,
	"boo":        nil,
	"book":       nil,
	"booking":    nil,
	"bosch":      nil,
	"bostik":     nil,
	"boston":     nil,
	"bot":        nil,
	"boutique":   nil,
	"box":        nil,
	"br": &tld{
		"9guacu":        nil,
		"abc":           nil,
		"adm":           nil,
		"adv":           nil,
		"agr":           nil,
		"aju":           nil,
		"am":            nil,
		"anani":         nil,
		"aparecida":     nil,
		"arq":           nil,
		"art":           nil,
		"ato":           nil,
		"b":             nil,
		"barueri":       nil,
		"belem":         nil,
		"bhz":           nil,
		"bio":           nil,
		"blog":          nil,
		"bmd":           nil,
		"boavista":      nil,
		"bsb":           nil,
		"campinagrande": nil,
		"campinas":      nil,
		"caxias":        nil,
		"cim":           nil,
		"cng":           nil,
		"cnt":           nil,
		"com": &tld{
			"blogspot": nil,
		},
		"contagem": nil,
		"coop":     nil,
		"cri":      nil,
		"cuiaba":   nil,
		"curitiba": nil,
		"def":      nil,
		"ecn":      nil,
		"eco":      nil,
		"edu":      nil,
		"emp":      nil,
		"eng":      nil,
		"esp":      nil,
		"etc":      nil,
		"eti":      nil,
		"far":      nil,
		"feira":    nil,
		"flog":     nil,
		"floripa":  nil,
		"fm":       nil,
		"fnd":      nil,
		"fortal":   nil,
		"fot":      nil,
		"foz":      nil,
		"fst":      nil,
		"g12":      nil,
		"ggf":      nil,
		"goiania":  nil,
		"gov": &tld{
			"ac": nil,
			"al": nil,
			"am": nil,
			"ap": nil,
			"ba": nil,
			"ce": nil,
			"df": nil,
			"es": nil,
			"go": nil,
			"ma": nil,
			"mg": nil,
			"ms": nil,
			"mt": nil,
			"pa": nil,
			"pb": nil,
			"pe": nil,
			"pi": nil,
			"pr": nil,
			"rj": nil,
			"rn": nil,
			"ro": nil,
			"rr": nil,
			"rs": nil,
			"sc": nil,
			"se": nil,
			"sp": nil,
			"to": nil,
		},
		"gru":       nil,
		"imb":       nil,
		"ind":       nil,
		"inf":       nil,
		"jab":       nil,
		"jampa":     nil,
		"jdf":       nil,
		"joinville": nil,
		"jor":       nil,
		"jus":       nil,
		"leg": &tld{
			"ac": nil,
			"al": nil,
			"am": nil,
			"ap": nil,
			"ba": nil,
			"ce": nil,
			"df": nil,
			"es": nil,
			"go": nil,
			"ma": nil,
			"mg": nil,
			"ms": nil,
			"mt": nil,
			"pa": nil,
			"pb": nil,
			"pe": nil,
			"pi": nil,
			"pr": nil,
			"rj": nil,
			"rn": nil,
			"ro": nil,
			"rr": nil,
			"rs": nil,
			"sc": nil,
			"se": nil,
			"sp": nil,
			"to": nil,
		},
		"lel":      nil,
		"londrina": nil,
		"macapa":   nil,
		"maceio":   nil,
		"manaus":   nil,
		"maringa":  nil,
		"mat":      nil,
		"med":      nil,
		"mil":      nil,
		"morena":   nil,
		"mp":       nil,
		"mus":      nil,
		"natal":    nil,
		"net":      nil,
		"niteroi":  nil,
		"nom": &tld{
			"*": nil,
		},
		"not":         nil,
		"ntr":         nil,
		"odo":         nil,
		"ong":         nil,
		"org":         nil,
		"osasco":      nil,
		"palmas":      nil,
		"poa":         nil,
		"ppg":         nil,
		"pro":         nil,
		"psc":         nil,
		"psi":         nil,
		"pvh":         nil,
		"qsl":         nil,
		"radio":       nil,
		"rec":         nil,
		"recife":      nil,
		"ribeirao":    nil,
		"rio":         nil,
		"riobranco":   nil,
		"riopreto":    nil,
		"salvador":    nil,
		"sampa":       nil,
		"santamaria":  nil,
		"santoandre":  nil,
		"saobernardo": nil,
		"saogonca":    nil,
		"sjc":         nil,
		"slg":         nil,
		"slz":         nil,
		"sorocaba":    nil,
		"srv":         nil,
		"taxi":        nil,
		"tc":          nil,
		"teo":         nil,
		"the":         nil,
		"tmp":         nil,
		"trd":         nil,
		"tur":         nil,
		"tv":          nil,
		"udi":         nil,
		"vet":         nil,
		"vix":         nil,
		"vlog":        nil,
		"wiki":        nil,
		"zlg":         nil,
	},
	"bradesco":    nil,
	"bridgestone": nil,
	"broadway":    nil,
	"broker":      nil,
	"brother":     nil,
	"brussels":    nil,
	"bs": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
		"we":  nil,
	},
	"bt": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"budapest": nil,
	"bugatti":  nil,
	"build":    nil,
	"builders": nil,
	"business": &tld{
		"co": nil,
	},
	"buy":  nil,
	"buzz": nil,
	"bv":   nil,
	"bw": &tld{
		"co":  nil,
		"org": nil,
	},
	"by": &tld{
		"com": &tld{
			"blogspot": nil,
		},
		"gov": nil,
		"mil": nil,
		"nym": nil,
		"of":  nil,
	},
	"bz": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"nym": nil,
		"org": nil,
		"za":  nil,
	},
	"bzh": nil,
	"ca": &tld{
		"ab": nil,
		"awdev": &tld{
			"*": nil,
		},
		"barsy":    nil,
		"bc":       nil,
		"blogspot": nil,
		"co":       nil,
		"gc":       nil,
		"mb":       nil,
		"nb":       nil,
		"nf":       nil,
		"nl":       nil,
		"no-ip":    nil,
		"ns":       nil,
		"nt":       nil,
		"nu":       nil,
		"on":       nil,
		"pe":       nil,
		"qc":       nil,
		"sk":       nil,
		"yk":       nil,
	},
	"cab":            nil,
	"cafe":           nil,
	"cal":            nil,
	"call":           nil,
	"calvinklein":    nil,
	"cam":            nil,
	"camera":         nil,
	"camp":           nil,
	"cancerresearch": nil,
	"canon":          nil,
	"capetown":       nil,
	"capital":        nil,
	"capitalone":     nil,
	"car":            nil,
	"caravan":        nil,
	"cards":          nil,
	"care":           nil,
	"career":         nil,
	"careers":        nil,
	"cars":           nil,
	"cartier":        nil,
	"casa": &tld{
		"nabu": &tld{
			"ui": nil,
		},
	},
	"case":     nil,
	"caseih":   nil,
	"cash":     nil,
	"casino":   nil,
	"cat":      nil,
	"catering": nil,
	"catholic": nil,
	"cba":      nil,
	"cbn":      nil,
	"cbre":     nil,
	"cbs":      nil,
	"cc": &tld{
		"cloudns":       nil,
		"fantasyleague": nil,
		"ftpaccess":     nil,
		"game-server":   nil,
		"myphotos":      nil,
		"scrapping":     nil,
		"twmail":        nil,
	},
	"cd": &tld{
		"gov": nil,
	},
	"ceb":    nil,
	"center": nil,
	"ceo":    nil,
	"cern":   nil,
	"cf": &tld{
		"blogspot": nil,
	},
	"cfa": nil,
	"cfd": nil,
	"cg":  nil,
	"ch": &tld{
		"12hp":           nil,
		"2ix":            nil,
		"4lima":          nil,
		"blogspot":       nil,
		"dnsking":        nil,
		"gotdns":         nil,
		"lima-city":      nil,
		"linkyard-cloud": nil,
		"square7":        nil,
	},
	"chanel":    nil,
	"channel":   nil,
	"charity":   nil,
	"chase":     nil,
	"chat":      nil,
	"cheap":     nil,
	"chintai":   nil,
	"christmas": nil,
	"chrome":    nil,
	"chrysler":  nil,
	"church":    nil,
	"ci": &tld{
		"ac":       nil,
		"asso":     nil,
		"aéroport": nil,
		"co":       nil,
		"com":      nil,
		"ed":       nil,
		"edu":      nil,
		"fin":      nil,
		"go":       nil,
		"gouv":     nil,
		"int":      nil,
		"md":       nil,
		"net":      nil,
		"or":       nil,
		"org":      nil,
		"presse":   nil,
	},
	"cipriani": nil,
	"circle":   nil,
	"cisco":    nil,
	"citadel":  nil,
	"citi":     nil,
	"citic":    nil,
	"city": &tld{
		"ng": nil,
	},
	"cityeats": nil,
	"ck": &tld{
		"!www": nil,
		"*":    nil,
	},
	"cl": &tld{
		"blogspot": nil,
		"co":       nil,
		"gob":      nil,
		"gov":      nil,
		"mil":      nil,
		"nom":      nil,
	},
	"claims":   nil,
	"cleaning": nil,
	"click":    nil,
	"clinic":   nil,
	"clinique": nil,
	"clothing": nil,
	"cloud": &tld{
		"linkyard": nil,
		"magentosite": &tld{
			"*": nil,
		},
		"on-rancher": &tld{
			"*": nil,
		},
		"sensiosite": &tld{
			"*": nil,
		},
		"statics": &tld{
			"*": nil,
		},
		"trafficplex": nil,
		"vapor":       nil,
		"voorloper":   nil,
	},
	"club": &tld{
		"barsy":   nil,
		"cloudns": nil,
		"pony":    nil,
	},
	"clubmed": nil,
	"cm": &tld{
		"co":  nil,
		"com": nil,
		"gov": nil,
		"net": nil,
	},
	"cn": &tld{
		"ac": nil,
		"ah": nil,
		"bj": nil,
		"com": &tld{
			"amazonaws": &tld{
				"cn-north-1": &tld{
					"s3": nil,
				},
				"compute": &tld{
					"*": nil,
				},
				"eb": &tld{
					"cn-north-1":     nil,
					"cn-northwest-1": nil,
				},
				"elb": &tld{
					"*": nil,
				},
			},
		},
		"cq":           nil,
		"edu":          nil,
		"fj":           nil,
		"gd":           nil,
		"gov":          nil,
		"gs":           nil,
		"gx":           nil,
		"gz":           nil,
		"ha":           nil,
		"hb":           nil,
		"he":           nil,
		"hi":           nil,
		"hk":           nil,
		"hl":           nil,
		"hn":           nil,
		"instantcloud": nil,
		"jl":           nil,
		"js":           nil,
		"jx":           nil,
		"ln":           nil,
		"mil":          nil,
		"mo":           nil,
		"net":          nil,
		"nm":           nil,
		"nx":           nil,
		"org":          nil,
		"qh":           nil,
		"sc":           nil,
		"sd":           nil,
		"sh":           nil,
		"sn":           nil,
		"sx":           nil,
		"tj":           nil,
		"tw":           nil,
		"xj":           nil,
		"xz":           nil,
		"yn":           nil,
		"zj":           nil,
		"公司":           nil,
		"網絡":           nil,
		"网络":           nil,
	},
	"co": &tld{
		"arts":  nil,
		"carrd": nil,
		"com": &tld{
			"blogspot": nil,
		},
		"crd":       nil,
		"edu":       nil,
		"firm":      nil,
		"go-vip":    nil,
		"gov":       nil,
		"info":      nil,
		"int":       nil,
		"leadpages": nil,
		"lpages":    nil,
		"mil":       nil,
		"mypi":      nil,
		"n4t":       nil,
		"net":       nil,
		"nodum":     nil,
		"nom":       nil,
		"org":       nil,
		"otap": &tld{
			"*": nil,
		},
		"rec":  nil,
		"repl": nil,
		"web":  nil,
	},
	"coach":   nil,
	"codes":   nil,
	"coffee":  nil,
	"college": nil,
	"cologne": nil,
	"com": &tld{
		"001www": nil,
		"0emm": &tld{
			"*": nil,
		},
		"1kapp":             nil,
		"3utilities":        nil,
		"4u":                nil,
		"africa":            nil,
		"alpha-myqnapcloud": nil,
		"amazonaws": &tld{
			"ap-northeast-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
			},
			"ap-northeast-2": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
			"ap-south-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
			"ap-southeast-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
			},
			"ap-southeast-2": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
			},
			"ca-central-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
			"compute": &tld{
				"*": nil,
			},
			"compute-1": &tld{
				"*": nil,
			},
			"elb": &tld{
				"*": nil,
			},
			"eu-central-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
			"eu-west-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
			},
			"eu-west-2": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
			"eu-west-3": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
			"s3":                        nil,
			"s3-ap-northeast-1":         nil,
			"s3-ap-northeast-2":         nil,
			"s3-ap-south-1":             nil,
			"s3-ap-southeast-1":         nil,
			"s3-ap-southeast-2":         nil,
			"s3-ca-central-1":           nil,
			"s3-eu-central-1":           nil,
			"s3-eu-west-1":              nil,
			"s3-eu-west-2":              nil,
			"s3-eu-west-3":              nil,
			"s3-external-1":             nil,
			"s3-fips-us-gov-west-1":     nil,
			"s3-sa-east-1":              nil,
			"s3-us-east-2":              nil,
			"s3-us-gov-west-1":          nil,
			"s3-us-west-1":              nil,
			"s3-us-west-2":              nil,
			"s3-website-ap-northeast-1": nil,
			"s3-website-ap-southeast-1": nil,
			"s3-website-ap-southeast-2": nil,
			"s3-website-eu-west-1":      nil,
			"s3-website-sa-east-1":      nil,
			"s3-website-us-east-1":      nil,
			"s3-website-us-west-1":      nil,
			"s3-website-us-west-2":      nil,
			"sa-east-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
			},
			"us-east-1": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
			},
			"us-east-2": &tld{
				"dualstack": &tld{
					"s3": nil,
				},
				"s3":         nil,
				"s3-website": nil,
			},
		},
		"appchizi":       nil,
		"applinzi":       nil,
		"appspot":        nil,
		"ar":             nil,
		"balena-devices": nil,
		"barsycenter":    nil,
		"barsyonline":    nil,
		"betainabox":     nil,
		"bitballoon":     nil,
		"blogdns":        nil,
		"blogspot":       nil,
		"blogsyte":       nil,
		"bloxcms":        nil,
		"bounty-full": &tld{
			"alpha": nil,
			"beta":  nil,
		},
		"bplaced":         nil,
		"br":              nil,
		"cechire":         nil,
		"ciscofreak":      nil,
		"cloudcontrolapp": nil,
		"cloudcontrolled": nil,
		"cn":              nil,
		"co":              nil,
		"codespot":        nil,
		"damnserver":      nil,
		"dattolocal":      nil,
		"dattorelay":      nil,
		"dattoweb":        nil,
		"ddnsfree":        nil,
		"ddnsgeek":        nil,
		"ddnsking":        nil,
		"ddnslive":        nil,
		"de":              nil,
		"dev-myqnapcloud": nil,
		"ditchyourip":     nil,
		"dnsalias":        nil,
		"dnsdojo":         nil,
		"dnsiskinky":      nil,
		"doesntexist":     nil,
		"dontexist":       nil,
		"doomdns":         nil,
		"drayddns":        nil,
		"dreamhosters":    nil,
		"dsmynas":         nil,
		"dyn-o-saur":      nil,
		"dynalias":        nil,
		"dyndns-at-home":  nil,
		"dyndns-at-work":  nil,
		"dyndns-blog":     nil,
		"dyndns-free":     nil,
		"dyndns-home":     nil,
		"dyndns-ip":       nil,
		"dyndns-mail":     nil,
		"dyndns-office":   nil,
		"dyndns-pics":     nil,
		"dyndns-remote":   nil,
		"dyndns-server":   nil,
		"dyndns-web":      nil,
		"dyndns-wiki":     nil,
		"dyndns-work":     nil,
		"dynns":           nil,
		"elasticbeanstalk": &tld{
			"ap-northeast-1": nil,
			"ap-northeast-2": nil,
			"ap-northeast-3": nil,
			"ap-south-1":     nil,
			"ap-southeast-1": nil,
			"ap-southeast-2": nil,
			"ca-central-1":   nil,
			"eu-central-1":   nil,
			"eu-west-1":      nil,
			"eu-west-2":      nil,
			"eu-west-3":      nil,
			"sa-east-1":      nil,
			"us-east-1":      nil,
			"us-east-2":      nil,
			"us-gov-west-1":  nil,
			"us-west-1":      nil,
			"us-west-2":      nil,
		},
		"est-a-la-maison":  nil,
		"est-a-la-masion":  nil,
		"est-le-patron":    nil,
		"est-mon-blogueur": nil,
		"eu":               nil,
		"evennode": &tld{
			"eu-1": nil,
			"eu-2": nil,
			"eu-3": nil,
			"eu-4": nil,
			"us-1": nil,
			"us-2": nil,
			"us-3": nil,
			"us-4": nil,
		},
		"familyds":         nil,
		"fastly-terrarium": nil,
		"fastvps-server":   nil,
		"fbsbx": &tld{
			"apps": nil,
		},
		"firebaseapp":           nil,
		"firewall-gateway":      nil,
		"flynnhub":              nil,
		"freebox-os":            nil,
		"freeboxos":             nil,
		"from-ak":               nil,
		"from-al":               nil,
		"from-ar":               nil,
		"from-ca":               nil,
		"from-ct":               nil,
		"from-dc":               nil,
		"from-de":               nil,
		"from-fl":               nil,
		"from-ga":               nil,
		"from-hi":               nil,
		"from-ia":               nil,
		"from-id":               nil,
		"from-il":               nil,
		"from-in":               nil,
		"from-ks":               nil,
		"from-ky":               nil,
		"from-ma":               nil,
		"from-md":               nil,
		"from-mi":               nil,
		"from-mn":               nil,
		"from-mo":               nil,
		"from-ms":               nil,
		"from-mt":               nil,
		"from-nc":               nil,
		"from-nd":               nil,
		"from-ne":               nil,
		"from-nh":               nil,
		"from-nj":               nil,
		"from-nm":               nil,
		"from-nv":               nil,
		"from-oh":               nil,
		"from-ok":               nil,
		"from-or":               nil,
		"from-pa":               nil,
		"from-pr":               nil,
		"from-ri":               nil,
		"from-sc":               nil,
		"from-sd":               nil,
		"from-tn":               nil,
		"from-tx":               nil,
		"from-ut":               nil,
		"from-va":               nil,
		"from-vt":               nil,
		"from-wa":               nil,
		"from-wi":               nil,
		"from-wv":               nil,
		"from-wy":               nil,
		"gb":                    nil,
		"geekgalaxy":            nil,
		"getmyip":               nil,
		"giize":                 nil,
		"githubusercontent":     nil,
		"gleeze":                nil,
		"googleapis":            nil,
		"googlecode":            nil,
		"gotdns":                nil,
		"gotpantheon":           nil,
		"gr":                    nil,
		"health-carereform":     nil,
		"herokuapp":             nil,
		"herokussl":             nil,
		"hk":                    nil,
		"hobby-site":            nil,
		"homelinux":             nil,
		"homesecuritymac":       nil,
		"homesecuritypc":        nil,
		"homeunix":              nil,
		"hu":                    nil,
		"iamallama":             nil,
		"is-a-anarchist":        nil,
		"is-a-blogger":          nil,
		"is-a-bookkeeper":       nil,
		"is-a-bulls-fan":        nil,
		"is-a-caterer":          nil,
		"is-a-chef":             nil,
		"is-a-conservative":     nil,
		"is-a-cpa":              nil,
		"is-a-cubicle-slave":    nil,
		"is-a-democrat":         nil,
		"is-a-designer":         nil,
		"is-a-doctor":           nil,
		"is-a-financialadvisor": nil,
		"is-a-geek":             nil,
		"is-a-green":            nil,
		"is-a-guru":             nil,
		"is-a-hard-worker":      nil,
		"is-a-hunter":           nil,
		"is-a-landscaper":       nil,
		"is-a-lawyer":           nil,
		"is-a-liberal":          nil,
		"is-a-libertarian":      nil,
		"is-a-llama":            nil,
		"is-a-musician":         nil,
		"is-a-nascarfan":        nil,
		"is-a-nurse":            nil,
		"is-a-painter":          nil,
		"is-a-personaltrainer":  nil,
		"is-a-photographer":     nil,
		"is-a-player":           nil,
		"is-a-republican":       nil,
		"is-a-rockstar":         nil,
		"is-a-socialist":        nil,
		"is-a-student":          nil,
		"is-a-teacher":          nil,
		"is-a-techie":           nil,
		"is-a-therapist":        nil,
		"is-an-accountant":      nil,
		"is-an-actor":           nil,
		"is-an-actress":         nil,
		"is-an-anarchist":       nil,
		"is-an-artist":          nil,
		"is-an-engineer":        nil,
		"is-an-entertainer":     nil,
		"is-certified":          nil,
		"is-gone":               nil,
		"is-into-anime":         nil,
		"is-into-cars":          nil,
		"is-into-cartoons":      nil,
		"is-into-games":         nil,
		"is-leet":               nil,
		"is-not-certified":      nil,
		"is-slick":              nil,
		"is-uberleet":           nil,
		"is-with-theband":       nil,
		"isa-geek":              nil,
		"isa-hockeynut":         nil,
		"issmarterthanyou":      nil,
		"jdevcloud":             nil,
		"joyent": &tld{
			"cns": &tld{
				"*": nil,
			},
		},
		"jpn":        nil,
		"kozow":      nil,
		"kr":         nil,
		"likes-pie":  nil,
		"likescandy": nil,
		"linode": &tld{
			"members":      nil,
			"nodebalancer": nil,
		},
		"lmpm": &tld{
			"app": nil,
		},
		"logoip":        nil,
		"loseyourip":    nil,
		"lpusercontent": nil,
		"meteorapp": &tld{
			"eu": nil,
		},
		"mex":                nil,
		"miniserver":         nil,
		"myactivedirectory":  nil,
		"myasustor":          nil,
		"mydatto":            nil,
		"mydobiss":           nil,
		"mydrobo":            nil,
		"myiphost":           nil,
		"myqnapcloud":        nil,
		"myravendb":          nil,
		"mysecuritycamera":   nil,
		"myshopblocks":       nil,
		"mytuleap":           nil,
		"myvnc":              nil,
		"neat-url":           nil,
		"net-freaks":         nil,
		"netlify":            nil,
		"nfshost":            nil,
		"no":                 nil,
		"on-aptible":         nil,
		"onrender":           nil,
		"onthewifi":          nil,
		"ooguy":              nil,
		"operaunite":         nil,
		"outsystemscloud":    nil,
		"ownprovider":        nil,
		"pagefrontapp":       nil,
		"pagespeedmobilizer": nil,
		"pgfog":              nil,
		"pixolino":           nil,
		"point2this":         nil,
		"prgmr": &tld{
			"xen": nil,
		},
		"publishproxy": nil,
		"qa2":          nil,
		"qc":           nil,
		"qualifioapp":  nil,
		"quicksytes":   nil,
		"quipelements": &tld{
			"*": nil,
		},
		"rackmaze": nil,
		"remotewd": nil,
		"render": &tld{
			"app": nil,
		},
		"rhcloud":            nil,
		"ru":                 nil,
		"sa":                 nil,
		"saves-the-whales":   nil,
		"scrysec":            nil,
		"securitytactics":    nil,
		"selfip":             nil,
		"sells-for-less":     nil,
		"sells-for-u":        nil,
		"servebbs":           nil,
		"servebeer":          nil,
		"servecounterstrike": nil,
		"serveexchange":      nil,
		"serveftp":           nil,
		"servegame":          nil,
		"servehalflife":      nil,
		"servehttp":          nil,
		"servehumour":        nil,
		"serveirc":           nil,
		"servemp3":           nil,
		"servep2p":           nil,
		"servepics":          nil,
		"servequake":         nil,
		"servesarcasm":       nil,
		"shopitsite":         nil,
		"simple-url":         nil,
		"sinaapp":            nil,
		"space-to-rent":      nil,
		"stackhero-network":  nil,
		"stdlib": &tld{
			"api": nil,
		},
		"stufftoread":      nil,
		"teaches-yoga":     nil,
		"temp-dns":         nil,
		"theworkpc":        nil,
		"thingdustdata":    nil,
		"townnews-staging": nil,
		"trycloudflare":    nil,
		"uk":               nil,
		"unusualperson":    nil,
		"us":               nil,
		"uy":               nil,
		"vipsinaapp":       nil,
		"wafflecell":       nil,
		"withgoogle":       nil,
		"withyoutube":      nil,
		"workisboring":     nil,
		"wpcomstaging":     nil,
		"wpdevcloud":       nil,
		"writesthisblog":   nil,
		"xenapponazure":    nil,
		"xnbay": &tld{
			"u2":       nil,
			"u2-local": nil,
		},
		"yolasite": nil,
		"za":       nil,
	},
	"comcast":  nil,
	"commbank": nil,
	"community": &tld{
		"ravendb": nil,
	},
	"company":        nil,
	"compare":        nil,
	"computer":       nil,
	"comsec":         nil,
	"condos":         nil,
	"construction":   nil,
	"consulting":     nil,
	"contact":        nil,
	"contractors":    nil,
	"cooking":        nil,
	"cookingchannel": nil,
	"cool": &tld{
		"de": nil,
	},
	"coop":    nil,
	"corsica": nil,
	"country": nil,
	"coupon":  nil,
	"coupons": nil,
	"courses": nil,
	"cpa":     nil,
	"cr": &tld{
		"ac": nil,
		"co": nil,
		"ed": nil,
		"fi": nil,
		"go": nil,
		"or": nil,
		"sa": nil,
	},
	"credit":      nil,
	"creditcard":  nil,
	"creditunion": nil,
	"cricket":     nil,
	"crown":       nil,
	"crs":         nil,
	"cruise":      nil,
	"cruises":     nil,
	"csc":         nil,
	"cu": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"inf": nil,
		"net": nil,
		"org": nil,
	},
	"cuisinella": nil,
	"cv": &tld{
		"blogspot": nil,
	},
	"cw": &tld{
		"com": nil,
		"edu": nil,
		"net": nil,
		"org": nil,
	},
	"cx": &tld{
		"ath":  nil,
		"gov":  nil,
		"info": nil,
	},
	"cy": &tld{
		"ac":  nil,
		"biz": nil,
		"com": &tld{
			"blogspot": nil,
		},
		"ekloges":    nil,
		"gov":        nil,
		"ltd":        nil,
		"name":       nil,
		"net":        nil,
		"org":        nil,
		"parliament": nil,
		"press":      nil,
		"pro":        nil,
		"tm":         nil,
	},
	"cymru": nil,
	"cyou":  nil,
	"cz": &tld{
		"blogspot": nil,
		"co":       nil,
		"e4":       nil,
		"metacentrum": &tld{
			"cloud":  nil,
			"custom": nil,
		},
		"muni": &tld{
			"cloud": &tld{
				"flt": nil,
				"usr": nil,
			},
		},
		"realm": nil,
	},
	"dabur":  nil,
	"dad":    nil,
	"dance":  nil,
	"data":   nil,
	"date":   nil,
	"dating": nil,
	"datsun": nil,
	"day":    nil,
	"dclk":   nil,
	"dds":    nil,
	"de": &tld{
		"12hp":     nil,
		"2ix":      nil,
		"4lima":    nil,
		"barsy":    nil,
		"blogspot": nil,
		"bplaced":  nil,
		"com":      nil,
		"cosidns": &tld{
			"dyn": nil,
		},
		"dd-dns": nil,
		"ddnss": &tld{
			"dyn":    nil,
			"dyndns": nil,
		},
		"dnshome":          nil,
		"dnsupdater":       nil,
		"dray-dns":         nil,
		"draydns":          nil,
		"dyn-berlin":       nil,
		"dyn-ip24":         nil,
		"dyn-vpn":          nil,
		"dynamisches-dns":  nil,
		"dyndns1":          nil,
		"dynvpn":           nil,
		"firewall-gateway": nil,
		"fuettertdasnetz":  nil,
		"git-repos":        nil,
		"goip":             nil,
		"home-webserver": &tld{
			"dyn": nil,
		},
		"in-berlin":     nil,
		"in-brb":        nil,
		"in-butter":     nil,
		"in-dsl":        nil,
		"in-vpn":        nil,
		"internet-dns":  nil,
		"isteingeek":    nil,
		"istmein":       nil,
		"keymachine":    nil,
		"l-o-g-i-n":     nil,
		"lcube-server":  nil,
		"lebtimnetz":    nil,
		"leitungsen":    nil,
		"lima-city":     nil,
		"logoip":        nil,
		"mein-iserv":    nil,
		"mein-vigor":    nil,
		"my-gateway":    nil,
		"my-router":     nil,
		"my-vigor":      nil,
		"my-wan":        nil,
		"myhome-server": nil,
		"spdns":         nil,
		"speedpartner": &tld{
			"customer": nil,
		},
		"square7":              nil,
		"svn-repos":            nil,
		"syno-ds":              nil,
		"synology-diskstation": nil,
		"synology-ds":          nil,
		"taifun-dns":           nil,
		"test-iserv":           nil,
		"traeumtgerade":        nil,
		"uberspace": &tld{
			"*": nil,
		},
		"virtual-user": nil,
		"virtualuser":  nil,
	},
	"deal":     nil,
	"dealer":   nil,
	"deals":    nil,
	"degree":   nil,
	"delivery": nil,
	"dell":     nil,
	"deloitte": nil,
	"delta":    nil,
	"democrat": nil,
	"dental":   nil,
	"dentist":  nil,
	"desi":     nil,
	"design": &tld{
		"bss": nil,
	},
	"dev": &tld{
		"iserv": nil,
		"lcl": &tld{
			"*": nil,
		},
		"loginline": nil,
		"stg": &tld{
			"*": nil,
		},
		"webhare": &tld{
			"*": nil,
		},
		"workers": nil,
	},
	"dhl":      nil,
	"diamonds": nil,
	"diet":     nil,
	"digital": &tld{
		"cloudapps": &tld{
			"london": nil,
		},
	},
	"direct": &tld{
		"fastpanel": nil,
	},
	"directory": nil,
	"discount":  nil,
	"discover":  nil,
	"dish":      nil,
	"diy":       nil,
	"dj":        nil,
	"dk": &tld{
		"biz":      nil,
		"blogspot": nil,
		"co":       nil,
		"firm":     nil,
		"reg":      nil,
		"store":    nil,
	},
	"dm": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"dnp": nil,
	"do": &tld{
		"art": nil,
		"com": nil,
		"edu": nil,
		"gob": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
		"sld": nil,
		"web": nil,
	},
	"docs":     nil,
	"doctor":   nil,
	"dodge":    nil,
	"dog":      nil,
	"domains":  nil,
	"dot":      nil,
	"download": nil,
	"drive":    nil,
	"dtv":      nil,
	"dubai":    nil,
	"duck":     nil,
	"dunlop":   nil,
	"dupont":   nil,
	"durban":   nil,
	"dvag":     nil,
	"dvr":      nil,
	"dz": &tld{
		"art":  nil,
		"asso": nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"net":  nil,
		"org":  nil,
		"pol":  nil,
	},
	"earth": &tld{
		"dapps": &tld{
			"*": nil,
			"bzz": &tld{
				"*": nil,
			},
		},
	},
	"eat": nil,
	"ec": &tld{
		"com":  nil,
		"edu":  nil,
		"fin":  nil,
		"gob":  nil,
		"gov":  nil,
		"info": nil,
		"k12":  nil,
		"med":  nil,
		"mil":  nil,
		"net":  nil,
		"nym":  nil,
		"org":  nil,
		"pro":  nil,
	},
	"eco":   nil,
	"edeka": nil,
	"edu": &tld{
		"rit": &tld{
			"git-pages": nil,
		},
	},
	"education": &tld{
		"co": nil,
	},
	"ee": &tld{
		"aip": nil,
		"com": &tld{
			"blogspot": nil,
		},
		"edu":  nil,
		"fie":  nil,
		"gov":  nil,
		"lib":  nil,
		"med":  nil,
		"org":  nil,
		"pri":  nil,
		"riik": nil,
	},
	"eg": &tld{
		"com": &tld{
			"blogspot": nil,
		},
		"edu":  nil,
		"eun":  nil,
		"gov":  nil,
		"mil":  nil,
		"name": nil,
		"net":  nil,
		"org":  nil,
		"sci":  nil,
	},
	"email":       nil,
	"emerck":      nil,
	"energy":      nil,
	"engineer":    nil,
	"engineering": nil,
	"enterprises": nil,
	"epson":       nil,
	"equipment":   nil,
	"er": &tld{
		"*": nil,
	},
	"ericsson": nil,
	"erni":     nil,
	"es": &tld{
		"com": &tld{
			"blogspot": nil,
		},
		"edu": nil,
		"gob": nil,
		"nom": nil,
		"org": nil,
	},
	"esq": nil,
	"estate": &tld{
		"compute": &tld{
			"*": nil,
		},
	},
	"esurance": nil,
	"et": &tld{
		"biz":  nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"name": nil,
		"net":  nil,
		"org":  nil,
	},
	"etisalat": nil,
	"eu": &tld{
		"barsy":       nil,
		"cloudns":     nil,
		"diskstation": nil,
		"mycd":        nil,
		"spdns":       nil,
		"transurl": &tld{
			"*": nil,
		},
		"wellbeingzone": nil,
	},
	"eurovision": nil,
	"eus": &tld{
		"party": &tld{
			"user": nil,
		},
	},
	"events": &tld{
		"co": nil,
	},
	"everbank":   nil,
	"exchange":   nil,
	"expert":     nil,
	"exposed":    nil,
	"express":    nil,
	"extraspace": nil,
	"fage":       nil,
	"fail":       nil,
	"fairwinds":  nil,
	"faith": &tld{
		"ybo": nil,
	},
	"family": nil,
	"fan":    nil,
	"fans":   nil,
	"farm": &tld{
		"storj": nil,
	},
	"farmers": nil,
	"fashion": &tld{
		"of": nil,
		"on": nil,
	},
	"fast":     nil,
	"fedex":    nil,
	"feedback": nil,
	"ferrari":  nil,
	"ferrero":  nil,
	"fi": &tld{
		"aland":    nil,
		"blogspot": nil,
		"dy":       nil,
		"häkkinen": nil,
		"iki":      nil,
	},
	"fiat":     nil,
	"fidelity": nil,
	"fido":     nil,
	"film":     nil,
	"final":    nil,
	"finance":  nil,
	"financial": &tld{
		"co": nil,
	},
	"fire":      nil,
	"firestone": nil,
	"firmdale":  nil,
	"fish":      nil,
	"fishing":   nil,
	"fit": &tld{
		"ptplus": nil,
	},
	"fitness": nil,
	"fj": &tld{
		"*": nil,
	},
	"fk": &tld{
		"*": nil,
	},
	"flickr":      nil,
	"flights":     nil,
	"flir":        nil,
	"florist":     nil,
	"flowers":     nil,
	"fly":         nil,
	"fm":          nil,
	"fo":          nil,
	"foo":         nil,
	"food":        nil,
	"foodnetwork": nil,
	"football": &tld{
		"of": nil,
	},
	"ford":       nil,
	"forex":      nil,
	"forsale":    nil,
	"forum":      nil,
	"foundation": nil,
	"fox":        nil,
	"fr": &tld{
		"aeroport":                        nil,
		"asso":                            nil,
		"avocat":                          nil,
		"avoues":                          nil,
		"blogspot":                        nil,
		"cci":                             nil,
		"chambagri":                       nil,
		"chirurgiens-dentistes":           nil,
		"chirurgiens-dentistes-en-france": nil,
		"com":                             nil,
		"experts-comptables":              nil,
		"fbx-os":                          nil,
		"fbxos":                           nil,
		"freebox-os":                      nil,
		"freeboxos":                       nil,
		"geometre-expert":                 nil,
		"gouv":                            nil,
		"greta":                           nil,
		"huissier-justice":                nil,
		"medecin":                         nil,
		"nom":                             nil,
		"notaires":                        nil,
		"on-web":                          nil,
		"pharmacien":                      nil,
		"port":                            nil,
		"prd":                             nil,
		"tm":                              nil,
		"veterinaire":                     nil,
	},
	"free":      nil,
	"fresenius": nil,
	"frl":       nil,
	"frogans":   nil,
	"frontdoor": nil,
	"frontier":  nil,
	"ftr":       nil,
	"fujitsu":   nil,
	"fujixerox": nil,
	"fun":       nil,
	"fund":      nil,
	"furniture": nil,
	"futbol":    nil,
	"fyi":       nil,
	"ga":        nil,
	"gal":       nil,
	"gallery":   nil,
	"gallo":     nil,
	"gallup":    nil,
	"game":      nil,
	"games":     nil,
	"gap":       nil,
	"garden":    nil,
	"gay":       nil,
	"gb":        nil,
	"gbiz":      nil,
	"gd": &tld{
		"nom": nil,
	},
	"gdn": &tld{
		"cnpy": nil,
	},
	"ge": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
		"pvt": nil,
	},
	"gea":     nil,
	"gent":    nil,
	"genting": nil,
	"george":  nil,
	"gf":      nil,
	"gg": &tld{
		"co":   nil,
		"cya":  nil,
		"kaas": nil,
		"net":  nil,
		"org":  nil,
	},
	"ggee": nil,
	"gh": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"org": nil,
	},
	"gi": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"ltd": nil,
		"mod": nil,
		"org": nil,
	},
	"gift":   nil,
	"gifts":  nil,
	"gives":  nil,
	"giving": nil,
	"gl": &tld{
		"biz": nil,
		"co":  nil,
		"com": nil,
		"edu": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"glade":  nil,
	"glass":  nil,
	"gle":    nil,
	"global": nil,
	"globo":  nil,
	"gm":     nil,
	"gmail":  nil,
	"gmbh":   nil,
	"gmo":    nil,
	"gmx":    nil,
	"gn": &tld{
		"ac":  nil,
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"godaddy":   nil,
	"gold":      nil,
	"goldpoint": nil,
	"golf":      nil,
	"goo":       nil,
	"goodyear":  nil,
	"goog": &tld{
		"cloud": nil,
	},
	"google": nil,
	"gop":    nil,
	"got":    nil,
	"gov":    nil,
	"gp": &tld{
		"asso": nil,
		"com":  nil,
		"edu":  nil,
		"mobi": nil,
		"net":  nil,
		"org":  nil,
	},
	"gq": nil,
	"gr": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"net":      nil,
		"nym":      nil,
		"org":      nil,
	},
	"grainger": nil,
	"graphics": nil,
	"gratis":   nil,
	"green":    nil,
	"gripe":    nil,
	"grocery":  nil,
	"group": &tld{
		"discourse": nil,
	},
	"gs": nil,
	"gt": &tld{
		"com": nil,
		"edu": nil,
		"gob": nil,
		"ind": nil,
		"mil": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"gu": &tld{
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"guam": nil,
		"info": nil,
		"net":  nil,
		"org":  nil,
		"web":  nil,
	},
	"guardian": nil,
	"gucci":    nil,
	"guge":     nil,
	"guide":    nil,
	"guitars":  nil,
	"guru":     nil,
	"gw":       nil,
	"gy": &tld{
		"co":  nil,
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"nym": nil,
		"org": nil,
	},
	"hair":       nil,
	"hamburg":    nil,
	"hangout":    nil,
	"haus":       nil,
	"hbo":        nil,
	"hdfc":       nil,
	"hdfcbank":   nil,
	"health":     nil,
	"healthcare": nil,
	"help":       nil,
	"helsinki":   nil,
	"here":       nil,
	"hermes":     nil,
	"hgtv":       nil,
	"hiphop":     nil,
	"hisamitsu":  nil,
	"hitachi":    nil,
	"hiv":        nil,
	"hk": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"idv":      nil,
		"inc":      nil,
		"ltd":      nil,
		"net":      nil,
		"nym":      nil,
		"org":      nil,
		"个人":       nil,
		"個人":       nil,
		"公司":       nil,
		"政府":       nil,
		"敎育":       nil,
		"教育":       nil,
		"箇人":       nil,
		"組織":       nil,
		"組织":       nil,
		"網絡":       nil,
		"網络":       nil,
		"组織":       nil,
		"组织":       nil,
		"网絡":       nil,
		"网络":       nil,
	},
	"hkt": nil,
	"hm":  nil,
	"hn": &tld{
		"com": nil,
		"edu": nil,
		"gob": nil,
		"mil": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"hockey":    nil,
	"holdings":  nil,
	"holiday":   nil,
	"homedepot": nil,
	"homegoods": nil,
	"homes":     nil,
	"homesense": nil,
	"honda":     nil,
	"horse":     nil,
	"hospital":  nil,
	"host": &tld{
		"cloudaccess": nil,
		"freesite":    nil,
		"half":        nil,
		"pcloud":      nil,
	},
	"hosting": &tld{
		"opencraft": nil,
	},
	"hot":     nil,
	"hoteles": nil,
	"hotels":  nil,
	"hotmail": nil,
	"house":   nil,
	"how":     nil,
	"hr": &tld{
		"blogspot": nil,
		"com":      nil,
		"free":     nil,
		"from":     nil,
		"iz":       nil,
		"name":     nil,
	},
	"hsbc": nil,
	"ht": &tld{
		"adult": nil,
		"art":   nil,
		"asso":  nil,
		"com":   nil,
		"coop":  nil,
		"edu":   nil,
		"firm":  nil,
		"gouv":  nil,
		"info":  nil,
		"med":   nil,
		"net":   nil,
		"org":   nil,
		"perso": nil,
		"pol":   nil,
		"pro":   nil,
		"rel":   nil,
		"shop":  nil,
	},
	"hu": &tld{
		"2000":     nil,
		"agrar":    nil,
		"blogspot": nil,
		"bolt":     nil,
		"casino":   nil,
		"city":     nil,
		"co":       nil,
		"erotica":  nil,
		"erotika":  nil,
		"film":     nil,
		"forum":    nil,
		"games":    nil,
		"hotel":    nil,
		"info":     nil,
		"ingatlan": nil,
		"jogasz":   nil,
		"konyvelo": nil,
		"lakas":    nil,
		"media":    nil,
		"news":     nil,
		"org":      nil,
		"priv":     nil,
		"reklam":   nil,
		"sex":      nil,
		"shop":     nil,
		"sport":    nil,
		"suli":     nil,
		"szex":     nil,
		"tm":       nil,
		"tozsde":   nil,
		"utazas":   nil,
		"video":    nil,
	},
	"hughes":  nil,
	"hyatt":   nil,
	"hyundai": nil,
	"ibm":     nil,
	"icbc":    nil,
	"ice":     nil,
	"icu":     nil,
	"id": &tld{
		"ac":  nil,
		"biz": nil,
		"co": &tld{
			"blogspot": nil,
		},
		"desa":   nil,
		"go":     nil,
		"mil":    nil,
		"my":     nil,
		"net":    nil,
		"or":     nil,
		"ponpes": nil,
		"sch":    nil,
		"web":    nil,
	},
	"ie": &tld{
		"blogspot": nil,
		"gov":      nil,
		"nym":      nil,
	},
	"ieee":  nil,
	"ifm":   nil,
	"ikano": nil,
	"il": &tld{
		"ac": nil,
		"co": &tld{
			"blogspot": nil,
		},
		"gov":  nil,
		"idf":  nil,
		"k12":  nil,
		"muni": nil,
		"net":  nil,
		"org":  nil,
	},
	"im": &tld{
		"ac": nil,
		"co": &tld{
			"ltd": nil,
			"plc": nil,
		},
		"com": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
		"ro":  nil,
		"tt":  nil,
		"tv":  nil,
	},
	"imamat":     nil,
	"imdb":       nil,
	"immo":       nil,
	"immobilien": nil,
	"in": &tld{
		"ac":       nil,
		"barsy":    nil,
		"blogspot": nil,
		"cloudns":  nil,
		"co":       nil,
		"edu":      nil,
		"firm":     nil,
		"gen":      nil,
		"gov":      nil,
		"ind":      nil,
		"mil":      nil,
		"net":      nil,
		"nic":      nil,
		"org":      nil,
		"res":      nil,
	},
	"inc":        nil,
	"industries": nil,
	"infiniti":   nil,
	"info": &tld{
		"barrel-of-knowledge":  nil,
		"barrell-of-knowledge": nil,
		"barsy":                nil,
		"cloudns":              nil,
		"dvrcam":               nil,
		"dynamic-dns":          nil,
		"dyndns":               nil,
		"for-our":              nil,
		"forumz":               nil,
		"groks-the":            nil,
		"groks-this":           nil,
		"here-for-more":        nil,
		"ilovecollege":         nil,
		"knowsitall":           nil,
		"mayfirst":             nil,
		"no-ip":                nil,
		"nsupdate":             nil,
		"selfip":               nil,
		"v-info":               nil,
		"webhop":               nil,
	},
	"ing": nil,
	"ink": &tld{
		"ng": nil,
	},
	"institute": nil,
	"insurance": nil,
	"insure":    nil,
	"int": &tld{
		"eu": nil,
	},
	"intel":         nil,
	"international": nil,
	"intuit":        nil,
	"investments":   nil,
	"io": &tld{
		"2038":             nil,
		"apigee":           nil,
		"applicationcloud": nil,
		"azurecontainer":   nil,
		"b-data":           nil,
		"backplaneapp":     nil,
		"banzaicloud": &tld{
			"app": nil,
		},
		"barsy":       nil,
		"basicserver": nil,
		"bigv": &tld{
			"uk0": nil,
		},
		"boxfuse":           nil,
		"browsersafetymark": nil,
		"cleverapps":        nil,
		"com":               nil,
		"dedyn":             nil,
		"definima":          nil,
		"drud":              nil,
		"dyn53":             nil,
		"enonic": &tld{
			"customer": nil,
		},
		"github":     nil,
		"gitlab":     nil,
		"hasura-app": nil,
		"hzc":        nil,
		"lair": &tld{
			"apps": nil,
		},
		"loginline":  nil,
		"mo-siemens": nil,
		"moonscale": &tld{
			"*": nil,
		},
		"ngrok": nil,
		"nid":   nil,
		"nodeart": &tld{
			"stage": nil,
		},
		"nodum": nil,
		"on-rio": &tld{
			"*": nil,
		},
		"pantheonsite": nil,
		"protonet":     nil,
		"readthedocs":  nil,
		"resindevice":  nil,
		"resinstaging": &tld{
			"devices": nil,
		},
		"s5y": &tld{
			"*": nil,
		},
		"sandcats":  nil,
		"scapp":     nil,
		"shiftedit": nil,
		"spacekit":  nil,
		"stolos": &tld{
			"*": nil,
		},
		"telebit": nil,
		"thingdust": &tld{
			"dev": &tld{
				"cust": nil,
			},
			"disrec": &tld{
				"cust": nil,
			},
			"prod": &tld{
				"cust": nil,
			},
			"testing": &tld{
				"cust": nil,
			},
		},
		"utwente":       nil,
		"vaporcloud":    nil,
		"virtualserver": nil,
		"wedeploy":      nil,
	},
	"ipiranga": nil,
	"iq": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
	},
	"ir": &tld{
		"ac":    nil,
		"co":    nil,
		"gov":   nil,
		"id":    nil,
		"net":   nil,
		"org":   nil,
		"sch":   nil,
		"ايران": nil,
		"ایران": nil,
	},
	"irish": nil,
	"is": &tld{
		"blogspot": nil,
		"com":      nil,
		"cupcake":  nil,
		"edu":      nil,
		"gov":      nil,
		"int":      nil,
		"net":      nil,
		"org":      nil,
	},
	"ismaili":  nil,
	"ist":      nil,
	"istanbul": nil,
	"it": &tld{
		"16-b":                  nil,
		"32-b":                  nil,
		"64-b":                  nil,
		"abr":                   nil,
		"abruzzo":               nil,
		"ag":                    nil,
		"agrigento":             nil,
		"al":                    nil,
		"alessandria":           nil,
		"alto-adige":            nil,
		"altoadige":             nil,
		"an":                    nil,
		"ancona":                nil,
		"andria-barletta-trani": nil,
		"andria-trani-barletta": nil,
		"andriabarlettatrani":   nil,
		"andriatranibarletta":   nil,
		"ao":                    nil,
		"aosta":                 nil,
		"aosta-valley":          nil,
		"aostavalley":           nil,
		"aoste":                 nil,
		"ap":                    nil,
		"aq":                    nil,
		"aquila":                nil,
		"ar":                    nil,
		"arezzo":                nil,
		"ascoli-piceno":         nil,
		"ascolipiceno":          nil,
		"asti":                  nil,
		"at":                    nil,
		"av":                    nil,
		"avellino":              nil,
		"ba":                    nil,
		"balsan":                nil,
		"balsan-sudtirol":       nil,
		"balsan-suedtirol":      nil,
		"balsan-südtirol":       nil,
		"bari":                  nil,
		"barletta-trani-andria": nil,
		"barlettatraniandria":   nil,
		"bas":                   nil,
		"basilicata":            nil,
		"belluno":               nil,
		"benevento":             nil,
		"bergamo":               nil,
		"bg":                    nil,
		"bi":                    nil,
		"biella":                nil,
		"bl":                    nil,
		"blogspot":              nil,
		"bn":                    nil,
		"bo":                    nil,
		"bologna":               nil,
		"bolzano":               nil,
		"bolzano-altoadige":     nil,
		"bozen":                 nil,
		"bozen-sudtirol":        nil,
		"bozen-suedtirol":       nil,
		"bozen-südtirol":        nil,
		"br":                    nil,
		"brescia":               nil,
		"brindisi":              nil,
		"bs":                    nil,
		"bt":                    nil,
		"bulsan":                nil,
		"bulsan-sudtirol":       nil,
		"bulsan-suedtirol":      nil,
		"bulsan-südtirol":       nil,
		"bz":                    nil,
		"ca":                    nil,
		"cagliari":              nil,
		"cal":                   nil,
		"calabria":              nil,
		"caltanissetta":         nil,
		"cam":                   nil,
		"campania":              nil,
		"campidano-medio":       nil,
		"campidanomedio":        nil,
		"campobasso":            nil,
		"carbonia-iglesias":     nil,
		"carboniaiglesias":      nil,
		"carrara-massa":         nil,
		"carraramassa":          nil,
		"caserta":               nil,
		"catania":               nil,
		"catanzaro":             nil,
		"cb":                    nil,
		"ce":                    nil,
		"cesena-forli":          nil,
		"cesena-forlì":          nil,
		"cesenaforli":           nil,
		"cesenaforlì":           nil,
		"ch":                    nil,
		"chieti":                nil,
		"ci":                    nil,
		"cl":                    nil,
		"cn":                    nil,
		"co":                    nil,
		"como":                  nil,
		"cosenza":               nil,
		"cr":                    nil,
		"cremona":               nil,
		"crotone":               nil,
		"cs":                    nil,
		"ct":                    nil,
		"cuneo":                 nil,
		"cz":                    nil,
		"dell-ogliastra":        nil,
		"dellogliastra":         nil,
		"edu":                   nil,
		"emilia-romagna":        nil,
		"emiliaromagna":         nil,
		"emr":                   nil,
		"en":                    nil,
		"enna":                  nil,
		"fc":                    nil,
		"fe":                    nil,
		"fermo":                 nil,
		"ferrara":               nil,
		"fg":                    nil,
		"fi":                    nil,
		"firenze":               nil,
		"florence":              nil,
		"fm":                    nil,
		"foggia":                nil,
		"forli-cesena":          nil,
		"forlicesena":           nil,
		"forlì-cesena":          nil,
		"forlìcesena":           nil,
		"fr":                    nil,
		"friuli-v-giulia":       nil,
		"friuli-ve-giulia":      nil,
		"friuli-vegiulia":       nil,
		"friuli-venezia-giulia": nil,
		"friuli-veneziagiulia":  nil,
		"friuli-vgiulia":        nil,
		"friuliv-giulia":        nil,
		"friulive-giulia":       nil,
		"friulivegiulia":        nil,
		"friulivenezia-giulia":  nil,
		"friuliveneziagiulia":   nil,
		"friulivgiulia":         nil,
		"frosinone":             nil,
		"fvg":                   nil,
		"ge":                    nil,
		"genoa":                 nil,
		"genova":                nil,
		"go":                    nil,
		"gorizia":               nil,
		"gov":                   nil,
		"gr":                    nil,
		"grosseto":              nil,
		"iglesias-carbonia":     nil,
		"iglesiascarbonia":      nil,
		"im":                    nil,
		"imperia":               nil,
		"is":                    nil,
		"isernia":               nil,
		"kr":                    nil,
		"la-spezia":             nil,
		"laquila":               nil,
		"laspezia":              nil,
		"latina":                nil,
		"laz":                   nil,
		"lazio":                 nil,
		"lc":                    nil,
		"le":                    nil,
		"lecce":                 nil,
		"lecco":                 nil,
		"li":                    nil,
		"lig":                   nil,
		"liguria":               nil,
		"livorno":               nil,
		"lo":                    nil,
		"lodi":                  nil,
		"lom":                   nil,
		"lombardia":             nil,
		"lombardy":              nil,
		"lt":                    nil,
		"lu":                    nil,
		"lucania":               nil,
		"lucca":                 nil,
		"macerata":              nil,
		"mantova":               nil,
		"mar":                   nil,
		"marche":                nil,
		"massa-carrara":         nil,
		"massacarrara":          nil,
		"matera":                nil,
		"mb":                    nil,
		"mc":                    nil,
		"me":                    nil,
		"medio-campidano":       nil,
		"mediocampidano":        nil,
		"messina":               nil,
		"mi":                    nil,
		"milan":                 nil,
		"milano":                nil,
		"mn":                    nil,
		"mo":                    nil,
		"modena":                nil,
		"mol":                   nil,
		"molise":                nil,
		"monza":                 nil,
		"monza-brianza":         nil,
		"monza-e-della-brianza": nil,
		"monzabrianza":          nil,
		"monzaebrianza":         nil,
		"monzaedellabrianza":    nil,
		"ms":                    nil,
		"mt":                    nil,
		"na":                    nil,
		"naples":                nil,
		"napoli":                nil,
		"no":                    nil,
		"novara":                nil,
		"nu":                    nil,
		"nuoro":                 nil,
		"og":                    nil,
		"ogliastra":             nil,
		"olbia-tempio":          nil,
		"olbiatempio":           nil,
		"or":                    nil,
		"oristano":              nil,
		"ot":                    nil,
		"pa":                    nil,
		"padova":                nil,
		"padua":                 nil,
		"palermo":               nil,
		"parma":                 nil,
		"pavia":                 nil,
		"pc":                    nil,
		"pd":                    nil,
		"pe":                    nil,
		"perugia":               nil,
		"pesaro-urbino":         nil,
		"pesarourbino":          nil,
		"pescara":               nil,
		"pg":                    nil,
		"pi":                    nil,
		"piacenza":              nil,
		"piedmont":              nil,
		"piemonte":              nil,
		"pisa":                  nil,
		"pistoia":               nil,
		"pmn":                   nil,
		"pn":                    nil,
		"po":                    nil,
		"pordenone":             nil,
		"potenza":               nil,
		"pr":                    nil,
		"prato":                 nil,
		"pt":                    nil,
		"pu":                    nil,
		"pug":                   nil,
		"puglia":                nil,
		"pv":                    nil,
		"pz":                    nil,
		"ra":                    nil,
		"ragusa":                nil,
		"ravenna":               nil,
		"rc":                    nil,
		"re":                    nil,
		"reggio-calabria":       nil,
		"reggio-emilia":         nil,
		"reggiocalabria":        nil,
		"reggioemilia":          nil,
		"rg":                    nil,
		"ri":                    nil,
		"rieti":                 nil,
		"rimini":                nil,
		"rm":                    nil,
		"rn":                    nil,
		"ro":                    nil,
		"roma":                  nil,
		"rome":                  nil,
		"rovigo":                nil,
		"sa":                    nil,
		"salerno":               nil,
		"sar":                   nil,
		"sardegna":              nil,
		"sardinia":              nil,
		"sassari":               nil,
		"savona":                nil,
		"si":                    nil,
		"sic":                   nil,
		"sicilia":               nil,
		"sicily":                nil,
		"siena":                 nil,
		"siracusa":              nil,
		"so":                    nil,
		"sondrio":               nil,
		"sp":                    nil,
		"sr":                    nil,
		"ss":                    nil,
		"suedtirol":             nil,
		"sv":                    nil,
		"syncloud":              nil,
		"südtirol":              nil,
		"ta":                    nil,
		"taa":                   nil,
		"taranto":               nil,
		"te":                    nil,
		"tempio-olbia":          nil,
		"tempioolbia":           nil,
		"teramo":                nil,
		"terni":                 nil,
		"tn":                    nil,
		"to":                    nil,
		"torino":                nil,
		"tos":                   nil,
		"toscana":               nil,
		"tp":                    nil,
		"tr":                    nil,
		"trani-andria-barletta": nil,
		"trani-barletta-andria": nil,
		"traniandriabarletta":   nil,
		"tranibarlettaandria":   nil,
		"trapani":               nil,
		"trentin-sud-tirol":     nil,
		"trentin-sudtirol":      nil,
		"trentin-sued-tirol":    nil,
		"trentin-suedtirol":     nil,
		"trentin-süd-tirol":     nil,
		"trentin-südtirol":      nil,
		"trentino":              nil,
		"trentino-a-adige":      nil,
		"trentino-aadige":       nil,
		"trentino-alto-adige":   nil,
		"trentino-altoadige":    nil,
		"trentino-s-tirol":      nil,
		"trentino-stirol":       nil,
		"trentino-sud-tirol":    nil,
		"trentino-sudtirol":     nil,
		"trentino-sued-tirol":   nil,
		"trentino-suedtirol":    nil,
		"trentino-süd-tirol":    nil,
		"trentino-südtirol":     nil,
		"trentinoa-adige":       nil,
		"trentinoaadige":        nil,
		"trentinoalto-adige":    nil,
		"trentinoaltoadige":     nil,
		"trentinos-tirol":       nil,
		"trentinostirol":        nil,
		"trentinosud-tirol":     nil,
		"trentinosudtirol":      nil,
		"trentinosued-tirol":    nil,
		"trentinosuedtirol":     nil,
		"trentinosüd-tirol":     nil,
		"trentinosüdtirol":      nil,
		"trentinsud-tirol":      nil,
		"trentinsudtirol":       nil,
		"trentinsued-tirol":     nil,
		"trentinsuedtirol":      nil,
		"trentinsüd-tirol":      nil,
		"trentinsüdtirol":       nil,
		"trento":                nil,
		"treviso":               nil,
		"trieste":               nil,
		"ts":                    nil,
		"turin":                 nil,
		"tuscany":               nil,
		"tv":                    nil,
		"ud":                    nil,
		"udine":                 nil,
		"umb":                   nil,
		"umbria":                nil,
		"urbino-pesaro":         nil,
		"urbinopesaro":          nil,
		"va":                    nil,
		"val-d-aosta":           nil,
		"val-daosta":            nil,
		"vald-aosta":            nil,
		"valdaosta":             nil,
		"valle-aosta":           nil,
		"valle-d-aosta":         nil,
		"valle-daosta":          nil,
		"valleaosta":            nil,
		"valled-aosta":          nil,
		"valledaosta":           nil,
		"vallee-aoste":          nil,
		"vallee-d-aoste":        nil,
		"valleeaoste":           nil,
		"valleedaoste":          nil,
		"vallée-aoste":          nil,
		"vallée-d-aoste":        nil,
		"valléeaoste":           nil,
		"valléedaoste":          nil,
		"vao":                   nil,
		"varese":                nil,
		"vb":                    nil,
		"vc":                    nil,
		"vda":                   nil,
		"ve":                    nil,
		"ven":                   nil,
		"veneto":                nil,
		"venezia":               nil,
		"venice":                nil,
		"verbania":              nil,
		"vercelli":              nil,
		"verona":                nil,
		"vi":                    nil,
		"vibo-valentia":         nil,
		"vibovalentia":          nil,
		"vicenza":               nil,
		"viterbo":               nil,
		"vr":                    nil,
		"vs":                    nil,
		"vt":                    nil,
		"vv":                    nil,
	},
	"itau":   nil,
	"itv":    nil,
	"iveco":  nil,
	"jaguar": nil,
	"java":   nil,
	"jcb":    nil,
	"jcp":    nil,
	"je": &tld{
		"co":  nil,
		"net": nil,
		"org": nil,
	},
	"jeep":    nil,
	"jetzt":   nil,
	"jewelry": nil,
	"jio":     nil,
	"jll":     nil,
	"jm": &tld{
		"*": nil,
	},
	"jmp": nil,
	"jnj": nil,
	"jo": &tld{
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"mil":  nil,
		"name": nil,
		"net":  nil,
		"org":  nil,
		"sch":  nil,
	},
	"jobs":   nil,
	"joburg": nil,
	"jot":    nil,
	"joy":    nil,
	"jp": &tld{
		"ac": nil,
		"ad": nil,
		"aichi": &tld{
			"aisai":      nil,
			"ama":        nil,
			"anjo":       nil,
			"asuke":      nil,
			"chiryu":     nil,
			"chita":      nil,
			"fuso":       nil,
			"gamagori":   nil,
			"handa":      nil,
			"hazu":       nil,
			"hekinan":    nil,
			"higashiura": nil,
			"ichinomiya": nil,
			"inazawa":    nil,
			"inuyama":    nil,
			"isshiki":    nil,
			"iwakura":    nil,
			"kanie":      nil,
			"kariya":     nil,
			"kasugai":    nil,
			"kira":       nil,
			"kiyosu":     nil,
			"komaki":     nil,
			"konan":      nil,
			"kota":       nil,
			"mihama":     nil,
			"miyoshi":    nil,
			"nishio":     nil,
			"nisshin":    nil,
			"obu":        nil,
			"oguchi":     nil,
			"oharu":      nil,
			"okazaki":    nil,
			"owariasahi": nil,
			"seto":       nil,
			"shikatsu":   nil,
			"shinshiro":  nil,
			"shitara":    nil,
			"tahara":     nil,
			"takahama":   nil,
			"tobishima":  nil,
			"toei":       nil,
			"togo":       nil,
			"tokai":      nil,
			"tokoname":   nil,
			"toyoake":    nil,
			"toyohashi":  nil,
			"toyokawa":   nil,
			"toyone":     nil,
			"toyota":     nil,
			"tsushima":   nil,
			"yatomi":     nil,
		},
		"akita": &tld{
			"akita":         nil,
			"daisen":        nil,
			"fujisato":      nil,
			"gojome":        nil,
			"hachirogata":   nil,
			"happou":        nil,
			"higashinaruse": nil,
			"honjo":         nil,
			"honjyo":        nil,
			"ikawa":         nil,
			"kamikoani":     nil,
			"kamioka":       nil,
			"katagami":      nil,
			"kazuno":        nil,
			"kitaakita":     nil,
			"kosaka":        nil,
			"kyowa":         nil,
			"misato":        nil,
			"mitane":        nil,
			"moriyoshi":     nil,
			"nikaho":        nil,
			"noshiro":       nil,
			"odate":         nil,
			"oga":           nil,
			"ogata":         nil,
			"semboku":       nil,
			"yokote":        nil,
			"yurihonjo":     nil,
		},
		"aomori": &tld{
			"aomori":     nil,
			"gonohe":     nil,
			"hachinohe":  nil,
			"hashikami":  nil,
			"hiranai":    nil,
			"hirosaki":   nil,
			"itayanagi":  nil,
			"kuroishi":   nil,
			"misawa":     nil,
			"mutsu":      nil,
			"nakadomari": nil,
			"noheji":     nil,
			"oirase":     nil,
			"owani":      nil,
			"rokunohe":   nil,
			"sannohe":    nil,
			"shichinohe": nil,
			"shingo":     nil,
			"takko":      nil,
			"towada":     nil,
			"tsugaru":    nil,
			"tsuruta":    nil,
		},
		"blogspot": nil,
		"chiba": &tld{
			"abiko":           nil,
			"asahi":           nil,
			"chonan":          nil,
			"chosei":          nil,
			"choshi":          nil,
			"chuo":            nil,
			"funabashi":       nil,
			"futtsu":          nil,
			"hanamigawa":      nil,
			"ichihara":        nil,
			"ichikawa":        nil,
			"ichinomiya":      nil,
			"inzai":           nil,
			"isumi":           nil,
			"kamagaya":        nil,
			"kamogawa":        nil,
			"kashiwa":         nil,
			"katori":          nil,
			"katsuura":        nil,
			"kimitsu":         nil,
			"kisarazu":        nil,
			"kozaki":          nil,
			"kujukuri":        nil,
			"kyonan":          nil,
			"matsudo":         nil,
			"midori":          nil,
			"mihama":          nil,
			"minamiboso":      nil,
			"mobara":          nil,
			"mutsuzawa":       nil,
			"nagara":          nil,
			"nagareyama":      nil,
			"narashino":       nil,
			"narita":          nil,
			"noda":            nil,
			"oamishirasato":   nil,
			"omigawa":         nil,
			"onjuku":          nil,
			"otaki":           nil,
			"sakae":           nil,
			"sakura":          nil,
			"shimofusa":       nil,
			"shirako":         nil,
			"shiroi":          nil,
			"shisui":          nil,
			"sodegaura":       nil,
			"sosa":            nil,
			"tako":            nil,
			"tateyama":        nil,
			"togane":          nil,
			"tohnosho":        nil,
			"tomisato":        nil,
			"urayasu":         nil,
			"yachimata":       nil,
			"yachiyo":         nil,
			"yokaichiba":      nil,
			"yokoshibahikari": nil,
			"yotsukaido":      nil,
		},
		"co": nil,
		"ed": nil,
		"ehime": &tld{
			"ainan":       nil,
			"honai":       nil,
			"ikata":       nil,
			"imabari":     nil,
			"iyo":         nil,
			"kamijima":    nil,
			"kihoku":      nil,
			"kumakogen":   nil,
			"masaki":      nil,
			"matsuno":     nil,
			"matsuyama":   nil,
			"namikata":    nil,
			"niihama":     nil,
			"ozu":         nil,
			"saijo":       nil,
			"seiyo":       nil,
			"shikokuchuo": nil,
			"tobe":        nil,
			"toon":        nil,
			"uchiko":      nil,
			"uwajima":     nil,
			"yawatahama":  nil,
		},
		"fukui": &tld{
			"echizen":       nil,
			"eiheiji":       nil,
			"fukui":         nil,
			"ikeda":         nil,
			"katsuyama":     nil,
			"mihama":        nil,
			"minamiechizen": nil,
			"obama":         nil,
			"ohi":           nil,
			"ono":           nil,
			"sabae":         nil,
			"sakai":         nil,
			"takahama":      nil,
			"tsuruga":       nil,
			"wakasa":        nil,
		},
		"fukuoka": &tld{
			"ashiya":        nil,
			"buzen":         nil,
			"chikugo":       nil,
			"chikuho":       nil,
			"chikujo":       nil,
			"chikushino":    nil,
			"chikuzen":      nil,
			"chuo":          nil,
			"dazaifu":       nil,
			"fukuchi":       nil,
			"hakata":        nil,
			"higashi":       nil,
			"hirokawa":      nil,
			"hisayama":      nil,
			"iizuka":        nil,
			"inatsuki":      nil,
			"kaho":          nil,
			"kasuga":        nil,
			"kasuya":        nil,
			"kawara":        nil,
			"keisen":        nil,
			"koga":          nil,
			"kurate":        nil,
			"kurogi":        nil,
			"kurume":        nil,
			"minami":        nil,
			"miyako":        nil,
			"miyama":        nil,
			"miyawaka":      nil,
			"mizumaki":      nil,
			"munakata":      nil,
			"nakagawa":      nil,
			"nakama":        nil,
			"nishi":         nil,
			"nogata":        nil,
			"ogori":         nil,
			"okagaki":       nil,
			"okawa":         nil,
			"oki":           nil,
			"omuta":         nil,
			"onga":          nil,
			"onojo":         nil,
			"oto":           nil,
			"saigawa":       nil,
			"sasaguri":      nil,
			"shingu":        nil,
			"shinyoshitomi": nil,
			"shonai":        nil,
			"soeda":         nil,
			"sue":           nil,
			"tachiarai":     nil,
			"tagawa":        nil,
			"takata":        nil,
			"toho":          nil,
			"toyotsu":       nil,
			"tsuiki":        nil,
			"ukiha":         nil,
			"umi":           nil,
			"usui":          nil,
			"yamada":        nil,
			"yame":          nil,
			"yanagawa":      nil,
			"yukuhashi":     nil,
		},
		"fukushima": &tld{
			"aizubange":     nil,
			"aizumisato":    nil,
			"aizuwakamatsu": nil,
			"asakawa":       nil,
			"bandai":        nil,
			"date":          nil,
			"fukushima":     nil,
			"furudono":      nil,
			"futaba":        nil,
			"hanawa":        nil,
			"higashi":       nil,
			"hirata":        nil,
			"hirono":        nil,
			"iitate":        nil,
			"inawashiro":    nil,
			"ishikawa":      nil,
			"iwaki":         nil,
			"izumizaki":     nil,
			"kagamiishi":    nil,
			"kaneyama":      nil,
			"kawamata":      nil,
			"kitakata":      nil,
			"kitashiobara":  nil,
			"koori":         nil,
			"koriyama":      nil,
			"kunimi":        nil,
			"miharu":        nil,
			"mishima":       nil,
			"namie":         nil,
			"nango":         nil,
			"nishiaizu":     nil,
			"nishigo":       nil,
			"okuma":         nil,
			"omotego":       nil,
			"ono":           nil,
			"otama":         nil,
			"samegawa":      nil,
			"shimogo":       nil,
			"shirakawa":     nil,
			"showa":         nil,
			"soma":          nil,
			"sukagawa":      nil,
			"taishin":       nil,
			"tamakawa":      nil,
			"tanagura":      nil,
			"tenei":         nil,
			"yabuki":        nil,
			"yamato":        nil,
			"yamatsuri":     nil,
			"yanaizu":       nil,
			"yugawa":        nil,
		},
		"gifu": &tld{
			"anpachi":          nil,
			"ena":              nil,
			"gifu":             nil,
			"ginan":            nil,
			"godo":             nil,
			"gujo":             nil,
			"hashima":          nil,
			"hichiso":          nil,
			"hida":             nil,
			"higashishirakawa": nil,
			"ibigawa":          nil,
			"ikeda":            nil,
			"kakamigahara":     nil,
			"kani":             nil,
			"kasahara":         nil,
			"kasamatsu":        nil,
			"kawaue":           nil,
			"kitagata":         nil,
			"mino":             nil,
			"minokamo":         nil,
			"mitake":           nil,
			"mizunami":         nil,
			"motosu":           nil,
			"nakatsugawa":      nil,
			"ogaki":            nil,
			"sakahogi":         nil,
			"seki":             nil,
			"sekigahara":       nil,
			"shirakawa":        nil,
			"tajimi":           nil,
			"takayama":         nil,
			"tarui":            nil,
			"toki":             nil,
			"tomika":           nil,
			"wanouchi":         nil,
			"yamagata":         nil,
			"yaotsu":           nil,
			"yoro":             nil,
		},
		"go": nil,
		"gr": nil,
		"gunma": &tld{
			"annaka":          nil,
			"chiyoda":         nil,
			"fujioka":         nil,
			"higashiagatsuma": nil,
			"isesaki":         nil,
			"itakura":         nil,
			"kanna":           nil,
			"kanra":           nil,
			"katashina":       nil,
			"kawaba":          nil,
			"kiryu":           nil,
			"kusatsu":         nil,
			"maebashi":        nil,
			"meiwa":           nil,
			"midori":          nil,
			"minakami":        nil,
			"naganohara":      nil,
			"nakanojo":        nil,
			"nanmoku":         nil,
			"numata":          nil,
			"oizumi":          nil,
			"ora":             nil,
			"ota":             nil,
			"shibukawa":       nil,
			"shimonita":       nil,
			"shinto":          nil,
			"showa":           nil,
			"takasaki":        nil,
			"takayama":        nil,
			"tamamura":        nil,
			"tatebayashi":     nil,
			"tomioka":         nil,
			"tsukiyono":       nil,
			"tsumagoi":        nil,
			"ueno":            nil,
			"yoshioka":        nil,
		},
		"hiroshima": &tld{
			"asaminami":        nil,
			"daiwa":            nil,
			"etajima":          nil,
			"fuchu":            nil,
			"fukuyama":         nil,
			"hatsukaichi":      nil,
			"higashihiroshima": nil,
			"hongo":            nil,
			"jinsekikogen":     nil,
			"kaita":            nil,
			"kui":              nil,
			"kumano":           nil,
			"kure":             nil,
			"mihara":           nil,
			"miyoshi":          nil,
			"naka":             nil,
			"onomichi":         nil,
			"osakikamijima":    nil,
			"otake":            nil,
			"saka":             nil,
			"sera":             nil,
			"seranishi":        nil,
			"shinichi":         nil,
			"shobara":          nil,
			"takehara":         nil,
		},
		"hokkaido": &tld{
			"abashiri":      nil,
			"abira":         nil,
			"aibetsu":       nil,
			"akabira":       nil,
			"akkeshi":       nil,
			"asahikawa":     nil,
			"ashibetsu":     nil,
			"ashoro":        nil,
			"assabu":        nil,
			"atsuma":        nil,
			"bibai":         nil,
			"biei":          nil,
			"bifuka":        nil,
			"bihoro":        nil,
			"biratori":      nil,
			"chippubetsu":   nil,
			"chitose":       nil,
			"date":          nil,
			"ebetsu":        nil,
			"embetsu":       nil,
			"eniwa":         nil,
			"erimo":         nil,
			"esan":          nil,
			"esashi":        nil,
			"fukagawa":      nil,
			"fukushima":     nil,
			"furano":        nil,
			"furubira":      nil,
			"haboro":        nil,
			"hakodate":      nil,
			"hamatonbetsu":  nil,
			"hidaka":        nil,
			"higashikagura": nil,
			"higashikawa":   nil,
			"hiroo":         nil,
			"hokuryu":       nil,
			"hokuto":        nil,
			"honbetsu":      nil,
			"horokanai":     nil,
			"horonobe":      nil,
			"ikeda":         nil,
			"imakane":       nil,
			"ishikari":      nil,
			"iwamizawa":     nil,
			"iwanai":        nil,
			"kamifurano":    nil,
			"kamikawa":      nil,
			"kamishihoro":   nil,
			"kamisunagawa":  nil,
			"kamoenai":      nil,
			"kayabe":        nil,
			"kembuchi":      nil,
			"kikonai":       nil,
			"kimobetsu":     nil,
			"kitahiroshima": nil,
			"kitami":        nil,
			"kiyosato":      nil,
			"koshimizu":     nil,
			"kunneppu":      nil,
			"kuriyama":      nil,
			"kuromatsunai":  nil,
			"kushiro":       nil,
			"kutchan":       nil,
			"kyowa":         nil,
			"mashike":       nil,
			"matsumae":      nil,
			"mikasa":        nil,
			"minamifurano":  nil,
			"mombetsu":      nil,
			"moseushi":      nil,
			"mukawa":        nil,
			"muroran":       nil,
			"naie":          nil,
			"nakagawa":      nil,
			"nakasatsunai":  nil,
			"nakatombetsu":  nil,
			"nanae":         nil,
			"nanporo":       nil,
			"nayoro":        nil,
			"nemuro":        nil,
			"niikappu":      nil,
			"niki":          nil,
			"nishiokoppe":   nil,
			"noboribetsu":   nil,
			"numata":        nil,
			"obihiro":       nil,
			"obira":         nil,
			"oketo":         nil,
			"okoppe":        nil,
			"otaru":         nil,
			"otobe":         nil,
			"otofuke":       nil,
			"otoineppu":     nil,
			"oumu":          nil,
			"ozora":         nil,
			"pippu":         nil,
			"rankoshi":      nil,
			"rebun":         nil,
			"rikubetsu":     nil,
			"rishiri":       nil,
			"rishirifuji":   nil,
			"saroma":        nil,
			"sarufutsu":     nil,
			"shakotan":      nil,
			"shari":         nil,
			"shibecha":      nil,
			"shibetsu":      nil,
			"shikabe":       nil,
			"shikaoi":       nil,
			"shimamaki":     nil,
			"shimizu":       nil,
			"shimokawa":     nil,
			"shinshinotsu":  nil,
			"shintoku":      nil,
			"shiranuka":     nil,
			"shiraoi":       nil,
			"shiriuchi":     nil,
			"sobetsu":       nil,
			"sunagawa":      nil,
			"taiki":         nil,
			"takasu":        nil,
			"takikawa":      nil,
			"takinoue":      nil,
			"teshikaga":     nil,
			"tobetsu":       nil,
			"tohma":         nil,
			"tomakomai":     nil,
			"tomari":        nil,
			"toya":          nil,
			"toyako":        nil,
			"toyotomi":      nil,
			"toyoura":       nil,
			"tsubetsu":      nil,
			"tsukigata":     nil,
			"urakawa":       nil,
			"urausu":        nil,
			"uryu":          nil,
			"utashinai":     nil,
			"wakkanai":      nil,
			"wassamu":       nil,
			"yakumo":        nil,
			"yoichi":        nil,
		},
		"hyogo": &tld{
			"aioi":        nil,
			"akashi":      nil,
			"ako":         nil,
			"amagasaki":   nil,
			"aogaki":      nil,
			"asago":       nil,
			"ashiya":      nil,
			"awaji":       nil,
			"fukusaki":    nil,
			"goshiki":     nil,
			"harima":      nil,
			"himeji":      nil,
			"ichikawa":    nil,
			"inagawa":     nil,
			"itami":       nil,
			"kakogawa":    nil,
			"kamigori":    nil,
			"kamikawa":    nil,
			"kasai":       nil,
			"kasuga":      nil,
			"kawanishi":   nil,
			"miki":        nil,
			"minamiawaji": nil,
			"nishinomiya": nil,
			"nishiwaki":   nil,
			"ono":         nil,
			"sanda":       nil,
			"sannan":      nil,
			"sasayama":    nil,
			"sayo":        nil,
			"shingu":      nil,
			"shinonsen":   nil,
			"shiso":       nil,
			"sumoto":      nil,
			"taishi":      nil,
			"taka":        nil,
			"takarazuka":  nil,
			"takasago":    nil,
			"takino":      nil,
			"tamba":       nil,
			"tatsuno":     nil,
			"toyooka":     nil,
			"yabu":        nil,
			"yashiro":     nil,
			"yoka":        nil,
			"yokawa":      nil,
		},
		"ibaraki": &tld{
			"ami":          nil,
			"asahi":        nil,
			"bando":        nil,
			"chikusei":     nil,
			"daigo":        nil,
			"fujishiro":    nil,
			"hitachi":      nil,
			"hitachinaka":  nil,
			"hitachiomiya": nil,
			"hitachiota":   nil,
			"ibaraki":      nil,
			"ina":          nil,
			"inashiki":     nil,
			"itako":        nil,
			"iwama":        nil,
			"joso":         nil,
			"kamisu":       nil,
			"kasama":       nil,
			"kashima":      nil,
			"kasumigaura":  nil,
			"koga":         nil,
			"miho":         nil,
			"mito":         nil,
			"moriya":       nil,
			"naka":         nil,
			"namegata":     nil,
			"oarai":        nil,
			"ogawa":        nil,
			"omitama":      nil,
			"ryugasaki":    nil,
			"sakai":        nil,
			"sakuragawa":   nil,
			"shimodate":    nil,
			"shimotsuma":   nil,
			"shirosato":    nil,
			"sowa":         nil,
			"suifu":        nil,
			"takahagi":     nil,
			"tamatsukuri":  nil,
			"tokai":        nil,
			"tomobe":       nil,
			"tone":         nil,
			"toride":       nil,
			"tsuchiura":    nil,
			"tsukuba":      nil,
			"uchihara":     nil,
			"ushiku":       nil,
			"yachiyo":      nil,
			"yamagata":     nil,
			"yawara":       nil,
			"yuki":         nil,
		},
		"ishikawa": &tld{
			"anamizu":  nil,
			"hakui":    nil,
			"hakusan":  nil,
			"kaga":     nil,
			"kahoku":   nil,
			"kanazawa": nil,
			"kawakita": nil,
			"komatsu":  nil,
			"nakanoto": nil,
			"nanao":    nil,
			"nomi":     nil,
			"nonoichi": nil,
			"noto":     nil,
			"shika":    nil,
			"suzu":     nil,
			"tsubata":  nil,
			"tsurugi":  nil,
			"uchinada": nil,
			"wajima":   nil,
		},
		"iwate": &tld{
			"fudai":         nil,
			"fujisawa":      nil,
			"hanamaki":      nil,
			"hiraizumi":     nil,
			"hirono":        nil,
			"ichinohe":      nil,
			"ichinoseki":    nil,
			"iwaizumi":      nil,
			"iwate":         nil,
			"joboji":        nil,
			"kamaishi":      nil,
			"kanegasaki":    nil,
			"karumai":       nil,
			"kawai":         nil,
			"kitakami":      nil,
			"kuji":          nil,
			"kunohe":        nil,
			"kuzumaki":      nil,
			"miyako":        nil,
			"mizusawa":      nil,
			"morioka":       nil,
			"ninohe":        nil,
			"noda":          nil,
			"ofunato":       nil,
			"oshu":          nil,
			"otsuchi":       nil,
			"rikuzentakata": nil,
			"shiwa":         nil,
			"shizukuishi":   nil,
			"sumita":        nil,
			"tanohata":      nil,
			"tono":          nil,
			"yahaba":        nil,
			"yamada":        nil,
		},
		"kagawa": &tld{
			"ayagawa":       nil,
			"higashikagawa": nil,
			"kanonji":       nil,
			"kotohira":      nil,
			"manno":         nil,
			"marugame":      nil,
			"mitoyo":        nil,
			"naoshima":      nil,
			"sanuki":        nil,
			"tadotsu":       nil,
			"takamatsu":     nil,
			"tonosho":       nil,
			"uchinomi":      nil,
			"utazu":         nil,
			"zentsuji":      nil,
		},
		"kagoshima": &tld{
			"akune":         nil,
			"amami":         nil,
			"hioki":         nil,
			"isa":           nil,
			"isen":          nil,
			"izumi":         nil,
			"kagoshima":     nil,
			"kanoya":        nil,
			"kawanabe":      nil,
			"kinko":         nil,
			"kouyama":       nil,
			"makurazaki":    nil,
			"matsumoto":     nil,
			"minamitane":    nil,
			"nakatane":      nil,
			"nishinoomote":  nil,
			"satsumasendai": nil,
			"soo":           nil,
			"tarumizu":      nil,
			"yusui":         nil,
		},
		"kanagawa": &tld{
			"aikawa":         nil,
			"atsugi":         nil,
			"ayase":          nil,
			"chigasaki":      nil,
			"ebina":          nil,
			"fujisawa":       nil,
			"hadano":         nil,
			"hakone":         nil,
			"hiratsuka":      nil,
			"isehara":        nil,
			"kaisei":         nil,
			"kamakura":       nil,
			"kiyokawa":       nil,
			"matsuda":        nil,
			"minamiashigara": nil,
			"miura":          nil,
			"nakai":          nil,
			"ninomiya":       nil,
			"odawara":        nil,
			"oi":             nil,
			"oiso":           nil,
			"sagamihara":     nil,
			"samukawa":       nil,
			"tsukui":         nil,
			"yamakita":       nil,
			"yamato":         nil,
			"yokosuka":       nil,
			"yugawara":       nil,
			"zama":           nil,
			"zushi":          nil,
		},
		"kawasaki": &tld{
			"!city": nil,
			"*":     nil,
		},
		"kitakyushu": &tld{
			"!city": nil,
			"*":     nil,
		},
		"kobe": &tld{
			"!city": nil,
			"*":     nil,
		},
		"kochi": &tld{
			"aki":          nil,
			"geisei":       nil,
			"hidaka":       nil,
			"higashitsuno": nil,
			"ino":          nil,
			"kagami":       nil,
			"kami":         nil,
			"kitagawa":     nil,
			"kochi":        nil,
			"mihara":       nil,
			"motoyama":     nil,
			"muroto":       nil,
			"nahari":       nil,
			"nakamura":     nil,
			"nankoku":      nil,
			"nishitosa":    nil,
			"niyodogawa":   nil,
			"ochi":         nil,
			"okawa":        nil,
			"otoyo":        nil,
			"otsuki":       nil,
			"sakawa":       nil,
			"sukumo":       nil,
			"susaki":       nil,
			"tosa":         nil,
			"tosashimizu":  nil,
			"toyo":         nil,
			"tsuno":        nil,
			"umaji":        nil,
			"yasuda":       nil,
			"yusuhara":     nil,
		},
		"kumamoto": &tld{
			"amakusa":     nil,
			"arao":        nil,
			"aso":         nil,
			"choyo":       nil,
			"gyokuto":     nil,
			"kamiamakusa": nil,
			"kikuchi":     nil,
			"kumamoto":    nil,
			"mashiki":     nil,
			"mifune":      nil,
			"minamata":    nil,
			"minamioguni": nil,
			"nagasu":      nil,
			"nishihara":   nil,
			"oguni":       nil,
			"ozu":         nil,
			"sumoto":      nil,
			"takamori":    nil,
			"uki":         nil,
			"uto":         nil,
			"yamaga":      nil,
			"yamato":      nil,
			"yatsushiro":  nil,
		},
		"kyoto": &tld{
			"ayabe":           nil,
			"fukuchiyama":     nil,
			"higashiyama":     nil,
			"ide":             nil,
			"ine":             nil,
			"joyo":            nil,
			"kameoka":         nil,
			"kamo":            nil,
			"kita":            nil,
			"kizu":            nil,
			"kumiyama":        nil,
			"kyotamba":        nil,
			"kyotanabe":       nil,
			"kyotango":        nil,
			"maizuru":         nil,
			"minami":          nil,
			"minamiyamashiro": nil,
			"miyazu":          nil,
			"muko":            nil,
			"nagaokakyo":      nil,
			"nakagyo":         nil,
			"nantan":          nil,
			"oyamazaki":       nil,
			"sakyo":           nil,
			"seika":           nil,
			"tanabe":          nil,
			"uji":             nil,
			"ujitawara":       nil,
			"wazuka":          nil,
			"yamashina":       nil,
			"yawata":          nil,
		},
		"lg": nil,
		"mie": &tld{
			"asahi":     nil,
			"inabe":     nil,
			"ise":       nil,
			"kameyama":  nil,
			"kawagoe":   nil,
			"kiho":      nil,
			"kisosaki":  nil,
			"kiwa":      nil,
			"komono":    nil,
			"kumano":    nil,
			"kuwana":    nil,
			"matsusaka": nil,
			"meiwa":     nil,
			"mihama":    nil,
			"minamiise": nil,
			"misugi":    nil,
			"miyama":    nil,
			"nabari":    nil,
			"shima":     nil,
			"suzuka":    nil,
			"tado":      nil,
			"taiki":     nil,
			"taki":      nil,
			"tamaki":    nil,
			"toba":      nil,
			"tsu":       nil,
			"udono":     nil,
			"ureshino":  nil,
			"watarai":   nil,
			"yokkaichi": nil,
		},
		"miyagi": &tld{
			"furukawa":          nil,
			"higashimatsushima": nil,
			"ishinomaki":        nil,
			"iwanuma":           nil,
			"kakuda":            nil,
			"kami":              nil,
			"kawasaki":          nil,
			"marumori":          nil,
			"matsushima":        nil,
			"minamisanriku":     nil,
			"misato":            nil,
			"murata":            nil,
			"natori":            nil,
			"ogawara":           nil,
			"ohira":             nil,
			"onagawa":           nil,
			"osaki":             nil,
			"rifu":              nil,
			"semine":            nil,
			"shibata":           nil,
			"shichikashuku":     nil,
			"shikama":           nil,
			"shiogama":          nil,
			"shiroishi":         nil,
			"tagajo":            nil,
			"taiwa":             nil,
			"tome":              nil,
			"tomiya":            nil,
			"wakuya":            nil,
			"watari":            nil,
			"yamamoto":          nil,
			"zao":               nil,
		},
		"miyazaki": &tld{
			"aya":        nil,
			"ebino":      nil,
			"gokase":     nil,
			"hyuga":      nil,
			"kadogawa":   nil,
			"kawaminami": nil,
			"kijo":       nil,
			"kitagawa":   nil,
			"kitakata":   nil,
			"kitaura":    nil,
			"kobayashi":  nil,
			"kunitomi":   nil,
			"kushima":    nil,
			"mimata":     nil,
			"miyakonojo": nil,
			"miyazaki":   nil,
			"morotsuka":  nil,
			"nichinan":   nil,
			"nishimera":  nil,
			"nobeoka":    nil,
			"saito":      nil,
			"shiiba":     nil,
			"shintomi":   nil,
			"takaharu":   nil,
			"takanabe":   nil,
			"takazaki":   nil,
			"tsuno":      nil,
		},
		"nagano": &tld{
			"achi":          nil,
			"agematsu":      nil,
			"anan":          nil,
			"aoki":          nil,
			"asahi":         nil,
			"azumino":       nil,
			"chikuhoku":     nil,
			"chikuma":       nil,
			"chino":         nil,
			"fujimi":        nil,
			"hakuba":        nil,
			"hara":          nil,
			"hiraya":        nil,
			"iida":          nil,
			"iijima":        nil,
			"iiyama":        nil,
			"iizuna":        nil,
			"ikeda":         nil,
			"ikusaka":       nil,
			"ina":           nil,
			"karuizawa":     nil,
			"kawakami":      nil,
			"kiso":          nil,
			"kisofukushima": nil,
			"kitaaiki":      nil,
			"komagane":      nil,
			"komoro":        nil,
			"matsukawa":     nil,
			"matsumoto":     nil,
			"miasa":         nil,
			"minamiaiki":    nil,
			"minamimaki":    nil,
			"minamiminowa":  nil,
			"minowa":        nil,
			"miyada":        nil,
			"miyota":        nil,
			"mochizuki":     nil,
			"nagano":        nil,
			"nagawa":        nil,
			"nagiso":        nil,
			"nakagawa":      nil,
			"nakano":        nil,
			"nozawaonsen":   nil,
			"obuse":         nil,
			"ogawa":         nil,
			"okaya":         nil,
			"omachi":        nil,
			"omi":           nil,
			"ookuwa":        nil,
			"ooshika":       nil,
			"otaki":         nil,
			"otari":         nil,
			"sakae":         nil,
			"sakaki":        nil,
			"saku":          nil,
			"sakuho":        nil,
			"shimosuwa":     nil,
			"shinanomachi":  nil,
			"shiojiri":      nil,
			"suwa":          nil,
			"suzaka":        nil,
			"takagi":        nil,
			"takamori":      nil,
			"takayama":      nil,
			"tateshina":     nil,
			"tatsuno":       nil,
			"togakushi":     nil,
			"togura":        nil,
			"tomi":          nil,
			"ueda":          nil,
			"wada":          nil,
			"yamagata":      nil,
			"yamanouchi":    nil,
			"yasaka":        nil,
			"yasuoka":       nil,
		},
		"nagasaki": &tld{
			"chijiwa":      nil,
			"futsu":        nil,
			"goto":         nil,
			"hasami":       nil,
			"hirado":       nil,
			"iki":          nil,
			"isahaya":      nil,
			"kawatana":     nil,
			"kuchinotsu":   nil,
			"matsuura":     nil,
			"nagasaki":     nil,
			"obama":        nil,
			"omura":        nil,
			"oseto":        nil,
			"saikai":       nil,
			"sasebo":       nil,
			"seihi":        nil,
			"shimabara":    nil,
			"shinkamigoto": nil,
			"togitsu":      nil,
			"tsushima":     nil,
			"unzen":        nil,
		},
		"nagoya": &tld{
			"!city": nil,
			"*":     nil,
		},
		"nara": &tld{
			"ando":           nil,
			"gose":           nil,
			"heguri":         nil,
			"higashiyoshino": nil,
			"ikaruga":        nil,
			"ikoma":          nil,
			"kamikitayama":   nil,
			"kanmaki":        nil,
			"kashiba":        nil,
			"kashihara":      nil,
			"katsuragi":      nil,
			"kawai":          nil,
			"kawakami":       nil,
			"kawanishi":      nil,
			"koryo":          nil,
			"kurotaki":       nil,
			"mitsue":         nil,
			"miyake":         nil,
			"nara":           nil,
			"nosegawa":       nil,
			"oji":            nil,
			"ouda":           nil,
			"oyodo":          nil,
			"sakurai":        nil,
			"sango":          nil,
			"shimoichi":      nil,
			"shimokitayama":  nil,
			"shinjo":         nil,
			"soni":           nil,
			"takatori":       nil,
			"tawaramoto":     nil,
			"tenkawa":        nil,
			"tenri":          nil,
			"uda":            nil,
			"yamatokoriyama": nil,
			"yamatotakada":   nil,
			"yamazoe":        nil,
			"yoshino":        nil,
		},
		"ne": &tld{
			"aseinet": &tld{
				"user": nil,
			},
			"gehirn": nil,
		},
		"niigata": &tld{
			"aga":          nil,
			"agano":        nil,
			"gosen":        nil,
			"itoigawa":     nil,
			"izumozaki":    nil,
			"joetsu":       nil,
			"kamo":         nil,
			"kariwa":       nil,
			"kashiwazaki":  nil,
			"minamiuonuma": nil,
			"mitsuke":      nil,
			"muika":        nil,
			"murakami":     nil,
			"myoko":        nil,
			"nagaoka":      nil,
			"niigata":      nil,
			"ojiya":        nil,
			"omi":          nil,
			"sado":         nil,
			"sanjo":        nil,
			"seiro":        nil,
			"seirou":       nil,
			"sekikawa":     nil,
			"shibata":      nil,
			"tagami":       nil,
			"tainai":       nil,
			"tochio":       nil,
			"tokamachi":    nil,
			"tsubame":      nil,
			"tsunan":       nil,
			"uonuma":       nil,
			"yahiko":       nil,
			"yoita":        nil,
			"yuzawa":       nil,
		},
		"oita": &tld{
			"beppu":       nil,
			"bungoono":    nil,
			"bungotakada": nil,
			"hasama":      nil,
			"hiji":        nil,
			"himeshima":   nil,
			"hita":        nil,
			"kamitsue":    nil,
			"kokonoe":     nil,
			"kuju":        nil,
			"kunisaki":    nil,
			"kusu":        nil,
			"oita":        nil,
			"saiki":       nil,
			"taketa":      nil,
			"tsukumi":     nil,
			"usa":         nil,
			"usuki":       nil,
			"yufu":        nil,
		},
		"okayama": &tld{
			"akaiwa":       nil,
			"asakuchi":     nil,
			"bizen":        nil,
			"hayashima":    nil,
			"ibara":        nil,
			"kagamino":     nil,
			"kasaoka":      nil,
			"kibichuo":     nil,
			"kumenan":      nil,
			"kurashiki":    nil,
			"maniwa":       nil,
			"misaki":       nil,
			"nagi":         nil,
			"niimi":        nil,
			"nishiawakura": nil,
			"okayama":      nil,
			"satosho":      nil,
			"setouchi":     nil,
			"shinjo":       nil,
			"shoo":         nil,
			"soja":         nil,
			"takahashi":    nil,
			"tamano":       nil,
			"tsuyama":      nil,
			"wake":         nil,
			"yakage":       nil,
		},
		"okinawa": &tld{
			"aguni":          nil,
			"ginowan":        nil,
			"ginoza":         nil,
			"gushikami":      nil,
			"haebaru":        nil,
			"higashi":        nil,
			"hirara":         nil,
			"iheya":          nil,
			"ishigaki":       nil,
			"ishikawa":       nil,
			"itoman":         nil,
			"izena":          nil,
			"kadena":         nil,
			"kin":            nil,
			"kitadaito":      nil,
			"kitanakagusuku": nil,
			"kumejima":       nil,
			"kunigami":       nil,
			"minamidaito":    nil,
			"motobu":         nil,
			"nago":           nil,
			"naha":           nil,
			"nakagusuku":     nil,
			"nakijin":        nil,
			"nanjo":          nil,
			"nishihara":      nil,
			"ogimi":          nil,
			"okinawa":        nil,
			"onna":           nil,
			"shimoji":        nil,
			"taketomi":       nil,
			"tarama":         nil,
			"tokashiki":      nil,
			"tomigusuku":     nil,
			"tonaki":         nil,
			"urasoe":         nil,
			"uruma":          nil,
			"yaese":          nil,
			"yomitan":        nil,
			"yonabaru":       nil,
			"yonaguni":       nil,
			"zamami":         nil,
		},
		"or": nil,
		"osaka": &tld{
			"abeno":            nil,
			"chihayaakasaka":   nil,
			"chuo":             nil,
			"daito":            nil,
			"fujiidera":        nil,
			"habikino":         nil,
			"hannan":           nil,
			"higashiosaka":     nil,
			"higashisumiyoshi": nil,
			"higashiyodogawa":  nil,
			"hirakata":         nil,
			"ibaraki":          nil,
			"ikeda":            nil,
			"izumi":            nil,
			"izumiotsu":        nil,
			"izumisano":        nil,
			"kadoma":           nil,
			"kaizuka":          nil,
			"kanan":            nil,
			"kashiwara":        nil,
			"katano":           nil,
			"kawachinagano":    nil,
			"kishiwada":        nil,
			"kita":             nil,
			"kumatori":         nil,
			"matsubara":        nil,
			"minato":           nil,
			"minoh":            nil,
			"misaki":           nil,
			"moriguchi":        nil,
			"neyagawa":         nil,
			"nishi":            nil,
			"nose":             nil,
			"osakasayama":      nil,
			"sakai":            nil,
			"sayama":           nil,
			"sennan":           nil,
			"settsu":           nil,
			"shijonawate":      nil,
			"shimamoto":        nil,
			"suita":            nil,
			"tadaoka":          nil,
			"taishi":           nil,
			"tajiri":           nil,
			"takaishi":         nil,
			"takatsuki":        nil,
			"tondabayashi":     nil,
			"toyonaka":         nil,
			"toyono":           nil,
			"yao":              nil,
		},
		"saga": &tld{
			"ariake":      nil,
			"arita":       nil,
			"fukudomi":    nil,
			"genkai":      nil,
			"hamatama":    nil,
			"hizen":       nil,
			"imari":       nil,
			"kamimine":    nil,
			"kanzaki":     nil,
			"karatsu":     nil,
			"kashima":     nil,
			"kitagata":    nil,
			"kitahata":    nil,
			"kiyama":      nil,
			"kouhoku":     nil,
			"kyuragi":     nil,
			"nishiarita":  nil,
			"ogi":         nil,
			"omachi":      nil,
			"ouchi":       nil,
			"saga":        nil,
			"shiroishi":   nil,
			"taku":        nil,
			"tara":        nil,
			"tosu":        nil,
			"yoshinogari": nil,
		},
		"saitama": &tld{
			"arakawa":          nil,
			"asaka":            nil,
			"chichibu":         nil,
			"fujimi":           nil,
			"fujimino":         nil,
			"fukaya":           nil,
			"hanno":            nil,
			"hanyu":            nil,
			"hasuda":           nil,
			"hatogaya":         nil,
			"hatoyama":         nil,
			"hidaka":           nil,
			"higashichichibu":  nil,
			"higashimatsuyama": nil,
			"honjo":            nil,
			"ina":              nil,
			"iruma":            nil,
			"iwatsuki":         nil,
			"kamiizumi":        nil,
			"kamikawa":         nil,
			"kamisato":         nil,
			"kasukabe":         nil,
			"kawagoe":          nil,
			"kawaguchi":        nil,
			"kawajima":         nil,
			"kazo":             nil,
			"kitamoto":         nil,
			"koshigaya":        nil,
			"kounosu":          nil,
			"kuki":             nil,
			"kumagaya":         nil,
			"matsubushi":       nil,
			"minano":           nil,
			"misato":           nil,
			"miyashiro":        nil,
			"miyoshi":          nil,
			"moroyama":         nil,
			"nagatoro":         nil,
			"namegawa":         nil,
			"niiza":            nil,
			"ogano":            nil,
			"ogawa":            nil,
			"ogose":            nil,
			"okegawa":          nil,
			"omiya":            nil,
			"otaki":            nil,
			"ranzan":           nil,
			"ryokami":          nil,
			"saitama":          nil,
			"sakado":           nil,
			"satte":            nil,
			"sayama":           nil,
			"shiki":            nil,
			"shiraoka":         nil,
			"soka":             nil,
			"sugito":           nil,
			"toda":             nil,
			"tokigawa":         nil,
			"tokorozawa":       nil,
			"tsurugashima":     nil,
			"urawa":            nil,
			"warabi":           nil,
			"yashio":           nil,
			"yokoze":           nil,
			"yono":             nil,
			"yorii":            nil,
			"yoshida":          nil,
			"yoshikawa":        nil,
			"yoshimi":          nil,
		},
		"sapporo": &tld{
			"!city": nil,
			"*":     nil,
		},
		"sendai": &tld{
			"!city": nil,
			"*":     nil,
		},
		"shiga": &tld{
			"aisho":       nil,
			"gamo":        nil,
			"higashiomi":  nil,
			"hikone":      nil,
			"koka":        nil,
			"konan":       nil,
			"kosei":       nil,
			"koto":        nil,
			"kusatsu":     nil,
			"maibara":     nil,
			"moriyama":    nil,
			"nagahama":    nil,
			"nishiazai":   nil,
			"notogawa":    nil,
			"omihachiman": nil,
			"otsu":        nil,
			"ritto":       nil,
			"ryuoh":       nil,
			"takashima":   nil,
			"takatsuki":   nil,
			"torahime":    nil,
			"toyosato":    nil,
			"yasu":        nil,
		},
		"shimane": &tld{
			"akagi":        nil,
			"ama":          nil,
			"gotsu":        nil,
			"hamada":       nil,
			"higashiizumo": nil,
			"hikawa":       nil,
			"hikimi":       nil,
			"izumo":        nil,
			"kakinoki":     nil,
			"masuda":       nil,
			"matsue":       nil,
			"misato":       nil,
			"nishinoshima": nil,
			"ohda":         nil,
			"okinoshima":   nil,
			"okuizumo":     nil,
			"shimane":      nil,
			"tamayu":       nil,
			"tsuwano":      nil,
			"unnan":        nil,
			"yakumo":       nil,
			"yasugi":       nil,
			"yatsuka":      nil,
		},
		"shizuoka": &tld{
			"arai":       nil,
			"atami":      nil,
			"fuji":       nil,
			"fujieda":    nil,
			"fujikawa":   nil,
			"fujinomiya": nil,
			"fukuroi":    nil,
			"gotemba":    nil,
			"haibara":    nil,
			"hamamatsu":  nil,
			"higashiizu": nil,
			"ito":        nil,
			"iwata":      nil,
			"izu":        nil,
			"izunokuni":  nil,
			"kakegawa":   nil,
			"kannami":    nil,
			"kawanehon":  nil,
			"kawazu":     nil,
			"kikugawa":   nil,
			"kosai":      nil,
			"makinohara": nil,
			"matsuzaki":  nil,
			"minamiizu":  nil,
			"mishima":    nil,
			"morimachi":  nil,
			"nishiizu":   nil,
			"numazu":     nil,
			"omaezaki":   nil,
			"shimada":    nil,
			"shimizu":    nil,
			"shimoda":    nil,
			"shizuoka":   nil,
			"susono":     nil,
			"yaizu":      nil,
			"yoshida":    nil,
		},
		"tochigi": &tld{
			"ashikaga":     nil,
			"bato":         nil,
			"haga":         nil,
			"ichikai":      nil,
			"iwafune":      nil,
			"kaminokawa":   nil,
			"kanuma":       nil,
			"karasuyama":   nil,
			"kuroiso":      nil,
			"mashiko":      nil,
			"mibu":         nil,
			"moka":         nil,
			"motegi":       nil,
			"nasu":         nil,
			"nasushiobara": nil,
			"nikko":        nil,
			"nishikata":    nil,
			"nogi":         nil,
			"ohira":        nil,
			"ohtawara":     nil,
			"oyama":        nil,
			"sakura":       nil,
			"sano":         nil,
			"shimotsuke":   nil,
			"shioya":       nil,
			"takanezawa":   nil,
			"tochigi":      nil,
			"tsuga":        nil,
			"ujiie":        nil,
			"utsunomiya":   nil,
			"yaita":        nil,
		},
		"tokushima": &tld{
			"aizumi":       nil,
			"anan":         nil,
			"ichiba":       nil,
			"itano":        nil,
			"kainan":       nil,
			"komatsushima": nil,
			"matsushige":   nil,
			"mima":         nil,
			"minami":       nil,
			"miyoshi":      nil,
			"mugi":         nil,
			"nakagawa":     nil,
			"naruto":       nil,
			"sanagochi":    nil,
			"shishikui":    nil,
			"tokushima":    nil,
			"wajiki":       nil,
		},
		"tokyo": &tld{
			"adachi":          nil,
			"akiruno":         nil,
			"akishima":        nil,
			"aogashima":       nil,
			"arakawa":         nil,
			"bunkyo":          nil,
			"chiyoda":         nil,
			"chofu":           nil,
			"chuo":            nil,
			"edogawa":         nil,
			"fuchu":           nil,
			"fussa":           nil,
			"hachijo":         nil,
			"hachioji":        nil,
			"hamura":          nil,
			"higashikurume":   nil,
			"higashimurayama": nil,
			"higashiyamato":   nil,
			"hino":            nil,
			"hinode":          nil,
			"hinohara":        nil,
			"inagi":           nil,
			"itabashi":        nil,
			"katsushika":      nil,
			"kita":            nil,
			"kiyose":          nil,
			"kodaira":         nil,
			"koganei":         nil,
			"kokubunji":       nil,
			"komae":           nil,
			"koto":            nil,
			"kouzushima":      nil,
			"kunitachi":       nil,
			"machida":         nil,
			"meguro":          nil,
			"minato":          nil,
			"mitaka":          nil,
			"mizuho":          nil,
			"musashimurayama": nil,
			"musashino":       nil,
			"nakano":          nil,
			"nerima":          nil,
			"ogasawara":       nil,
			"okutama":         nil,
			"ome":             nil,
			"oshima":          nil,
			"ota":             nil,
			"setagaya":        nil,
			"shibuya":         nil,
			"shinagawa":       nil,
			"shinjuku":        nil,
			"suginami":        nil,
			"sumida":          nil,
			"tachikawa":       nil,
			"taito":           nil,
			"tama":            nil,
			"toshima":         nil,
		},
		"tottori": &tld{
			"chizu":       nil,
			"hino":        nil,
			"kawahara":    nil,
			"koge":        nil,
			"kotoura":     nil,
			"misasa":      nil,
			"nanbu":       nil,
			"nichinan":    nil,
			"sakaiminato": nil,
			"tottori":     nil,
			"wakasa":      nil,
			"yazu":        nil,
			"yonago":      nil,
		},
		"toyama": &tld{
			"asahi":       nil,
			"fuchu":       nil,
			"fukumitsu":   nil,
			"funahashi":   nil,
			"himi":        nil,
			"imizu":       nil,
			"inami":       nil,
			"johana":      nil,
			"kamiichi":    nil,
			"kurobe":      nil,
			"nakaniikawa": nil,
			"namerikawa":  nil,
			"nanto":       nil,
			"nyuzen":      nil,
			"oyabe":       nil,
			"taira":       nil,
			"takaoka":     nil,
			"tateyama":    nil,
			"toga":        nil,
			"tonami":      nil,
			"toyama":      nil,
			"unazuki":     nil,
			"uozu":        nil,
			"yamada":      nil,
		},
		"usercontent": nil,
		"wakayama": &tld{
			"arida":         nil,
			"aridagawa":     nil,
			"gobo":          nil,
			"hashimoto":     nil,
			"hidaka":        nil,
			"hirogawa":      nil,
			"inami":         nil,
			"iwade":         nil,
			"kainan":        nil,
			"kamitonda":     nil,
			"katsuragi":     nil,
			"kimino":        nil,
			"kinokawa":      nil,
			"kitayama":      nil,
			"koya":          nil,
			"koza":          nil,
			"kozagawa":      nil,
			"kudoyama":      nil,
			"kushimoto":     nil,
			"mihama":        nil,
			"misato":        nil,
			"nachikatsuura": nil,
			"shingu":        nil,
			"shirahama":     nil,
			"taiji":         nil,
			"tanabe":        nil,
			"wakayama":      nil,
			"yuasa":         nil,
			"yura":          nil,
		},
		"yamagata": &tld{
			"asahi":      nil,
			"funagata":   nil,
			"higashine":  nil,
			"iide":       nil,
			"kahoku":     nil,
			"kaminoyama": nil,
			"kaneyama":   nil,
			"kawanishi":  nil,
			"mamurogawa": nil,
			"mikawa":     nil,
			"murayama":   nil,
			"nagai":      nil,
			"nakayama":   nil,
			"nanyo":      nil,
			"nishikawa":  nil,
			"obanazawa":  nil,
			"oe":         nil,
			"oguni":      nil,
			"ohkura":     nil,
			"oishida":    nil,
			"sagae":      nil,
			"sakata":     nil,
			"sakegawa":   nil,
			"shinjo":     nil,
			"shirataka":  nil,
			"shonai":     nil,
			"takahata":   nil,
			"tendo":      nil,
			"tozawa":     nil,
			"tsuruoka":   nil,
			"yamagata":   nil,
			"yamanobe":   nil,
			"yonezawa":   nil,
			"yuza":       nil,
		},
		"yamaguchi": &tld{
			"abu":         nil,
			"hagi":        nil,
			"hikari":      nil,
			"hofu":        nil,
			"iwakuni":     nil,
			"kudamatsu":   nil,
			"mitou":       nil,
			"nagato":      nil,
			"oshima":      nil,
			"shimonoseki": nil,
			"shunan":      nil,
			"tabuse":      nil,
			"tokuyama":    nil,
			"toyota":      nil,
			"ube":         nil,
			"yuu":         nil,
		},
		"yamanashi": &tld{
			"chuo":            nil,
			"doshi":           nil,
			"fuefuki":         nil,
			"fujikawa":        nil,
			"fujikawaguchiko": nil,
			"fujiyoshida":     nil,
			"hayakawa":        nil,
			"hokuto":          nil,
			"ichikawamisato":  nil,
			"kai":             nil,
			"kofu":            nil,
			"koshu":           nil,
			"kosuge":          nil,
			"minami-alps":     nil,
			"minobu":          nil,
			"nakamichi":       nil,
			"nanbu":           nil,
			"narusawa":        nil,
			"nirasaki":        nil,
			"nishikatsura":    nil,
			"oshino":          nil,
			"otsuki":          nil,
			"showa":           nil,
			"tabayama":        nil,
			"tsuru":           nil,
			"uenohara":        nil,
			"yamanakako":      nil,
			"yamanashi":       nil,
		},
		"yokohama": &tld{
			"!city": nil,
			"*":     nil,
		},
		"三重":  nil,
		"京都":  nil,
		"佐賀":  nil,
		"兵庫":  nil,
		"北海道": nil,
		"千葉":  nil,
		"和歌山": nil,
		"埼玉":  nil,
		"大分":  nil,
		"大阪":  nil,
		"奈良":  nil,
		"宮城":  nil,
		"宮崎":  nil,
		"富山":  nil,
		"山口":  nil,
		"山形":  nil,
		"山梨":  nil,
		"岐阜":  nil,
		"岡山":  nil,
		"岩手":  nil,
		"島根":  nil,
		"広島":  nil,
		"徳島":  nil,
		"愛媛":  nil,
		"愛知":  nil,
		"新潟":  nil,
		"東京":  nil,
		"栃木":  nil,
		"沖縄":  nil,
		"滋賀":  nil,
		"熊本":  nil,
		"石川":  nil,
		"神奈川": nil,
		"福井":  nil,
		"福岡":  nil,
		"福島":  nil,
		"秋田":  nil,
		"群馬":  nil,
		"茨城":  nil,
		"長崎":  nil,
		"長野":  nil,
		"青森":  nil,
		"静岡":  nil,
		"香川":  nil,
		"高知":  nil,
		"鳥取":  nil,
		"鹿児島": nil,
	},
	"jpmorgan": nil,
	"jprs":     nil,
	"juegos":   nil,
	"juniper":  nil,
	"kaufen":   nil,
	"kddi":     nil,
	"ke": &tld{
		"ac": nil,
		"co": &tld{
			"blogspot": nil,
		},
		"go":   nil,
		"info": nil,
		"me":   nil,
		"mobi": nil,
		"ne":   nil,
		"nom":  nil,
		"or":   nil,
		"sc":   nil,
	},
	"kerryhotels":     nil,
	"kerrylogistics":  nil,
	"kerryproperties": nil,
	"kfh":             nil,
	"kg": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
	},
	"kh": &tld{
		"*": nil,
	},
	"ki": &tld{
		"biz":  nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"net":  nil,
		"org":  nil,
	},
	"kia":     nil,
	"kim":     nil,
	"kinder":  nil,
	"kindle":  nil,
	"kitchen": nil,
	"kiwi":    nil,
	"km": &tld{
		"ass":         nil,
		"asso":        nil,
		"com":         nil,
		"coop":        nil,
		"edu":         nil,
		"gouv":        nil,
		"gov":         nil,
		"medecin":     nil,
		"mil":         nil,
		"nom":         nil,
		"notaires":    nil,
		"org":         nil,
		"pharmaciens": nil,
		"prd":         nil,
		"presse":      nil,
		"tm":          nil,
		"veterinaire": nil,
	},
	"kn": &tld{
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"koeln":   nil,
	"komatsu": nil,
	"kosher":  nil,
	"kp": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"org": nil,
		"rep": nil,
		"tra": nil,
	},
	"kpmg": nil,
	"kpn":  nil,
	"kr": &tld{
		"ac":        nil,
		"blogspot":  nil,
		"busan":     nil,
		"chungbuk":  nil,
		"chungnam":  nil,
		"co":        nil,
		"daegu":     nil,
		"daejeon":   nil,
		"es":        nil,
		"gangwon":   nil,
		"go":        nil,
		"gwangju":   nil,
		"gyeongbuk": nil,
		"gyeonggi":  nil,
		"gyeongnam": nil,
		"hs":        nil,
		"incheon":   nil,
		"jeju":      nil,
		"jeonbuk":   nil,
		"jeonnam":   nil,
		"kg":        nil,
		"mil":       nil,
		"ms":        nil,
		"ne":        nil,
		"or":        nil,
		"pe":        nil,
		"re":        nil,
		"sc":        nil,
		"seoul":     nil,
		"ulsan":     nil,
	},
	"krd": &tld{
		"co":  nil,
		"edu": nil,
	},
	"kred":      nil,
	"kuokgroup": nil,
	"kw": &tld{
		"com": nil,
		"edu": nil,
		"emb": nil,
		"gov": nil,
		"ind": nil,
		"net": nil,
		"org": nil,
	},
	"ky": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"kyoto": nil,
	"kz": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"nym": nil,
		"org": nil,
	},
	"la": &tld{
		"bnr":  nil,
		"c":    nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"int":  nil,
		"net":  nil,
		"nym":  nil,
		"org":  nil,
		"per":  nil,
	},
	"lacaixa":     nil,
	"ladbrokes":   nil,
	"lamborghini": nil,
	"lamer":       nil,
	"lancaster":   nil,
	"lancia":      nil,
	"lancome":     nil,
	"land": &tld{
		"static": &tld{
			"dev":   nil,
			"sites": nil,
		},
	},
	"landrover": nil,
	"lanxess":   nil,
	"lasalle":   nil,
	"lat":       nil,
	"latino":    nil,
	"latrobe":   nil,
	"law":       nil,
	"lawyer":    nil,
	"lb": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"lc": &tld{
		"co":  nil,
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"nym": nil,
		"org": nil,
		"oy":  nil,
	},
	"lds":     nil,
	"lease":   nil,
	"leclerc": nil,
	"lefrak":  nil,
	"legal":   nil,
	"lego":    nil,
	"lexus":   nil,
	"lgbt":    nil,
	"li": &tld{
		"blogspot": nil,
		"caa":      nil,
		"nom":      nil,
		"nym":      nil,
	},
	"liaison":       nil,
	"lidl":          nil,
	"life":          nil,
	"lifeinsurance": nil,
	"lifestyle":     nil,
	"lighting":      nil,
	"like":          nil,
	"lilly":         nil,
	"limited":       nil,
	"limo":          nil,
	"lincoln":       nil,
	"linde":         nil,
	"link": &tld{
		"cyon": nil,
		"dweb": &tld{
			"*": nil,
		},
		"mypep": nil,
	},
	"lipsy":  nil,
	"live":   nil,
	"living": nil,
	"lixil":  nil,
	"lk": &tld{
		"ac":    nil,
		"assn":  nil,
		"com":   nil,
		"edu":   nil,
		"gov":   nil,
		"grp":   nil,
		"hotel": nil,
		"int":   nil,
		"ltd":   nil,
		"net":   nil,
		"ngo":   nil,
		"org":   nil,
		"sch":   nil,
		"soc":   nil,
		"web":   nil,
	},
	"llc":    nil,
	"llp":    nil,
	"loan":   nil,
	"loans":  nil,
	"locker": nil,
	"locus":  nil,
	"loft":   nil,
	"lol":    nil,
	"london": &tld{
		"in": nil,
		"of": nil,
	},
	"lotte":        nil,
	"lotto":        nil,
	"love":         nil,
	"lpl":          nil,
	"lplfinancial": nil,
	"lr": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"ls": &tld{
		"ac":   nil,
		"biz":  nil,
		"co":   nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"net":  nil,
		"org":  nil,
		"sc":   nil,
	},
	"lt": &tld{
		"blogspot": nil,
		"gov":      nil,
		"nym":      nil,
	},
	"ltd":  nil,
	"ltda": nil,
	"lu": &tld{
		"blogspot": nil,
		"nym":      nil,
	},
	"lundbeck": nil,
	"lupin":    nil,
	"luxe":     nil,
	"luxury":   nil,
	"lv": &tld{
		"asn":  nil,
		"com":  nil,
		"conf": nil,
		"edu":  nil,
		"gov":  nil,
		"id":   nil,
		"mil":  nil,
		"net":  nil,
		"org":  nil,
	},
	"ly": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"id":  nil,
		"med": nil,
		"net": nil,
		"org": nil,
		"plc": nil,
		"sch": nil,
	},
	"ma": &tld{
		"ac":    nil,
		"co":    nil,
		"gov":   nil,
		"net":   nil,
		"org":   nil,
		"press": nil,
	},
	"macys":  nil,
	"madrid": nil,
	"maif":   nil,
	"maison": nil,
	"makeup": nil,
	"man":    nil,
	"management": &tld{
		"router": nil,
	},
	"mango":     nil,
	"map":       nil,
	"market":    nil,
	"marketing": nil,
	"markets":   nil,
	"marriott":  nil,
	"marshalls": nil,
	"maserati":  nil,
	"mattel":    nil,
	"mba":       nil,
	"mc": &tld{
		"asso": nil,
		"tm":   nil,
	},
	"mckinsey": nil,
	"md": &tld{
		"blogspot": nil,
	},
	"me": &tld{
		"ac":       nil,
		"barsy":    nil,
		"brasilia": nil,
		"c66":      nil,
		"co":       nil,
		"daplie": &tld{
			"localhost": nil,
		},
		"ddns":        nil,
		"diskstation": nil,
		"dnsfor":      nil,
		"dscloud":     nil,
		"edu":         nil,
		"filegear":    nil,
		"filegear-au": nil,
		"filegear-de": nil,
		"filegear-gb": nil,
		"filegear-ie": nil,
		"filegear-jp": nil,
		"filegear-sg": nil,
		"glitch":      nil,
		"gov":         nil,
		"hopto":       nil,
		"i234":        nil,
		"its":         nil,
		"loginto":     nil,
		"myds":        nil,
		"nctu":        nil,
		"net":         nil,
		"nohost":      nil,
		"noip":        nil,
		"nym":         nil,
		"org":         nil,
		"priv":        nil,
		"ravendb":     nil,
		"soundcast":   nil,
		"synology":    nil,
		"tcp4":        nil,
		"webhop":      nil,
		"wedeploy":    nil,
		"yombo":       nil,
	},
	"med":       nil,
	"media":     nil,
	"meet":      nil,
	"melbourne": nil,
	"meme":      nil,
	"memorial":  nil,
	"men": &tld{
		"for": nil,
	},
	"menu": &tld{
		"barsy": nil,
	},
	"merckmsd": nil,
	"metlife":  nil,
	"mg": &tld{
		"co":  nil,
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"nom": nil,
		"org": nil,
		"prd": nil,
		"tm":  nil,
	},
	"mh":         nil,
	"miami":      nil,
	"microsoft":  nil,
	"mil":        nil,
	"mini":       nil,
	"mint":       nil,
	"mit":        nil,
	"mitsubishi": nil,
	"mk": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"inf":      nil,
		"name":     nil,
		"net":      nil,
		"nom":      nil,
		"org":      nil,
	},
	"ml": &tld{
		"com":    nil,
		"edu":    nil,
		"gouv":   nil,
		"gov":    nil,
		"net":    nil,
		"org":    nil,
		"presse": nil,
	},
	"mlb": nil,
	"mls": nil,
	"mm": &tld{
		"*": nil,
	},
	"mma": nil,
	"mn": &tld{
		"edu": nil,
		"gov": nil,
		"nyc": nil,
		"nym": nil,
		"org": nil,
	},
	"mo": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"mobi": &tld{
		"barsy":   nil,
		"dscloud": nil,
	},
	"mobile": nil,
	"mobily": nil,
	"moda":   nil,
	"moe":    nil,
	"moi":    nil,
	"mom": &tld{
		"and": nil,
		"for": nil,
	},
	"monash":      nil,
	"money":       nil,
	"monster":     nil,
	"mopar":       nil,
	"mormon":      nil,
	"mortgage":    nil,
	"moscow":      nil,
	"moto":        nil,
	"motorcycles": nil,
	"mov":         nil,
	"movie":       nil,
	"movistar":    nil,
	"mp":          nil,
	"mq":          nil,
	"mr": &tld{
		"blogspot": nil,
		"gov":      nil,
	},
	"ms": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"lab": nil,
		"net": nil,
		"org": nil,
	},
	"msd": nil,
	"mt": &tld{
		"com": &tld{
			"blogspot": nil,
		},
		"edu": nil,
		"net": nil,
		"org": nil,
	},
	"mtn": nil,
	"mtr": nil,
	"mu": &tld{
		"ac":  nil,
		"co":  nil,
		"com": nil,
		"gov": nil,
		"net": nil,
		"or":  nil,
		"org": nil,
	},
	"museum": &tld{
		"academy":                      nil,
		"agriculture":                  nil,
		"air":                          nil,
		"airguard":                     nil,
		"alabama":                      nil,
		"alaska":                       nil,
		"amber":                        nil,
		"ambulance":                    nil,
		"american":                     nil,
		"americana":                    nil,
		"americanantiques":             nil,
		"americanart":                  nil,
		"amsterdam":                    nil,
		"and":                          nil,
		"annefrank":                    nil,
		"anthro":                       nil,
		"anthropology":                 nil,
		"antiques":                     nil,
		"aquarium":                     nil,
		"arboretum":                    nil,
		"archaeological":               nil,
		"archaeology":                  nil,
		"architecture":                 nil,
		"art":                          nil,
		"artanddesign":                 nil,
		"artcenter":                    nil,
		"artdeco":                      nil,
		"arteducation":                 nil,
		"artgallery":                   nil,
		"arts":                         nil,
		"artsandcrafts":                nil,
		"asmatart":                     nil,
		"assassination":                nil,
		"assisi":                       nil,
		"association":                  nil,
		"astronomy":                    nil,
		"atlanta":                      nil,
		"austin":                       nil,
		"australia":                    nil,
		"automotive":                   nil,
		"aviation":                     nil,
		"axis":                         nil,
		"badajoz":                      nil,
		"baghdad":                      nil,
		"bahn":                         nil,
		"bale":                         nil,
		"baltimore":                    nil,
		"barcelona":                    nil,
		"baseball":                     nil,
		"basel":                        nil,
		"baths":                        nil,
		"bauern":                       nil,
		"beauxarts":                    nil,
		"beeldengeluid":                nil,
		"bellevue":                     nil,
		"bergbau":                      nil,
		"berkeley":                     nil,
		"berlin":                       nil,
		"bern":                         nil,
		"bible":                        nil,
		"bilbao":                       nil,
		"bill":                         nil,
		"birdart":                      nil,
		"birthplace":                   nil,
		"bonn":                         nil,
		"boston":                       nil,
		"botanical":                    nil,
		"botanicalgarden":              nil,
		"botanicgarden":                nil,
		"botany":                       nil,
		"brandywinevalley":             nil,
		"brasil":                       nil,
		"bristol":                      nil,
		"british":                      nil,
		"britishcolumbia":              nil,
		"broadcast":                    nil,
		"brunel":                       nil,
		"brussel":                      nil,
		"brussels":                     nil,
		"bruxelles":                    nil,
		"building":                     nil,
		"burghof":                      nil,
		"bus":                          nil,
		"bushey":                       nil,
		"cadaques":                     nil,
		"california":                   nil,
		"cambridge":                    nil,
		"can":                          nil,
		"canada":                       nil,
		"capebreton":                   nil,
		"carrier":                      nil,
		"cartoonart":                   nil,
		"casadelamoneda":               nil,
		"castle":                       nil,
		"castres":                      nil,
		"celtic":                       nil,
		"center":                       nil,
		"chattanooga":                  nil,
		"cheltenham":                   nil,
		"chesapeakebay":                nil,
		"chicago":                      nil,
		"children":                     nil,
		"childrens":                    nil,
		"childrensgarden":              nil,
		"chiropractic":                 nil,
		"chocolate":                    nil,
		"christiansburg":               nil,
		"cincinnati":                   nil,
		"cinema":                       nil,
		"circus":                       nil,
		"civilisation":                 nil,
		"civilization":                 nil,
		"civilwar":                     nil,
		"clinton":                      nil,
		"clock":                        nil,
		"coal":                         nil,
		"coastaldefence":               nil,
		"cody":                         nil,
		"coldwar":                      nil,
		"collection":                   nil,
		"colonialwilliamsburg":         nil,
		"coloradoplateau":              nil,
		"columbia":                     nil,
		"columbus":                     nil,
		"communication":                nil,
		"communications":               nil,
		"community":                    nil,
		"computer":                     nil,
		"computerhistory":              nil,
		"comunicações":                 nil,
		"contemporary":                 nil,
		"contemporaryart":              nil,
		"convent":                      nil,
		"copenhagen":                   nil,
		"corporation":                  nil,
		"correios-e-telecomunicações":  nil,
		"corvette":                     nil,
		"costume":                      nil,
		"countryestate":                nil,
		"county":                       nil,
		"crafts":                       nil,
		"cranbrook":                    nil,
		"creation":                     nil,
		"cultural":                     nil,
		"culturalcenter":               nil,
		"culture":                      nil,
		"cyber":                        nil,
		"cymru":                        nil,
		"dali":                         nil,
		"dallas":                       nil,
		"database":                     nil,
		"ddr":                          nil,
		"decorativearts":               nil,
		"delaware":                     nil,
		"delmenhorst":                  nil,
		"denmark":                      nil,
		"depot":                        nil,
		"design":                       nil,
		"detroit":                      nil,
		"dinosaur":                     nil,
		"discovery":                    nil,
		"dolls":                        nil,
		"donostia":                     nil,
		"durham":                       nil,
		"eastafrica":                   nil,
		"eastcoast":                    nil,
		"education":                    nil,
		"educational":                  nil,
		"egyptian":                     nil,
		"eisenbahn":                    nil,
		"elburg":                       nil,
		"elvendrell":                   nil,
		"embroidery":                   nil,
		"encyclopedic":                 nil,
		"england":                      nil,
		"entomology":                   nil,
		"environment":                  nil,
		"environmentalconservation":    nil,
		"epilepsy":                     nil,
		"essex":                        nil,
		"estate":                       nil,
		"ethnology":                    nil,
		"exeter":                       nil,
		"exhibition":                   nil,
		"family":                       nil,
		"farm":                         nil,
		"farmequipment":                nil,
		"farmers":                      nil,
		"farmstead":                    nil,
		"field":                        nil,
		"figueres":                     nil,
		"filatelia":                    nil,
		"film":                         nil,
		"fineart":                      nil,
		"finearts":                     nil,
		"finland":                      nil,
		"flanders":                     nil,
		"florida":                      nil,
		"force":                        nil,
		"fortmissoula":                 nil,
		"fortworth":                    nil,
		"foundation":                   nil,
		"francaise":                    nil,
		"frankfurt":                    nil,
		"franziskaner":                 nil,
		"freemasonry":                  nil,
		"freiburg":                     nil,
		"fribourg":                     nil,
		"frog":                         nil,
		"fundacio":                     nil,
		"furniture":                    nil,
		"gallery":                      nil,
		"garden":                       nil,
		"gateway":                      nil,
		"geelvinck":                    nil,
		"gemological":                  nil,
		"geology":                      nil,
		"georgia":                      nil,
		"giessen":                      nil,
		"glas":                         nil,
		"glass":                        nil,
		"gorge":                        nil,
		"grandrapids":                  nil,
		"graz":                         nil,
		"guernsey":                     nil,
		"halloffame":                   nil,
		"hamburg":                      nil,
		"handson":                      nil,
		"harvestcelebration":           nil,
		"hawaii":                       nil,
		"health":                       nil,
		"heimatunduhren":               nil,
		"hellas":                       nil,
		"helsinki":                     nil,
		"hembygdsforbund":              nil,
		"heritage":                     nil,
		"histoire":                     nil,
		"historical":                   nil,
		"historicalsociety":            nil,
		"historichouses":               nil,
		"historisch":                   nil,
		"historisches":                 nil,
		"history":                      nil,
		"historyofscience":             nil,
		"horology":                     nil,
		"house":                        nil,
		"humanities":                   nil,
		"illustration":                 nil,
		"imageandsound":                nil,
		"indian":                       nil,
		"indiana":                      nil,
		"indianapolis":                 nil,
		"indianmarket":                 nil,
		"intelligence":                 nil,
		"interactive":                  nil,
		"iraq":                         nil,
		"iron":                         nil,
		"isleofman":                    nil,
		"jamison":                      nil,
		"jefferson":                    nil,
		"jerusalem":                    nil,
		"jewelry":                      nil,
		"jewish":                       nil,
		"jewishart":                    nil,
		"jfk":                          nil,
		"journalism":                   nil,
		"judaica":                      nil,
		"judygarland":                  nil,
		"juedisches":                   nil,
		"juif":                         nil,
		"karate":                       nil,
		"karikatur":                    nil,
		"kids":                         nil,
		"koebenhavn":                   nil,
		"koeln":                        nil,
		"kunst":                        nil,
		"kunstsammlung":                nil,
		"kunstunddesign":               nil,
		"labor":                        nil,
		"labour":                       nil,
		"lajolla":                      nil,
		"lancashire":                   nil,
		"landes":                       nil,
		"lans":                         nil,
		"larsson":                      nil,
		"lewismiller":                  nil,
		"lincoln":                      nil,
		"linz":                         nil,
		"living":                       nil,
		"livinghistory":                nil,
		"localhistory":                 nil,
		"london":                       nil,
		"losangeles":                   nil,
		"louvre":                       nil,
		"loyalist":                     nil,
		"lucerne":                      nil,
		"luxembourg":                   nil,
		"luzern":                       nil,
		"läns":                         nil,
		"mad":                          nil,
		"madrid":                       nil,
		"mallorca":                     nil,
		"manchester":                   nil,
		"mansion":                      nil,
		"mansions":                     nil,
		"manx":                         nil,
		"marburg":                      nil,
		"maritime":                     nil,
		"maritimo":                     nil,
		"maryland":                     nil,
		"marylhurst":                   nil,
		"media":                        nil,
		"medical":                      nil,
		"medizinhistorisches":          nil,
		"meeres":                       nil,
		"memorial":                     nil,
		"mesaverde":                    nil,
		"michigan":                     nil,
		"midatlantic":                  nil,
		"military":                     nil,
		"mill":                         nil,
		"miners":                       nil,
		"mining":                       nil,
		"minnesota":                    nil,
		"missile":                      nil,
		"missoula":                     nil,
		"modern":                       nil,
		"moma":                         nil,
		"money":                        nil,
		"monmouth":                     nil,
		"monticello":                   nil,
		"montreal":                     nil,
		"moscow":                       nil,
		"motorcycle":                   nil,
		"muenchen":                     nil,
		"muenster":                     nil,
		"mulhouse":                     nil,
		"muncie":                       nil,
		"museet":                       nil,
		"museumcenter":                 nil,
		"museumvereniging":             nil,
		"music":                        nil,
		"national":                     nil,
		"nationalfirearms":             nil,
		"nationalheritage":             nil,
		"nativeamerican":               nil,
		"naturalhistory":               nil,
		"naturalhistorymuseum":         nil,
		"naturalsciences":              nil,
		"nature":                       nil,
		"naturhistorisches":            nil,
		"natuurwetenschappen":          nil,
		"naumburg":                     nil,
		"naval":                        nil,
		"nebraska":                     nil,
		"neues":                        nil,
		"newhampshire":                 nil,
		"newjersey":                    nil,
		"newmexico":                    nil,
		"newport":                      nil,
		"newspaper":                    nil,
		"newyork":                      nil,
		"niepce":                       nil,
		"norfolk":                      nil,
		"north":                        nil,
		"nrw":                          nil,
		"nyc":                          nil,
		"nyny":                         nil,
		"oceanographic":                nil,
		"oceanographique":              nil,
		"omaha":                        nil,
		"online":                       nil,
		"ontario":                      nil,
		"openair":                      nil,
		"oregon":                       nil,
		"oregontrail":                  nil,
		"otago":                        nil,
		"oxford":                       nil,
		"pacific":                      nil,
		"paderborn":                    nil,
		"palace":                       nil,
		"paleo":                        nil,
		"palmsprings":                  nil,
		"panama":                       nil,
		"paris":                        nil,
		"pasadena":                     nil,
		"pharmacy":                     nil,
		"philadelphia":                 nil,
		"philadelphiaarea":             nil,
		"philately":                    nil,
		"phoenix":                      nil,
		"photography":                  nil,
		"pilots":                       nil,
		"pittsburgh":                   nil,
		"planetarium":                  nil,
		"plantation":                   nil,
		"plants":                       nil,
		"plaza":                        nil,
		"portal":                       nil,
		"portland":                     nil,
		"portlligat":                   nil,
		"posts-and-telecommunications": nil,
		"preservation":                 nil,
		"presidio":                     nil,
		"press":                        nil,
		"project":                      nil,
		"public":                       nil,
		"pubol":                        nil,
		"quebec":                       nil,
		"railroad":                     nil,
		"railway":                      nil,
		"research":                     nil,
		"resistance":                   nil,
		"riodejaneiro":                 nil,
		"rochester":                    nil,
		"rockart":                      nil,
		"roma":                         nil,
		"russia":                       nil,
		"saintlouis":                   nil,
		"salem":                        nil,
		"salvadordali":                 nil,
		"salzburg":                     nil,
		"sandiego":                     nil,
		"sanfrancisco":                 nil,
		"santabarbara":                 nil,
		"santacruz":                    nil,
		"santafe":                      nil,
		"saskatchewan":                 nil,
		"satx":                         nil,
		"savannahga":                   nil,
		"schlesisches":                 nil,
		"schoenbrunn":                  nil,
		"schokoladen":                  nil,
		"school":                       nil,
		"schweiz":                      nil,
		"science":                      nil,
		"science-fiction":              nil,
		"scienceandhistory":            nil,
		"scienceandindustry":           nil,
		"sciencecenter":                nil,
		"sciencecenters":               nil,
		"sciencehistory":               nil,
		"sciences":                     nil,
		"sciencesnaturelles":           nil,
		"scotland":                     nil,
		"seaport":                      nil,
		"settlement":                   nil,
		"settlers":                     nil,
		"shell":                        nil,
		"sherbrooke":                   nil,
		"sibenik":                      nil,
		"silk":                         nil,
		"ski":                          nil,
		"skole":                        nil,
		"society":                      nil,
		"sologne":                      nil,
		"soundandvision":               nil,
		"southcarolina":                nil,
		"southwest":                    nil,
		"space":                        nil,
		"spy":                          nil,
		"square":                       nil,
		"stadt":                        nil,
		"stalbans":                     nil,
		"starnberg":                    nil,
		"state":                        nil,
		"stateofdelaware":              nil,
		"station":                      nil,
		"steam":                        nil,
		"steiermark":                   nil,
		"stjohn":                       nil,
		"stockholm":                    nil,
		"stpetersburg":                 nil,
		"stuttgart":                    nil,
		"suisse":                       nil,
		"surgeonshall":                 nil,
		"surrey":                       nil,
		"svizzera":                     nil,
		"sweden":                       nil,
		"sydney":                       nil,
		"tank":                         nil,
		"tcm":                          nil,
		"technology":                   nil,
		"telekommunikation":            nil,
		"television":                   nil,
		"texas":                        nil,
		"textile":                      nil,
		"theater":                      nil,
		"time":                         nil,
		"timekeeping":                  nil,
		"topology":                     nil,
		"torino":                       nil,
		"touch":                        nil,
		"town":                         nil,
		"transport":                    nil,
		"tree":                         nil,
		"trolley":                      nil,
		"trust":                        nil,
		"trustee":                      nil,
		"uhren":                        nil,
		"ulm":                          nil,
		"undersea":                     nil,
		"university":                   nil,
		"usa":                          nil,
		"usantiques":                   nil,
		"usarts":                       nil,
		"uscountryestate":              nil,
		"usculture":                    nil,
		"usdecorativearts":             nil,
		"usgarden":                     nil,
		"ushistory":                    nil,
		"ushuaia":                      nil,
		"uslivinghistory":              nil,
		"utah":                         nil,
		"uvic":                         nil,
		"valley":                       nil,
		"vantaa":                       nil,
		"versailles":                   nil,
		"viking":                       nil,
		"village":                      nil,
		"virginia":                     nil,
		"virtual":                      nil,
		"virtuel":                      nil,
		"vlaanderen":                   nil,
		"volkenkunde":                  nil,
		"wales":                        nil,
		"wallonie":                     nil,
		"war":                          nil,
		"washingtondc":                 nil,
		"watch-and-clock":              nil,
		"watchandclock":                nil,
		"western":                      nil,
		"westfalen":                    nil,
		"whaling":                      nil,
		"wildlife":                     nil,
		"williamsburg":                 nil,
		"windmill":                     nil,
		"workshop":                     nil,
		"york":                         nil,
		"yorkshire":                    nil,
		"yosemite":                     nil,
		"youth":                        nil,
		"zoological":                   nil,
		"zoology":                      nil,
		"иком":                         nil,
		"ירושלים":                      nil,
	},
	"mutual": nil,
	"mv": &tld{
		"aero":   nil,
		"biz":    nil,
		"com":    nil,
		"coop":   nil,
		"edu":    nil,
		"gov":    nil,
		"info":   nil,
		"int":    nil,
		"mil":    nil,
		"museum": nil,
		"name":   nil,
		"net":    nil,
		"org":    nil,
		"pro":    nil,
	},
	"mw": &tld{
		"ac":     nil,
		"biz":    nil,
		"co":     nil,
		"com":    nil,
		"coop":   nil,
		"edu":    nil,
		"gov":    nil,
		"int":    nil,
		"museum": nil,
		"net":    nil,
		"org":    nil,
	},
	"mx": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gob":      nil,
		"net":      nil,
		"nym":      nil,
		"org":      nil,
	},
	"my": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"mil":      nil,
		"name":     nil,
		"net":      nil,
		"org":      nil,
	},
	"mz": &tld{
		"ac":  nil,
		"adv": nil,
		"co":  nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
	},
	"na": &tld{
		"ca":     nil,
		"cc":     nil,
		"co":     nil,
		"com":    nil,
		"dr":     nil,
		"in":     nil,
		"info":   nil,
		"mobi":   nil,
		"mx":     nil,
		"name":   nil,
		"or":     nil,
		"org":    nil,
		"pro":    nil,
		"school": nil,
		"tv":     nil,
		"us":     nil,
		"ws":     nil,
	},
	"nab":    nil,
	"nadex":  nil,
	"nagoya": nil,
	"name": &tld{
		"her": &tld{
			"forgot": nil,
		},
		"his": &tld{
			"forgot": nil,
		},
	},
	"nationwide": nil,
	"natura":     nil,
	"navy":       nil,
	"nba":        nil,
	"nc": &tld{
		"asso": nil,
		"nom":  nil,
	},
	"ne":  nil,
	"nec": nil,
	"net": &tld{
		"alwaysdata":    nil,
		"at-band-camp":  nil,
		"azure-mobile":  nil,
		"azurewebsites": nil,
		"barsy":         nil,
		"blackbaudcdn":  nil,
		"blogdns":       nil,
		"boomla":        nil,
		"bounceme":      nil,
		"bplaced":       nil,
		"broke-it":      nil,
		"buyshouses":    nil,
		"casacam":       nil,
		"cdn77": &tld{
			"r": nil,
		},
		"cdn77-ssl":      nil,
		"channelsdvr":    nil,
		"cloudaccess":    nil,
		"cloudapp":       nil,
		"cloudeity":      nil,
		"cloudfront":     nil,
		"cloudfunctions": nil,
		"cloudycluster":  nil,
		"cryptonomic": &tld{
			"*": nil,
		},
		"dattolocal":     nil,
		"ddns":           nil,
		"debian":         nil,
		"definima":       nil,
		"dnsalias":       nil,
		"dnsdojo":        nil,
		"dnsup":          nil,
		"does-it":        nil,
		"dontexist":      nil,
		"dsmynas":        nil,
		"dynalias":       nil,
		"dynathome":      nil,
		"dynu":           nil,
		"dynv6":          nil,
		"eating-organic": nil,
		"endofinternet":  nil,
		"familyds":       nil,
		"fastly": &tld{
			"freetls": nil,
			"map":     nil,
			"prod": &tld{
				"a":      nil,
				"global": nil,
			},
			"ssl": &tld{
				"a":      nil,
				"b":      nil,
				"global": nil,
			},
		},
		"fastlylb": &tld{
			"map": nil,
		},
		"feste-ip":                 nil,
		"firewall-gateway":         nil,
		"flynnhosting":             nil,
		"from-az":                  nil,
		"from-co":                  nil,
		"from-la":                  nil,
		"from-ny":                  nil,
		"gb":                       nil,
		"gets-it":                  nil,
		"go-vip":                   nil,
		"ham-radio-op":             nil,
		"hicam":                    nil,
		"homeftp":                  nil,
		"homeip":                   nil,
		"homelinux":                nil,
		"homeunix":                 nil,
		"hu":                       nil,
		"in":                       nil,
		"in-dsl":                   nil,
		"in-the-band":              nil,
		"in-vpn":                   nil,
		"iobb":                     nil,
		"ipifony":                  nil,
		"is-a-chef":                nil,
		"is-a-geek":                nil,
		"isa-geek":                 nil,
		"jp":                       nil,
		"kicks-ass":                nil,
		"kinghost":                 nil,
		"knx-server":               nil,
		"memset":                   nil,
		"moonscale":                nil,
		"mydatto":                  nil,
		"mydissent":                nil,
		"myeffect":                 nil,
		"myfritz":                  nil,
		"mymediapc":                nil,
		"mypsx":                    nil,
		"mysecuritycamera":         nil,
		"nhlfan":                   nil,
		"no-ip":                    nil,
		"now-dns":                  nil,
		"office-on-the":            nil,
		"ownip":                    nil,
		"pgafan":                   nil,
		"podzone":                  nil,
		"privatizehealthinsurance": nil,
		"rackmaze":                 nil,
		"redirectme":               nil,
		"ru":                       nil,
		"schokokeks":               nil,
		"scrapper-site":            nil,
		"se":                       nil,
		"selfip":                   nil,
		"sells-it":                 nil,
		"servebbs":                 nil,
		"serveblog":                nil,
		"serveftp":                 nil,
		"serveminecraft":           nil,
		"siteleaf":                 nil,
		"square7":                  nil,
		"srcf": &tld{
			"soc":  nil,
			"user": nil,
		},
		"static-access": nil,
		"sytes":         nil,
		"t3l3p0rt":      nil,
		"thruhere":      nil,
		"twmail":        nil,
		"uk":            nil,
		"uni5":          nil,
		"vpndns":        nil,
		"webhop":        nil,
		"yandexcloud": &tld{
			"storage": nil,
			"website": nil,
		},
		"za": nil,
	},
	"netbank": nil,
	"netflix": nil,
	"network": &tld{
		"alces": &tld{
			"*": nil,
		},
		"arvo":    nil,
		"azimuth": nil,
		"co":      nil,
	},
	"neustar":    nil,
	"new":        nil,
	"newholland": nil,
	"news":       nil,
	"next":       nil,
	"nextdirect": nil,
	"nexus":      nil,
	"nf": &tld{
		"arts":  nil,
		"com":   nil,
		"firm":  nil,
		"info":  nil,
		"net":   nil,
		"other": nil,
		"per":   nil,
		"rec":   nil,
		"store": nil,
		"web":   nil,
	},
	"nfl": nil,
	"ng": &tld{
		"col": nil,
		"com": &tld{
			"blogspot": nil,
		},
		"edu":  nil,
		"firm": nil,
		"gen":  nil,
		"gov":  nil,
		"i":    nil,
		"ltd":  nil,
		"mil":  nil,
		"mobi": nil,
		"name": nil,
		"net":  nil,
		"org":  nil,
		"sch":  nil,
	},
	"ngo": nil,
	"nhk": nil,
	"ni": &tld{
		"ac":   nil,
		"biz":  nil,
		"co":   nil,
		"com":  nil,
		"edu":  nil,
		"gob":  nil,
		"in":   nil,
		"info": nil,
		"int":  nil,
		"mil":  nil,
		"net":  nil,
		"nom":  nil,
		"org":  nil,
		"web":  nil,
	},
	"nico":   nil,
	"nike":   nil,
	"nikon":  nil,
	"ninja":  nil,
	"nissan": nil,
	"nissay": nil,
	"nl": &tld{
		"blogspot":        nil,
		"cistron":         nil,
		"co":              nil,
		"demon":           nil,
		"hosting-cluster": nil,
		"khplay":          nil,
		"transurl": &tld{
			"*": nil,
		},
		"virtueeldomein": nil,
	},
	"no": &tld{
		"aa": &tld{
			"gs": nil,
		},
		"aarborte": nil,
		"aejrie":   nil,
		"afjord":   nil,
		"agdenes":  nil,
		"ah": &tld{
			"gs": nil,
		},
		"akershus": &tld{
			"nes": nil,
		},
		"aknoluokta":     nil,
		"akrehamn":       nil,
		"al":             nil,
		"alaheadju":      nil,
		"alesund":        nil,
		"algard":         nil,
		"alstahaug":      nil,
		"alta":           nil,
		"alvdal":         nil,
		"amli":           nil,
		"amot":           nil,
		"andasuolo":      nil,
		"andebu":         nil,
		"andoy":          nil,
		"andøy":          nil,
		"ardal":          nil,
		"aremark":        nil,
		"arendal":        nil,
		"arna":           nil,
		"aseral":         nil,
		"asker":          nil,
		"askim":          nil,
		"askoy":          nil,
		"askvoll":        nil,
		"askøy":          nil,
		"asnes":          nil,
		"audnedaln":      nil,
		"aukra":          nil,
		"aure":           nil,
		"aurland":        nil,
		"aurskog-holand": nil,
		"aurskog-høland": nil,
		"austevoll":      nil,
		"austrheim":      nil,
		"averoy":         nil,
		"averøy":         nil,
		"badaddja":       nil,
		"bahcavuotna":    nil,
		"bahccavuotna":   nil,
		"baidar":         nil,
		"bajddar":        nil,
		"balat":          nil,
		"balestrand":     nil,
		"ballangen":      nil,
		"balsfjord":      nil,
		"bamble":         nil,
		"bardu":          nil,
		"barum":          nil,
		"batsfjord":      nil,
		"bearalvahki":    nil,
		"bearalváhki":    nil,
		"beardu":         nil,
		"beiarn":         nil,
		"berg":           nil,
		"bergen":         nil,
		"berlevag":       nil,
		"berlevåg":       nil,
		"bievat":         nil,
		"bievát":         nil,
		"bindal":         nil,
		"birkenes":       nil,
		"bjarkoy":        nil,
		"bjarkøy":        nil,
		"bjerkreim":      nil,
		"bjugn":          nil,
		"blogspot":       nil,
		"bodo":           nil,
		"bodø":           nil,
		"bokn":           nil,
		"bomlo":          nil,
		"bremanger":      nil,
		"bronnoy":        nil,
		"bronnoysund":    nil,
		"brumunddal":     nil,
		"bryne":          nil,
		"brønnøy":        nil,
		"brønnøysund":    nil,
		"bu": &tld{
			"gs": nil,
		},
		"budejju": nil,
		"buskerud": &tld{
			"nes": nil,
		},
		"bygland":         nil,
		"bykle":           nil,
		"báhcavuotna":     nil,
		"báhccavuotna":    nil,
		"báidár":          nil,
		"bájddar":         nil,
		"bálát":           nil,
		"bådåddjå":        nil,
		"båtsfjord":       nil,
		"bærum":           nil,
		"bømlo":           nil,
		"cahcesuolo":      nil,
		"co":              nil,
		"davvenjarga":     nil,
		"davvenjárga":     nil,
		"davvesiida":      nil,
		"deatnu":          nil,
		"dep":             nil,
		"dielddanuorri":   nil,
		"divtasvuodna":    nil,
		"divttasvuotna":   nil,
		"donna":           nil,
		"dovre":           nil,
		"drammen":         nil,
		"drangedal":       nil,
		"drobak":          nil,
		"drøbak":          nil,
		"dyroy":           nil,
		"dyrøy":           nil,
		"dønna":           nil,
		"egersund":        nil,
		"eid":             nil,
		"eidfjord":        nil,
		"eidsberg":        nil,
		"eidskog":         nil,
		"eidsvoll":        nil,
		"eigersund":       nil,
		"elverum":         nil,
		"enebakk":         nil,
		"engerdal":        nil,
		"etne":            nil,
		"etnedal":         nil,
		"evenassi":        nil,
		"evenes":          nil,
		"evenášši":        nil,
		"evje-og-hornnes": nil,
		"farsund":         nil,
		"fauske":          nil,
		"fedje":           nil,
		"fet":             nil,
		"fetsund":         nil,
		"fhs":             nil,
		"finnoy":          nil,
		"finnøy":          nil,
		"fitjar":          nil,
		"fjaler":          nil,
		"fjell":           nil,
		"fla":             nil,
		"flakstad":        nil,
		"flatanger":       nil,
		"flekkefjord":     nil,
		"flesberg":        nil,
		"flora":           nil,
		"floro":           nil,
		"florø":           nil,
		"flå":             nil,
		"fm": &tld{
			"gs": nil,
		},
		"folkebibl":     nil,
		"folldal":       nil,
		"forde":         nil,
		"forsand":       nil,
		"fosnes":        nil,
		"frana":         nil,
		"fredrikstad":   nil,
		"frei":          nil,
		"frogn":         nil,
		"froland":       nil,
		"frosta":        nil,
		"froya":         nil,
		"fræna":         nil,
		"frøya":         nil,
		"fuoisku":       nil,
		"fuossko":       nil,
		"fusa":          nil,
		"fylkesbibl":    nil,
		"fyresdal":      nil,
		"førde":         nil,
		"gaivuotna":     nil,
		"galsa":         nil,
		"gamvik":        nil,
		"gangaviika":    nil,
		"gaular":        nil,
		"gausdal":       nil,
		"giehtavuoatna": nil,
		"gildeskal":     nil,
		"gildeskål":     nil,
		"giske":         nil,
		"gjemnes":       nil,
		"gjerdrum":      nil,
		"gjerstad":      nil,
		"gjesdal":       nil,
		"gjovik":        nil,
		"gjøvik":        nil,
		"gloppen":       nil,
		"gol":           nil,
		"gran":          nil,
		"grane":         nil,
		"granvin":       nil,
		"gratangen":     nil,
		"grimstad":      nil,
		"grong":         nil,
		"grue":          nil,
		"gulen":         nil,
		"guovdageaidnu": nil,
		"gáivuotna":     nil,
		"gálsá":         nil,
		"gáŋgaviika":    nil,
		"ha":            nil,
		"habmer":        nil,
		"hadsel":        nil,
		"hagebostad":    nil,
		"halden":        nil,
		"halsa":         nil,
		"hamar":         nil,
		"hamaroy":       nil,
		"hammarfeasta":  nil,
		"hammerfest":    nil,
		"hapmir":        nil,
		"haram":         nil,
		"hareid":        nil,
		"harstad":       nil,
		"hasvik":        nil,
		"hattfjelldal":  nil,
		"haugesund":     nil,
		"hedmark": &tld{
			"os":    nil,
			"valer": nil,
			"våler": nil,
		},
		"hemne":      nil,
		"hemnes":     nil,
		"hemsedal":   nil,
		"herad":      nil,
		"hitra":      nil,
		"hjartdal":   nil,
		"hjelmeland": nil,
		"hl": &tld{
			"gs": nil,
		},
		"hm": &tld{
			"gs": nil,
		},
		"hobol":       nil,
		"hobøl":       nil,
		"hof":         nil,
		"hokksund":    nil,
		"hol":         nil,
		"hole":        nil,
		"holmestrand": nil,
		"holtalen":    nil,
		"holtålen":    nil,
		"honefoss":    nil,
		"hordaland": &tld{
			"os": nil,
		},
		"hornindal":    nil,
		"horten":       nil,
		"hoyanger":     nil,
		"hoylandet":    nil,
		"hurdal":       nil,
		"hurum":        nil,
		"hvaler":       nil,
		"hyllestad":    nil,
		"hábmer":       nil,
		"hámmárfeasta": nil,
		"hápmir":       nil,
		"hå":           nil,
		"hægebostad":   nil,
		"hønefoss":     nil,
		"høyanger":     nil,
		"høylandet":    nil,
		"ibestad":      nil,
		"idrett":       nil,
		"inderoy":      nil,
		"inderøy":      nil,
		"iveland":      nil,
		"ivgu":         nil,
		"jan-mayen": &tld{
			"gs": nil,
		},
		"jessheim":       nil,
		"jevnaker":       nil,
		"jolster":        nil,
		"jondal":         nil,
		"jorpeland":      nil,
		"jølster":        nil,
		"jørpeland":      nil,
		"kafjord":        nil,
		"karasjohka":     nil,
		"karasjok":       nil,
		"karlsoy":        nil,
		"karmoy":         nil,
		"karmøy":         nil,
		"kautokeino":     nil,
		"kirkenes":       nil,
		"klabu":          nil,
		"klepp":          nil,
		"klæbu":          nil,
		"kommune":        nil,
		"kongsberg":      nil,
		"kongsvinger":    nil,
		"kopervik":       nil,
		"kraanghke":      nil,
		"kragero":        nil,
		"kragerø":        nil,
		"kristiansand":   nil,
		"kristiansund":   nil,
		"krodsherad":     nil,
		"krokstadelva":   nil,
		"kråanghke":      nil,
		"krødsherad":     nil,
		"kvafjord":       nil,
		"kvalsund":       nil,
		"kvam":           nil,
		"kvanangen":      nil,
		"kvinesdal":      nil,
		"kvinnherad":     nil,
		"kviteseid":      nil,
		"kvitsoy":        nil,
		"kvitsøy":        nil,
		"kvæfjord":       nil,
		"kvænangen":      nil,
		"kárášjohka":     nil,
		"kåfjord":        nil,
		"laakesvuemie":   nil,
		"lahppi":         nil,
		"langevag":       nil,
		"langevåg":       nil,
		"lardal":         nil,
		"larvik":         nil,
		"lavagis":        nil,
		"lavangen":       nil,
		"leangaviika":    nil,
		"leaŋgaviika":    nil,
		"lebesby":        nil,
		"leikanger":      nil,
		"leirfjord":      nil,
		"leirvik":        nil,
		"leka":           nil,
		"leksvik":        nil,
		"lenvik":         nil,
		"lerdal":         nil,
		"lesja":          nil,
		"levanger":       nil,
		"lier":           nil,
		"lierne":         nil,
		"lillehammer":    nil,
		"lillesand":      nil,
		"lindas":         nil,
		"lindesnes":      nil,
		"lindås":         nil,
		"loabat":         nil,
		"loabát":         nil,
		"lodingen":       nil,
		"lom":            nil,
		"loppa":          nil,
		"lorenskog":      nil,
		"loten":          nil,
		"lund":           nil,
		"lunner":         nil,
		"luroy":          nil,
		"lurøy":          nil,
		"luster":         nil,
		"lyngdal":        nil,
		"lyngen":         nil,
		"láhppi":         nil,
		"lærdal":         nil,
		"lødingen":       nil,
		"lørenskog":      nil,
		"løten":          nil,
		"malatvuopmi":    nil,
		"malselv":        nil,
		"malvik":         nil,
		"mandal":         nil,
		"marker":         nil,
		"marnardal":      nil,
		"masfjorden":     nil,
		"masoy":          nil,
		"matta-varjjat":  nil,
		"meland":         nil,
		"meldal":         nil,
		"melhus":         nil,
		"meloy":          nil,
		"meløy":          nil,
		"meraker":        nil,
		"meråker":        nil,
		"midsund":        nil,
		"midtre-gauldal": nil,
		"mil":            nil,
		"mjondalen":      nil,
		"mjøndalen":      nil,
		"mo-i-rana":      nil,
		"moareke":        nil,
		"modalen":        nil,
		"modum":          nil,
		"molde":          nil,
		"more-og-romsdal": &tld{
			"heroy": nil,
			"sande": nil,
		},
		"mosjoen":  nil,
		"mosjøen":  nil,
		"moskenes": nil,
		"moss":     nil,
		"mosvik":   nil,
		"moåreke":  nil,
		"mr": &tld{
			"gs": nil,
		},
		"muosat":        nil,
		"muosát":        nil,
		"museum":        nil,
		"málatvuopmi":   nil,
		"mátta-várjjat": nil,
		"målselv":       nil,
		"måsøy":         nil,
		"møre-og-romsdal": &tld{
			"herøy": nil,
			"sande": nil,
		},
		"naamesjevuemie": nil,
		"namdalseid":     nil,
		"namsos":         nil,
		"namsskogan":     nil,
		"nannestad":      nil,
		"naroy":          nil,
		"narviika":       nil,
		"narvik":         nil,
		"naustdal":       nil,
		"navuotna":       nil,
		"nedre-eiker":    nil,
		"nesna":          nil,
		"nesodden":       nil,
		"nesoddtangen":   nil,
		"nesseby":        nil,
		"nesset":         nil,
		"nissedal":       nil,
		"nittedal":       nil,
		"nl": &tld{
			"gs": nil,
		},
		"nord-aurdal": nil,
		"nord-fron":   nil,
		"nord-odal":   nil,
		"norddal":     nil,
		"nordkapp":    nil,
		"nordland": &tld{
			"bo":    nil,
			"bø":    nil,
			"heroy": nil,
			"herøy": nil,
		},
		"nordre-land":   nil,
		"nordreisa":     nil,
		"nore-og-uvdal": nil,
		"notodden":      nil,
		"notteroy":      nil,
		"nt": &tld{
			"gs": nil,
		},
		"návuotna":       nil,
		"nååmesjevuemie": nil,
		"nærøy":          nil,
		"nøtterøy":       nil,
		"odda":           nil,
		"of": &tld{
			"gs": nil,
		},
		"oksnes": nil,
		"ol": &tld{
			"gs": nil,
		},
		"omasvuotna": nil,
		"oppdal":     nil,
		"oppegard":   nil,
		"oppegård":   nil,
		"orkanger":   nil,
		"orkdal":     nil,
		"orland":     nil,
		"orskog":     nil,
		"orsta":      nil,
		"osen":       nil,
		"oslo": &tld{
			"gs": nil,
		},
		"osoyro":  nil,
		"osteroy": nil,
		"osterøy": nil,
		"ostfold": &tld{
			"valer": nil,
		},
		"ostre-toten":   nil,
		"osøyro":        nil,
		"overhalla":     nil,
		"ovre-eiker":    nil,
		"oyer":          nil,
		"oygarden":      nil,
		"oystre-slidre": nil,
		"porsanger":     nil,
		"porsangu":      nil,
		"porsgrunn":     nil,
		"porsáŋgu":      nil,
		"priv":          nil,
		"rade":          nil,
		"radoy":         nil,
		"radøy":         nil,
		"rahkkeravju":   nil,
		"raholt":        nil,
		"raisa":         nil,
		"rakkestad":     nil,
		"ralingen":      nil,
		"rana":          nil,
		"randaberg":     nil,
		"rauma":         nil,
		"rendalen":      nil,
		"rennebu":       nil,
		"rennesoy":      nil,
		"rennesøy":      nil,
		"rindal":        nil,
		"ringebu":       nil,
		"ringerike":     nil,
		"ringsaker":     nil,
		"risor":         nil,
		"rissa":         nil,
		"risør":         nil,
		"rl": &tld{
			"gs": nil,
		},
		"roan":         nil,
		"rodoy":        nil,
		"rollag":       nil,
		"romsa":        nil,
		"romskog":      nil,
		"roros":        nil,
		"rost":         nil,
		"royken":       nil,
		"royrvik":      nil,
		"ruovat":       nil,
		"rygge":        nil,
		"ráhkkerávju":  nil,
		"ráisa":        nil,
		"råde":         nil,
		"råholt":       nil,
		"rælingen":     nil,
		"rødøy":        nil,
		"rømskog":      nil,
		"røros":        nil,
		"røst":         nil,
		"røyken":       nil,
		"røyrvik":      nil,
		"salangen":     nil,
		"salat":        nil,
		"saltdal":      nil,
		"samnanger":    nil,
		"sandefjord":   nil,
		"sandnes":      nil,
		"sandnessjoen": nil,
		"sandnessjøen": nil,
		"sandoy":       nil,
		"sandøy":       nil,
		"sarpsborg":    nil,
		"sauda":        nil,
		"sauherad":     nil,
		"sel":          nil,
		"selbu":        nil,
		"selje":        nil,
		"seljord":      nil,
		"sf": &tld{
			"gs": nil,
		},
		"siellak":       nil,
		"sigdal":        nil,
		"siljan":        nil,
		"sirdal":        nil,
		"skanit":        nil,
		"skanland":      nil,
		"skaun":         nil,
		"skedsmo":       nil,
		"skedsmokorset": nil,
		"ski":           nil,
		"skien":         nil,
		"skierva":       nil,
		"skiervá":       nil,
		"skiptvet":      nil,
		"skjak":         nil,
		"skjervoy":      nil,
		"skjervøy":      nil,
		"skjåk":         nil,
		"skodje":        nil,
		"skánit":        nil,
		"skånland":      nil,
		"slattum":       nil,
		"smola":         nil,
		"smøla":         nil,
		"snaase":        nil,
		"snasa":         nil,
		"snillfjord":    nil,
		"snoasa":        nil,
		"snåase":        nil,
		"snåsa":         nil,
		"sogndal":       nil,
		"sogne":         nil,
		"sokndal":       nil,
		"sola":          nil,
		"solund":        nil,
		"somna":         nil,
		"sondre-land":   nil,
		"songdalen":     nil,
		"sor-aurdal":    nil,
		"sor-fron":      nil,
		"sor-odal":      nil,
		"sor-varanger":  nil,
		"sorfold":       nil,
		"sorreisa":      nil,
		"sortland":      nil,
		"sorum":         nil,
		"spjelkavik":    nil,
		"spydeberg":     nil,
		"st": &tld{
			"gs": nil,
		},
		"stange":          nil,
		"stat":            nil,
		"stathelle":       nil,
		"stavanger":       nil,
		"stavern":         nil,
		"steigen":         nil,
		"steinkjer":       nil,
		"stjordal":        nil,
		"stjordalshalsen": nil,
		"stjørdal":        nil,
		"stjørdalshalsen": nil,
		"stokke":          nil,
		"stor-elvdal":     nil,
		"stord":           nil,
		"stordal":         nil,
		"storfjord":       nil,
		"strand":          nil,
		"stranda":         nil,
		"stryn":           nil,
		"sula":            nil,
		"suldal":          nil,
		"sund":            nil,
		"sunndal":         nil,
		"surnadal":        nil,
		"svalbard": &tld{
			"gs": nil,
		},
		"sveio":        nil,
		"svelvik":      nil,
		"sykkylven":    nil,
		"sálat":        nil,
		"sálát":        nil,
		"søgne":        nil,
		"sømna":        nil,
		"søndre-land":  nil,
		"sør-aurdal":   nil,
		"sør-fron":     nil,
		"sør-odal":     nil,
		"sør-varanger": nil,
		"sørfold":      nil,
		"sørreisa":     nil,
		"sørum":        nil,
		"tana":         nil,
		"tananger":     nil,
		"telemark": &tld{
			"bo": nil,
			"bø": nil,
		},
		"time":      nil,
		"tingvoll":  nil,
		"tinn":      nil,
		"tjeldsund": nil,
		"tjome":     nil,
		"tjøme":     nil,
		"tm": &tld{
			"gs": nil,
		},
		"tokke":    nil,
		"tolga":    nil,
		"tonsberg": nil,
		"torsken":  nil,
		"tr": &tld{
			"gs": nil,
		},
		"trana":       nil,
		"tranby":      nil,
		"tranoy":      nil,
		"tranøy":      nil,
		"troandin":    nil,
		"trogstad":    nil,
		"tromsa":      nil,
		"tromso":      nil,
		"tromsø":      nil,
		"trondheim":   nil,
		"trysil":      nil,
		"træna":       nil,
		"trøgstad":    nil,
		"tvedestrand": nil,
		"tydal":       nil,
		"tynset":      nil,
		"tysfjord":    nil,
		"tysnes":      nil,
		"tysvar":      nil,
		"tysvær":      nil,
		"tønsberg":    nil,
		"ullensaker":  nil,
		"ullensvang":  nil,
		"ulvik":       nil,
		"unjarga":     nil,
		"unjárga":     nil,
		"utsira":      nil,
		"va": &tld{
			"gs": nil,
		},
		"vaapste":   nil,
		"vadso":     nil,
		"vadsø":     nil,
		"vaga":      nil,
		"vagan":     nil,
		"vagsoy":    nil,
		"vaksdal":   nil,
		"valle":     nil,
		"vang":      nil,
		"vanylven":  nil,
		"vardo":     nil,
		"vardø":     nil,
		"varggat":   nil,
		"varoy":     nil,
		"vefsn":     nil,
		"vega":      nil,
		"vegarshei": nil,
		"vegårshei": nil,
		"vennesla":  nil,
		"verdal":    nil,
		"verran":    nil,
		"vestby":    nil,
		"vestfold": &tld{
			"sande": nil,
		},
		"vestnes":       nil,
		"vestre-slidre": nil,
		"vestre-toten":  nil,
		"vestvagoy":     nil,
		"vestvågøy":     nil,
		"vevelstad":     nil,
		"vf": &tld{
			"gs": nil,
		},
		"vgs":         nil,
		"vik":         nil,
		"vikna":       nil,
		"vindafjord":  nil,
		"voagat":      nil,
		"volda":       nil,
		"voss":        nil,
		"vossevangen": nil,
		"várggát":     nil,
		"vågan":       nil,
		"vågsøy":      nil,
		"vågå":        nil,
		"værøy":       nil,
		"ákŋoluokta":  nil,
		"álaheadju":   nil,
		"áltá":        nil,
		"åfjord":      nil,
		"åkrehamn":    nil,
		"ål":          nil,
		"ålesund":     nil,
		"ålgård":      nil,
		"åmli":        nil,
		"åmot":        nil,
		"årdal":       nil,
		"ås":          nil,
		"åseral":      nil,
		"åsnes":       nil,
		"øksnes":      nil,
		"ørland":      nil,
		"ørskog":      nil,
		"ørsta":       nil,
		"østfold": &tld{
			"våler": nil,
		},
		"østre-toten":   nil,
		"øvre-eiker":    nil,
		"øyer":          nil,
		"øygarden":      nil,
		"øystre-slidre": nil,
		"čáhcesuolo":    nil,
	},
	"nokia":              nil,
	"northwesternmutual": nil,
	"norton":             nil,
	"now":                nil,
	"nowruz":             nil,
	"nowtv":              nil,
	"np": &tld{
		"*": nil,
	},
	"nr": &tld{
		"biz":  nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"net":  nil,
		"org":  nil,
	},
	"nra": nil,
	"nrw": nil,
	"ntt": nil,
	"nu": &tld{
		"builder": &tld{
			"site": nil,
		},
		"enterprisecloud": nil,
		"merseine":        nil,
		"mine":            nil,
		"nom":             nil,
		"shacknet":        nil,
	},
	"nyc": nil,
	"nz": &tld{
		"ac": nil,
		"co": &tld{
			"blogspot": nil,
		},
		"cri":        nil,
		"geek":       nil,
		"gen":        nil,
		"govt":       nil,
		"health":     nil,
		"iwi":        nil,
		"kiwi":       nil,
		"maori":      nil,
		"mil":        nil,
		"māori":      nil,
		"net":        nil,
		"nym":        nil,
		"org":        nil,
		"parliament": nil,
		"school":     nil,
	},
	"obi":         nil,
	"observer":    nil,
	"off":         nil,
	"office":      nil,
	"okinawa":     nil,
	"olayan":      nil,
	"olayangroup": nil,
	"oldnavy":     nil,
	"ollo":        nil,
	"om": &tld{
		"co":     nil,
		"com":    nil,
		"edu":    nil,
		"gov":    nil,
		"med":    nil,
		"museum": nil,
		"net":    nil,
		"org":    nil,
		"pro":    nil,
	},
	"omega": nil,
	"one": &tld{
		"for":      nil,
		"homelink": nil,
		"onred": &tld{
			"staging": nil,
		},
	},
	"ong":   nil,
	"onion": nil,
	"onl":   nil,
	"online": &tld{
		"barsy": nil,
	},
	"onyourside": nil,
	"ooo":        nil,
	"open":       nil,
	"oracle":     nil,
	"orange":     nil,
	"org": &tld{
		"accesscam": nil,
		"ae":        nil,
		"amune": &tld{
			"tele": nil,
		},
		"barsy":              nil,
		"blogdns":            nil,
		"blogsite":           nil,
		"bmoattachments":     nil,
		"boldlygoingnowhere": nil,
		"cable-modem":        nil,
		"camdvr":             nil,
		"cdn77": &tld{
			"c":   nil,
			"rsc": nil,
		},
		"cdn77-secure": &tld{
			"origin": &tld{
				"ssl": nil,
			},
		},
		"certmgr":          nil,
		"cloudns":          nil,
		"collegefan":       nil,
		"couchpotatofries": nil,
		"ddnss":            nil,
		"diskstation":      nil,
		"dnsalias":         nil,
		"dnsdojo":          nil,
		"doesntexist":      nil,
		"dontexist":        nil,
		"doomdns":          nil,
		"dsmynas":          nil,
		"duckdns":          nil,
		"dvrdns":           nil,
		"dynalias":         nil,
		"dyndns": &tld{
			"go":   nil,
			"home": nil,
		},
		"dynserv":          nil,
		"edugit":           nil,
		"endofinternet":    nil,
		"endoftheinternet": nil,
		"eu": &tld{
			"al":    nil,
			"asso":  nil,
			"at":    nil,
			"au":    nil,
			"be":    nil,
			"bg":    nil,
			"ca":    nil,
			"cd":    nil,
			"ch":    nil,
			"cn":    nil,
			"cy":    nil,
			"cz":    nil,
			"de":    nil,
			"dk":    nil,
			"edu":   nil,
			"ee":    nil,
			"es":    nil,
			"fi":    nil,
			"fr":    nil,
			"gr":    nil,
			"hr":    nil,
			"hu":    nil,
			"ie":    nil,
			"il":    nil,
			"in":    nil,
			"int":   nil,
			"is":    nil,
			"it":    nil,
			"jp":    nil,
			"kr":    nil,
			"lt":    nil,
			"lu":    nil,
			"lv":    nil,
			"mc":    nil,
			"me":    nil,
			"mk":    nil,
			"mt":    nil,
			"my":    nil,
			"net":   nil,
			"ng":    nil,
			"nl":    nil,
			"no":    nil,
			"nz":    nil,
			"paris": nil,
			"pl":    nil,
			"pt":    nil,
			"q-a":   nil,
			"ro":    nil,
			"ru":    nil,
			"se":    nil,
			"si":    nil,
			"sk":    nil,
			"tr":    nil,
			"uk":    nil,
			"us":    nil,
		},
		"familyds":         nil,
		"fedorainfracloud": nil,
		"fedorapeople":     nil,
		"fedoraproject": &tld{
			"cloud": nil,
			"os": &tld{
				"app": nil,
			},
			"stg": &tld{
				"os": &tld{
					"app": nil,
				},
			},
		},
		"freeddns":         nil,
		"freedesktop":      nil,
		"from-me":          nil,
		"game-host":        nil,
		"gotdns":           nil,
		"hepforge":         nil,
		"hk":               nil,
		"hobby-site":       nil,
		"homedns":          nil,
		"homeftp":          nil,
		"homelinux":        nil,
		"homeunix":         nil,
		"hopto":            nil,
		"in-dsl":           nil,
		"in-vpn":           nil,
		"is-a-bruinsfan":   nil,
		"is-a-candidate":   nil,
		"is-a-celticsfan":  nil,
		"is-a-chef":        nil,
		"is-a-geek":        nil,
		"is-a-knight":      nil,
		"is-a-linux-user":  nil,
		"is-a-patsfan":     nil,
		"is-a-soxfan":      nil,
		"is-found":         nil,
		"is-lost":          nil,
		"is-saved":         nil,
		"is-very-bad":      nil,
		"is-very-evil":     nil,
		"is-very-good":     nil,
		"is-very-nice":     nil,
		"is-very-sweet":    nil,
		"isa-geek":         nil,
		"js":               nil,
		"kicks-ass":        nil,
		"mayfirst":         nil,
		"misconfused":      nil,
		"mlbfan":           nil,
		"mozilla-iot":      nil,
		"my-firewall":      nil,
		"myfirewall":       nil,
		"myftp":            nil,
		"mysecuritycamera": nil,
		"mywire":           nil,
		"nflfan":           nil,
		"no-ip":            nil,
		"now-dns":          nil,
		"pimienta":         nil,
		"podzone":          nil,
		"poivron":          nil,
		"potager":          nil,
		"pubtls":           nil,
		"read-books":       nil,
		"readmyblog":       nil,
		"selfip":           nil,
		"sellsyourhome":    nil,
		"servebbs":         nil,
		"serveftp":         nil,
		"servegame":        nil,
		"spdns":            nil,
		"stuff-4-sale":     nil,
		"sweetpepper":      nil,
		"tunk":             nil,
		"tuxfamily":        nil,
		"twmail":           nil,
		"ufcfan":           nil,
		"uklugs":           nil,
		"us":               nil,
		"webhop":           nil,
		"webredirect":      nil,
		"wmflabs":          nil,
		"za":               nil,
		"zapto":            nil,
	},
	"organic": nil,
	"origins": nil,
	"osaka":   nil,
	"otsuka":  nil,
	"ott":     nil,
	"ovh": &tld{
		"nerdpol": nil,
	},
	"pa": &tld{
		"abo": nil,
		"ac":  nil,
		"com": nil,
		"edu": nil,
		"gob": nil,
		"ing": nil,
		"med": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
		"sld": nil,
	},
	"page": &tld{
		"prvcy": nil,
	},
	"panasonic": nil,
	"paris":     nil,
	"pars":      nil,
	"partners":  nil,
	"parts":     nil,
	"party": &tld{
		"ybo": nil,
	},
	"passagens": nil,
	"pay":       nil,
	"pccw":      nil,
	"pe": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gob":      nil,
		"mil":      nil,
		"net":      nil,
		"nom":      nil,
		"nym":      nil,
		"org":      nil,
	},
	"pet": nil,
	"pf": &tld{
		"com": nil,
		"edu": nil,
		"org": nil,
	},
	"pfizer": nil,
	"pg": &tld{
		"*": nil,
	},
	"ph": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"i":   nil,
		"mil": nil,
		"net": nil,
		"ngo": nil,
		"org": nil,
	},
	"pharmacy":    nil,
	"phd":         nil,
	"philips":     nil,
	"phone":       nil,
	"photo":       nil,
	"photography": nil,
	"photos":      nil,
	"physio":      nil,
	"piaget":      nil,
	"pics":        nil,
	"pictet":      nil,
	"pictures": &tld{
		"1337": nil,
	},
	"pid":     nil,
	"pin":     nil,
	"ping":    nil,
	"pink":    nil,
	"pioneer": nil,
	"pizza":   nil,
	"pk": &tld{
		"biz":  nil,
		"com":  nil,
		"edu":  nil,
		"fam":  nil,
		"gob":  nil,
		"gok":  nil,
		"gon":  nil,
		"gop":  nil,
		"gos":  nil,
		"gov":  nil,
		"info": nil,
		"net":  nil,
		"org":  nil,
		"web":  nil,
	},
	"pl": &tld{
		"agro":        nil,
		"aid":         nil,
		"art":         nil,
		"atm":         nil,
		"augustow":    nil,
		"auto":        nil,
		"babia-gora":  nil,
		"bedzin":      nil,
		"beep":        nil,
		"beskidy":     nil,
		"bialowieza":  nil,
		"bialystok":   nil,
		"bielawa":     nil,
		"bieszczady":  nil,
		"biz":         nil,
		"boleslawiec": nil,
		"bydgoszcz":   nil,
		"bytom":       nil,
		"cieszyn":     nil,
		"co":          nil,
		"com":         nil,
		"czeladz":     nil,
		"czest":       nil,
		"dlugoleka":   nil,
		"edu":         nil,
		"elblag":      nil,
		"elk":         nil,
		"gda":         nil,
		"gdansk":      nil,
		"gdynia":      nil,
		"gliwice":     nil,
		"glogow":      nil,
		"gmina":       nil,
		"gniezno":     nil,
		"gorlice":     nil,
		"gov": &tld{
			"ap":        nil,
			"griw":      nil,
			"ic":        nil,
			"is":        nil,
			"kmpsp":     nil,
			"konsulat":  nil,
			"kppsp":     nil,
			"kwp":       nil,
			"kwpsp":     nil,
			"mup":       nil,
			"mw":        nil,
			"oirm":      nil,
			"oum":       nil,
			"pa":        nil,
			"pinb":      nil,
			"piw":       nil,
			"po":        nil,
			"psp":       nil,
			"psse":      nil,
			"pup":       nil,
			"rzgw":      nil,
			"sa":        nil,
			"sdn":       nil,
			"sko":       nil,
			"so":        nil,
			"sr":        nil,
			"starostwo": nil,
			"ug":        nil,
			"ugim":      nil,
			"um":        nil,
			"umig":      nil,
			"upow":      nil,
			"uppo":      nil,
			"us":        nil,
			"uw":        nil,
			"uzs":       nil,
			"wif":       nil,
			"wiih":      nil,
			"winb":      nil,
			"wios":      nil,
			"witd":      nil,
			"wiw":       nil,
			"wsa":       nil,
			"wskr":      nil,
			"wuoz":      nil,
			"wzmiuw":    nil,
			"zp":        nil,
		},
		"grajewo":         nil,
		"gsm":             nil,
		"ilawa":           nil,
		"info":            nil,
		"jaworzno":        nil,
		"jelenia-gora":    nil,
		"jgora":           nil,
		"kalisz":          nil,
		"karpacz":         nil,
		"kartuzy":         nil,
		"kaszuby":         nil,
		"katowice":        nil,
		"kazimierz-dolny": nil,
		"kepno":           nil,
		"ketrzyn":         nil,
		"klodzko":         nil,
		"kobierzyce":      nil,
		"kolobrzeg":       nil,
		"konin":           nil,
		"konskowola":      nil,
		"krakow":          nil,
		"krasnik":         nil,
		"kutno":           nil,
		"lapy":            nil,
		"lebork":          nil,
		"leczna":          nil,
		"legnica":         nil,
		"lezajsk":         nil,
		"limanowa":        nil,
		"lomza":           nil,
		"lowicz":          nil,
		"lubartow":        nil,
		"lubin":           nil,
		"lublin":          nil,
		"lukow":           nil,
		"mail":            nil,
		"malbork":         nil,
		"malopolska":      nil,
		"mazowsze":        nil,
		"mazury":          nil,
		"med":             nil,
		"media":           nil,
		"miasta":          nil,
		"mielec":          nil,
		"mielno":          nil,
		"mil":             nil,
		"mragowo":         nil,
		"naklo":           nil,
		"net":             nil,
		"nieruchomosci":   nil,
		"nom":             nil,
		"nowaruda":        nil,
		"nysa":            nil,
		"olawa":           nil,
		"olecko":          nil,
		"olkusz":          nil,
		"olsztyn":         nil,
		"opoczno":         nil,
		"opole":           nil,
		"org":             nil,
		"ostroda":         nil,
		"ostroleka":       nil,
		"ostrowiec":       nil,
		"ostrowwlkp":      nil,
		"pc":              nil,
		"pila":            nil,
		"pisz":            nil,
		"podhale":         nil,
		"podlasie":        nil,
		"polkowice":       nil,
		"pomorskie":       nil,
		"pomorze":         nil,
		"poniatowa":       nil,
		"powiat":          nil,
		"poznan":          nil,
		"priv":            nil,
		"prochowice":      nil,
		"pruszkow":        nil,
		"przeworsk":       nil,
		"pulawy":          nil,
		"radom":           nil,
		"rawa-maz":        nil,
		"realestate":      nil,
		"rel":             nil,
		"rybnik":          nil,
		"rzeszow":         nil,
		"sanok":           nil,
		"sejny":           nil,
		"sex":             nil,
		"shop":            nil,
		"sklep":           nil,
		"skoczow":         nil,
		"slask":           nil,
		"slupsk":          nil,
		"sopot":           nil,
		"sos":             nil,
		"sosnowiec":       nil,
		"stalowa-wola":    nil,
		"starachowice":    nil,
		"stargard":        nil,
		"suwalki":         nil,
		"swidnica":        nil,
		"swidnik":         nil,
		"swiebodzin":      nil,
		"swinoujscie":     nil,
		"szczecin":        nil,
		"szczytno":        nil,
		"szkola":          nil,
		"targi":           nil,
		"tarnobrzeg":      nil,
		"tgory":           nil,
		"tm":              nil,
		"tourism":         nil,
		"travel":          nil,
		"turek":           nil,
		"turystyka":       nil,
		"tychy":           nil,
		"ustka":           nil,
		"walbrzych":       nil,
		"warmia":          nil,
		"warszawa":        nil,
		"waw":             nil,
		"wegrow":          nil,
		"wielun":          nil,
		"wlocl":           nil,
		"wloclawek":       nil,
		"wodzislaw":       nil,
		"wolomin":         nil,
		"wroc":            nil,
		"wroclaw":         nil,
		"zachpomor":       nil,
		"zagan":           nil,
		"zakopane":        nil,
		"zarow":           nil,
		"zgora":           nil,
		"zgorzelec":       nil,
	},
	"place": &tld{
		"co": nil,
	},
	"play":        nil,
	"playstation": nil,
	"plumbing":    nil,
	"plus":        nil,
	"pm": &tld{
		"own": nil,
	},
	"pn": &tld{
		"co":  nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"pnc":     nil,
	"pohl":    nil,
	"poker":   nil,
	"politie": nil,
	"porn":    nil,
	"post":    nil,
	"pr": &tld{
		"ac":   nil,
		"biz":  nil,
		"com":  nil,
		"edu":  nil,
		"est":  nil,
		"gov":  nil,
		"info": nil,
		"isla": nil,
		"name": nil,
		"net":  nil,
		"org":  nil,
		"pro":  nil,
		"prof": nil,
	},
	"pramerica": nil,
	"praxi":     nil,
	"press":     nil,
	"prime":     nil,
	"pro": &tld{
		"aaa":     nil,
		"aca":     nil,
		"acct":    nil,
		"avocat":  nil,
		"bar":     nil,
		"barsy":   nil,
		"cloudns": nil,
		"cpa":     nil,
		"dnstrace": &tld{
			"bci": nil,
		},
		"eng":   nil,
		"jur":   nil,
		"law":   nil,
		"med":   nil,
		"recht": nil,
	},
	"prod":        nil,
	"productions": nil,
	"prof":        nil,
	"progressive": nil,
	"promo":       nil,
	"properties":  nil,
	"property":    nil,
	"protection":  nil,
	"pru":         nil,
	"prudential":  nil,
	"ps": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
		"plo": nil,
		"sec": nil,
	},
	"pt": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"int":      nil,
		"net":      nil,
		"nome":     nil,
		"nym":      nil,
		"org":      nil,
		"publ":     nil,
	},
	"pub": &tld{
		"barsy": nil,
	},
	"pw": &tld{
		"belau":   nil,
		"cloudns": nil,
		"co":      nil,
		"ed":      nil,
		"go":      nil,
		"ne":      nil,
		"nom":     nil,
		"or":      nil,
		"x443":    nil,
	},
	"pwc": nil,
	"py": &tld{
		"com":  nil,
		"coop": nil,
		"edu":  nil,
		"gov":  nil,
		"mil":  nil,
		"net":  nil,
		"org":  nil,
	},
	"qa": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"mil":      nil,
		"name":     nil,
		"net":      nil,
		"nom":      nil,
		"org":      nil,
		"sch":      nil,
	},
	"qpon":   nil,
	"quebec": nil,
	"quest":  nil,
	"qvc":    nil,
	"racing": nil,
	"radio":  nil,
	"raid":   nil,
	"re": &tld{
		"asso":     nil,
		"blogspot": nil,
		"com":      nil,
		"nom":      nil,
	},
	"read":        nil,
	"realestate":  nil,
	"realtor":     nil,
	"realty":      nil,
	"recipes":     nil,
	"red":         nil,
	"redstone":    nil,
	"redumbrella": nil,
	"rehab":       nil,
	"reise":       nil,
	"reisen":      nil,
	"reit":        nil,
	"reliance":    nil,
	"ren":         nil,
	"rent":        nil,
	"rentals":     nil,
	"repair":      nil,
	"report":      nil,
	"republican":  nil,
	"rest":        nil,
	"restaurant":  nil,
	"review": &tld{
		"ybo": nil,
	},
	"reviews":     nil,
	"rexroth":     nil,
	"rich":        nil,
	"richardli":   nil,
	"ricoh":       nil,
	"rightathome": nil,
	"ril":         nil,
	"rio":         nil,
	"rip": &tld{
		"clan": nil,
	},
	"rmit": nil,
	"ro": &tld{
		"arts":     nil,
		"blogspot": nil,
		"com":      nil,
		"firm":     nil,
		"info":     nil,
		"nom":      nil,
		"nt":       nil,
		"nym":      nil,
		"org":      nil,
		"rec":      nil,
		"shop":     nil,
		"store":    nil,
		"tm":       nil,
		"www":      nil,
	},
	"rocher": nil,
	"rocks": &tld{
		"lima-city": nil,
		"myddns":    nil,
		"webspace":  nil,
	},
	"rodeo":  nil,
	"rogers": nil,
	"room":   nil,
	"rs": &tld{
		"ac":       nil,
		"blogspot": nil,
		"co":       nil,
		"edu":      nil,
		"gov":      nil,
		"in":       nil,
		"nom":      nil,
		"org":      nil,
		"ox":       nil,
		"ua":       nil,
	},
	"rsvp": nil,
	"ru": &tld{
		"ac":        nil,
		"adygeya":   nil,
		"bashkiria": nil,
		"bir":       nil,
		"blogspot":  nil,
		"cbg":       nil,
		"cldmail": &tld{
			"hb": nil,
		},
		"com":      nil,
		"dagestan": nil,
		"edu":      nil,
		"gov":      nil,
		"grozny":   nil,
		"int":      nil,
		"kalmykia": nil,
		"kustanai": nil,
		"marine":   nil,
		"mil":      nil,
		"mordovia": nil,
		"msk":      nil,
		"myjino": &tld{
			"hosting": &tld{
				"*": nil,
			},
			"landing": &tld{
				"*": nil,
			},
			"spectrum": &tld{
				"*": nil,
			},
			"vps": &tld{
				"*": nil,
			},
		},
		"mytis":       nil,
		"nalchik":     nil,
		"net":         nil,
		"nov":         nil,
		"org":         nil,
		"pp":          nil,
		"pyatigorsk":  nil,
		"ras":         nil,
		"spb":         nil,
		"test":        nil,
		"vladikavkaz": nil,
		"vladimir":    nil,
	},
	"rugby": nil,
	"ruhr":  nil,
	"run": &tld{
		"development": nil,
		"hs":          nil,
		"ravendb":     nil,
		"repl":        nil,
	},
	"rw": &tld{
		"ac":   nil,
		"co":   nil,
		"coop": nil,
		"gov":  nil,
		"mil":  nil,
		"net":  nil,
		"org":  nil,
	},
	"rwe":    nil,
	"ryukyu": nil,
	"sa": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"med": nil,
		"net": nil,
		"org": nil,
		"pub": nil,
		"sch": nil,
	},
	"saarland": nil,
	"safe":     nil,
	"safety":   nil,
	"sakura":   nil,
	"sale": &tld{
		"for": nil,
	},
	"salon":           nil,
	"samsclub":        nil,
	"samsung":         nil,
	"sandvik":         nil,
	"sandvikcoromant": nil,
	"sanofi":          nil,
	"sap":             nil,
	"sarl":            nil,
	"sas":             nil,
	"save":            nil,
	"saxo":            nil,
	"sb": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"sbi": nil,
	"sbs": nil,
	"sc": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"sca":          nil,
	"scb":          nil,
	"schaeffler":   nil,
	"schmidt":      nil,
	"scholarships": nil,
	"school": &tld{
		"ng": nil,
	},
	"schule":  nil,
	"schwarz": nil,
	"science": &tld{
		"ybo": nil,
	},
	"scjohnson": nil,
	"scor":      nil,
	"scot":      nil,
	"sd": &tld{
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"med":  nil,
		"net":  nil,
		"org":  nil,
		"tv":   nil,
	},
	"se": &tld{
		"a":               nil,
		"ac":              nil,
		"b":               nil,
		"bd":              nil,
		"blogspot":        nil,
		"brand":           nil,
		"c":               nil,
		"com":             nil,
		"conf":            nil,
		"d":               nil,
		"e":               nil,
		"f":               nil,
		"fh":              nil,
		"fhsk":            nil,
		"fhv":             nil,
		"g":               nil,
		"h":               nil,
		"i":               nil,
		"k":               nil,
		"komforb":         nil,
		"kommunalforbund": nil,
		"komvux":          nil,
		"l":               nil,
		"lanbib":          nil,
		"m":               nil,
		"n":               nil,
		"naturbruksgymn":  nil,
		"o":               nil,
		"org":             nil,
		"p":               nil,
		"parti":           nil,
		"pp":              nil,
		"press":           nil,
		"r":               nil,
		"s":               nil,
		"t":               nil,
		"tm":              nil,
		"u":               nil,
		"w":               nil,
		"x":               nil,
		"y":               nil,
		"z":               nil,
	},
	"search":   nil,
	"seat":     nil,
	"secure":   nil,
	"security": nil,
	"seek":     nil,
	"select":   nil,
	"sener":    nil,
	"services": &tld{
		"loginline": nil,
	},
	"ses":   nil,
	"seven": nil,
	"sew":   nil,
	"sex":   nil,
	"sexy":  nil,
	"sfr":   nil,
	"sg": &tld{
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"net":      nil,
		"org":      nil,
		"per":      nil,
	},
	"sh": &tld{
		"com":      nil,
		"gov":      nil,
		"hashbang": nil,
		"mil":      nil,
		"net":      nil,
		"now":      nil,
		"org":      nil,
		"platform": &tld{
			"*": nil,
		},
		"wedeploy": nil,
	},
	"shangrila": nil,
	"sharp":     nil,
	"shaw":      nil,
	"shell":     nil,
	"shia":      nil,
	"shiksha":   nil,
	"shoes":     nil,
	"shop": &tld{
		"barsy": nil,
	},
	"shopping": nil,
	"shouji":   nil,
	"show":     nil,
	"showtime": nil,
	"shriram":  nil,
	"si": &tld{
		"blogspot": nil,
		"nom":      nil,
	},
	"silk":    nil,
	"sina":    nil,
	"singles": nil,
	"site": &tld{
		"barsy":     nil,
		"byen":      nil,
		"cloudera":  nil,
		"cyon":      nil,
		"lelux":     nil,
		"loginline": nil,
		"platformsh": &tld{
			"*": nil,
		},
	},
	"sj": nil,
	"sk": &tld{
		"blogspot": nil,
		"nym":      nil,
	},
	"ski":   nil,
	"skin":  nil,
	"sky":   nil,
	"skype": nil,
	"sl": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"net": nil,
		"org": nil,
	},
	"sling": nil,
	"sm":    nil,
	"smart": nil,
	"smile": nil,
	"sn": &tld{
		"art":      nil,
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gouv":     nil,
		"org":      nil,
		"perso":    nil,
		"univ":     nil,
	},
	"sncf": nil,
	"so": &tld{
		"com": nil,
		"net": nil,
		"org": nil,
		"sch": nil,
	},
	"soccer":    nil,
	"social":    nil,
	"softbank":  nil,
	"software":  nil,
	"sohu":      nil,
	"solar":     nil,
	"solutions": nil,
	"song":      nil,
	"sony":      nil,
	"soy":       nil,
	"space": &tld{
		"linkitools": nil,
		"uber":       nil,
		"xs4all":     nil,
	},
	"sport":         nil,
	"spot":          nil,
	"spreadbetting": nil,
	"sr":            nil,
	"srl":           nil,
	"srt":           nil,
	"st": &tld{
		"co":        nil,
		"com":       nil,
		"consulado": nil,
		"edu":       nil,
		"embaixada": nil,
		"gov":       nil,
		"mil":       nil,
		"net":       nil,
		"noho":      nil,
		"nom":       nil,
		"org":       nil,
		"principe":  nil,
		"saotome":   nil,
		"store":     nil,
	},
	"stada":     nil,
	"staples":   nil,
	"star":      nil,
	"statebank": nil,
	"statefarm": nil,
	"stc":       nil,
	"stcgroup":  nil,
	"stockholm": nil,
	"storage":   nil,
	"store":     nil,
	"stream":    nil,
	"studio":    nil,
	"study":     nil,
	"style":     nil,
	"su": &tld{
		"abkhazia":         nil,
		"adygeya":          nil,
		"aktyubinsk":       nil,
		"arkhangelsk":      nil,
		"armenia":          nil,
		"ashgabad":         nil,
		"azerbaijan":       nil,
		"balashov":         nil,
		"bashkiria":        nil,
		"bryansk":          nil,
		"bukhara":          nil,
		"chimkent":         nil,
		"dagestan":         nil,
		"east-kazakhstan":  nil,
		"exnet":            nil,
		"georgia":          nil,
		"grozny":           nil,
		"ivanovo":          nil,
		"jambyl":           nil,
		"kalmykia":         nil,
		"kaluga":           nil,
		"karacol":          nil,
		"karaganda":        nil,
		"karelia":          nil,
		"khakassia":        nil,
		"krasnodar":        nil,
		"kurgan":           nil,
		"kustanai":         nil,
		"lenug":            nil,
		"mangyshlak":       nil,
		"mordovia":         nil,
		"msk":              nil,
		"murmansk":         nil,
		"nalchik":          nil,
		"navoi":            nil,
		"north-kazakhstan": nil,
		"nov":              nil,
		"nym":              nil,
		"obninsk":          nil,
		"penza":            nil,
		"pokrovsk":         nil,
		"sochi":            nil,
		"spb":              nil,
		"tashkent":         nil,
		"termez":           nil,
		"togliatti":        nil,
		"troitsk":          nil,
		"tselinograd":      nil,
		"tula":             nil,
		"tuva":             nil,
		"vladikavkaz":      nil,
		"vladimir":         nil,
		"vologda":          nil,
	},
	"sucks":    nil,
	"supplies": nil,
	"supply":   nil,
	"support": &tld{
		"barsy": nil,
	},
	"surf":    nil,
	"surgery": nil,
	"suzuki":  nil,
	"sv": &tld{
		"com": nil,
		"edu": nil,
		"gob": nil,
		"org": nil,
		"red": nil,
	},
	"swatch":     nil,
	"swiftcover": nil,
	"swiss":      nil,
	"sx": &tld{
		"gov": nil,
		"nym": nil,
	},
	"sy": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
	},
	"sydney":   nil,
	"symantec": nil,
	"systems": &tld{
		"knightpoint": nil,
	},
	"sz": &tld{
		"ac":  nil,
		"co":  nil,
		"org": nil,
	},
	"tab":        nil,
	"taipei":     nil,
	"talk":       nil,
	"taobao":     nil,
	"target":     nil,
	"tatamotors": nil,
	"tatar":      nil,
	"tattoo":     nil,
	"tax":        nil,
	"taxi":       nil,
	"tc":         nil,
	"tci":        nil,
	"td": &tld{
		"blogspot": nil,
	},
	"tdk":  nil,
	"team": nil,
	"tech": nil,
	"technology": &tld{
		"co": nil,
	},
	"tel":        nil,
	"telefonica": nil,
	"temasek":    nil,
	"tennis":     nil,
	"teva":       nil,
	"tf":         nil,
	"tg":         nil,
	"th": &tld{
		"ac":     nil,
		"co":     nil,
		"go":     nil,
		"in":     nil,
		"mi":     nil,
		"net":    nil,
		"online": nil,
		"or":     nil,
		"shop":   nil,
	},
	"thd":     nil,
	"theater": nil,
	"theatre": nil,
	"tiaa":    nil,
	"tickets": nil,
	"tienda":  nil,
	"tiffany": nil,
	"tips":    nil,
	"tires":   nil,
	"tirol":   nil,
	"tj": &tld{
		"ac":   nil,
		"biz":  nil,
		"co":   nil,
		"com":  nil,
		"edu":  nil,
		"go":   nil,
		"gov":  nil,
		"int":  nil,
		"mil":  nil,
		"name": nil,
		"net":  nil,
		"nic":  nil,
		"nom":  nil,
		"org":  nil,
		"test": nil,
		"web":  nil,
	},
	"tjmaxx": nil,
	"tjx":    nil,
	"tk":     nil,
	"tkmaxx": nil,
	"tl": &tld{
		"gov": nil,
	},
	"tm": &tld{
		"co":  nil,
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"tmall": nil,
	"tn": &tld{
		"agrinet": nil,
		"com":     nil,
		"defense": nil,
		"edunet":  nil,
		"ens":     nil,
		"fin":     nil,
		"gov":     nil,
		"ind":     nil,
		"info":    nil,
		"intl":    nil,
		"mincom":  nil,
		"nat":     nil,
		"net":     nil,
		"org":     nil,
		"perso":   nil,
		"rnrt":    nil,
		"rns":     nil,
		"rnu":     nil,
		"tourism": nil,
		"turen":   nil,
	},
	"to": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"mil": nil,
		"net": nil,
		"org": nil,
		"quickconnect": &tld{
			"direct": nil,
		},
		"vpnplus": nil,
	},
	"today": nil,
	"tokyo": nil,
	"tools": nil,
	"top": &tld{
		"now-dns": nil,
		"ntdll":   nil,
	},
	"toray":   nil,
	"toshiba": nil,
	"total":   nil,
	"tours":   nil,
	"town":    nil,
	"toyota":  nil,
	"toys":    nil,
	"tr": &tld{
		"av":  nil,
		"bbs": nil,
		"bel": nil,
		"biz": nil,
		"com": &tld{
			"blogspot": nil,
		},
		"dr":   nil,
		"edu":  nil,
		"gen":  nil,
		"gov":  nil,
		"info": nil,
		"k12":  nil,
		"kep":  nil,
		"mil":  nil,
		"name": nil,
		"nc": &tld{
			"gov": nil,
		},
		"net": nil,
		"org": nil,
		"pol": nil,
		"tel": nil,
		"tsk": nil,
		"tv":  nil,
		"web": nil,
	},
	"trade": &tld{
		"ybo": nil,
	},
	"trading":            nil,
	"training":           nil,
	"travel":             nil,
	"travelchannel":      nil,
	"travelers":          nil,
	"travelersinsurance": nil,
	"trust":              nil,
	"trv":                nil,
	"tt": &tld{
		"aero":   nil,
		"biz":    nil,
		"co":     nil,
		"com":    nil,
		"coop":   nil,
		"edu":    nil,
		"gov":    nil,
		"info":   nil,
		"int":    nil,
		"jobs":   nil,
		"mobi":   nil,
		"museum": nil,
		"name":   nil,
		"net":    nil,
		"org":    nil,
		"pro":    nil,
		"travel": nil,
	},
	"tube":  nil,
	"tui":   nil,
	"tunes": nil,
	"tushu": nil,
	"tv": &tld{
		"better-than": nil,
		"dyndns":      nil,
		"on-the-web":  nil,
		"worse-than":  nil,
	},
	"tvs": nil,
	"tw": &tld{
		"blogspot": nil,
		"club":     nil,
		"com": &tld{
			"mymailer": nil,
		},
		"ebiz": nil,
		"edu":  nil,
		"game": nil,
		"gov":  nil,
		"idv":  nil,
		"mil":  nil,
		"net":  nil,
		"nym":  nil,
		"org":  nil,
		"url":  nil,
		"商業":   nil,
		"組織":   nil,
		"網路":   nil,
	},
	"tz": &tld{
		"ac":    nil,
		"co":    nil,
		"go":    nil,
		"hotel": nil,
		"info":  nil,
		"me":    nil,
		"mil":   nil,
		"mobi":  nil,
		"ne":    nil,
		"or":    nil,
		"sc":    nil,
		"tv":    nil,
	},
	"ua": &tld{
		"biz":             nil,
		"cc":              nil,
		"cherkassy":       nil,
		"cherkasy":        nil,
		"chernigov":       nil,
		"chernihiv":       nil,
		"chernivtsi":      nil,
		"chernovtsy":      nil,
		"ck":              nil,
		"cn":              nil,
		"co":              nil,
		"com":             nil,
		"cr":              nil,
		"crimea":          nil,
		"cv":              nil,
		"dn":              nil,
		"dnepropetrovsk":  nil,
		"dnipropetrovsk":  nil,
		"dominic":         nil,
		"donetsk":         nil,
		"dp":              nil,
		"edu":             nil,
		"gov":             nil,
		"if":              nil,
		"in":              nil,
		"inf":             nil,
		"ivano-frankivsk": nil,
		"kh":              nil,
		"kharkiv":         nil,
		"kharkov":         nil,
		"kherson":         nil,
		"khmelnitskiy":    nil,
		"khmelnytskyi":    nil,
		"kiev":            nil,
		"kirovograd":      nil,
		"km":              nil,
		"kr":              nil,
		"krym":            nil,
		"ks":              nil,
		"kv":              nil,
		"kyiv":            nil,
		"lg":              nil,
		"lt":              nil,
		"ltd":             nil,
		"lugansk":         nil,
		"lutsk":           nil,
		"lv":              nil,
		"lviv":            nil,
		"mk":              nil,
		"mykolaiv":        nil,
		"net":             nil,
		"nikolaev":        nil,
		"od":              nil,
		"odesa":           nil,
		"odessa":          nil,
		"org":             nil,
		"pl":              nil,
		"poltava":         nil,
		"pp":              nil,
		"rivne":           nil,
		"rovno":           nil,
		"rv":              nil,
		"sb":              nil,
		"sebastopol":      nil,
		"sevastopol":      nil,
		"sm":              nil,
		"sumy":            nil,
		"te":              nil,
		"ternopil":        nil,
		"uz":              nil,
		"uzhgorod":        nil,
		"vinnica":         nil,
		"vinnytsia":       nil,
		"vn":              nil,
		"volyn":           nil,
		"yalta":           nil,
		"zaporizhzhe":     nil,
		"zaporizhzhia":    nil,
		"zhitomir":        nil,
		"zhytomyr":        nil,
		"zp":              nil,
		"zt":              nil,
	},
	"ubank":    nil,
	"ubs":      nil,
	"uconnect": nil,
	"ug": &tld{
		"ac":       nil,
		"blogspot": nil,
		"co":       nil,
		"com":      nil,
		"go":       nil,
		"ne":       nil,
		"nom":      nil,
		"or":       nil,
		"org":      nil,
		"sc":       nil,
	},
	"uk": &tld{
		"ac":    nil,
		"barsy": nil,
		"co": &tld{
			"barsy":       nil,
			"barsyonline": nil,
			"blogspot":    nil,
			"bytemark": &tld{
				"dh": nil,
				"vm": nil,
			},
			"gwiddle":       nil,
			"nh-serv":       nil,
			"no-ip":         nil,
			"wellbeingzone": nil,
		},
		"gov": &tld{
			"homeoffice": nil,
			"service":    nil,
		},
		"ltd": nil,
		"me":  nil,
		"net": nil,
		"nhs": nil,
		"org": &tld{
			"glug": nil,
			"lug":  nil,
			"lugs": nil,
		},
		"plc":    nil,
		"police": nil,
		"sch": &tld{
			"*": nil,
		},
	},
	"unicom":     nil,
	"university": nil,
	"uno":        nil,
	"uol":        nil,
	"ups":        nil,
	"us": &tld{
		"ak": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"al": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ar": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"as": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"az": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ca": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"cloudns": nil,
		"co": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ct": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"dc": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"de": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"dni":  nil,
		"drud": nil,
		"fed":  nil,
		"fl": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"freeddns": nil,
		"ga": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"golffan": nil,
		"gu": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"hi": &tld{
			"cc":  nil,
			"lib": nil,
		},
		"ia": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"id": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"il": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"in": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"is-by": nil,
		"isa":   nil,
		"kids":  nil,
		"ks": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ky": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"la": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"land-4-sale": nil,
		"ma": &tld{
			"cc": nil,
			"k12": &tld{
				"chtr":   nil,
				"paroch": nil,
				"pvt":    nil,
			},
			"lib": nil,
		},
		"md": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"me": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"mi": &tld{
			"ann-arbor": nil,
			"cc":        nil,
			"cog":       nil,
			"dst":       nil,
			"eaton":     nil,
			"gen":       nil,
			"k12":       nil,
			"lib":       nil,
			"mus":       nil,
			"tec":       nil,
			"washtenaw": nil,
		},
		"mn": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"mo": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ms": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"mt": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"nc": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"nd": &tld{
			"cc":  nil,
			"lib": nil,
		},
		"ne": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"nh": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"nj": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"nm": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"noip": nil,
		"nsn":  nil,
		"nv": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ny": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"oh": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ok": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"or": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"pa": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"pointto": nil,
		"pr": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ri": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"sc": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"sd": &tld{
			"cc":  nil,
			"lib": nil,
		},
		"stuff-4-sale": nil,
		"tn": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"tx": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"ut": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"va": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"vi": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"vt": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"wa": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"wi": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
		"wv": &tld{
			"cc": nil,
		},
		"wy": &tld{
			"cc":  nil,
			"k12": nil,
			"lib": nil,
		},
	},
	"uy": &tld{
		"com": &tld{
			"blogspot": nil,
		},
		"edu": nil,
		"gub": nil,
		"mil": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"uz": &tld{
		"co":  nil,
		"com": nil,
		"net": nil,
		"org": nil,
	},
	"va":        nil,
	"vacations": nil,
	"vana":      nil,
	"vanguard":  nil,
	"vc": &tld{
		"com": nil,
		"edu": nil,
		"gov": nil,
		"gv": &tld{
			"d": nil,
		},
		"mil": nil,
		"net": nil,
		"nom": nil,
		"org": nil,
	},
	"ve": &tld{
		"arts":  nil,
		"co":    nil,
		"com":   nil,
		"e12":   nil,
		"edu":   nil,
		"firm":  nil,
		"gob":   nil,
		"gov":   nil,
		"info":  nil,
		"int":   nil,
		"mil":   nil,
		"net":   nil,
		"org":   nil,
		"rec":   nil,
		"store": nil,
		"tec":   nil,
		"web":   nil,
	},
	"vegas":             nil,
	"ventures":          nil,
	"verisign":          nil,
	"vermögensberater":  nil,
	"vermögensberatung": nil,
	"versicherung":      nil,
	"vet":               nil,
	"vg": &tld{
		"nom": nil,
	},
	"vi": &tld{
		"co":  nil,
		"com": nil,
		"k12": nil,
		"net": nil,
		"org": nil,
	},
	"viajes":     nil,
	"video":      nil,
	"vig":        nil,
	"viking":     nil,
	"villas":     nil,
	"vin":        nil,
	"vip":        nil,
	"virgin":     nil,
	"visa":       nil,
	"vision":     nil,
	"vistaprint": nil,
	"viva":       nil,
	"vivo":       nil,
	"vlaanderen": nil,
	"vn": &tld{
		"ac":       nil,
		"biz":      nil,
		"blogspot": nil,
		"com":      nil,
		"edu":      nil,
		"gov":      nil,
		"health":   nil,
		"info":     nil,
		"int":      nil,
		"name":     nil,
		"net":      nil,
		"org":      nil,
		"pro":      nil,
	},
	"vodka":      nil,
	"volkswagen": nil,
	"volvo":      nil,
	"vote":       nil,
	"voting":     nil,
	"voto":       nil,
	"voyage":     nil,
	"vu": &tld{
		"com": nil,
		"edu": nil,
		"net": nil,
		"org": nil,
	},
	"vuelos":         nil,
	"wales":          nil,
	"walmart":        nil,
	"walter":         nil,
	"wang":           nil,
	"wanggou":        nil,
	"warman":         nil,
	"watch":          nil,
	"watches":        nil,
	"weather":        nil,
	"weatherchannel": nil,
	"webcam":         nil,
	"weber":          nil,
	"website":        nil,
	"wed":            nil,
	"wedding":        nil,
	"weibo":          nil,
	"weir":           nil,
	"wf":             nil,
	"whoswho":        nil,
	"wien":           nil,
	"wiki":           nil,
	"williamhill":    nil,
	"win":            nil,
	"windows":        nil,
	"wine":           nil,
	"winners":        nil,
	"wme":            nil,
	"wolterskluwer":  nil,
	"woodside":       nil,
	"work": &tld{
		"of": nil,
		"to": nil,
	},
	"works": nil,
	"world": nil,
	"wow":   nil,
	"ws": &tld{
		"advisor": &tld{
			"*": nil,
		},
		"cloud66": nil,
		"com":     nil,
		"dyndns":  nil,
		"edu":     nil,
		"gov":     nil,
		"mypets":  nil,
		"net":     nil,
		"org":     nil,
	},
	"wtc":     nil,
	"wtf":     nil,
	"xbox":    nil,
	"xerox":   nil,
	"xfinity": nil,
	"xihuan":  nil,
	"xin":     nil,
	"xxx":     nil,
	"xyz": &tld{
		"blogsite": nil,
		"crafting": nil,
		"fhapp":    nil,
		"telebit": &tld{
			"*": nil,
		},
		"zapto": nil,
	},
	"yachts":  nil,
	"yahoo":   nil,
	"yamaxun": nil,
	"yandex":  nil,
	"ye": &tld{
		"*": nil,
	},
	"yodobashi": nil,
	"yoga":      nil,
	"yokohama":  nil,
	"you":       nil,
	"youtube":   nil,
	"yt":        nil,
	"yun":       nil,
	"za": &tld{
		"ac":    nil,
		"agric": nil,
		"alt":   nil,
		"co": &tld{
			"blogspot": nil,
		},
		"edu":     nil,
		"gov":     nil,
		"grondar": nil,
		"law":     nil,
		"mil":     nil,
		"net":     nil,
		"ngo":     nil,
		"nic":     nil,
		"nis":     nil,
		"nom":     nil,
		"org":     nil,
		"school":  nil,
		"tm":      nil,
		"web":     nil,
	},
	"zappos": nil,
	"zara":   nil,
	"zero":   nil,
	"zip":    nil,
	"zm": &tld{
		"ac":   nil,
		"biz":  nil,
		"co":   nil,
		"com":  nil,
		"edu":  nil,
		"gov":  nil,
		"info": nil,
		"mil":  nil,
		"net":  nil,
		"org":  nil,
		"sch":  nil,
	},
	"zone": &tld{
		"cloud66": nil,
		"hs":      nil,
		"lima":    nil,
		"triton": &tld{
			"*": nil,
		},
	},
	"zuerich": nil,
	"zw": &tld{
		"ac":  nil,
		"co":  nil,
		"gov": nil,
		"mil": nil,
		"org": nil,
	},
	"ελ":      nil,
	"бг":      nil,
	"бел":     nil,
	"дети":    nil,
	"ею":      nil,
	"католик": nil,
	"ком":     nil,
	"мкд":     nil,
	"мон":     nil,
	"москва":  nil,
	"онлайн":  nil,
	"орг":     nil,
	"рус":     nil,
	"рф":      nil,
	"сайт":    nil,
	"срб": &tld{
		"ак":  nil,
		"обр": nil,
		"од":  nil,
		"орг": nil,
		"пр":  nil,
		"упр": nil,
	},
	"укр":         nil,
	"қаз":         nil,
	"հայ":         nil,
	"קום":         nil,
	"ابوظبي":      nil,
	"اتصالات":     nil,
	"ارامكو":      nil,
	"الاردن":      nil,
	"الجزائر":     nil,
	"السعودية":    nil,
	"السعوديه":    nil,
	"السعودیة":    nil,
	"السعودیۃ":    nil,
	"العليان":     nil,
	"المغرب":      nil,
	"اليمن":       nil,
	"امارات":      nil,
	"ايران":       nil,
	"ایران":       nil,
	"بارت":        nil,
	"بازار":       nil,
	"بيتك":        nil,
	"بھارت":       nil,
	"تونس":        nil,
	"سودان":       nil,
	"سوريا":       nil,
	"سورية":       nil,
	"شبكة":        nil,
	"عراق":        nil,
	"عرب":         nil,
	"عمان":        nil,
	"فلسطين":      nil,
	"قطر":         nil,
	"كاثوليك":     nil,
	"كوم":         nil,
	"مصر":         nil,
	"مليسيا":      nil,
	"موبايلي":     nil,
	"موقع":        nil,
	"همراه":       nil,
	"پاكستان":     nil,
	"پاکستان":     nil,
	"ڀارت":        nil,
	"कॉम":         nil,
	"नेट":         nil,
	"भारत":        nil,
	"भारतम्":      nil,
	"भारोत":       nil,
	"संगठन":       nil,
	"বাংলা":       nil,
	"ভারত":        nil,
	"ভাৰত":        nil,
	"ਭਾਰਤ":        nil,
	"ભારત":        nil,
	"ଭାରତ":        nil,
	"இந்தியா":     nil,
	"இலங்கை":      nil,
	"சிங்கப்பூர்": nil,
	"భారత్":       nil,
	"ಭಾರತ":        nil,
	"ഭാരതം":       nil,
	"ලංකා":        nil,
	"คอม":         nil,
	"ไทย": &tld{
		"ทหาร":   nil,
		"ธุรกิจ": nil,
		"รัฐบาล": nil,
		"ศึกษา":  nil,
		"องค์กร": nil,
		"เน็ต":   nil,
	},
	"გე":     nil,
	"みんな":    nil,
	"クラウド":   nil,
	"グーグル":   nil,
	"コム":     nil,
	"ストア":    nil,
	"セール":    nil,
	"ファッション": nil,
	"ポイント":   nil,
	"世界":     nil,
	"中信":     nil,
	"中国":     nil,
	"中國":     nil,
	"中文网":    nil,
	"企业":     nil,
	"佛山":     nil,
	"信息":     nil,
	"健康":     nil,
	"八卦":     nil,
	"公司":     nil,
	"公益":     nil,
	"台湾":     nil,
	"台灣":     nil,
	"商城":     nil,
	"商店":     nil,
	"商标":     nil,
	"嘉里":     nil,
	"嘉里大酒店":  nil,
	"在线":     nil,
	"大众汽车":   nil,
	"大拿":     nil,
	"天主教":    nil,
	"娱乐":     nil,
	"家電":     nil,
	"工行":     nil,
	"广东":     nil,
	"微博":     nil,
	"慈善":     nil,
	"我爱你":    nil,
	"手机":     nil,
	"手表":     nil,
	"招聘":     nil,
	"政务":     nil,
	"政府":     nil,
	"新加坡":    nil,
	"新闻":     nil,
	"时尚":     nil,
	"書籍":     nil,
	"机构":     nil,
	"淡马锡":    nil,
	"游戏":     nil,
	"澳門":     nil,
	"澳门":     nil,
	"点看":     nil,
	"珠宝":     nil,
	"移动":     nil,
	"组织机构":   nil,
	"网址":     nil,
	"网店":     nil,
	"网站":     nil,
	"网络":     nil,
	"联通":     nil,
	"臺灣":     nil,
	"诺基亚":    nil,
	"谷歌":     nil,
	"购物":     nil,
	"通販":     nil,
	"集团":     nil,
	"電訊盈科":   nil,
	"飞利浦":    nil,
	"食品":     nil,
	"餐厅":     nil,
	"香格里拉":   nil,
	"香港": &tld{
		"個人": nil,
		"公司": nil,
		"政府": nil,
		"教育": nil,
		"組織": nil,
		"網絡": nil,
	},
	"닷넷": nil,
	"닷컴": nil,
	"삼성": nil,
	"한국": nil,
}
