// Code generated by smithy-go-codegen DO NOT EDIT.

package voiceid

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/voiceid/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all speakers in a specified domain.
func (c *Client) ListSpeakers(ctx context.Context, params *ListSpeakersInput, optFns ...func(*Options)) (*ListSpeakersOutput, error) {
	if params == nil {
		params = &ListSpeakersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSpeakers", params, optFns, c.addOperationListSpeakersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSpeakersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSpeakersInput struct {

	// The identifier of the domain.
	//
	// This member is required.
	DomainId *string

	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain further pages of results. The default is 100; the maximum allowed page
	// size is also 100.
	MaxResults *int32

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSpeakersOutput struct {

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours.
	NextToken *string

	// A list containing details about each speaker in the Amazon Web Services account.
	SpeakerSummaries []types.SpeakerSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSpeakersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListSpeakers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListSpeakers{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListSpeakersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSpeakers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSpeakersAPIClient is a client that implements the ListSpeakers operation.
type ListSpeakersAPIClient interface {
	ListSpeakers(context.Context, *ListSpeakersInput, ...func(*Options)) (*ListSpeakersOutput, error)
}

var _ ListSpeakersAPIClient = (*Client)(nil)

// ListSpeakersPaginatorOptions is the paginator options for ListSpeakers
type ListSpeakersPaginatorOptions struct {
	// The maximum number of results that are returned per call. You can use NextToken
	// to obtain further pages of results. The default is 100; the maximum allowed page
	// size is also 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSpeakersPaginator is a paginator for ListSpeakers
type ListSpeakersPaginator struct {
	options   ListSpeakersPaginatorOptions
	client    ListSpeakersAPIClient
	params    *ListSpeakersInput
	nextToken *string
	firstPage bool
}

// NewListSpeakersPaginator returns a new ListSpeakersPaginator
func NewListSpeakersPaginator(client ListSpeakersAPIClient, params *ListSpeakersInput, optFns ...func(*ListSpeakersPaginatorOptions)) *ListSpeakersPaginator {
	if params == nil {
		params = &ListSpeakersInput{}
	}

	options := ListSpeakersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSpeakersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSpeakersPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListSpeakers page.
func (p *ListSpeakersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSpeakersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSpeakers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSpeakers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "voiceid",
		OperationName: "ListSpeakers",
	}
}
