// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Endpoint for mobile app and device.
type Endpoint struct {

	// Attributes for endpoint.
	Attributes map[string]string

	// EndpointArn for mobile app and device.
	EndpointArn *string

	noSmithyDocumentSerde
}

// The user-specified message attribute value. For string data types, the value
// attribute has the same restrictions on the content as the message body. For more
// information, see Publish
// (https://docs.aws.amazon.com/sns/latest/api/API_Publish.html). Name, type, and
// value must not be empty or null. In addition, the message body should not be
// empty or null. All parts of the message attribute, including name, type, and
// value, are included in the message size restriction, which is currently 256 KB
// (262,144 bytes). For more information, see Amazon SNS message attributes
// (https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html) and
// Publishing to a mobile phone
// (https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html) in the
// Amazon SNS Developer Guide.
type MessageAttributeValue struct {

	// Amazon SNS supports the following logical data types: String, String.Array,
	// Number, and Binary. For more information, see Message Attribute Data Types
	// (https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes).
	//
	// This member is required.
	DataType *string

	// Binary type attributes can store any binary data, for example, compressed data,
	// encrypted data, or images.
	BinaryValue []byte

	// Strings are Unicode with UTF8 binary encoding. For a list of code values, see
	// ASCII Printable Characters
	// (https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string

	noSmithyDocumentSerde
}

// A list of phone numbers and their metadata.
type PhoneNumberInformation struct {

	// The date and time when the phone number was created.
	CreatedAt *time.Time

	// The two-character code for the country or region, in ISO 3166-1 alpha-2 format.
	Iso2CountryCode *string

	// The capabilities of each phone number.
	NumberCapabilities []NumberCapability

	// The phone number.
	PhoneNumber *string

	// The list of supported routes.
	RouteType RouteType

	// The status of the phone number.
	Status *string

	noSmithyDocumentSerde
}

// Platform application object.
type PlatformApplication struct {

	// Attributes for platform application object.
	Attributes map[string]string

	// PlatformApplicationArn for platform application object.
	PlatformApplicationArn *string

	noSmithyDocumentSerde
}

// A verified or pending destination phone number in the SMS sandbox. When you
// start using Amazon SNS to send SMS messages, your account is in the SMS sandbox.
// The SMS sandbox provides a safe environment for you to try Amazon SNS features
// without risking your reputation as an SMS sender. While your account is in the
// SMS sandbox, you can use all of the features of Amazon SNS. However, you can
// send SMS messages only to verified destination phone numbers. For more
// information, including how to move out of the sandbox to send messages without
// restrictions, see SMS sandbox
// (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the Amazon
// SNS Developer Guide.
type SMSSandboxPhoneNumber struct {

	// The destination phone number.
	PhoneNumber *string

	// The destination phone number's verification status.
	Status SMSSandboxPhoneNumberVerificationStatus

	noSmithyDocumentSerde
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type Subscription struct {

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string

	// The subscription's owner.
	Owner *string

	// The subscription's protocol.
	Protocol *string

	// The subscription's ARN.
	SubscriptionArn *string

	// The ARN of the subscription's topic.
	TopicArn *string

	noSmithyDocumentSerde
}

// The list of tags to be added to the specified topic.
type Tag struct {

	// The required key portion of the tag.
	//
	// This member is required.
	Key *string

	// The optional value portion of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a topic's
// attributes, use GetTopicAttributes.
type Topic struct {

	// The topic's ARN.
	TopicArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
