// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information about the application.
type AppSummary struct {

	// The unique ID of the application.
	AppId *string

	// The creation time of the application.
	CreationTime *time.Time

	// The description of the application.
	Description *string

	// The ID of the application.
	ImportedAppId *string

	// The last modified time of the application.
	LastModified *time.Time

	// The timestamp of the application's most recent successful replication.
	LatestReplicationTime *time.Time

	// Status of the launch configuration.
	LaunchConfigurationStatus AppLaunchConfigurationStatus

	// Details about the latest launch of the application.
	LaunchDetails *LaunchDetails

	// The launch status of the application.
	LaunchStatus AppLaunchStatus

	// A message related to the launch status of the application.
	LaunchStatusMessage *string

	// The name of the application.
	Name *string

	// Status of the replication configuration.
	ReplicationConfigurationStatus AppReplicationConfigurationStatus

	// The replication status of the application.
	ReplicationStatus AppReplicationStatus

	// A message related to the replication status of the application.
	ReplicationStatusMessage *string

	// The name of the service role in the customer's account used by AWS SMS.
	RoleName *string

	// Status of the application.
	Status AppStatus

	// A message related to the status of the application
	StatusMessage *string

	// The number of server groups present in the application.
	TotalServerGroups *int32

	// The number of servers present in the application.
	TotalServers *int32

	noSmithyDocumentSerde
}

// Configuration for validating an application.
type AppValidationConfiguration struct {

	// The validation strategy.
	AppValidationStrategy AppValidationStrategy

	// The name of the configuration.
	Name *string

	// The validation parameters.
	SsmValidationParameters *SSMValidationParameters

	// The ID of the validation.
	ValidationId *string

	noSmithyDocumentSerde
}

// Output from validating an application.
type AppValidationOutput struct {

	// Output from using SSM to validate the application.
	SsmOutput *SSMOutput

	noSmithyDocumentSerde
}

// Represents a connector.
type Connector struct {

	// The time the connector was associated.
	AssociatedOn *time.Time

	// The capabilities of the connector.
	CapabilityList []ConnectorCapability

	// The ID of the connector.
	ConnectorId *string

	// The IP address of the connector.
	IpAddress *string

	// The MAC address of the connector.
	MacAddress *string

	// The status of the connector.
	Status ConnectorStatus

	// The connector version.
	Version *string

	// The ID of the VM manager.
	VmManagerId *string

	// The name of the VM manager.
	VmManagerName *string

	// The VM management product.
	VmManagerType VmManagerType

	noSmithyDocumentSerde
}

// Details about the latest launch of an application.
type LaunchDetails struct {

	// The latest time that this application was launched successfully.
	LatestLaunchTime *time.Time

	// The ID of the latest stack launched for this application.
	StackId *string

	// The name of the latest stack launched for this application.
	StackName *string

	noSmithyDocumentSerde
}

// Contains the status of validating an application.
type NotificationContext struct {

	// The status of the validation.
	Status ValidationStatus

	// The status message.
	StatusMessage *string

	// The ID of the validation.
	ValidationId *string

	noSmithyDocumentSerde
}

// Represents a replication job.
type ReplicationJob struct {

	// The description of the replication job.
	Description *string

	// Indicates whether the replication job should produce encrypted AMIs.
	Encrypted *bool

	// The time between consecutive replication runs, in hours.
	Frequency *int32

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	// * KMS key ID
	//
	// * KMS key alias
	//
	// * ARN
	// referring to the KMS key ID
	//
	// * ARN referring to the KMS key alias
	//
	// If encrypted
	// is enabled but a KMS key ID is not specified, the customer's default KMS key for
	// Amazon EBS is used.
	KmsKeyId *string

	// The ID of the latest Amazon Machine Image (AMI).
	LatestAmiId *string

	// The license type to be used for the AMI created by a successful replication run.
	LicenseType LicenseType

	// The start time of the next replication run.
	NextReplicationRunStartTime *time.Time

	// The number of recent AMIs to keep in the customer's account for a replication
	// job. By default, the value is set to zero, meaning that all AMIs are kept.
	NumberOfRecentAmisToKeep *int32

	// The ID of the replication job.
	ReplicationJobId *string

	// Information about the replication runs.
	ReplicationRunList []ReplicationRun

	// The name of the IAM role to be used by AWS SMS.
	RoleName *string

	// Indicates whether to run the replication job one time.
	RunOnce *bool

	// The seed replication time.
	SeedReplicationTime *time.Time

	// The ID of the server.
	ServerId *string

	// The type of server.
	ServerType ServerType

	// The state of the replication job.
	State ReplicationJobState

	// The description of the current status of the replication job.
	StatusMessage *string

	// Information about the VM server.
	VmServer *VmServer

	noSmithyDocumentSerde
}

// Represents a replication run.
type ReplicationRun struct {

	// The ID of the Amazon Machine Image (AMI) from the replication run.
	AmiId *string

	// The completion time of the last replication run.
	CompletedTime *time.Time

	// The description of the replication run.
	Description *string

	// Indicates whether the replication run should produce an encrypted AMI.
	Encrypted *bool

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	// * KMS key ID
	//
	// * KMS key alias
	//
	// * ARN
	// referring to the KMS key ID
	//
	// * ARN referring to the KMS key alias
	//
	// If encrypted
	// is true but a KMS key ID is not specified, the customer's default KMS key for
	// Amazon EBS is used.
	KmsKeyId *string

	// The ID of the replication run.
	ReplicationRunId *string

	// The start time of the next replication run.
	ScheduledStartTime *time.Time

	// Details about the current stage of the replication run.
	StageDetails *ReplicationRunStageDetails

	// The state of the replication run.
	State ReplicationRunState

	// The description of the current status of the replication job.
	StatusMessage *string

	// The type of replication run.
	Type ReplicationRunType

	noSmithyDocumentSerde
}

// Details of the current stage of a replication run.
type ReplicationRunStageDetails struct {

	// The current stage of a replication run.
	Stage *string

	// The progress of the current stage of a replication run.
	StageProgress *string

	noSmithyDocumentSerde
}

// Location of an Amazon S3 object.
type S3Location struct {

	// The Amazon S3 bucket name.
	Bucket *string

	// The Amazon S3 bucket key.
	Key *string

	noSmithyDocumentSerde
}

// Represents a server.
type Server struct {

	// The ID of the replication job.
	ReplicationJobId *string

	// Indicates whether the replication job is deleted or failed.
	ReplicationJobTerminated *bool

	// The ID of the server.
	ServerId *string

	// The type of server.
	ServerType ServerType

	// Information about the VM server.
	VmServer *VmServer

	noSmithyDocumentSerde
}

// Logical grouping of servers.
type ServerGroup struct {

	// The name of a server group.
	Name *string

	// The ID of a server group.
	ServerGroupId *string

	// The servers that belong to a server group.
	ServerList []Server

	noSmithyDocumentSerde
}

// Launch configuration for a server group.
type ServerGroupLaunchConfiguration struct {

	// The launch order of servers in the server group.
	LaunchOrder *int32

	// The ID of the server group with which the launch configuration is associated.
	ServerGroupId *string

	// The launch configuration for servers in the server group.
	ServerLaunchConfigurations []ServerLaunchConfiguration

	noSmithyDocumentSerde
}

// Replication configuration for a server group.
type ServerGroupReplicationConfiguration struct {

	// The ID of the server group with which this replication configuration is
	// associated.
	ServerGroupId *string

	// The replication configuration for servers in the server group.
	ServerReplicationConfigurations []ServerReplicationConfiguration

	noSmithyDocumentSerde
}

// Configuration for validating an instance.
type ServerGroupValidationConfiguration struct {

	// The ID of the server group.
	ServerGroupId *string

	// The validation configuration.
	ServerValidationConfigurations []ServerValidationConfiguration

	noSmithyDocumentSerde
}

// Launch configuration for a server.
type ServerLaunchConfiguration struct {

	// Indicates whether a publicly accessible IP address is created when launching the
	// server.
	AssociatePublicIpAddress *bool

	// Location of an Amazon S3 object.
	ConfigureScript *S3Location

	// The type of configuration script.
	ConfigureScriptType ScriptType

	// The name of the Amazon EC2 SSH key to be used for connecting to the launched
	// server.
	Ec2KeyName *string

	// The name of the IAM instance profile.
	IamInstanceProfileName *string

	// The instance type to use when launching the server.
	InstanceType *string

	// The logical ID of the server in the AWS CloudFormation template.
	LogicalId *string

	// The ID of the security group that applies to the launched server.
	SecurityGroup *string

	// The ID of the server with which the launch configuration is associated.
	Server *Server

	// The ID of the subnet the server should be launched into.
	Subnet *string

	// Location of the user-data script to be executed when launching the server.
	UserData *UserData

	// The ID of the VPC into which the server should be launched.
	Vpc *string

	noSmithyDocumentSerde
}

// Replication configuration of a server.
type ServerReplicationConfiguration struct {

	// The ID of the server with which this replication configuration is associated.
	Server *Server

	// The parameters for replicating the server.
	ServerReplicationParameters *ServerReplicationParameters

	noSmithyDocumentSerde
}

// The replication parameters for replicating a server.
type ServerReplicationParameters struct {

	// Indicates whether the replication job produces encrypted AMIs.
	Encrypted *bool

	// The frequency of creating replication jobs for the server.
	Frequency *int32

	// The ID of the KMS key for replication jobs that produce encrypted AMIs. This
	// value can be any of the following:
	//
	// * KMS key ID
	//
	// * KMS key alias
	//
	// * ARN
	// referring to the KMS key ID
	//
	// * ARN referring to the KMS key alias
	//
	// If encrypted
	// is enabled but a KMS key ID is not specified, the customer's default KMS key for
	// Amazon EBS is used.
	KmsKeyId *string

	// The license type for creating a replication job for the server.
	LicenseType LicenseType

	// The number of recent AMIs to keep when creating a replication job for this
	// server.
	NumberOfRecentAmisToKeep *int32

	// Indicates whether to run the replication job one time.
	RunOnce *bool

	// The seed time for creating a replication job for the server.
	SeedTime *time.Time

	noSmithyDocumentSerde
}

// Configuration for validating an instance.
type ServerValidationConfiguration struct {

	// The name of the configuration.
	Name *string

	// Represents a server.
	Server *Server

	// The validation strategy.
	ServerValidationStrategy ServerValidationStrategy

	// The validation parameters.
	UserDataValidationParameters *UserDataValidationParameters

	// The ID of the validation.
	ValidationId *string

	noSmithyDocumentSerde
}

// Contains output from validating an instance.
type ServerValidationOutput struct {

	// Represents a server.
	Server *Server

	noSmithyDocumentSerde
}

// Contains the location of a validation script.
type Source struct {

	// Location of an Amazon S3 object.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Contains the location of validation output.
type SSMOutput struct {

	// Location of an Amazon S3 object.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Contains validation parameters.
type SSMValidationParameters struct {

	// The command to run the validation script
	Command *string

	// The timeout interval, in seconds.
	ExecutionTimeoutSeconds int32

	// The ID of the instance. The instance must have the following tag:
	// UserForSMSApplicationValidation=true.
	InstanceId *string

	// The name of the S3 bucket for output.
	OutputS3BucketName *string

	// The type of validation script.
	ScriptType ScriptType

	// The location of the validation script.
	Source *Source

	noSmithyDocumentSerde
}

// Key/value pair that can be assigned to an application.
type Tag struct {

	// The tag key.
	Key *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// A script that runs on first launch of an Amazon EC2 instance. Used for
// configuring the server during launch.
type UserData struct {

	// Amazon S3 location of the user-data script.
	S3Location *S3Location

	noSmithyDocumentSerde
}

// Contains validation parameters.
type UserDataValidationParameters struct {

	// The type of validation script.
	ScriptType ScriptType

	// The location of the validation script.
	Source *Source

	noSmithyDocumentSerde
}

// Contains validation output.
type ValidationOutput struct {

	// The output from validating an application.
	AppValidationOutput *AppValidationOutput

	// The latest time that the validation was performed.
	LatestValidationTime *time.Time

	// The name of the validation.
	Name *string

	// The output from validation an instance.
	ServerValidationOutput *ServerValidationOutput

	// The status of the validation.
	Status ValidationStatus

	// The status message.
	StatusMessage *string

	// The ID of the validation.
	ValidationId *string

	noSmithyDocumentSerde
}

// Represents a VM server.
type VmServer struct {

	// The name of the VM manager.
	VmManagerName *string

	// The type of VM management product.
	VmManagerType VmManagerType

	// The name of the VM.
	VmName *string

	// The VM folder path in the vCenter Server virtual machine inventory tree.
	VmPath *string

	// The VM server location.
	VmServerAddress *VmServerAddress

	noSmithyDocumentSerde
}

// Represents a VM server location.
type VmServerAddress struct {

	// The ID of the VM.
	VmId *string

	// The ID of the VM manager.
	VmManagerId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
