// Code generated by smithy-go-codegen DO NOT EDIT.

package secretsmanager

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/secretsmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Validates that the resource policy does not grant a wide range of IAM principals
// access to your secret. The JSON request string input and response output
// displays formatted code with white space and line breaks for better readability.
// Submit your input as a single line JSON string. A resource-based policy is
// optional for secrets. The API performs three checks when validating the
// secret:
//
// * Sends a call to Zelkova
// (https://aws.amazon.com/blogs/security/protect-sensitive-data-in-the-cloud-with-automated-reasoning-zelkova/),
// an automated reasoning engine, to ensure your Resource Policy does not allow
// broad access to your secret.
//
// * Checks for correct syntax in a policy.
//
// *
// Verifies the policy does not lock out a caller.
//
// Minimum Permissions You must
// have the permissions required to access the following APIs:
//
// *
// secretsmanager:PutResourcePolicy
//
// * secretsmanager:ValidateResourcePolicy
func (c *Client) ValidateResourcePolicy(ctx context.Context, params *ValidateResourcePolicyInput, optFns ...func(*Options)) (*ValidateResourcePolicyOutput, error) {
	if params == nil {
		params = &ValidateResourcePolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ValidateResourcePolicy", params, optFns, c.addOperationValidateResourcePolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ValidateResourcePolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ValidateResourcePolicyInput struct {

	// A JSON-formatted string constructed according to the grammar and syntax for an
	// Amazon Web Services resource-based policy. The policy in the string identifies
	// who can access or manage this secret and its versions. For information on how to
	// format a JSON parameter for the various command line tool environments, see
	// Using JSON for Parameters
	// (http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json)
	// in the CLI User Guide.publi
	//
	// This member is required.
	ResourcePolicy *string

	// (Optional) The identifier of the secret with the resource-based policy you want
	// to validate. You can specify either the Amazon Resource Name (ARN) or the
	// friendly name of the secret. For an ARN, we recommend that you specify a
	// complete ARN rather than a partial ARN.
	SecretId *string

	noSmithyDocumentSerde
}

type ValidateResourcePolicyOutput struct {

	// Returns a message stating that your Reource Policy passed validation.
	PolicyValidationPassed bool

	// Returns an error message if your policy doesn't pass validatation.
	ValidationErrors []types.ValidationErrorsEntry

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationValidateResourcePolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpValidateResourcePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpValidateResourcePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpValidateResourcePolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opValidateResourcePolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opValidateResourcePolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "secretsmanager",
		OperationName: "ValidateResourcePolicy",
	}
}
