// Code generated by smithy-go-codegen DO NOT EDIT.

package route53recoverycontrolconfig

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/route53recoverycontrolconfig/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the safety rules (that is, the assertion rules and gating rules) for
// the routing controls in a control panel.
func (c *Client) DescribeSafetyRule(ctx context.Context, params *DescribeSafetyRuleInput, optFns ...func(*Options)) (*DescribeSafetyRuleOutput, error) {
	if params == nil {
		params = &DescribeSafetyRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSafetyRule", params, optFns, c.addOperationDescribeSafetyRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSafetyRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSafetyRuleInput struct {

	// The request body that you include when you update a safety rule.
	//
	// This member is required.
	SafetyRuleArn *string

	noSmithyDocumentSerde
}

type DescribeSafetyRuleOutput struct {

	// An assertion rule enforces that, when a routing control state is changed, the
	// criteria set by the rule configuration is met. Otherwise, the change to the
	// routing control is not accepted.
	AssertionRule *types.AssertionRule

	// A gating rule verifies that a set of gating controls evaluates as true, based on
	// a rule configuration that you specify. If the gating rule evaluates to true,
	// Amazon Route 53 Application Recovery Controller allows a set of routing control
	// state changes to run and complete against the set of target controls.
	GatingRule *types.GatingRule

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSafetyRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeSafetyRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeSafetyRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeSafetyRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSafetyRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeSafetyRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "route53-recovery-control-config",
		OperationName: "DescribeSafetyRule",
	}
}
