// Code generated by smithy-go-codegen DO NOT EDIT.

package ram

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ram/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the resources or principals for the resource shares that you own.
func (c *Client) GetResourceShareAssociations(ctx context.Context, params *GetResourceShareAssociationsInput, optFns ...func(*Options)) (*GetResourceShareAssociationsOutput, error) {
	if params == nil {
		params = &GetResourceShareAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceShareAssociations", params, optFns, c.addOperationGetResourceShareAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceShareAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceShareAssociationsInput struct {

	// The association type. Specify PRINCIPAL to list the principals that are
	// associated with the specified resource share. Specify RESOURCE to list the
	// resources that are associated with the specified resource share.
	//
	// This member is required.
	AssociationType types.ResourceShareAssociationType

	// The association status.
	AssociationStatus types.ResourceShareAssociationStatus

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The principal. You cannot specify this parameter if the association type is
	// RESOURCE.
	Principal *string

	// The Amazon Resource Name (ARN) of the resource. You cannot specify this
	// parameter if the association type is PRINCIPAL.
	ResourceArn *string

	// The Amazon Resource Names (ARN) of the resource shares.
	ResourceShareArns []string

	noSmithyDocumentSerde
}

type GetResourceShareAssociationsOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the associations.
	ResourceShareAssociations []types.ResourceShareAssociation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceShareAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetResourceShareAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetResourceShareAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetResourceShareAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceShareAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetResourceShareAssociationsAPIClient is a client that implements the
// GetResourceShareAssociations operation.
type GetResourceShareAssociationsAPIClient interface {
	GetResourceShareAssociations(context.Context, *GetResourceShareAssociationsInput, ...func(*Options)) (*GetResourceShareAssociationsOutput, error)
}

var _ GetResourceShareAssociationsAPIClient = (*Client)(nil)

// GetResourceShareAssociationsPaginatorOptions is the paginator options for
// GetResourceShareAssociations
type GetResourceShareAssociationsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetResourceShareAssociationsPaginator is a paginator for
// GetResourceShareAssociations
type GetResourceShareAssociationsPaginator struct {
	options   GetResourceShareAssociationsPaginatorOptions
	client    GetResourceShareAssociationsAPIClient
	params    *GetResourceShareAssociationsInput
	nextToken *string
	firstPage bool
}

// NewGetResourceShareAssociationsPaginator returns a new
// GetResourceShareAssociationsPaginator
func NewGetResourceShareAssociationsPaginator(client GetResourceShareAssociationsAPIClient, params *GetResourceShareAssociationsInput, optFns ...func(*GetResourceShareAssociationsPaginatorOptions)) *GetResourceShareAssociationsPaginator {
	if params == nil {
		params = &GetResourceShareAssociationsInput{}
	}

	options := GetResourceShareAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetResourceShareAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetResourceShareAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next GetResourceShareAssociations page.
func (p *GetResourceShareAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetResourceShareAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetResourceShareAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetResourceShareAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ram",
		OperationName: "GetResourceShareAssociations",
	}
}
