// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Provides a list of utterances that users have sent to the bot. Utterances are
// aggregated by the text of the utterance. For example, all instances where
// customers used the phrase "I want to order pizza" are aggregated into the same
// line in the response. You can see both detected utterances and missed
// utterances. A detected utterance is where the bot properly recognized the
// utterance and activated the associated intent. A missed utterance was not
// recognized by the bot and didn't activate an intent. Utterances can be
// aggregated for a bot alias or for a bot version, but not both at the same time.
// Utterances statistics are not generated under the following conditions:
//
// * The
// childDirected field was set to true when the bot was created.
//
// * You are using
// slot obfuscation with one or more slots.
//
// * You opted out of participating in
// improving Amazon Lex.
func (c *Client) ListAggregatedUtterances(ctx context.Context, params *ListAggregatedUtterancesInput, optFns ...func(*Options)) (*ListAggregatedUtterancesOutput, error) {
	if params == nil {
		params = &ListAggregatedUtterancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAggregatedUtterances", params, optFns, c.addOperationListAggregatedUtterancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAggregatedUtterancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAggregatedUtterancesInput struct {

	// The time window for aggregating the utterance information. You can specify a
	// time between one hour and two weeks.
	//
	// This member is required.
	AggregationDuration *types.UtteranceAggregationDuration

	// The unique identifier of the bot associated with this request.
	//
	// This member is required.
	BotId *string

	// The identifier of the language and locale where the utterances were collected.
	// For more information, see Supported languages
	// (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
	//
	// This member is required.
	LocaleId *string

	// The identifier of the bot alias associated with this request. If you specify the
	// bot alias, you can't specify the bot version.
	BotAliasId *string

	// The identifier of the bot version associated with this request. If you specify
	// the bot version, you can't specify the bot alias.
	BotVersion *string

	// Provides the specification of a filter used to limit the utterances in the
	// response to only those that match the filter specification. You can only specify
	// one filter and one string to filter on.
	Filters []types.AggregatedUtterancesFilter

	// The maximum number of utterances to return in each page of results. If there are
	// fewer results than the maximum page size, only the actual number of results are
	// returned. If you don't specify the maxResults parameter, 1,000 results are
	// returned.
	MaxResults *int32

	// If the response from the ListAggregatedUtterances operation contains more
	// results that specified in the maxResults parameter, a token is returned in the
	// response. Use that token in the nextToken parameter to return the next page of
	// results.
	NextToken *string

	// Specifies sorting parameters for the list of utterances. You can sort by the hit
	// count, the missed count, or the number of distinct sessions the utterance
	// appeared in.
	SortBy *types.AggregatedUtterancesSortBy

	noSmithyDocumentSerde
}

type ListAggregatedUtterancesOutput struct {

	// Summaries of the aggregated utterance data. Each response contains information
	// about the number of times that the utterance was seen during the time period,
	// whether it was detected or missed, and when it was seen during the time period.
	AggregatedUtterancesSummaries []types.AggregatedUtterancesSummary

	// The time period used to aggregate the utterance data.
	AggregationDuration *types.UtteranceAggregationDuration

	// The last date and time that the aggregated data was collected. The time period
	// depends on the length of the aggregation window.
	//
	// * Hours - for 1 hour time
	// window, every half hour; otherwise every hour.
	//
	// * Days - every 6 hours
	//
	// * Weeks
	// - for a one week time window, every 12 hours; otherwise, every day
	AggregationLastRefreshedDateTime *time.Time

	// The date and time that the aggregation window ends. Only data collected between
	// the start time and the end time are returned in the results.
	AggregationWindowEndTime *time.Time

	// The date and time that the aggregation window begins. Only data collected after
	// this time is returned in the results.
	AggregationWindowStartTime *time.Time

	// The identifier of the bot alias that contains the utterances. If you specified
	// the bot version, the bot alias ID isn't returned.
	BotAliasId *string

	// The identifier of the bot that contains the utterances.
	BotId *string

	// The identifier of the bot version that contains the utterances. If you specified
	// the bot alias, the bot version isn't returned.
	BotVersion *string

	// The identifier of the language and locale that the utterances are in.
	LocaleId *string

	// A token that indicates whether there are more results to return in a response to
	// the ListAggregatedUtterances operation. If the nextToken field is present, you
	// send the contents as the nextToken parameter of a ListAggregatedUtterances
	// operation request to get the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAggregatedUtterancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAggregatedUtterances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAggregatedUtterances{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListAggregatedUtterancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAggregatedUtterances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAggregatedUtterancesAPIClient is a client that implements the
// ListAggregatedUtterances operation.
type ListAggregatedUtterancesAPIClient interface {
	ListAggregatedUtterances(context.Context, *ListAggregatedUtterancesInput, ...func(*Options)) (*ListAggregatedUtterancesOutput, error)
}

var _ ListAggregatedUtterancesAPIClient = (*Client)(nil)

// ListAggregatedUtterancesPaginatorOptions is the paginator options for
// ListAggregatedUtterances
type ListAggregatedUtterancesPaginatorOptions struct {
	// The maximum number of utterances to return in each page of results. If there are
	// fewer results than the maximum page size, only the actual number of results are
	// returned. If you don't specify the maxResults parameter, 1,000 results are
	// returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAggregatedUtterancesPaginator is a paginator for ListAggregatedUtterances
type ListAggregatedUtterancesPaginator struct {
	options   ListAggregatedUtterancesPaginatorOptions
	client    ListAggregatedUtterancesAPIClient
	params    *ListAggregatedUtterancesInput
	nextToken *string
	firstPage bool
}

// NewListAggregatedUtterancesPaginator returns a new
// ListAggregatedUtterancesPaginator
func NewListAggregatedUtterancesPaginator(client ListAggregatedUtterancesAPIClient, params *ListAggregatedUtterancesInput, optFns ...func(*ListAggregatedUtterancesPaginatorOptions)) *ListAggregatedUtterancesPaginator {
	if params == nil {
		params = &ListAggregatedUtterancesInput{}
	}

	options := ListAggregatedUtterancesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAggregatedUtterancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAggregatedUtterancesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListAggregatedUtterances page.
func (p *ListAggregatedUtterancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAggregatedUtterancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAggregatedUtterances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAggregatedUtterances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "lex",
		OperationName: "ListAggregatedUtterances",
	}
}
