// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified customer-owned address pools or all of your
// customer-owned address pools.
func (c *Client) DescribeCoipPools(ctx context.Context, params *DescribeCoipPoolsInput, optFns ...func(*Options)) (*DescribeCoipPoolsOutput, error) {
	if params == nil {
		params = &DescribeCoipPoolsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeCoipPools", params, optFns, c.addOperationDescribeCoipPoolsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeCoipPoolsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeCoipPoolsInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	// The filters. The following are the possible values:
	//
	// * coip-pool.pool-id
	//
	// *
	// coip-pool.local-gateway-route-table-id
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the address pools.
	PoolIds []string

	noSmithyDocumentSerde
}

type DescribeCoipPoolsOutput struct {

	// Information about the address pools.
	CoipPools []types.CoipPool

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeCoipPoolsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeCoipPools{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeCoipPools{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeCoipPools(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeCoipPoolsAPIClient is a client that implements the DescribeCoipPools
// operation.
type DescribeCoipPoolsAPIClient interface {
	DescribeCoipPools(context.Context, *DescribeCoipPoolsInput, ...func(*Options)) (*DescribeCoipPoolsOutput, error)
}

var _ DescribeCoipPoolsAPIClient = (*Client)(nil)

// DescribeCoipPoolsPaginatorOptions is the paginator options for DescribeCoipPools
type DescribeCoipPoolsPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeCoipPoolsPaginator is a paginator for DescribeCoipPools
type DescribeCoipPoolsPaginator struct {
	options   DescribeCoipPoolsPaginatorOptions
	client    DescribeCoipPoolsAPIClient
	params    *DescribeCoipPoolsInput
	nextToken *string
	firstPage bool
}

// NewDescribeCoipPoolsPaginator returns a new DescribeCoipPoolsPaginator
func NewDescribeCoipPoolsPaginator(client DescribeCoipPoolsAPIClient, params *DescribeCoipPoolsInput, optFns ...func(*DescribeCoipPoolsPaginatorOptions)) *DescribeCoipPoolsPaginator {
	if params == nil {
		params = &DescribeCoipPoolsInput{}
	}

	options := DescribeCoipPoolsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeCoipPoolsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeCoipPoolsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribeCoipPools page.
func (p *DescribeCoipPoolsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeCoipPoolsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeCoipPools(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeCoipPools(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "DescribeCoipPools",
	}
}
