// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// A list of the channels moderated by an AppInstanceUser. The x-amz-chime-bearer
// request header is mandatory. Use the AppInstanceUserArn of the user that makes
// the API call as the value in the header.
func (c *Client) ListChannelsModeratedByAppInstanceUser(ctx context.Context, params *ListChannelsModeratedByAppInstanceUserInput, optFns ...func(*Options)) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	if params == nil {
		params = &ListChannelsModeratedByAppInstanceUserInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChannelsModeratedByAppInstanceUser", params, optFns, c.addOperationListChannelsModeratedByAppInstanceUserMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChannelsModeratedByAppInstanceUserOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChannelsModeratedByAppInstanceUserInput struct {

	// The AppInstanceUserArn of the user that makes the API call.
	//
	// This member is required.
	ChimeBearer *string

	// The ARN of the user in the moderated channel.
	AppInstanceUserArn *string

	// The maximum number of channels in the request.
	MaxResults *int32

	// The token returned from previous API requests until the number of channels
	// moderated by the user is reached.
	NextToken *string

	noSmithyDocumentSerde
}

type ListChannelsModeratedByAppInstanceUserOutput struct {

	// The moderated channels in the request.
	Channels []types.ChannelModeratedByAppInstanceUserSummary

	// The token returned from previous API requests until the number of channels
	// moderated by the user is reached.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChannelsModeratedByAppInstanceUserMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChannelsModeratedByAppInstanceUser{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChannelsModeratedByAppInstanceUser{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListChannelsModeratedByAppInstanceUserValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChannelsModeratedByAppInstanceUser(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListChannelsModeratedByAppInstanceUserAPIClient is a client that implements the
// ListChannelsModeratedByAppInstanceUser operation.
type ListChannelsModeratedByAppInstanceUserAPIClient interface {
	ListChannelsModeratedByAppInstanceUser(context.Context, *ListChannelsModeratedByAppInstanceUserInput, ...func(*Options)) (*ListChannelsModeratedByAppInstanceUserOutput, error)
}

var _ ListChannelsModeratedByAppInstanceUserAPIClient = (*Client)(nil)

// ListChannelsModeratedByAppInstanceUserPaginatorOptions is the paginator options
// for ListChannelsModeratedByAppInstanceUser
type ListChannelsModeratedByAppInstanceUserPaginatorOptions struct {
	// The maximum number of channels in the request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChannelsModeratedByAppInstanceUserPaginator is a paginator for
// ListChannelsModeratedByAppInstanceUser
type ListChannelsModeratedByAppInstanceUserPaginator struct {
	options   ListChannelsModeratedByAppInstanceUserPaginatorOptions
	client    ListChannelsModeratedByAppInstanceUserAPIClient
	params    *ListChannelsModeratedByAppInstanceUserInput
	nextToken *string
	firstPage bool
}

// NewListChannelsModeratedByAppInstanceUserPaginator returns a new
// ListChannelsModeratedByAppInstanceUserPaginator
func NewListChannelsModeratedByAppInstanceUserPaginator(client ListChannelsModeratedByAppInstanceUserAPIClient, params *ListChannelsModeratedByAppInstanceUserInput, optFns ...func(*ListChannelsModeratedByAppInstanceUserPaginatorOptions)) *ListChannelsModeratedByAppInstanceUserPaginator {
	if params == nil {
		params = &ListChannelsModeratedByAppInstanceUserInput{}
	}

	options := ListChannelsModeratedByAppInstanceUserPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChannelsModeratedByAppInstanceUserPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChannelsModeratedByAppInstanceUserPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListChannelsModeratedByAppInstanceUser page.
func (p *ListChannelsModeratedByAppInstanceUserPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChannelsModeratedByAppInstanceUserOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListChannelsModeratedByAppInstanceUser(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListChannelsModeratedByAppInstanceUser(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "chime",
		OperationName: "ListChannelsModeratedByAppInstanceUser",
	}
}
