// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A list of backup options for each resource type.
type AdvancedBackupSetting struct {

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows VSS backup jobs. Valid values: Set to
	// "WindowsVSS":"enabled" to enable the WindowsVSS backup option and create a
	// Windows VSS backup. Set to "WindowsVSS":"disabled" to create a regular backup.
	// The WindowsVSS option is not enabled by default. If you specify an invalid
	// option, you get an InvalidParameterValueException exception. For more
	// information about Windows VSS backups, see Creating a VSS-Enabled Windows Backup
	// (https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html).
	BackupOptions map[string]string

	// Specifies an object containing resource type and backup options. The only
	// supported resource type is Amazon EC2 instances with Windows Volume Shadow Copy
	// Service (VSS). For a CloudFormation example, see the sample CloudFormation
	// template to enable Windows VSS
	// (https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html)
	// in the Backup User Guide. Valid values: EC2.
	ResourceType *string

	noSmithyDocumentSerde
}

// Contains detailed information about a backup job.
type BackupJob struct {

	// The account ID that owns the backup job.
	AccountId *string

	// Uniquely identifies a request to Backup to back up a resource.
	BackupJobId *string

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs. Valid
	// values: Set to "WindowsVSS":"enabled" to enable the WindowsVSS backup option and
	// create a Windows VSS backup. Set to "WindowsVSS":"disabled" to create a regular
	// backup. If you specify an invalid option, you get an
	// InvalidParameterValueException exception.
	BackupOptions map[string]string

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64

	// Represents the type of backup for a backup job.
	BackupType *string

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string

	// The size in bytes transferred to a backup vault at the time that the job status
	// was queried.
	BytesTransferred *int64

	// The date and time a job to create a backup job is completed, in Unix format and
	// Coordinated Universal Time (UTC). The value of CompletionDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// Contains identifying information about the creation of a backup job, including
	// the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId of the
	// backup plan used to create it.
	CreatedBy *RecoveryPointCreator

	// The date and time a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The date and time a job to back up resources is expected to be completed, in
	// Unix format and Coordinated Universal Time (UTC). The value of
	// ExpectedCompletionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	ExpectedCompletionDate *time.Time

	// Specifies the IAM role ARN used to create the target recovery point. IAM roles
	// other than the default role must include either AWSBackup or AwsBackup in the
	// role name. For example, arn:aws:iam::123456789012:role/AWSBackupRDSAccess. Role
	// names without those strings lack permissions to perform backup jobs.
	IamRoleArn *string

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string

	// An ARN that uniquely identifies a recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string

	// An ARN that uniquely identifies a resource. The format of the ARN depends on the
	// resource type.
	ResourceArn *string

	// The type of Amazon Web Services resource to be backed up; for example, an Amazon
	// Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the
	// only supported resource type is Amazon EC2.
	ResourceType *string

	// Specifies the time in Unix format and Coordinated Universal Time (UTC) when a
	// backup job must be started before it is canceled. The value is calculated by
	// adding the start window to the scheduled time. So if the scheduled time were
	// 6:00 PM and the start window is 2 hours, the StartBy time would be 8:00 PM on
	// the date specified. The value of StartBy is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	StartBy *time.Time

	// The current state of a resource recovery point.
	State BackupJobState

	// A detailed message explaining the status of the job to back up a resource.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan is a
// separate scheduled task and can back up a different selection of Amazon Web
// Services resources.
type BackupPlan struct {

	// The display name of a backup plan.
	//
	// This member is required.
	BackupPlanName *string

	// An array of BackupRule objects, each of which specifies a scheduled task that is
	// used to back up a selection of resources.
	//
	// This member is required.
	Rules []BackupRule

	// Contains a list of BackupOptions for each resource type.
	AdvancedBackupSettings []AdvancedBackupSetting

	noSmithyDocumentSerde
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan is a
// separate scheduled task.
type BackupPlanInput struct {

	// The optional display name of a backup plan.
	//
	// This member is required.
	BackupPlanName *string

	// An array of BackupRule objects, each of which specifies a scheduled task that is
	// used to back up a selection of resources.
	//
	// This member is required.
	Rules []BackupRuleInput

	// Specifies a list of BackupOptions for each resource type. These settings are
	// only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	AdvancedBackupSettings []AdvancedBackupSetting

	noSmithyDocumentSerde
}

// Contains metadata about a backup plan.
type BackupPlansListMember struct {

	// Contains a list of BackupOptions for a resource type.
	AdvancedBackupSettings []AdvancedBackupSetting

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// The display name of a saved backup plan.
	BackupPlanName *string

	// The date and time a resource backup plan is created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreationDate *time.Time

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of running the operation twice.
	CreatorRequestId *string

	// The date and time a backup plan is deleted, in Unix format and Coordinated
	// Universal Time (UTC). The value of DeletionDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	DeletionDate *time.Time

	// The last time a job to back up resources was run with this rule. A date and
	// time, in Unix format and Coordinated Universal Time (UTC). The value of
	// LastExecutionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionDate *time.Time

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string

	noSmithyDocumentSerde
}

// An object specifying metadata associated with a backup plan template.
type BackupPlanTemplatesListMember struct {

	// Uniquely identifies a stored backup plan template.
	BackupPlanTemplateId *string

	// The optional display name of a backup plan template.
	BackupPlanTemplateName *string

	noSmithyDocumentSerde
}

// Specifies a scheduled task used to back up a selection of resources.
type BackupRule struct {

	// An optional display name for a backup rule.
	//
	// This member is required.
	RuleName *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// This member is required.
	TargetBackupVaultName *string

	// A value in minutes after a backup job is successfully started before it must be
	// completed or it will be canceled by Backup. This value is optional.
	CompletionWindowMinutes *int64

	// An array of CopyAction objects, which contains the details of the copy
	// operation.
	CopyActions []CopyAction

	// Specifies whether Backup creates continuous backups. True causes Backup to
	// create continuous backups capable of point-in-time restore (PITR). False (or not
	// specified) causes Backup to create snapshot backups.
	EnableContinuousBackup *bool

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define. Backups transitioned to cold storage
	// must be stored in cold storage for a minimum of 90 days. Therefore, the “expire
	// after days” setting must be 90 days greater than the “transition to cold after
	// days” setting. The “transition to cold after days” setting cannot be changed
	// after a backup has been transitioned to cold. Only Amazon EFS file system
	// backups can be transitioned to cold storage.
	Lifecycle *Lifecycle

	// An array of key-value pair strings that are assigned to resources that are
	// associated with this rule when restored from backup.
	RecoveryPointTags map[string]string

	// Uniquely identifies a rule that is used to schedule the backup of a selection of
	// resources.
	RuleId *string

	// A cron expression in UTC specifying when Backup initiates a backup job. For more
	// information about cron expressions, see Schedule Expressions for Rules
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
	// in the Amazon CloudWatch Events User Guide.. Prior to specifying a value for
	// this parameter, we recommend testing your cron expression using one of the many
	// available cron generator and testing tools.
	ScheduleExpression *string

	// A value in minutes after a backup is scheduled before a job will be canceled if
	// it doesn't start successfully. This value is optional.
	StartWindowMinutes *int64

	noSmithyDocumentSerde
}

// Specifies a scheduled task used to back up a selection of resources.
type BackupRuleInput struct {

	// An optional display name for a backup rule.
	//
	// This member is required.
	RuleName *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// This member is required.
	TargetBackupVaultName *string

	// A value in minutes after a backup job is successfully started before it must be
	// completed or it will be canceled by Backup. This value is optional.
	CompletionWindowMinutes *int64

	// An array of CopyAction objects, which contains the details of the copy
	// operation.
	CopyActions []CopyAction

	// Specifies whether Backup creates continuous backups. True causes Backup to
	// create continuous backups capable of point-in-time restore (PITR). False (or not
	// specified) causes Backup to create snapshot backups.
	EnableContinuousBackup *bool

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup will transition and expire backups automatically
	// according to the lifecycle that you define. Backups transitioned to cold storage
	// must be stored in cold storage for a minimum of 90 days. Therefore, the “expire
	// after days” setting must be 90 days greater than the “transition to cold after
	// days” setting. The “transition to cold after days” setting cannot be changed
	// after a backup has been transitioned to cold. Only Amazon EFS file system
	// backups can be transitioned to cold storage.
	Lifecycle *Lifecycle

	// To help organize your resources, you can assign your own metadata to the
	// resources that you create. Each tag is a key-value pair.
	RecoveryPointTags map[string]string

	// A CRON expression in UTC specifying when Backup initiates a backup job.
	ScheduleExpression *string

	// A value in minutes after a backup is scheduled before a job will be canceled if
	// it doesn't start successfully. This value is optional.
	StartWindowMinutes *int64

	noSmithyDocumentSerde
}

// Used to specify a set of resources to a backup plan.
type BackupSelection struct {

	// The ARN of the IAM role that Backup uses to authenticate when backing up the
	// target resource; for example, arn:aws:iam::123456789012:role/S3Access.
	//
	// This member is required.
	IamRoleArn *string

	// The display name of a resource selection document.
	//
	// This member is required.
	SelectionName *string

	// An array of conditions used to specify a set of resources to assign to a backup
	// plan; for example, "StringEquals": {"ec2:ResourceTag/Department": "accounting".
	// Assigns the backup plan to every resource with at least one matching tag.
	ListOfTags []Condition

	// An array of strings that contain Amazon Resource Names (ARNs) of resources to
	// assign to a backup plan.
	Resources []string

	noSmithyDocumentSerde
}

// Contains metadata about a BackupSelection object.
type BackupSelectionsListMember struct {

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// The date and time a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of running the operation twice.
	CreatorRequestId *string

	// Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery
	// point; for example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string

	// Uniquely identifies a request to assign a set of resources to a backup plan.
	SelectionId *string

	// The display name of a resource selection document.
	SelectionName *string

	noSmithyDocumentSerde
}

// Contains metadata about a backup vault.
type BackupVaultListMember struct {

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string

	// The date and time a resource backup is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// A unique string that identifies the request and allows failed requests to be
	// retried without the risk of running the operation twice.
	CreatorRequestId *string

	// The server-side encryption key that is used to protect your backups; for
	// example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string

	// The date and time when Backup Vault Lock configuration becomes immutable,
	// meaning it cannot be changed or deleted. If you applied Vault Lock to your vault
	// without specifying a lock date, you can change your Vault Lock settings, or
	// delete Vault Lock from the vault entirely, at any time. This value is in Unix
	// format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	LockDate *time.Time

	// A Boolean value that indicates whether Backup Vault Lock applies to the selected
	// backup vault. If true, Vault Lock prevents delete and update operations on the
	// recovery points in the selected vault.
	Locked *bool

	// The Backup Vault Lock setting that specifies the maximum retention period that
	// the vault retains its recovery points. If this parameter is not specified, Vault
	// Lock does not enforce a maximum retention period on the recovery points in the
	// vault (allowing indefinite storage). If specified, any backup or copy job to the
	// vault must have a lifecycle policy with a retention period equal to or shorter
	// than the maximum retention period. If the job's retention period is longer than
	// that maximum retention period, then the vault fails the backup or copy job, and
	// you should either modify your lifecycle settings or use a different vault.
	// Recovery points already stored in the vault prior to Vault Lock are not
	// affected.
	MaxRetentionDays *int64

	// The Backup Vault Lock setting that specifies the minimum retention period that
	// the vault retains its recovery points. If this parameter is not specified, Vault
	// Lock does not enforce a minimum retention period. If specified, any backup or
	// copy job to the vault must have a lifecycle policy with a retention period equal
	// to or longer than the minimum retention period. If the job's retention period is
	// shorter than that minimum retention period, then the vault fails the backup or
	// copy job, and you should either modify your lifecycle settings or use a
	// different vault. Recovery points already stored in the vault prior to Vault Lock
	// are not affected.
	MinRetentionDays *int64

	// The number of recovery points that are stored in a backup vault.
	NumberOfRecoveryPoints int64

	noSmithyDocumentSerde
}

// Contains DeleteAt and MoveToColdStorageAt timestamps, which are used to specify
// a lifecycle for a recovery point. The lifecycle defines when a protected
// resource is transitioned to cold storage and when it expires. Backup transitions
// and expires backups automatically according to the lifecycle that you define.
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, the “expire after days” setting must be 90 days
// greater than the “transition to cold after days” setting. The “transition to
// cold after days” setting cannot be changed after a backup has been transitioned
// to cold. Only Amazon EFS file system backups can be transitioned to cold
// storage.
type CalculatedLifecycle struct {

	// A timestamp that specifies when to delete a recovery point.
	DeleteAt *time.Time

	// A timestamp that specifies when to transition a recovery point to cold storage.
	MoveToColdStorageAt *time.Time

	noSmithyDocumentSerde
}

// Contains an array of triplets made up of a condition type (such as
// StringEquals), a key, and a value. Conditions are used to filter resources in a
// selection that is assigned to a backup plan.
type Condition struct {

	// The key in a key-value pair. For example, in "ec2:ResourceTag/Department":
	// "accounting", "ec2:ResourceTag/Department" is the key.
	//
	// This member is required.
	ConditionKey *string

	// An operation, such as StringEquals, that is applied to a key-value pair used to
	// filter resources in a selection.
	//
	// This member is required.
	ConditionType ConditionType

	// The value in a key-value pair. For example, in "ec2:ResourceTag/Department":
	// "accounting", "accounting" is the value.
	//
	// This member is required.
	ConditionValue *string

	noSmithyDocumentSerde
}

// A list of parameters for a control. A control can have zero, one, or more than
// one parameter. An example of a control with two parameters is: "backup plan
// frequency is at least daily and the retention period is at least 1 year". The
// first parameter is daily. The second parameter is 1 year.
type ControlInputParameter struct {

	// The name of a parameter, for example, BackupPlanFrequency.
	ParameterName *string

	// The value of parameter, for example, hourly.
	ParameterValue *string

	noSmithyDocumentSerde
}

// A framework consists of one or more controls. Each control has its own control
// scope. The control scope defines what the control will evaluate. Three examples
// of control scopes are: a specific backup plan, all backup plans with a specific
// tag, or all backup plans. To set a control scope that includes all of a
// particular resource, leave the ControlScope empty or do not pass it when calling
// CreateFramework.
type ControlScope struct {

	// The ID of the only Amazon Web Services resource that you want your control scope
	// to contain.
	ComplianceResourceIds []string

	// Describes whether the control scope includes one or more types of resources,
	// such as EFS or RDS.
	ComplianceResourceTypes []string

	// Describes whether the control scope includes resources with one or more tags.
	// Each tag is a key-value pair.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The details of the copy operation.
type CopyAction struct {

	// An Amazon Resource Name (ARN) that uniquely identifies the destination backup
	// vault for the copied backup. For example,
	// arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	//
	// This member is required.
	DestinationBackupVaultArn *string

	// Contains an array of Transition objects specifying how long in days before a
	// recovery point transitions to cold storage or is deleted. Backups transitioned
	// to cold storage must be stored in cold storage for a minimum of 90 days.
	// Therefore, on the console, the “expire after days” setting must be 90 days
	// greater than the “transition to cold after days” setting. The “transition to
	// cold after days” setting cannot be changed after a backup has been transitioned
	// to cold. Only Amazon EFS file system backups can be transitioned to cold
	// storage.
	Lifecycle *Lifecycle

	noSmithyDocumentSerde
}

// Contains detailed information about a copy job.
type CopyJob struct {

	// The account ID that owns the copy job.
	AccountId *string

	// The size, in bytes, of a copy job.
	BackupSizeInBytes *int64

	// The date and time a copy job is completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionDate *time.Time

	// Uniquely identifies a copy job.
	CopyJobId *string

	// Contains information about the backup plan and rule that Backup used to initiate
	// the recovery point backup.
	CreatedBy *RecoveryPointCreator

	// The date and time a copy job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault;
	// for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	DestinationBackupVaultArn *string

	// An ARN that uniquely identifies a destination recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	DestinationRecoveryPointArn *string

	// Specifies the IAM role ARN used to copy the target recovery point; for example,
	// arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string

	// The Amazon Web Services resource to be copied; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon
	// RDS) database.
	ResourceArn *string

	// The type of Amazon Web Services resource to be copied; for example, an Amazon
	// Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database.
	ResourceType *string

	// An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	SourceBackupVaultArn *string

	// An ARN that uniquely identifies a source recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	SourceRecoveryPointArn *string

	// The current state of a copy job.
	State CopyJobState

	// A detailed message explaining the status of the job to copy a resource.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains detailed information about a framework. Frameworks contain controls,
// which evaluate and report on your backup events and resources. Frameworks
// generate daily compliance results.
type Framework struct {

	// The date and time that a framework is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time

	// The deployment status of a framework. The statuses are: CREATE_IN_PROGRESS |
	// UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED
	DeploymentStatus *string

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of
	// the ARN depends on the resource type.
	FrameworkArn *string

	// An optional description of the framework with a maximum 1,024 characters.
	FrameworkDescription *string

	// The unique name of a framework. This name is between 1 and 256 characters,
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
	// underscores (_).
	FrameworkName *string

	// The number of controls contained by the framework.
	NumberOfControls int32

	noSmithyDocumentSerde
}

// Contains detailed information about all of the controls of a framework. Each
// framework must contain at least one control.
type FrameworkControl struct {

	// The name of a control. This name is between 1 and 256 characters.
	//
	// This member is required.
	ControlName *string

	// A list of ParameterName and ParameterValue pairs.
	ControlInputParameters []ControlInputParameter

	// The scope of a control. The control scope defines what the control will
	// evaluate. Three examples of control scopes are: a specific backup plan, all
	// backup plans with a specific tag, or all backup plans. For more information, see
	// ControlScope.
	ControlScope *ControlScope

	noSmithyDocumentSerde
}

// Contains an array of Transition objects specifying how long in days before a
// recovery point transitions to cold storage or is deleted. Backups transitioned
// to cold storage must be stored in cold storage for a minimum of 90 days.
// Therefore, on the console, the “expire after days” setting must be 90 days
// greater than the “transition to cold after days” setting. The “transition to
// cold after days” setting cannot be changed after a backup has been transitioned
// to cold. Only Amazon EFS file system backups can be transitioned to cold
// storage.
type Lifecycle struct {

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays.
	DeleteAfterDays *int64

	// Specifies the number of days after creation that a recovery point is moved to
	// cold storage.
	MoveToColdStorageAfterDays *int64

	noSmithyDocumentSerde
}

// A structure that contains information about a backed-up resource.
type ProtectedResource struct {

	// The date and time a resource was last backed up, in Unix format and Coordinated
	// Universal Time (UTC). The value of LastBackupTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	LastBackupTime *time.Time

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of
	// the ARN depends on the resource type.
	ResourceArn *string

	// The type of Amazon Web Services resource; for example, an Amazon Elastic Block
	// Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS)
	// database. For Windows Volume Shadow Copy Service (VSS) backups, the only
	// supported resource type is Amazon EC2.
	ResourceType *string

	noSmithyDocumentSerde
}

// Contains detailed information about the recovery points stored in a backup
// vault.
type RecoveryPointByBackupVault struct {

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64

	// An ARN that uniquely identifies a backup vault; for example,
	// arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle

	// The date and time a job to restore a recovery point is completed, in Unix format
	// and Coordinated Universal Time (UTC). The value of CompletionDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId
	// of the backup plan that is used to create it.
	CreatedBy *RecoveryPointCreator

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The server-side encryption key that is used to protect your backups; for
	// example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string

	// A Boolean value that is returned as TRUE if the specified recovery point is
	// encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted bool

	// The date and time a recovery point was last restored, in Unix format and
	// Coordinated Universal Time (UTC). The value of LastRestoreTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	LastRestoreTime *time.Time

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define. Backups transitioned to cold storage
	// must be stored in cold storage for a minimum of 90 days. Therefore, the “expire
	// after days” setting must be 90 days greater than the “transition to cold after
	// days” setting. The “transition to cold after days” setting cannot be changed
	// after a backup has been transitioned to cold. Only Amazon EFS file system
	// backups can be transitioned to cold storage.
	Lifecycle *Lifecycle

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string

	// An ARN that uniquely identifies a resource. The format of the ARN depends on the
	// resource type.
	ResourceArn *string

	// The type of Amazon Web Services resource saved as a recovery point; for example,
	// an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational
	// Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service
	// (VSS) backups, the only supported resource type is Amazon EC2.
	ResourceType *string

	// The backup vault where the recovery point was originally copied from. If the
	// recovery point is restored to the same account this value will be null.
	SourceBackupVaultArn *string

	// A status code specifying the state of the recovery point.
	Status RecoveryPointStatus

	// A message explaining the reason of the recovery point deletion failure.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains detailed information about a saved recovery point.
type RecoveryPointByResource struct {

	// The size, in bytes, of a backup.
	BackupSizeBytes *int64

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The server-side encryption key that is used to protect your backups; for
	// example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string

	// A status code specifying the state of the recovery point.
	Status RecoveryPointStatus

	// A message explaining the reason of the recovery point deletion failure.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains information about the backup plan and rule that Backup used to initiate
// the recovery point backup.
type RecoveryPointCreator struct {

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string

	// Uniquely identifies a backup plan.
	BackupPlanId *string

	// Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that
	// are at most 1,024 bytes long. They cannot be edited.
	BackupPlanVersion *string

	// Uniquely identifies a rule used to schedule the backup of a selection of
	// resources.
	BackupRuleId *string

	noSmithyDocumentSerde
}

// Contains information from your report plan about where to deliver your reports,
// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your
// reports.
type ReportDeliveryChannel struct {

	// The unique name of the S3 bucket that receives your reports.
	//
	// This member is required.
	S3BucketName *string

	// A list of the format of your reports: CSV, JSON, or both. If not specified, the
	// default format is CSV.
	Formats []string

	// The prefix for where Backup Audit Manager delivers your reports to Amazon S3.
	// The prefix is this part of the following path:
	// s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name. If not
	// specified, there is no prefix.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// Contains information from your report job about your report destination.
type ReportDestination struct {

	// The unique name of the Amazon S3 bucket that receives your reports.
	S3BucketName *string

	// The object key that uniquely identifies your reports in your S3 bucket.
	S3Keys []string

	noSmithyDocumentSerde
}

// Contains detailed information about a report job. A report job compiles a report
// based on a report plan and publishes it to Amazon S3.
type ReportJob struct {

	// The date and time that a report job is completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionTime *time.Time

	// The date and time that a report job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time

	// The S3 bucket name and S3 keys for the destination where the report job
	// publishes the report.
	ReportDestination *ReportDestination

	// The identifier for a report job. A unique, randomly generated, Unicode, UTF-8
	// encoded string that is at most 1,024 bytes long. Report job IDs cannot be
	// edited.
	ReportJobId *string

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of
	// the ARN depends on the resource type.
	ReportPlanArn *string

	// Identifies the report template for the report. Reports are built using a report
	// template. The report templates are: RESOURCE_COMPLIANCE_REPORT |
	// CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT |
	// RESTORE_JOB_REPORT
	ReportTemplate *string

	// The status of a report job. The statuses are: CREATED | RUNNING | COMPLETED |
	// FAILEDCOMPLETED means that the report is available for your review at your
	// designated destination. If the status is FAILED, review the StatusMessage for
	// the reason.
	Status *string

	// A message explaining the status of the report job.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains detailed information about a report plan.
type ReportPlan struct {

	// The date and time that a report plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time

	// The deployment status of a report plan. The statuses are: CREATE_IN_PROGRESS |
	// UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED
	DeploymentStatus *string

	// The date and time that a report job associated with this report plan last
	// attempted to run, in Unix format and Coordinated Universal Time (UTC). The value
	// of LastAttemptedExecutionTime is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastAttemptedExecutionTime *time.Time

	// The date and time that a report job associated with this report plan last
	// successfully ran, in Unix format and Coordinated Universal Time (UTC). The value
	// of LastSuccessfulExecutionTime is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastSuccessfulExecutionTime *time.Time

	// Contains information about where and how to deliver your reports, specifically
	// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
	ReportDeliveryChannel *ReportDeliveryChannel

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of
	// the ARN depends on the resource type.
	ReportPlanArn *string

	// An optional description of the report plan with a maximum 1,024 characters.
	ReportPlanDescription *string

	// The unique name of the report plan. This name is between 1 and 256 characters
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and
	// underscores (_).
	ReportPlanName *string

	// Identifies the report template for the report. Reports are built using a report
	// template. The report templates are: RESOURCE_COMPLIANCE_REPORT |
	// CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT |
	// RESTORE_JOB_REPORT If the report template is RESOURCE_COMPLIANCE_REPORT or
	// CONTROL_COMPLIANCE_REPORT, this API resource also describes the report coverage
	// by Amazon Web Services Regions and frameworks.
	ReportSetting *ReportSetting

	noSmithyDocumentSerde
}

// Contains detailed information about a report setting.
type ReportSetting struct {

	// Identifies the report template for the report. Reports are built using a report
	// template. The report templates are: RESOURCE_COMPLIANCE_REPORT |
	// CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT |
	// RESTORE_JOB_REPORT
	//
	// This member is required.
	ReportTemplate *string

	// The Amazon Resource Names (ARNs) of the frameworks a report covers.
	FrameworkArns []string

	// The number of frameworks a report covers.
	NumberOfFrameworks int32

	noSmithyDocumentSerde
}

// Contains metadata about a restore job.
type RestoreJobsListMember struct {

	// The account ID that owns the restore job.
	AccountId *string

	// The size, in bytes, of the restored resource.
	BackupSizeInBytes *int64

	// The date and time a job to restore a recovery point is completed, in Unix format
	// and Coordinated Universal Time (UTC). The value of CompletionDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of
	// the ARN depends on the resource type.
	CreatedResourceArn *string

	// The date and time a restore job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time

	// The amount of time in minutes that a job restoring a recovery point is expected
	// to take.
	ExpectedCompletionTimeMinutes *int64

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string

	// An ARN that uniquely identifies a recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string

	// The resource type of the listed restore jobs; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon
	// RDS) database. For Windows Volume Shadow Copy Service (VSS) backups, the only
	// supported resource type is Amazon EC2.
	ResourceType *string

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string

	// A status code specifying the state of the job initiated by Backup to restore a
	// recovery point.
	Status RestoreJobStatus

	// A detailed message explaining the status of the job to restore a recovery point.
	StatusMessage *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
