// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateBackupPlan struct {
}

func (*awsRestjson1_serializeOpCreateBackupPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackupPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackupPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackupPlanInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackupPlanInput(v *CreateBackupPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackupPlanInput(v *CreateBackupPlanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupPlan != nil {
		ok := object.Key("BackupPlan")
		if err := awsRestjson1_serializeDocumentBackupPlanInput(v.BackupPlan, ok); err != nil {
			return err
		}
	}

	if v.BackupPlanTags != nil {
		ok := object.Key("BackupPlanTags")
		if err := awsRestjson1_serializeDocumentTags(v.BackupPlanTags, ok); err != nil {
			return err
		}
	}

	if v.CreatorRequestId != nil {
		ok := object.Key("CreatorRequestId")
		ok.String(*v.CreatorRequestId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackupSelection struct {
}

func (*awsRestjson1_serializeOpCreateBackupSelection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackupSelection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackupSelectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}/selections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBackupSelectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackupSelectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackupSelectionInput(v *CreateBackupSelectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackupSelectionInput(v *CreateBackupSelectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupSelection != nil {
		ok := object.Key("BackupSelection")
		if err := awsRestjson1_serializeDocumentBackupSelection(v.BackupSelection, ok); err != nil {
			return err
		}
	}

	if v.CreatorRequestId != nil {
		ok := object.Key("CreatorRequestId")
		ok.String(*v.CreatorRequestId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBackupVault struct {
}

func (*awsRestjson1_serializeOpCreateBackupVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBackupVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackupVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBackupVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBackupVaultInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBackupVaultInput(v *CreateBackupVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBackupVaultInput(v *CreateBackupVaultInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupVaultTags != nil {
		ok := object.Key("BackupVaultTags")
		if err := awsRestjson1_serializeDocumentTags(v.BackupVaultTags, ok); err != nil {
			return err
		}
	}

	if v.CreatorRequestId != nil {
		ok := object.Key("CreatorRequestId")
		ok.String(*v.CreatorRequestId)
	}

	if v.EncryptionKeyArn != nil {
		ok := object.Key("EncryptionKeyArn")
		ok.String(*v.EncryptionKeyArn)
	}

	return nil
}

type awsRestjson1_serializeOpCreateFramework struct {
}

func (*awsRestjson1_serializeOpCreateFramework) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFramework) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFrameworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/frameworks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFrameworkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFrameworkInput(v *CreateFrameworkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFrameworkInput(v *CreateFrameworkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FrameworkControls != nil {
		ok := object.Key("FrameworkControls")
		if err := awsRestjson1_serializeDocumentFrameworkControls(v.FrameworkControls, ok); err != nil {
			return err
		}
	}

	if v.FrameworkDescription != nil {
		ok := object.Key("FrameworkDescription")
		ok.String(*v.FrameworkDescription)
	}

	if v.FrameworkName != nil {
		ok := object.Key("FrameworkName")
		ok.String(*v.FrameworkName)
	}

	if v.FrameworkTags != nil {
		ok := object.Key("FrameworkTags")
		if err := awsRestjson1_serializeDocumentStringMap(v.FrameworkTags, ok); err != nil {
			return err
		}
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	return nil
}

type awsRestjson1_serializeOpCreateReportPlan struct {
}

func (*awsRestjson1_serializeOpCreateReportPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateReportPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateReportPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-plans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateReportPlanInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateReportPlanInput(v *CreateReportPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateReportPlanInput(v *CreateReportPlanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if v.ReportDeliveryChannel != nil {
		ok := object.Key("ReportDeliveryChannel")
		if err := awsRestjson1_serializeDocumentReportDeliveryChannel(v.ReportDeliveryChannel, ok); err != nil {
			return err
		}
	}

	if v.ReportPlanDescription != nil {
		ok := object.Key("ReportPlanDescription")
		ok.String(*v.ReportPlanDescription)
	}

	if v.ReportPlanName != nil {
		ok := object.Key("ReportPlanName")
		ok.String(*v.ReportPlanName)
	}

	if v.ReportPlanTags != nil {
		ok := object.Key("ReportPlanTags")
		if err := awsRestjson1_serializeDocumentStringMap(v.ReportPlanTags, ok); err != nil {
			return err
		}
	}

	if v.ReportSetting != nil {
		ok := object.Key("ReportSetting")
		if err := awsRestjson1_serializeDocumentReportSetting(v.ReportSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupPlan struct {
}

func (*awsRestjson1_serializeOpDeleteBackupPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupPlanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupPlanInput(v *DeleteBackupPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupSelection struct {
}

func (*awsRestjson1_serializeOpDeleteBackupSelection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupSelection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupSelectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}/selections/{SelectionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupSelectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupSelectionInput(v *DeleteBackupSelectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	if v.SelectionId == nil || len(*v.SelectionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SelectionId must not be empty")}
	}
	if v.SelectionId != nil {
		if err := encoder.SetURI("SelectionId").String(*v.SelectionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupVault struct {
}

func (*awsRestjson1_serializeOpDeleteBackupVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultInput(v *DeleteBackupVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupVaultAccessPolicy struct {
}

func (*awsRestjson1_serializeOpDeleteBackupVaultAccessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupVaultAccessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupVaultAccessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/access-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultAccessPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultAccessPolicyInput(v *DeleteBackupVaultAccessPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupVaultLockConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteBackupVaultLockConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupVaultLockConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupVaultLockConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/vault-lock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultLockConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultLockConfigurationInput(v *DeleteBackupVaultLockConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBackupVaultNotifications struct {
}

func (*awsRestjson1_serializeOpDeleteBackupVaultNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBackupVaultNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupVaultNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/notification-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBackupVaultNotificationsInput(v *DeleteBackupVaultNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFramework struct {
}

func (*awsRestjson1_serializeOpDeleteFramework) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFramework) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFrameworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/frameworks/{FrameworkName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFrameworkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFrameworkInput(v *DeleteFrameworkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FrameworkName == nil || len(*v.FrameworkName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FrameworkName must not be empty")}
	}
	if v.FrameworkName != nil {
		if err := encoder.SetURI("FrameworkName").String(*v.FrameworkName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRecoveryPoint struct {
}

func (*awsRestjson1_serializeOpDeleteRecoveryPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRecoveryPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRecoveryPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRecoveryPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRecoveryPointInput(v *DeleteRecoveryPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn == nil || len(*v.RecoveryPointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecoveryPointArn must not be empty")}
	}
	if v.RecoveryPointArn != nil {
		if err := encoder.SetURI("RecoveryPointArn").String(*v.RecoveryPointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteReportPlan struct {
}

func (*awsRestjson1_serializeOpDeleteReportPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteReportPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteReportPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-plans/{ReportPlanName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteReportPlanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteReportPlanInput(v *DeleteReportPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReportPlanName == nil || len(*v.ReportPlanName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReportPlanName must not be empty")}
	}
	if v.ReportPlanName != nil {
		if err := encoder.SetURI("ReportPlanName").String(*v.ReportPlanName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBackupJob struct {
}

func (*awsRestjson1_serializeOpDescribeBackupJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBackupJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBackupJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBackupJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBackupJobInput(v *DescribeBackupJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBackupVault struct {
}

func (*awsRestjson1_serializeOpDescribeBackupVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBackupVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBackupVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBackupVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBackupVaultInput(v *DescribeBackupVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCopyJob struct {
}

func (*awsRestjson1_serializeOpDescribeCopyJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCopyJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCopyJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/copy-jobs/{CopyJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCopyJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCopyJobInput(v *DescribeCopyJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CopyJobId == nil || len(*v.CopyJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member CopyJobId must not be empty")}
	}
	if v.CopyJobId != nil {
		if err := encoder.SetURI("CopyJobId").String(*v.CopyJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeFramework struct {
}

func (*awsRestjson1_serializeOpDescribeFramework) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeFramework) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFrameworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/frameworks/{FrameworkName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeFrameworkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeFrameworkInput(v *DescribeFrameworkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FrameworkName == nil || len(*v.FrameworkName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FrameworkName must not be empty")}
	}
	if v.FrameworkName != nil {
		if err := encoder.SetURI("FrameworkName").String(*v.FrameworkName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeGlobalSettings struct {
}

func (*awsRestjson1_serializeOpDescribeGlobalSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeGlobalSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeGlobalSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/global-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeGlobalSettingsInput(v *DescribeGlobalSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeProtectedResource struct {
}

func (*awsRestjson1_serializeOpDescribeProtectedResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeProtectedResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeProtectedResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeProtectedResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeProtectedResourceInput(v *DescribeProtectedResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRecoveryPoint struct {
}

func (*awsRestjson1_serializeOpDescribeRecoveryPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRecoveryPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRecoveryPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRecoveryPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRecoveryPointInput(v *DescribeRecoveryPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn == nil || len(*v.RecoveryPointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecoveryPointArn must not be empty")}
	}
	if v.RecoveryPointArn != nil {
		if err := encoder.SetURI("RecoveryPointArn").String(*v.RecoveryPointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRegionSettings struct {
}

func (*awsRestjson1_serializeOpDescribeRegionSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRegionSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRegionSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRegionSettingsInput(v *DescribeRegionSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeReportJob struct {
}

func (*awsRestjson1_serializeOpDescribeReportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeReportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-jobs/{ReportJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeReportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeReportJobInput(v *DescribeReportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReportJobId == nil || len(*v.ReportJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReportJobId must not be empty")}
	}
	if v.ReportJobId != nil {
		if err := encoder.SetURI("ReportJobId").String(*v.ReportJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeReportPlan struct {
}

func (*awsRestjson1_serializeOpDescribeReportPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeReportPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReportPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-plans/{ReportPlanName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeReportPlanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeReportPlanInput(v *DescribeReportPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReportPlanName == nil || len(*v.ReportPlanName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReportPlanName must not be empty")}
	}
	if v.ReportPlanName != nil {
		if err := encoder.SetURI("ReportPlanName").String(*v.ReportPlanName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeRestoreJob struct {
}

func (*awsRestjson1_serializeOpDescribeRestoreJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeRestoreJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRestoreJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs/{RestoreJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeRestoreJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeRestoreJobInput(v *DescribeRestoreJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.RestoreJobId == nil || len(*v.RestoreJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RestoreJobId must not be empty")}
	}
	if v.RestoreJobId != nil {
		if err := encoder.SetURI("RestoreJobId").String(*v.RestoreJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateRecoveryPoint struct {
}

func (*awsRestjson1_serializeOpDisassociateRecoveryPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateRecoveryPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateRecoveryPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}/disassociate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateRecoveryPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateRecoveryPointInput(v *DisassociateRecoveryPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn == nil || len(*v.RecoveryPointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecoveryPointArn must not be empty")}
	}
	if v.RecoveryPointArn != nil {
		if err := encoder.SetURI("RecoveryPointArn").String(*v.RecoveryPointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportBackupPlanTemplate struct {
}

func (*awsRestjson1_serializeOpExportBackupPlanTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportBackupPlanTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportBackupPlanTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}/toTemplate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportBackupPlanTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportBackupPlanTemplateInput(v *ExportBackupPlanTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupPlan struct {
}

func (*awsRestjson1_serializeOpGetBackupPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupPlanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupPlanInput(v *GetBackupPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupPlanFromJSON struct {
}

func (*awsRestjson1_serializeOpGetBackupPlanFromJSON) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupPlanFromJSON) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupPlanFromJSONInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/template/json/toPlan")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetBackupPlanFromJSONInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupPlanFromJSONInput(v *GetBackupPlanFromJSONInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetBackupPlanFromJSONInput(v *GetBackupPlanFromJSONInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupPlanTemplateJson != nil {
		ok := object.Key("BackupPlanTemplateJson")
		ok.String(*v.BackupPlanTemplateJson)
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupPlanFromTemplate struct {
}

func (*awsRestjson1_serializeOpGetBackupPlanFromTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupPlanFromTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupPlanFromTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/template/plans/{BackupPlanTemplateId}/toPlan")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupPlanFromTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupPlanFromTemplateInput(v *GetBackupPlanFromTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanTemplateId == nil || len(*v.BackupPlanTemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanTemplateId must not be empty")}
	}
	if v.BackupPlanTemplateId != nil {
		if err := encoder.SetURI("BackupPlanTemplateId").String(*v.BackupPlanTemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupSelection struct {
}

func (*awsRestjson1_serializeOpGetBackupSelection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupSelection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupSelectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}/selections/{SelectionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupSelectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupSelectionInput(v *GetBackupSelectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	if v.SelectionId == nil || len(*v.SelectionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member SelectionId must not be empty")}
	}
	if v.SelectionId != nil {
		if err := encoder.SetURI("SelectionId").String(*v.SelectionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupVaultAccessPolicy struct {
}

func (*awsRestjson1_serializeOpGetBackupVaultAccessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupVaultAccessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupVaultAccessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/access-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupVaultAccessPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupVaultAccessPolicyInput(v *GetBackupVaultAccessPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBackupVaultNotifications struct {
}

func (*awsRestjson1_serializeOpGetBackupVaultNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBackupVaultNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBackupVaultNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/notification-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBackupVaultNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBackupVaultNotificationsInput(v *GetBackupVaultNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRecoveryPointRestoreMetadata struct {
}

func (*awsRestjson1_serializeOpGetRecoveryPointRestoreMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRecoveryPointRestoreMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRecoveryPointRestoreMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}/restore-metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRecoveryPointRestoreMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRecoveryPointRestoreMetadataInput(v *GetRecoveryPointRestoreMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn == nil || len(*v.RecoveryPointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecoveryPointArn must not be empty")}
	}
	if v.RecoveryPointArn != nil {
		if err := encoder.SetURI("RecoveryPointArn").String(*v.RecoveryPointArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSupportedResourceTypes struct {
}

func (*awsRestjson1_serializeOpGetSupportedResourceTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSupportedResourceTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSupportedResourceTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/supported-resource-types")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSupportedResourceTypesInput(v *GetSupportedResourceTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpListBackupJobs struct {
}

func (*awsRestjson1_serializeOpListBackupJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackupJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupJobsInput(v *ListBackupJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ByAccountId != nil {
		encoder.SetQuery("accountId").String(*v.ByAccountId)
	}

	if v.ByBackupVaultName != nil {
		encoder.SetQuery("backupVaultName").String(*v.ByBackupVaultName)
	}

	if v.ByCreatedAfter != nil {
		encoder.SetQuery("createdAfter").String(smithytime.FormatDateTime(*v.ByCreatedAfter))
	}

	if v.ByCreatedBefore != nil {
		encoder.SetQuery("createdBefore").String(smithytime.FormatDateTime(*v.ByCreatedBefore))
	}

	if v.ByResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ByResourceArn)
	}

	if v.ByResourceType != nil {
		encoder.SetQuery("resourceType").String(*v.ByResourceType)
	}

	if len(v.ByState) > 0 {
		encoder.SetQuery("state").String(string(v.ByState))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBackupPlans struct {
}

func (*awsRestjson1_serializeOpListBackupPlans) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupPlans) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupPlansInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackupPlansInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupPlansInput(v *ListBackupPlansInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IncludeDeleted != nil {
		encoder.SetQuery("includeDeleted").Boolean(*v.IncludeDeleted)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBackupPlanTemplates struct {
}

func (*awsRestjson1_serializeOpListBackupPlanTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupPlanTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupPlanTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/template/plans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackupPlanTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupPlanTemplatesInput(v *ListBackupPlanTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBackupPlanVersions struct {
}

func (*awsRestjson1_serializeOpListBackupPlanVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupPlanVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupPlanVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackupPlanVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupPlanVersionsInput(v *ListBackupPlanVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBackupSelections struct {
}

func (*awsRestjson1_serializeOpListBackupSelections) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupSelections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupSelectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}/selections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackupSelectionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupSelectionsInput(v *ListBackupSelectionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBackupVaults struct {
}

func (*awsRestjson1_serializeOpListBackupVaults) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBackupVaults) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBackupVaultsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBackupVaultsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBackupVaultsInput(v *ListBackupVaultsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCopyJobs struct {
}

func (*awsRestjson1_serializeOpListCopyJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCopyJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCopyJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/copy-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCopyJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCopyJobsInput(v *ListCopyJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ByAccountId != nil {
		encoder.SetQuery("accountId").String(*v.ByAccountId)
	}

	if v.ByCreatedAfter != nil {
		encoder.SetQuery("createdAfter").String(smithytime.FormatDateTime(*v.ByCreatedAfter))
	}

	if v.ByCreatedBefore != nil {
		encoder.SetQuery("createdBefore").String(smithytime.FormatDateTime(*v.ByCreatedBefore))
	}

	if v.ByDestinationVaultArn != nil {
		encoder.SetQuery("destinationVaultArn").String(*v.ByDestinationVaultArn)
	}

	if v.ByResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ByResourceArn)
	}

	if v.ByResourceType != nil {
		encoder.SetQuery("resourceType").String(*v.ByResourceType)
	}

	if len(v.ByState) > 0 {
		encoder.SetQuery("state").String(string(v.ByState))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFrameworks struct {
}

func (*awsRestjson1_serializeOpListFrameworks) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFrameworks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFrameworksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/frameworks")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFrameworksInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFrameworksInput(v *ListFrameworksInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListProtectedResources struct {
}

func (*awsRestjson1_serializeOpListProtectedResources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProtectedResources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProtectedResourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProtectedResourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProtectedResourcesInput(v *ListProtectedResourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRecoveryPointsByBackupVault struct {
}

func (*awsRestjson1_serializeOpListRecoveryPointsByBackupVault) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRecoveryPointsByBackupVault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRecoveryPointsByBackupVaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/recovery-points")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRecoveryPointsByBackupVaultInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRecoveryPointsByBackupVaultInput(v *ListRecoveryPointsByBackupVaultInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	if v.ByBackupPlanId != nil {
		encoder.SetQuery("backupPlanId").String(*v.ByBackupPlanId)
	}

	if v.ByCreatedAfter != nil {
		encoder.SetQuery("createdAfter").String(smithytime.FormatDateTime(*v.ByCreatedAfter))
	}

	if v.ByCreatedBefore != nil {
		encoder.SetQuery("createdBefore").String(smithytime.FormatDateTime(*v.ByCreatedBefore))
	}

	if v.ByResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ByResourceArn)
	}

	if v.ByResourceType != nil {
		encoder.SetQuery("resourceType").String(*v.ByResourceType)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRecoveryPointsByResource struct {
}

func (*awsRestjson1_serializeOpListRecoveryPointsByResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRecoveryPointsByResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRecoveryPointsByResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/resources/{ResourceArn}/recovery-points")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRecoveryPointsByResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRecoveryPointsByResourceInput(v *ListRecoveryPointsByResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListReportJobs struct {
}

func (*awsRestjson1_serializeOpListReportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListReportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListReportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListReportJobsInput(v *ListReportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ByCreationAfter != nil {
		encoder.SetQuery("CreationAfter").String(smithytime.FormatDateTime(*v.ByCreationAfter))
	}

	if v.ByCreationBefore != nil {
		encoder.SetQuery("CreationBefore").String(smithytime.FormatDateTime(*v.ByCreationBefore))
	}

	if v.ByReportPlanName != nil {
		encoder.SetQuery("ReportPlanName").String(*v.ByReportPlanName)
	}

	if v.ByStatus != nil {
		encoder.SetQuery("Status").String(*v.ByStatus)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListReportPlans struct {
}

func (*awsRestjson1_serializeOpListReportPlans) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListReportPlans) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListReportPlansInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-plans")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListReportPlansInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListReportPlansInput(v *ListReportPlansInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRestoreJobs struct {
}

func (*awsRestjson1_serializeOpListRestoreJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRestoreJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRestoreJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRestoreJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRestoreJobsInput(v *ListRestoreJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ByAccountId != nil {
		encoder.SetQuery("accountId").String(*v.ByAccountId)
	}

	if v.ByCreatedAfter != nil {
		encoder.SetQuery("createdAfter").String(smithytime.FormatDateTime(*v.ByCreatedAfter))
	}

	if v.ByCreatedBefore != nil {
		encoder.SetQuery("createdBefore").String(smithytime.FormatDateTime(*v.ByCreatedBefore))
	}

	if len(v.ByStatus) > 0 {
		encoder.SetQuery("status").String(string(v.ByStatus))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTags struct {
}

func (*awsRestjson1_serializeOpListTags) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsInput(v *ListTagsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutBackupVaultAccessPolicy struct {
}

func (*awsRestjson1_serializeOpPutBackupVaultAccessPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutBackupVaultAccessPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBackupVaultAccessPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/access-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutBackupVaultAccessPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutBackupVaultAccessPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutBackupVaultAccessPolicyInput(v *PutBackupVaultAccessPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutBackupVaultAccessPolicyInput(v *PutBackupVaultAccessPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	return nil
}

type awsRestjson1_serializeOpPutBackupVaultLockConfiguration struct {
}

func (*awsRestjson1_serializeOpPutBackupVaultLockConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutBackupVaultLockConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBackupVaultLockConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/vault-lock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutBackupVaultLockConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutBackupVaultLockConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutBackupVaultLockConfigurationInput(v *PutBackupVaultLockConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutBackupVaultLockConfigurationInput(v *PutBackupVaultLockConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChangeableForDays != nil {
		ok := object.Key("ChangeableForDays")
		ok.Long(*v.ChangeableForDays)
	}

	if v.MaxRetentionDays != nil {
		ok := object.Key("MaxRetentionDays")
		ok.Long(*v.MaxRetentionDays)
	}

	if v.MinRetentionDays != nil {
		ok := object.Key("MinRetentionDays")
		ok.Long(*v.MinRetentionDays)
	}

	return nil
}

type awsRestjson1_serializeOpPutBackupVaultNotifications struct {
}

func (*awsRestjson1_serializeOpPutBackupVaultNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutBackupVaultNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBackupVaultNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/notification-configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutBackupVaultNotificationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutBackupVaultNotificationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutBackupVaultNotificationsInput(v *PutBackupVaultNotificationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutBackupVaultNotificationsInput(v *PutBackupVaultNotificationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupVaultEvents != nil {
		ok := object.Key("BackupVaultEvents")
		if err := awsRestjson1_serializeDocumentBackupVaultEvents(v.BackupVaultEvents, ok); err != nil {
			return err
		}
	}

	if v.SNSTopicArn != nil {
		ok := object.Key("SNSTopicArn")
		ok.String(*v.SNSTopicArn)
	}

	return nil
}

type awsRestjson1_serializeOpStartBackupJob struct {
}

func (*awsRestjson1_serializeOpStartBackupJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartBackupJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartBackupJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartBackupJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartBackupJobInput(v *StartBackupJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartBackupJobInput(v *StartBackupJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupOptions != nil {
		ok := object.Key("BackupOptions")
		if err := awsRestjson1_serializeDocumentBackupOptions(v.BackupOptions, ok); err != nil {
			return err
		}
	}

	if v.BackupVaultName != nil {
		ok := object.Key("BackupVaultName")
		ok.String(*v.BackupVaultName)
	}

	if v.CompleteWindowMinutes != nil {
		ok := object.Key("CompleteWindowMinutes")
		ok.Long(*v.CompleteWindowMinutes)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if v.Lifecycle != nil {
		ok := object.Key("Lifecycle")
		if err := awsRestjson1_serializeDocumentLifecycle(v.Lifecycle, ok); err != nil {
			return err
		}
	}

	if v.RecoveryPointTags != nil {
		ok := object.Key("RecoveryPointTags")
		if err := awsRestjson1_serializeDocumentTags(v.RecoveryPointTags, ok); err != nil {
			return err
		}
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.StartWindowMinutes != nil {
		ok := object.Key("StartWindowMinutes")
		ok.Long(*v.StartWindowMinutes)
	}

	return nil
}

type awsRestjson1_serializeOpStartCopyJob struct {
}

func (*awsRestjson1_serializeOpStartCopyJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartCopyJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartCopyJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/copy-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartCopyJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartCopyJobInput(v *StartCopyJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartCopyJobInput(v *StartCopyJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationBackupVaultArn != nil {
		ok := object.Key("DestinationBackupVaultArn")
		ok.String(*v.DestinationBackupVaultArn)
	}

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if v.Lifecycle != nil {
		ok := object.Key("Lifecycle")
		if err := awsRestjson1_serializeDocumentLifecycle(v.Lifecycle, ok); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn != nil {
		ok := object.Key("RecoveryPointArn")
		ok.String(*v.RecoveryPointArn)
	}

	if v.SourceBackupVaultName != nil {
		ok := object.Key("SourceBackupVaultName")
		ok.String(*v.SourceBackupVaultName)
	}

	return nil
}

type awsRestjson1_serializeOpStartReportJob struct {
}

func (*awsRestjson1_serializeOpStartReportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartReportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartReportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-jobs/{ReportPlanName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartReportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartReportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartReportJobInput(v *StartReportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReportPlanName == nil || len(*v.ReportPlanName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReportPlanName must not be empty")}
	}
	if v.ReportPlanName != nil {
		if err := encoder.SetURI("ReportPlanName").String(*v.ReportPlanName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartReportJobInput(v *StartReportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	return nil
}

type awsRestjson1_serializeOpStartRestoreJob struct {
}

func (*awsRestjson1_serializeOpStartRestoreJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartRestoreJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartRestoreJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/restore-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartRestoreJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartRestoreJobInput(v *StartRestoreJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartRestoreJobInput(v *StartRestoreJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if v.Metadata != nil {
		ok := object.Key("Metadata")
		if err := awsRestjson1_serializeDocumentMetadata(v.Metadata, ok); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn != nil {
		ok := object.Key("RecoveryPointArn")
		ok.String(*v.RecoveryPointArn)
	}

	if v.ResourceType != nil {
		ok := object.Key("ResourceType")
		ok.String(*v.ResourceType)
	}

	return nil
}

type awsRestjson1_serializeOpStopBackupJob struct {
}

func (*awsRestjson1_serializeOpStopBackupJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopBackupJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopBackupJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-jobs/{BackupJobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopBackupJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopBackupJobInput(v *StopBackupJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupJobId == nil || len(*v.BackupJobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupJobId must not be empty")}
	}
	if v.BackupJobId != nil {
		if err := encoder.SetURI("BackupJobId").String(*v.BackupJobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/untag/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TagKeyList != nil {
		ok := object.Key("TagKeyList")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeyList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBackupPlan struct {
}

func (*awsRestjson1_serializeOpUpdateBackupPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBackupPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBackupPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup/plans/{BackupPlanId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBackupPlanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBackupPlanInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBackupPlanInput(v *UpdateBackupPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupPlanId == nil || len(*v.BackupPlanId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupPlanId must not be empty")}
	}
	if v.BackupPlanId != nil {
		if err := encoder.SetURI("BackupPlanId").String(*v.BackupPlanId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBackupPlanInput(v *UpdateBackupPlanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupPlan != nil {
		ok := object.Key("BackupPlan")
		if err := awsRestjson1_serializeDocumentBackupPlanInput(v.BackupPlan, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFramework struct {
}

func (*awsRestjson1_serializeOpUpdateFramework) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFramework) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFrameworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/frameworks/{FrameworkName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFrameworkInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFrameworkInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFrameworkInput(v *UpdateFrameworkInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.FrameworkName == nil || len(*v.FrameworkName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member FrameworkName must not be empty")}
	}
	if v.FrameworkName != nil {
		if err := encoder.SetURI("FrameworkName").String(*v.FrameworkName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFrameworkInput(v *UpdateFrameworkInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FrameworkControls != nil {
		ok := object.Key("FrameworkControls")
		if err := awsRestjson1_serializeDocumentFrameworkControls(v.FrameworkControls, ok); err != nil {
			return err
		}
	}

	if v.FrameworkDescription != nil {
		ok := object.Key("FrameworkDescription")
		ok.String(*v.FrameworkDescription)
	}

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGlobalSettings struct {
}

func (*awsRestjson1_serializeOpUpdateGlobalSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGlobalSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGlobalSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/global-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGlobalSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGlobalSettingsInput(v *UpdateGlobalSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGlobalSettingsInput(v *UpdateGlobalSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlobalSettings != nil {
		ok := object.Key("GlobalSettings")
		if err := awsRestjson1_serializeDocumentGlobalSettings(v.GlobalSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRecoveryPointLifecycle struct {
}

func (*awsRestjson1_serializeOpUpdateRecoveryPointLifecycle) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRecoveryPointLifecycle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRecoveryPointLifecycleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/backup-vaults/{BackupVaultName}/recovery-points/{RecoveryPointArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRecoveryPointLifecycleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRecoveryPointLifecycleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRecoveryPointLifecycleInput(v *UpdateRecoveryPointLifecycleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BackupVaultName == nil || len(*v.BackupVaultName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member BackupVaultName must not be empty")}
	}
	if v.BackupVaultName != nil {
		if err := encoder.SetURI("BackupVaultName").String(*v.BackupVaultName); err != nil {
			return err
		}
	}

	if v.RecoveryPointArn == nil || len(*v.RecoveryPointArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RecoveryPointArn must not be empty")}
	}
	if v.RecoveryPointArn != nil {
		if err := encoder.SetURI("RecoveryPointArn").String(*v.RecoveryPointArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRecoveryPointLifecycleInput(v *UpdateRecoveryPointLifecycleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Lifecycle != nil {
		ok := object.Key("Lifecycle")
		if err := awsRestjson1_serializeDocumentLifecycle(v.Lifecycle, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRegionSettings struct {
}

func (*awsRestjson1_serializeOpUpdateRegionSettings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRegionSettings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRegionSettingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/account-settings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRegionSettingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRegionSettingsInput(v *UpdateRegionSettingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRegionSettingsInput(v *UpdateRegionSettingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceTypeOptInPreference != nil {
		ok := object.Key("ResourceTypeOptInPreference")
		if err := awsRestjson1_serializeDocumentResourceTypeOptInPreference(v.ResourceTypeOptInPreference, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateReportPlan struct {
}

func (*awsRestjson1_serializeOpUpdateReportPlan) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateReportPlan) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateReportPlanInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audit/report-plans/{ReportPlanName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateReportPlanInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateReportPlanInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateReportPlanInput(v *UpdateReportPlanInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ReportPlanName == nil || len(*v.ReportPlanName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ReportPlanName must not be empty")}
	}
	if v.ReportPlanName != nil {
		if err := encoder.SetURI("ReportPlanName").String(*v.ReportPlanName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateReportPlanInput(v *UpdateReportPlanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdempotencyToken != nil {
		ok := object.Key("IdempotencyToken")
		ok.String(*v.IdempotencyToken)
	}

	if v.ReportDeliveryChannel != nil {
		ok := object.Key("ReportDeliveryChannel")
		if err := awsRestjson1_serializeDocumentReportDeliveryChannel(v.ReportDeliveryChannel, ok); err != nil {
			return err
		}
	}

	if v.ReportPlanDescription != nil {
		ok := object.Key("ReportPlanDescription")
		ok.String(*v.ReportPlanDescription)
	}

	if v.ReportSetting != nil {
		ok := object.Key("ReportSetting")
		if err := awsRestjson1_serializeDocumentReportSetting(v.ReportSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdvancedBackupSetting(v *types.AdvancedBackupSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupOptions != nil {
		ok := object.Key("BackupOptions")
		if err := awsRestjson1_serializeDocumentBackupOptions(v.BackupOptions, ok); err != nil {
			return err
		}
	}

	if v.ResourceType != nil {
		ok := object.Key("ResourceType")
		ok.String(*v.ResourceType)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdvancedBackupSettings(v []types.AdvancedBackupSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAdvancedBackupSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBackupOptions(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentBackupPlanInput(v *types.BackupPlanInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdvancedBackupSettings != nil {
		ok := object.Key("AdvancedBackupSettings")
		if err := awsRestjson1_serializeDocumentAdvancedBackupSettings(v.AdvancedBackupSettings, ok); err != nil {
			return err
		}
	}

	if v.BackupPlanName != nil {
		ok := object.Key("BackupPlanName")
		ok.String(*v.BackupPlanName)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		if err := awsRestjson1_serializeDocumentBackupRulesInput(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBackupRuleInput(v *types.BackupRuleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompletionWindowMinutes != nil {
		ok := object.Key("CompletionWindowMinutes")
		ok.Long(*v.CompletionWindowMinutes)
	}

	if v.CopyActions != nil {
		ok := object.Key("CopyActions")
		if err := awsRestjson1_serializeDocumentCopyActions(v.CopyActions, ok); err != nil {
			return err
		}
	}

	if v.EnableContinuousBackup != nil {
		ok := object.Key("EnableContinuousBackup")
		ok.Boolean(*v.EnableContinuousBackup)
	}

	if v.Lifecycle != nil {
		ok := object.Key("Lifecycle")
		if err := awsRestjson1_serializeDocumentLifecycle(v.Lifecycle, ok); err != nil {
			return err
		}
	}

	if v.RecoveryPointTags != nil {
		ok := object.Key("RecoveryPointTags")
		if err := awsRestjson1_serializeDocumentTags(v.RecoveryPointTags, ok); err != nil {
			return err
		}
	}

	if v.RuleName != nil {
		ok := object.Key("RuleName")
		ok.String(*v.RuleName)
	}

	if v.ScheduleExpression != nil {
		ok := object.Key("ScheduleExpression")
		ok.String(*v.ScheduleExpression)
	}

	if v.StartWindowMinutes != nil {
		ok := object.Key("StartWindowMinutes")
		ok.Long(*v.StartWindowMinutes)
	}

	if v.TargetBackupVaultName != nil {
		ok := object.Key("TargetBackupVaultName")
		ok.String(*v.TargetBackupVaultName)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackupRulesInput(v []types.BackupRuleInput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBackupRuleInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBackupSelection(v *types.BackupSelection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IamRoleArn != nil {
		ok := object.Key("IamRoleArn")
		ok.String(*v.IamRoleArn)
	}

	if v.ListOfTags != nil {
		ok := object.Key("ListOfTags")
		if err := awsRestjson1_serializeDocumentListOfTags(v.ListOfTags, ok); err != nil {
			return err
		}
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsRestjson1_serializeDocumentResourceArns(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.SelectionName != nil {
		ok := object.Key("SelectionName")
		ok.String(*v.SelectionName)
	}

	return nil
}

func awsRestjson1_serializeDocumentBackupVaultEvents(v []types.BackupVaultEvent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentComplianceResourceIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCondition(v *types.Condition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConditionKey != nil {
		ok := object.Key("ConditionKey")
		ok.String(*v.ConditionKey)
	}

	if len(v.ConditionType) > 0 {
		ok := object.Key("ConditionType")
		ok.String(string(v.ConditionType))
	}

	if v.ConditionValue != nil {
		ok := object.Key("ConditionValue")
		ok.String(*v.ConditionValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentControlInputParameter(v *types.ControlInputParameter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ParameterName != nil {
		ok := object.Key("ParameterName")
		ok.String(*v.ParameterName)
	}

	if v.ParameterValue != nil {
		ok := object.Key("ParameterValue")
		ok.String(*v.ParameterValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentControlInputParameters(v []types.ControlInputParameter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentControlInputParameter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentControlScope(v *types.ControlScope, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComplianceResourceIds != nil {
		ok := object.Key("ComplianceResourceIds")
		if err := awsRestjson1_serializeDocumentComplianceResourceIdList(v.ComplianceResourceIds, ok); err != nil {
			return err
		}
	}

	if v.ComplianceResourceTypes != nil {
		ok := object.Key("ComplianceResourceTypes")
		if err := awsRestjson1_serializeDocumentResourceTypeList(v.ComplianceResourceTypes, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentStringMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCopyAction(v *types.CopyAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationBackupVaultArn != nil {
		ok := object.Key("DestinationBackupVaultArn")
		ok.String(*v.DestinationBackupVaultArn)
	}

	if v.Lifecycle != nil {
		ok := object.Key("Lifecycle")
		if err := awsRestjson1_serializeDocumentLifecycle(v.Lifecycle, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCopyActions(v []types.CopyAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCopyAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFormatList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFrameworkControl(v *types.FrameworkControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ControlInputParameters != nil {
		ok := object.Key("ControlInputParameters")
		if err := awsRestjson1_serializeDocumentControlInputParameters(v.ControlInputParameters, ok); err != nil {
			return err
		}
	}

	if v.ControlName != nil {
		ok := object.Key("ControlName")
		ok.String(*v.ControlName)
	}

	if v.ControlScope != nil {
		ok := object.Key("ControlScope")
		if err := awsRestjson1_serializeDocumentControlScope(v.ControlScope, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameworkControls(v []types.FrameworkControl, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFrameworkControl(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentGlobalSettings(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentLifecycle(v *types.Lifecycle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeleteAfterDays != nil {
		ok := object.Key("DeleteAfterDays")
		ok.Long(*v.DeleteAfterDays)
	}

	if v.MoveToColdStorageAfterDays != nil {
		ok := object.Key("MoveToColdStorageAfterDays")
		ok.Long(*v.MoveToColdStorageAfterDays)
	}

	return nil
}

func awsRestjson1_serializeDocumentListOfTags(v []types.Condition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCondition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMetadata(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentReportDeliveryChannel(v *types.ReportDeliveryChannel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Formats != nil {
		ok := object.Key("Formats")
		if err := awsRestjson1_serializeDocumentFormatList(v.Formats, ok); err != nil {
			return err
		}
	}

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3KeyPrefix != nil {
		ok := object.Key("S3KeyPrefix")
		ok.String(*v.S3KeyPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentReportSetting(v *types.ReportSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FrameworkArns != nil {
		ok := object.Key("FrameworkArns")
		if err := awsRestjson1_serializeDocumentStringList(v.FrameworkArns, ok); err != nil {
			return err
		}
	}

	if v.NumberOfFrameworks != 0 {
		ok := object.Key("NumberOfFrameworks")
		ok.Integer(v.NumberOfFrameworks)
	}

	if v.ReportTemplate != nil {
		ok := object.Key("ReportTemplate")
		ok.String(*v.ReportTemplate)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceArns(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResourceTypeList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResourceTypeOptInPreference(v map[string]bool, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.Boolean(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}
