// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateApiCache struct {
}

func (*validateOpCreateApiCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApiCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApiCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApiCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateApiKey struct {
}

func (*validateOpCreateApiKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApiKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApiKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApiKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDataSource struct {
}

func (*validateOpCreateDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFunction struct {
}

func (*validateOpCreateFunction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFunction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFunctionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFunctionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateGraphqlApi struct {
}

func (*validateOpCreateGraphqlApi) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGraphqlApi) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGraphqlApiInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGraphqlApiInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateResolver struct {
}

func (*validateOpCreateResolver) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateResolver) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateResolverInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateResolverInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateType struct {
}

func (*validateOpCreateType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApiCache struct {
}

func (*validateOpDeleteApiCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApiCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApiCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApiCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApiKey struct {
}

func (*validateOpDeleteApiKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApiKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApiKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApiKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataSource struct {
}

func (*validateOpDeleteDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteFunction struct {
}

func (*validateOpDeleteFunction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteFunction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteFunctionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteFunctionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteGraphqlApi struct {
}

func (*validateOpDeleteGraphqlApi) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteGraphqlApi) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteGraphqlApiInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteGraphqlApiInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteResolver struct {
}

func (*validateOpDeleteResolver) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteResolver) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteResolverInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteResolverInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteType struct {
}

func (*validateOpDeleteType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpFlushApiCache struct {
}

func (*validateOpFlushApiCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpFlushApiCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*FlushApiCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpFlushApiCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetApiCache struct {
}

func (*validateOpGetApiCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetApiCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetApiCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetApiCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDataSource struct {
}

func (*validateOpGetDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetFunction struct {
}

func (*validateOpGetFunction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetFunction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetFunctionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetFunctionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetGraphqlApi struct {
}

func (*validateOpGetGraphqlApi) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetGraphqlApi) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetGraphqlApiInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetGraphqlApiInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetIntrospectionSchema struct {
}

func (*validateOpGetIntrospectionSchema) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetIntrospectionSchema) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetIntrospectionSchemaInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetIntrospectionSchemaInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResolver struct {
}

func (*validateOpGetResolver) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResolver) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResolverInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResolverInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetSchemaCreationStatus struct {
}

func (*validateOpGetSchemaCreationStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetSchemaCreationStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetSchemaCreationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetSchemaCreationStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetType struct {
}

func (*validateOpGetType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListApiKeys struct {
}

func (*validateOpListApiKeys) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListApiKeys) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListApiKeysInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListApiKeysInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDataSources struct {
}

func (*validateOpListDataSources) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDataSources) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDataSourcesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDataSourcesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListFunctions struct {
}

func (*validateOpListFunctions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListFunctions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListFunctionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListFunctionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListResolversByFunction struct {
}

func (*validateOpListResolversByFunction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListResolversByFunction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListResolversByFunctionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListResolversByFunctionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListResolvers struct {
}

func (*validateOpListResolvers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListResolvers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListResolversInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListResolversInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTypes struct {
}

func (*validateOpListTypes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTypes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTypesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTypesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartSchemaCreation struct {
}

func (*validateOpStartSchemaCreation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartSchemaCreation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartSchemaCreationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartSchemaCreationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateApiCache struct {
}

func (*validateOpUpdateApiCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateApiCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateApiCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateApiCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateApiKey struct {
}

func (*validateOpUpdateApiKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateApiKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateApiKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateApiKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDataSource struct {
}

func (*validateOpUpdateDataSource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDataSource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDataSourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDataSourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFunction struct {
}

func (*validateOpUpdateFunction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFunction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFunctionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFunctionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateGraphqlApi struct {
}

func (*validateOpUpdateGraphqlApi) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateGraphqlApi) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateGraphqlApiInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateGraphqlApiInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateResolver struct {
}

func (*validateOpUpdateResolver) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateResolver) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateResolverInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateResolverInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateType struct {
}

func (*validateOpUpdateType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateApiCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApiCache{}, middleware.After)
}

func addOpCreateApiKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApiKey{}, middleware.After)
}

func addOpCreateDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDataSource{}, middleware.After)
}

func addOpCreateFunctionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFunction{}, middleware.After)
}

func addOpCreateGraphqlApiValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGraphqlApi{}, middleware.After)
}

func addOpCreateResolverValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateResolver{}, middleware.After)
}

func addOpCreateTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateType{}, middleware.After)
}

func addOpDeleteApiCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApiCache{}, middleware.After)
}

func addOpDeleteApiKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApiKey{}, middleware.After)
}

func addOpDeleteDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataSource{}, middleware.After)
}

func addOpDeleteFunctionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteFunction{}, middleware.After)
}

func addOpDeleteGraphqlApiValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteGraphqlApi{}, middleware.After)
}

func addOpDeleteResolverValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteResolver{}, middleware.After)
}

func addOpDeleteTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteType{}, middleware.After)
}

func addOpFlushApiCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpFlushApiCache{}, middleware.After)
}

func addOpGetApiCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetApiCache{}, middleware.After)
}

func addOpGetDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDataSource{}, middleware.After)
}

func addOpGetFunctionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetFunction{}, middleware.After)
}

func addOpGetGraphqlApiValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetGraphqlApi{}, middleware.After)
}

func addOpGetIntrospectionSchemaValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetIntrospectionSchema{}, middleware.After)
}

func addOpGetResolverValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResolver{}, middleware.After)
}

func addOpGetSchemaCreationStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetSchemaCreationStatus{}, middleware.After)
}

func addOpGetTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetType{}, middleware.After)
}

func addOpListApiKeysValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListApiKeys{}, middleware.After)
}

func addOpListDataSourcesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDataSources{}, middleware.After)
}

func addOpListFunctionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListFunctions{}, middleware.After)
}

func addOpListResolversByFunctionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListResolversByFunction{}, middleware.After)
}

func addOpListResolversValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListResolvers{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpListTypesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTypes{}, middleware.After)
}

func addOpStartSchemaCreationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartSchemaCreation{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateApiCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateApiCache{}, middleware.After)
}

func addOpUpdateApiKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateApiKey{}, middleware.After)
}

func addOpUpdateDataSourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDataSource{}, middleware.After)
}

func addOpUpdateFunctionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFunction{}, middleware.After)
}

func addOpUpdateGraphqlApiValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateGraphqlApi{}, middleware.After)
}

func addOpUpdateResolverValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateResolver{}, middleware.After)
}

func addOpUpdateTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateType{}, middleware.After)
}

func validateAdditionalAuthenticationProvider(v *types.AdditionalAuthenticationProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AdditionalAuthenticationProvider"}
	if v.OpenIDConnectConfig != nil {
		if err := validateOpenIDConnectConfig(v.OpenIDConnectConfig); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.UserPoolConfig != nil {
		if err := validateCognitoUserPoolConfig(v.UserPoolConfig); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaAuthorizerConfig != nil {
		if err := validateLambdaAuthorizerConfig(v.LambdaAuthorizerConfig); err != nil {
			invalidParams.AddNested("LambdaAuthorizerConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAdditionalAuthenticationProviders(v []types.AdditionalAuthenticationProvider) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AdditionalAuthenticationProviders"}
	for i := range v {
		if err := validateAdditionalAuthenticationProvider(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuthorizationConfig(v *types.AuthorizationConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuthorizationConfig"}
	if len(v.AuthorizationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AuthorizationType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCognitoUserPoolConfig(v *types.CognitoUserPoolConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CognitoUserPoolConfig"}
	if v.UserPoolId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UserPoolId"))
	}
	if v.AwsRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsRegion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynamodbDataSourceConfig(v *types.DynamodbDataSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynamodbDataSourceConfig"}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.AwsRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsRegion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateElasticsearchDataSourceConfig(v *types.ElasticsearchDataSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ElasticsearchDataSourceConfig"}
	if v.Endpoint == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Endpoint"))
	}
	if v.AwsRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsRegion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHttpDataSourceConfig(v *types.HttpDataSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HttpDataSourceConfig"}
	if v.AuthorizationConfig != nil {
		if err := validateAuthorizationConfig(v.AuthorizationConfig); err != nil {
			invalidParams.AddNested("AuthorizationConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaAuthorizerConfig(v *types.LambdaAuthorizerConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaAuthorizerConfig"}
	if v.AuthorizerUri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthorizerUri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLambdaDataSourceConfig(v *types.LambdaDataSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LambdaDataSourceConfig"}
	if v.LambdaFunctionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LambdaFunctionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLogConfig(v *types.LogConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LogConfig"}
	if len(v.FieldLogLevel) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FieldLogLevel"))
	}
	if v.CloudWatchLogsRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudWatchLogsRoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenIDConnectConfig(v *types.OpenIDConnectConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenIDConnectConfig"}
	if v.Issuer == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Issuer"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenSearchServiceDataSourceConfig(v *types.OpenSearchServiceDataSourceConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenSearchServiceDataSourceConfig"}
	if v.Endpoint == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Endpoint"))
	}
	if v.AwsRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsRegion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUserPoolConfig(v *types.UserPoolConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UserPoolConfig"}
	if v.UserPoolId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UserPoolId"))
	}
	if v.AwsRegion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsRegion"))
	}
	if len(v.DefaultAction) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DefaultAction"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApiCacheInput(v *CreateApiCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApiCacheInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if len(v.ApiCachingBehavior) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ApiCachingBehavior"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApiKeyInput(v *CreateApiKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApiKeyInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDataSourceInput(v *CreateDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDataSourceInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.DynamodbConfig != nil {
		if err := validateDynamodbDataSourceConfig(v.DynamodbConfig); err != nil {
			invalidParams.AddNested("DynamodbConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaConfig != nil {
		if err := validateLambdaDataSourceConfig(v.LambdaConfig); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.ElasticsearchConfig != nil {
		if err := validateElasticsearchDataSourceConfig(v.ElasticsearchConfig); err != nil {
			invalidParams.AddNested("ElasticsearchConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenSearchServiceConfig != nil {
		if err := validateOpenSearchServiceDataSourceConfig(v.OpenSearchServiceConfig); err != nil {
			invalidParams.AddNested("OpenSearchServiceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.HttpConfig != nil {
		if err := validateHttpDataSourceConfig(v.HttpConfig); err != nil {
			invalidParams.AddNested("HttpConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFunctionInput(v *CreateFunctionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFunctionInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.DataSourceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSourceName"))
	}
	if v.FunctionVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGraphqlApiInput(v *CreateGraphqlApiInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGraphqlApiInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.LogConfig != nil {
		if err := validateLogConfig(v.LogConfig); err != nil {
			invalidParams.AddNested("LogConfig", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.AuthenticationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AuthenticationType"))
	}
	if v.UserPoolConfig != nil {
		if err := validateUserPoolConfig(v.UserPoolConfig); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenIDConnectConfig != nil {
		if err := validateOpenIDConnectConfig(v.OpenIDConnectConfig); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdditionalAuthenticationProviders != nil {
		if err := validateAdditionalAuthenticationProviders(v.AdditionalAuthenticationProviders); err != nil {
			invalidParams.AddNested("AdditionalAuthenticationProviders", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaAuthorizerConfig != nil {
		if err := validateLambdaAuthorizerConfig(v.LambdaAuthorizerConfig); err != nil {
			invalidParams.AddNested("LambdaAuthorizerConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateResolverInput(v *CreateResolverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateResolverInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if v.FieldName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FieldName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTypeInput(v *CreateTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTypeInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Definition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Definition"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApiCacheInput(v *DeleteApiCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApiCacheInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApiKeyInput(v *DeleteApiKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApiKeyInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataSourceInput(v *DeleteDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataSourceInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteFunctionInput(v *DeleteFunctionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFunctionInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.FunctionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteGraphqlApiInput(v *DeleteGraphqlApiInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteGraphqlApiInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteResolverInput(v *DeleteResolverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteResolverInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if v.FieldName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FieldName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTypeInput(v *DeleteTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTypeInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpFlushApiCacheInput(v *FlushApiCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FlushApiCacheInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetApiCacheInput(v *GetApiCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetApiCacheInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDataSourceInput(v *GetDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDataSourceInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetFunctionInput(v *GetFunctionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetFunctionInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.FunctionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetGraphqlApiInput(v *GetGraphqlApiInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetGraphqlApiInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetIntrospectionSchemaInput(v *GetIntrospectionSchemaInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetIntrospectionSchemaInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResolverInput(v *GetResolverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResolverInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if v.FieldName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FieldName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetSchemaCreationStatusInput(v *GetSchemaCreationStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetSchemaCreationStatusInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTypeInput(v *GetTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTypeInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListApiKeysInput(v *ListApiKeysInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListApiKeysInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDataSourcesInput(v *ListDataSourcesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDataSourcesInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListFunctionsInput(v *ListFunctionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListFunctionsInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListResolversByFunctionInput(v *ListResolversByFunctionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListResolversByFunctionInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.FunctionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListResolversInput(v *ListResolversInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListResolversInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTypesInput(v *ListTypesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTypesInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartSchemaCreationInput(v *StartSchemaCreationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartSchemaCreationInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Definition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Definition"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateApiCacheInput(v *UpdateApiCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateApiCacheInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if len(v.ApiCachingBehavior) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ApiCachingBehavior"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateApiKeyInput(v *UpdateApiKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateApiKeyInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDataSourceInput(v *UpdateDataSourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDataSourceInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.DynamodbConfig != nil {
		if err := validateDynamodbDataSourceConfig(v.DynamodbConfig); err != nil {
			invalidParams.AddNested("DynamodbConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaConfig != nil {
		if err := validateLambdaDataSourceConfig(v.LambdaConfig); err != nil {
			invalidParams.AddNested("LambdaConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.ElasticsearchConfig != nil {
		if err := validateElasticsearchDataSourceConfig(v.ElasticsearchConfig); err != nil {
			invalidParams.AddNested("ElasticsearchConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenSearchServiceConfig != nil {
		if err := validateOpenSearchServiceDataSourceConfig(v.OpenSearchServiceConfig); err != nil {
			invalidParams.AddNested("OpenSearchServiceConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.HttpConfig != nil {
		if err := validateHttpDataSourceConfig(v.HttpConfig); err != nil {
			invalidParams.AddNested("HttpConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFunctionInput(v *UpdateFunctionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFunctionInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.FunctionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionId"))
	}
	if v.DataSourceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSourceName"))
	}
	if v.FunctionVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FunctionVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateGraphqlApiInput(v *UpdateGraphqlApiInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateGraphqlApiInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.LogConfig != nil {
		if err := validateLogConfig(v.LogConfig); err != nil {
			invalidParams.AddNested("LogConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.UserPoolConfig != nil {
		if err := validateUserPoolConfig(v.UserPoolConfig); err != nil {
			invalidParams.AddNested("UserPoolConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenIDConnectConfig != nil {
		if err := validateOpenIDConnectConfig(v.OpenIDConnectConfig); err != nil {
			invalidParams.AddNested("OpenIDConnectConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AdditionalAuthenticationProviders != nil {
		if err := validateAdditionalAuthenticationProviders(v.AdditionalAuthenticationProviders); err != nil {
			invalidParams.AddNested("AdditionalAuthenticationProviders", err.(smithy.InvalidParamsError))
		}
	}
	if v.LambdaAuthorizerConfig != nil {
		if err := validateLambdaAuthorizerConfig(v.LambdaAuthorizerConfig); err != nil {
			invalidParams.AddNested("LambdaAuthorizerConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateResolverInput(v *UpdateResolverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateResolverInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if v.FieldName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FieldName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateTypeInput(v *UpdateTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateTypeInput"}
	if v.ApiId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApiId"))
	}
	if v.TypeName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TypeName"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
