// Code generated by smithy-go-codegen DO NOT EDIT.

package sqs

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/sqs/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"sort"
)

type awsAwsquery_serializeOpAddPermission struct {
}

func (*awsAwsquery_serializeOpAddPermission) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpAddPermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddPermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AddPermission")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentAddPermissionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpChangeMessageVisibility struct {
}

func (*awsAwsquery_serializeOpChangeMessageVisibility) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpChangeMessageVisibility) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ChangeMessageVisibilityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ChangeMessageVisibility")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentChangeMessageVisibilityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpChangeMessageVisibilityBatch struct {
}

func (*awsAwsquery_serializeOpChangeMessageVisibilityBatch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpChangeMessageVisibilityBatch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ChangeMessageVisibilityBatchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ChangeMessageVisibilityBatch")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentChangeMessageVisibilityBatchInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpCreateQueue struct {
}

func (*awsAwsquery_serializeOpCreateQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpCreateQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateQueue")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentCreateQueueInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteMessage struct {
}

func (*awsAwsquery_serializeOpDeleteMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteMessage")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentDeleteMessageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteMessageBatch struct {
}

func (*awsAwsquery_serializeOpDeleteMessageBatch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteMessageBatch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMessageBatchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteMessageBatch")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentDeleteMessageBatchInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpDeleteQueue struct {
}

func (*awsAwsquery_serializeOpDeleteQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpDeleteQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteQueue")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentDeleteQueueInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetQueueAttributes struct {
}

func (*awsAwsquery_serializeOpGetQueueAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetQueueAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetQueueAttributes")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentGetQueueAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpGetQueueUrl struct {
}

func (*awsAwsquery_serializeOpGetQueueUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpGetQueueUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetQueueUrl")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentGetQueueUrlInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListDeadLetterSourceQueues struct {
}

func (*awsAwsquery_serializeOpListDeadLetterSourceQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListDeadLetterSourceQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDeadLetterSourceQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListDeadLetterSourceQueues")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentListDeadLetterSourceQueuesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListQueues struct {
}

func (*awsAwsquery_serializeOpListQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListQueues")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentListQueuesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpListQueueTags struct {
}

func (*awsAwsquery_serializeOpListQueueTags) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpListQueueTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueueTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ListQueueTags")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentListQueueTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpPurgeQueue struct {
}

func (*awsAwsquery_serializeOpPurgeQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpPurgeQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurgeQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PurgeQueue")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentPurgeQueueInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpReceiveMessage struct {
}

func (*awsAwsquery_serializeOpReceiveMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpReceiveMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReceiveMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReceiveMessage")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentReceiveMessageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpRemovePermission struct {
}

func (*awsAwsquery_serializeOpRemovePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpRemovePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RemovePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RemovePermission")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentRemovePermissionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendMessage struct {
}

func (*awsAwsquery_serializeOpSendMessage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendMessage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendMessageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendMessage")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentSendMessageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSendMessageBatch struct {
}

func (*awsAwsquery_serializeOpSendMessageBatch) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSendMessageBatch) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendMessageBatchInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendMessageBatch")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentSendMessageBatchInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpSetQueueAttributes struct {
}

func (*awsAwsquery_serializeOpSetQueueAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpSetQueueAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetQueueAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SetQueueAttributes")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentSetQueueAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpTagQueue struct {
}

func (*awsAwsquery_serializeOpTagQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpTagQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TagQueue")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentTagQueueInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsquery_serializeOpUntagQueue struct {
}

func (*awsAwsquery_serializeOpUntagQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsquery_serializeOpUntagQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UntagQueue")
	body.Key("Version").String("2012-11-05")

	if err := awsAwsquery_serializeOpDocumentUntagQueueInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsquery_serializeDocumentActionNameList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentAttributeNameList(v []types.QueueAttributeName, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsquery_serializeDocumentAWSAccountIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentBinaryList(v [][]byte, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("BinaryListValue")

	for i := range v {
		if vv := v[i]; vv == nil {
			continue
		}
		av := array.Value()
		av.Base64EncodeBytes(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentChangeMessageVisibilityBatchRequestEntry(v *types.ChangeMessageVisibilityBatchRequestEntry, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.ReceiptHandle != nil {
		objectKey := object.Key("ReceiptHandle")
		objectKey.String(*v.ReceiptHandle)
	}

	if v.VisibilityTimeout != 0 {
		objectKey := object.Key("VisibilityTimeout")
		objectKey.Integer(v.VisibilityTimeout)
	}

	return nil
}

func awsAwsquery_serializeDocumentChangeMessageVisibilityBatchRequestEntryList(v []types.ChangeMessageVisibilityBatchRequestEntry, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentChangeMessageVisibilityBatchRequestEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentDeleteMessageBatchRequestEntry(v *types.DeleteMessageBatchRequestEntry, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.ReceiptHandle != nil {
		objectKey := object.Key("ReceiptHandle")
		objectKey.String(*v.ReceiptHandle)
	}

	return nil
}

func awsAwsquery_serializeDocumentDeleteMessageBatchRequestEntryList(v []types.DeleteMessageBatchRequestEntry, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentDeleteMessageBatchRequestEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMessageAttributeNameList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentMessageAttributeValue(v *types.MessageAttributeValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BinaryListValues != nil {
		objectKey := object.FlatKey("BinaryListValue")
		if err := awsAwsquery_serializeDocumentBinaryList(v.BinaryListValues, objectKey); err != nil {
			return err
		}
	}

	if v.BinaryValue != nil {
		objectKey := object.Key("BinaryValue")
		objectKey.Base64EncodeBytes(v.BinaryValue)
	}

	if v.DataType != nil {
		objectKey := object.Key("DataType")
		objectKey.String(*v.DataType)
	}

	if v.StringListValues != nil {
		objectKey := object.FlatKey("StringListValue")
		if err := awsAwsquery_serializeDocumentStringList(v.StringListValues, objectKey); err != nil {
			return err
		}
	}

	if v.StringValue != nil {
		objectKey := object.Key("StringValue")
		objectKey.String(*v.StringValue)
	}

	return nil
}

func awsAwsquery_serializeDocumentMessageBodyAttributeMap(v map[string]types.MessageAttributeValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("Name", "Value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsquery_serializeDocumentMessageAttributeValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMessageBodySystemAttributeMap(v map[string]types.MessageSystemAttributeValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("Name", "Value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsquery_serializeDocumentMessageSystemAttributeValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentMessageSystemAttributeValue(v *types.MessageSystemAttributeValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BinaryListValues != nil {
		objectKey := object.FlatKey("BinaryListValue")
		if err := awsAwsquery_serializeDocumentBinaryList(v.BinaryListValues, objectKey); err != nil {
			return err
		}
	}

	if v.BinaryValue != nil {
		objectKey := object.Key("BinaryValue")
		objectKey.Base64EncodeBytes(v.BinaryValue)
	}

	if v.DataType != nil {
		objectKey := object.Key("DataType")
		objectKey.String(*v.DataType)
	}

	if v.StringListValues != nil {
		objectKey := object.FlatKey("StringListValue")
		if err := awsAwsquery_serializeDocumentStringList(v.StringListValues, objectKey); err != nil {
			return err
		}
	}

	if v.StringValue != nil {
		objectKey := object.Key("StringValue")
		objectKey.String(*v.StringValue)
	}

	return nil
}

func awsAwsquery_serializeDocumentQueueAttributeMap(v map[string]string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("Name", "Value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsquery_serializeDocumentSendMessageBatchRequestEntry(v *types.SendMessageBatchRequestEntry, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DelaySeconds != 0 {
		objectKey := object.Key("DelaySeconds")
		objectKey.Integer(v.DelaySeconds)
	}

	if v.Id != nil {
		objectKey := object.Key("Id")
		objectKey.String(*v.Id)
	}

	if v.MessageAttributes != nil {
		objectKey := object.FlatKey("MessageAttribute")
		if err := awsAwsquery_serializeDocumentMessageBodyAttributeMap(v.MessageAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.MessageBody != nil {
		objectKey := object.Key("MessageBody")
		objectKey.String(*v.MessageBody)
	}

	if v.MessageDeduplicationId != nil {
		objectKey := object.Key("MessageDeduplicationId")
		objectKey.String(*v.MessageDeduplicationId)
	}

	if v.MessageGroupId != nil {
		objectKey := object.Key("MessageGroupId")
		objectKey.String(*v.MessageGroupId)
	}

	if v.MessageSystemAttributes != nil {
		objectKey := object.FlatKey("MessageSystemAttribute")
		if err := awsAwsquery_serializeDocumentMessageBodySystemAttributeMap(v.MessageSystemAttributes, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeDocumentSendMessageBatchRequestEntryList(v []types.SendMessageBatchRequestEntry, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		if err := awsAwsquery_serializeDocumentSendMessageBatchRequestEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsquery_serializeDocumentStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("StringListValue")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTagKeyList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsquery_serializeDocumentTagMap(v map[string]string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	object := value.Map("Key", "Value")

	keys := make([]string, 0, len(v))
	for key := range v {
		keys = append(keys, key)
	}
	sort.Strings(keys)

	for _, key := range keys {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsquery_serializeOpDocumentAddPermissionInput(v *AddPermissionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Actions != nil {
		objectKey := object.FlatKey("ActionName")
		if err := awsAwsquery_serializeDocumentActionNameList(v.Actions, objectKey); err != nil {
			return err
		}
	}

	if v.AWSAccountIds != nil {
		objectKey := object.FlatKey("AWSAccountId")
		if err := awsAwsquery_serializeDocumentAWSAccountIdList(v.AWSAccountIds, objectKey); err != nil {
			return err
		}
	}

	if v.Label != nil {
		objectKey := object.Key("Label")
		objectKey.String(*v.Label)
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentChangeMessageVisibilityBatchInput(v *ChangeMessageVisibilityBatchInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Entries != nil {
		objectKey := object.FlatKey("ChangeMessageVisibilityBatchRequestEntry")
		if err := awsAwsquery_serializeDocumentChangeMessageVisibilityBatchRequestEntryList(v.Entries, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentChangeMessageVisibilityInput(v *ChangeMessageVisibilityInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	if v.ReceiptHandle != nil {
		objectKey := object.Key("ReceiptHandle")
		objectKey.String(*v.ReceiptHandle)
	}

	{
		objectKey := object.Key("VisibilityTimeout")
		objectKey.Integer(v.VisibilityTimeout)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentCreateQueueInput(v *CreateQueueInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Attributes != nil {
		objectKey := object.FlatKey("Attribute")
		if err := awsAwsquery_serializeDocumentQueueAttributeMap(v.Attributes, objectKey); err != nil {
			return err
		}
	}

	if v.QueueName != nil {
		objectKey := object.Key("QueueName")
		objectKey.String(*v.QueueName)
	}

	if v.Tags != nil {
		objectKey := object.FlatKey("Tag")
		if err := awsAwsquery_serializeDocumentTagMap(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteMessageBatchInput(v *DeleteMessageBatchInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Entries != nil {
		objectKey := object.FlatKey("DeleteMessageBatchRequestEntry")
		if err := awsAwsquery_serializeDocumentDeleteMessageBatchRequestEntryList(v.Entries, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteMessageInput(v *DeleteMessageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	if v.ReceiptHandle != nil {
		objectKey := object.Key("ReceiptHandle")
		objectKey.String(*v.ReceiptHandle)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentDeleteQueueInput(v *DeleteQueueInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetQueueAttributesInput(v *GetQueueAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AttributeNames != nil {
		objectKey := object.FlatKey("AttributeName")
		if err := awsAwsquery_serializeDocumentAttributeNameList(v.AttributeNames, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentGetQueueUrlInput(v *GetQueueUrlInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueName != nil {
		objectKey := object.Key("QueueName")
		objectKey.String(*v.QueueName)
	}

	if v.QueueOwnerAWSAccountId != nil {
		objectKey := object.Key("QueueOwnerAWSAccountId")
		objectKey.String(*v.QueueOwnerAWSAccountId)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListDeadLetterSourceQueuesInput(v *ListDeadLetterSourceQueuesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListQueuesInput(v *ListQueuesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.MaxResults != nil {
		objectKey := object.Key("MaxResults")
		objectKey.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		objectKey := object.Key("NextToken")
		objectKey.String(*v.NextToken)
	}

	if v.QueueNamePrefix != nil {
		objectKey := object.Key("QueueNamePrefix")
		objectKey.String(*v.QueueNamePrefix)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentListQueueTagsInput(v *ListQueueTagsInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentPurgeQueueInput(v *PurgeQueueInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentReceiveMessageInput(v *ReceiveMessageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AttributeNames != nil {
		objectKey := object.FlatKey("AttributeName")
		if err := awsAwsquery_serializeDocumentAttributeNameList(v.AttributeNames, objectKey); err != nil {
			return err
		}
	}

	if v.MaxNumberOfMessages != 0 {
		objectKey := object.Key("MaxNumberOfMessages")
		objectKey.Integer(v.MaxNumberOfMessages)
	}

	if v.MessageAttributeNames != nil {
		objectKey := object.FlatKey("MessageAttributeName")
		if err := awsAwsquery_serializeDocumentMessageAttributeNameList(v.MessageAttributeNames, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	if v.ReceiveRequestAttemptId != nil {
		objectKey := object.Key("ReceiveRequestAttemptId")
		objectKey.String(*v.ReceiveRequestAttemptId)
	}

	if v.VisibilityTimeout != 0 {
		objectKey := object.Key("VisibilityTimeout")
		objectKey.Integer(v.VisibilityTimeout)
	}

	if v.WaitTimeSeconds != 0 {
		objectKey := object.Key("WaitTimeSeconds")
		objectKey.Integer(v.WaitTimeSeconds)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentRemovePermissionInput(v *RemovePermissionInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Label != nil {
		objectKey := object.Key("Label")
		objectKey.String(*v.Label)
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendMessageBatchInput(v *SendMessageBatchInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Entries != nil {
		objectKey := object.FlatKey("SendMessageBatchRequestEntry")
		if err := awsAwsquery_serializeDocumentSendMessageBatchRequestEntryList(v.Entries, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSendMessageInput(v *SendMessageInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DelaySeconds != 0 {
		objectKey := object.Key("DelaySeconds")
		objectKey.Integer(v.DelaySeconds)
	}

	if v.MessageAttributes != nil {
		objectKey := object.FlatKey("MessageAttribute")
		if err := awsAwsquery_serializeDocumentMessageBodyAttributeMap(v.MessageAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.MessageBody != nil {
		objectKey := object.Key("MessageBody")
		objectKey.String(*v.MessageBody)
	}

	if v.MessageDeduplicationId != nil {
		objectKey := object.Key("MessageDeduplicationId")
		objectKey.String(*v.MessageDeduplicationId)
	}

	if v.MessageGroupId != nil {
		objectKey := object.Key("MessageGroupId")
		objectKey.String(*v.MessageGroupId)
	}

	if v.MessageSystemAttributes != nil {
		objectKey := object.FlatKey("MessageSystemAttribute")
		if err := awsAwsquery_serializeDocumentMessageBodySystemAttributeMap(v.MessageSystemAttributes, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentSetQueueAttributesInput(v *SetQueueAttributesInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Attributes != nil {
		objectKey := object.FlatKey("Attribute")
		if err := awsAwsquery_serializeDocumentQueueAttributeMap(v.Attributes, objectKey); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	return nil
}

func awsAwsquery_serializeOpDocumentTagQueueInput(v *TagQueueInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	if v.Tags != nil {
		objectKey := object.FlatKey("Tag")
		if err := awsAwsquery_serializeDocumentTagMap(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsquery_serializeOpDocumentUntagQueueInput(v *UntagQueueInput, value query.Value) error {
	object := value.Object()
	_ = object

	if v.QueueUrl != nil {
		objectKey := object.Key("QueueUrl")
		objectKey.String(*v.QueueUrl)
	}

	if v.TagKeys != nil {
		objectKey := object.FlatKey("TagKey")
		if err := awsAwsquery_serializeDocumentTagKeyList(v.TagKeys, objectKey); err != nil {
			return err
		}
	}

	return nil
}
