// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"math"
	"strings"
)

type awsRestjson1_deserializeOpAcceptAdministratorInvitation struct {
}

func (*awsRestjson1_deserializeOpAcceptAdministratorInvitation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpAcceptAdministratorInvitation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorAcceptAdministratorInvitation(response, &metadata)
	}
	output := &AcceptAdministratorInvitationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorAcceptAdministratorInvitation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpAcceptInvitation struct {
}

func (*awsRestjson1_deserializeOpAcceptInvitation) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpAcceptInvitation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorAcceptInvitation(response, &metadata)
	}
	output := &AcceptInvitationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorAcceptInvitation(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpBatchDisableStandards struct {
}

func (*awsRestjson1_deserializeOpBatchDisableStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchDisableStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchDisableStandards(response, &metadata)
	}
	output := &BatchDisableStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchDisableStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchDisableStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchDisableStandardsOutput(v **BatchDisableStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchDisableStandardsOutput
	if *v == nil {
		sv = &BatchDisableStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsSubscriptions":
			if err := awsRestjson1_deserializeDocumentStandardsSubscriptions(&sv.StandardsSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchEnableStandards struct {
}

func (*awsRestjson1_deserializeOpBatchEnableStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchEnableStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchEnableStandards(response, &metadata)
	}
	output := &BatchEnableStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchEnableStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchEnableStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchEnableStandardsOutput(v **BatchEnableStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchEnableStandardsOutput
	if *v == nil {
		sv = &BatchEnableStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsSubscriptions":
			if err := awsRestjson1_deserializeDocumentStandardsSubscriptions(&sv.StandardsSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchImportFindings struct {
}

func (*awsRestjson1_deserializeOpBatchImportFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchImportFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchImportFindings(response, &metadata)
	}
	output := &BatchImportFindingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchImportFindingsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchImportFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchImportFindingsOutput(v **BatchImportFindingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchImportFindingsOutput
	if *v == nil {
		sv = &BatchImportFindingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FailedCount = int32(i64)
			}

		case "FailedFindings":
			if err := awsRestjson1_deserializeDocumentImportFindingsErrorList(&sv.FailedFindings, value); err != nil {
				return err
			}

		case "SuccessCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SuccessCount = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpBatchUpdateFindings struct {
}

func (*awsRestjson1_deserializeOpBatchUpdateFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpBatchUpdateFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorBatchUpdateFindings(response, &metadata)
	}
	output := &BatchUpdateFindingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentBatchUpdateFindingsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorBatchUpdateFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentBatchUpdateFindingsOutput(v **BatchUpdateFindingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchUpdateFindingsOutput
	if *v == nil {
		sv = &BatchUpdateFindingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ProcessedFindings":
			if err := awsRestjson1_deserializeDocumentAwsSecurityFindingIdentifierList(&sv.ProcessedFindings, value); err != nil {
				return err
			}

		case "UnprocessedFindings":
			if err := awsRestjson1_deserializeDocumentBatchUpdateFindingsUnprocessedFindingsList(&sv.UnprocessedFindings, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateActionTarget struct {
}

func (*awsRestjson1_deserializeOpCreateActionTarget) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateActionTarget) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateActionTarget(response, &metadata)
	}
	output := &CreateActionTargetOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateActionTargetOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateActionTarget(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateActionTargetOutput(v **CreateActionTargetOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateActionTargetOutput
	if *v == nil {
		sv = &CreateActionTargetOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionTargetArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateInsight struct {
}

func (*awsRestjson1_deserializeOpCreateInsight) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateInsight) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateInsight(response, &metadata)
	}
	output := &CreateInsightOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateInsightOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateInsight(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateInsightOutput(v **CreateInsightOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateInsightOutput
	if *v == nil {
		sv = &CreateInsightOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InsightArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InsightArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpCreateMembers struct {
}

func (*awsRestjson1_deserializeOpCreateMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpCreateMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorCreateMembers(response, &metadata)
	}
	output := &CreateMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentCreateMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorCreateMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentCreateMembersOutput(v **CreateMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateMembersOutput
	if *v == nil {
		sv = &CreateMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeclineInvitations struct {
}

func (*awsRestjson1_deserializeOpDeclineInvitations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeclineInvitations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeclineInvitations(response, &metadata)
	}
	output := &DeclineInvitationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeclineInvitationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeclineInvitations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeclineInvitationsOutput(v **DeclineInvitationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeclineInvitationsOutput
	if *v == nil {
		sv = &DeclineInvitationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteActionTarget struct {
}

func (*awsRestjson1_deserializeOpDeleteActionTarget) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteActionTarget) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteActionTarget(response, &metadata)
	}
	output := &DeleteActionTargetOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteActionTargetOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteActionTarget(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteActionTargetOutput(v **DeleteActionTargetOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteActionTargetOutput
	if *v == nil {
		sv = &DeleteActionTargetOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionTargetArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteInsight struct {
}

func (*awsRestjson1_deserializeOpDeleteInsight) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteInsight) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteInsight(response, &metadata)
	}
	output := &DeleteInsightOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteInsightOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteInsight(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteInsightOutput(v **DeleteInsightOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteInsightOutput
	if *v == nil {
		sv = &DeleteInsightOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InsightArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InsightArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteInvitations struct {
}

func (*awsRestjson1_deserializeOpDeleteInvitations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteInvitations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteInvitations(response, &metadata)
	}
	output := &DeleteInvitationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteInvitationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteInvitations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteInvitationsOutput(v **DeleteInvitationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteInvitationsOutput
	if *v == nil {
		sv = &DeleteInvitationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDeleteMembers struct {
}

func (*awsRestjson1_deserializeOpDeleteMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDeleteMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDeleteMembers(response, &metadata)
	}
	output := &DeleteMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDeleteMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDeleteMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDeleteMembersOutput(v **DeleteMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteMembersOutput
	if *v == nil {
		sv = &DeleteMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeActionTargets struct {
}

func (*awsRestjson1_deserializeOpDescribeActionTargets) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeActionTargets) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeActionTargets(response, &metadata)
	}
	output := &DescribeActionTargetsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeActionTargetsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeActionTargets(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeActionTargetsOutput(v **DescribeActionTargetsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeActionTargetsOutput
	if *v == nil {
		sv = &DescribeActionTargetsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargets":
			if err := awsRestjson1_deserializeDocumentActionTargetList(&sv.ActionTargets, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeHub struct {
}

func (*awsRestjson1_deserializeOpDescribeHub) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeHub) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeHub(response, &metadata)
	}
	output := &DescribeHubOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeHubOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeHub(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeHubOutput(v **DescribeHubOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeHubOutput
	if *v == nil {
		sv = &DescribeHubOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutoEnableControls":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoEnableControls = jtv
			}

		case "HubArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HubArn = ptr.String(jtv)
			}

		case "SubscribedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubscribedAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeOrganizationConfiguration struct {
}

func (*awsRestjson1_deserializeOpDescribeOrganizationConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeOrganizationConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeOrganizationConfiguration(response, &metadata)
	}
	output := &DescribeOrganizationConfigurationOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeOrganizationConfigurationOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeOrganizationConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeOrganizationConfigurationOutput(v **DescribeOrganizationConfigurationOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeOrganizationConfigurationOutput
	if *v == nil {
		sv = &DescribeOrganizationConfigurationOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutoEnable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoEnable = jtv
			}

		case "MemberAccountLimitReached":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MemberAccountLimitReached = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeProducts struct {
}

func (*awsRestjson1_deserializeOpDescribeProducts) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeProducts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeProducts(response, &metadata)
	}
	output := &DescribeProductsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeProductsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeProducts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeProductsOutput(v **DescribeProductsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeProductsOutput
	if *v == nil {
		sv = &DescribeProductsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "Products":
			if err := awsRestjson1_deserializeDocumentProductsList(&sv.Products, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeStandards struct {
}

func (*awsRestjson1_deserializeOpDescribeStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeStandards(response, &metadata)
	}
	output := &DescribeStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeStandardsOutput(v **DescribeStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeStandardsOutput
	if *v == nil {
		sv = &DescribeStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "Standards":
			if err := awsRestjson1_deserializeDocumentStandards(&sv.Standards, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDescribeStandardsControls struct {
}

func (*awsRestjson1_deserializeOpDescribeStandardsControls) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDescribeStandardsControls) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDescribeStandardsControls(response, &metadata)
	}
	output := &DescribeStandardsControlsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentDescribeStandardsControlsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDescribeStandardsControls(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentDescribeStandardsControlsOutput(v **DescribeStandardsControlsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeStandardsControlsOutput
	if *v == nil {
		sv = &DescribeStandardsControlsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Controls":
			if err := awsRestjson1_deserializeDocumentStandardsControls(&sv.Controls, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpDisableImportFindingsForProduct struct {
}

func (*awsRestjson1_deserializeOpDisableImportFindingsForProduct) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisableImportFindingsForProduct) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisableImportFindingsForProduct(response, &metadata)
	}
	output := &DisableImportFindingsForProductOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisableImportFindingsForProduct(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisableOrganizationAdminAccount struct {
}

func (*awsRestjson1_deserializeOpDisableOrganizationAdminAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisableOrganizationAdminAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisableOrganizationAdminAccount(response, &metadata)
	}
	output := &DisableOrganizationAdminAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisableOrganizationAdminAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisableSecurityHub struct {
}

func (*awsRestjson1_deserializeOpDisableSecurityHub) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisableSecurityHub) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisableSecurityHub(response, &metadata)
	}
	output := &DisableSecurityHubOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisableSecurityHub(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisassociateFromAdministratorAccount struct {
}

func (*awsRestjson1_deserializeOpDisassociateFromAdministratorAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisassociateFromAdministratorAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisassociateFromAdministratorAccount(response, &metadata)
	}
	output := &DisassociateFromAdministratorAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisassociateFromAdministratorAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisassociateFromMasterAccount struct {
}

func (*awsRestjson1_deserializeOpDisassociateFromMasterAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisassociateFromMasterAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisassociateFromMasterAccount(response, &metadata)
	}
	output := &DisassociateFromMasterAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisassociateFromMasterAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpDisassociateMembers struct {
}

func (*awsRestjson1_deserializeOpDisassociateMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpDisassociateMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorDisassociateMembers(response, &metadata)
	}
	output := &DisassociateMembersOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorDisassociateMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpEnableImportFindingsForProduct struct {
}

func (*awsRestjson1_deserializeOpEnableImportFindingsForProduct) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpEnableImportFindingsForProduct) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorEnableImportFindingsForProduct(response, &metadata)
	}
	output := &EnableImportFindingsForProductOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentEnableImportFindingsForProductOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorEnableImportFindingsForProduct(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentEnableImportFindingsForProductOutput(v **EnableImportFindingsForProductOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *EnableImportFindingsForProductOutput
	if *v == nil {
		sv = &EnableImportFindingsForProductOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ProductSubscriptionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductSubscriptionArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpEnableOrganizationAdminAccount struct {
}

func (*awsRestjson1_deserializeOpEnableOrganizationAdminAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpEnableOrganizationAdminAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorEnableOrganizationAdminAccount(response, &metadata)
	}
	output := &EnableOrganizationAdminAccountOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorEnableOrganizationAdminAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpEnableSecurityHub struct {
}

func (*awsRestjson1_deserializeOpEnableSecurityHub) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpEnableSecurityHub) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorEnableSecurityHub(response, &metadata)
	}
	output := &EnableSecurityHubOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorEnableSecurityHub(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("AccessDeniedException", errorCode):
		return awsRestjson1_deserializeErrorAccessDeniedException(response, errorBody)

	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceConflictException", errorCode):
		return awsRestjson1_deserializeErrorResourceConflictException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpGetAdministratorAccount struct {
}

func (*awsRestjson1_deserializeOpGetAdministratorAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetAdministratorAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetAdministratorAccount(response, &metadata)
	}
	output := &GetAdministratorAccountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetAdministratorAccountOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetAdministratorAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetAdministratorAccountOutput(v **GetAdministratorAccountOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetAdministratorAccountOutput
	if *v == nil {
		sv = &GetAdministratorAccountOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Administrator":
			if err := awsRestjson1_deserializeDocumentInvitation(&sv.Administrator, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetEnabledStandards struct {
}

func (*awsRestjson1_deserializeOpGetEnabledStandards) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetEnabledStandards) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetEnabledStandards(response, &metadata)
	}
	output := &GetEnabledStandardsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetEnabledStandardsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetEnabledStandards(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetEnabledStandardsOutput(v **GetEnabledStandardsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetEnabledStandardsOutput
	if *v == nil {
		sv = &GetEnabledStandardsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "StandardsSubscriptions":
			if err := awsRestjson1_deserializeDocumentStandardsSubscriptions(&sv.StandardsSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetFindings struct {
}

func (*awsRestjson1_deserializeOpGetFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetFindings(response, &metadata)
	}
	output := &GetFindingsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetFindingsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetFindingsOutput(v **GetFindingsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetFindingsOutput
	if *v == nil {
		sv = &GetFindingsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Findings":
			if err := awsRestjson1_deserializeDocumentAwsSecurityFindingList(&sv.Findings, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInsightResults struct {
}

func (*awsRestjson1_deserializeOpGetInsightResults) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInsightResults) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInsightResults(response, &metadata)
	}
	output := &GetInsightResultsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetInsightResultsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInsightResults(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInsightResultsOutput(v **GetInsightResultsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInsightResultsOutput
	if *v == nil {
		sv = &GetInsightResultsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InsightResults":
			if err := awsRestjson1_deserializeDocumentInsightResults(&sv.InsightResults, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInsights struct {
}

func (*awsRestjson1_deserializeOpGetInsights) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInsights) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInsights(response, &metadata)
	}
	output := &GetInsightsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetInsightsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInsights(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInsightsOutput(v **GetInsightsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInsightsOutput
	if *v == nil {
		sv = &GetInsightsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Insights":
			if err := awsRestjson1_deserializeDocumentInsightList(&sv.Insights, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetInvitationsCount struct {
}

func (*awsRestjson1_deserializeOpGetInvitationsCount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetInvitationsCount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetInvitationsCount(response, &metadata)
	}
	output := &GetInvitationsCountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetInvitationsCountOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetInvitationsCount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetInvitationsCountOutput(v **GetInvitationsCountOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetInvitationsCountOutput
	if *v == nil {
		sv = &GetInvitationsCountOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InvitationsCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InvitationsCount = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetMasterAccount struct {
}

func (*awsRestjson1_deserializeOpGetMasterAccount) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetMasterAccount) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetMasterAccount(response, &metadata)
	}
	output := &GetMasterAccountOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetMasterAccountOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetMasterAccount(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetMasterAccountOutput(v **GetMasterAccountOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMasterAccountOutput
	if *v == nil {
		sv = &GetMasterAccountOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Master":
			if err := awsRestjson1_deserializeDocumentInvitation(&sv.Master, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpGetMembers struct {
}

func (*awsRestjson1_deserializeOpGetMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpGetMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorGetMembers(response, &metadata)
	}
	output := &GetMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentGetMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorGetMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentGetMembersOutput(v **GetMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMembersOutput
	if *v == nil {
		sv = &GetMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Members":
			if err := awsRestjson1_deserializeDocumentMemberList(&sv.Members, value); err != nil {
				return err
			}

		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpInviteMembers struct {
}

func (*awsRestjson1_deserializeOpInviteMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpInviteMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorInviteMembers(response, &metadata)
	}
	output := &InviteMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentInviteMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorInviteMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentInviteMembersOutput(v **InviteMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *InviteMembersOutput
	if *v == nil {
		sv = &InviteMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "UnprocessedAccounts":
			if err := awsRestjson1_deserializeDocumentResultList(&sv.UnprocessedAccounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListEnabledProductsForImport struct {
}

func (*awsRestjson1_deserializeOpListEnabledProductsForImport) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListEnabledProductsForImport) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListEnabledProductsForImport(response, &metadata)
	}
	output := &ListEnabledProductsForImportOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListEnabledProductsForImportOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListEnabledProductsForImport(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListEnabledProductsForImportOutput(v **ListEnabledProductsForImportOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListEnabledProductsForImportOutput
	if *v == nil {
		sv = &ListEnabledProductsForImportOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "ProductSubscriptions":
			if err := awsRestjson1_deserializeDocumentProductSubscriptionArnList(&sv.ProductSubscriptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListInvitations struct {
}

func (*awsRestjson1_deserializeOpListInvitations) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListInvitations) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListInvitations(response, &metadata)
	}
	output := &ListInvitationsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListInvitationsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListInvitations(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListInvitationsOutput(v **ListInvitationsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListInvitationsOutput
	if *v == nil {
		sv = &ListInvitationsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Invitations":
			if err := awsRestjson1_deserializeDocumentInvitationList(&sv.Invitations, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListMembers struct {
}

func (*awsRestjson1_deserializeOpListMembers) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListMembers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListMembers(response, &metadata)
	}
	output := &ListMembersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListMembersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListMembers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListMembersOutput(v **ListMembersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListMembersOutput
	if *v == nil {
		sv = &ListMembersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Members":
			if err := awsRestjson1_deserializeDocumentMemberList(&sv.Members, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListOrganizationAdminAccounts struct {
}

func (*awsRestjson1_deserializeOpListOrganizationAdminAccounts) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListOrganizationAdminAccounts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListOrganizationAdminAccounts(response, &metadata)
	}
	output := &ListOrganizationAdminAccountsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListOrganizationAdminAccountsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListOrganizationAdminAccounts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListOrganizationAdminAccountsOutput(v **ListOrganizationAdminAccountsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListOrganizationAdminAccountsOutput
	if *v == nil {
		sv = &ListOrganizationAdminAccountsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AdminAccounts":
			if err := awsRestjson1_deserializeDocumentAdminAccounts(&sv.AdminAccounts, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpListTagsForResource struct {
}

func (*awsRestjson1_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)

	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsRestjson1_deserializeOpDocumentListTagsForResourceOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		return out, metadata, &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body with invalid JSON, %w", err),
			Snapshot: snapshot.Bytes(),
		}
	}

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Tags":
			if err := awsRestjson1_deserializeDocumentTagMap(&sv.Tags, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type awsRestjson1_deserializeOpTagResource struct {
}

func (*awsRestjson1_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorTagResource(response, &metadata)
	}
	output := &TagResourceOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorTagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUntagResource struct {
}

func (*awsRestjson1_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUntagResource(response, &metadata)
	}
	output := &UntagResourceOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUntagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateActionTarget struct {
}

func (*awsRestjson1_deserializeOpUpdateActionTarget) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateActionTarget) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateActionTarget(response, &metadata)
	}
	output := &UpdateActionTargetOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateActionTarget(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateFindings struct {
}

func (*awsRestjson1_deserializeOpUpdateFindings) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateFindings) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateFindings(response, &metadata)
	}
	output := &UpdateFindingsOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateFindings(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateInsight struct {
}

func (*awsRestjson1_deserializeOpUpdateInsight) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateInsight) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateInsight(response, &metadata)
	}
	output := &UpdateInsightOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateInsight(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateOrganizationConfiguration struct {
}

func (*awsRestjson1_deserializeOpUpdateOrganizationConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateOrganizationConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateOrganizationConfiguration(response, &metadata)
	}
	output := &UpdateOrganizationConfigurationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateOrganizationConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateSecurityHubConfiguration struct {
}

func (*awsRestjson1_deserializeOpUpdateSecurityHubConfiguration) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateSecurityHubConfiguration) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateSecurityHubConfiguration(response, &metadata)
	}
	output := &UpdateSecurityHubConfigurationOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateSecurityHubConfiguration(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("LimitExceededException", errorCode):
		return awsRestjson1_deserializeErrorLimitExceededException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsRestjson1_deserializeOpUpdateStandardsControl struct {
}

func (*awsRestjson1_deserializeOpUpdateStandardsControl) ID() string {
	return "OperationDeserializer"
}

func (m *awsRestjson1_deserializeOpUpdateStandardsControl) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsRestjson1_deserializeOpErrorUpdateStandardsControl(response, &metadata)
	}
	output := &UpdateStandardsControlOutput{}
	out.Result = output

	return out, metadata, err
}

func awsRestjson1_deserializeOpErrorUpdateStandardsControl(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	code := response.Header.Get("X-Amzn-ErrorType")
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	code, message, err := restjson.GetErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if len(code) != 0 {
		errorCode = restjson.SanitizeErrorCode(code)
	}
	if len(message) != 0 {
		errorMessage = message
	}

	switch {
	case strings.EqualFold("InternalException", errorCode):
		return awsRestjson1_deserializeErrorInternalException(response, errorBody)

	case strings.EqualFold("InvalidAccessException", errorCode):
		return awsRestjson1_deserializeErrorInvalidAccessException(response, errorBody)

	case strings.EqualFold("InvalidInputException", errorCode):
		return awsRestjson1_deserializeErrorInvalidInputException(response, errorBody)

	case strings.EqualFold("ResourceNotFoundException", errorCode):
		return awsRestjson1_deserializeErrorResourceNotFoundException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsRestjson1_deserializeErrorAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.AccessDeniedException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentAccessDeniedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInternalException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InternalException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInternalException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInvalidAccessException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidAccessException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInvalidAccessException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorInvalidInputException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.InvalidInputException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentInvalidInputException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.LimitExceededException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorResourceConflictException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceConflictException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentResourceConflictException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeErrorResourceNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	output := &types.ResourceNotFoundException{}
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	err := awsRestjson1_deserializeDocumentResourceNotFoundException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)

	return output
}

func awsRestjson1_deserializeDocumentAccessDeniedException(v **types.AccessDeniedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AccessDeniedException
	if *v == nil {
		sv = &types.AccessDeniedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAction(v **types.Action, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Action
	if *v == nil {
		sv = &types.Action{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionType = ptr.String(jtv)
			}

		case "AwsApiCallAction":
			if err := awsRestjson1_deserializeDocumentAwsApiCallAction(&sv.AwsApiCallAction, value); err != nil {
				return err
			}

		case "DnsRequestAction":
			if err := awsRestjson1_deserializeDocumentDnsRequestAction(&sv.DnsRequestAction, value); err != nil {
				return err
			}

		case "NetworkConnectionAction":
			if err := awsRestjson1_deserializeDocumentNetworkConnectionAction(&sv.NetworkConnectionAction, value); err != nil {
				return err
			}

		case "PortProbeAction":
			if err := awsRestjson1_deserializeDocumentPortProbeAction(&sv.PortProbeAction, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionLocalIpDetails(v **types.ActionLocalIpDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionLocalIpDetails
	if *v == nil {
		sv = &types.ActionLocalIpDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IpAddressV4":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddressV4 = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionLocalPortDetails(v **types.ActionLocalPortDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionLocalPortDetails
	if *v == nil {
		sv = &types.ActionLocalPortDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "PortName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PortName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionRemoteIpDetails(v **types.ActionRemoteIpDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionRemoteIpDetails
	if *v == nil {
		sv = &types.ActionRemoteIpDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "City":
			if err := awsRestjson1_deserializeDocumentCity(&sv.City, value); err != nil {
				return err
			}

		case "Country":
			if err := awsRestjson1_deserializeDocumentCountry(&sv.Country, value); err != nil {
				return err
			}

		case "GeoLocation":
			if err := awsRestjson1_deserializeDocumentGeoLocation(&sv.GeoLocation, value); err != nil {
				return err
			}

		case "IpAddressV4":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddressV4 = ptr.String(jtv)
			}

		case "Organization":
			if err := awsRestjson1_deserializeDocumentIpOrganizationDetails(&sv.Organization, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionRemotePortDetails(v **types.ActionRemotePortDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionRemotePortDetails
	if *v == nil {
		sv = &types.ActionRemotePortDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "PortName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PortName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionTarget(v **types.ActionTarget, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActionTarget
	if *v == nil {
		sv = &types.ActionTarget{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActionTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActionTargetArn = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentActionTargetList(v *[]types.ActionTarget, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ActionTarget
	if *v == nil {
		cv = []types.ActionTarget{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ActionTarget
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentActionTarget(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAdjustment(v **types.Adjustment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Adjustment
	if *v == nil {
		sv = &types.Adjustment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Metric":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Metric = ptr.String(jtv)
			}

		case "Reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAdjustmentList(v *[]types.Adjustment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Adjustment
	if *v == nil {
		cv = []types.Adjustment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Adjustment
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAdjustment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAdminAccount(v **types.AdminAccount, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AdminAccount
	if *v == nil {
		sv = &types.AdminAccount{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AdminStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.AdminStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAdminAccounts(v *[]types.AdminAccount, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AdminAccount
	if *v == nil {
		cv = []types.AdminAccount{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AdminAccount
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAdminAccount(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAvailabilityZone(v **types.AvailabilityZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AvailabilityZone
	if *v == nil {
		sv = &types.AvailabilityZone{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		case "ZoneName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ZoneName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAvailabilityZones(v *[]types.AvailabilityZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AvailabilityZone
	if *v == nil {
		cv = []types.AvailabilityZone{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AvailabilityZone
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAvailabilityZone(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiCallAction(v **types.AwsApiCallAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiCallAction
	if *v == nil {
		sv = &types.AwsApiCallAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AffectedResources":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.AffectedResources, value); err != nil {
				return err
			}

		case "Api":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Api = ptr.String(jtv)
			}

		case "CallerType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CallerType = ptr.String(jtv)
			}

		case "DomainDetails":
			if err := awsRestjson1_deserializeDocumentAwsApiCallActionDomainDetails(&sv.DomainDetails, value); err != nil {
				return err
			}

		case "FirstSeen":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FirstSeen = ptr.String(jtv)
			}

		case "LastSeen":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastSeen = ptr.String(jtv)
			}

		case "RemoteIpDetails":
			if err := awsRestjson1_deserializeDocumentActionRemoteIpDetails(&sv.RemoteIpDetails, value); err != nil {
				return err
			}

		case "ServiceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiCallActionDomainDetails(v **types.AwsApiCallActionDomainDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiCallActionDomainDetails
	if *v == nil {
		sv = &types.AwsApiCallActionDomainDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Domain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Domain = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayAccessLogSettings(v **types.AwsApiGatewayAccessLogSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayAccessLogSettings
	if *v == nil {
		sv = &types.AwsApiGatewayAccessLogSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationArn = ptr.String(jtv)
			}

		case "Format":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Format = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayCanarySettings(v **types.AwsApiGatewayCanarySettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayCanarySettings
	if *v == nil {
		sv = &types.AwsApiGatewayCanarySettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeploymentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentId = ptr.String(jtv)
			}

		case "PercentTraffic":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.PercentTraffic = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.PercentTraffic = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "StageVariableOverrides":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.StageVariableOverrides, value); err != nil {
				return err
			}

		case "UseStageCache":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.UseStageCache = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayEndpointConfiguration(v **types.AwsApiGatewayEndpointConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayEndpointConfiguration
	if *v == nil {
		sv = &types.AwsApiGatewayEndpointConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Types":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Types, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettings(v **types.AwsApiGatewayMethodSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayMethodSettings
	if *v == nil {
		sv = &types.AwsApiGatewayMethodSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CacheDataEncrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CacheDataEncrypted = jtv
			}

		case "CacheTtlInSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CacheTtlInSeconds = int32(i64)
			}

		case "CachingEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CachingEnabled = jtv
			}

		case "DataTraceEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DataTraceEnabled = jtv
			}

		case "HttpMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpMethod = ptr.String(jtv)
			}

		case "LoggingLevel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoggingLevel = ptr.String(jtv)
			}

		case "MetricsEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MetricsEnabled = jtv
			}

		case "RequireAuthorizationForCacheControl":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RequireAuthorizationForCacheControl = jtv
			}

		case "ResourcePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourcePath = ptr.String(jtv)
			}

		case "ThrottlingBurstLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ThrottlingBurstLimit = int32(i64)
			}

		case "ThrottlingRateLimit":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.ThrottlingRateLimit = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.ThrottlingRateLimit = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "UnauthorizedCacheControlHeaderStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UnauthorizedCacheControlHeaderStrategy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettingsList(v *[]types.AwsApiGatewayMethodSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsApiGatewayMethodSettings
	if *v == nil {
		cv = []types.AwsApiGatewayMethodSettings{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsApiGatewayMethodSettings
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettings(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayRestApiDetails(v **types.AwsApiGatewayRestApiDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayRestApiDetails
	if *v == nil {
		sv = &types.AwsApiGatewayRestApiDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApiKeySource":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiKeySource = ptr.String(jtv)
			}

		case "BinaryMediaTypes":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.BinaryMediaTypes, value); err != nil {
				return err
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EndpointConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayEndpointConfiguration(&sv.EndpointConfiguration, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "MinimumCompressionSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MinimumCompressionSize = int32(i64)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayStageDetails(v **types.AwsApiGatewayStageDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayStageDetails
	if *v == nil {
		sv = &types.AwsApiGatewayStageDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessLogSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayAccessLogSettings(&sv.AccessLogSettings, value); err != nil {
				return err
			}

		case "CacheClusterEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CacheClusterEnabled = jtv
			}

		case "CacheClusterSize":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CacheClusterSize = ptr.String(jtv)
			}

		case "CacheClusterStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CacheClusterStatus = ptr.String(jtv)
			}

		case "CanarySettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayCanarySettings(&sv.CanarySettings, value); err != nil {
				return err
			}

		case "ClientCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientCertificateId = ptr.String(jtv)
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "DeploymentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentId = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DocumentationVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DocumentationVersion = ptr.String(jtv)
			}

		case "LastUpdatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdatedDate = ptr.String(jtv)
			}

		case "MethodSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayMethodSettingsList(&sv.MethodSettings, value); err != nil {
				return err
			}

		case "StageName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StageName = ptr.String(jtv)
			}

		case "TracingEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.TracingEnabled = jtv
			}

		case "Variables":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Variables, value); err != nil {
				return err
			}

		case "WebAclArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WebAclArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayV2ApiDetails(v **types.AwsApiGatewayV2ApiDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayV2ApiDetails
	if *v == nil {
		sv = &types.AwsApiGatewayV2ApiDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApiEndpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiEndpoint = ptr.String(jtv)
			}

		case "ApiId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiId = ptr.String(jtv)
			}

		case "ApiKeySelectionExpression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApiKeySelectionExpression = ptr.String(jtv)
			}

		case "CorsConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsCorsConfiguration(&sv.CorsConfiguration, value); err != nil {
				return err
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ProtocolType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProtocolType = ptr.String(jtv)
			}

		case "RouteSelectionExpression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RouteSelectionExpression = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayV2RouteSettings(v **types.AwsApiGatewayV2RouteSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayV2RouteSettings
	if *v == nil {
		sv = &types.AwsApiGatewayV2RouteSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DataTraceEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DataTraceEnabled = jtv
			}

		case "DetailedMetricsEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DetailedMetricsEnabled = jtv
			}

		case "LoggingLevel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoggingLevel = ptr.String(jtv)
			}

		case "ThrottlingBurstLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ThrottlingBurstLimit = int32(i64)
			}

		case "ThrottlingRateLimit":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.ThrottlingRateLimit = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.ThrottlingRateLimit = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsApiGatewayV2StageDetails(v **types.AwsApiGatewayV2StageDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsApiGatewayV2StageDetails
	if *v == nil {
		sv = &types.AwsApiGatewayV2StageDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessLogSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayAccessLogSettings(&sv.AccessLogSettings, value); err != nil {
				return err
			}

		case "ApiGatewayManaged":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ApiGatewayManaged = jtv
			}

		case "AutoDeploy":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoDeploy = jtv
			}

		case "ClientCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClientCertificateId = ptr.String(jtv)
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "DefaultRouteSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayV2RouteSettings(&sv.DefaultRouteSettings, value); err != nil {
				return err
			}

		case "DeploymentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeploymentId = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "LastDeploymentStatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastDeploymentStatusMessage = ptr.String(jtv)
			}

		case "LastUpdatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdatedDate = ptr.String(jtv)
			}

		case "RouteSettings":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayV2RouteSettings(&sv.RouteSettings, value); err != nil {
				return err
			}

		case "StageName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StageName = ptr.String(jtv)
			}

		case "StageVariables":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.StageVariables, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupDetails(v **types.AwsAutoScalingAutoScalingGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingAutoScalingGroupDetails
	if *v == nil {
		sv = &types.AwsAutoScalingAutoScalingGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "HealthCheckGracePeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HealthCheckGracePeriod = int32(i64)
			}

		case "HealthCheckType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HealthCheckType = ptr.String(jtv)
			}

		case "LaunchConfigurationName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchConfigurationName = ptr.String(jtv)
			}

		case "LoadBalancerNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.LoadBalancerNames, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(v **types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeviceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceName = ptr.String(jtv)
			}

		case "Ebs":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(&sv.Ebs, value); err != nil {
				return err
			}

		case "NoDevice":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.NoDevice = jtv
			}

		case "VirtualName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VirtualName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(v **types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = jtv
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = jtv
			}

		case "Iops":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Iops = int32(i64)
			}

		case "SnapshotId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotId = ptr.String(jtv)
			}

		case "VolumeSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.VolumeSize = int32(i64)
			}

		case "VolumeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VolumeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsList(v *[]types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
	if *v == nil {
		cv = []types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationDetails(v **types.AwsAutoScalingLaunchConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociatePublicIpAddress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AssociatePublicIpAddress = jtv
			}

		case "BlockDeviceMappings":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationBlockDeviceMappingsList(&sv.BlockDeviceMappings, value); err != nil {
				return err
			}

		case "ClassicLinkVpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClassicLinkVpcId = ptr.String(jtv)
			}

		case "ClassicLinkVpcSecurityGroups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ClassicLinkVpcSecurityGroups, value); err != nil {
				return err
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "EbsOptimized":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EbsOptimized = jtv
			}

		case "IamInstanceProfile":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamInstanceProfile = ptr.String(jtv)
			}

		case "ImageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageId = ptr.String(jtv)
			}

		case "InstanceMonitoring":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(&sv.InstanceMonitoring, value); err != nil {
				return err
			}

		case "InstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "KernelId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KernelId = ptr.String(jtv)
			}

		case "KeyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyName = ptr.String(jtv)
			}

		case "LaunchConfigurationName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchConfigurationName = ptr.String(jtv)
			}

		case "PlacementTenancy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PlacementTenancy = ptr.String(jtv)
			}

		case "RamdiskId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RamdiskId = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "SpotPrice":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SpotPrice = ptr.String(jtv)
			}

		case "UserData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserData = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationInstanceMonitoringDetails(v **types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails
	if *v == nil {
		sv = &types.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDetails(v **types.AwsCertificateManagerCertificateDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateDetails
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CertificateAuthorityArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateAuthorityArn = ptr.String(jtv)
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "DomainValidationOptions":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(&sv.DomainValidationOptions, value); err != nil {
				return err
			}

		case "ExtendedKeyUsages":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsages(&sv.ExtendedKeyUsages, value); err != nil {
				return err
			}

		case "FailureReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FailureReason = ptr.String(jtv)
			}

		case "ImportedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImportedAt = ptr.String(jtv)
			}

		case "InUseBy":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.InUseBy, value); err != nil {
				return err
			}

		case "IssuedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IssuedAt = ptr.String(jtv)
			}

		case "Issuer":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Issuer = ptr.String(jtv)
			}

		case "KeyAlgorithm":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyAlgorithm = ptr.String(jtv)
			}

		case "KeyUsages":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsages(&sv.KeyUsages, value); err != nil {
				return err
			}

		case "NotAfter":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NotAfter = ptr.String(jtv)
			}

		case "NotBefore":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NotBefore = ptr.String(jtv)
			}

		case "Options":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateOptions(&sv.Options, value); err != nil {
				return err
			}

		case "RenewalEligibility":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RenewalEligibility = ptr.String(jtv)
			}

		case "RenewalSummary":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateRenewalSummary(&sv.RenewalSummary, value); err != nil {
				return err
			}

		case "Serial":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Serial = ptr.String(jtv)
			}

		case "SignatureAlgorithm":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SignatureAlgorithm = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "Subject":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Subject = ptr.String(jtv)
			}

		case "SubjectAlternativeNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SubjectAlternativeNames, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOption(v **types.AwsCertificateManagerCertificateDomainValidationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateDomainValidationOption
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateDomainValidationOption{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "ResourceRecord":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateResourceRecord(&sv.ResourceRecord, value); err != nil {
				return err
			}

		case "ValidationDomain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidationDomain = ptr.String(jtv)
			}

		case "ValidationEmails":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.ValidationEmails, value); err != nil {
				return err
			}

		case "ValidationMethod":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidationMethod = ptr.String(jtv)
			}

		case "ValidationStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValidationStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(v *[]types.AwsCertificateManagerCertificateDomainValidationOption, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCertificateManagerCertificateDomainValidationOption
	if *v == nil {
		cv = []types.AwsCertificateManagerCertificateDomainValidationOption{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCertificateManagerCertificateDomainValidationOption
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOption(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsage(v **types.AwsCertificateManagerCertificateExtendedKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateExtendedKeyUsage
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateExtendedKeyUsage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "OId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsages(v *[]types.AwsCertificateManagerCertificateExtendedKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCertificateManagerCertificateExtendedKeyUsage
	if *v == nil {
		cv = []types.AwsCertificateManagerCertificateExtendedKeyUsage{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCertificateManagerCertificateExtendedKeyUsage
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateExtendedKeyUsage(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsage(v **types.AwsCertificateManagerCertificateKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateKeyUsage
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateKeyUsage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsages(v *[]types.AwsCertificateManagerCertificateKeyUsage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCertificateManagerCertificateKeyUsage
	if *v == nil {
		cv = []types.AwsCertificateManagerCertificateKeyUsage{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCertificateManagerCertificateKeyUsage
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateKeyUsage(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateOptions(v **types.AwsCertificateManagerCertificateOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateOptions
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CertificateTransparencyLoggingPreference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateTransparencyLoggingPreference = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateRenewalSummary(v **types.AwsCertificateManagerCertificateRenewalSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateRenewalSummary
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateRenewalSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DomainValidationOptions":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDomainValidationOptions(&sv.DomainValidationOptions, value); err != nil {
				return err
			}

		case "RenewalStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RenewalStatus = ptr.String(jtv)
			}

		case "RenewalStatusReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RenewalStatusReason = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdatedAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateResourceRecord(v **types.AwsCertificateManagerCertificateResourceRecord, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCertificateManagerCertificateResourceRecord
	if *v == nil {
		sv = &types.AwsCertificateManagerCertificateResourceRecord{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehavior(v **types.AwsCloudFrontDistributionCacheBehavior, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionCacheBehavior
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionCacheBehavior{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ViewerProtocolPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ViewerProtocolPolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviors(v **types.AwsCloudFrontDistributionCacheBehaviors, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionCacheBehaviors
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionCacheBehaviors{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviorsItemList(&sv.Items, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviorsItemList(v *[]types.AwsCloudFrontDistributionCacheBehavior, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFrontDistributionCacheBehavior
	if *v == nil {
		cv = []types.AwsCloudFrontDistributionCacheBehavior{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFrontDistributionCacheBehavior
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehavior(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDefaultCacheBehavior(v **types.AwsCloudFrontDistributionDefaultCacheBehavior, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionDefaultCacheBehavior
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionDefaultCacheBehavior{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ViewerProtocolPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ViewerProtocolPolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDetails(v **types.AwsCloudFrontDistributionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionDetails
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CacheBehaviors":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionCacheBehaviors(&sv.CacheBehaviors, value); err != nil {
				return err
			}

		case "DefaultCacheBehavior":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDefaultCacheBehavior(&sv.DefaultCacheBehavior, value); err != nil {
				return err
			}

		case "DefaultRootObject":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultRootObject = ptr.String(jtv)
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "ETag":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ETag = ptr.String(jtv)
			}

		case "LastModifiedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastModifiedTime = ptr.String(jtv)
			}

		case "Logging":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionLogging(&sv.Logging, value); err != nil {
				return err
			}

		case "OriginGroups":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroups(&sv.OriginGroups, value); err != nil {
				return err
			}

		case "Origins":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOrigins(&sv.Origins, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "WebAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WebAclId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionLogging(v **types.AwsCloudFrontDistributionLogging, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionLogging
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionLogging{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Bucket":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Bucket = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "IncludeCookies":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IncludeCookies = jtv
			}

		case "Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Prefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroup(v **types.AwsCloudFrontDistributionOriginGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroup
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailoverCriteria":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailover(&sv.FailoverCriteria, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailover(v **types.AwsCloudFrontDistributionOriginGroupFailover, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroupFailover
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroupFailover{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StatusCodes":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodes(&sv.StatusCodes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodes(v **types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList(&sv.Items, value); err != nil {
				return err
			}

		case "Quantity":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Quantity = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupFailoverStatusCodesItemList(v *[]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []int32
	if *v == nil {
		cv = []int32{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			col = int32(i64)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroups(v **types.AwsCloudFrontDistributionOriginGroups, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginGroups
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginGroups{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupsItemList(&sv.Items, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroupsItemList(v *[]types.AwsCloudFrontDistributionOriginGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFrontDistributionOriginGroup
	if *v == nil {
		cv = []types.AwsCloudFrontDistributionOriginGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFrontDistributionOriginGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItem(v **types.AwsCloudFrontDistributionOriginItem, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginItem
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginItem{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "OriginPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OriginPath = ptr.String(jtv)
			}

		case "S3OriginConfig":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginS3OriginConfig(&sv.S3OriginConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItemList(v *[]types.AwsCloudFrontDistributionOriginItem, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsCloudFrontDistributionOriginItem
	if *v == nil {
		cv = []types.AwsCloudFrontDistributionOriginItem{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsCloudFrontDistributionOriginItem
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItem(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOrigins(v **types.AwsCloudFrontDistributionOrigins, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOrigins
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOrigins{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Items":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginItemList(&sv.Items, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudFrontDistributionOriginS3OriginConfig(v **types.AwsCloudFrontDistributionOriginS3OriginConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudFrontDistributionOriginS3OriginConfig
	if *v == nil {
		sv = &types.AwsCloudFrontDistributionOriginS3OriginConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "OriginAccessIdentity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OriginAccessIdentity = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCloudTrailTrailDetails(v **types.AwsCloudTrailTrailDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCloudTrailTrailDetails
	if *v == nil {
		sv = &types.AwsCloudTrailTrailDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchLogsLogGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsLogGroupArn = ptr.String(jtv)
			}

		case "CloudWatchLogsRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsRoleArn = ptr.String(jtv)
			}

		case "HasCustomEventSelectors":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.HasCustomEventSelectors = jtv
			}

		case "HomeRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HomeRegion = ptr.String(jtv)
			}

		case "IncludeGlobalServiceEvents":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IncludeGlobalServiceEvents = jtv
			}

		case "IsMultiRegionTrail":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsMultiRegionTrail = jtv
			}

		case "IsOrganizationTrail":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsOrganizationTrail = jtv
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LogFileValidationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.LogFileValidationEnabled = jtv
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "S3BucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketName = ptr.String(jtv)
			}

		case "S3KeyPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3KeyPrefix = ptr.String(jtv)
			}

		case "SnsTopicArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnsTopicArn = ptr.String(jtv)
			}

		case "SnsTopicName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnsTopicName = ptr.String(jtv)
			}

		case "TrailArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TrailArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectDetails(v **types.AwsCodeBuildProjectDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectDetails
	if *v == nil {
		sv = &types.AwsCodeBuildProjectDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EncryptionKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EncryptionKey = ptr.String(jtv)
			}

		case "Environment":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironment(&sv.Environment, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ServiceRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceRole = ptr.String(jtv)
			}

		case "Source":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectSource(&sv.Source, value); err != nil {
				return err
			}

		case "VpcConfig":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectVpcConfig(&sv.VpcConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironment(v **types.AwsCodeBuildProjectEnvironment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectEnvironment
	if *v == nil {
		sv = &types.AwsCodeBuildProjectEnvironment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Certificate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Certificate = ptr.String(jtv)
			}

		case "ImagePullCredentialsType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImagePullCredentialsType = ptr.String(jtv)
			}

		case "RegistryCredential":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentRegistryCredential(&sv.RegistryCredential, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectEnvironmentRegistryCredential(v **types.AwsCodeBuildProjectEnvironmentRegistryCredential, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectEnvironmentRegistryCredential
	if *v == nil {
		sv = &types.AwsCodeBuildProjectEnvironmentRegistryCredential{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Credential":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Credential = ptr.String(jtv)
			}

		case "CredentialProvider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CredentialProvider = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectSource(v **types.AwsCodeBuildProjectSource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectSource
	if *v == nil {
		sv = &types.AwsCodeBuildProjectSource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GitCloneDepth":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.GitCloneDepth = int32(i64)
			}

		case "InsecureSsl":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.InsecureSsl = jtv
			}

		case "Location":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Location = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCodeBuildProjectVpcConfig(v **types.AwsCodeBuildProjectVpcConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCodeBuildProjectVpcConfig
	if *v == nil {
		sv = &types.AwsCodeBuildProjectVpcConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SecurityGroupIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIds, value); err != nil {
				return err
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Subnets, value); err != nil {
				return err
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsCorsConfiguration(v **types.AwsCorsConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsCorsConfiguration
	if *v == nil {
		sv = &types.AwsCorsConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllowCredentials":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AllowCredentials = jtv
			}

		case "AllowHeaders":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AllowHeaders, value); err != nil {
				return err
			}

		case "AllowMethods":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AllowMethods, value); err != nil {
				return err
			}

		case "AllowOrigins":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AllowOrigins, value); err != nil {
				return err
			}

		case "ExposeHeaders":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ExposeHeaders, value); err != nil {
				return err
			}

		case "MaxAge":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxAge = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinition(v **types.AwsDynamoDbTableAttributeDefinition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableAttributeDefinition
	if *v == nil {
		sv = &types.AwsDynamoDbTableAttributeDefinition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttributeName = ptr.String(jtv)
			}

		case "AttributeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttributeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinitionList(v *[]types.AwsDynamoDbTableAttributeDefinition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableAttributeDefinition
	if *v == nil {
		cv = []types.AwsDynamoDbTableAttributeDefinition{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableAttributeDefinition
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinition(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableBillingModeSummary(v **types.AwsDynamoDbTableBillingModeSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableBillingModeSummary
	if *v == nil {
		sv = &types.AwsDynamoDbTableBillingModeSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BillingMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BillingMode = ptr.String(jtv)
			}

		case "LastUpdateToPayPerRequestDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastUpdateToPayPerRequestDateTime = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableDetails(v **types.AwsDynamoDbTableDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableDetails
	if *v == nil {
		sv = &types.AwsDynamoDbTableDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeDefinitions":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableAttributeDefinitionList(&sv.AttributeDefinitions, value); err != nil {
				return err
			}

		case "BillingModeSummary":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableBillingModeSummary(&sv.BillingModeSummary, value); err != nil {
				return err
			}

		case "CreationDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreationDateTime = ptr.String(jtv)
			}

		case "GlobalSecondaryIndexes":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndexList(&sv.GlobalSecondaryIndexes, value); err != nil {
				return err
			}

		case "GlobalTableVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GlobalTableVersion = ptr.String(jtv)
			}

		case "ItemCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ItemCount = int32(i64)
			}

		case "KeySchema":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(&sv.KeySchema, value); err != nil {
				return err
			}

		case "LatestStreamArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LatestStreamArn = ptr.String(jtv)
			}

		case "LatestStreamLabel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LatestStreamLabel = ptr.String(jtv)
			}

		case "LocalSecondaryIndexes":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndexList(&sv.LocalSecondaryIndexes, value); err != nil {
				return err
			}

		case "ProvisionedThroughput":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughput(&sv.ProvisionedThroughput, value); err != nil {
				return err
			}

		case "Replicas":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaList(&sv.Replicas, value); err != nil {
				return err
			}

		case "RestoreSummary":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableRestoreSummary(&sv.RestoreSummary, value); err != nil {
				return err
			}

		case "SseDescription":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableSseDescription(&sv.SseDescription, value); err != nil {
				return err
			}

		case "StreamSpecification":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableStreamSpecification(&sv.StreamSpecification, value); err != nil {
				return err
			}

		case "TableId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableId = ptr.String(jtv)
			}

		case "TableName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableName = ptr.String(jtv)
			}

		case "TableSizeBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected SizeBytes to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TableSizeBytes = i64
			}

		case "TableStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TableStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndex(v **types.AwsDynamoDbTableGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableGlobalSecondaryIndex
	if *v == nil {
		sv = &types.AwsDynamoDbTableGlobalSecondaryIndex{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Backfilling":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Backfilling = jtv
			}

		case "IndexArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexArn = ptr.String(jtv)
			}

		case "IndexName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexName = ptr.String(jtv)
			}

		case "IndexSizeBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected SizeBytes to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.IndexSizeBytes = i64
			}

		case "IndexStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexStatus = ptr.String(jtv)
			}

		case "ItemCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ItemCount = int32(i64)
			}

		case "KeySchema":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(&sv.KeySchema, value); err != nil {
				return err
			}

		case "Projection":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProjection(&sv.Projection, value); err != nil {
				return err
			}

		case "ProvisionedThroughput":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughput(&sv.ProvisionedThroughput, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndexList(v *[]types.AwsDynamoDbTableGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableGlobalSecondaryIndex
	if *v == nil {
		cv = []types.AwsDynamoDbTableGlobalSecondaryIndex{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableGlobalSecondaryIndex
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableGlobalSecondaryIndex(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchema(v **types.AwsDynamoDbTableKeySchema, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableKeySchema
	if *v == nil {
		sv = &types.AwsDynamoDbTableKeySchema{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttributeName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttributeName = ptr.String(jtv)
			}

		case "KeyType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(v *[]types.AwsDynamoDbTableKeySchema, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableKeySchema
	if *v == nil {
		cv = []types.AwsDynamoDbTableKeySchema{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableKeySchema
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchema(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndex(v **types.AwsDynamoDbTableLocalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableLocalSecondaryIndex
	if *v == nil {
		sv = &types.AwsDynamoDbTableLocalSecondaryIndex{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IndexArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexArn = ptr.String(jtv)
			}

		case "IndexName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexName = ptr.String(jtv)
			}

		case "KeySchema":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableKeySchemaList(&sv.KeySchema, value); err != nil {
				return err
			}

		case "Projection":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProjection(&sv.Projection, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndexList(v *[]types.AwsDynamoDbTableLocalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableLocalSecondaryIndex
	if *v == nil {
		cv = []types.AwsDynamoDbTableLocalSecondaryIndex{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableLocalSecondaryIndex
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableLocalSecondaryIndex(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableProjection(v **types.AwsDynamoDbTableProjection, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableProjection
	if *v == nil {
		sv = &types.AwsDynamoDbTableProjection{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NonKeyAttributes":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.NonKeyAttributes, value); err != nil {
				return err
			}

		case "ProjectionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProjectionType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughput(v **types.AwsDynamoDbTableProvisionedThroughput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableProvisionedThroughput
	if *v == nil {
		sv = &types.AwsDynamoDbTableProvisionedThroughput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LastDecreaseDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastDecreaseDateTime = ptr.String(jtv)
			}

		case "LastIncreaseDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastIncreaseDateTime = ptr.String(jtv)
			}

		case "NumberOfDecreasesToday":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfDecreasesToday = int32(i64)
			}

		case "ReadCapacityUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReadCapacityUnits = int32(i64)
			}

		case "WriteCapacityUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.WriteCapacityUnits = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(v **types.AwsDynamoDbTableProvisionedThroughputOverride, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableProvisionedThroughputOverride
	if *v == nil {
		sv = &types.AwsDynamoDbTableProvisionedThroughputOverride{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ReadCapacityUnits":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReadCapacityUnits = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplica(v **types.AwsDynamoDbTableReplica, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableReplica
	if *v == nil {
		sv = &types.AwsDynamoDbTableReplica{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GlobalSecondaryIndexes":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndexList(&sv.GlobalSecondaryIndexes, value); err != nil {
				return err
			}

		case "KmsMasterKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsMasterKeyId = ptr.String(jtv)
			}

		case "ProvisionedThroughputOverride":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(&sv.ProvisionedThroughputOverride, value); err != nil {
				return err
			}

		case "RegionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegionName = ptr.String(jtv)
			}

		case "ReplicaStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicaStatus = ptr.String(jtv)
			}

		case "ReplicaStatusDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplicaStatusDescription = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndex(v **types.AwsDynamoDbTableReplicaGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableReplicaGlobalSecondaryIndex
	if *v == nil {
		sv = &types.AwsDynamoDbTableReplicaGlobalSecondaryIndex{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IndexName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexName = ptr.String(jtv)
			}

		case "ProvisionedThroughputOverride":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableProvisionedThroughputOverride(&sv.ProvisionedThroughputOverride, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndexList(v *[]types.AwsDynamoDbTableReplicaGlobalSecondaryIndex, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableReplicaGlobalSecondaryIndex
	if *v == nil {
		cv = []types.AwsDynamoDbTableReplicaGlobalSecondaryIndex{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableReplicaGlobalSecondaryIndex
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaGlobalSecondaryIndex(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableReplicaList(v *[]types.AwsDynamoDbTableReplica, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsDynamoDbTableReplica
	if *v == nil {
		cv = []types.AwsDynamoDbTableReplica{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsDynamoDbTableReplica
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableReplica(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableRestoreSummary(v **types.AwsDynamoDbTableRestoreSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableRestoreSummary
	if *v == nil {
		sv = &types.AwsDynamoDbTableRestoreSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RestoreDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RestoreDateTime = ptr.String(jtv)
			}

		case "RestoreInProgress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RestoreInProgress = jtv
			}

		case "SourceBackupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceBackupArn = ptr.String(jtv)
			}

		case "SourceTableArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceTableArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableSseDescription(v **types.AwsDynamoDbTableSseDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableSseDescription
	if *v == nil {
		sv = &types.AwsDynamoDbTableSseDescription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InaccessibleEncryptionDateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InaccessibleEncryptionDateTime = ptr.String(jtv)
			}

		case "KmsMasterKeyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsMasterKeyArn = ptr.String(jtv)
			}

		case "SseType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SseType = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsDynamoDbTableStreamSpecification(v **types.AwsDynamoDbTableStreamSpecification, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsDynamoDbTableStreamSpecification
	if *v == nil {
		sv = &types.AwsDynamoDbTableStreamSpecification{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StreamEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StreamEnabled = jtv
			}

		case "StreamViewType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StreamViewType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2EipDetails(v **types.AwsEc2EipDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2EipDetails
	if *v == nil {
		sv = &types.AwsEc2EipDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AllocationId = ptr.String(jtv)
			}

		case "AssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationId = ptr.String(jtv)
			}

		case "Domain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Domain = ptr.String(jtv)
			}

		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		case "NetworkBorderGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkBorderGroup = ptr.String(jtv)
			}

		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		case "NetworkInterfaceOwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceOwnerId = ptr.String(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		case "PublicIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIp = ptr.String(jtv)
			}

		case "PublicIpv4Pool":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIpv4Pool = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceDetails(v **types.AwsEc2InstanceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2InstanceDetails
	if *v == nil {
		sv = &types.AwsEc2InstanceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IamInstanceProfileArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamInstanceProfileArn = ptr.String(jtv)
			}

		case "ImageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageId = ptr.String(jtv)
			}

		case "IpV4Addresses":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.IpV4Addresses, value); err != nil {
				return err
			}

		case "IpV6Addresses":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.IpV6Addresses, value); err != nil {
				return err
			}

		case "KeyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyName = ptr.String(jtv)
			}

		case "LaunchedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchedAt = ptr.String(jtv)
			}

		case "NetworkInterfaces":
			if err := awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesList(&sv.NetworkInterfaces, value); err != nil {
				return err
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesDetails(v **types.AwsEc2InstanceNetworkInterfacesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2InstanceNetworkInterfacesDetails
	if *v == nil {
		sv = &types.AwsEc2InstanceNetworkInterfacesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesList(v *[]types.AwsEc2InstanceNetworkInterfacesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2InstanceNetworkInterfacesDetails
	if *v == nil {
		cv = []types.AwsEc2InstanceNetworkInterfacesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2InstanceNetworkInterfacesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2InstanceNetworkInterfacesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociation(v **types.AwsEc2NetworkAclAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkAclAssociation
	if *v == nil {
		sv = &types.AwsEc2NetworkAclAssociation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NetworkAclAssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkAclAssociationId = ptr.String(jtv)
			}

		case "NetworkAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkAclId = ptr.String(jtv)
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociationList(v *[]types.AwsEc2NetworkAclAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkAclAssociation
	if *v == nil {
		cv = []types.AwsEc2NetworkAclAssociation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkAclAssociation
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclDetails(v **types.AwsEc2NetworkAclDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkAclDetails
	if *v == nil {
		sv = &types.AwsEc2NetworkAclDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Associations":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclAssociationList(&sv.Associations, value); err != nil {
				return err
			}

		case "Entries":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntryList(&sv.Entries, value); err != nil {
				return err
			}

		case "IsDefault":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsDefault = jtv
			}

		case "NetworkAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkAclId = ptr.String(jtv)
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntry(v **types.AwsEc2NetworkAclEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkAclEntry
	if *v == nil {
		sv = &types.AwsEc2NetworkAclEntry{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlock = ptr.String(jtv)
			}

		case "Egress":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Egress = jtv
			}

		case "IcmpTypeCode":
			if err := awsRestjson1_deserializeDocumentIcmpTypeCode(&sv.IcmpTypeCode, value); err != nil {
				return err
			}

		case "Ipv6CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Ipv6CidrBlock = ptr.String(jtv)
			}

		case "PortRange":
			if err := awsRestjson1_deserializeDocumentPortRangeFromTo(&sv.PortRange, value); err != nil {
				return err
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "RuleAction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleAction = ptr.String(jtv)
			}

		case "RuleNumber":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RuleNumber = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntryList(v *[]types.AwsEc2NetworkAclEntry, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkAclEntry
	if *v == nil {
		cv = []types.AwsEc2NetworkAclEntry{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkAclEntry
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclEntry(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceAttachment(v **types.AwsEc2NetworkInterfaceAttachment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceAttachment
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceAttachment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttachmentId = ptr.String(jtv)
			}

		case "AttachTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttachTime = ptr.String(jtv)
			}

		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = jtv
			}

		case "DeviceIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DeviceIndex = int32(i64)
			}

		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		case "InstanceOwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceOwnerId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceDetails(v **types.AwsEc2NetworkInterfaceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceDetails
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attachment":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceAttachment(&sv.Attachment, value); err != nil {
				return err
			}

		case "IpV6Addresses":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressList(&sv.IpV6Addresses, value); err != nil {
				return err
			}

		case "NetworkInterfaceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkInterfaceId = ptr.String(jtv)
			}

		case "PrivateIpAddresses":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressList(&sv.PrivateIpAddresses, value); err != nil {
				return err
			}

		case "PublicDnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicDnsName = ptr.String(jtv)
			}

		case "PublicIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIp = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroupList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "SourceDestCheck":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.SourceDestCheck = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressDetail(v **types.AwsEc2NetworkInterfaceIpV6AddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceIpV6AddressDetail
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceIpV6AddressDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IpV6Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpV6Address = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressList(v *[]types.AwsEc2NetworkInterfaceIpV6AddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkInterfaceIpV6AddressDetail
	if *v == nil {
		cv = []types.AwsEc2NetworkInterfaceIpV6AddressDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkInterfaceIpV6AddressDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceIpV6AddressDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressDetail(v **types.AwsEc2NetworkInterfacePrivateIpAddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfacePrivateIpAddressDetail
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfacePrivateIpAddressDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PrivateDnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateDnsName = ptr.String(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressList(v *[]types.AwsEc2NetworkInterfacePrivateIpAddressDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkInterfacePrivateIpAddressDetail
	if *v == nil {
		cv = []types.AwsEc2NetworkInterfacePrivateIpAddressDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkInterfacePrivateIpAddressDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfacePrivateIpAddressDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroup(v **types.AwsEc2NetworkInterfaceSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2NetworkInterfaceSecurityGroup
	if *v == nil {
		sv = &types.AwsEc2NetworkInterfaceSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroupList(v *[]types.AwsEc2NetworkInterfaceSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2NetworkInterfaceSecurityGroup
	if *v == nil {
		cv = []types.AwsEc2NetworkInterfaceSecurityGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2NetworkInterfaceSecurityGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceSecurityGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupDetails(v **types.AwsEc2SecurityGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupDetails
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "IpPermissions":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermissionList(&sv.IpPermissions, value); err != nil {
				return err
			}

		case "IpPermissionsEgress":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermissionList(&sv.IpPermissionsEgress, value); err != nil {
				return err
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermission(v **types.AwsEc2SecurityGroupIpPermission, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupIpPermission
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupIpPermission{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FromPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FromPort = int32(i64)
			}

		case "IpProtocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpProtocol = ptr.String(jtv)
			}

		case "IpRanges":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRangeList(&sv.IpRanges, value); err != nil {
				return err
			}

		case "Ipv6Ranges":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6RangeList(&sv.Ipv6Ranges, value); err != nil {
				return err
			}

		case "PrefixListIds":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListIdList(&sv.PrefixListIds, value); err != nil {
				return err
			}

		case "ToPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ToPort = int32(i64)
			}

		case "UserIdGroupPairs":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPairList(&sv.UserIdGroupPairs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermissionList(v *[]types.AwsEc2SecurityGroupIpPermission, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupIpPermission
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupIpPermission{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupIpPermission
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpPermission(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRange(v **types.AwsEc2SecurityGroupIpRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupIpRange
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupIpRange{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrIp = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRangeList(v *[]types.AwsEc2SecurityGroupIpRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupIpRange
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupIpRange{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupIpRange
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpRange(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6Range(v **types.AwsEc2SecurityGroupIpv6Range, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupIpv6Range
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupIpv6Range{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrIpv6":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrIpv6 = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6RangeList(v *[]types.AwsEc2SecurityGroupIpv6Range, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupIpv6Range
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupIpv6Range{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupIpv6Range
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupIpv6Range(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListId(v **types.AwsEc2SecurityGroupPrefixListId, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupPrefixListId
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupPrefixListId{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PrefixListId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrefixListId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListIdList(v *[]types.AwsEc2SecurityGroupPrefixListId, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupPrefixListId
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupPrefixListId{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupPrefixListId
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupPrefixListId(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPair(v **types.AwsEc2SecurityGroupUserIdGroupPair, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SecurityGroupUserIdGroupPair
	if *v == nil {
		sv = &types.AwsEc2SecurityGroupUserIdGroupPair{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "PeeringStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PeeringStatus = ptr.String(jtv)
			}

		case "UserId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		case "VpcPeeringConnectionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcPeeringConnectionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPairList(v *[]types.AwsEc2SecurityGroupUserIdGroupPair, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2SecurityGroupUserIdGroupPair
	if *v == nil {
		cv = []types.AwsEc2SecurityGroupUserIdGroupPair{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2SecurityGroupUserIdGroupPair
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupUserIdGroupPair(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2SubnetDetails(v **types.AwsEc2SubnetDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2SubnetDetails
	if *v == nil {
		sv = &types.AwsEc2SubnetDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssignIpv6AddressOnCreation":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AssignIpv6AddressOnCreation = jtv
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "AvailabilityZoneId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZoneId = ptr.String(jtv)
			}

		case "AvailableIpAddressCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AvailableIpAddressCount = int32(i64)
			}

		case "CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlock = ptr.String(jtv)
			}

		case "DefaultForAz":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DefaultForAz = jtv
			}

		case "Ipv6CidrBlockAssociationSet":
			if err := awsRestjson1_deserializeDocumentIpv6CidrBlockAssociationList(&sv.Ipv6CidrBlockAssociationSet, value); err != nil {
				return err
			}

		case "MapPublicIpOnLaunch":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MapPublicIpOnLaunch = jtv
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "SubnetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetArn = ptr.String(jtv)
			}

		case "SubnetId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetId = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VolumeAttachment(v **types.AwsEc2VolumeAttachment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VolumeAttachment
	if *v == nil {
		sv = &types.AwsEc2VolumeAttachment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AttachTime = ptr.String(jtv)
			}

		case "DeleteOnTermination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeleteOnTermination = jtv
			}

		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VolumeAttachmentList(v *[]types.AwsEc2VolumeAttachment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VolumeAttachment
	if *v == nil {
		cv = []types.AwsEc2VolumeAttachment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VolumeAttachment
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VolumeAttachment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VolumeDetails(v **types.AwsEc2VolumeDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VolumeDetails
	if *v == nil {
		sv = &types.AwsEc2VolumeDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attachments":
			if err := awsRestjson1_deserializeDocumentAwsEc2VolumeAttachmentList(&sv.Attachments, value); err != nil {
				return err
			}

		case "CreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateTime = ptr.String(jtv)
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = jtv
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "Size":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Size = int32(i64)
			}

		case "SnapshotId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotId = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpcDetails(v **types.AwsEc2VpcDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpcDetails
	if *v == nil {
		sv = &types.AwsEc2VpcDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CidrBlockAssociationSet":
			if err := awsRestjson1_deserializeDocumentCidrBlockAssociationList(&sv.CidrBlockAssociationSet, value); err != nil {
				return err
			}

		case "DhcpOptionsId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DhcpOptionsId = ptr.String(jtv)
			}

		case "Ipv6CidrBlockAssociationSet":
			if err := awsRestjson1_deserializeDocumentIpv6CidrBlockAssociationList(&sv.Ipv6CidrBlockAssociationSet, value); err != nil {
				return err
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionDetails(v **types.AwsEc2VpnConnectionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Category":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Category = ptr.String(jtv)
			}

		case "CustomerGatewayConfiguration":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CustomerGatewayConfiguration = ptr.String(jtv)
			}

		case "CustomerGatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CustomerGatewayId = ptr.String(jtv)
			}

		case "Options":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsDetails(&sv.Options, value); err != nil {
				return err
			}

		case "Routes":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesList(&sv.Routes, value); err != nil {
				return err
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		case "TransitGatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TransitGatewayId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "VgwTelemetry":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryList(&sv.VgwTelemetry, value); err != nil {
				return err
			}

		case "VpnConnectionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpnConnectionId = ptr.String(jtv)
			}

		case "VpnGatewayId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpnGatewayId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsDetails(v **types.AwsEc2VpnConnectionOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StaticRoutesOnly":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StaticRoutesOnly = jtv
			}

		case "TunnelOptions":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsList(&sv.TunnelOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsDetails(v **types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DpdTimeoutSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DpdTimeoutSeconds = int32(i64)
			}

		case "IkeVersions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.IkeVersions, value); err != nil {
				return err
			}

		case "OutsideIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OutsideIpAddress = ptr.String(jtv)
			}

		case "Phase1DhGroupNumbers":
			if err := awsRestjson1_deserializeDocumentIntegerList(&sv.Phase1DhGroupNumbers, value); err != nil {
				return err
			}

		case "Phase1EncryptionAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase1EncryptionAlgorithms, value); err != nil {
				return err
			}

		case "Phase1IntegrityAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase1IntegrityAlgorithms, value); err != nil {
				return err
			}

		case "Phase1LifetimeSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Phase1LifetimeSeconds = int32(i64)
			}

		case "Phase2DhGroupNumbers":
			if err := awsRestjson1_deserializeDocumentIntegerList(&sv.Phase2DhGroupNumbers, value); err != nil {
				return err
			}

		case "Phase2EncryptionAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase2EncryptionAlgorithms, value); err != nil {
				return err
			}

		case "Phase2IntegrityAlgorithms":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Phase2IntegrityAlgorithms, value); err != nil {
				return err
			}

		case "Phase2LifetimeSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Phase2LifetimeSeconds = int32(i64)
			}

		case "PreSharedKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreSharedKey = ptr.String(jtv)
			}

		case "RekeyFuzzPercentage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RekeyFuzzPercentage = int32(i64)
			}

		case "RekeyMarginTimeSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RekeyMarginTimeSeconds = int32(i64)
			}

		case "ReplayWindowSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReplayWindowSize = int32(i64)
			}

		case "TunnelInsideCidr":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TunnelInsideCidr = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsList(v *[]types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
	if *v == nil {
		cv = []types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpnConnectionOptionsTunnelOptionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionOptionsTunnelOptionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesDetails(v **types.AwsEc2VpnConnectionRoutesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionRoutesDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionRoutesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationCidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationCidrBlock = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.State = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesList(v *[]types.AwsEc2VpnConnectionRoutesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpnConnectionRoutesDetails
	if *v == nil {
		cv = []types.AwsEc2VpnConnectionRoutesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpnConnectionRoutesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionRoutesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryDetails(v **types.AwsEc2VpnConnectionVgwTelemetryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEc2VpnConnectionVgwTelemetryDetails
	if *v == nil {
		sv = &types.AwsEc2VpnConnectionVgwTelemetryDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AcceptedRouteCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AcceptedRouteCount = int32(i64)
			}

		case "CertificateArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CertificateArn = ptr.String(jtv)
			}

		case "LastStatusChange":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastStatusChange = ptr.String(jtv)
			}

		case "OutsideIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OutsideIpAddress = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StatusMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StatusMessage = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryList(v *[]types.AwsEc2VpnConnectionVgwTelemetryDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEc2VpnConnectionVgwTelemetryDetails
	if *v == nil {
		cv = []types.AwsEc2VpnConnectionVgwTelemetryDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEc2VpnConnectionVgwTelemetryDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionVgwTelemetryDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcrContainerImageDetails(v **types.AwsEcrContainerImageDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcrContainerImageDetails
	if *v == nil {
		sv = &types.AwsEcrContainerImageDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Architecture":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Architecture = ptr.String(jtv)
			}

		case "ImageDigest":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageDigest = ptr.String(jtv)
			}

		case "ImagePublishedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImagePublishedAt = ptr.String(jtv)
			}

		case "ImageTags":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.ImageTags, value); err != nil {
				return err
			}

		case "RegistryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryId = ptr.String(jtv)
			}

		case "RepositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsDetails(v **types.AwsEcsClusterClusterSettingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterClusterSettingsDetails
	if *v == nil {
		sv = &types.AwsEcsClusterClusterSettingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsList(v *[]types.AwsEcsClusterClusterSettingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsClusterClusterSettingsDetails
	if *v == nil {
		cv = []types.AwsEcsClusterClusterSettingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsClusterClusterSettingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationDetails(v **types.AwsEcsClusterConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsClusterConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ExecuteCommandConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationDetails(&sv.ExecuteCommandConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationDetails(v **types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsClusterConfigurationExecuteCommandConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LogConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(&sv.LogConfiguration, value); err != nil {
				return err
			}

		case "Logging":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Logging = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(v **types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchEncryptionEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CloudWatchEncryptionEnabled = jtv
			}

		case "CloudWatchLogGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogGroupName = ptr.String(jtv)
			}

		case "S3BucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketName = ptr.String(jtv)
			}

		case "S3EncryptionEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.S3EncryptionEnabled = jtv
			}

		case "S3KeyPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3KeyPrefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyDetails(v **types.AwsEcsClusterDefaultCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterDefaultCapacityProviderStrategyDetails
	if *v == nil {
		sv = &types.AwsEcsClusterDefaultCapacityProviderStrategyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Base":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Base = int32(i64)
			}

		case "CapacityProvider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityProvider = ptr.String(jtv)
			}

		case "Weight":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Weight = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyList(v *[]types.AwsEcsClusterDefaultCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsClusterDefaultCapacityProviderStrategyDetails
	if *v == nil {
		cv = []types.AwsEcsClusterDefaultCapacityProviderStrategyDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsClusterDefaultCapacityProviderStrategyDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsClusterDetails(v **types.AwsEcsClusterDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsClusterDetails
	if *v == nil {
		sv = &types.AwsEcsClusterDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CapacityProviders":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.CapacityProviders, value); err != nil {
				return err
			}

		case "ClusterSettings":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterClusterSettingsList(&sv.ClusterSettings, value); err != nil {
				return err
			}

		case "Configuration":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterConfigurationDetails(&sv.Configuration, value); err != nil {
				return err
			}

		case "DefaultCapacityProviderStrategy":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterDefaultCapacityProviderStrategyList(&sv.DefaultCapacityProviderStrategy, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyDetails(v **types.AwsEcsServiceCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceCapacityProviderStrategyDetails
	if *v == nil {
		sv = &types.AwsEcsServiceCapacityProviderStrategyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Base":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Base = int32(i64)
			}

		case "CapacityProvider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CapacityProvider = ptr.String(jtv)
			}

		case "Weight":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Weight = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyList(v *[]types.AwsEcsServiceCapacityProviderStrategyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServiceCapacityProviderStrategyDetails
	if *v == nil {
		cv = []types.AwsEcsServiceCapacityProviderStrategyDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServiceCapacityProviderStrategyDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(v **types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enable = jtv
			}

		case "Rollback":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Rollback = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDetails(v **types.AwsEcsServiceDeploymentConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDeploymentConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDeploymentConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeploymentCircuitBreaker":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(&sv.DeploymentCircuitBreaker, value); err != nil {
				return err
			}

		case "MaximumPercent":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaximumPercent = int32(i64)
			}

		case "MinimumHealthyPercent":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MinimumHealthyPercent = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentControllerDetails(v **types.AwsEcsServiceDeploymentControllerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDeploymentControllerDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDeploymentControllerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceDetails(v **types.AwsEcsServiceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceDetails
	if *v == nil {
		sv = &types.AwsEcsServiceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CapacityProviderStrategy":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceCapacityProviderStrategyList(&sv.CapacityProviderStrategy, value); err != nil {
				return err
			}

		case "Cluster":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cluster = ptr.String(jtv)
			}

		case "DeploymentConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentConfigurationDetails(&sv.DeploymentConfiguration, value); err != nil {
				return err
			}

		case "DeploymentController":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDeploymentControllerDetails(&sv.DeploymentController, value); err != nil {
				return err
			}

		case "DesiredCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DesiredCount = int32(i64)
			}

		case "EnableEcsManagedTags":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableEcsManagedTags = jtv
			}

		case "EnableExecuteCommand":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnableExecuteCommand = jtv
			}

		case "HealthCheckGracePeriodSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HealthCheckGracePeriodSeconds = int32(i64)
			}

		case "LaunchType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchType = ptr.String(jtv)
			}

		case "LoadBalancers":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersList(&sv.LoadBalancers, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "NetworkConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationDetails(&sv.NetworkConfiguration, value); err != nil {
				return err
			}

		case "PlacementConstraints":
			if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsList(&sv.PlacementConstraints, value); err != nil {
				return err
			}

		case "PlacementStrategies":
			if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesList(&sv.PlacementStrategies, value); err != nil {
				return err
			}

		case "PlatformVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PlatformVersion = ptr.String(jtv)
			}

		case "PropagateTags":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PropagateTags = ptr.String(jtv)
			}

		case "Role":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Role = ptr.String(jtv)
			}

		case "SchedulingStrategy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SchedulingStrategy = ptr.String(jtv)
			}

		case "ServiceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceArn = ptr.String(jtv)
			}

		case "ServiceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServiceName = ptr.String(jtv)
			}

		case "ServiceRegistries":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesList(&sv.ServiceRegistries, value); err != nil {
				return err
			}

		case "TaskDefinition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TaskDefinition = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersDetails(v **types.AwsEcsServiceLoadBalancersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceLoadBalancersDetails
	if *v == nil {
		sv = &types.AwsEcsServiceLoadBalancersDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		case "ContainerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContainerPort = int32(i64)
			}

		case "LoadBalancerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoadBalancerName = ptr.String(jtv)
			}

		case "TargetGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetGroupArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersList(v *[]types.AwsEcsServiceLoadBalancersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServiceLoadBalancersDetails
	if *v == nil {
		cv = []types.AwsEcsServiceLoadBalancersDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServiceLoadBalancersDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServiceLoadBalancersDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(v **types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssignPublicIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssignPublicIp = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Subnets, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationDetails(v **types.AwsEcsServiceNetworkConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceNetworkConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsServiceNetworkConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AwsVpcConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails(&sv.AwsVpcConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsDetails(v **types.AwsEcsServicePlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServicePlacementConstraintsDetails
	if *v == nil {
		sv = &types.AwsEcsServicePlacementConstraintsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Expression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Expression = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsList(v *[]types.AwsEcsServicePlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServicePlacementConstraintsDetails
	if *v == nil {
		cv = []types.AwsEcsServicePlacementConstraintsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServicePlacementConstraintsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementConstraintsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesDetails(v **types.AwsEcsServicePlacementStrategiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServicePlacementStrategiesDetails
	if *v == nil {
		sv = &types.AwsEcsServicePlacementStrategiesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Field":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Field = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesList(v *[]types.AwsEcsServicePlacementStrategiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServicePlacementStrategiesDetails
	if *v == nil {
		cv = []types.AwsEcsServicePlacementStrategiesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServicePlacementStrategiesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServicePlacementStrategiesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesDetails(v **types.AwsEcsServiceServiceRegistriesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsServiceServiceRegistriesDetails
	if *v == nil {
		sv = &types.AwsEcsServiceServiceRegistriesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		case "ContainerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContainerPort = int32(i64)
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "RegistryArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RegistryArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesList(v *[]types.AwsEcsServiceServiceRegistriesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsServiceServiceRegistriesDetails
	if *v == nil {
		cv = []types.AwsEcsServiceServiceRegistriesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsServiceServiceRegistriesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsServiceServiceRegistriesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Condition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Condition = ptr.String(jtv)
			}

		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Command":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Command, value); err != nil {
				return err
			}

		case "Cpu":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Cpu = int32(i64)
			}

		case "DependsOn":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDependsOnList(&sv.DependsOn, value); err != nil {
				return err
			}

		case "DisableNetworking":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DisableNetworking = jtv
			}

		case "DnsSearchDomains":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.DnsSearchDomains, value); err != nil {
				return err
			}

		case "DnsServers":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.DnsServers, value); err != nil {
				return err
			}

		case "DockerLabels":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.DockerLabels, value); err != nil {
				return err
			}

		case "DockerSecurityOptions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.DockerSecurityOptions, value); err != nil {
				return err
			}

		case "EntryPoint":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.EntryPoint, value); err != nil {
				return err
			}

		case "Environment":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentList(&sv.Environment, value); err != nil {
				return err
			}

		case "EnvironmentFiles":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList(&sv.EnvironmentFiles, value); err != nil {
				return err
			}

		case "Essential":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Essential = jtv
			}

		case "ExtraHosts":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsList(&sv.ExtraHosts, value); err != nil {
				return err
			}

		case "FirelensConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(&sv.FirelensConfiguration, value); err != nil {
				return err
			}

		case "HealthCheck":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(&sv.HealthCheck, value); err != nil {
				return err
			}

		case "Hostname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Hostname = ptr.String(jtv)
			}

		case "Image":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Image = ptr.String(jtv)
			}

		case "Interactive":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Interactive = jtv
			}

		case "Links":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Links, value); err != nil {
				return err
			}

		case "LinuxParameters":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(&sv.LinuxParameters, value); err != nil {
				return err
			}

		case "LogConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(&sv.LogConfiguration, value); err != nil {
				return err
			}

		case "Memory":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Memory = int32(i64)
			}

		case "MemoryReservation":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MemoryReservation = int32(i64)
			}

		case "MountPoints":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsList(&sv.MountPoints, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "PortMappings":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsList(&sv.PortMappings, value); err != nil {
				return err
			}

		case "Privileged":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Privileged = jtv
			}

		case "PseudoTerminal":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PseudoTerminal = jtv
			}

		case "ReadonlyRootFilesystem":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ReadonlyRootFilesystem = jtv
			}

		case "RepositoryCredentials":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(&sv.RepositoryCredentials, value); err != nil {
				return err
			}

		case "ResourceRequirements":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList(&sv.ResourceRequirements, value); err != nil {
				return err
			}

		case "Secrets":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsList(&sv.Secrets, value); err != nil {
				return err
			}

		case "StartTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartTimeout = int32(i64)
			}

		case "StopTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StopTimeout = int32(i64)
			}

		case "SystemControls":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsList(&sv.SystemControls, value); err != nil {
				return err
			}

		case "Ulimits":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsList(&sv.Ulimits, value); err != nil {
				return err
			}

		case "User":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.User = ptr.String(jtv)
			}

		case "VolumesFrom":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromList(&sv.VolumesFrom, value); err != nil {
				return err
			}

		case "WorkingDirectory":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WorkingDirectory = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Hostname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Hostname = ptr.String(jtv)
			}

		case "IpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Options":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Options, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Command":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Command, value); err != nil {
				return err
			}

		case "Interval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Interval = int32(i64)
			}

		case "Retries":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Retries = int32(i64)
			}

		case "StartPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartPeriod = int32(i64)
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Add":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Add, value); err != nil {
				return err
			}

		case "Drop":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Drop, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Capabilities":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails(&sv.Capabilities, value); err != nil {
				return err
			}

		case "Devices":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList(&sv.Devices, value); err != nil {
				return err
			}

		case "InitProcessEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.InitProcessEnabled = jtv
			}

		case "MaxSwap":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxSwap = int32(i64)
			}

		case "SharedMemorySize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SharedMemorySize = int32(i64)
			}

		case "Swappiness":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Swappiness = int32(i64)
			}

		case "Tmpfs":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList(&sv.Tmpfs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerPath = ptr.String(jtv)
			}

		case "HostPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostPath = ptr.String(jtv)
			}

		case "Permissions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.Permissions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerPath = ptr.String(jtv)
			}

		case "MountOptions":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.MountOptions, value); err != nil {
				return err
			}

		case "Size":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Size = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LogDriver":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LogDriver = ptr.String(jtv)
			}

		case "Options":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Options, value); err != nil {
				return err
			}

		case "SecretOptions":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList(&sv.SecretOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ValueFrom":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValueFrom = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerPath = ptr.String(jtv)
			}

		case "ReadOnly":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ReadOnly = jtv
			}

		case "SourceVolume":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceVolume = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ContainerPort = int32(i64)
			}

		case "HostPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HostPort = int32(i64)
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CredentialsParameter":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CredentialsParameter = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ValueFrom":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ValueFrom = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSecretsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Namespace":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Namespace = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HardLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HardLimit = int32(i64)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "SoftLimit":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SoftLimit = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(v **types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ReadOnly":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ReadOnly = jtv
			}

		case "SourceContainer":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceContainer = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromList(v *[]types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionDetails(v **types.AwsEcsTaskDefinitionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerDefinitions":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionContainerDefinitionsList(&sv.ContainerDefinitions, value); err != nil {
				return err
			}

		case "Cpu":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cpu = ptr.String(jtv)
			}

		case "ExecutionRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExecutionRoleArn = ptr.String(jtv)
			}

		case "Family":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Family = ptr.String(jtv)
			}

		case "InferenceAccelerators":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsList(&sv.InferenceAccelerators, value); err != nil {
				return err
			}

		case "IpcMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpcMode = ptr.String(jtv)
			}

		case "Memory":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Memory = ptr.String(jtv)
			}

		case "NetworkMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NetworkMode = ptr.String(jtv)
			}

		case "PidMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PidMode = ptr.String(jtv)
			}

		case "PlacementConstraints":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsList(&sv.PlacementConstraints, value); err != nil {
				return err
			}

		case "ProxyConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationDetails(&sv.ProxyConfiguration, value); err != nil {
				return err
			}

		case "RequiresCompatibilities":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.RequiresCompatibilities, value); err != nil {
				return err
			}

		case "TaskRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TaskRoleArn = ptr.String(jtv)
			}

		case "Volumes":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesList(&sv.Volumes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsDetails(v **types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeviceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceName = ptr.String(jtv)
			}

		case "DeviceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeviceType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsList(v *[]types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionInferenceAcceleratorsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionInferenceAcceleratorsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsDetails(v **types.AwsEcsTaskDefinitionPlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionPlacementConstraintsDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionPlacementConstraintsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Expression":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Expression = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsList(v *[]types.AwsEcsTaskDefinitionPlacementConstraintsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionPlacementConstraintsDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionPlacementConstraintsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionPlacementConstraintsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionPlacementConstraintsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationDetails(v **types.AwsEcsTaskDefinitionProxyConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionProxyConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionProxyConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContainerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContainerName = ptr.String(jtv)
			}

		case "ProxyConfigurationProperties":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList(&sv.ProxyConfigurationProperties, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(v **types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesList(v *[]types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionProxyConfigurationProxyConfigurationPropertiesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDetails(v **types.AwsEcsTaskDefinitionVolumesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DockerVolumeConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(&sv.DockerVolumeConfiguration, value); err != nil {
				return err
			}

		case "EfsVolumeConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(&sv.EfsVolumeConfiguration, value); err != nil {
				return err
			}

		case "Host":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesHostDetails(&sv.Host, value); err != nil {
				return err
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(v **types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Autoprovision":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Autoprovision = jtv
			}

		case "Driver":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Driver = ptr.String(jtv)
			}

		case "DriverOpts":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.DriverOpts, value); err != nil {
				return err
			}

		case "Labels":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Labels, value); err != nil {
				return err
			}

		case "Scope":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Scope = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(v **types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessPointId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessPointId = ptr.String(jtv)
			}

		case "Iam":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Iam = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails(v **types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuthorizationConfig":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(&sv.AuthorizationConfig, value); err != nil {
				return err
			}

		case "FilesystemId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FilesystemId = ptr.String(jtv)
			}

		case "RootDirectory":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RootDirectory = ptr.String(jtv)
			}

		case "TransitEncryption":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TransitEncryption = ptr.String(jtv)
			}

		case "TransitEncryptionPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TransitEncryptionPort = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesHostDetails(v **types.AwsEcsTaskDefinitionVolumesHostDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsEcsTaskDefinitionVolumesHostDetails
	if *v == nil {
		sv = &types.AwsEcsTaskDefinitionVolumesHostDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SourcePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourcePath = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesList(v *[]types.AwsEcsTaskDefinitionVolumesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsEcsTaskDefinitionVolumesDetails
	if *v == nil {
		cv = []types.AwsEcsTaskDefinitionVolumesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsEcsTaskDefinitionVolumesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionVolumesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentDetails(v **types.AwsElasticBeanstalkEnvironmentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentDetails
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplicationName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApplicationName = ptr.String(jtv)
			}

		case "Cname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cname = ptr.String(jtv)
			}

		case "DateCreated":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DateCreated = ptr.String(jtv)
			}

		case "DateUpdated":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DateUpdated = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EndpointUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EndpointUrl = ptr.String(jtv)
			}

		case "EnvironmentArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentArn = ptr.String(jtv)
			}

		case "EnvironmentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentId = ptr.String(jtv)
			}

		case "EnvironmentLinks":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLinks(&sv.EnvironmentLinks, value); err != nil {
				return err
			}

		case "EnvironmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentName = ptr.String(jtv)
			}

		case "OptionSettings":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSettings(&sv.OptionSettings, value); err != nil {
				return err
			}

		case "PlatformArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PlatformArn = ptr.String(jtv)
			}

		case "SolutionStackName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SolutionStackName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "Tier":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentTier(&sv.Tier, value); err != nil {
				return err
			}

		case "VersionLabel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VersionLabel = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLink(v **types.AwsElasticBeanstalkEnvironmentEnvironmentLink, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentEnvironmentLink
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentEnvironmentLink{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EnvironmentName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnvironmentName = ptr.String(jtv)
			}

		case "LinkName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LinkName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLinks(v *[]types.AwsElasticBeanstalkEnvironmentEnvironmentLink, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElasticBeanstalkEnvironmentEnvironmentLink
	if *v == nil {
		cv = []types.AwsElasticBeanstalkEnvironmentEnvironmentLink{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElasticBeanstalkEnvironmentEnvironmentLink
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentEnvironmentLink(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSetting(v **types.AwsElasticBeanstalkEnvironmentOptionSetting, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentOptionSetting
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentOptionSetting{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Namespace":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Namespace = ptr.String(jtv)
			}

		case "OptionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OptionName = ptr.String(jtv)
			}

		case "ResourceName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceName = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSettings(v *[]types.AwsElasticBeanstalkEnvironmentOptionSetting, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElasticBeanstalkEnvironmentOptionSetting
	if *v == nil {
		cv = []types.AwsElasticBeanstalkEnvironmentOptionSetting{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElasticBeanstalkEnvironmentOptionSetting
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentOptionSetting(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentTier(v **types.AwsElasticBeanstalkEnvironmentTier, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticBeanstalkEnvironmentTier
	if *v == nil {
		sv = &types.AwsElasticBeanstalkEnvironmentTier{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainDetails(v **types.AwsElasticsearchDomainDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainDetails
	if *v == nil {
		sv = &types.AwsElasticsearchDomainDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessPolicies":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessPolicies = ptr.String(jtv)
			}

		case "DomainEndpointOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainDomainEndpointOptions(&sv.DomainEndpointOptions, value); err != nil {
				return err
			}

		case "DomainId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainId = ptr.String(jtv)
			}

		case "DomainName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DomainName = ptr.String(jtv)
			}

		case "ElasticsearchClusterConfig":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigDetails(&sv.ElasticsearchClusterConfig, value); err != nil {
				return err
			}

		case "ElasticsearchVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ElasticsearchVersion = ptr.String(jtv)
			}

		case "EncryptionAtRestOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainEncryptionAtRestOptions(&sv.EncryptionAtRestOptions, value); err != nil {
				return err
			}

		case "Endpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Endpoint = ptr.String(jtv)
			}

		case "Endpoints":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Endpoints, value); err != nil {
				return err
			}

		case "LogPublishingOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptions(&sv.LogPublishingOptions, value); err != nil {
				return err
			}

		case "NodeToNodeEncryptionOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainNodeToNodeEncryptionOptions(&sv.NodeToNodeEncryptionOptions, value); err != nil {
				return err
			}

		case "ServiceSoftwareOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainServiceSoftwareOptions(&sv.ServiceSoftwareOptions, value); err != nil {
				return err
			}

		case "VPCOptions":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainVPCOptions(&sv.VPCOptions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainDomainEndpointOptions(v **types.AwsElasticsearchDomainDomainEndpointOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainDomainEndpointOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainDomainEndpointOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EnforceHTTPS":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnforceHTTPS = jtv
			}

		case "TLSSecurityPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TLSSecurityPolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigDetails(v **types.AwsElasticsearchDomainElasticsearchClusterConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainElasticsearchClusterConfigDetails
	if *v == nil {
		sv = &types.AwsElasticsearchDomainElasticsearchClusterConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DedicatedMasterCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DedicatedMasterCount = int32(i64)
			}

		case "DedicatedMasterEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DedicatedMasterEnabled = jtv
			}

		case "DedicatedMasterType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DedicatedMasterType = ptr.String(jtv)
			}

		case "InstanceCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstanceCount = int32(i64)
			}

		case "InstanceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceType = ptr.String(jtv)
			}

		case "ZoneAwarenessConfig":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails(&sv.ZoneAwarenessConfig, value); err != nil {
				return err
			}

		case "ZoneAwarenessEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ZoneAwarenessEnabled = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails(v **types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails
	if *v == nil {
		sv = &types.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZoneCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AvailabilityZoneCount = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainEncryptionAtRestOptions(v **types.AwsElasticsearchDomainEncryptionAtRestOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainEncryptionAtRestOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainEncryptionAtRestOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptions(v **types.AwsElasticsearchDomainLogPublishingOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainLogPublishingOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainLogPublishingOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AuditLogs":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(&sv.AuditLogs, value); err != nil {
				return err
			}

		case "IndexSlowLogs":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(&sv.IndexSlowLogs, value); err != nil {
				return err
			}

		case "SearchSlowLogs":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(&sv.SearchSlowLogs, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainLogPublishingOptionsLogConfig(v **types.AwsElasticsearchDomainLogPublishingOptionsLogConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainLogPublishingOptionsLogConfig
	if *v == nil {
		sv = &types.AwsElasticsearchDomainLogPublishingOptionsLogConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CloudWatchLogsLogGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CloudWatchLogsLogGroupArn = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainNodeToNodeEncryptionOptions(v **types.AwsElasticsearchDomainNodeToNodeEncryptionOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainNodeToNodeEncryptionOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainNodeToNodeEncryptionOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainServiceSoftwareOptions(v **types.AwsElasticsearchDomainServiceSoftwareOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainServiceSoftwareOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainServiceSoftwareOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutomatedUpdateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AutomatedUpdateDate = ptr.String(jtv)
			}

		case "Cancellable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Cancellable = jtv
			}

		case "CurrentVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CurrentVersion = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "NewVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NewVersion = ptr.String(jtv)
			}

		case "UpdateAvailable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.UpdateAvailable = jtv
			}

		case "UpdateStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdateStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElasticsearchDomainVPCOptions(v **types.AwsElasticsearchDomainVPCOptions, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElasticsearchDomainVPCOptions
	if *v == nil {
		sv = &types.AwsElasticsearchDomainVPCOptions{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "SecurityGroupIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIds, value); err != nil {
				return err
			}

		case "SubnetIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SubnetIds, value); err != nil {
				return err
			}

		case "VPCId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VPCId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicies(v *[]types.AwsElbAppCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbAppCookieStickinessPolicy
	if *v == nil {
		cv = []types.AwsElbAppCookieStickinessPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbAppCookieStickinessPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicy(v **types.AwsElbAppCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbAppCookieStickinessPolicy
	if *v == nil {
		sv = &types.AwsElbAppCookieStickinessPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CookieName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CookieName = ptr.String(jtv)
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicies(v *[]types.AwsElbLbCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLbCookieStickinessPolicy
	if *v == nil {
		cv = []types.AwsElbLbCookieStickinessPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLbCookieStickinessPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicy(v **types.AwsElbLbCookieStickinessPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLbCookieStickinessPolicy
	if *v == nil {
		sv = &types.AwsElbLbCookieStickinessPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CookieExpirationPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CookieExpirationPeriod = i64
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerAccessLog(v **types.AwsElbLoadBalancerAccessLog, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerAccessLog
	if *v == nil {
		sv = &types.AwsElbLoadBalancerAccessLog{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "EmitInterval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EmitInterval = int32(i64)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "S3BucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketName = ptr.String(jtv)
			}

		case "S3BucketPrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3BucketPrefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerAttributes(v **types.AwsElbLoadBalancerAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerAttributes
	if *v == nil {
		sv = &types.AwsElbLoadBalancerAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessLog":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerAccessLog(&sv.AccessLog, value); err != nil {
				return err
			}

		case "ConnectionDraining":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionDraining(&sv.ConnectionDraining, value); err != nil {
				return err
			}

		case "ConnectionSettings":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionSettings(&sv.ConnectionSettings, value); err != nil {
				return err
			}

		case "CrossZoneLoadBalancing":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerCrossZoneLoadBalancing(&sv.CrossZoneLoadBalancing, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescription(v **types.AwsElbLoadBalancerBackendServerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerBackendServerDescription
	if *v == nil {
		sv = &types.AwsElbLoadBalancerBackendServerDescription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstancePort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstancePort = int32(i64)
			}

		case "PolicyNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.PolicyNames, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescriptions(v *[]types.AwsElbLoadBalancerBackendServerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerBackendServerDescription
	if *v == nil {
		cv = []types.AwsElbLoadBalancerBackendServerDescription{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerBackendServerDescription
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescription(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionDraining(v **types.AwsElbLoadBalancerConnectionDraining, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerConnectionDraining
	if *v == nil {
		sv = &types.AwsElbLoadBalancerConnectionDraining{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerConnectionSettings(v **types.AwsElbLoadBalancerConnectionSettings, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerConnectionSettings
	if *v == nil {
		sv = &types.AwsElbLoadBalancerConnectionSettings{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "IdleTimeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.IdleTimeout = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerCrossZoneLoadBalancing(v **types.AwsElbLoadBalancerCrossZoneLoadBalancing, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerCrossZoneLoadBalancing
	if *v == nil {
		sv = &types.AwsElbLoadBalancerCrossZoneLoadBalancing{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerDetails(v **types.AwsElbLoadBalancerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerDetails
	if *v == nil {
		sv = &types.AwsElbLoadBalancerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "BackendServerDescriptions":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerBackendServerDescriptions(&sv.BackendServerDescriptions, value); err != nil {
				return err
			}

		case "CanonicalHostedZoneName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CanonicalHostedZoneName = ptr.String(jtv)
			}

		case "CanonicalHostedZoneNameID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CanonicalHostedZoneNameID = ptr.String(jtv)
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "DnsName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DnsName = ptr.String(jtv)
			}

		case "HealthCheck":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerHealthCheck(&sv.HealthCheck, value); err != nil {
				return err
			}

		case "Instances":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstances(&sv.Instances, value); err != nil {
				return err
			}

		case "ListenerDescriptions":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescriptions(&sv.ListenerDescriptions, value); err != nil {
				return err
			}

		case "LoadBalancerAttributes":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerAttributes(&sv.LoadBalancerAttributes, value); err != nil {
				return err
			}

		case "LoadBalancerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LoadBalancerName = ptr.String(jtv)
			}

		case "Policies":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerPolicies(&sv.Policies, value); err != nil {
				return err
			}

		case "Scheme":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Scheme = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "SourceSecurityGroup":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerSourceSecurityGroup(&sv.SourceSecurityGroup, value); err != nil {
				return err
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Subnets, value); err != nil {
				return err
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerHealthCheck(v **types.AwsElbLoadBalancerHealthCheck, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerHealthCheck
	if *v == nil {
		sv = &types.AwsElbLoadBalancerHealthCheck{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HealthyThreshold":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.HealthyThreshold = int32(i64)
			}

		case "Interval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Interval = int32(i64)
			}

		case "Target":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Target = ptr.String(jtv)
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = int32(i64)
			}

		case "UnhealthyThreshold":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.UnhealthyThreshold = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstance(v **types.AwsElbLoadBalancerInstance, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerInstance
	if *v == nil {
		sv = &types.AwsElbLoadBalancerInstance{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstanceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstances(v *[]types.AwsElbLoadBalancerInstance, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerInstance
	if *v == nil {
		cv = []types.AwsElbLoadBalancerInstance{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerInstance
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerInstance(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerListener(v **types.AwsElbLoadBalancerListener, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerListener
	if *v == nil {
		sv = &types.AwsElbLoadBalancerListener{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "InstancePort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstancePort = int32(i64)
			}

		case "InstanceProtocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceProtocol = ptr.String(jtv)
			}

		case "LoadBalancerPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.LoadBalancerPort = int32(i64)
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "SslCertificateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SslCertificateId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescription(v **types.AwsElbLoadBalancerListenerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerListenerDescription
	if *v == nil {
		sv = &types.AwsElbLoadBalancerListenerDescription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Listener":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerListener(&sv.Listener, value); err != nil {
				return err
			}

		case "PolicyNames":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.PolicyNames, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescriptions(v *[]types.AwsElbLoadBalancerListenerDescription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsElbLoadBalancerListenerDescription
	if *v == nil {
		cv = []types.AwsElbLoadBalancerListenerDescription{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsElbLoadBalancerListenerDescription
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerListenerDescription(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerPolicies(v **types.AwsElbLoadBalancerPolicies, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerPolicies
	if *v == nil {
		sv = &types.AwsElbLoadBalancerPolicies{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AppCookieStickinessPolicies":
			if err := awsRestjson1_deserializeDocumentAwsElbAppCookieStickinessPolicies(&sv.AppCookieStickinessPolicies, value); err != nil {
				return err
			}

		case "LbCookieStickinessPolicies":
			if err := awsRestjson1_deserializeDocumentAwsElbLbCookieStickinessPolicies(&sv.LbCookieStickinessPolicies, value); err != nil {
				return err
			}

		case "OtherPolicies":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.OtherPolicies, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbLoadBalancerSourceSecurityGroup(v **types.AwsElbLoadBalancerSourceSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbLoadBalancerSourceSecurityGroup
	if *v == nil {
		sv = &types.AwsElbLoadBalancerSourceSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "OwnerAlias":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerAlias = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerDetails(v **types.AwsElbv2LoadBalancerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsElbv2LoadBalancerDetails
	if *v == nil {
		sv = &types.AwsElbv2LoadBalancerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentAvailabilityZones(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "CanonicalHostedZoneId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CanonicalHostedZoneId = ptr.String(jtv)
			}

		case "CreatedTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedTime = ptr.String(jtv)
			}

		case "DNSName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DNSName = ptr.String(jtv)
			}

		case "IpAddressType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IpAddressType = ptr.String(jtv)
			}

		case "Scheme":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Scheme = ptr.String(jtv)
			}

		case "SecurityGroups":
			if err := awsRestjson1_deserializeDocumentSecurityGroups(&sv.SecurityGroups, value); err != nil {
				return err
			}

		case "State":
			if err := awsRestjson1_deserializeDocumentLoadBalancerState(&sv.State, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeyDetails(v **types.AwsIamAccessKeyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeyDetails
	if *v == nil {
		sv = &types.AwsIamAccessKeyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessKeyId = ptr.String(jtv)
			}

		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "PrincipalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalId = ptr.String(jtv)
			}

		case "PrincipalName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalName = ptr.String(jtv)
			}

		case "PrincipalType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalType = ptr.String(jtv)
			}

		case "SessionContext":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContext(&sv.SessionContext, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AwsIamAccessKeyStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.AwsIamAccessKeyStatus(jtv)
			}

		case "UserName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContext(v **types.AwsIamAccessKeySessionContext, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeySessionContext
	if *v == nil {
		sv = &types.AwsIamAccessKeySessionContext{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Attributes":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextAttributes(&sv.Attributes, value); err != nil {
				return err
			}

		case "SessionIssuer":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextSessionIssuer(&sv.SessionIssuer, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextAttributes(v **types.AwsIamAccessKeySessionContextAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeySessionContextAttributes
	if *v == nil {
		sv = &types.AwsIamAccessKeySessionContextAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreationDate = ptr.String(jtv)
			}

		case "MfaAuthenticated":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MfaAuthenticated = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAccessKeySessionContextSessionIssuer(v **types.AwsIamAccessKeySessionContextSessionIssuer, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAccessKeySessionContextSessionIssuer
	if *v == nil {
		sv = &types.AwsIamAccessKeySessionContextSessionIssuer{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "PrincipalId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrincipalId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		case "UserName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicy(v **types.AwsIamAttachedManagedPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamAttachedManagedPolicy
	if *v == nil {
		sv = &types.AwsIamAttachedManagedPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PolicyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyArn = ptr.String(jtv)
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicyList(v *[]types.AwsIamAttachedManagedPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamAttachedManagedPolicy
	if *v == nil {
		cv = []types.AwsIamAttachedManagedPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamAttachedManagedPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamGroupDetails(v **types.AwsIamGroupDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamGroupDetails
	if *v == nil {
		sv = &types.AwsIamGroupDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachedManagedPolicies":
			if err := awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicyList(&sv.AttachedManagedPolicies, value); err != nil {
				return err
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "GroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupId = ptr.String(jtv)
			}

		case "GroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupName = ptr.String(jtv)
			}

		case "GroupPolicyList":
			if err := awsRestjson1_deserializeDocumentAwsIamGroupPolicyList(&sv.GroupPolicyList, value); err != nil {
				return err
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamGroupPolicy(v **types.AwsIamGroupPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamGroupPolicy
	if *v == nil {
		sv = &types.AwsIamGroupPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamGroupPolicyList(v *[]types.AwsIamGroupPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamGroupPolicy
	if *v == nil {
		cv = []types.AwsIamGroupPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamGroupPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamGroupPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamInstanceProfile(v **types.AwsIamInstanceProfile, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamInstanceProfile
	if *v == nil {
		sv = &types.AwsIamInstanceProfile{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "InstanceProfileId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceProfileId = ptr.String(jtv)
			}

		case "InstanceProfileName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceProfileName = ptr.String(jtv)
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "Roles":
			if err := awsRestjson1_deserializeDocumentAwsIamInstanceProfileRoles(&sv.Roles, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamInstanceProfileList(v *[]types.AwsIamInstanceProfile, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamInstanceProfile
	if *v == nil {
		cv = []types.AwsIamInstanceProfile{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamInstanceProfile
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamInstanceProfile(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamInstanceProfileRole(v **types.AwsIamInstanceProfileRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamInstanceProfileRole
	if *v == nil {
		sv = &types.AwsIamInstanceProfileRole{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "AssumeRolePolicyDocument":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AwsIamRoleAssumeRolePolicyDocument to be of type string, got %T instead", value)
				}
				sv.AssumeRolePolicyDocument = ptr.String(jtv)
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "RoleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleId = ptr.String(jtv)
			}

		case "RoleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamInstanceProfileRoles(v *[]types.AwsIamInstanceProfileRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamInstanceProfileRole
	if *v == nil {
		cv = []types.AwsIamInstanceProfileRole{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamInstanceProfileRole
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamInstanceProfileRole(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamPermissionsBoundary(v **types.AwsIamPermissionsBoundary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamPermissionsBoundary
	if *v == nil {
		sv = &types.AwsIamPermissionsBoundary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PermissionsBoundaryArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PermissionsBoundaryArn = ptr.String(jtv)
			}

		case "PermissionsBoundaryType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PermissionsBoundaryType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamPolicyDetails(v **types.AwsIamPolicyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamPolicyDetails
	if *v == nil {
		sv = &types.AwsIamPolicyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachmentCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AttachmentCount = int32(i64)
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "DefaultVersionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultVersionId = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "IsAttachable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsAttachable = jtv
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "PermissionsBoundaryUsageCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PermissionsBoundaryUsageCount = int32(i64)
			}

		case "PolicyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyId = ptr.String(jtv)
			}

		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		case "PolicyVersionList":
			if err := awsRestjson1_deserializeDocumentAwsIamPolicyVersionList(&sv.PolicyVersionList, value); err != nil {
				return err
			}

		case "UpdateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdateDate = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamPolicyVersion(v **types.AwsIamPolicyVersion, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamPolicyVersion
	if *v == nil {
		sv = &types.AwsIamPolicyVersion{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "IsDefaultVersion":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsDefaultVersion = jtv
			}

		case "VersionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VersionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamPolicyVersionList(v *[]types.AwsIamPolicyVersion, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamPolicyVersion
	if *v == nil {
		cv = []types.AwsIamPolicyVersion{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamPolicyVersion
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamPolicyVersion(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamRoleDetails(v **types.AwsIamRoleDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamRoleDetails
	if *v == nil {
		sv = &types.AwsIamRoleDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssumeRolePolicyDocument":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AwsIamRoleAssumeRolePolicyDocument to be of type string, got %T instead", value)
				}
				sv.AssumeRolePolicyDocument = ptr.String(jtv)
			}

		case "AttachedManagedPolicies":
			if err := awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicyList(&sv.AttachedManagedPolicies, value); err != nil {
				return err
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "InstanceProfileList":
			if err := awsRestjson1_deserializeDocumentAwsIamInstanceProfileList(&sv.InstanceProfileList, value); err != nil {
				return err
			}

		case "MaxSessionDuration":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxSessionDuration = int32(i64)
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "PermissionsBoundary":
			if err := awsRestjson1_deserializeDocumentAwsIamPermissionsBoundary(&sv.PermissionsBoundary, value); err != nil {
				return err
			}

		case "RoleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleId = ptr.String(jtv)
			}

		case "RoleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleName = ptr.String(jtv)
			}

		case "RolePolicyList":
			if err := awsRestjson1_deserializeDocumentAwsIamRolePolicyList(&sv.RolePolicyList, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamRolePolicy(v **types.AwsIamRolePolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamRolePolicy
	if *v == nil {
		sv = &types.AwsIamRolePolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamRolePolicyList(v *[]types.AwsIamRolePolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamRolePolicy
	if *v == nil {
		cv = []types.AwsIamRolePolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamRolePolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamRolePolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamUserDetails(v **types.AwsIamUserDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamUserDetails
	if *v == nil {
		sv = &types.AwsIamUserDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AttachedManagedPolicies":
			if err := awsRestjson1_deserializeDocumentAwsIamAttachedManagedPolicyList(&sv.AttachedManagedPolicies, value); err != nil {
				return err
			}

		case "CreateDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreateDate = ptr.String(jtv)
			}

		case "GroupList":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.GroupList, value); err != nil {
				return err
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "PermissionsBoundary":
			if err := awsRestjson1_deserializeDocumentAwsIamPermissionsBoundary(&sv.PermissionsBoundary, value); err != nil {
				return err
			}

		case "UserId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserId = ptr.String(jtv)
			}

		case "UserName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UserName = ptr.String(jtv)
			}

		case "UserPolicyList":
			if err := awsRestjson1_deserializeDocumentAwsIamUserPolicyList(&sv.UserPolicyList, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamUserPolicy(v **types.AwsIamUserPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsIamUserPolicy
	if *v == nil {
		sv = &types.AwsIamUserPolicy{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "PolicyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PolicyName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsIamUserPolicyList(v *[]types.AwsIamUserPolicy, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsIamUserPolicy
	if *v == nil {
		cv = []types.AwsIamUserPolicy{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsIamUserPolicy
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsIamUserPolicy(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsKmsKeyDetails(v **types.AwsKmsKeyDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsKmsKeyDetails
	if *v == nil {
		sv = &types.AwsKmsKeyDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AWSAccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AWSAccountId = ptr.String(jtv)
			}

		case "CreationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.CreationDate = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "KeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyId = ptr.String(jtv)
			}

		case "KeyManager":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyManager = ptr.String(jtv)
			}

		case "KeyRotationStatus":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.KeyRotationStatus = jtv
			}

		case "KeyState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyState = ptr.String(jtv)
			}

		case "Origin":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Origin = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionCode(v **types.AwsLambdaFunctionCode, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionCode
	if *v == nil {
		sv = &types.AwsLambdaFunctionCode{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "S3Bucket":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3Bucket = ptr.String(jtv)
			}

		case "S3Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3Key = ptr.String(jtv)
			}

		case "S3ObjectVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.S3ObjectVersion = ptr.String(jtv)
			}

		case "ZipFile":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ZipFile = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionDeadLetterConfig(v **types.AwsLambdaFunctionDeadLetterConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionDeadLetterConfig
	if *v == nil {
		sv = &types.AwsLambdaFunctionDeadLetterConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "TargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TargetArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionDetails(v **types.AwsLambdaFunctionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionDetails
	if *v == nil {
		sv = &types.AwsLambdaFunctionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionCode(&sv.Code, value); err != nil {
				return err
			}

		case "CodeSha256":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CodeSha256 = ptr.String(jtv)
			}

		case "DeadLetterConfig":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionDeadLetterConfig(&sv.DeadLetterConfig, value); err != nil {
				return err
			}

		case "Environment":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionEnvironment(&sv.Environment, value); err != nil {
				return err
			}

		case "FunctionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FunctionName = ptr.String(jtv)
			}

		case "Handler":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Handler = ptr.String(jtv)
			}

		case "KmsKeyArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyArn = ptr.String(jtv)
			}

		case "LastModified":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastModified = ptr.String(jtv)
			}

		case "Layers":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionLayerList(&sv.Layers, value); err != nil {
				return err
			}

		case "MasterArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterArn = ptr.String(jtv)
			}

		case "MemorySize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MemorySize = int32(i64)
			}

		case "RevisionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RevisionId = ptr.String(jtv)
			}

		case "Role":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Role = ptr.String(jtv)
			}

		case "Runtime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Runtime = ptr.String(jtv)
			}

		case "Timeout":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Timeout = int32(i64)
			}

		case "TracingConfig":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionTracingConfig(&sv.TracingConfig, value); err != nil {
				return err
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		case "VpcConfig":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionVpcConfig(&sv.VpcConfig, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionEnvironment(v **types.AwsLambdaFunctionEnvironment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionEnvironment
	if *v == nil {
		sv = &types.AwsLambdaFunctionEnvironment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Error":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionEnvironmentError(&sv.Error, value); err != nil {
				return err
			}

		case "Variables":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Variables, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionEnvironmentError(v **types.AwsLambdaFunctionEnvironmentError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionEnvironmentError
	if *v == nil {
		sv = &types.AwsLambdaFunctionEnvironmentError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ErrorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ErrorCode = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionLayer(v **types.AwsLambdaFunctionLayer, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionLayer
	if *v == nil {
		sv = &types.AwsLambdaFunctionLayer{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "CodeSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CodeSize = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionLayerList(v *[]types.AwsLambdaFunctionLayer, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsLambdaFunctionLayer
	if *v == nil {
		cv = []types.AwsLambdaFunctionLayer{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsLambdaFunctionLayer
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionLayer(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionTracingConfig(v **types.AwsLambdaFunctionTracingConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionTracingConfig
	if *v == nil {
		sv = &types.AwsLambdaFunctionTracingConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Mode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Mode = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaFunctionVpcConfig(v **types.AwsLambdaFunctionVpcConfig, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaFunctionVpcConfig
	if *v == nil {
		sv = &types.AwsLambdaFunctionVpcConfig{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SecurityGroupIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SecurityGroupIds, value); err != nil {
				return err
			}

		case "SubnetIds":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SubnetIds, value); err != nil {
				return err
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsLambdaLayerVersionDetails(v **types.AwsLambdaLayerVersionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsLambdaLayerVersionDetails
	if *v == nil {
		sv = &types.AwsLambdaLayerVersionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CompatibleRuntimes":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.CompatibleRuntimes, value); err != nil {
				return err
			}

		case "CreatedDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedDate = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected AwsLambdaLayerVersionNumber to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Version = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterAssociatedRole(v **types.AwsRdsDbClusterAssociatedRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbClusterAssociatedRole
	if *v == nil {
		sv = &types.AwsRdsDbClusterAssociatedRole{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterAssociatedRoles(v *[]types.AwsRdsDbClusterAssociatedRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbClusterAssociatedRole
	if *v == nil {
		cv = []types.AwsRdsDbClusterAssociatedRole{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbClusterAssociatedRole
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterAssociatedRole(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterDetails(v **types.AwsRdsDbClusterDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbClusterDetails
	if *v == nil {
		sv = &types.AwsRdsDbClusterDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActivityStreamStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActivityStreamStatus = ptr.String(jtv)
			}

		case "AllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AllocatedStorage = int32(i64)
			}

		case "AssociatedRoles":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterAssociatedRoles(&sv.AssociatedRoles, value); err != nil {
				return err
			}

		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "BackupRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BackupRetentionPeriod = int32(i64)
			}

		case "ClusterCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterCreateTime = ptr.String(jtv)
			}

		case "CopyTagsToSnapshot":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CopyTagsToSnapshot = jtv
			}

		case "CrossAccountClone":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CrossAccountClone = jtv
			}

		case "CustomEndpoints":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.CustomEndpoints, value); err != nil {
				return err
			}

		case "DatabaseName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DatabaseName = ptr.String(jtv)
			}

		case "DbClusterIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterIdentifier = ptr.String(jtv)
			}

		case "DbClusterMembers":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterMembers(&sv.DbClusterMembers, value); err != nil {
				return err
			}

		case "DbClusterOptionGroupMemberships":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterOptionGroupMemberships(&sv.DbClusterOptionGroupMemberships, value); err != nil {
				return err
			}

		case "DbClusterParameterGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterParameterGroup = ptr.String(jtv)
			}

		case "DbClusterResourceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterResourceId = ptr.String(jtv)
			}

		case "DbSubnetGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbSubnetGroup = ptr.String(jtv)
			}

		case "DeletionProtection":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeletionProtection = jtv
			}

		case "DomainMemberships":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbDomainMemberships(&sv.DomainMemberships, value); err != nil {
				return err
			}

		case "EnabledCloudWatchLogsExports":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.EnabledCloudWatchLogsExports, value); err != nil {
				return err
			}

		case "Endpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Endpoint = ptr.String(jtv)
			}

		case "Engine":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Engine = ptr.String(jtv)
			}

		case "EngineMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineMode = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "HostedZoneId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostedZoneId = ptr.String(jtv)
			}

		case "HttpEndpointEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.HttpEndpointEnabled = jtv
			}

		case "IamDatabaseAuthenticationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IamDatabaseAuthenticationEnabled = jtv
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "MasterUsername":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUsername = ptr.String(jtv)
			}

		case "MultiAz":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MultiAz = jtv
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "PreferredBackupWindow":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreferredBackupWindow = ptr.String(jtv)
			}

		case "PreferredMaintenanceWindow":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreferredMaintenanceWindow = ptr.String(jtv)
			}

		case "ReaderEndpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReaderEndpoint = ptr.String(jtv)
			}

		case "ReadReplicaIdentifiers":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.ReadReplicaIdentifiers, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StorageEncrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StorageEncrypted = jtv
			}

		case "VpcSecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceVpcSecurityGroups(&sv.VpcSecurityGroups, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterMember(v **types.AwsRdsDbClusterMember, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbClusterMember
	if *v == nil {
		sv = &types.AwsRdsDbClusterMember{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DbClusterParameterGroupStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterParameterGroupStatus = ptr.String(jtv)
			}

		case "DbInstanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbInstanceIdentifier = ptr.String(jtv)
			}

		case "IsClusterWriter":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IsClusterWriter = jtv
			}

		case "PromotionTier":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PromotionTier = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterMembers(v *[]types.AwsRdsDbClusterMember, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbClusterMember
	if *v == nil {
		cv = []types.AwsRdsDbClusterMember{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbClusterMember
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterMember(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterOptionGroupMembership(v **types.AwsRdsDbClusterOptionGroupMembership, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbClusterOptionGroupMembership
	if *v == nil {
		sv = &types.AwsRdsDbClusterOptionGroupMembership{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DbClusterOptionGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterOptionGroupName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterOptionGroupMemberships(v *[]types.AwsRdsDbClusterOptionGroupMembership, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbClusterOptionGroupMembership
	if *v == nil {
		cv = []types.AwsRdsDbClusterOptionGroupMembership{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbClusterOptionGroupMembership
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterOptionGroupMembership(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbClusterSnapshotDetails(v **types.AwsRdsDbClusterSnapshotDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbClusterSnapshotDetails
	if *v == nil {
		sv = &types.AwsRdsDbClusterSnapshotDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AllocatedStorage = int32(i64)
			}

		case "AvailabilityZones":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.AvailabilityZones, value); err != nil {
				return err
			}

		case "ClusterCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterCreateTime = ptr.String(jtv)
			}

		case "DbClusterIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterIdentifier = ptr.String(jtv)
			}

		case "DbClusterSnapshotIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbClusterSnapshotIdentifier = ptr.String(jtv)
			}

		case "Engine":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Engine = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "IamDatabaseAuthenticationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IamDatabaseAuthenticationEnabled = jtv
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LicenseModel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LicenseModel = ptr.String(jtv)
			}

		case "MasterUsername":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUsername = ptr.String(jtv)
			}

		case "PercentProgress":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PercentProgress = int32(i64)
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "SnapshotCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotCreateTime = ptr.String(jtv)
			}

		case "SnapshotType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotType = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StorageEncrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StorageEncrypted = jtv
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbDomainMembership(v **types.AwsRdsDbDomainMembership, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbDomainMembership
	if *v == nil {
		sv = &types.AwsRdsDbDomainMembership{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Domain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Domain = ptr.String(jtv)
			}

		case "Fqdn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Fqdn = ptr.String(jtv)
			}

		case "IamRoleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamRoleName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbDomainMemberships(v *[]types.AwsRdsDbDomainMembership, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbDomainMembership
	if *v == nil {
		cv = []types.AwsRdsDbDomainMembership{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbDomainMembership
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbDomainMembership(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbInstanceAssociatedRole(v **types.AwsRdsDbInstanceAssociatedRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbInstanceAssociatedRole
	if *v == nil {
		sv = &types.AwsRdsDbInstanceAssociatedRole{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FeatureName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FeatureName = ptr.String(jtv)
			}

		case "RoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RoleArn = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbInstanceAssociatedRoles(v *[]types.AwsRdsDbInstanceAssociatedRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbInstanceAssociatedRole
	if *v == nil {
		cv = []types.AwsRdsDbInstanceAssociatedRole{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbInstanceAssociatedRole
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceAssociatedRole(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbInstanceDetails(v **types.AwsRdsDbInstanceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbInstanceDetails
	if *v == nil {
		sv = &types.AwsRdsDbInstanceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AllocatedStorage = int32(i64)
			}

		case "AssociatedRoles":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceAssociatedRoles(&sv.AssociatedRoles, value); err != nil {
				return err
			}

		case "AutoMinorVersionUpgrade":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AutoMinorVersionUpgrade = jtv
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "BackupRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BackupRetentionPeriod = int32(i64)
			}

		case "CACertificateIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CACertificateIdentifier = ptr.String(jtv)
			}

		case "CharacterSetName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CharacterSetName = ptr.String(jtv)
			}

		case "CopyTagsToSnapshot":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.CopyTagsToSnapshot = jtv
			}

		case "DBClusterIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DBClusterIdentifier = ptr.String(jtv)
			}

		case "DBInstanceClass":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DBInstanceClass = ptr.String(jtv)
			}

		case "DBInstanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DBInstanceIdentifier = ptr.String(jtv)
			}

		case "DbInstancePort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DbInstancePort = int32(i64)
			}

		case "DbInstanceStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbInstanceStatus = ptr.String(jtv)
			}

		case "DbiResourceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbiResourceId = ptr.String(jtv)
			}

		case "DBName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DBName = ptr.String(jtv)
			}

		case "DbParameterGroups":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbParameterGroups(&sv.DbParameterGroups, value); err != nil {
				return err
			}

		case "DbSecurityGroups":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.DbSecurityGroups, value); err != nil {
				return err
			}

		case "DbSubnetGroup":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroup(&sv.DbSubnetGroup, value); err != nil {
				return err
			}

		case "DeletionProtection":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.DeletionProtection = jtv
			}

		case "DomainMemberships":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbDomainMemberships(&sv.DomainMemberships, value); err != nil {
				return err
			}

		case "EnabledCloudWatchLogsExports":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.EnabledCloudWatchLogsExports, value); err != nil {
				return err
			}

		case "Endpoint":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceEndpoint(&sv.Endpoint, value); err != nil {
				return err
			}

		case "Engine":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Engine = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "EnhancedMonitoringResourceArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EnhancedMonitoringResourceArn = ptr.String(jtv)
			}

		case "IAMDatabaseAuthenticationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IAMDatabaseAuthenticationEnabled = jtv
			}

		case "InstanceCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceCreateTime = ptr.String(jtv)
			}

		case "Iops":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Iops = int32(i64)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LatestRestorableTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LatestRestorableTime = ptr.String(jtv)
			}

		case "LicenseModel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LicenseModel = ptr.String(jtv)
			}

		case "ListenerEndpoint":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceEndpoint(&sv.ListenerEndpoint, value); err != nil {
				return err
			}

		case "MasterUsername":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUsername = ptr.String(jtv)
			}

		case "MaxAllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MaxAllocatedStorage = int32(i64)
			}

		case "MonitoringInterval":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MonitoringInterval = int32(i64)
			}

		case "MonitoringRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MonitoringRoleArn = ptr.String(jtv)
			}

		case "MultiAz":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MultiAz = jtv
			}

		case "OptionGroupMemberships":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbOptionGroupMemberships(&sv.OptionGroupMemberships, value); err != nil {
				return err
			}

		case "PendingModifiedValues":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbPendingModifiedValues(&sv.PendingModifiedValues, value); err != nil {
				return err
			}

		case "PerformanceInsightsEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PerformanceInsightsEnabled = jtv
			}

		case "PerformanceInsightsKmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PerformanceInsightsKmsKeyId = ptr.String(jtv)
			}

		case "PerformanceInsightsRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PerformanceInsightsRetentionPeriod = int32(i64)
			}

		case "PreferredBackupWindow":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreferredBackupWindow = ptr.String(jtv)
			}

		case "PreferredMaintenanceWindow":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreferredMaintenanceWindow = ptr.String(jtv)
			}

		case "ProcessorFeatures":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbProcessorFeatures(&sv.ProcessorFeatures, value); err != nil {
				return err
			}

		case "PromotionTier":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PromotionTier = int32(i64)
			}

		case "PubliclyAccessible":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PubliclyAccessible = jtv
			}

		case "ReadReplicaDBClusterIdentifiers":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.ReadReplicaDBClusterIdentifiers, value); err != nil {
				return err
			}

		case "ReadReplicaDBInstanceIdentifiers":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.ReadReplicaDBInstanceIdentifiers, value); err != nil {
				return err
			}

		case "ReadReplicaSourceDBInstanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReadReplicaSourceDBInstanceIdentifier = ptr.String(jtv)
			}

		case "SecondaryAvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SecondaryAvailabilityZone = ptr.String(jtv)
			}

		case "StatusInfos":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbStatusInfos(&sv.StatusInfos, value); err != nil {
				return err
			}

		case "StorageEncrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.StorageEncrypted = jtv
			}

		case "StorageType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageType = ptr.String(jtv)
			}

		case "TdeCredentialArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TdeCredentialArn = ptr.String(jtv)
			}

		case "Timezone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Timezone = ptr.String(jtv)
			}

		case "VpcSecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceVpcSecurityGroups(&sv.VpcSecurityGroups, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbInstanceEndpoint(v **types.AwsRdsDbInstanceEndpoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbInstanceEndpoint
	if *v == nil {
		sv = &types.AwsRdsDbInstanceEndpoint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Address = ptr.String(jtv)
			}

		case "HostedZoneId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HostedZoneId = ptr.String(jtv)
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbInstanceVpcSecurityGroup(v **types.AwsRdsDbInstanceVpcSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbInstanceVpcSecurityGroup
	if *v == nil {
		sv = &types.AwsRdsDbInstanceVpcSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "VpcSecurityGroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcSecurityGroupId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbInstanceVpcSecurityGroups(v *[]types.AwsRdsDbInstanceVpcSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbInstanceVpcSecurityGroup
	if *v == nil {
		cv = []types.AwsRdsDbInstanceVpcSecurityGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbInstanceVpcSecurityGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceVpcSecurityGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbOptionGroupMembership(v **types.AwsRdsDbOptionGroupMembership, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbOptionGroupMembership
	if *v == nil {
		sv = &types.AwsRdsDbOptionGroupMembership{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "OptionGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OptionGroupName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbOptionGroupMemberships(v *[]types.AwsRdsDbOptionGroupMembership, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbOptionGroupMembership
	if *v == nil {
		cv = []types.AwsRdsDbOptionGroupMembership{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbOptionGroupMembership
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbOptionGroupMembership(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbParameterGroup(v **types.AwsRdsDbParameterGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbParameterGroup
	if *v == nil {
		sv = &types.AwsRdsDbParameterGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DbParameterGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbParameterGroupName = ptr.String(jtv)
			}

		case "ParameterApplyStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ParameterApplyStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbParameterGroups(v *[]types.AwsRdsDbParameterGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbParameterGroup
	if *v == nil {
		cv = []types.AwsRdsDbParameterGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbParameterGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbParameterGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbPendingModifiedValues(v **types.AwsRdsDbPendingModifiedValues, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbPendingModifiedValues
	if *v == nil {
		sv = &types.AwsRdsDbPendingModifiedValues{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AllocatedStorage = int32(i64)
			}

		case "BackupRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.BackupRetentionPeriod = int32(i64)
			}

		case "CaCertificateIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CaCertificateIdentifier = ptr.String(jtv)
			}

		case "DbInstanceClass":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbInstanceClass = ptr.String(jtv)
			}

		case "DbInstanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbInstanceIdentifier = ptr.String(jtv)
			}

		case "DbSubnetGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbSubnetGroupName = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "Iops":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Iops = int32(i64)
			}

		case "LicenseModel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LicenseModel = ptr.String(jtv)
			}

		case "MasterUserPassword":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUserPassword = ptr.String(jtv)
			}

		case "MultiAZ":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.MultiAZ = jtv
			}

		case "PendingCloudWatchLogsExports":
			if err := awsRestjson1_deserializeDocumentAwsRdsPendingCloudWatchLogsExports(&sv.PendingCloudWatchLogsExports, value); err != nil {
				return err
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "ProcessorFeatures":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbProcessorFeatures(&sv.ProcessorFeatures, value); err != nil {
				return err
			}

		case "StorageType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbProcessorFeature(v **types.AwsRdsDbProcessorFeature, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbProcessorFeature
	if *v == nil {
		sv = &types.AwsRdsDbProcessorFeature{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbProcessorFeatures(v *[]types.AwsRdsDbProcessorFeature, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbProcessorFeature
	if *v == nil {
		cv = []types.AwsRdsDbProcessorFeature{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbProcessorFeature
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbProcessorFeature(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbSnapshotDetails(v **types.AwsRdsDbSnapshotDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbSnapshotDetails
	if *v == nil {
		sv = &types.AwsRdsDbSnapshotDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllocatedStorage":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AllocatedStorage = int32(i64)
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "DbInstanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbInstanceIdentifier = ptr.String(jtv)
			}

		case "DbiResourceId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbiResourceId = ptr.String(jtv)
			}

		case "DbSnapshotIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbSnapshotIdentifier = ptr.String(jtv)
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = jtv
			}

		case "Engine":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Engine = ptr.String(jtv)
			}

		case "EngineVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EngineVersion = ptr.String(jtv)
			}

		case "IamDatabaseAuthenticationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IamDatabaseAuthenticationEnabled = jtv
			}

		case "InstanceCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InstanceCreateTime = ptr.String(jtv)
			}

		case "Iops":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Iops = int32(i64)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "LicenseModel":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LicenseModel = ptr.String(jtv)
			}

		case "MasterUsername":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUsername = ptr.String(jtv)
			}

		case "OptionGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OptionGroupName = ptr.String(jtv)
			}

		case "PercentProgress":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PercentProgress = int32(i64)
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		case "ProcessorFeatures":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbProcessorFeatures(&sv.ProcessorFeatures, value); err != nil {
				return err
			}

		case "SnapshotCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotCreateTime = ptr.String(jtv)
			}

		case "SnapshotType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotType = ptr.String(jtv)
			}

		case "SourceDbSnapshotIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceDbSnapshotIdentifier = ptr.String(jtv)
			}

		case "SourceRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceRegion = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StorageType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageType = ptr.String(jtv)
			}

		case "TdeCredentialArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TdeCredentialArn = ptr.String(jtv)
			}

		case "Timezone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Timezone = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbStatusInfo(v **types.AwsRdsDbStatusInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbStatusInfo
	if *v == nil {
		sv = &types.AwsRdsDbStatusInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "Normal":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Normal = jtv
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "StatusType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StatusType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbStatusInfos(v *[]types.AwsRdsDbStatusInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbStatusInfo
	if *v == nil {
		cv = []types.AwsRdsDbStatusInfo{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbStatusInfo
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbStatusInfo(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroup(v **types.AwsRdsDbSubnetGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbSubnetGroup
	if *v == nil {
		sv = &types.AwsRdsDbSubnetGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DbSubnetGroupArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbSubnetGroupArn = ptr.String(jtv)
			}

		case "DbSubnetGroupDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbSubnetGroupDescription = ptr.String(jtv)
			}

		case "DbSubnetGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DbSubnetGroupName = ptr.String(jtv)
			}

		case "SubnetGroupStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetGroupStatus = ptr.String(jtv)
			}

		case "Subnets":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroupSubnets(&sv.Subnets, value); err != nil {
				return err
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroupSubnet(v **types.AwsRdsDbSubnetGroupSubnet, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbSubnetGroupSubnet
	if *v == nil {
		sv = &types.AwsRdsDbSubnetGroupSubnet{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "SubnetAvailabilityZone":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroupSubnetAvailabilityZone(&sv.SubnetAvailabilityZone, value); err != nil {
				return err
			}

		case "SubnetIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetIdentifier = ptr.String(jtv)
			}

		case "SubnetStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubnetStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroupSubnetAvailabilityZone(v **types.AwsRdsDbSubnetGroupSubnetAvailabilityZone, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsDbSubnetGroupSubnetAvailabilityZone
	if *v == nil {
		sv = &types.AwsRdsDbSubnetGroupSubnetAvailabilityZone{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroupSubnets(v *[]types.AwsRdsDbSubnetGroupSubnet, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRdsDbSubnetGroupSubnet
	if *v == nil {
		cv = []types.AwsRdsDbSubnetGroupSubnet{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRdsDbSubnetGroupSubnet
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRdsDbSubnetGroupSubnet(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsEventSubscriptionDetails(v **types.AwsRdsEventSubscriptionDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsEventSubscriptionDetails
	if *v == nil {
		sv = &types.AwsRdsEventSubscriptionDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CustomerAwsId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CustomerAwsId = ptr.String(jtv)
			}

		case "CustSubscriptionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CustSubscriptionId = ptr.String(jtv)
			}

		case "Enabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Enabled = jtv
			}

		case "EventCategoriesList":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.EventCategoriesList, value); err != nil {
				return err
			}

		case "EventSubscriptionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EventSubscriptionArn = ptr.String(jtv)
			}

		case "SnsTopicArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnsTopicArn = ptr.String(jtv)
			}

		case "SourceIdsList":
			if err := awsRestjson1_deserializeDocumentNonEmptyStringList(&sv.SourceIdsList, value); err != nil {
				return err
			}

		case "SourceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceType = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "SubscriptionCreationTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SubscriptionCreationTime = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRdsPendingCloudWatchLogsExports(v **types.AwsRdsPendingCloudWatchLogsExports, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRdsPendingCloudWatchLogsExports
	if *v == nil {
		sv = &types.AwsRdsPendingCloudWatchLogsExports{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LogTypesToDisable":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.LogTypesToDisable, value); err != nil {
				return err
			}

		case "LogTypesToEnable":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.LogTypesToEnable, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterNode(v **types.AwsRedshiftClusterClusterNode, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterClusterNode
	if *v == nil {
		sv = &types.AwsRedshiftClusterClusterNode{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "NodeRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NodeRole = ptr.String(jtv)
			}

		case "PrivateIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PrivateIpAddress = ptr.String(jtv)
			}

		case "PublicIpAddress":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PublicIpAddress = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterNodes(v *[]types.AwsRedshiftClusterClusterNode, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterClusterNode
	if *v == nil {
		cv = []types.AwsRedshiftClusterClusterNode{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterClusterNode
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterNode(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterGroup(v **types.AwsRedshiftClusterClusterParameterGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterClusterParameterGroup
	if *v == nil {
		sv = &types.AwsRedshiftClusterClusterParameterGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ClusterParameterStatusList":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterStatusList(&sv.ClusterParameterStatusList, value); err != nil {
				return err
			}

		case "ParameterApplyStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ParameterApplyStatus = ptr.String(jtv)
			}

		case "ParameterGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ParameterGroupName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterGroups(v *[]types.AwsRedshiftClusterClusterParameterGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterClusterParameterGroup
	if *v == nil {
		cv = []types.AwsRedshiftClusterClusterParameterGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterClusterParameterGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterStatus(v **types.AwsRedshiftClusterClusterParameterStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterClusterParameterStatus
	if *v == nil {
		sv = &types.AwsRedshiftClusterClusterParameterStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ParameterApplyErrorDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ParameterApplyErrorDescription = ptr.String(jtv)
			}

		case "ParameterApplyStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ParameterApplyStatus = ptr.String(jtv)
			}

		case "ParameterName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ParameterName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterStatusList(v *[]types.AwsRedshiftClusterClusterParameterStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterClusterParameterStatus
	if *v == nil {
		cv = []types.AwsRedshiftClusterClusterParameterStatus{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterClusterParameterStatus
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterStatus(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterSecurityGroup(v **types.AwsRedshiftClusterClusterSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterClusterSecurityGroup
	if *v == nil {
		sv = &types.AwsRedshiftClusterClusterSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ClusterSecurityGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterSecurityGroupName = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterSecurityGroups(v *[]types.AwsRedshiftClusterClusterSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterClusterSecurityGroup
	if *v == nil {
		cv = []types.AwsRedshiftClusterClusterSecurityGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterClusterSecurityGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterSecurityGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterSnapshotCopyStatus(v **types.AwsRedshiftClusterClusterSnapshotCopyStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterClusterSnapshotCopyStatus
	if *v == nil {
		sv = &types.AwsRedshiftClusterClusterSnapshotCopyStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationRegion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationRegion = ptr.String(jtv)
			}

		case "ManualSnapshotRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ManualSnapshotRetentionPeriod = int32(i64)
			}

		case "RetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RetentionPeriod = int32(i64)
			}

		case "SnapshotCopyGrantName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotCopyGrantName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterDeferredMaintenanceWindow(v **types.AwsRedshiftClusterDeferredMaintenanceWindow, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterDeferredMaintenanceWindow
	if *v == nil {
		sv = &types.AwsRedshiftClusterDeferredMaintenanceWindow{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeferMaintenanceEndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeferMaintenanceEndTime = ptr.String(jtv)
			}

		case "DeferMaintenanceIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeferMaintenanceIdentifier = ptr.String(jtv)
			}

		case "DeferMaintenanceStartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeferMaintenanceStartTime = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterDeferredMaintenanceWindows(v *[]types.AwsRedshiftClusterDeferredMaintenanceWindow, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterDeferredMaintenanceWindow
	if *v == nil {
		cv = []types.AwsRedshiftClusterDeferredMaintenanceWindow{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterDeferredMaintenanceWindow
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterDeferredMaintenanceWindow(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterDetails(v **types.AwsRedshiftClusterDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterDetails
	if *v == nil {
		sv = &types.AwsRedshiftClusterDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllowVersionUpgrade":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AllowVersionUpgrade = jtv
			}

		case "AutomatedSnapshotRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AutomatedSnapshotRetentionPeriod = int32(i64)
			}

		case "AvailabilityZone":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AvailabilityZone = ptr.String(jtv)
			}

		case "ClusterAvailabilityStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterAvailabilityStatus = ptr.String(jtv)
			}

		case "ClusterCreateTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterCreateTime = ptr.String(jtv)
			}

		case "ClusterIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterIdentifier = ptr.String(jtv)
			}

		case "ClusterNodes":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterNodes(&sv.ClusterNodes, value); err != nil {
				return err
			}

		case "ClusterParameterGroups":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterParameterGroups(&sv.ClusterParameterGroups, value); err != nil {
				return err
			}

		case "ClusterPublicKey":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterPublicKey = ptr.String(jtv)
			}

		case "ClusterRevisionNumber":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterRevisionNumber = ptr.String(jtv)
			}

		case "ClusterSecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterSecurityGroups(&sv.ClusterSecurityGroups, value); err != nil {
				return err
			}

		case "ClusterSnapshotCopyStatus":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterClusterSnapshotCopyStatus(&sv.ClusterSnapshotCopyStatus, value); err != nil {
				return err
			}

		case "ClusterStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterStatus = ptr.String(jtv)
			}

		case "ClusterSubnetGroupName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterSubnetGroupName = ptr.String(jtv)
			}

		case "ClusterVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterVersion = ptr.String(jtv)
			}

		case "DBName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DBName = ptr.String(jtv)
			}

		case "DeferredMaintenanceWindows":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterDeferredMaintenanceWindows(&sv.DeferredMaintenanceWindows, value); err != nil {
				return err
			}

		case "ElasticIpStatus":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterElasticIpStatus(&sv.ElasticIpStatus, value); err != nil {
				return err
			}

		case "ElasticResizeNumberOfNodeOptions":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ElasticResizeNumberOfNodeOptions = ptr.String(jtv)
			}

		case "Encrypted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Encrypted = jtv
			}

		case "Endpoint":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterEndpoint(&sv.Endpoint, value); err != nil {
				return err
			}

		case "EnhancedVpcRouting":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnhancedVpcRouting = jtv
			}

		case "ExpectedNextSnapshotScheduleTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExpectedNextSnapshotScheduleTime = ptr.String(jtv)
			}

		case "ExpectedNextSnapshotScheduleTimeStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExpectedNextSnapshotScheduleTimeStatus = ptr.String(jtv)
			}

		case "HsmStatus":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterHsmStatus(&sv.HsmStatus, value); err != nil {
				return err
			}

		case "IamRoles":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterIamRoles(&sv.IamRoles, value); err != nil {
				return err
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "MaintenanceTrackName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MaintenanceTrackName = ptr.String(jtv)
			}

		case "ManualSnapshotRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ManualSnapshotRetentionPeriod = int32(i64)
			}

		case "MasterUsername":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUsername = ptr.String(jtv)
			}

		case "NextMaintenanceWindowStartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NextMaintenanceWindowStartTime = ptr.String(jtv)
			}

		case "NodeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NodeType = ptr.String(jtv)
			}

		case "NumberOfNodes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfNodes = int32(i64)
			}

		case "PendingActions":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.PendingActions, value); err != nil {
				return err
			}

		case "PendingModifiedValues":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterPendingModifiedValues(&sv.PendingModifiedValues, value); err != nil {
				return err
			}

		case "PreferredMaintenanceWindow":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PreferredMaintenanceWindow = ptr.String(jtv)
			}

		case "PubliclyAccessible":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PubliclyAccessible = jtv
			}

		case "ResizeInfo":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterResizeInfo(&sv.ResizeInfo, value); err != nil {
				return err
			}

		case "RestoreStatus":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterRestoreStatus(&sv.RestoreStatus, value); err != nil {
				return err
			}

		case "SnapshotScheduleIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotScheduleIdentifier = ptr.String(jtv)
			}

		case "SnapshotScheduleState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SnapshotScheduleState = ptr.String(jtv)
			}

		case "VpcId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcId = ptr.String(jtv)
			}

		case "VpcSecurityGroups":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterVpcSecurityGroups(&sv.VpcSecurityGroups, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterElasticIpStatus(v **types.AwsRedshiftClusterElasticIpStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterElasticIpStatus
	if *v == nil {
		sv = &types.AwsRedshiftClusterElasticIpStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ElasticIp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ElasticIp = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterEndpoint(v **types.AwsRedshiftClusterEndpoint, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterEndpoint
	if *v == nil {
		sv = &types.AwsRedshiftClusterEndpoint{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Address":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Address = ptr.String(jtv)
			}

		case "Port":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Port = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterHsmStatus(v **types.AwsRedshiftClusterHsmStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterHsmStatus
	if *v == nil {
		sv = &types.AwsRedshiftClusterHsmStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HsmClientCertificateIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HsmClientCertificateIdentifier = ptr.String(jtv)
			}

		case "HsmConfigurationIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HsmConfigurationIdentifier = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterIamRole(v **types.AwsRedshiftClusterIamRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterIamRole
	if *v == nil {
		sv = &types.AwsRedshiftClusterIamRole{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplyStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ApplyStatus = ptr.String(jtv)
			}

		case "IamRoleArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IamRoleArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterIamRoles(v *[]types.AwsRedshiftClusterIamRole, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterIamRole
	if *v == nil {
		cv = []types.AwsRedshiftClusterIamRole{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterIamRole
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterIamRole(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterPendingModifiedValues(v **types.AwsRedshiftClusterPendingModifiedValues, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterPendingModifiedValues
	if *v == nil {
		sv = &types.AwsRedshiftClusterPendingModifiedValues{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutomatedSnapshotRetentionPeriod":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AutomatedSnapshotRetentionPeriod = int32(i64)
			}

		case "ClusterIdentifier":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterIdentifier = ptr.String(jtv)
			}

		case "ClusterType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterType = ptr.String(jtv)
			}

		case "ClusterVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ClusterVersion = ptr.String(jtv)
			}

		case "EncryptionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.EncryptionType = ptr.String(jtv)
			}

		case "EnhancedVpcRouting":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnhancedVpcRouting = jtv
			}

		case "MaintenanceTrackName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MaintenanceTrackName = ptr.String(jtv)
			}

		case "MasterUserPassword":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterUserPassword = ptr.String(jtv)
			}

		case "NodeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.NodeType = ptr.String(jtv)
			}

		case "NumberOfNodes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfNodes = int32(i64)
			}

		case "PubliclyAccessible":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.PubliclyAccessible = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterResizeInfo(v **types.AwsRedshiftClusterResizeInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterResizeInfo
	if *v == nil {
		sv = &types.AwsRedshiftClusterResizeInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AllowCancelResize":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AllowCancelResize = jtv
			}

		case "ResizeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResizeType = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterRestoreStatus(v **types.AwsRedshiftClusterRestoreStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterRestoreStatus
	if *v == nil {
		sv = &types.AwsRedshiftClusterRestoreStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CurrentRestoreRateInMegaBytesPerSecond":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CurrentRestoreRateInMegaBytesPerSecond = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.CurrentRestoreRateInMegaBytesPerSecond = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "ElapsedTimeInSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ElapsedTimeInSeconds = i64
			}

		case "EstimatedTimeToCompletionInSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EstimatedTimeToCompletionInSeconds = i64
			}

		case "ProgressInMegaBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ProgressInMegaBytes = i64
			}

		case "SnapshotSizeInMegaBytes":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SnapshotSizeInMegaBytes = i64
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterVpcSecurityGroup(v **types.AwsRedshiftClusterVpcSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsRedshiftClusterVpcSecurityGroup
	if *v == nil {
		sv = &types.AwsRedshiftClusterVpcSecurityGroup{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "VpcSecurityGroupId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VpcSecurityGroupId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsRedshiftClusterVpcSecurityGroups(v *[]types.AwsRedshiftClusterVpcSecurityGroup, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsRedshiftClusterVpcSecurityGroup
	if *v == nil {
		cv = []types.AwsRedshiftClusterVpcSecurityGroup{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsRedshiftClusterVpcSecurityGroup
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterVpcSecurityGroup(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3AccountPublicAccessBlockDetails(v **types.AwsS3AccountPublicAccessBlockDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3AccountPublicAccessBlockDetails
	if *v == nil {
		sv = &types.AwsS3AccountPublicAccessBlockDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "BlockPublicAcls":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.BlockPublicAcls = jtv
			}

		case "BlockPublicPolicy":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.BlockPublicPolicy = jtv
			}

		case "IgnorePublicAcls":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.IgnorePublicAcls = jtv
			}

		case "RestrictPublicBuckets":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RestrictPublicBuckets = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationDetails(v **types.AwsS3BucketBucketLifecycleConfigurationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Rules":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesList(&sv.Rules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DaysAfterInitiation":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DaysAfterInitiation = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AbortIncompleteMultipartUpload":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesAbortIncompleteMultipartUploadDetails(&sv.AbortIncompleteMultipartUpload, value); err != nil {
				return err
			}

		case "ExpirationDate":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExpirationDate = ptr.String(jtv)
			}

		case "ExpirationInDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ExpirationInDays = int32(i64)
			}

		case "ExpiredObjectDeleteMarker":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.ExpiredObjectDeleteMarker = jtv
			}

		case "Filter":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(&sv.Filter, value); err != nil {
				return err
			}

		case "ID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ID = ptr.String(jtv)
			}

		case "NoncurrentVersionExpirationInDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NoncurrentVersionExpirationInDays = int32(i64)
			}

		case "NoncurrentVersionTransitions":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList(&sv.NoncurrentVersionTransitions, value); err != nil {
				return err
			}

		case "Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Prefix = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		case "Transitions":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsList(&sv.Transitions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesFilterDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Predicate":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(&sv.Predicate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Operands":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList(&sv.Operands, value); err != nil {
				return err
			}

		case "Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Prefix = ptr.String(jtv)
			}

		case "Tag":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails(&sv.Tag, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Prefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Prefix = ptr.String(jtv)
			}

		case "Tag":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails(&sv.Tag, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsList(v *[]types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
	if *v == nil {
		cv = []types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateTagDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesList(v *[]types.AwsS3BucketBucketLifecycleConfigurationRulesDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketBucketLifecycleConfigurationRulesDetails
	if *v == nil {
		cv = []types.AwsS3BucketBucketLifecycleConfigurationRulesDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketBucketLifecycleConfigurationRulesDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Days":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Days = int32(i64)
			}

		case "StorageClass":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageClass = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsList(v *[]types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
	if *v == nil {
		cv = []types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(v **types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
	if *v == nil {
		sv = &types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Date":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Date = ptr.String(jtv)
			}

		case "Days":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Days = int32(i64)
			}

		case "StorageClass":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StorageClass = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsList(v *[]types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
	if *v == nil {
		cv = []types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketDetails(v **types.AwsS3BucketDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketDetails
	if *v == nil {
		sv = &types.AwsS3BucketDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccessControlList":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AccessControlList = ptr.String(jtv)
			}

		case "BucketLifecycleConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketBucketLifecycleConfigurationDetails(&sv.BucketLifecycleConfiguration, value); err != nil {
				return err
			}

		case "BucketLoggingConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketLoggingConfiguration(&sv.BucketLoggingConfiguration, value); err != nil {
				return err
			}

		case "BucketNotificationConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfiguration(&sv.BucketNotificationConfiguration, value); err != nil {
				return err
			}

		case "BucketWebsiteConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfiguration(&sv.BucketWebsiteConfiguration, value); err != nil {
				return err
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "OwnerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerId = ptr.String(jtv)
			}

		case "OwnerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OwnerName = ptr.String(jtv)
			}

		case "PublicAccessBlockConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsS3AccountPublicAccessBlockDetails(&sv.PublicAccessBlockConfiguration, value); err != nil {
				return err
			}

		case "ServerSideEncryptionConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionConfiguration(&sv.ServerSideEncryptionConfiguration, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketLoggingConfiguration(v **types.AwsS3BucketLoggingConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketLoggingConfiguration
	if *v == nil {
		sv = &types.AwsS3BucketLoggingConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationBucketName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationBucketName = ptr.String(jtv)
			}

		case "LogFilePrefix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LogFilePrefix = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfiguration(v **types.AwsS3BucketNotificationConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketNotificationConfiguration
	if *v == nil {
		sv = &types.AwsS3BucketNotificationConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Configurations":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationDetails(&sv.Configurations, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationDetail(v **types.AwsS3BucketNotificationConfigurationDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketNotificationConfigurationDetail
	if *v == nil {
		sv = &types.AwsS3BucketNotificationConfigurationDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Destination":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Destination = ptr.String(jtv)
			}

		case "Events":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationEvents(&sv.Events, value); err != nil {
				return err
			}

		case "Filter":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationFilter(&sv.Filter, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationDetails(v *[]types.AwsS3BucketNotificationConfigurationDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketNotificationConfigurationDetail
	if *v == nil {
		cv = []types.AwsS3BucketNotificationConfigurationDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketNotificationConfigurationDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationEvents(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationFilter(v **types.AwsS3BucketNotificationConfigurationFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketNotificationConfigurationFilter
	if *v == nil {
		sv = &types.AwsS3BucketNotificationConfigurationFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "S3KeyFilter":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilter(&sv.S3KeyFilter, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilter(v **types.AwsS3BucketNotificationConfigurationS3KeyFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketNotificationConfigurationS3KeyFilter
	if *v == nil {
		sv = &types.AwsS3BucketNotificationConfigurationS3KeyFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FilterRules":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRules(&sv.FilterRules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRule(v **types.AwsS3BucketNotificationConfigurationS3KeyFilterRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketNotificationConfigurationS3KeyFilterRule
	if *v == nil {
		sv = &types.AwsS3BucketNotificationConfigurationS3KeyFilterRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AwsS3BucketNotificationConfigurationS3KeyFilterRuleName to be of type string, got %T instead", value)
				}
				sv.Name = types.AwsS3BucketNotificationConfigurationS3KeyFilterRuleName(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRules(v *[]types.AwsS3BucketNotificationConfigurationS3KeyFilterRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketNotificationConfigurationS3KeyFilterRule
	if *v == nil {
		cv = []types.AwsS3BucketNotificationConfigurationS3KeyFilterRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketNotificationConfigurationS3KeyFilterRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketNotificationConfigurationS3KeyFilterRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionByDefault(v **types.AwsS3BucketServerSideEncryptionByDefault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketServerSideEncryptionByDefault
	if *v == nil {
		sv = &types.AwsS3BucketServerSideEncryptionByDefault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "KMSMasterKeyID":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KMSMasterKeyID = ptr.String(jtv)
			}

		case "SSEAlgorithm":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SSEAlgorithm = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionConfiguration(v **types.AwsS3BucketServerSideEncryptionConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketServerSideEncryptionConfiguration
	if *v == nil {
		sv = &types.AwsS3BucketServerSideEncryptionConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Rules":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionRules(&sv.Rules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionRule(v **types.AwsS3BucketServerSideEncryptionRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketServerSideEncryptionRule
	if *v == nil {
		sv = &types.AwsS3BucketServerSideEncryptionRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ApplyServerSideEncryptionByDefault":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionByDefault(&sv.ApplyServerSideEncryptionByDefault, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionRules(v *[]types.AwsS3BucketServerSideEncryptionRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketServerSideEncryptionRule
	if *v == nil {
		cv = []types.AwsS3BucketServerSideEncryptionRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketServerSideEncryptionRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketServerSideEncryptionRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfiguration(v **types.AwsS3BucketWebsiteConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketWebsiteConfiguration
	if *v == nil {
		sv = &types.AwsS3BucketWebsiteConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ErrorDocument":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ErrorDocument = ptr.String(jtv)
			}

		case "IndexDocumentSuffix":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.IndexDocumentSuffix = ptr.String(jtv)
			}

		case "RedirectAllRequestsTo":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRedirectTo(&sv.RedirectAllRequestsTo, value); err != nil {
				return err
			}

		case "RoutingRules":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRules(&sv.RoutingRules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRedirectTo(v **types.AwsS3BucketWebsiteConfigurationRedirectTo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketWebsiteConfigurationRedirectTo
	if *v == nil {
		sv = &types.AwsS3BucketWebsiteConfigurationRedirectTo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Hostname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Hostname = ptr.String(jtv)
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRule(v **types.AwsS3BucketWebsiteConfigurationRoutingRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketWebsiteConfigurationRoutingRule
	if *v == nil {
		sv = &types.AwsS3BucketWebsiteConfigurationRoutingRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Condition":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleCondition(&sv.Condition, value); err != nil {
				return err
			}

		case "Redirect":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleRedirect(&sv.Redirect, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleCondition(v **types.AwsS3BucketWebsiteConfigurationRoutingRuleCondition, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
	if *v == nil {
		sv = &types.AwsS3BucketWebsiteConfigurationRoutingRuleCondition{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "HttpErrorCodeReturnedEquals":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpErrorCodeReturnedEquals = ptr.String(jtv)
			}

		case "KeyPrefixEquals":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KeyPrefixEquals = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRuleRedirect(v **types.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect
	if *v == nil {
		sv = &types.AwsS3BucketWebsiteConfigurationRoutingRuleRedirect{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Hostname":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Hostname = ptr.String(jtv)
			}

		case "HttpRedirectCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.HttpRedirectCode = ptr.String(jtv)
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "ReplaceKeyPrefixWith":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplaceKeyPrefixWith = ptr.String(jtv)
			}

		case "ReplaceKeyWith":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReplaceKeyWith = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRules(v *[]types.AwsS3BucketWebsiteConfigurationRoutingRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsS3BucketWebsiteConfigurationRoutingRule
	if *v == nil {
		cv = []types.AwsS3BucketWebsiteConfigurationRoutingRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsS3BucketWebsiteConfigurationRoutingRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsS3BucketWebsiteConfigurationRoutingRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsS3ObjectDetails(v **types.AwsS3ObjectDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsS3ObjectDetails
	if *v == nil {
		sv = &types.AwsS3ObjectDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ContentType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ContentType = ptr.String(jtv)
			}

		case "ETag":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ETag = ptr.String(jtv)
			}

		case "LastModified":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastModified = ptr.String(jtv)
			}

		case "ServerSideEncryption":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ServerSideEncryption = ptr.String(jtv)
			}

		case "SSEKMSKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SSEKMSKeyId = ptr.String(jtv)
			}

		case "VersionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VersionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecretsManagerSecretDetails(v **types.AwsSecretsManagerSecretDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSecretsManagerSecretDetails
	if *v == nil {
		sv = &types.AwsSecretsManagerSecretDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Deleted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Deleted = jtv
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "KmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "RotationEnabled":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RotationEnabled = jtv
			}

		case "RotationLambdaArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RotationLambdaArn = ptr.String(jtv)
			}

		case "RotationOccurredWithinFrequency":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.RotationOccurredWithinFrequency = jtv
			}

		case "RotationRules":
			if err := awsRestjson1_deserializeDocumentAwsSecretsManagerSecretRotationRules(&sv.RotationRules, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecretsManagerSecretRotationRules(v **types.AwsSecretsManagerSecretRotationRules, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSecretsManagerSecretRotationRules
	if *v == nil {
		sv = &types.AwsSecretsManagerSecretRotationRules{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AutomaticallyAfterDays":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.AutomaticallyAfterDays = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecurityFinding(v **types.AwsSecurityFinding, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSecurityFinding
	if *v == nil {
		sv = &types.AwsSecurityFinding{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Action":
			if err := awsRestjson1_deserializeDocumentAction(&sv.Action, value); err != nil {
				return err
			}

		case "AwsAccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AwsAccountId = ptr.String(jtv)
			}

		case "CompanyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CompanyName = ptr.String(jtv)
			}

		case "Compliance":
			if err := awsRestjson1_deserializeDocumentCompliance(&sv.Compliance, value); err != nil {
				return err
			}

		case "Confidence":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Confidence = int32(i64)
			}

		case "CreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CreatedAt = ptr.String(jtv)
			}

		case "Criticality":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Criticality = int32(i64)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "FindingProviderFields":
			if err := awsRestjson1_deserializeDocumentFindingProviderFields(&sv.FindingProviderFields, value); err != nil {
				return err
			}

		case "FirstObservedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FirstObservedAt = ptr.String(jtv)
			}

		case "GeneratorId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GeneratorId = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "LastObservedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastObservedAt = ptr.String(jtv)
			}

		case "Malware":
			if err := awsRestjson1_deserializeDocumentMalwareList(&sv.Malware, value); err != nil {
				return err
			}

		case "Network":
			if err := awsRestjson1_deserializeDocumentNetwork(&sv.Network, value); err != nil {
				return err
			}

		case "NetworkPath":
			if err := awsRestjson1_deserializeDocumentNetworkPathList(&sv.NetworkPath, value); err != nil {
				return err
			}

		case "Note":
			if err := awsRestjson1_deserializeDocumentNote(&sv.Note, value); err != nil {
				return err
			}

		case "PatchSummary":
			if err := awsRestjson1_deserializeDocumentPatchSummary(&sv.PatchSummary, value); err != nil {
				return err
			}

		case "Process":
			if err := awsRestjson1_deserializeDocumentProcessDetails(&sv.Process, value); err != nil {
				return err
			}

		case "ProductArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductArn = ptr.String(jtv)
			}

		case "ProductFields":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.ProductFields, value); err != nil {
				return err
			}

		case "ProductName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductName = ptr.String(jtv)
			}

		case "RecordState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecordState to be of type string, got %T instead", value)
				}
				sv.RecordState = types.RecordState(jtv)
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		case "RelatedFindings":
			if err := awsRestjson1_deserializeDocumentRelatedFindingList(&sv.RelatedFindings, value); err != nil {
				return err
			}

		case "Remediation":
			if err := awsRestjson1_deserializeDocumentRemediation(&sv.Remediation, value); err != nil {
				return err
			}

		case "Resources":
			if err := awsRestjson1_deserializeDocumentResourceList(&sv.Resources, value); err != nil {
				return err
			}

		case "SchemaVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SchemaVersion = ptr.String(jtv)
			}

		case "Severity":
			if err := awsRestjson1_deserializeDocumentSeverity(&sv.Severity, value); err != nil {
				return err
			}

		case "SourceUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceUrl = ptr.String(jtv)
			}

		case "ThreatIntelIndicators":
			if err := awsRestjson1_deserializeDocumentThreatIntelIndicatorList(&sv.ThreatIntelIndicators, value); err != nil {
				return err
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		case "Types":
			if err := awsRestjson1_deserializeDocumentTypeList(&sv.Types, value); err != nil {
				return err
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdatedAt = ptr.String(jtv)
			}

		case "UserDefinedFields":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.UserDefinedFields, value); err != nil {
				return err
			}

		case "VerificationState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected VerificationState to be of type string, got %T instead", value)
				}
				sv.VerificationState = types.VerificationState(jtv)
			}

		case "Vulnerabilities":
			if err := awsRestjson1_deserializeDocumentVulnerabilityList(&sv.Vulnerabilities, value); err != nil {
				return err
			}

		case "Workflow":
			if err := awsRestjson1_deserializeDocumentWorkflow(&sv.Workflow, value); err != nil {
				return err
			}

		case "WorkflowState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowState to be of type string, got %T instead", value)
				}
				sv.WorkflowState = types.WorkflowState(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecurityFindingFilters(v **types.AwsSecurityFindingFilters, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSecurityFindingFilters
	if *v == nil {
		sv = &types.AwsSecurityFindingFilters{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AwsAccountId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.AwsAccountId, value); err != nil {
				return err
			}

		case "CompanyName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.CompanyName, value); err != nil {
				return err
			}

		case "ComplianceStatus":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ComplianceStatus, value); err != nil {
				return err
			}

		case "Confidence":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.Confidence, value); err != nil {
				return err
			}

		case "CreatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.CreatedAt, value); err != nil {
				return err
			}

		case "Criticality":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.Criticality, value); err != nil {
				return err
			}

		case "Description":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Description, value); err != nil {
				return err
			}

		case "FindingProviderFieldsConfidence":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.FindingProviderFieldsConfidence, value); err != nil {
				return err
			}

		case "FindingProviderFieldsCriticality":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.FindingProviderFieldsCriticality, value); err != nil {
				return err
			}

		case "FindingProviderFieldsRelatedFindingsId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.FindingProviderFieldsRelatedFindingsId, value); err != nil {
				return err
			}

		case "FindingProviderFieldsRelatedFindingsProductArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.FindingProviderFieldsRelatedFindingsProductArn, value); err != nil {
				return err
			}

		case "FindingProviderFieldsSeverityLabel":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.FindingProviderFieldsSeverityLabel, value); err != nil {
				return err
			}

		case "FindingProviderFieldsSeverityOriginal":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.FindingProviderFieldsSeverityOriginal, value); err != nil {
				return err
			}

		case "FindingProviderFieldsTypes":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.FindingProviderFieldsTypes, value); err != nil {
				return err
			}

		case "FirstObservedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.FirstObservedAt, value); err != nil {
				return err
			}

		case "GeneratorId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.GeneratorId, value); err != nil {
				return err
			}

		case "Id":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Id, value); err != nil {
				return err
			}

		case "Keyword":
			if err := awsRestjson1_deserializeDocumentKeywordFilterList(&sv.Keyword, value); err != nil {
				return err
			}

		case "LastObservedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.LastObservedAt, value); err != nil {
				return err
			}

		case "MalwareName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.MalwareName, value); err != nil {
				return err
			}

		case "MalwarePath":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.MalwarePath, value); err != nil {
				return err
			}

		case "MalwareState":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.MalwareState, value); err != nil {
				return err
			}

		case "MalwareType":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.MalwareType, value); err != nil {
				return err
			}

		case "NetworkDestinationDomain":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NetworkDestinationDomain, value); err != nil {
				return err
			}

		case "NetworkDestinationIpV4":
			if err := awsRestjson1_deserializeDocumentIpFilterList(&sv.NetworkDestinationIpV4, value); err != nil {
				return err
			}

		case "NetworkDestinationIpV6":
			if err := awsRestjson1_deserializeDocumentIpFilterList(&sv.NetworkDestinationIpV6, value); err != nil {
				return err
			}

		case "NetworkDestinationPort":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.NetworkDestinationPort, value); err != nil {
				return err
			}

		case "NetworkDirection":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NetworkDirection, value); err != nil {
				return err
			}

		case "NetworkProtocol":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NetworkProtocol, value); err != nil {
				return err
			}

		case "NetworkSourceDomain":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NetworkSourceDomain, value); err != nil {
				return err
			}

		case "NetworkSourceIpV4":
			if err := awsRestjson1_deserializeDocumentIpFilterList(&sv.NetworkSourceIpV4, value); err != nil {
				return err
			}

		case "NetworkSourceIpV6":
			if err := awsRestjson1_deserializeDocumentIpFilterList(&sv.NetworkSourceIpV6, value); err != nil {
				return err
			}

		case "NetworkSourceMac":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NetworkSourceMac, value); err != nil {
				return err
			}

		case "NetworkSourcePort":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.NetworkSourcePort, value); err != nil {
				return err
			}

		case "NoteText":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NoteText, value); err != nil {
				return err
			}

		case "NoteUpdatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.NoteUpdatedAt, value); err != nil {
				return err
			}

		case "NoteUpdatedBy":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.NoteUpdatedBy, value); err != nil {
				return err
			}

		case "ProcessLaunchedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.ProcessLaunchedAt, value); err != nil {
				return err
			}

		case "ProcessName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ProcessName, value); err != nil {
				return err
			}

		case "ProcessParentPid":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.ProcessParentPid, value); err != nil {
				return err
			}

		case "ProcessPath":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ProcessPath, value); err != nil {
				return err
			}

		case "ProcessPid":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.ProcessPid, value); err != nil {
				return err
			}

		case "ProcessTerminatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.ProcessTerminatedAt, value); err != nil {
				return err
			}

		case "ProductArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ProductArn, value); err != nil {
				return err
			}

		case "ProductFields":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.ProductFields, value); err != nil {
				return err
			}

		case "ProductName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ProductName, value); err != nil {
				return err
			}

		case "RecommendationText":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RecommendationText, value); err != nil {
				return err
			}

		case "RecordState":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RecordState, value); err != nil {
				return err
			}

		case "Region":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Region, value); err != nil {
				return err
			}

		case "RelatedFindingsId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RelatedFindingsId, value); err != nil {
				return err
			}

		case "RelatedFindingsProductArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.RelatedFindingsProductArn, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceIamInstanceProfileArn":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsEc2InstanceIamInstanceProfileArn, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceImageId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsEc2InstanceImageId, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceIpV4Addresses":
			if err := awsRestjson1_deserializeDocumentIpFilterList(&sv.ResourceAwsEc2InstanceIpV4Addresses, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceIpV6Addresses":
			if err := awsRestjson1_deserializeDocumentIpFilterList(&sv.ResourceAwsEc2InstanceIpV6Addresses, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceKeyName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsEc2InstanceKeyName, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceLaunchedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.ResourceAwsEc2InstanceLaunchedAt, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceSubnetId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsEc2InstanceSubnetId, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceType":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsEc2InstanceType, value); err != nil {
				return err
			}

		case "ResourceAwsEc2InstanceVpcId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsEc2InstanceVpcId, value); err != nil {
				return err
			}

		case "ResourceAwsIamAccessKeyCreatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.ResourceAwsIamAccessKeyCreatedAt, value); err != nil {
				return err
			}

		case "ResourceAwsIamAccessKeyPrincipalName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsIamAccessKeyPrincipalName, value); err != nil {
				return err
			}

		case "ResourceAwsIamAccessKeyStatus":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsIamAccessKeyStatus, value); err != nil {
				return err
			}

		case "ResourceAwsIamAccessKeyUserName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsIamAccessKeyUserName, value); err != nil {
				return err
			}

		case "ResourceAwsIamUserUserName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsIamUserUserName, value); err != nil {
				return err
			}

		case "ResourceAwsS3BucketOwnerId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsS3BucketOwnerId, value); err != nil {
				return err
			}

		case "ResourceAwsS3BucketOwnerName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceAwsS3BucketOwnerName, value); err != nil {
				return err
			}

		case "ResourceContainerImageId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceContainerImageId, value); err != nil {
				return err
			}

		case "ResourceContainerImageName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceContainerImageName, value); err != nil {
				return err
			}

		case "ResourceContainerLaunchedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.ResourceContainerLaunchedAt, value); err != nil {
				return err
			}

		case "ResourceContainerName":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceContainerName, value); err != nil {
				return err
			}

		case "ResourceDetailsOther":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.ResourceDetailsOther, value); err != nil {
				return err
			}

		case "ResourceId":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceId, value); err != nil {
				return err
			}

		case "ResourcePartition":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourcePartition, value); err != nil {
				return err
			}

		case "ResourceRegion":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceRegion, value); err != nil {
				return err
			}

		case "ResourceTags":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.ResourceTags, value); err != nil {
				return err
			}

		case "ResourceType":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ResourceType, value); err != nil {
				return err
			}

		case "SeverityLabel":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.SeverityLabel, value); err != nil {
				return err
			}

		case "SeverityNormalized":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.SeverityNormalized, value); err != nil {
				return err
			}

		case "SeverityProduct":
			if err := awsRestjson1_deserializeDocumentNumberFilterList(&sv.SeverityProduct, value); err != nil {
				return err
			}

		case "SourceUrl":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.SourceUrl, value); err != nil {
				return err
			}

		case "ThreatIntelIndicatorCategory":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ThreatIntelIndicatorCategory, value); err != nil {
				return err
			}

		case "ThreatIntelIndicatorLastObservedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.ThreatIntelIndicatorLastObservedAt, value); err != nil {
				return err
			}

		case "ThreatIntelIndicatorSource":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ThreatIntelIndicatorSource, value); err != nil {
				return err
			}

		case "ThreatIntelIndicatorSourceUrl":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ThreatIntelIndicatorSourceUrl, value); err != nil {
				return err
			}

		case "ThreatIntelIndicatorType":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ThreatIntelIndicatorType, value); err != nil {
				return err
			}

		case "ThreatIntelIndicatorValue":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.ThreatIntelIndicatorValue, value); err != nil {
				return err
			}

		case "Title":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Title, value); err != nil {
				return err
			}

		case "Type":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.Type, value); err != nil {
				return err
			}

		case "UpdatedAt":
			if err := awsRestjson1_deserializeDocumentDateFilterList(&sv.UpdatedAt, value); err != nil {
				return err
			}

		case "UserDefinedFields":
			if err := awsRestjson1_deserializeDocumentMapFilterList(&sv.UserDefinedFields, value); err != nil {
				return err
			}

		case "VerificationState":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.VerificationState, value); err != nil {
				return err
			}

		case "WorkflowState":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.WorkflowState, value); err != nil {
				return err
			}

		case "WorkflowStatus":
			if err := awsRestjson1_deserializeDocumentStringFilterList(&sv.WorkflowStatus, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecurityFindingIdentifier(v **types.AwsSecurityFindingIdentifier, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSecurityFindingIdentifier
	if *v == nil {
		sv = &types.AwsSecurityFindingIdentifier{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "ProductArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecurityFindingIdentifierList(v *[]types.AwsSecurityFindingIdentifier, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsSecurityFindingIdentifier
	if *v == nil {
		cv = []types.AwsSecurityFindingIdentifier{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsSecurityFindingIdentifier
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsSecurityFindingIdentifier(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSecurityFindingList(v *[]types.AwsSecurityFinding, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsSecurityFinding
	if *v == nil {
		cv = []types.AwsSecurityFinding{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsSecurityFinding
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsSecurityFinding(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSnsTopicDetails(v **types.AwsSnsTopicDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSnsTopicDetails
	if *v == nil {
		sv = &types.AwsSnsTopicDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "KmsMasterKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsMasterKeyId = ptr.String(jtv)
			}

		case "Owner":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Owner = ptr.String(jtv)
			}

		case "Subscription":
			if err := awsRestjson1_deserializeDocumentAwsSnsTopicSubscriptionList(&sv.Subscription, value); err != nil {
				return err
			}

		case "TopicName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TopicName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSnsTopicSubscription(v **types.AwsSnsTopicSubscription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSnsTopicSubscription
	if *v == nil {
		sv = &types.AwsSnsTopicSubscription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Endpoint":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Endpoint = ptr.String(jtv)
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSnsTopicSubscriptionList(v *[]types.AwsSnsTopicSubscription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsSnsTopicSubscription
	if *v == nil {
		cv = []types.AwsSnsTopicSubscription{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsSnsTopicSubscription
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsSnsTopicSubscription(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSqsQueueDetails(v **types.AwsSqsQueueDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSqsQueueDetails
	if *v == nil {
		sv = &types.AwsSqsQueueDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DeadLetterTargetArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DeadLetterTargetArn = ptr.String(jtv)
			}

		case "KmsDataKeyReusePeriodSeconds":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.KmsDataKeyReusePeriodSeconds = int32(i64)
			}

		case "KmsMasterKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.KmsMasterKeyId = ptr.String(jtv)
			}

		case "QueueName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.QueueName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSsmComplianceSummary(v **types.AwsSsmComplianceSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSsmComplianceSummary
	if *v == nil {
		sv = &types.AwsSsmComplianceSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ComplianceType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ComplianceType = ptr.String(jtv)
			}

		case "CompliantCriticalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompliantCriticalCount = int32(i64)
			}

		case "CompliantHighCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompliantHighCount = int32(i64)
			}

		case "CompliantInformationalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompliantInformationalCount = int32(i64)
			}

		case "CompliantLowCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompliantLowCount = int32(i64)
			}

		case "CompliantMediumCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompliantMediumCount = int32(i64)
			}

		case "CompliantUnspecifiedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.CompliantUnspecifiedCount = int32(i64)
			}

		case "ExecutionType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ExecutionType = ptr.String(jtv)
			}

		case "NonCompliantCriticalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NonCompliantCriticalCount = int32(i64)
			}

		case "NonCompliantHighCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NonCompliantHighCount = int32(i64)
			}

		case "NonCompliantInformationalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NonCompliantInformationalCount = int32(i64)
			}

		case "NonCompliantLowCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NonCompliantLowCount = int32(i64)
			}

		case "NonCompliantMediumCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NonCompliantMediumCount = int32(i64)
			}

		case "NonCompliantUnspecifiedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NonCompliantUnspecifiedCount = int32(i64)
			}

		case "OverallSeverity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OverallSeverity = ptr.String(jtv)
			}

		case "PatchBaselineId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PatchBaselineId = ptr.String(jtv)
			}

		case "PatchGroup":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PatchGroup = ptr.String(jtv)
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Status = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSsmPatch(v **types.AwsSsmPatch, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSsmPatch
	if *v == nil {
		sv = &types.AwsSsmPatch{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ComplianceSummary":
			if err := awsRestjson1_deserializeDocumentAwsSsmComplianceSummary(&sv.ComplianceSummary, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsSsmPatchComplianceDetails(v **types.AwsSsmPatchComplianceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsSsmPatchComplianceDetails
	if *v == nil {
		sv = &types.AwsSsmPatchComplianceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Patch":
			if err := awsRestjson1_deserializeDocumentAwsSsmPatch(&sv.Patch, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsWafWebAclDetails(v **types.AwsWafWebAclDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsWafWebAclDetails
	if *v == nil {
		sv = &types.AwsWafWebAclDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DefaultAction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DefaultAction = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Rules":
			if err := awsRestjson1_deserializeDocumentAwsWafWebAclRuleList(&sv.Rules, value); err != nil {
				return err
			}

		case "WebAclId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.WebAclId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsWafWebAclRule(v **types.AwsWafWebAclRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AwsWafWebAclRule
	if *v == nil {
		sv = &types.AwsWafWebAclRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Action":
			if err := awsRestjson1_deserializeDocumentWafAction(&sv.Action, value); err != nil {
				return err
			}

		case "ExcludedRules":
			if err := awsRestjson1_deserializeDocumentWafExcludedRuleList(&sv.ExcludedRules, value); err != nil {
				return err
			}

		case "OverrideAction":
			if err := awsRestjson1_deserializeDocumentWafOverrideAction(&sv.OverrideAction, value); err != nil {
				return err
			}

		case "Priority":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Priority = int32(i64)
			}

		case "RuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleId = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentAwsWafWebAclRuleList(v *[]types.AwsWafWebAclRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.AwsWafWebAclRule
	if *v == nil {
		cv = []types.AwsWafWebAclRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.AwsWafWebAclRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentAwsWafWebAclRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentBatchUpdateFindingsUnprocessedFinding(v **types.BatchUpdateFindingsUnprocessedFinding, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BatchUpdateFindingsUnprocessedFinding
	if *v == nil {
		sv = &types.BatchUpdateFindingsUnprocessedFinding{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ErrorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ErrorCode = ptr.String(jtv)
			}

		case "ErrorMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ErrorMessage = ptr.String(jtv)
			}

		case "FindingIdentifier":
			if err := awsRestjson1_deserializeDocumentAwsSecurityFindingIdentifier(&sv.FindingIdentifier, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentBatchUpdateFindingsUnprocessedFindingsList(v *[]types.BatchUpdateFindingsUnprocessedFinding, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.BatchUpdateFindingsUnprocessedFinding
	if *v == nil {
		cv = []types.BatchUpdateFindingsUnprocessedFinding{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.BatchUpdateFindingsUnprocessedFinding
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentBatchUpdateFindingsUnprocessedFinding(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentCategoryList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentCell(v **types.Cell, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Cell
	if *v == nil {
		sv = &types.Cell{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CellReference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CellReference = ptr.String(jtv)
			}

		case "Column":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Column = i64
			}

		case "ColumnName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ColumnName = ptr.String(jtv)
			}

		case "Row":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Row = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCells(v *[]types.Cell, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Cell
	if *v == nil {
		cv = []types.Cell{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Cell
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentCell(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentCidrBlockAssociation(v **types.CidrBlockAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CidrBlockAssociation
	if *v == nil {
		sv = &types.CidrBlockAssociation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationId = ptr.String(jtv)
			}

		case "CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlock = ptr.String(jtv)
			}

		case "CidrBlockState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlockState = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCidrBlockAssociationList(v *[]types.CidrBlockAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.CidrBlockAssociation
	if *v == nil {
		cv = []types.CidrBlockAssociation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.CidrBlockAssociation
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentCidrBlockAssociation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentCity(v **types.City, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.City
	if *v == nil {
		sv = &types.City{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CityName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CityName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentClassificationResult(v **types.ClassificationResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ClassificationResult
	if *v == nil {
		sv = &types.ClassificationResult{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AdditionalOccurrences":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.AdditionalOccurrences = jtv
			}

		case "CustomDataIdentifiers":
			if err := awsRestjson1_deserializeDocumentCustomDataIdentifiersResult(&sv.CustomDataIdentifiers, value); err != nil {
				return err
			}

		case "MimeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MimeType = ptr.String(jtv)
			}

		case "SensitiveData":
			if err := awsRestjson1_deserializeDocumentSensitiveDataResultList(&sv.SensitiveData, value); err != nil {
				return err
			}

		case "SizeClassified":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SizeClassified = i64
			}

		case "Status":
			if err := awsRestjson1_deserializeDocumentClassificationStatus(&sv.Status, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentClassificationStatus(v **types.ClassificationStatus, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ClassificationStatus
	if *v == nil {
		sv = &types.ClassificationStatus{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCompliance(v **types.Compliance, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Compliance
	if *v == nil {
		sv = &types.Compliance{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RelatedRequirements":
			if err := awsRestjson1_deserializeDocumentRelatedRequirementsList(&sv.RelatedRequirements, value); err != nil {
				return err
			}

		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ComplianceStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.ComplianceStatus(jtv)
			}

		case "StatusReasons":
			if err := awsRestjson1_deserializeDocumentStatusReasonsList(&sv.StatusReasons, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentContainerDetails(v **types.ContainerDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ContainerDetails
	if *v == nil {
		sv = &types.ContainerDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ImageId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageId = ptr.String(jtv)
			}

		case "ImageName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ImageName = ptr.String(jtv)
			}

		case "LaunchedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchedAt = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCountry(v **types.Country, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Country
	if *v == nil {
		sv = &types.Country{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "CountryCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CountryCode = ptr.String(jtv)
			}

		case "CountryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CountryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCustomDataIdentifiersDetections(v **types.CustomDataIdentifiersDetections, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CustomDataIdentifiersDetections
	if *v == nil {
		sv = &types.CustomDataIdentifiersDetections{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "Count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = i64
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Occurrences":
			if err := awsRestjson1_deserializeDocumentOccurrences(&sv.Occurrences, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCustomDataIdentifiersDetectionsList(v *[]types.CustomDataIdentifiersDetections, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.CustomDataIdentifiersDetections
	if *v == nil {
		cv = []types.CustomDataIdentifiersDetections{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.CustomDataIdentifiersDetections
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentCustomDataIdentifiersDetections(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentCustomDataIdentifiersResult(v **types.CustomDataIdentifiersResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CustomDataIdentifiersResult
	if *v == nil {
		sv = &types.CustomDataIdentifiersResult{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Detections":
			if err := awsRestjson1_deserializeDocumentCustomDataIdentifiersDetectionsList(&sv.Detections, value); err != nil {
				return err
			}

		case "TotalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalCount = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCvss(v **types.Cvss, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Cvss
	if *v == nil {
		sv = &types.Cvss{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Adjustments":
			if err := awsRestjson1_deserializeDocumentAdjustmentList(&sv.Adjustments, value); err != nil {
				return err
			}

		case "BaseScore":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.BaseScore = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.BaseScore = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "BaseVector":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.BaseVector = ptr.String(jtv)
			}

		case "Source":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Source = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentCvssList(v *[]types.Cvss, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Cvss
	if *v == nil {
		cv = []types.Cvss{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Cvss
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentCvss(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentDataClassificationDetails(v **types.DataClassificationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DataClassificationDetails
	if *v == nil {
		sv = &types.DataClassificationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DetailedResultsLocation":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DetailedResultsLocation = ptr.String(jtv)
			}

		case "Result":
			if err := awsRestjson1_deserializeDocumentClassificationResult(&sv.Result, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDateFilter(v **types.DateFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DateFilter
	if *v == nil {
		sv = &types.DateFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DateRange":
			if err := awsRestjson1_deserializeDocumentDateRange(&sv.DateRange, value); err != nil {
				return err
			}

		case "End":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.End = ptr.String(jtv)
			}

		case "Start":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Start = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDateFilterList(v *[]types.DateFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.DateFilter
	if *v == nil {
		cv = []types.DateFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.DateFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentDateFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentDateRange(v **types.DateRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DateRange
	if *v == nil {
		sv = &types.DateRange{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Unit":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DateRangeUnit to be of type string, got %T instead", value)
				}
				sv.Unit = types.DateRangeUnit(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Value = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentDnsRequestAction(v **types.DnsRequestAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DnsRequestAction
	if *v == nil {
		sv = &types.DnsRequestAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Blocked":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Blocked = jtv
			}

		case "Domain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Domain = ptr.String(jtv)
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentFieldMap(v *map[string]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]string
	if *v == nil {
		mv = map[string]string{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			parsedVal = jtv
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentFindingProviderFields(v **types.FindingProviderFields, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FindingProviderFields
	if *v == nil {
		sv = &types.FindingProviderFields{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Confidence":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected RatioScale to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Confidence = int32(i64)
			}

		case "Criticality":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected RatioScale to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Criticality = int32(i64)
			}

		case "RelatedFindings":
			if err := awsRestjson1_deserializeDocumentRelatedFindingList(&sv.RelatedFindings, value); err != nil {
				return err
			}

		case "Severity":
			if err := awsRestjson1_deserializeDocumentFindingProviderSeverity(&sv.Severity, value); err != nil {
				return err
			}

		case "Types":
			if err := awsRestjson1_deserializeDocumentTypeList(&sv.Types, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentFindingProviderSeverity(v **types.FindingProviderSeverity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FindingProviderSeverity
	if *v == nil {
		sv = &types.FindingProviderSeverity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Label":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SeverityLabel to be of type string, got %T instead", value)
				}
				sv.Label = types.SeverityLabel(jtv)
			}

		case "Original":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Original = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentGeoLocation(v **types.GeoLocation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.GeoLocation
	if *v == nil {
		sv = &types.GeoLocation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Lat":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Lat = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Lat = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Lon":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Lon = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Lon = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIcmpTypeCode(v **types.IcmpTypeCode, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IcmpTypeCode
	if *v == nil {
		sv = &types.IcmpTypeCode{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Code = int32(i64)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Type = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentImportFindingsError(v **types.ImportFindingsError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ImportFindingsError
	if *v == nil {
		sv = &types.ImportFindingsError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ErrorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ErrorCode = ptr.String(jtv)
			}

		case "ErrorMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ErrorMessage = ptr.String(jtv)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentImportFindingsErrorList(v *[]types.ImportFindingsError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ImportFindingsError
	if *v == nil {
		cv = []types.ImportFindingsError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ImportFindingsError
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentImportFindingsError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentInsight(v **types.Insight, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Insight
	if *v == nil {
		sv = &types.Insight{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Filters":
			if err := awsRestjson1_deserializeDocumentAwsSecurityFindingFilters(&sv.Filters, value); err != nil {
				return err
			}

		case "GroupByAttribute":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupByAttribute = ptr.String(jtv)
			}

		case "InsightArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InsightArn = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInsightList(v *[]types.Insight, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Insight
	if *v == nil {
		cv = []types.Insight{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Insight
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentInsight(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentInsightResults(v **types.InsightResults, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InsightResults
	if *v == nil {
		sv = &types.InsightResults{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "GroupByAttribute":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupByAttribute = ptr.String(jtv)
			}

		case "InsightArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InsightArn = ptr.String(jtv)
			}

		case "ResultValues":
			if err := awsRestjson1_deserializeDocumentInsightResultValueList(&sv.ResultValues, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInsightResultValue(v **types.InsightResultValue, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InsightResultValue
	if *v == nil {
		sv = &types.InsightResultValue{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = int32(i64)
			}

		case "GroupByAttributeValue":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.GroupByAttributeValue = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInsightResultValueList(v *[]types.InsightResultValue, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.InsightResultValue
	if *v == nil {
		cv = []types.InsightResultValue{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.InsightResultValue
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentInsightResultValue(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentIntegerList(v *[]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []int32
	if *v == nil {
		cv = []int32{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			col = int32(i64)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentIntegrationTypeList(v *[]types.IntegrationType, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.IntegrationType
	if *v == nil {
		cv = []types.IntegrationType{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.IntegrationType
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected IntegrationType to be of type string, got %T instead", value)
			}
			col = types.IntegrationType(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentInternalException(v **types.InternalException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InternalException
	if *v == nil {
		sv = &types.InternalException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInvalidAccessException(v **types.InvalidAccessException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidAccessException
	if *v == nil {
		sv = &types.InvalidAccessException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInvalidInputException(v **types.InvalidInputException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidInputException
	if *v == nil {
		sv = &types.InvalidInputException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInvitation(v **types.Invitation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Invitation
	if *v == nil {
		sv = &types.Invitation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "InvitationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.InvitationId = ptr.String(jtv)
			}

		case "InvitedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.InvitedAt = ptr.Time(t)
			}

		case "MemberStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MemberStatus = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentInvitationList(v *[]types.Invitation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Invitation
	if *v == nil {
		cv = []types.Invitation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Invitation
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentInvitation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentIpFilter(v **types.IpFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IpFilter
	if *v == nil {
		sv = &types.IpFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Cidr":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Cidr = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIpFilterList(v *[]types.IpFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.IpFilter
	if *v == nil {
		cv = []types.IpFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.IpFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentIpFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentIpOrganizationDetails(v **types.IpOrganizationDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IpOrganizationDetails
	if *v == nil {
		sv = &types.IpOrganizationDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Asn":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Asn = int32(i64)
			}

		case "AsnOrg":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AsnOrg = ptr.String(jtv)
			}

		case "Isp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Isp = ptr.String(jtv)
			}

		case "Org":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Org = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIpv6CidrBlockAssociation(v **types.Ipv6CidrBlockAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Ipv6CidrBlockAssociation
	if *v == nil {
		sv = &types.Ipv6CidrBlockAssociation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AssociationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AssociationId = ptr.String(jtv)
			}

		case "CidrBlockState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CidrBlockState = ptr.String(jtv)
			}

		case "Ipv6CidrBlock":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Ipv6CidrBlock = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentIpv6CidrBlockAssociationList(v *[]types.Ipv6CidrBlockAssociation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Ipv6CidrBlockAssociation
	if *v == nil {
		cv = []types.Ipv6CidrBlockAssociation{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Ipv6CidrBlockAssociation
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentIpv6CidrBlockAssociation(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentKeywordFilter(v **types.KeywordFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.KeywordFilter
	if *v == nil {
		sv = &types.KeywordFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentKeywordFilterList(v *[]types.KeywordFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.KeywordFilter
	if *v == nil {
		cv = []types.KeywordFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.KeywordFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentKeywordFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentLimitExceededException(v **types.LimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LimitExceededException
	if *v == nil {
		sv = &types.LimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentLoadBalancerState(v **types.LoadBalancerState, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LoadBalancerState
	if *v == nil {
		sv = &types.LoadBalancerState{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMalware(v **types.Malware, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Malware
	if *v == nil {
		sv = &types.Malware{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "State":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MalwareState to be of type string, got %T instead", value)
				}
				sv.State = types.MalwareState(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MalwareType to be of type string, got %T instead", value)
				}
				sv.Type = types.MalwareType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMalwareList(v *[]types.Malware, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Malware
	if *v == nil {
		cv = []types.Malware{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Malware
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentMalware(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentMapFilter(v **types.MapFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MapFilter
	if *v == nil {
		sv = &types.MapFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Comparison":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MapFilterComparison to be of type string, got %T instead", value)
				}
				sv.Comparison = types.MapFilterComparison(jtv)
			}

		case "Key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMapFilterList(v *[]types.MapFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.MapFilter
	if *v == nil {
		cv = []types.MapFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.MapFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentMapFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentMember(v **types.Member, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Member
	if *v == nil {
		sv = &types.Member{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "AdministratorId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.AdministratorId = ptr.String(jtv)
			}

		case "Email":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Email = ptr.String(jtv)
			}

		case "InvitedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.InvitedAt = ptr.Time(t)
			}

		case "MasterId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MasterId = ptr.String(jtv)
			}

		case "MemberStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MemberStatus = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.UpdatedAt = ptr.Time(t)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentMemberList(v *[]types.Member, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Member
	if *v == nil {
		cv = []types.Member{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Member
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentMember(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentNetwork(v **types.Network, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Network
	if *v == nil {
		sv = &types.Network{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DestinationDomain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationDomain = ptr.String(jtv)
			}

		case "DestinationIpV4":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationIpV4 = ptr.String(jtv)
			}

		case "DestinationIpV6":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DestinationIpV6 = ptr.String(jtv)
			}

		case "DestinationPort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DestinationPort = int32(i64)
			}

		case "Direction":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NetworkDirection to be of type string, got %T instead", value)
				}
				sv.Direction = types.NetworkDirection(jtv)
			}

		case "OpenPortRange":
			if err := awsRestjson1_deserializeDocumentPortRange(&sv.OpenPortRange, value); err != nil {
				return err
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "SourceDomain":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceDomain = ptr.String(jtv)
			}

		case "SourceIpV4":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceIpV4 = ptr.String(jtv)
			}

		case "SourceIpV6":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceIpV6 = ptr.String(jtv)
			}

		case "SourceMac":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceMac = ptr.String(jtv)
			}

		case "SourcePort":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.SourcePort = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNetworkConnectionAction(v **types.NetworkConnectionAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NetworkConnectionAction
	if *v == nil {
		sv = &types.NetworkConnectionAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Blocked":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Blocked = jtv
			}

		case "ConnectionDirection":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ConnectionDirection = ptr.String(jtv)
			}

		case "LocalPortDetails":
			if err := awsRestjson1_deserializeDocumentActionLocalPortDetails(&sv.LocalPortDetails, value); err != nil {
				return err
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "RemoteIpDetails":
			if err := awsRestjson1_deserializeDocumentActionRemoteIpDetails(&sv.RemoteIpDetails, value); err != nil {
				return err
			}

		case "RemotePortDetails":
			if err := awsRestjson1_deserializeDocumentActionRemotePortDetails(&sv.RemotePortDetails, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNetworkHeader(v **types.NetworkHeader, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NetworkHeader
	if *v == nil {
		sv = &types.NetworkHeader{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Destination":
			if err := awsRestjson1_deserializeDocumentNetworkPathComponentDetails(&sv.Destination, value); err != nil {
				return err
			}

		case "Protocol":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Protocol = ptr.String(jtv)
			}

		case "Source":
			if err := awsRestjson1_deserializeDocumentNetworkPathComponentDetails(&sv.Source, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNetworkPathComponent(v **types.NetworkPathComponent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NetworkPathComponent
	if *v == nil {
		sv = &types.NetworkPathComponent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ComponentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ComponentId = ptr.String(jtv)
			}

		case "ComponentType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ComponentType = ptr.String(jtv)
			}

		case "Egress":
			if err := awsRestjson1_deserializeDocumentNetworkHeader(&sv.Egress, value); err != nil {
				return err
			}

		case "Ingress":
			if err := awsRestjson1_deserializeDocumentNetworkHeader(&sv.Ingress, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNetworkPathComponentDetails(v **types.NetworkPathComponentDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NetworkPathComponentDetails
	if *v == nil {
		sv = &types.NetworkPathComponentDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Address":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.Address, value); err != nil {
				return err
			}

		case "PortRanges":
			if err := awsRestjson1_deserializeDocumentPortRangeList(&sv.PortRanges, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNetworkPathList(v *[]types.NetworkPathComponent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.NetworkPathComponent
	if *v == nil {
		cv = []types.NetworkPathComponent{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.NetworkPathComponent
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentNetworkPathComponent(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentNonEmptyStringList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentNote(v **types.Note, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Note
	if *v == nil {
		sv = &types.Note{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Text":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Text = ptr.String(jtv)
			}

		case "UpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdatedAt = ptr.String(jtv)
			}

		case "UpdatedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.UpdatedBy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNumberFilter(v **types.NumberFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NumberFilter
	if *v == nil {
		sv = &types.NumberFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Eq":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Eq = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Eq = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Gte":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Gte = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Gte = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		case "Lte":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Lte = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Lte = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentNumberFilterList(v *[]types.NumberFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.NumberFilter
	if *v == nil {
		cv = []types.NumberFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.NumberFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentNumberFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentOccurrences(v **types.Occurrences, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Occurrences
	if *v == nil {
		sv = &types.Occurrences{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Cells":
			if err := awsRestjson1_deserializeDocumentCells(&sv.Cells, value); err != nil {
				return err
			}

		case "LineRanges":
			if err := awsRestjson1_deserializeDocumentRanges(&sv.LineRanges, value); err != nil {
				return err
			}

		case "OffsetRanges":
			if err := awsRestjson1_deserializeDocumentRanges(&sv.OffsetRanges, value); err != nil {
				return err
			}

		case "Pages":
			if err := awsRestjson1_deserializeDocumentPages(&sv.Pages, value); err != nil {
				return err
			}

		case "Records":
			if err := awsRestjson1_deserializeDocumentRecords(&sv.Records, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPage(v **types.Page, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Page
	if *v == nil {
		sv = &types.Page{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LineRange":
			if err := awsRestjson1_deserializeDocumentRange(&sv.LineRange, value); err != nil {
				return err
			}

		case "OffsetRange":
			if err := awsRestjson1_deserializeDocumentRange(&sv.OffsetRange, value); err != nil {
				return err
			}

		case "PageNumber":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PageNumber = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPages(v *[]types.Page, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Page
	if *v == nil {
		cv = []types.Page{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Page
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentPage(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentPatchSummary(v **types.PatchSummary, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PatchSummary
	if *v == nil {
		sv = &types.PatchSummary{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "FailedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FailedCount = int32(i64)
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "InstalledCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstalledCount = int32(i64)
			}

		case "InstalledOtherCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstalledOtherCount = int32(i64)
			}

		case "InstalledPendingReboot":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstalledPendingReboot = int32(i64)
			}

		case "InstalledRejectedCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InstalledRejectedCount = int32(i64)
			}

		case "MissingCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.MissingCount = int32(i64)
			}

		case "Operation":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Operation = ptr.String(jtv)
			}

		case "OperationEndTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OperationEndTime = ptr.String(jtv)
			}

		case "OperationStartTime":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.OperationStartTime = ptr.String(jtv)
			}

		case "RebootOption":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RebootOption = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPortProbeAction(v **types.PortProbeAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PortProbeAction
	if *v == nil {
		sv = &types.PortProbeAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Blocked":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.Blocked = jtv
			}

		case "PortProbeDetails":
			if err := awsRestjson1_deserializeDocumentPortProbeDetailList(&sv.PortProbeDetails, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPortProbeDetail(v **types.PortProbeDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PortProbeDetail
	if *v == nil {
		sv = &types.PortProbeDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LocalIpDetails":
			if err := awsRestjson1_deserializeDocumentActionLocalIpDetails(&sv.LocalIpDetails, value); err != nil {
				return err
			}

		case "LocalPortDetails":
			if err := awsRestjson1_deserializeDocumentActionLocalPortDetails(&sv.LocalPortDetails, value); err != nil {
				return err
			}

		case "RemoteIpDetails":
			if err := awsRestjson1_deserializeDocumentActionRemoteIpDetails(&sv.RemoteIpDetails, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPortProbeDetailList(v *[]types.PortProbeDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.PortProbeDetail
	if *v == nil {
		cv = []types.PortProbeDetail{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.PortProbeDetail
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentPortProbeDetail(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentPortRange(v **types.PortRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PortRange
	if *v == nil {
		sv = &types.PortRange{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Begin":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Begin = int32(i64)
			}

		case "End":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.End = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPortRangeFromTo(v **types.PortRangeFromTo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PortRangeFromTo
	if *v == nil {
		sv = &types.PortRangeFromTo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "From":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.From = int32(i64)
			}

		case "To":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.To = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentPortRangeList(v *[]types.PortRange, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.PortRange
	if *v == nil {
		cv = []types.PortRange{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.PortRange
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentPortRange(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentProcessDetails(v **types.ProcessDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ProcessDetails
	if *v == nil {
		sv = &types.ProcessDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "LaunchedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LaunchedAt = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "ParentPid":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ParentPid = int32(i64)
			}

		case "Path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "Pid":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Pid = int32(i64)
			}

		case "TerminatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.TerminatedAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentProduct(v **types.Product, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Product
	if *v == nil {
		sv = &types.Product{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ActivationUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ActivationUrl = ptr.String(jtv)
			}

		case "Categories":
			if err := awsRestjson1_deserializeDocumentCategoryList(&sv.Categories, value); err != nil {
				return err
			}

		case "CompanyName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.CompanyName = ptr.String(jtv)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "IntegrationTypes":
			if err := awsRestjson1_deserializeDocumentIntegrationTypeList(&sv.IntegrationTypes, value); err != nil {
				return err
			}

		case "MarketplaceUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.MarketplaceUrl = ptr.String(jtv)
			}

		case "ProductArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductArn = ptr.String(jtv)
			}

		case "ProductName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductName = ptr.String(jtv)
			}

		case "ProductSubscriptionResourcePolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductSubscriptionResourcePolicy = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentProductsList(v *[]types.Product, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Product
	if *v == nil {
		cv = []types.Product{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Product
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentProduct(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentProductSubscriptionArnList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRange(v **types.Range, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Range
	if *v == nil {
		sv = &types.Range{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "End":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.End = i64
			}

		case "Start":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Start = i64
			}

		case "StartColumn":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartColumn = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRanges(v *[]types.Range, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Range
	if *v == nil {
		cv = []types.Range{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Range
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRange(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRecommendation(v **types.Recommendation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Recommendation
	if *v == nil {
		sv = &types.Recommendation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Text":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Text = ptr.String(jtv)
			}

		case "Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Url = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRecord(v **types.Record, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Record
	if *v == nil {
		sv = &types.Record{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "JsonPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.JsonPath = ptr.String(jtv)
			}

		case "RecordIndex":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.RecordIndex = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRecords(v *[]types.Record, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Record
	if *v == nil {
		cv = []types.Record{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Record
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRecord(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRelatedFinding(v **types.RelatedFinding, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RelatedFinding
	if *v == nil {
		sv = &types.RelatedFinding{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "ProductArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProductArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentRelatedFindingList(v *[]types.RelatedFinding, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RelatedFinding
	if *v == nil {
		cv = []types.RelatedFinding{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RelatedFinding
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentRelatedFinding(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRelatedRequirementsList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentRemediation(v **types.Remediation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Remediation
	if *v == nil {
		sv = &types.Remediation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Recommendation":
			if err := awsRestjson1_deserializeDocumentRecommendation(&sv.Recommendation, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResource(v **types.Resource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Resource
	if *v == nil {
		sv = &types.Resource{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "DataClassification":
			if err := awsRestjson1_deserializeDocumentDataClassificationDetails(&sv.DataClassification, value); err != nil {
				return err
			}

		case "Details":
			if err := awsRestjson1_deserializeDocumentResourceDetails(&sv.Details, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "Partition":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Partition to be of type string, got %T instead", value)
				}
				sv.Partition = types.Partition(jtv)
			}

		case "Region":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Region = ptr.String(jtv)
			}

		case "ResourceRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ResourceRole = ptr.String(jtv)
			}

		case "Tags":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Tags, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResourceConflictException(v **types.ResourceConflictException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceConflictException
	if *v == nil {
		sv = &types.ResourceConflictException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResourceDetails(v **types.ResourceDetails, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceDetails
	if *v == nil {
		sv = &types.ResourceDetails{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AwsApiGatewayRestApi":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayRestApiDetails(&sv.AwsApiGatewayRestApi, value); err != nil {
				return err
			}

		case "AwsApiGatewayStage":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayStageDetails(&sv.AwsApiGatewayStage, value); err != nil {
				return err
			}

		case "AwsApiGatewayV2Api":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayV2ApiDetails(&sv.AwsApiGatewayV2Api, value); err != nil {
				return err
			}

		case "AwsApiGatewayV2Stage":
			if err := awsRestjson1_deserializeDocumentAwsApiGatewayV2StageDetails(&sv.AwsApiGatewayV2Stage, value); err != nil {
				return err
			}

		case "AwsAutoScalingAutoScalingGroup":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingAutoScalingGroupDetails(&sv.AwsAutoScalingAutoScalingGroup, value); err != nil {
				return err
			}

		case "AwsAutoScalingLaunchConfiguration":
			if err := awsRestjson1_deserializeDocumentAwsAutoScalingLaunchConfigurationDetails(&sv.AwsAutoScalingLaunchConfiguration, value); err != nil {
				return err
			}

		case "AwsCertificateManagerCertificate":
			if err := awsRestjson1_deserializeDocumentAwsCertificateManagerCertificateDetails(&sv.AwsCertificateManagerCertificate, value); err != nil {
				return err
			}

		case "AwsCloudFrontDistribution":
			if err := awsRestjson1_deserializeDocumentAwsCloudFrontDistributionDetails(&sv.AwsCloudFrontDistribution, value); err != nil {
				return err
			}

		case "AwsCloudTrailTrail":
			if err := awsRestjson1_deserializeDocumentAwsCloudTrailTrailDetails(&sv.AwsCloudTrailTrail, value); err != nil {
				return err
			}

		case "AwsCodeBuildProject":
			if err := awsRestjson1_deserializeDocumentAwsCodeBuildProjectDetails(&sv.AwsCodeBuildProject, value); err != nil {
				return err
			}

		case "AwsDynamoDbTable":
			if err := awsRestjson1_deserializeDocumentAwsDynamoDbTableDetails(&sv.AwsDynamoDbTable, value); err != nil {
				return err
			}

		case "AwsEc2Eip":
			if err := awsRestjson1_deserializeDocumentAwsEc2EipDetails(&sv.AwsEc2Eip, value); err != nil {
				return err
			}

		case "AwsEc2Instance":
			if err := awsRestjson1_deserializeDocumentAwsEc2InstanceDetails(&sv.AwsEc2Instance, value); err != nil {
				return err
			}

		case "AwsEc2NetworkAcl":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkAclDetails(&sv.AwsEc2NetworkAcl, value); err != nil {
				return err
			}

		case "AwsEc2NetworkInterface":
			if err := awsRestjson1_deserializeDocumentAwsEc2NetworkInterfaceDetails(&sv.AwsEc2NetworkInterface, value); err != nil {
				return err
			}

		case "AwsEc2SecurityGroup":
			if err := awsRestjson1_deserializeDocumentAwsEc2SecurityGroupDetails(&sv.AwsEc2SecurityGroup, value); err != nil {
				return err
			}

		case "AwsEc2Subnet":
			if err := awsRestjson1_deserializeDocumentAwsEc2SubnetDetails(&sv.AwsEc2Subnet, value); err != nil {
				return err
			}

		case "AwsEc2Volume":
			if err := awsRestjson1_deserializeDocumentAwsEc2VolumeDetails(&sv.AwsEc2Volume, value); err != nil {
				return err
			}

		case "AwsEc2Vpc":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpcDetails(&sv.AwsEc2Vpc, value); err != nil {
				return err
			}

		case "AwsEc2VpnConnection":
			if err := awsRestjson1_deserializeDocumentAwsEc2VpnConnectionDetails(&sv.AwsEc2VpnConnection, value); err != nil {
				return err
			}

		case "AwsEcrContainerImage":
			if err := awsRestjson1_deserializeDocumentAwsEcrContainerImageDetails(&sv.AwsEcrContainerImage, value); err != nil {
				return err
			}

		case "AwsEcsCluster":
			if err := awsRestjson1_deserializeDocumentAwsEcsClusterDetails(&sv.AwsEcsCluster, value); err != nil {
				return err
			}

		case "AwsEcsService":
			if err := awsRestjson1_deserializeDocumentAwsEcsServiceDetails(&sv.AwsEcsService, value); err != nil {
				return err
			}

		case "AwsEcsTaskDefinition":
			if err := awsRestjson1_deserializeDocumentAwsEcsTaskDefinitionDetails(&sv.AwsEcsTaskDefinition, value); err != nil {
				return err
			}

		case "AwsElasticBeanstalkEnvironment":
			if err := awsRestjson1_deserializeDocumentAwsElasticBeanstalkEnvironmentDetails(&sv.AwsElasticBeanstalkEnvironment, value); err != nil {
				return err
			}

		case "AwsElasticsearchDomain":
			if err := awsRestjson1_deserializeDocumentAwsElasticsearchDomainDetails(&sv.AwsElasticsearchDomain, value); err != nil {
				return err
			}

		case "AwsElbLoadBalancer":
			if err := awsRestjson1_deserializeDocumentAwsElbLoadBalancerDetails(&sv.AwsElbLoadBalancer, value); err != nil {
				return err
			}

		case "AwsElbv2LoadBalancer":
			if err := awsRestjson1_deserializeDocumentAwsElbv2LoadBalancerDetails(&sv.AwsElbv2LoadBalancer, value); err != nil {
				return err
			}

		case "AwsIamAccessKey":
			if err := awsRestjson1_deserializeDocumentAwsIamAccessKeyDetails(&sv.AwsIamAccessKey, value); err != nil {
				return err
			}

		case "AwsIamGroup":
			if err := awsRestjson1_deserializeDocumentAwsIamGroupDetails(&sv.AwsIamGroup, value); err != nil {
				return err
			}

		case "AwsIamPolicy":
			if err := awsRestjson1_deserializeDocumentAwsIamPolicyDetails(&sv.AwsIamPolicy, value); err != nil {
				return err
			}

		case "AwsIamRole":
			if err := awsRestjson1_deserializeDocumentAwsIamRoleDetails(&sv.AwsIamRole, value); err != nil {
				return err
			}

		case "AwsIamUser":
			if err := awsRestjson1_deserializeDocumentAwsIamUserDetails(&sv.AwsIamUser, value); err != nil {
				return err
			}

		case "AwsKmsKey":
			if err := awsRestjson1_deserializeDocumentAwsKmsKeyDetails(&sv.AwsKmsKey, value); err != nil {
				return err
			}

		case "AwsLambdaFunction":
			if err := awsRestjson1_deserializeDocumentAwsLambdaFunctionDetails(&sv.AwsLambdaFunction, value); err != nil {
				return err
			}

		case "AwsLambdaLayerVersion":
			if err := awsRestjson1_deserializeDocumentAwsLambdaLayerVersionDetails(&sv.AwsLambdaLayerVersion, value); err != nil {
				return err
			}

		case "AwsRdsDbCluster":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterDetails(&sv.AwsRdsDbCluster, value); err != nil {
				return err
			}

		case "AwsRdsDbClusterSnapshot":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbClusterSnapshotDetails(&sv.AwsRdsDbClusterSnapshot, value); err != nil {
				return err
			}

		case "AwsRdsDbInstance":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbInstanceDetails(&sv.AwsRdsDbInstance, value); err != nil {
				return err
			}

		case "AwsRdsDbSnapshot":
			if err := awsRestjson1_deserializeDocumentAwsRdsDbSnapshotDetails(&sv.AwsRdsDbSnapshot, value); err != nil {
				return err
			}

		case "AwsRdsEventSubscription":
			if err := awsRestjson1_deserializeDocumentAwsRdsEventSubscriptionDetails(&sv.AwsRdsEventSubscription, value); err != nil {
				return err
			}

		case "AwsRedshiftCluster":
			if err := awsRestjson1_deserializeDocumentAwsRedshiftClusterDetails(&sv.AwsRedshiftCluster, value); err != nil {
				return err
			}

		case "AwsS3AccountPublicAccessBlock":
			if err := awsRestjson1_deserializeDocumentAwsS3AccountPublicAccessBlockDetails(&sv.AwsS3AccountPublicAccessBlock, value); err != nil {
				return err
			}

		case "AwsS3Bucket":
			if err := awsRestjson1_deserializeDocumentAwsS3BucketDetails(&sv.AwsS3Bucket, value); err != nil {
				return err
			}

		case "AwsS3Object":
			if err := awsRestjson1_deserializeDocumentAwsS3ObjectDetails(&sv.AwsS3Object, value); err != nil {
				return err
			}

		case "AwsSecretsManagerSecret":
			if err := awsRestjson1_deserializeDocumentAwsSecretsManagerSecretDetails(&sv.AwsSecretsManagerSecret, value); err != nil {
				return err
			}

		case "AwsSnsTopic":
			if err := awsRestjson1_deserializeDocumentAwsSnsTopicDetails(&sv.AwsSnsTopic, value); err != nil {
				return err
			}

		case "AwsSqsQueue":
			if err := awsRestjson1_deserializeDocumentAwsSqsQueueDetails(&sv.AwsSqsQueue, value); err != nil {
				return err
			}

		case "AwsSsmPatchCompliance":
			if err := awsRestjson1_deserializeDocumentAwsSsmPatchComplianceDetails(&sv.AwsSsmPatchCompliance, value); err != nil {
				return err
			}

		case "AwsWafWebAcl":
			if err := awsRestjson1_deserializeDocumentAwsWafWebAclDetails(&sv.AwsWafWebAcl, value); err != nil {
				return err
			}

		case "Container":
			if err := awsRestjson1_deserializeDocumentContainerDetails(&sv.Container, value); err != nil {
				return err
			}

		case "Other":
			if err := awsRestjson1_deserializeDocumentFieldMap(&sv.Other, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResourceList(v *[]types.Resource, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Resource
	if *v == nil {
		cv = []types.Resource{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Resource
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentResource(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentResourceNotFoundException(v **types.ResourceNotFoundException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceNotFoundException
	if *v == nil {
		sv = &types.ResourceNotFoundException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Code":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Code = ptr.String(jtv)
			}

		case "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResult(v **types.Result, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Result
	if *v == nil {
		sv = &types.Result{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "AccountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "ProcessingResult":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ProcessingResult = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentResultList(v *[]types.Result, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Result
	if *v == nil {
		cv = []types.Result{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Result
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentResult(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentSecurityGroups(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentSensitiveDataDetections(v **types.SensitiveDataDetections, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SensitiveDataDetections
	if *v == nil {
		sv = &types.SensitiveDataDetections{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = i64
			}

		case "Occurrences":
			if err := awsRestjson1_deserializeDocumentOccurrences(&sv.Occurrences, value); err != nil {
				return err
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSensitiveDataDetectionsList(v *[]types.SensitiveDataDetections, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SensitiveDataDetections
	if *v == nil {
		cv = []types.SensitiveDataDetections{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SensitiveDataDetections
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSensitiveDataDetections(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentSensitiveDataResult(v **types.SensitiveDataResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SensitiveDataResult
	if *v == nil {
		sv = &types.SensitiveDataResult{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Category":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Category = ptr.String(jtv)
			}

		case "Detections":
			if err := awsRestjson1_deserializeDocumentSensitiveDataDetectionsList(&sv.Detections, value); err != nil {
				return err
			}

		case "TotalCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Long to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.TotalCount = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSensitiveDataResultList(v *[]types.SensitiveDataResult, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SensitiveDataResult
	if *v == nil {
		cv = []types.SensitiveDataResult{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SensitiveDataResult
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSensitiveDataResult(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentSeverity(v **types.Severity, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Severity
	if *v == nil {
		sv = &types.Severity{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Label":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SeverityLabel to be of type string, got %T instead", value)
				}
				sv.Label = types.SeverityLabel(jtv)
			}

		case "Normalized":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Integer to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Normalized = int32(i64)
			}

		case "Original":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Original = ptr.String(jtv)
			}

		case "Product":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.Product = f64

				case string:
					var f64 float64
					switch {
					case strings.EqualFold(jtv, "NaN"):
						f64 = math.NaN()

					case strings.EqualFold(jtv, "Infinity"):
						f64 = math.Inf(1)

					case strings.EqualFold(jtv, "-Infinity"):
						f64 = math.Inf(-1)

					default:
						return fmt.Errorf("unknown JSON number value: %s", jtv)

					}
					sv.Product = f64

				default:
					return fmt.Errorf("expected Double to be a JSON Number, got %T instead", value)

				}
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSoftwarePackage(v **types.SoftwarePackage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SoftwarePackage
	if *v == nil {
		sv = &types.SoftwarePackage{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Architecture":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Architecture = ptr.String(jtv)
			}

		case "Epoch":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Epoch = ptr.String(jtv)
			}

		case "FilePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.FilePath = ptr.String(jtv)
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "PackageManager":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.PackageManager = ptr.String(jtv)
			}

		case "Release":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Release = ptr.String(jtv)
			}

		case "Version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentSoftwarePackageList(v *[]types.SoftwarePackage, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SoftwarePackage
	if *v == nil {
		cv = []types.SoftwarePackage{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SoftwarePackage
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentSoftwarePackage(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentStandard(v **types.Standard, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Standard
	if *v == nil {
		sv = &types.Standard{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "EnabledByDefault":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Boolean to be of type *bool, got %T instead", value)
				}
				sv.EnabledByDefault = jtv
			}

		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "StandardsArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StandardsArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentStandards(v *[]types.Standard, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Standard
	if *v == nil {
		cv = []types.Standard{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Standard
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentStandard(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentStandardsControl(v **types.StandardsControl, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StandardsControl
	if *v == nil {
		sv = &types.StandardsControl{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "ControlId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ControlId = ptr.String(jtv)
			}

		case "ControlStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ControlStatus to be of type string, got %T instead", value)
				}
				sv.ControlStatus = types.ControlStatus(jtv)
			}

		case "ControlStatusUpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Timestamp to be of type string, got %T instead", value)
				}
				t, err := smithytime.ParseDateTime(jtv)
				if err != nil {
					return err
				}
				sv.ControlStatusUpdatedAt = ptr.Time(t)
			}

		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "DisabledReason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.DisabledReason = ptr.String(jtv)
			}

		case "RelatedRequirements":
			if err := awsRestjson1_deserializeDocumentRelatedRequirementsList(&sv.RelatedRequirements, value); err != nil {
				return err
			}

		case "RemediationUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RemediationUrl = ptr.String(jtv)
			}

		case "SeverityRating":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SeverityRating to be of type string, got %T instead", value)
				}
				sv.SeverityRating = types.SeverityRating(jtv)
			}

		case "StandardsControlArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StandardsControlArn = ptr.String(jtv)
			}

		case "Title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentStandardsControls(v *[]types.StandardsControl, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.StandardsControl
	if *v == nil {
		cv = []types.StandardsControl{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.StandardsControl
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentStandardsControl(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentStandardsInputParameterMap(v *map[string]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]string
	if *v == nil {
		mv = map[string]string{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			parsedVal = jtv
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentStandardsSubscription(v **types.StandardsSubscription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StandardsSubscription
	if *v == nil {
		sv = &types.StandardsSubscription{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "StandardsArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StandardsArn = ptr.String(jtv)
			}

		case "StandardsInput":
			if err := awsRestjson1_deserializeDocumentStandardsInputParameterMap(&sv.StandardsInput, value); err != nil {
				return err
			}

		case "StandardsStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StandardsStatus to be of type string, got %T instead", value)
				}
				sv.StandardsStatus = types.StandardsStatus(jtv)
			}

		case "StandardsSubscriptionArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.StandardsSubscriptionArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentStandardsSubscriptions(v *[]types.StandardsSubscription, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.StandardsSubscription
	if *v == nil {
		cv = []types.StandardsSubscription{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.StandardsSubscription
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentStandardsSubscription(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentStatusReason(v **types.StatusReason, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StatusReason
	if *v == nil {
		sv = &types.StatusReason{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "ReasonCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.ReasonCode = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentStatusReasonsList(v *[]types.StatusReason, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.StatusReason
	if *v == nil {
		cv = []types.StatusReason{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.StatusReason
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentStatusReason(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentStringFilter(v **types.StringFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StringFilter
	if *v == nil {
		sv = &types.StringFilter{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Comparison":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StringFilterComparison to be of type string, got %T instead", value)
				}
				sv.Comparison = types.StringFilterComparison(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentStringFilterList(v *[]types.StringFilter, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.StringFilter
	if *v == nil {
		cv = []types.StringFilter{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.StringFilter
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentStringFilter(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentStringList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentTagMap(v *map[string]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]string
	if *v == nil {
		mv = map[string]string{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected TagValue to be of type string, got %T instead", value)
			}
			parsedVal = jtv
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsRestjson1_deserializeDocumentThreatIntelIndicator(v **types.ThreatIntelIndicator, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ThreatIntelIndicator
	if *v == nil {
		sv = &types.ThreatIntelIndicator{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Category":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ThreatIntelIndicatorCategory to be of type string, got %T instead", value)
				}
				sv.Category = types.ThreatIntelIndicatorCategory(jtv)
			}

		case "LastObservedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.LastObservedAt = ptr.String(jtv)
			}

		case "Source":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Source = ptr.String(jtv)
			}

		case "SourceUrl":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.SourceUrl = ptr.String(jtv)
			}

		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ThreatIntelIndicatorType to be of type string, got %T instead", value)
				}
				sv.Type = types.ThreatIntelIndicatorType(jtv)
			}

		case "Value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentThreatIntelIndicatorList(v *[]types.ThreatIntelIndicator, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ThreatIntelIndicator
	if *v == nil {
		cv = []types.ThreatIntelIndicator{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ThreatIntelIndicator
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentThreatIntelIndicator(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentTypeList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentVulnerability(v **types.Vulnerability, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Vulnerability
	if *v == nil {
		sv = &types.Vulnerability{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Cvss":
			if err := awsRestjson1_deserializeDocumentCvssList(&sv.Cvss, value); err != nil {
				return err
			}

		case "Id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "ReferenceUrls":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.ReferenceUrls, value); err != nil {
				return err
			}

		case "RelatedVulnerabilities":
			if err := awsRestjson1_deserializeDocumentStringList(&sv.RelatedVulnerabilities, value); err != nil {
				return err
			}

		case "Vendor":
			if err := awsRestjson1_deserializeDocumentVulnerabilityVendor(&sv.Vendor, value); err != nil {
				return err
			}

		case "VulnerablePackages":
			if err := awsRestjson1_deserializeDocumentSoftwarePackageList(&sv.VulnerablePackages, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentVulnerabilityList(v *[]types.Vulnerability, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Vulnerability
	if *v == nil {
		cv = []types.Vulnerability{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Vulnerability
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentVulnerability(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentVulnerabilityVendor(v **types.VulnerabilityVendor, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.VulnerabilityVendor
	if *v == nil {
		sv = &types.VulnerabilityVendor{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "Url":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Url = ptr.String(jtv)
			}

		case "VendorCreatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VendorCreatedAt = ptr.String(jtv)
			}

		case "VendorSeverity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VendorSeverity = ptr.String(jtv)
			}

		case "VendorUpdatedAt":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.VendorUpdatedAt = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWafAction(v **types.WafAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WafAction
	if *v == nil {
		sv = &types.WafAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWafExcludedRule(v **types.WafExcludedRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WafExcludedRule
	if *v == nil {
		sv = &types.WafExcludedRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "RuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.RuleId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWafExcludedRuleList(v *[]types.WafExcludedRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WafExcludedRule
	if *v == nil {
		cv = []types.WafExcludedRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WafExcludedRule
		destAddr := &col
		if err := awsRestjson1_deserializeDocumentWafExcludedRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsRestjson1_deserializeDocumentWafOverrideAction(v **types.WafOverrideAction, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WafOverrideAction
	if *v == nil {
		sv = &types.WafOverrideAction{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Type":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NonEmptyString to be of type string, got %T instead", value)
				}
				sv.Type = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsRestjson1_deserializeDocumentWorkflow(v **types.Workflow, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Workflow
	if *v == nil {
		sv = &types.Workflow{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "Status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.WorkflowStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}
