// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the available standards in Security Hub. For each standard,
// the results include the standard ARN, the name, and a description.
func (c *Client) DescribeStandards(ctx context.Context, params *DescribeStandardsInput, optFns ...func(*Options)) (*DescribeStandardsOutput, error) {
	if params == nil {
		params = &DescribeStandardsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeStandards", params, optFns, c.addOperationDescribeStandardsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeStandardsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeStandardsInput struct {

	// The maximum number of standards to return.
	MaxResults int32

	// The token that is required for pagination. On your first call to the
	// DescribeStandards operation, set the value of this parameter to NULL. For
	// subsequent calls to the operation, to continue listing data, set the value of
	// this parameter to the value returned from the previous response.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeStandardsOutput struct {

	// The pagination token to use to request the next page of results.
	NextToken *string

	// A list of available standards.
	Standards []types.Standard

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeStandardsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeStandards{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeStandards{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeStandards(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeStandardsAPIClient is a client that implements the DescribeStandards
// operation.
type DescribeStandardsAPIClient interface {
	DescribeStandards(context.Context, *DescribeStandardsInput, ...func(*Options)) (*DescribeStandardsOutput, error)
}

var _ DescribeStandardsAPIClient = (*Client)(nil)

// DescribeStandardsPaginatorOptions is the paginator options for DescribeStandards
type DescribeStandardsPaginatorOptions struct {
	// The maximum number of standards to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeStandardsPaginator is a paginator for DescribeStandards
type DescribeStandardsPaginator struct {
	options   DescribeStandardsPaginatorOptions
	client    DescribeStandardsAPIClient
	params    *DescribeStandardsInput
	nextToken *string
	firstPage bool
}

// NewDescribeStandardsPaginator returns a new DescribeStandardsPaginator
func NewDescribeStandardsPaginator(client DescribeStandardsAPIClient, params *DescribeStandardsInput, optFns ...func(*DescribeStandardsPaginatorOptions)) *DescribeStandardsPaginator {
	if params == nil {
		params = &DescribeStandardsInput{}
	}

	options := DescribeStandardsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeStandardsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeStandardsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribeStandards page.
func (p *DescribeStandardsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeStandardsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.DescribeStandards(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeStandards(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securityhub",
		OperationName: "DescribeStandards",
	}
}
