// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information for one billing record.
type BillingRecord struct {

	// The date that the operation was billed, in Unix format.
	BillDate *time.Time

	// The name of the domain that the billing record applies to. If the domain name
	// contains characters other than a-z, 0-9, and - (hyphen), such as an
	// internationalized domain name, then this value is in Punycode. For more
	// information, see DNS Domain Name Format
	// (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
	// in the Amazon Route 53 Developer Guide.
	DomainName *string

	// The ID of the invoice that is associated with the billing record.
	InvoiceId *string

	// The operation that you were charged for.
	Operation OperationType

	// The price that you were charged for the operation, in US dollars. Example value:
	// 12.0
	Price float64

	noSmithyDocumentSerde
}

// ContactDetail includes the following elements.
type ContactDetail struct {

	// First line of the contact's address.
	AddressLine1 *string

	// Second line of contact's address, if any.
	AddressLine2 *string

	// The city of the contact's address.
	City *string

	// Indicates whether the contact is a person, company, association, or public
	// organization. Note the following:
	//
	// * If you specify a value other than PERSON,
	// you must also specify a value for OrganizationName.
	//
	// * For some TLDs, the
	// privacy protection available depends on the value that you specify for Contact
	// Type. For the privacy protection settings for your TLD, see Domains that You Can
	// Register with Amazon Route 53
	// (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
	// in the Amazon Route 53 Developer Guide
	//
	// * For .es domains, if you specify
	// PERSON, you must specify INDIVIDUAL for the value of ES_LEGAL_FORM.
	ContactType ContactType

	// Code for the country of the contact's address.
	CountryCode CountryCode

	// Email address of the contact.
	Email *string

	// A list of name-value pairs for parameters required by certain top-level domains.
	ExtraParams []ExtraParam

	// Fax number of the contact. Constraints: Phone number must be specified in the
	// format "+[country dialing code].[number including any area code]". For example,
	// a US phone number might appear as "+1.1234567890".
	Fax *string

	// First name of contact.
	FirstName *string

	// Last name of contact.
	LastName *string

	// Name of the organization for contact types other than PERSON.
	OrganizationName *string

	// The phone number of the contact. Constraints: Phone number must be specified in
	// the format "+[country dialing code].[number including any area code>]". For
	// example, a US phone number might appear as "+1.1234567890".
	PhoneNumber *string

	// The state or province of the contact's city.
	State *string

	// The zip or postal code of the contact's address.
	ZipCode *string

	noSmithyDocumentSerde
}

// Information about one suggested domain name.
type DomainSuggestion struct {

	// Whether the domain name is available for registering. You can register only the
	// domains that are designated as AVAILABLE. Valid values: AVAILABLE The domain
	// name is available. AVAILABLE_RESERVED The domain name is reserved under specific
	// conditions. AVAILABLE_PREORDER The domain name is available and can be
	// preordered. DONT_KNOW The TLD registry didn't reply with a definitive answer
	// about whether the domain name is available. Route 53 can return this response
	// for a variety of reasons, for example, the registry is performing maintenance.
	// Try again later. PENDING The TLD registry didn't return a response in the
	// expected amount of time. When the response is delayed, it usually takes just a
	// few extra seconds. You can resubmit the request immediately. RESERVED The domain
	// name has been reserved for another person or organization. UNAVAILABLE The
	// domain name is not available. UNAVAILABLE_PREMIUM The domain name is not
	// available. UNAVAILABLE_RESTRICTED The domain name is forbidden.
	Availability *string

	// A suggested domain name.
	DomainName *string

	noSmithyDocumentSerde
}

// Summary information about one domain.
type DomainSummary struct {

	// The name of the domain that the summary information applies to.
	//
	// This member is required.
	DomainName *string

	// Indicates whether the domain is automatically renewed upon expiration.
	AutoRenew *bool

	// Expiration date of the domain in Unix time format and Coordinated Universal Time
	// (UTC).
	Expiry *time.Time

	// Indicates whether a domain is locked from unauthorized transfer to another
	// party.
	TransferLock *bool

	noSmithyDocumentSerde
}

// A complex type that contains information about whether the specified domain can
// be transferred to Route 53.
type DomainTransferability struct {

	// Whether the domain name can be transferred to Route 53. You can transfer only
	// domains that have a value of TRANSFERABLE for Transferable. Valid values:
	// TRANSFERABLE The domain name can be transferred to Route 53. UNTRANSFERRABLE The
	// domain name can't be transferred to Route 53. DONT_KNOW Reserved for future use.
	Transferable Transferable

	noSmithyDocumentSerde
}

// ExtraParam includes the following elements.
type ExtraParam struct {

	// The name of an additional parameter that is required by a top-level domain. Here
	// are the top-level domains that require additional parameters and the names of
	// the parameters that they require: .com.au and .net.au
	//
	// * AU_ID_NUMBER
	//
	// *
	// AU_ID_TYPE Valid values include the following:
	//
	// * ABN (Australian business
	// number)
	//
	// * ACN (Australian company number)
	//
	// * TM (Trademark number)
	//
	// .ca
	//
	// *
	// BRAND_NUMBER
	//
	// * CA_BUSINESS_ENTITY_TYPE Valid values include the following:
	//
	// *
	// BANK (Bank)
	//
	// * COMMERCIAL_COMPANY (Commercial company)
	//
	// * COMPANY (Company)
	//
	// *
	// COOPERATION (Cooperation)
	//
	// * COOPERATIVE (Cooperative)
	//
	// * COOPRIX (Cooprix)
	//
	// *
	// CORP (Corporation)
	//
	// * CREDIT_UNION (Credit union)
	//
	// * FOMIA (Federation of mutual
	// insurance associations)
	//
	// * INC (Incorporated)
	//
	// * LTD (Limited)
	//
	// * LTEE
	// (Limitée)
	//
	// * LLC (Limited liability corporation)
	//
	// * LLP (Limited liability
	// partnership)
	//
	// * LTE (Lte.)
	//
	// * MBA (Mutual benefit association)
	//
	// * MIC (Mutual
	// insurance company)
	//
	// * NFP (Not-for-profit corporation)
	//
	// * SA (S.A.)
	//
	// *
	// SAVINGS_COMPANY (Savings company)
	//
	// * SAVINGS_UNION (Savings union)
	//
	// * SARL
	// (Société à responsabilité limitée)
	//
	// * TRUST (Trust)
	//
	// * ULC (Unlimited liability
	// corporation)
	//
	// * CA_LEGAL_TYPE When ContactType is PERSON, valid values include
	// the following:
	//
	// * ABO (Aboriginal Peoples indigenous to Canada)
	//
	// * CCT (Canadian
	// citizen)
	//
	// * LGR (Legal Representative of a Canadian Citizen or Permanent
	// Resident)
	//
	// * RES (Permanent resident of Canada)
	//
	// When ContactType is a value
	// other than PERSON, valid values include the following:
	//
	// * ASS (Canadian
	// unincorporated association)
	//
	// * CCO (Canadian corporation)
	//
	// * EDU (Canadian
	// educational institution)
	//
	// * GOV (Government or government entity in Canada)
	//
	// *
	// HOP (Canadian Hospital)
	//
	// * INB (Indian Band recognized by the Indian Act of
	// Canada)
	//
	// * LAM (Canadian Library, Archive, or Museum)
	//
	// * MAJ (Her/His Majesty
	// the Queen/King)
	//
	// * OMK (Official mark registered in Canada)
	//
	// * PLT (Canadian
	// Political Party)
	//
	// * PRT (Partnership Registered in Canada)
	//
	// * TDM (Trademark
	// registered in Canada)
	//
	// * TRD (Canadian Trade Union)
	//
	// * TRS (Trust established in
	// Canada)
	//
	// .es
	//
	// * ES_IDENTIFICATION Specify the applicable value:
	//
	// * For contacts
	// inside Spain: Enter your passport ID.
	//
	// * For contacts outside of Spain: Enter
	// the VAT identification number for the company. For .es domains, the value of
	// ContactType must be PERSON.
	//
	// * ES_IDENTIFICATION_TYPE Valid values include the
	// following:
	//
	// * DNI_AND_NIF (For Spanish contacts)
	//
	// * NIE (For foreigners with
	// legal residence)
	//
	// * OTHER (For contacts outside of Spain)
	//
	// * ES_LEGAL_FORM Valid
	// values include the following:
	//
	// * ASSOCIATION
	//
	// * CENTRAL_GOVERNMENT_BODY
	//
	// *
	// CIVIL_SOCIETY
	//
	// * COMMUNITY_OF_OWNERS
	//
	// * COMMUNITY_PROPERTY
	//
	// * CONSULATE
	//
	// *
	// COOPERATIVE
	//
	// * DESIGNATION_OF_ORIGIN_SUPERVISORY_COUNCIL
	//
	// *
	// ECONOMIC_INTEREST_GROUP
	//
	// * EMBASSY
	//
	// * ENTITY_MANAGING_NATURAL_AREAS
	//
	// *
	// FARM_PARTNERSHIP
	//
	// * FOUNDATION
	//
	// * GENERAL_AND_LIMITED_PARTNERSHIP
	//
	// *
	// GENERAL_PARTNERSHIP
	//
	// * INDIVIDUAL
	//
	// * LIMITED_COMPANY
	//
	// * LOCAL_AUTHORITY
	//
	// *
	// LOCAL_PUBLIC_ENTITY
	//
	// * MUTUAL_INSURANCE_COMPANY
	//
	// * NATIONAL_PUBLIC_ENTITY
	//
	// *
	// ORDER_OR_RELIGIOUS_INSTITUTION
	//
	// * OTHERS (Only for contacts outside of Spain)
	//
	// *
	// POLITICAL_PARTY
	//
	// * PROFESSIONAL_ASSOCIATION
	//
	// * PUBLIC_LAW_ASSOCIATION
	//
	// *
	// PUBLIC_LIMITED_COMPANY
	//
	// * REGIONAL_GOVERNMENT_BODY
	//
	// * REGIONAL_PUBLIC_ENTITY
	//
	// *
	// SAVINGS_BANK
	//
	// * SPANISH_OFFICE
	//
	// * SPORTS_ASSOCIATION
	//
	// * SPORTS_FEDERATION
	//
	// *
	// SPORTS_LIMITED_COMPANY
	//
	// * TEMPORARY_ALLIANCE_OF_ENTERPRISES
	//
	// * TRADE_UNION
	//
	// *
	// WORKER_OWNED_COMPANY
	//
	// * WORKER_OWNED_LIMITED_COMPANY
	//
	// .fi
	//
	// *
	// BIRTH_DATE_IN_YYYY_MM_DD
	//
	// * FI_BUSINESS_NUMBER
	//
	// * FI_ID_NUMBER
	//
	// * FI_NATIONALITY
	// Valid values include the following:
	//
	// * FINNISH
	//
	// * NOT_FINNISH
	//
	// *
	// FI_ORGANIZATION_TYPE Valid values include the following:
	//
	// * COMPANY
	//
	// *
	// CORPORATION
	//
	// * GOVERNMENT
	//
	// * INSTITUTION
	//
	// * POLITICAL_PARTY
	//
	// *
	// PUBLIC_COMMUNITY
	//
	// * TOWNSHIP
	//
	// .fr
	//
	// * BIRTH_CITY
	//
	// * BIRTH_COUNTRY
	//
	// *
	// BIRTH_DATE_IN_YYYY_MM_DD
	//
	// * BIRTH_DEPARTMENT: Specify the INSEE code that
	// corresponds with the department where the contact was born. If the contact was
	// born somewhere other than France or its overseas departments, specify 99. For
	// more information, including a list of departments and the corresponding INSEE
	// numbers, see the Wikipedia entry Departments of France
	// (https://en.wikipedia.org/wiki/Departments_of_France).
	//
	// * BRAND_NUMBER
	//
	// .it
	//
	// *
	// IT_NATIONALITY
	//
	// * IT_PIN
	//
	// * IT_REGISTRANT_ENTITY_TYPE Valid values include the
	// following:
	//
	// * FOREIGNERS
	//
	// * FREELANCE_WORKERS (Freelance workers and
	// professionals)
	//
	// * ITALIAN_COMPANIES (Italian companies and one-person
	// companies)
	//
	// * NON_PROFIT_ORGANIZATIONS
	//
	// * OTHER_SUBJECTS
	//
	// *
	// PUBLIC_ORGANIZATIONS
	//
	// .ru
	//
	// * BIRTH_DATE_IN_YYYY_MM_DD
	//
	// *
	// RU_PASSPORT_DATA
	//
	// .se
	//
	// * BIRTH_COUNTRY
	//
	// * SE_ID_NUMBER
	//
	// .sg
	//
	// *
	// SG_ID_NUMBER
	//
	// .co.uk, .me.uk, and .org.uk
	//
	// * UK_CONTACT_TYPE Valid values
	// include the following:
	//
	// * CRC (UK Corporation by Royal Charter)
	//
	// * FCORP (Non-UK
	// Corporation)
	//
	// * FIND (Non-UK Individual, representing self)
	//
	// * FOTHER (Non-UK
	// Entity that does not fit into any other category)
	//
	// * GOV (UK Government Body)
	//
	// *
	// IND (UK Individual (representing self))
	//
	// * IP (UK Industrial/Provident
	// Registered Company)
	//
	// * LLP (UK Limited Liability Partnership)
	//
	// * LTD (UK Limited
	// Company)
	//
	// * OTHER (UK Entity that does not fit into any other category)
	//
	// * PLC
	// (UK Public Limited Company)
	//
	// * PTNR (UK Partnership)
	//
	// * RCHAR (UK Registered
	// Charity)
	//
	// * SCH (UK School)
	//
	// * STAT (UK Statutory Body)
	//
	// * STRA (UK Sole
	// Trader)
	//
	// * UK_COMPANY_NUMBER
	//
	// In addition, many TLDs require a VAT_NUMBER.
	//
	// This member is required.
	Name ExtraParamName

	// The value that corresponds with the name of an extra parameter.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Nameserver includes the following elements.
type Nameserver struct {

	// The fully qualified host name of the name server. Constraint: Maximum 255
	// characters
	//
	// This member is required.
	Name *string

	// Glue IP address of a name server entry. Glue IP addresses are required only when
	// the name of the name server is a subdomain of the domain. For example, if your
	// domain is example.com and the name server for the domain is ns.example.com, you
	// need to specify the IP address for ns.example.com. Constraints: The list can
	// contain only one IPv4 and one IPv6 address.
	GlueIps []string

	noSmithyDocumentSerde
}

// OperationSummary includes the following elements.
type OperationSummary struct {

	// Identifier returned to track the requested action.
	//
	// This member is required.
	OperationId *string

	// The current status of the requested operation in the system.
	//
	// This member is required.
	Status OperationStatus

	// The date when the request was submitted.
	//
	// This member is required.
	SubmittedDate *time.Time

	// Type of the action requested.
	//
	// This member is required.
	Type OperationType

	noSmithyDocumentSerde
}

// Each tag includes the following elements.
type Tag struct {

	// The key (name) of a tag. Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"
	// Constraints: Each key can be 1-128 characters long.
	Key *string

	// The value of a tag. Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@" Constraints:
	// Each value can be 0-256 characters long.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
