// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The Amazon QuickSight customizations associated with your Amazon Web Services
// account or a Amazon QuickSight namespace in a specific Amazon Web Services
// Region;.
type AccountCustomization struct {

	// The default theme for this Amazon QuickSight subscription.
	DefaultTheme *string

	noSmithyDocumentSerde
}

// The Amazon QuickSight settings associated with your Amazon Web Services account.
type AccountSettings struct {

	// The "account name" you provided for the Amazon QuickSight subscription in your
	// Amazon Web Services account. You create this name when you sign up for Amazon
	// QuickSight. It is unique in all of Amazon Web Services and it appears only when
	// users sign in.
	AccountName *string

	// The default Amazon QuickSight namespace for your Amazon Web Services account.
	DefaultNamespace *string

	// The edition of Amazon QuickSight that you're currently subscribed to: Enterprise
	// edition or Standard edition.
	Edition Edition

	// The main notification email for your Amazon QuickSight subscription.
	NotificationEmail *string

	noSmithyDocumentSerde
}

// The active Identity and Access Management (IAM) policy assignment.
type ActiveIAMPolicyAssignment struct {

	// A name for the IAMpolicy assignment.
	AssignmentName *string

	// The Amazon Resource Name (ARN) of the resource.
	PolicyArn *string

	noSmithyDocumentSerde
}

// Ad hoc (one-time) filtering option.
type AdHocFilteringOption struct {

	// Availability status.
	AvailabilityStatus DashboardBehavior

	noSmithyDocumentSerde
}

// The parameters for Elasticsearch.
type AmazonElasticsearchParameters struct {

	// The Elasticsearch domain.
	//
	// This member is required.
	Domain *string

	noSmithyDocumentSerde
}

type AmazonOpenSearchParameters struct {

	// This member is required.
	Domain *string

	noSmithyDocumentSerde
}

// Metadata structure for an analysis in Amazon QuickSight
type Analysis struct {

	// The ID of the analysis.
	AnalysisId *string

	// The Amazon Resource Name (ARN) of the analysis.
	Arn *string

	// The time that the analysis was created.
	CreatedTime *time.Time

	// The ARNs of the datasets of the analysis.
	DataSetArns []string

	// Errors associated with the analysis.
	Errors []AnalysisError

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time

	// The descriptive name of the analysis.
	Name *string

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []Sheet

	// Status associated with the analysis.
	Status ResourceStatus

	// The ARN of the theme of the analysis.
	ThemeArn *string

	noSmithyDocumentSerde
}

// Analysis error.
type AnalysisError struct {

	// The message associated with the analysis error.
	Message *string

	// The type of the analysis error.
	Type AnalysisErrorType

	noSmithyDocumentSerde
}

// A filter that you apply when searching for one or more analyses.
type AnalysisSearchFilter struct {

	// The name of the value that you want to use as a filter, for example "Name":
	// "QUICKSIGHT_USER".
	Name AnalysisFilterAttribute

	// The comparison operator that you want to use as a filter, for example
	// "Operator": "StringEquals".
	Operator FilterOperator

	// The value of the named item, in this case QUICKSIGHT_USER, that you want to use
	// as a filter, for example "Value". An example is
	// "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string

	noSmithyDocumentSerde
}

// The source entity of an analysis.
type AnalysisSourceEntity struct {

	// The source template for the source entity of the analysis.
	SourceTemplate *AnalysisSourceTemplate

	noSmithyDocumentSerde
}

// The source template of an analysis.
type AnalysisSourceTemplate struct {

	// The Amazon Resource Name (ARN) of the source template of an analysis.
	//
	// This member is required.
	Arn *string

	// The dataset references of the source template of an analysis.
	//
	// This member is required.
	DataSetReferences []DataSetReference

	noSmithyDocumentSerde
}

// The summary metadata that describes an analysis.
type AnalysisSummary struct {

	// The ID of the analysis. This ID displays in the URL.
	AnalysisId *string

	// The Amazon Resource Name (ARN) for the analysis.
	Arn *string

	// The time that the analysis was created.
	CreatedTime *time.Time

	// The time that the analysis was last updated.
	LastUpdatedTime *time.Time

	// The name of the analysis. This name is displayed in the Amazon QuickSight
	// console.
	Name *string

	// The last known status for the analysis.
	Status ResourceStatus

	noSmithyDocumentSerde
}

// Information about the dashboard that you want to embed.
type AnonymousUserDashboardEmbeddingConfiguration struct {

	// The dashboard ID for the dashboard that you want the user to see first. This ID
	// is included in the output URL. When the URL in response is accessed, Amazon
	// QuickSight renders this dashboard. The Amazon Resource Name (ARN) of this
	// dashboard must be included in the AuthorizedResourceArns parameter. Otherwise,
	// the request will fail with InvalidParameterValueException.
	//
	// This member is required.
	InitialDashboardId *string

	noSmithyDocumentSerde
}

// The type of experience you want to embed. For anonymous users, you can embed an
// Amazon QuickSight dashboard.
type AnonymousUserEmbeddingExperienceConfiguration struct {

	// The type of embedding experience. In this case, an Amazon QuickSight dashboard.
	Dashboard *AnonymousUserDashboardEmbeddingConfiguration

	noSmithyDocumentSerde
}

// Parameters for Amazon Athena.
type AthenaParameters struct {

	// The workgroup that Amazon Athena uses.
	WorkGroup *string

	noSmithyDocumentSerde
}

// Parameters for Amazon Aurora.
type AuroraParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// Parameters for Amazon Aurora PostgreSQL-Compatible Edition.
type AuroraPostgreSqlParameters struct {

	// The Amazon Aurora PostgreSQL database to connect to.
	//
	// This member is required.
	Database *string

	// The Amazon Aurora PostgreSQL-Compatible host to connect to.
	//
	// This member is required.
	Host *string

	// The port that Amazon Aurora PostgreSQL is listening on.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// The parameters for IoT Analytics.
type AwsIotAnalyticsParameters struct {

	// Dataset name.
	//
	// This member is required.
	DataSetName *string

	noSmithyDocumentSerde
}

// The display options for tile borders for visuals.
type BorderStyle struct {

	// The option to enable display of borders for visuals.
	Show bool

	noSmithyDocumentSerde
}

// A calculated column for a dataset.
type CalculatedColumn struct {

	// A unique ID to identify a calculated column. During a dataset update, if the
	// column ID of a calculated column matches that of an existing calculated column,
	// Amazon QuickSight preserves the existing calculated column.
	//
	// This member is required.
	ColumnId *string

	// Column name.
	//
	// This member is required.
	ColumnName *string

	// An expression that defines the calculated column.
	//
	// This member is required.
	Expression *string

	noSmithyDocumentSerde
}

// A transform operation that casts a column to a different type.
type CastColumnTypeOperation struct {

	// Column name.
	//
	// This member is required.
	ColumnName *string

	// New column data type.
	//
	// This member is required.
	NewColumnType ColumnDataType

	// When casting a column from string to datetime type, you can supply a string in a
	// format supported by Amazon QuickSight to denote the source data format.
	Format *string

	noSmithyDocumentSerde
}

// Metadata that contains a description for a column.
type ColumnDescription struct {

	// The text of a description for a column.
	Text *string

	noSmithyDocumentSerde
}

// Groupings of columns that work together in certain Amazon QuickSight features.
// This is a variant type structure. For this structure to be valid, only one of
// the attributes can be non-null.
type ColumnGroup struct {

	// Geospatial column group that denotes a hierarchy.
	GeoSpatialColumnGroup *GeoSpatialColumnGroup

	noSmithyDocumentSerde
}

// A structure describing the name, data type, and geographic role of the columns.
type ColumnGroupColumnSchema struct {

	// The name of the column group's column schema.
	Name *string

	noSmithyDocumentSerde
}

// The column group schema.
type ColumnGroupSchema struct {

	// A structure containing the list of schemas for column group columns.
	ColumnGroupColumnSchemaList []ColumnGroupColumnSchema

	// The name of the column group schema.
	Name *string

	noSmithyDocumentSerde
}

// A rule defined to grant access on one or more restricted columns. Each dataset
// can have multiple rules. To create a restricted column, you add it to one or
// more rules. Each rule must contain at least one column and at least one user or
// group. To be able to see a restricted column, a user or group needs to be added
// to a rule for that column.
type ColumnLevelPermissionRule struct {

	// An array of column names.
	ColumnNames []string

	// An array of Amazon Resource Names (ARNs) for Amazon QuickSight users or groups.
	Principals []string

	noSmithyDocumentSerde
}

// The column schema.
type ColumnSchema struct {

	// The data type of the column schema.
	DataType *string

	// The geographic role of the column schema.
	GeographicRole *string

	// The name of the column schema.
	Name *string

	noSmithyDocumentSerde
}

// A tag for a column in a TagColumnOperation structure. This is a variant type
// structure. For this structure to be valid, only one of the attributes can be
// non-null.
type ColumnTag struct {

	// A description for a column.
	ColumnDescription *ColumnDescription

	// A geospatial role for a column.
	ColumnGeographicRole GeoSpatialDataRole

	noSmithyDocumentSerde
}

// A transform operation that creates calculated columns. Columns created in one
// such operation form a lexical closure.
type CreateColumnsOperation struct {

	// Calculated columns to create.
	//
	// This member is required.
	Columns []CalculatedColumn

	noSmithyDocumentSerde
}

// The combination of user name and password that are used as credentials.
type CredentialPair struct {

	// Password.
	//
	// This member is required.
	Password *string

	// User name.
	//
	// This member is required.
	Username *string

	// A set of alternate data source parameters that you want to share for these
	// credentials. The credentials are applied in tandem with the data source
	// parameters when you copy a data source by using a create or update request. The
	// API operation compares the DataSourceParameters structure that's in the request
	// with the structures in the AlternateDataSourceParameters allow list. If the
	// structures are an exact match, the request is allowed to use the new data source
	// with the existing credentials. If the AlternateDataSourceParameters list is
	// null, the DataSourceParameters originally used with these Credentials is
	// automatically allowed.
	AlternateDataSourceParameters []DataSourceParameters

	noSmithyDocumentSerde
}

// A physical table type built from the results of the custom SQL query.
type CustomSql struct {

	// The Amazon Resource Name (ARN) of the data source.
	//
	// This member is required.
	DataSourceArn *string

	// A display name for the SQL query result.
	//
	// This member is required.
	Name *string

	// The SQL query.
	//
	// This member is required.
	SqlQuery *string

	// The column schema from the SQL query result set.
	Columns []InputColumn

	noSmithyDocumentSerde
}

// Dashboard.
type Dashboard struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The time that this dataset was created.
	CreatedTime *time.Time

	// Dashboard ID.
	DashboardId *string

	// The last time that this dataset was published.
	LastPublishedTime *time.Time

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time

	// A display name for the dashboard.
	Name *string

	// Version.
	Version *DashboardVersion

	noSmithyDocumentSerde
}

// Dashboard error.
type DashboardError struct {

	// Message.
	Message *string

	// Type.
	Type DashboardErrorType

	noSmithyDocumentSerde
}

// Dashboard publish options.
type DashboardPublishOptions struct {

	// Ad hoc (one-time) filtering option.
	AdHocFilteringOption *AdHocFilteringOption

	// Export to .csv option.
	ExportToCSVOption *ExportToCSVOption

	// Sheet controls option.
	SheetControlsOption *SheetControlsOption

	noSmithyDocumentSerde
}

// A filter that you apply when searching for dashboards.
type DashboardSearchFilter struct {

	// The comparison operator that you want to use as a filter, for example,
	// "Operator": "StringEquals".
	//
	// This member is required.
	Operator FilterOperator

	// The name of the value that you want to use as a filter, for example, "Name":
	// "QUICKSIGHT_USER".
	Name DashboardFilterAttribute

	// The value of the named item, in this case QUICKSIGHT_USER, that you want to use
	// as a filter, for example, "Value":
	// "arn:aws:quicksight:us-east-1:1:user/default/UserName1".
	Value *string

	noSmithyDocumentSerde
}

// Dashboard source entity.
type DashboardSourceEntity struct {

	// Source template.
	SourceTemplate *DashboardSourceTemplate

	noSmithyDocumentSerde
}

// Dashboard source template.
type DashboardSourceTemplate struct {

	// The Amazon Resource Name (ARN) of the resource.
	//
	// This member is required.
	Arn *string

	// Dataset references.
	//
	// This member is required.
	DataSetReferences []DataSetReference

	noSmithyDocumentSerde
}

// Dashboard summary.
type DashboardSummary struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The time that this dashboard was created.
	CreatedTime *time.Time

	// Dashboard ID.
	DashboardId *string

	// The last time that this dashboard was published.
	LastPublishedTime *time.Time

	// The last time that this dashboard was updated.
	LastUpdatedTime *time.Time

	// A display name for the dashboard.
	Name *string

	// Published version number.
	PublishedVersionNumber *int64

	noSmithyDocumentSerde
}

// Dashboard version.
type DashboardVersion struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The time that this dashboard version was created.
	CreatedTime *time.Time

	// The Amazon Resource Numbers (ARNs) for the datasets that are associated with
	// this version of the dashboard.
	DataSetArns []string

	// Description.
	Description *string

	// Errors associated with this dashboard version.
	Errors []DashboardError

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []Sheet

	// Source entity ARN.
	SourceEntityArn *string

	// The HTTP status of the request.
	Status ResourceStatus

	// The ARN of the theme associated with a version of the dashboard.
	ThemeArn *string

	// Version number for this version of the dashboard.
	VersionNumber *int64

	noSmithyDocumentSerde
}

// Dashboard version summary.
type DashboardVersionSummary struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The time that this dashboard version was created.
	CreatedTime *time.Time

	// Description.
	Description *string

	// Source entity ARN.
	SourceEntityArn *string

	// The HTTP status of the request.
	Status ResourceStatus

	// Version number.
	VersionNumber *int64

	noSmithyDocumentSerde
}

// The theme colors that are used for data colors in charts. The colors description
// is a hexadecimal color code that consists of six alphanumerical characters,
// prefixed with #, for example #37BFF5.
type DataColorPalette struct {

	// The hexadecimal codes for the colors.
	Colors []string

	// The hexadecimal code of a color that applies to charts where a lack of data is
	// highlighted.
	EmptyFillColor *string

	// The minimum and maximum hexadecimal codes that describe a color gradient.
	MinMaxGradient []string

	noSmithyDocumentSerde
}

// Dataset.
type DataSet struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// Groupings of columns that work together in certain Amazon QuickSight features.
	// Currently, only geospatial hierarchy is supported.
	ColumnGroups []ColumnGroup

	// A set of one or more definitions of a ColumnLevelPermissionRule.
	ColumnLevelPermissionRules []ColumnLevelPermissionRule

	// The amount of SPICE capacity used by this dataset. This is 0 if the dataset
	// isn't imported into SPICE.
	ConsumedSpiceCapacityInBytes int64

	// The time that this dataset was created.
	CreatedTime *time.Time

	// The ID of the dataset.
	DataSetId *string

	// The usage configuration to apply to child datasets that reference this dataset
	// as a source.
	DataSetUsageConfiguration *DataSetUsageConfiguration

	// The folder that contains fields and nested subfolders for your dataset.
	FieldFolders map[string]FieldFolder

	// A value that indicates whether you want to import the data into SPICE.
	ImportMode DataSetImportMode

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time

	// Configures the combination and transformation of the data from the physical
	// tables.
	LogicalTableMap map[string]LogicalTable

	// A display name for the dataset.
	Name *string

	// The list of columns after all transforms. These columns are available in
	// templates, analyses, and dashboards.
	OutputColumns []OutputColumn

	// Declares the physical tables that are available in the underlying data sources.
	PhysicalTableMap map[string]PhysicalTable

	// The row-level security configuration for the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet

	// The element you can use to define tags for row-level security.
	RowLevelPermissionTagConfiguration *RowLevelPermissionTagConfiguration

	noSmithyDocumentSerde
}

// Dataset configuration.
type DataSetConfiguration struct {

	// A structure containing the list of column group schemas.
	ColumnGroupSchemaList []ColumnGroupSchema

	// Dataset schema.
	DataSetSchema *DataSetSchema

	// Placeholder.
	Placeholder *string

	noSmithyDocumentSerde
}

// Dataset reference.
type DataSetReference struct {

	// Dataset Amazon Resource Name (ARN).
	//
	// This member is required.
	DataSetArn *string

	// Dataset placeholder.
	//
	// This member is required.
	DataSetPlaceholder *string

	noSmithyDocumentSerde
}

// Dataset schema.
type DataSetSchema struct {

	// A structure containing the list of column schemas.
	ColumnSchemaList []ColumnSchema

	noSmithyDocumentSerde
}

// Dataset summary.
type DataSetSummary struct {

	// The Amazon Resource Name (ARN) of the dataset.
	Arn *string

	// A value that indicates if the dataset has column level permission configured.
	ColumnLevelPermissionRulesApplied bool

	// The time that this dataset was created.
	CreatedTime *time.Time

	// The ID of the dataset.
	DataSetId *string

	// A value that indicates whether you want to import the data into SPICE.
	ImportMode DataSetImportMode

	// The last time that this dataset was updated.
	LastUpdatedTime *time.Time

	// A display name for the dataset.
	Name *string

	// The row-level security configuration for the dataset.
	RowLevelPermissionDataSet *RowLevelPermissionDataSet

	// Whether or not the row level permission tags are applied.
	RowLevelPermissionTagConfigurationApplied bool

	noSmithyDocumentSerde
}

// The usage configuration to apply to child datasets that reference this dataset
// as a source.
type DataSetUsageConfiguration struct {

	// An option that controls whether a child dataset of a direct query can use this
	// dataset as a source.
	DisableUseAsDirectQuerySource bool

	// An option that controls whether a child dataset that's stored in QuickSight can
	// use this dataset as a source.
	DisableUseAsImportedSource bool

	noSmithyDocumentSerde
}

// The structure of a data source.
type DataSource struct {

	// A set of alternate data source parameters that you want to share for the
	// credentials stored with this data source. The credentials are applied in tandem
	// with the data source parameters when you copy a data source by using a create or
	// update request. The API operation compares the DataSourceParameters structure
	// that's in the request with the structures in the AlternateDataSourceParameters
	// allow list. If the structures are an exact match, the request is allowed to use
	// the credentials from this existing data source. If the
	// AlternateDataSourceParameters list is null, the Credentials originally used with
	// this DataSourceParameters are automatically allowed.
	AlternateDataSourceParameters []DataSourceParameters

	// The Amazon Resource Name (ARN) of the data source.
	Arn *string

	// The time that this data source was created.
	CreatedTime *time.Time

	// The ID of the data source. This ID is unique per Amazon Web Services Region; for
	// each Amazon Web Services account.
	DataSourceId *string

	// The parameters that Amazon QuickSight uses to connect to your underlying source.
	// This is a variant type structure. For this structure to be valid, only one of
	// the attributes can be non-null.
	DataSourceParameters DataSourceParameters

	// Error information from the last update or the creation of the data source.
	ErrorInfo *DataSourceErrorInfo

	// The last time that this data source was updated.
	LastUpdatedTime *time.Time

	// A display name for the data source.
	Name *string

	// Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects
	// to your underlying source.
	SslProperties *SslProperties

	// The HTTP status of the request.
	Status ResourceStatus

	// The type of the data source. This type indicates which database engine the data
	// source connects to.
	Type DataSourceType

	// The VPC connection information. You need to use this parameter only when you
	// want Amazon QuickSight to use a VPC connection when connecting to your
	// underlying source.
	VpcConnectionProperties *VpcConnectionProperties

	noSmithyDocumentSerde
}

// Data source credentials. This is a variant type structure. For this structure to
// be valid, only one of the attributes can be non-null.
type DataSourceCredentials struct {

	// The Amazon Resource Name (ARN) of a data source that has the credential pair
	// that you want to use. When CopySourceArn is not null, the credential pair from
	// the data source in the ARN is used as the credentials for the
	// DataSourceCredentials structure.
	CopySourceArn *string

	// Credential pair. For more information, see CredentialPair.
	CredentialPair *CredentialPair

	noSmithyDocumentSerde
}

// Error information for the data source creation or update.
type DataSourceErrorInfo struct {

	// Error message.
	Message *string

	// Error type.
	Type DataSourceErrorInfoType

	noSmithyDocumentSerde
}

// The parameters that Amazon QuickSight uses to connect to your underlying data
// source. This is a variant type structure. For this structure to be valid, only
// one of the attributes can be non-null.
//
// The following types satisfy this interface:
//  DataSourceParametersMemberAmazonElasticsearchParameters
//  DataSourceParametersMemberAthenaParameters
//  DataSourceParametersMemberAuroraParameters
//  DataSourceParametersMemberAuroraPostgreSqlParameters
//  DataSourceParametersMemberAwsIotAnalyticsParameters
//  DataSourceParametersMemberJiraParameters
//  DataSourceParametersMemberMariaDbParameters
//  DataSourceParametersMemberMySqlParameters
//  DataSourceParametersMemberOracleParameters
//  DataSourceParametersMemberPostgreSqlParameters
//  DataSourceParametersMemberPrestoParameters
//  DataSourceParametersMemberRdsParameters
//  DataSourceParametersMemberRedshiftParameters
//  DataSourceParametersMemberS3Parameters
//  DataSourceParametersMemberServiceNowParameters
//  DataSourceParametersMemberSnowflakeParameters
//  DataSourceParametersMemberSparkParameters
//  DataSourceParametersMemberSqlServerParameters
//  DataSourceParametersMemberTeradataParameters
//  DataSourceParametersMemberTwitterParameters
//  DataSourceParametersMemberAmazonOpenSearchParameters
type DataSourceParameters interface {
	isDataSourceParameters()
}

// The parameters for Elasticsearch.
type DataSourceParametersMemberAmazonElasticsearchParameters struct {
	Value AmazonElasticsearchParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberAmazonElasticsearchParameters) isDataSourceParameters() {}

// The parameters for Amazon Athena.
type DataSourceParametersMemberAthenaParameters struct {
	Value AthenaParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberAthenaParameters) isDataSourceParameters() {}

// The parameters for Amazon Aurora MySQL.
type DataSourceParametersMemberAuroraParameters struct {
	Value AuroraParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberAuroraParameters) isDataSourceParameters() {}

// The parameters for Amazon Aurora.
type DataSourceParametersMemberAuroraPostgreSqlParameters struct {
	Value AuroraPostgreSqlParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberAuroraPostgreSqlParameters) isDataSourceParameters() {}

// The parameters for IoT Analytics.
type DataSourceParametersMemberAwsIotAnalyticsParameters struct {
	Value AwsIotAnalyticsParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberAwsIotAnalyticsParameters) isDataSourceParameters() {}

// The parameters for Jira.
type DataSourceParametersMemberJiraParameters struct {
	Value JiraParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberJiraParameters) isDataSourceParameters() {}

// The parameters for MariaDB.
type DataSourceParametersMemberMariaDbParameters struct {
	Value MariaDbParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberMariaDbParameters) isDataSourceParameters() {}

// The parameters for MySQL.
type DataSourceParametersMemberMySqlParameters struct {
	Value MySqlParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberMySqlParameters) isDataSourceParameters() {}

// The parameters for Oracle.
type DataSourceParametersMemberOracleParameters struct {
	Value OracleParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberOracleParameters) isDataSourceParameters() {}

// The parameters for PostgreSQL.
type DataSourceParametersMemberPostgreSqlParameters struct {
	Value PostgreSqlParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberPostgreSqlParameters) isDataSourceParameters() {}

// The parameters for Presto.
type DataSourceParametersMemberPrestoParameters struct {
	Value PrestoParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberPrestoParameters) isDataSourceParameters() {}

// The parameters for Amazon RDS.
type DataSourceParametersMemberRdsParameters struct {
	Value RdsParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberRdsParameters) isDataSourceParameters() {}

// The parameters for Amazon Redshift.
type DataSourceParametersMemberRedshiftParameters struct {
	Value RedshiftParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberRedshiftParameters) isDataSourceParameters() {}

// The parameters for S3.
type DataSourceParametersMemberS3Parameters struct {
	Value S3Parameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberS3Parameters) isDataSourceParameters() {}

// The parameters for ServiceNow.
type DataSourceParametersMemberServiceNowParameters struct {
	Value ServiceNowParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberServiceNowParameters) isDataSourceParameters() {}

// The parameters for Snowflake.
type DataSourceParametersMemberSnowflakeParameters struct {
	Value SnowflakeParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberSnowflakeParameters) isDataSourceParameters() {}

// The parameters for Spark.
type DataSourceParametersMemberSparkParameters struct {
	Value SparkParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberSparkParameters) isDataSourceParameters() {}

// The parameters for SQL Server.
type DataSourceParametersMemberSqlServerParameters struct {
	Value SqlServerParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberSqlServerParameters) isDataSourceParameters() {}

// The parameters for Teradata.
type DataSourceParametersMemberTeradataParameters struct {
	Value TeradataParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberTeradataParameters) isDataSourceParameters() {}

// The parameters for Twitter.
type DataSourceParametersMemberTwitterParameters struct {
	Value TwitterParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberTwitterParameters) isDataSourceParameters() {}

type DataSourceParametersMemberAmazonOpenSearchParameters struct {
	Value AmazonOpenSearchParameters

	noSmithyDocumentSerde
}

func (*DataSourceParametersMemberAmazonOpenSearchParameters) isDataSourceParameters() {}

// A date-time parameter.
type DateTimeParameter struct {

	// A display name for the date-time parameter.
	//
	// This member is required.
	Name *string

	// The values for the date-time parameter.
	//
	// This member is required.
	Values []time.Time

	noSmithyDocumentSerde
}

// A decimal parameter.
type DecimalParameter struct {

	// A display name for the decimal parameter.
	//
	// This member is required.
	Name *string

	// The values for the decimal parameter.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// Error information for the SPICE ingestion of a dataset.
type ErrorInfo struct {

	// Error message.
	Message *string

	// Error type.
	Type IngestionErrorType

	noSmithyDocumentSerde
}

// Export to .csv option.
type ExportToCSVOption struct {

	// Availability status.
	AvailabilityStatus DashboardBehavior

	noSmithyDocumentSerde
}

// A FieldFolder element is a folder that contains fields and nested subfolders.
type FieldFolder struct {

	// A folder has a list of columns. A column can only be in one folder.
	Columns []string

	// The description for a field folder.
	Description *string

	noSmithyDocumentSerde
}

// A transform operation that filters rows based on a condition.
type FilterOperation struct {

	// An expression that must evaluate to a Boolean value. Rows for which the
	// expression evaluates to true are kept in the dataset.
	//
	// This member is required.
	ConditionExpression *string

	noSmithyDocumentSerde
}

// A folder.
type Folder struct {

	// The folder Amazon Resource Name (ARN).
	Arn *string

	// The time that the folder was created.
	CreatedTime *time.Time

	// The folder ID.
	FolderId *string

	// An array of ancestor folder ARN strings.
	FolderPath []string

	// The type of the folder.
	FolderType FolderType

	// The time that the folder was last updated.
	LastUpdatedTime *time.Time

	// A display name for the folder.
	Name *string

	noSmithyDocumentSerde
}

// An asset in a folder, such as a dashboard, analysis, or dataset.
type FolderMember struct {

	// The ID of the asset.
	MemberId *string

	// The type of the asset.
	MemberType MemberType

	noSmithyDocumentSerde
}

// Searches a folder by a filter.
type FolderSearchFilter struct {

	// The name of the value that you want to use as a filter. For example, "Name":
	// "PARENT_FOLDER_ARN".
	Name FolderFilterAttribute

	// The comparison operator that you want to use as a filter. For example,
	// "Operator": "StringEquals".
	Operator FilterOperator

	// The value of the named item (in this example, PARENT_FOLDER_ARN), that you want
	// to use as a filter. For example, "Value":
	// "arn:aws:quicksight:us-east-1:1:folder/folderId".
	Value *string

	noSmithyDocumentSerde
}

// A summary of the folder.
type FolderSummary struct {

	// The Amazon Resource Name (ARN).
	Arn *string

	// The time that the folder was created.
	CreatedTime *time.Time

	// The folder ID.
	FolderId *string

	// The type of folder.
	FolderType FolderType

	// The time that the folder was last updated.
	LastUpdatedTime *time.Time

	// The display name of the folder.
	Name *string

	noSmithyDocumentSerde
}

// Geospatial column group that denotes a hierarchy.
type GeoSpatialColumnGroup struct {

	// Columns in this hierarchy.
	//
	// This member is required.
	Columns []string

	// Country code.
	//
	// This member is required.
	CountryCode GeoSpatialCountryCode

	// A display name for the hierarchy.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A group in Amazon QuickSight consists of a set of users. You can use groups to
// make it easier to manage access and security.
type Group struct {

	// The Amazon Resource Name (ARN) for the group.
	Arn *string

	// The group description.
	Description *string

	// The name of the group.
	GroupName *string

	// The principal ID of the group.
	PrincipalId *string

	noSmithyDocumentSerde
}

// A member of an Amazon QuickSight group. Currently, group members must be users.
// Groups can't be members of another group. .
type GroupMember struct {

	// The Amazon Resource Name (ARN) for the group member (user).
	Arn *string

	// The name of the group member (user).
	MemberName *string

	noSmithyDocumentSerde
}

// The display options for gutter spacing between tiles on a sheet.
type GutterStyle struct {

	// This Boolean value controls whether to display a gutter space between sheet
	// tiles.
	Show bool

	noSmithyDocumentSerde
}

// An Identity and Access Management (IAM) policy assignment.
type IAMPolicyAssignment struct {

	// Assignment ID.
	AssignmentId *string

	// Assignment name.
	AssignmentName *string

	// Assignment status.
	AssignmentStatus AssignmentStatus

	// The Amazon Web Services account ID.
	AwsAccountId *string

	// Identities.
	Identities map[string][]string

	// The Amazon Resource Name (ARN) for the IAMpolicy.
	PolicyArn *string

	noSmithyDocumentSerde
}

// IAMpolicy assignment summary.
type IAMPolicyAssignmentSummary struct {

	// Assignment name.
	AssignmentName *string

	// Assignment status.
	AssignmentStatus AssignmentStatus

	noSmithyDocumentSerde
}

// Information about the SPICE ingestion for a dataset.
type Ingestion struct {

	// The Amazon Resource Name (ARN) of the resource.
	//
	// This member is required.
	Arn *string

	// The time that this ingestion started.
	//
	// This member is required.
	CreatedTime *time.Time

	// Ingestion status.
	//
	// This member is required.
	IngestionStatus IngestionStatus

	// Error information for this ingestion.
	ErrorInfo *ErrorInfo

	// Ingestion ID.
	IngestionId *string

	// The size of the data ingested, in bytes.
	IngestionSizeInBytes int64

	// The time that this ingestion took, measured in seconds.
	IngestionTimeInSeconds int64

	// Information about a queued dataset SPICE ingestion.
	QueueInfo *QueueInfo

	// Event source for this ingestion.
	RequestSource IngestionRequestSource

	// Type of this ingestion.
	RequestType IngestionRequestType

	// Information about rows for a data set SPICE ingestion.
	RowInfo *RowInfo

	noSmithyDocumentSerde
}

// Metadata for a column that is used as the input of a transform operation.
type InputColumn struct {

	// The name of this column in the underlying data source.
	//
	// This member is required.
	Name *string

	// The data type of the column.
	//
	// This member is required.
	Type InputColumnDataType

	noSmithyDocumentSerde
}

// An integer parameter.
type IntegerParameter struct {

	// The name of the integer parameter.
	//
	// This member is required.
	Name *string

	// The values for the integer parameter.
	//
	// This member is required.
	Values []int64

	noSmithyDocumentSerde
}

// The parameters for Jira.
type JiraParameters struct {

	// The base URL of the Jira site.
	//
	// This member is required.
	SiteBaseUrl *string

	noSmithyDocumentSerde
}

// The instructions associated with a join.
type JoinInstruction struct {

	// The operand on the left side of a join.
	//
	// This member is required.
	LeftOperand *string

	// The join instructions provided in the ON clause of a join.
	//
	// This member is required.
	OnClause *string

	// The operand on the right side of a join.
	//
	// This member is required.
	RightOperand *string

	// The type of join that it is.
	//
	// This member is required.
	Type JoinType

	// Join key properties of the left operand.
	LeftJoinKeyProperties *JoinKeyProperties

	// Join key properties of the right operand.
	RightJoinKeyProperties *JoinKeyProperties

	noSmithyDocumentSerde
}

// Properties associated with the columns participating in a join.
type JoinKeyProperties struct {

	// A value that indicates that a row in a table is uniquely identified by the
	// columns in a join key. This is used by Amazon QuickSight to optimize query
	// performance.
	UniqueKey bool

	noSmithyDocumentSerde
}

// A logical table is a unit that joins and that data transformations operate on. A
// logical table has a source, which can be either a physical table or result of a
// join. When a logical table points to a physical table, the logical table acts as
// a mutable copy of that physical table through transform operations.
type LogicalTable struct {

	// A display name for the logical table.
	//
	// This member is required.
	Alias *string

	// Source of this logical table.
	//
	// This member is required.
	Source *LogicalTableSource

	// Transform operations that act on this logical table.
	DataTransforms []TransformOperation

	noSmithyDocumentSerde
}

// Information about the source of a logical table. This is a variant type
// structure. For this structure to be valid, only one of the attributes can be
// non-null.
type LogicalTableSource struct {

	// The Amazon Resource Number (ARN) of the parent dataset.
	DataSetArn *string

	// Specifies the result of a join of two logical tables.
	JoinInstruction *JoinInstruction

	// Physical table ID.
	PhysicalTableId *string

	noSmithyDocumentSerde
}

// Amazon S3 manifest file location.
type ManifestFileLocation struct {

	// Amazon S3 bucket.
	//
	// This member is required.
	Bucket *string

	// Amazon S3 key that identifies an object.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// The display options for margins around the outside edge of sheets.
type MarginStyle struct {

	// This Boolean value controls whether to display sheet margins.
	Show bool

	noSmithyDocumentSerde
}

// The parameters for MariaDB.
type MariaDbParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// An object that consists of the member Amazon Resource Name (ARN) and member ID.
type MemberIdArnPair struct {

	// The Amazon Resource Name (ARN) of the member.
	MemberArn *string

	// The ID of the member.
	MemberId *string

	noSmithyDocumentSerde
}

// The parameters for MySQL.
type MySqlParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// Errors that occur during namespace creation.
type NamespaceError struct {

	// The message for the error.
	Message *string

	// The error type.
	Type NamespaceErrorType

	noSmithyDocumentSerde
}

// The error type.
type NamespaceInfoV2 struct {

	// The namespace ARN.
	Arn *string

	// The namespace Amazon Web Services Region;.
	CapacityRegion *string

	// The creation status of a namespace that is not yet completely created.
	CreationStatus NamespaceStatus

	// The identity store used for the namespace.
	IdentityStore IdentityStore

	// The name of the error.
	Name *string

	// An error that occurred when the namespace was created.
	NamespaceError *NamespaceError

	noSmithyDocumentSerde
}

// The parameters for Oracle.
type OracleParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// An Oracle host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// Output column.
type OutputColumn struct {

	// A description for a column.
	Description *string

	// A display name for the dataset.
	Name *string

	// Type.
	Type ColumnDataType

	noSmithyDocumentSerde
}

// A list of Amazon QuickSight parameters and the list's override values.
type Parameters struct {

	// The parameters that have a data type of date-time.
	DateTimeParameters []DateTimeParameter

	// The parameters that have a data type of decimal.
	DecimalParameters []DecimalParameter

	// The parameters that have a data type of integer.
	IntegerParameters []IntegerParameter

	// The parameters that have a data type of string.
	StringParameters []StringParameter

	noSmithyDocumentSerde
}

// A view of a data source that contains information about the shape of the data in
// the underlying source. This is a variant type structure. For this structure to
// be valid, only one of the attributes can be non-null.
//
// The following types satisfy this interface:
//  PhysicalTableMemberRelationalTable
//  PhysicalTableMemberCustomSql
//  PhysicalTableMemberS3Source
type PhysicalTable interface {
	isPhysicalTable()
}

// A physical table type for relational data sources.
type PhysicalTableMemberRelationalTable struct {
	Value RelationalTable

	noSmithyDocumentSerde
}

func (*PhysicalTableMemberRelationalTable) isPhysicalTable() {}

// A physical table type built from the results of the custom SQL query.
type PhysicalTableMemberCustomSql struct {
	Value CustomSql

	noSmithyDocumentSerde
}

func (*PhysicalTableMemberCustomSql) isPhysicalTable() {}

// A physical table type for as S3 data source.
type PhysicalTableMemberS3Source struct {
	Value S3Source

	noSmithyDocumentSerde
}

func (*PhysicalTableMemberS3Source) isPhysicalTable() {}

// The parameters for PostgreSQL.
type PostgreSqlParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// The parameters for Presto.
type PrestoParameters struct {

	// Catalog.
	//
	// This member is required.
	Catalog *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// A transform operation that projects columns. Operations that come after a
// projection can only refer to projected columns.
type ProjectOperation struct {

	// Projected columns.
	//
	// This member is required.
	ProjectedColumns []string

	noSmithyDocumentSerde
}

// Information about a queued dataset SPICE ingestion.
type QueueInfo struct {

	// The ID of the ongoing ingestion. The queued ingestion is waiting for the ongoing
	// ingestion to complete.
	//
	// This member is required.
	QueuedIngestion *string

	// The ID of the queued ingestion.
	//
	// This member is required.
	WaitingOnIngestion *string

	noSmithyDocumentSerde
}

// The parameters for Amazon RDS.
type RdsParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Instance ID.
	//
	// This member is required.
	InstanceId *string

	noSmithyDocumentSerde
}

// The parameters for Amazon Redshift. The ClusterId field can be blank if Host and
// Port are both set. The Host and Port fields can be blank if the ClusterId field
// is set.
type RedshiftParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Cluster ID. This field can be blank if the Host and Port are provided.
	ClusterId *string

	// Host. This field can be blank if ClusterId is provided.
	Host *string

	// Port. This field can be blank if the ClusterId is provided.
	Port int32

	noSmithyDocumentSerde
}

// Information about the dashboard you want to embed.
type RegisteredUserDashboardEmbeddingConfiguration struct {

	// The dashboard ID for the dashboard that you want the user to see first. This ID
	// is included in the output URL. When the URL in response is accessed, Amazon
	// QuickSight renders this dashboard if the user has permissions to view it. If the
	// user does not have permission to view this dashboard, they see a permissions
	// error message.
	//
	// This member is required.
	InitialDashboardId *string

	noSmithyDocumentSerde
}

// The type of experience you want to embed. For registered users, you can embed an
// Amazon QuickSight dashboard or the Amazon QuickSight console. Exactly one of the
// experience configurations is required. You can choose Dashboard or
// QuickSightConsole. You cannot choose more than one experience configuraton.
type RegisteredUserEmbeddingExperienceConfiguration struct {

	// The configuration details for providing a dashboard embedding experience.
	Dashboard *RegisteredUserDashboardEmbeddingConfiguration

	// The configuration details for providing an Amazon QuickSight console embedding
	// experience. This can be used along with custom permissions to restrict access to
	// certain features. For more information, see Customizing Access to the Amazon
	// QuickSight Console
	// (https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
	// in the Amazon QuickSight User Guide. Use GenerateEmbedUrlForRegisteredUser where
	// you want to provide an authoring portal that allows users to create data
	// sources, datasets, analyses, and dashboards. The users who accesses an embedded
	// Amazon QuickSight console needs to belong to the author or admin security
	// cohort. If you want to restrict permissions to some of these features, add a
	// custom permissions profile to the user with the UpdateUser API operation. Use
	// RegisterUser API operation to add a new user with a custom permission profile
	// attached. For more information, see the following sections in the Amazon
	// QuickSight User Guide:
	//
	// * Embedding the Full Functionality of the Amazon
	// QuickSight Console for Authenticated Users
	// (https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html)
	//
	// *
	// Customizing Access to the Amazon QuickSight Console
	// (https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
	//
	// For
	// more information about the high-level steps for embedding and for an interactive
	// demo of the ways you can customize embedding, visit the Amazon QuickSight
	// Developer Portal
	// (https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
	QuickSightConsole *RegisteredUserQuickSightConsoleEmbeddingConfiguration

	noSmithyDocumentSerde
}

// Information about the Amazon QuickSight console that you want to embed.
type RegisteredUserQuickSightConsoleEmbeddingConfiguration struct {

	// The initial URL path for the Amazon QuickSight console. InitialPath is required.
	// The entry point URL is constrained to the following paths:
	//
	// * /start
	//
	// *
	// /start/analyses
	//
	// * /start/dashboards
	//
	// * /start/favorites
	//
	// *
	// /dashboards/DashboardId. DashboardId is the actual ID key from the Amazon
	// QuickSight console URL of the dashboard.
	//
	// * /analyses/AnalysisId. AnalysisId is
	// the actual ID key from the Amazon QuickSight console URL of the analysis.
	InitialPath *string

	noSmithyDocumentSerde
}

// A physical table type for relational data sources.
type RelationalTable struct {

	// The Amazon Resource Name (ARN) for the data source.
	//
	// This member is required.
	DataSourceArn *string

	// The column schema of the table.
	//
	// This member is required.
	InputColumns []InputColumn

	// The name of the relational table.
	//
	// This member is required.
	Name *string

	// The catalog associated with a table.
	Catalog *string

	// The schema name. This name applies to certain relational database engines.
	Schema *string

	noSmithyDocumentSerde
}

// A transform operation that renames a column.
type RenameColumnOperation struct {

	// The name of the column to be renamed.
	//
	// This member is required.
	ColumnName *string

	// The new name for the column.
	//
	// This member is required.
	NewColumnName *string

	noSmithyDocumentSerde
}

// Permission for the resource.
type ResourcePermission struct {

	// The IAMaction to grant or revoke permissions on.
	//
	// This member is required.
	Actions []string

	// The Amazon Resource Name (ARN) of the principal. This can be one of the
	// following:
	//
	// * The ARN of an Amazon QuickSight user or group associated with a
	// data source or dataset. (This is common.)
	//
	// * The ARN of an Amazon QuickSight
	// user, group, or namespace associated with an analysis, dashboard, template, or
	// theme. (This is common.)
	//
	// * The ARN of an Amazon Web Services account root: This
	// is an IAMARN rather than a Amazon QuickSight ARN. Use this option only to share
	// resources (templates) across Amazon Web Services accounts. (This is less
	// common.)
	//
	// This member is required.
	Principal *string

	noSmithyDocumentSerde
}

// Information about rows for a data set SPICE ingestion.
type RowInfo struct {

	// The number of rows that were not ingested.
	RowsDropped int64

	// The number of rows that were ingested.
	RowsIngested int64

	noSmithyDocumentSerde
}

// Information about a dataset that contains permissions for row-level security
// (RLS). The permissions dataset maps fields to users or groups. For more
// information, see Using Row-Level Security (RLS) to Restrict Access to a Dataset
// (https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html)
// in the Amazon QuickSight User Guide. The option to deny permissions by setting
// PermissionPolicy to DENY_ACCESS is not supported for new RLS datasets.
type RowLevelPermissionDataSet struct {

	// The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
	//
	// This member is required.
	Arn *string

	// The type of permissions to use when interpreting the permissions for RLS.
	// DENY_ACCESS is included for backward compatibility only.
	//
	// This member is required.
	PermissionPolicy RowLevelPermissionPolicy

	// The user or group rules associated with the dataset that contains permissions
	// for RLS. By default, FormatVersion is VERSION_1. When FormatVersion is
	// VERSION_1, UserName and GroupName are required. When FormatVersion is VERSION_2,
	// UserARN and GroupARN are required, and Namespace must not exist.
	FormatVersion RowLevelPermissionFormatVersion

	// The namespace associated with the dataset that contains permissions for RLS.
	Namespace *string

	// The status of the row-level security permission dataset. If enabled, the status
	// is ENABLED. If disabled, the status is DISABLED.
	Status Status

	noSmithyDocumentSerde
}

// The configuration of tags on a dataset to set row-level security.
type RowLevelPermissionTagConfiguration struct {

	// A set of rules associated with row-level security, such as the tag names and
	// columns that they are assigned to.
	//
	// This member is required.
	TagRules []RowLevelPermissionTagRule

	// The status of row-level security tags. If enabled, the status is ENABLED. If
	// disabled, the status is DISABLED.
	Status Status

	noSmithyDocumentSerde
}

// A set of rules associated with a tag.
type RowLevelPermissionTagRule struct {

	// The column name that a tag key is assigned to.
	//
	// This member is required.
	ColumnName *string

	// The unique key for a tag.
	//
	// This member is required.
	TagKey *string

	// A string that you want to use to filter by all the values in a column in the
	// dataset and don’t want to list the values one by one. For example, you can use
	// an asterisk as your match all value.
	MatchAllValue *string

	// A string that you want to use to delimit the values when you pass the values at
	// run time. For example, you can delimit the values with a comma.
	TagMultiValueDelimiter *string

	noSmithyDocumentSerde
}

// The parameters for S3.
type S3Parameters struct {

	// Location of the Amazon S3 manifest file. This is NULL if the manifest file was
	// uploaded into Amazon QuickSight.
	//
	// This member is required.
	ManifestFileLocation *ManifestFileLocation

	noSmithyDocumentSerde
}

// A physical table type for an S3 data source.
type S3Source struct {

	// The Amazon Resource Name (ARN) for the data source.
	//
	// This member is required.
	DataSourceArn *string

	// A physical table type for an S3 data source. For files that aren't JSON, only
	// STRING data types are supported in input columns.
	//
	// This member is required.
	InputColumns []InputColumn

	// Information about the format for the S3 source file or files.
	UploadSettings *UploadSettings

	noSmithyDocumentSerde
}

// The parameters for ServiceNow.
type ServiceNowParameters struct {

	// URL of the base site.
	//
	// This member is required.
	SiteBaseUrl *string

	noSmithyDocumentSerde
}

// The key-value pair used for the row-level security tags feature.
type SessionTag struct {

	// The key for the tag.
	//
	// This member is required.
	Key *string

	// The value that you want to assign the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A sheet, which is an object that contains a set of visuals that are viewed
// together on one page in Amazon QuickSight. Every analysis and dashboard contains
// at least one sheet. Each sheet contains at least one visualization widget, for
// example a chart, pivot table, or narrative insight. Sheets can be associated
// with other components, such as controls, filters, and so on.
type Sheet struct {

	// The name of a sheet. This name is displayed on the sheet's tab in the Amazon
	// QuickSight console.
	Name *string

	// The unique identifier associated with a sheet.
	SheetId *string

	noSmithyDocumentSerde
}

// Sheet controls option.
type SheetControlsOption struct {

	// Visibility state.
	VisibilityState DashboardUIState

	noSmithyDocumentSerde
}

// The theme display options for sheets.
type SheetStyle struct {

	// The display options for tiles.
	Tile *TileStyle

	// The layout options for tiles.
	TileLayout *TileLayoutStyle

	noSmithyDocumentSerde
}

// The parameters for Snowflake.
type SnowflakeParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Warehouse.
	//
	// This member is required.
	Warehouse *string

	noSmithyDocumentSerde
}

// The parameters for Spark.
type SparkParameters struct {

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// The parameters for SQL Server.
type SqlServerParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects
// to your underlying data source.
type SslProperties struct {

	// A Boolean option to control whether SSL should be disabled.
	DisableSsl bool

	noSmithyDocumentSerde
}

// A string parameter.
type StringParameter struct {

	// A display name for a string parameter.
	//
	// This member is required.
	Name *string

	// The values of a string parameter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The key or keys of the key-value pairs for the resource tag or tags assigned to
// the resource.
type Tag struct {

	// Tag key.
	//
	// This member is required.
	Key *string

	// Tag value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A transform operation that tags a column with additional information.
type TagColumnOperation struct {

	// The column that this operation acts on.
	//
	// This member is required.
	ColumnName *string

	// The dataset column tag, currently only used for geospatial type tagging. This is
	// not tags for the Amazon Web Services tagging feature.
	//
	// This member is required.
	Tags []ColumnTag

	noSmithyDocumentSerde
}

// A template object. A template is an entity in Amazon QuickSight that
// encapsulates the metadata required to create an analysis and that you can use to
// create a dashboard. A template adds a layer of abstraction by using placeholders
// to replace the dataset associated with an analysis. You can use templates to
// create dashboards by replacing dataset placeholders with datasets that follow
// the same schema that was used to create the source analysis and template. You
// can share templates across Amazon Web Services accounts by allowing users in
// other Amazon Web Services accounts to create a template or a dashboard from an
// existing template.
type Template struct {

	// The Amazon Resource Name (ARN) of the template.
	Arn *string

	// Time when this was created.
	CreatedTime *time.Time

	// Time when this was last updated.
	LastUpdatedTime *time.Time

	// The display name of the template.
	Name *string

	// The ID for the template. This is unique per Amazon Web Services Region; for each
	// Amazon Web Services account.
	TemplateId *string

	// A structure describing the versions of the template.
	Version *TemplateVersion

	noSmithyDocumentSerde
}

// The template alias.
type TemplateAlias struct {

	// The display name of the template alias.
	AliasName *string

	// The Amazon Resource Name (ARN) of the template alias.
	Arn *string

	// The version number of the template alias.
	TemplateVersionNumber *int64

	noSmithyDocumentSerde
}

// List of errors that occurred when the template version creation failed.
type TemplateError struct {

	// Description of the error type.
	Message *string

	// Type of error.
	Type TemplateErrorType

	noSmithyDocumentSerde
}

// The source analysis of the template.
type TemplateSourceAnalysis struct {

	// The Amazon Resource Name (ARN) of the resource.
	//
	// This member is required.
	Arn *string

	// A structure containing information about the dataset references used as
	// placeholders in the template.
	//
	// This member is required.
	DataSetReferences []DataSetReference

	noSmithyDocumentSerde
}

// The source entity of the template.
type TemplateSourceEntity struct {

	// The source analysis, if it is based on an analysis.
	SourceAnalysis *TemplateSourceAnalysis

	// The source template, if it is based on an template.
	SourceTemplate *TemplateSourceTemplate

	noSmithyDocumentSerde
}

// The source template of the template.
type TemplateSourceTemplate struct {

	// The Amazon Resource Name (ARN) of the resource.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

// The template summary.
type TemplateSummary struct {

	// A summary of a template.
	Arn *string

	// The last time that this template was created.
	CreatedTime *time.Time

	// The last time that this template was updated.
	LastUpdatedTime *time.Time

	// A structure containing a list of version numbers for the template summary.
	LatestVersionNumber *int64

	// A display name for the template.
	Name *string

	// The ID of the template. This ID is unique per Amazon Web Services Region; for
	// each Amazon Web Services account.
	TemplateId *string

	noSmithyDocumentSerde
}

// A version of a template.
type TemplateVersion struct {

	// The time that this template version was created.
	CreatedTime *time.Time

	// Schema of the dataset identified by the placeholder. Any dashboard created from
	// this template should be bound to new datasets matching the same schema described
	// through this API operation.
	DataSetConfigurations []DataSetConfiguration

	// The description of the template.
	Description *string

	// Errors associated with this template version.
	Errors []TemplateError

	// A list of the associated sheets with the unique identifier and name of each
	// sheet.
	Sheets []Sheet

	// The Amazon Resource Name (ARN) of an analysis or template that was used to
	// create this template.
	SourceEntityArn *string

	// The HTTP status of the request.
	Status ResourceStatus

	// The ARN of the theme associated with this version of the template.
	ThemeArn *string

	// The version number of the template version.
	VersionNumber *int64

	noSmithyDocumentSerde
}

// The template version.
type TemplateVersionSummary struct {

	// The Amazon Resource Name (ARN) of the template version.
	Arn *string

	// The time that this template version was created.
	CreatedTime *time.Time

	// The description of the template version.
	Description *string

	// The status of the template version.
	Status ResourceStatus

	// The version number of the template version.
	VersionNumber *int64

	noSmithyDocumentSerde
}

// The parameters for Teradata.
type TeradataParameters struct {

	// Database.
	//
	// This member is required.
	Database *string

	// Host.
	//
	// This member is required.
	Host *string

	// Port.
	//
	// This member is required.
	Port int32

	noSmithyDocumentSerde
}

// Summary information about a theme.
type Theme struct {

	// The Amazon Resource Name (ARN) of the theme.
	Arn *string

	// The date and time that the theme was created.
	CreatedTime *time.Time

	// The date and time that the theme was last updated.
	LastUpdatedTime *time.Time

	// The name that the user gives to the theme.
	Name *string

	// The identifier that the user gives to the theme.
	ThemeId *string

	// The type of theme, based on how it was created. Valid values include: QUICKSIGHT
	// and CUSTOM.
	Type ThemeType

	// A version of a theme.
	Version *ThemeVersion

	noSmithyDocumentSerde
}

// An alias for a theme.
type ThemeAlias struct {

	// The display name of the theme alias.
	AliasName *string

	// The Amazon Resource Name (ARN) of the theme alias.
	Arn *string

	// The version number of the theme alias.
	ThemeVersionNumber *int64

	noSmithyDocumentSerde
}

// The theme configuration. This configuration contains all of the display
// properties for a theme.
type ThemeConfiguration struct {

	// Color properties that apply to chart data colors.
	DataColorPalette *DataColorPalette

	// Display options related to sheets.
	Sheet *SheetStyle

	// Color properties that apply to the UI and to charts, excluding the colors that
	// apply to data.
	UIColorPalette *UIColorPalette

	noSmithyDocumentSerde
}

// Theme error.
type ThemeError struct {

	// The error message.
	Message *string

	// The type of error.
	Type ThemeErrorType

	noSmithyDocumentSerde
}

// The theme summary.
type ThemeSummary struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The date and time that this theme was created.
	CreatedTime *time.Time

	// The last date and time that this theme was updated.
	LastUpdatedTime *time.Time

	// The latest version number for the theme.
	LatestVersionNumber *int64

	// the display name for the theme.
	Name *string

	// The ID of the theme. This ID is unique per Amazon Web Services Region; for each
	// Amazon Web Services account.
	ThemeId *string

	noSmithyDocumentSerde
}

// A version of a theme.
type ThemeVersion struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	// The Amazon QuickSight-defined ID of the theme that a custom theme inherits from.
	// All themes initially inherit from a default Amazon QuickSight theme.
	BaseThemeId *string

	// The theme configuration, which contains all the theme display properties.
	Configuration *ThemeConfiguration

	// The date and time that this theme version was created.
	CreatedTime *time.Time

	// The description of the theme.
	Description *string

	// Errors associated with the theme.
	Errors []ThemeError

	// The status of the theme version.
	Status ResourceStatus

	// The version number of the theme.
	VersionNumber *int64

	noSmithyDocumentSerde
}

// The theme version.
type ThemeVersionSummary struct {

	// The Amazon Resource Name (ARN) of the theme version.
	Arn *string

	// The date and time that this theme version was created.
	CreatedTime *time.Time

	// The description of the theme version.
	Description *string

	// The status of the theme version.
	Status ResourceStatus

	// The version number of the theme version.
	VersionNumber *int64

	noSmithyDocumentSerde
}

// The display options for the layout of tiles on a sheet.
type TileLayoutStyle struct {

	// The gutter settings that apply between tiles.
	Gutter *GutterStyle

	// The margin settings that apply around the outside edge of sheets.
	Margin *MarginStyle

	noSmithyDocumentSerde
}

// Display options related to tiles on a sheet.
type TileStyle struct {

	// The border around a tile.
	Border *BorderStyle

	noSmithyDocumentSerde
}

// A data transformation on a logical table. This is a variant type structure. For
// this structure to be valid, only one of the attributes can be non-null.
//
// The following types satisfy this interface:
//  TransformOperationMemberProjectOperation
//  TransformOperationMemberFilterOperation
//  TransformOperationMemberCreateColumnsOperation
//  TransformOperationMemberRenameColumnOperation
//  TransformOperationMemberCastColumnTypeOperation
//  TransformOperationMemberTagColumnOperation
//  TransformOperationMemberUntagColumnOperation
type TransformOperation interface {
	isTransformOperation()
}

// An operation that projects columns. Operations that come after a projection can
// only refer to projected columns.
type TransformOperationMemberProjectOperation struct {
	Value ProjectOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberProjectOperation) isTransformOperation() {}

// An operation that filters rows based on some condition.
type TransformOperationMemberFilterOperation struct {
	Value FilterOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberFilterOperation) isTransformOperation() {}

// An operation that creates calculated columns. Columns created in one such
// operation form a lexical closure.
type TransformOperationMemberCreateColumnsOperation struct {
	Value CreateColumnsOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberCreateColumnsOperation) isTransformOperation() {}

// An operation that renames a column.
type TransformOperationMemberRenameColumnOperation struct {
	Value RenameColumnOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberRenameColumnOperation) isTransformOperation() {}

// A transform operation that casts a column to a different type.
type TransformOperationMemberCastColumnTypeOperation struct {
	Value CastColumnTypeOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberCastColumnTypeOperation) isTransformOperation() {}

// An operation that tags a column with additional information.
type TransformOperationMemberTagColumnOperation struct {
	Value TagColumnOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberTagColumnOperation) isTransformOperation() {}

// A transform operation that removes tags associated with a column.
type TransformOperationMemberUntagColumnOperation struct {
	Value UntagColumnOperation

	noSmithyDocumentSerde
}

func (*TransformOperationMemberUntagColumnOperation) isTransformOperation() {}

// The parameters for Twitter.
type TwitterParameters struct {

	// Maximum number of rows to query Twitter.
	//
	// This member is required.
	MaxRows int32

	// Twitter query string.
	//
	// This member is required.
	Query *string

	noSmithyDocumentSerde
}

// The theme colors that apply to UI and to charts, excluding data colors. The
// colors description is a hexadecimal color code that consists of six
// alphanumerical characters, prefixed with #, for example #37BFF5. For more
// information, see Using Themes in Amazon QuickSight
// (https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
// in the Amazon QuickSight User Guide.
type UIColorPalette struct {

	// This color is that applies to selected states and buttons.
	Accent *string

	// The foreground color that applies to any text or other elements that appear over
	// the accent color.
	AccentForeground *string

	// The color that applies to error messages.
	Danger *string

	// The foreground color that applies to any text or other elements that appear over
	// the error color.
	DangerForeground *string

	// The color that applies to the names of fields that are identified as dimensions.
	Dimension *string

	// The foreground color that applies to any text or other elements that appear over
	// the dimension color.
	DimensionForeground *string

	// The color that applies to the names of fields that are identified as measures.
	Measure *string

	// The foreground color that applies to any text or other elements that appear over
	// the measure color.
	MeasureForeground *string

	// The background color that applies to visuals and other high emphasis UI.
	PrimaryBackground *string

	// The color of text and other foreground elements that appear over the primary
	// background regions, such as grid lines, borders, table banding, icons, and so
	// on.
	PrimaryForeground *string

	// The background color that applies to the sheet background and sheet controls.
	SecondaryBackground *string

	// The foreground color that applies to any sheet title, sheet control text, or UI
	// that appears over the secondary background.
	SecondaryForeground *string

	// The color that applies to success messages, for example the check mark for a
	// successful download.
	Success *string

	// The foreground color that applies to any text or other elements that appear over
	// the success color.
	SuccessForeground *string

	// This color that applies to warning and informational messages.
	Warning *string

	// The foreground color that applies to any text or other elements that appear over
	// the warning color.
	WarningForeground *string

	noSmithyDocumentSerde
}

// A transform operation that removes tags associated with a column.
type UntagColumnOperation struct {

	// The column that this operation acts on.
	//
	// This member is required.
	ColumnName *string

	// The column tags to remove from this column.
	//
	// This member is required.
	TagNames []ColumnTagName

	noSmithyDocumentSerde
}

// Information about the format for a source file or files.
type UploadSettings struct {

	// Whether the file has a header row, or the files each have a header row.
	ContainsHeader bool

	// The delimiter between values in the file.
	Delimiter *string

	// File format.
	Format FileFormat

	// A row number to start reading data from.
	StartFromRow int32

	// Text qualifier.
	TextQualifier TextQualifier

	noSmithyDocumentSerde
}

// A registered user of Amazon QuickSight.
type User struct {

	// The active status of user. When you create an Amazon QuickSight user that’s not
	// an IAM user or an Active Directory user, that user is inactive until they sign
	// in and provide a password.
	Active bool

	// The Amazon Resource Name (ARN) for the user.
	Arn *string

	// The custom permissions profile associated with this user.
	CustomPermissionsName *string

	// The user's email address.
	Email *string

	// The type of supported external login provider that provides identity to let the
	// user federate into Amazon QuickSight with an associated IAMrole. The type can be
	// one of the following.
	//
	// * COGNITO: Amazon Cognito. The provider URL is
	// cognito-identity.amazonaws.com.
	//
	// * CUSTOM_OIDC: Custom OpenID Connect (OIDC)
	// provider.
	ExternalLoginFederationProviderType *string

	// The URL of the external login provider.
	ExternalLoginFederationProviderUrl *string

	// The identity ID for the user in the external login provider.
	ExternalLoginId *string

	// The type of identity authentication used by the user.
	IdentityType IdentityType

	// The principal ID of the user.
	PrincipalId *string

	// The Amazon QuickSight role for the user. The user role can be one of the
	// following:.
	//
	// * READER: A user who has read-only access to dashboards.
	//
	// * AUTHOR:
	// A user who can create data sources, datasets, analyses, and dashboards.
	//
	// *
	// ADMIN: A user who is an author, who can also manage Amazon Amazon QuickSight
	// settings.
	//
	// * RESTRICTED_READER: This role isn't currently available for use.
	//
	// *
	// RESTRICTED_AUTHOR: This role isn't currently available for use.
	Role UserRole

	// The user's user name.
	UserName *string

	noSmithyDocumentSerde
}

// VPC connection properties.
type VpcConnectionProperties struct {

	// The Amazon Resource Name (ARN) for the VPC connection.
	//
	// This member is required.
	VpcConnectionArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDataSourceParameters() {}
func (*UnknownUnionMember) isPhysicalTable()        {}
func (*UnknownUnionMember) isTransformOperation()   {}
