// Code generated by smithy-go-codegen DO NOT EDIT.

package pi

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/pi/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDescribeDimensionKeys struct {
}

func (*validateOpDescribeDimensionKeys) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeDimensionKeys) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeDimensionKeysInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeDimensionKeysInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDimensionKeyDetails struct {
}

func (*validateOpGetDimensionKeyDetails) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDimensionKeyDetails) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDimensionKeyDetailsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDimensionKeyDetailsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResourceMetrics struct {
}

func (*validateOpGetResourceMetrics) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResourceMetrics) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResourceMetricsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResourceMetricsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDescribeDimensionKeysValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeDimensionKeys{}, middleware.After)
}

func addOpGetDimensionKeyDetailsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDimensionKeyDetails{}, middleware.After)
}

func addOpGetResourceMetricsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResourceMetrics{}, middleware.After)
}

func validateDimensionGroup(v *types.DimensionGroup) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DimensionGroup"}
	if v.Group == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Group"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricQuery(v *types.MetricQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricQuery"}
	if v.Metric == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metric"))
	}
	if v.GroupBy != nil {
		if err := validateDimensionGroup(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricQueryList(v []types.MetricQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricQueryList"}
	for i := range v {
		if err := validateMetricQuery(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeDimensionKeysInput(v *DescribeDimensionKeysInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeDimensionKeysInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if v.Metric == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Metric"))
	}
	if v.GroupBy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GroupBy"))
	} else if v.GroupBy != nil {
		if err := validateDimensionGroup(v.GroupBy); err != nil {
			invalidParams.AddNested("GroupBy", err.(smithy.InvalidParamsError))
		}
	}
	if v.PartitionBy != nil {
		if err := validateDimensionGroup(v.PartitionBy); err != nil {
			invalidParams.AddNested("PartitionBy", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDimensionKeyDetailsInput(v *GetDimensionKeyDetailsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDimensionKeyDetailsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.Group == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Group"))
	}
	if v.GroupIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GroupIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResourceMetricsInput(v *GetResourceMetricsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResourceMetricsInput"}
	if len(v.ServiceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceType"))
	}
	if v.Identifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Identifier"))
	}
	if v.MetricQueries == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetricQueries"))
	} else if v.MetricQueries != nil {
		if err := validateMetricQueryList(v.MetricQueries); err != nil {
			invalidParams.AddNested("MetricQueries", err.(smithy.InvalidParamsError))
		}
	}
	if v.StartTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartTime"))
	}
	if v.EndTime == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndTime"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
