// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A timestamp, and a single numerical value, which together represent a
// measurement at a particular point in time.
type DataPoint struct {

	// The time, in epoch format, associated with a particular Value.
	//
	// This member is required.
	Timestamp *time.Time

	// The actual value associated with a particular Timestamp.
	//
	// This member is required.
	Value *float64

	noSmithyDocumentSerde
}

// A logical grouping of Performance Insights metrics for a related subject area.
// For example, the db.sql dimension group consists of the following dimensions:
// db.sql.id, db.sql.db_id, db.sql.statement, and db.sql.tokenized_id. Each
// response element returns a maximum of 500 bytes. For larger elements, such as
// SQL statements, only the first 500 bytes are returned.
type DimensionGroup struct {

	// The name of the dimension group. Valid values are:
	//
	// * db - The name of the
	// database to which the client is connected (only Aurora PostgreSQL, RDS
	// PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)
	//
	// * db.application - The name
	// of the application that is connected to the database (only Aurora PostgreSQL and
	// RDS PostgreSQL)
	//
	// * db.host - The host name of the connected client (all
	// engines)
	//
	// * db.session_type - The type of the current session (only Aurora
	// PostgreSQL and RDS PostgreSQL)
	//
	// * db.sql - The SQL that is currently executing
	// (all engines)
	//
	// * db.sql_tokenized - The SQL digest (all engines)
	//
	// *
	// db.wait_event - The event for which the database backend is waiting (all
	// engines)
	//
	// * db.wait_event_type - The type of event for which the database
	// backend is waiting (all engines)
	//
	// * db.user - The user logged in to the database
	// (all engines)
	//
	// This member is required.
	Group *string

	// A list of specific dimensions from a dimension group. If this parameter is not
	// present, then it signifies that all of the dimensions in the group were
	// requested, or are present in the response. Valid values for elements in the
	// Dimensions array are:
	//
	// * db.application.name - The name of the application that
	// is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	// *
	// db.host.id - The host ID of the connected client (all engines)
	//
	// * db.host.name -
	// The host name of the connected client (all engines)
	//
	// * db.name - The name of the
	// database to which the client is connected (only Aurora PostgreSQL, RDS
	// PostgreSQL, Aurora MySQL, RDS MySQL, and MariaDB)
	//
	// * db.session_type.name - The
	// type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
	//
	// *
	// db.sql.id - The SQL ID generated by Performance Insights (all engines)
	//
	// *
	// db.sql.db_id - The SQL ID generated by the database (all engines)
	//
	// *
	// db.sql.statement - The SQL text that is being executed (all engines)
	//
	// *
	// db.sql.tokenized_id
	//
	// * db.sql_tokenized.id - The SQL digest ID generated by
	// Performance Insights (all engines)
	//
	// * db.sql_tokenized.db_id - SQL digest ID
	// generated by the database (all engines)
	//
	// * db.sql_tokenized.statement - The SQL
	// digest text (all engines)
	//
	// * db.user.id - The ID of the user logged in to the
	// database (all engines)
	//
	// * db.user.name - The name of the user logged in to the
	// database (all engines)
	//
	// * db.wait_event.name - The event for which the backend
	// is waiting (all engines)
	//
	// * db.wait_event.type - The type of event for which the
	// backend is waiting (all engines)
	//
	// * db.wait_event_type.name - The name of the
	// event type for which the backend is waiting (all engines)
	Dimensions []string

	// The maximum number of items to fetch for this dimension group.
	Limit *int32

	noSmithyDocumentSerde
}

// An array of descriptions and aggregated values for each dimension within a
// dimension group.
type DimensionKeyDescription struct {

	// A map of name-value pairs for the dimensions in the group.
	Dimensions map[string]string

	// If PartitionBy was specified, PartitionKeys contains the dimensions that were.
	Partitions []float64

	// The aggregated metric value for the dimension(s), over the requested time range.
	Total *float64

	noSmithyDocumentSerde
}

// An object that describes the details for a specified dimension.
type DimensionKeyDetail struct {

	// The full name of the dimension. The full name includes the group name and key
	// name. The only valid value is db.sql.statement.
	Dimension *string

	// The status of the dimension detail data. Possible values include the
	// following:
	//
	// * AVAILABLE - The dimension detail data is ready to be retrieved.
	//
	// *
	// PROCESSING - The dimension detail data isn't ready to be retrieved because more
	// processing time is required. If the requested detail data for db.sql.statement
	// has the status PROCESSING, Performance Insights returns the truncated query.
	//
	// *
	// UNAVAILABLE - The dimension detail data could not be collected successfully.
	Status DetailStatus

	// The value of the dimension detail data. For the db.sql.statement dimension, this
	// value is either the full or truncated SQL query, depending on the return status.
	Value *string

	noSmithyDocumentSerde
}

// A time-ordered series of data points, corresponding to a dimension of a
// Performance Insights metric.
type MetricKeyDataPoints struct {

	// An array of timestamp-value pairs, representing measurements over a period of
	// time.
	DataPoints []DataPoint

	// The dimension(s) to which the data points apply.
	Key *ResponseResourceMetricKey

	noSmithyDocumentSerde
}

// A single query to be processed. You must provide the metric to query. If no
// other parameters are specified, Performance Insights returns all of the data
// points for that metric. You can optionally request that the data points be
// aggregated by dimension group ( GroupBy), and return only those data points that
// match your criteria (Filter).
type MetricQuery struct {

	// The name of a Performance Insights metric to be measured. Valid values for
	// Metric are:
	//
	// * db.load.avg - a scaled representation of the number of active
	// sessions for the database engine.
	//
	// * db.sampledload.avg - the raw number of
	// active sessions for the database engine.
	//
	// If the number of active sessions is
	// less than an internal Performance Insights threshold, db.load.avg and
	// db.sampledload.avg are the same value. If the number of active sessions is
	// greater than the internal threshold, Performance Insights samples the active
	// sessions, with db.load.avg showing the scaled values, db.sampledload.avg showing
	// the raw values, and db.sampledload.avg less than db.load.avg. For most use
	// cases, you can query db.load.avg only.
	//
	// This member is required.
	Metric *string

	// One or more filters to apply in the request. Restrictions:
	//
	// * Any number of
	// filters by the same dimension, as specified in the GroupBy parameter.
	//
	// * A
	// single filter for any other dimension in this dimension group.
	Filter map[string]string

	// A specification for how to aggregate the data points from a query result. You
	// must specify a valid dimension group. Performance Insights will return all of
	// the dimensions within that group, unless you provide the names of specific
	// dimensions within that group. You can also request that Performance Insights
	// return a limited number of values for a dimension.
	GroupBy *DimensionGroup

	noSmithyDocumentSerde
}

// If PartitionBy was specified in a DescribeDimensionKeys request, the dimensions
// are returned in an array. Each element in the array specifies one dimension.
type ResponsePartitionKey struct {

	// A dimension map that contains the dimension(s) for this partition.
	//
	// This member is required.
	Dimensions map[string]string

	noSmithyDocumentSerde
}

// An object describing a Performance Insights metric and one or more dimensions
// for that metric.
type ResponseResourceMetricKey struct {

	// The name of a Performance Insights metric to be measured. Valid values for
	// Metric are:
	//
	// * db.load.avg - a scaled representation of the number of active
	// sessions for the database engine.
	//
	// * db.sampledload.avg - the raw number of
	// active sessions for the database engine.
	//
	// If the number of active sessions is
	// less than an internal Performance Insights threshold, db.load.avg and
	// db.sampledload.avg are the same value. If the number of active sessions is
	// greater than the internal threshold, Performance Insights samples the active
	// sessions, with db.load.avg showing the scaled values, db.sampledload.avg showing
	// the raw values, and db.sampledload.avg less than db.load.avg. For most use
	// cases, you can query db.load.avg only.
	//
	// This member is required.
	Metric *string

	// The valid dimensions for the metric.
	Dimensions map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
