// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Allows you to either upgrade your domain or perform an upgrade eligibility check
// to a compatible version of OpenSearch or Elasticsearch.
func (c *Client) UpgradeDomain(ctx context.Context, params *UpgradeDomainInput, optFns ...func(*Options)) (*UpgradeDomainOutput, error) {
	if params == nil {
		params = &UpgradeDomainInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpgradeDomain", params, optFns, c.addOperationUpgradeDomainMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpgradeDomainOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for the request parameters to UpgradeDomain operation.
type UpgradeDomainInput struct {

	// The name of an domain. Domain names are unique across the domains owned by an
	// account within an AWS region. Domain names start with a letter or number and can
	// contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// This member is required.
	DomainName *string

	// The version of OpenSearch you intend to upgrade the domain to.
	//
	// This member is required.
	TargetVersion *string

	// Exposes select native OpenSearch configuration values from opensearch.yml.
	// Currently, the following advanced options are available:
	//
	// * Option to allow
	// references to indices in an HTTP request body. Must be false when configuring
	// access to individual sub-resources. By default, the value is true. See Advanced
	// cluster parameters
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	//
	// * Option to specify the percentage of heap space
	// allocated to field data. By default, this setting is unbounded.
	//
	// For more
	// information, see  Advanced cluster parameters
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions map[string]string

	// When true, indicates that an upgrade eligibility check needs to be performed.
	// Does not actually perform the upgrade.
	PerformCheckOnly *bool

	noSmithyDocumentSerde
}

// Container for response returned by UpgradeDomain operation.
type UpgradeDomainOutput struct {

	// Exposes select native OpenSearch configuration values from opensearch.yml.
	// Currently, the following advanced options are available:
	//
	// * Option to allow
	// references to indices in an HTTP request body. Must be false when configuring
	// access to individual sub-resources. By default, the value is true. See Advanced
	// cluster parameters
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	//
	// * Option to specify the percentage of heap space
	// allocated to field data. By default, this setting is unbounded.
	//
	// For more
	// information, see  Advanced cluster parameters
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
	AdvancedOptions map[string]string

	// The name of an domain. Domain names are unique across the domains owned by an
	// account within an AWS region. Domain names start with a letter or number and can
	// contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	DomainName *string

	// When true, indicates that an upgrade eligibility check needs to be performed.
	// Does not actually perform the upgrade.
	PerformCheckOnly *bool

	// The version of OpenSearch that you intend to upgrade the domain to.
	TargetVersion *string

	UpgradeId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpgradeDomainMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpgradeDomain{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpgradeDomain{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpgradeDomainValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpgradeDomain(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpgradeDomain(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "es",
		OperationName: "UpgradeDomain",
	}
}
