// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opensearch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about reserved OpenSearch instances for this account.
func (c *Client) DescribeReservedInstances(ctx context.Context, params *DescribeReservedInstancesInput, optFns ...func(*Options)) (*DescribeReservedInstancesOutput, error) {
	if params == nil {
		params = &DescribeReservedInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeReservedInstances", params, optFns, c.addOperationDescribeReservedInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeReservedInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Container for parameters to DescribeReservedInstances
type DescribeReservedInstancesInput struct {

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults int32

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string

	// The reserved instance identifier filter value. Use this parameter to show only
	// the reservation that matches the specified reserved OpenSearch instance ID.
	ReservedInstanceId *string

	noSmithyDocumentSerde
}

// Container for results from DescribeReservedInstances
type DescribeReservedInstancesOutput struct {

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string

	// List of reserved OpenSearch instances.
	ReservedInstances []types.ReservedInstance

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeReservedInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeReservedInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeReservedInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeReservedInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeReservedInstancesAPIClient is a client that implements the
// DescribeReservedInstances operation.
type DescribeReservedInstancesAPIClient interface {
	DescribeReservedInstances(context.Context, *DescribeReservedInstancesInput, ...func(*Options)) (*DescribeReservedInstancesOutput, error)
}

var _ DescribeReservedInstancesAPIClient = (*Client)(nil)

// DescribeReservedInstancesPaginatorOptions is the paginator options for
// DescribeReservedInstances
type DescribeReservedInstancesPaginatorOptions struct {
	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeReservedInstancesPaginator is a paginator for DescribeReservedInstances
type DescribeReservedInstancesPaginator struct {
	options   DescribeReservedInstancesPaginatorOptions
	client    DescribeReservedInstancesAPIClient
	params    *DescribeReservedInstancesInput
	nextToken *string
	firstPage bool
}

// NewDescribeReservedInstancesPaginator returns a new
// DescribeReservedInstancesPaginator
func NewDescribeReservedInstancesPaginator(client DescribeReservedInstancesAPIClient, params *DescribeReservedInstancesInput, optFns ...func(*DescribeReservedInstancesPaginatorOptions)) *DescribeReservedInstancesPaginator {
	if params == nil {
		params = &DescribeReservedInstancesInput{}
	}

	options := DescribeReservedInstancesPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeReservedInstancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeReservedInstancesPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribeReservedInstances page.
func (p *DescribeReservedInstancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeReservedInstancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.DescribeReservedInstances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeReservedInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "es",
		OperationName: "DescribeReservedInstances",
	}
}
