// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the EBS volume upgrade information. The broker identifier must be set
// to the keyword ALL. This means the changes apply to all the brokers in the
// cluster.
type BrokerEBSVolumeInfo struct {

	// The ID of the broker to update.
	//
	// This member is required.
	KafkaBrokerNodeId *string

	// Size of the EBS volume to update.
	//
	// This member is required.
	VolumeSizeGB int32

	noSmithyDocumentSerde
}

type BrokerLogs struct {
	CloudWatchLogs *CloudWatchLogs

	Firehose *Firehose

	S3 *S3

	noSmithyDocumentSerde
}

// Describes the setup to be used for Kafka broker nodes in the cluster.
type BrokerNodeGroupInfo struct {

	// The list of subnets to connect to in the client virtual private cloud (VPC). AWS
	// creates elastic network interfaces inside these subnets. Client applications use
	// elastic network interfaces to produce and consume data. Client subnets can't be
	// in Availability Zone us-east-1e.
	//
	// This member is required.
	ClientSubnets []string

	// The type of Amazon EC2 instances to use for Kafka brokers. The following
	// instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge,
	// kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
	//
	// This member is required.
	InstanceType *string

	// The distribution of broker nodes across Availability Zones. This is an optional
	// parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You
	// can also explicitly set this parameter to the value DEFAULT. No other values are
	// currently allowed. Amazon MSK distributes the broker nodes evenly across the
	// Availability Zones that correspond to the subnets you provide when you create
	// the cluster.
	BrokerAZDistribution BrokerAZDistribution

	// The AWS security groups to associate with the elastic network interfaces in
	// order to specify who can connect to and communicate with the Amazon MSK cluster.
	// If you don't specify a security group, Amazon MSK uses the default security
	// group associated with the VPC.
	SecurityGroups []string

	// Contains information about storage volumes attached to MSK broker nodes.
	StorageInfo *StorageInfo

	noSmithyDocumentSerde
}

// BrokerNodeInfo
type BrokerNodeInfo struct {

	// The attached elastic network interface of the broker.
	AttachedENIId *string

	// The ID of the broker.
	BrokerId float64

	// The client subnet to which this broker node belongs.
	ClientSubnet *string

	// The virtual private cloud (VPC) of the client.
	ClientVpcIpAddress *string

	// Information about the version of software currently deployed on the Kafka
	// brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo

	// Endpoints for accessing the broker.
	Endpoints []string

	noSmithyDocumentSerde
}

// Information about the current software installed on the cluster.
type BrokerSoftwareInfo struct {

	// The Amazon Resource Name (ARN) of the configuration used for the cluster. This
	// field isn't visible in this preview release.
	ConfigurationArn *string

	// The revision of the configuration to use. This field isn't visible in this
	// preview release.
	ConfigurationRevision int64

	// The version of Apache Kafka.
	KafkaVersion *string

	noSmithyDocumentSerde
}

// Includes all client authentication information.
type ClientAuthentication struct {

	// Details for ClientAuthentication using SASL.
	Sasl *Sasl

	// Details for ClientAuthentication using TLS.
	Tls *Tls

	// Contains information about unauthenticated traffic to the cluster.
	Unauthenticated *Unauthenticated

	noSmithyDocumentSerde
}

type CloudWatchLogs struct {

	// This member is required.
	Enabled bool

	LogGroup *string

	noSmithyDocumentSerde
}

// Returns information about a cluster.
type ClusterInfo struct {

	// Arn of active cluster operation.
	ActiveOperationArn *string

	// Information about the broker nodes.
	BrokerNodeGroupInfo *BrokerNodeGroupInfo

	// Includes all client authentication information.
	ClientAuthentication *ClientAuthentication

	// The Amazon Resource Name (ARN) that uniquely identifies the cluster.
	ClusterArn *string

	// The name of the cluster.
	ClusterName *string

	// The time when the cluster was created.
	CreationTime *time.Time

	// Information about the version of software currently deployed on the Kafka
	// brokers in the cluster.
	CurrentBrokerSoftwareInfo *BrokerSoftwareInfo

	// The current version of the MSK cluster.
	CurrentVersion *string

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo

	// Specifies which metrics are gathered for the MSK cluster. This property has the
	// following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and
	// PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these
	// levels of monitoring, see Monitoring
	// (https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html).
	EnhancedMonitoring EnhancedMonitoring

	LoggingInfo *LoggingInfo

	// The number of broker nodes in the cluster.
	NumberOfBrokerNodes int32

	// Settings for open monitoring using Prometheus.
	OpenMonitoring *OpenMonitoring

	// The state of the cluster. The possible states are ACTIVE, CREATING, DELETING,
	// FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
	State ClusterState

	StateInfo *StateInfo

	// Tags attached to the cluster.
	Tags map[string]string

	// The connection string to use to connect to the Apache ZooKeeper cluster.
	ZookeeperConnectString *string

	// The connection string to use to connect to zookeeper cluster on Tls port.
	ZookeeperConnectStringTls *string

	noSmithyDocumentSerde
}

// Returns information about a cluster operation.
type ClusterOperationInfo struct {

	// The ID of the API request that triggered this operation.
	ClientRequestId *string

	// ARN of the cluster.
	ClusterArn *string

	// The time that the operation was created.
	CreationTime *time.Time

	// The time at which the operation finished.
	EndTime *time.Time

	// Describes the error if the operation fails.
	ErrorInfo *ErrorInfo

	// ARN of the cluster operation.
	OperationArn *string

	// State of the cluster operation.
	OperationState *string

	// Steps completed during the operation.
	OperationSteps []ClusterOperationStep

	// Type of the cluster operation.
	OperationType *string

	// Information about cluster attributes before a cluster is updated.
	SourceClusterInfo *MutableClusterInfo

	// Information about cluster attributes after a cluster is updated.
	TargetClusterInfo *MutableClusterInfo

	noSmithyDocumentSerde
}

// Step taken during a cluster operation.
type ClusterOperationStep struct {

	// Information about the step and its status.
	StepInfo *ClusterOperationStepInfo

	// The name of the step.
	StepName *string

	noSmithyDocumentSerde
}

// State information about the operation step.
type ClusterOperationStepInfo struct {

	// The steps current status.
	StepStatus *string

	noSmithyDocumentSerde
}

// Contains source Kafka versions and compatible target Kafka versions.
type CompatibleKafkaVersion struct {

	// A Kafka version.
	SourceVersion *string

	// A list of Kafka versions.
	TargetVersions []string

	noSmithyDocumentSerde
}

// Represents an MSK Configuration.
type Configuration struct {

	// The Amazon Resource Name (ARN) of the configuration.
	//
	// This member is required.
	Arn *string

	// The time when the configuration was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The description of the configuration.
	//
	// This member is required.
	Description *string

	// An array of the versions of Apache Kafka with which you can use this MSK
	// configuration. You can use this configuration for an MSK cluster only if the
	// Apache Kafka version specified for the cluster appears in this array.
	//
	// This member is required.
	KafkaVersions []string

	// Latest revision of the configuration.
	//
	// This member is required.
	LatestRevision *ConfigurationRevision

	// The name of the configuration.
	//
	// This member is required.
	Name *string

	// The state of the configuration. The possible states are ACTIVE, DELETING, and
	// DELETE_FAILED.
	//
	// This member is required.
	State ConfigurationState

	noSmithyDocumentSerde
}

// Specifies the configuration to use for the brokers.
type ConfigurationInfo struct {

	// ARN of the configuration to use.
	//
	// This member is required.
	Arn *string

	// The revision of the configuration to use.
	//
	// This member is required.
	Revision int64

	noSmithyDocumentSerde
}

// Describes a configuration revision.
type ConfigurationRevision struct {

	// The time when the configuration revision was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The revision number.
	//
	// This member is required.
	Revision int64

	// The description of the configuration revision.
	Description *string

	noSmithyDocumentSerde
}

// Contains information about the EBS storage volumes attached to Kafka broker
// nodes.
type EBSStorageInfo struct {

	// The size in GiB of the EBS volume for the data drive on each broker node.
	VolumeSize int32

	noSmithyDocumentSerde
}

// The data-volume encryption details.
type EncryptionAtRest struct {

	// The ARN of the AWS KMS key for encrypting data at rest. If you don't specify a
	// KMS key, MSK creates one for you and uses it.
	//
	// This member is required.
	DataVolumeKMSKeyId *string

	noSmithyDocumentSerde
}

// Includes encryption-related information, such as the AWS KMS key used for
// encrypting data at rest and whether you want MSK to encrypt your data in
// transit.
type EncryptionInfo struct {

	// The data-volume encryption details.
	EncryptionAtRest *EncryptionAtRest

	// The details for encryption in transit.
	EncryptionInTransit *EncryptionInTransit

	noSmithyDocumentSerde
}

// The settings for encrypting data in transit.
type EncryptionInTransit struct {

	// Indicates the encryption setting for data in transit between clients and
	// brokers. The following are the possible values. TLS means that client-broker
	// communication is enabled with TLS only. TLS_PLAINTEXT means that client-broker
	// communication is enabled for both TLS-encrypted, as well as plaintext data.
	// PLAINTEXT means that client-broker communication is enabled in plaintext only.
	// The default value is TLS_PLAINTEXT.
	ClientBroker ClientBroker

	// When set to true, it indicates that data communication among the broker nodes of
	// the cluster is encrypted. When set to false, the communication happens in
	// plaintext. The default value is true.
	InCluster bool

	noSmithyDocumentSerde
}

// Returns information about an error state of the cluster.
type ErrorInfo struct {

	// A number describing the error programmatically.
	ErrorCode *string

	// An optional field to provide more details about the error.
	ErrorString *string

	noSmithyDocumentSerde
}

type Firehose struct {

	// This member is required.
	Enabled bool

	DeliveryStream *string

	noSmithyDocumentSerde
}

// Details for IAM access control.
type Iam struct {

	// Indicates whether IAM access control is enabled.
	Enabled bool

	noSmithyDocumentSerde
}

// Indicates whether you want to enable or disable the JMX Exporter.
type JmxExporter struct {

	// Indicates whether you want to enable or disable the JMX Exporter.
	//
	// This member is required.
	EnabledInBroker bool

	noSmithyDocumentSerde
}

// Indicates whether you want to enable or disable the JMX Exporter.
type JmxExporterInfo struct {

	// Indicates whether you want to enable or disable the JMX Exporter.
	//
	// This member is required.
	EnabledInBroker bool

	noSmithyDocumentSerde
}

type KafkaVersion struct {
	Status KafkaVersionStatus

	Version *string

	noSmithyDocumentSerde
}

type LoggingInfo struct {

	// This member is required.
	BrokerLogs *BrokerLogs

	noSmithyDocumentSerde
}

// Information about cluster attributes that can be updated via update APIs.
type MutableClusterInfo struct {

	// Specifies the size of the EBS volume and the ID of the associated broker.
	BrokerEBSVolumeInfo []BrokerEBSVolumeInfo

	// Includes all client authentication information.
	ClientAuthentication *ClientAuthentication

	// Information about the changes in the configuration of the brokers.
	ConfigurationInfo *ConfigurationInfo

	// Includes all encryption-related information.
	EncryptionInfo *EncryptionInfo

	// Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon
	// CloudWatch for this cluster.
	EnhancedMonitoring EnhancedMonitoring

	// Information about the Amazon MSK broker type.
	InstanceType *string

	// The Kafka version.
	KafkaVersion *string

	// You can configure your MSK cluster to send broker logs to different destination
	// types. This is a container for the configuration details related to broker logs.
	LoggingInfo *LoggingInfo

	// The number of broker nodes in the cluster.
	NumberOfBrokerNodes int32

	// The settings for open monitoring.
	OpenMonitoring *OpenMonitoring

	noSmithyDocumentSerde
}

// Indicates whether you want to enable or disable the Node Exporter.
type NodeExporter struct {

	// Indicates whether you want to enable or disable the Node Exporter.
	//
	// This member is required.
	EnabledInBroker bool

	noSmithyDocumentSerde
}

// Indicates whether you want to enable or disable the Node Exporter.
type NodeExporterInfo struct {

	// Indicates whether you want to enable or disable the Node Exporter.
	//
	// This member is required.
	EnabledInBroker bool

	noSmithyDocumentSerde
}

// The node information object.
type NodeInfo struct {

	// The start time.
	AddedToClusterTime *string

	// The broker node info.
	BrokerNodeInfo *BrokerNodeInfo

	// The instance type.
	InstanceType *string

	// The Amazon Resource Name (ARN) of the node.
	NodeARN *string

	// The node type.
	NodeType NodeType

	// The ZookeeperNodeInfo.
	ZookeeperNodeInfo *ZookeeperNodeInfo

	noSmithyDocumentSerde
}

// JMX and Node monitoring for the MSK cluster.
type OpenMonitoring struct {

	// Prometheus settings.
	//
	// This member is required.
	Prometheus *Prometheus

	noSmithyDocumentSerde
}

// JMX and Node monitoring for the MSK cluster.
type OpenMonitoringInfo struct {

	// Prometheus settings.
	//
	// This member is required.
	Prometheus *PrometheusInfo

	noSmithyDocumentSerde
}

// Prometheus settings.
type Prometheus struct {

	// Indicates whether you want to enable or disable the JMX Exporter.
	JmxExporter *JmxExporter

	// Indicates whether you want to enable or disable the Node Exporter.
	NodeExporter *NodeExporter

	noSmithyDocumentSerde
}

// Prometheus settings.
type PrometheusInfo struct {

	// Indicates whether you want to enable or disable the JMX Exporter.
	JmxExporter *JmxExporterInfo

	// Indicates whether you want to enable or disable the Node Exporter.
	NodeExporter *NodeExporterInfo

	noSmithyDocumentSerde
}

type S3 struct {

	// This member is required.
	Enabled bool

	Bucket *string

	Prefix *string

	noSmithyDocumentSerde
}

// Details for client authentication using SASL.
type Sasl struct {

	// Indicates whether IAM access control is enabled.
	Iam *Iam

	// Details for SASL/SCRAM client authentication.
	Scram *Scram

	noSmithyDocumentSerde
}

// Details for SASL/SCRAM client authentication.
type Scram struct {

	// SASL/SCRAM authentication is enabled or not.
	Enabled bool

	noSmithyDocumentSerde
}

type StateInfo struct {
	Code *string

	Message *string

	noSmithyDocumentSerde
}

// Contains information about storage volumes attached to MSK broker nodes.
type StorageInfo struct {

	// EBS volume information.
	EbsStorageInfo *EBSStorageInfo

	noSmithyDocumentSerde
}

// Details for client authentication using TLS.
type Tls struct {

	// List of ACM Certificate Authority ARNs.
	CertificateAuthorityArnList []string

	// Specifies whether you want to enable or disable TLS authentication.
	Enabled bool

	noSmithyDocumentSerde
}

type Unauthenticated struct {

	// Specifies whether you want to enable or disable unauthenticated traffic to your
	// cluster.
	Enabled bool

	noSmithyDocumentSerde
}

// Error info for scram secret associate/disassociate failure.
type UnprocessedScramSecret struct {

	// Error code for associate/disassociate failure.
	ErrorCode *string

	// Error message for associate/disassociate failure.
	ErrorMessage *string

	// AWS Secrets Manager secret ARN.
	SecretArn *string

	noSmithyDocumentSerde
}

// Zookeeper node information.
type ZookeeperNodeInfo struct {

	// The attached elastic network interface of the broker.
	AttachedENIId *string

	// The virtual private cloud (VPC) IP address of the client.
	ClientVpcIpAddress *string

	// Endpoints for accessing the ZooKeeper.
	Endpoints []string

	// The role-specific ID for Zookeeper.
	ZookeeperId float64

	// The version of Zookeeper.
	ZookeeperVersion *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
