// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information on the current access control policies for the bucket.
type AccessControlList struct {

	// A value that indicates whether public read access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicReadAccess bool

	// A value that indicates whether public write access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicWriteAccess bool

	noSmithyDocumentSerde
}

// Contains information about the access keys.
type AccessKeyDetails struct {

	// The access key ID of the user.
	AccessKeyId *string

	// The principal ID of the user.
	PrincipalId *string

	// The name of the user.
	UserName *string

	// The type of the user.
	UserType *string

	noSmithyDocumentSerde
}

// Contains information about the account.
type AccountDetail struct {

	// The member account ID.
	//
	// This member is required.
	AccountId *string

	// The email address of the member account.
	//
	// This member is required.
	Email *string

	noSmithyDocumentSerde
}

// Contains information about the account level permissions on the S3 bucket.
type AccountLevelPermissions struct {

	// Describes the S3 Block Public Access settings of the bucket's parent account.
	BlockPublicAccess *BlockPublicAccess

	noSmithyDocumentSerde
}

// Contains information about actions.
type Action struct {

	// The GuardDuty finding activity type.
	ActionType *string

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction

	noSmithyDocumentSerde
}

// The account within the organization specified as the GuardDuty delegated
// administrator.
type AdminAccount struct {

	// The AWS account ID for the account.
	AdminAccountId *string

	// Indicates whether the account is enabled as the delegated administrator.
	AdminStatus AdminStatus

	noSmithyDocumentSerde
}

// Contains information about the API action.
type AwsApiCallAction struct {

	// The AWS API name.
	Api *string

	// The AWS API caller type.
	CallerType *string

	// The domain information for the AWS API call.
	DomainDetails *DomainDetails

	// The error code of the failed AWS API action.
	ErrorCode *string

	// The remote IP information of the connection that initiated the AWS API call.
	RemoteIpDetails *RemoteIpDetails

	// The AWS service name whose API was invoked.
	ServiceName *string

	noSmithyDocumentSerde
}

// Contains information on how the bucker owner's S3 Block Public Access settings
// are being applied to the S3 bucket. See S3 Block Public Access
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
// for more information.
type BlockPublicAccess struct {

	// Indicates if S3 Block Public Access is set to BlockPublicAcls.
	BlockPublicAcls bool

	// Indicates if S3 Block Public Access is set to BlockPublicPolicy.
	BlockPublicPolicy bool

	// Indicates if S3 Block Public Access is set to IgnorePublicAcls.
	IgnorePublicAcls bool

	// Indicates if S3 Block Public Access is set to RestrictPublicBuckets.
	RestrictPublicBuckets bool

	noSmithyDocumentSerde
}

// Contains information about the bucket level permissions for the S3 bucket.
type BucketLevelPermissions struct {

	// Contains information on how Access Control Policies are applied to the bucket.
	AccessControlList *AccessControlList

	// Contains information on which account level S3 Block Public Access settings are
	// applied to the S3 bucket.
	BlockPublicAccess *BlockPublicAccess

	// Contains information on the bucket policies for the S3 bucket.
	BucketPolicy *BucketPolicy

	noSmithyDocumentSerde
}

// Contains information on the current bucket policies for the S3 bucket.
type BucketPolicy struct {

	// A value that indicates whether public read access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicReadAccess bool

	// A value that indicates whether public write access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicWriteAccess bool

	noSmithyDocumentSerde
}

// Contains information about the city associated with the IP address.
type City struct {

	// The city name of the remote IP address.
	CityName *string

	noSmithyDocumentSerde
}

// Contains information on the status of CloudTrail as a data source for the
// detector.
type CloudTrailConfigurationResult struct {

	// Describes whether CloudTrail is enabled as a data source for the detector.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the condition.
type Condition struct {

	// Represents the equal condition to be applied to a single field when querying for
	// findings.
	//
	// Deprecated: This member has been deprecated.
	Eq []string

	// Represents an equal condition to be applied to a single field when querying for
	// findings.
	Equals []string

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	GreaterThan int64

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	GreaterThanOrEqual int64

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Gt int32

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Gte int32

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	LessThan int64

	// Represents a less than or equal condition to be applied to a single field when
	// querying for findings.
	LessThanOrEqual int64

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: This member has been deprecated.
	Lt int32

	// Represents a less than or equal condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Lte int32

	// Represents the not equal condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: This member has been deprecated.
	Neq []string

	// Represents a not equal condition to be applied to a single field when querying
	// for findings.
	NotEquals []string

	noSmithyDocumentSerde
}

// Contains information about the country where the remote IP address is located.
type Country struct {

	// The country code of the remote IP address.
	CountryCode *string

	// The country name of the remote IP address.
	CountryName *string

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled.
type DataSourceConfigurations struct {

	// Describes whether S3 data event logs are enabled as a data source.
	S3Logs *S3LogsConfiguration

	noSmithyDocumentSerde
}

// Contains information on the status of data sources for the detector.
type DataSourceConfigurationsResult struct {

	// An object that contains information on the status of CloudTrail as a data
	// source.
	//
	// This member is required.
	CloudTrail *CloudTrailConfigurationResult

	// An object that contains information on the status of DNS logs as a data source.
	//
	// This member is required.
	DNSLogs *DNSLogsConfigurationResult

	// An object that contains information on the status of VPC flow logs as a data
	// source.
	//
	// This member is required.
	FlowLogs *FlowLogsConfigurationResult

	// An object that contains information on the status of S3 Data event logs as a
	// data source.
	//
	// This member is required.
	S3Logs *S3LogsConfigurationResult

	noSmithyDocumentSerde
}

// Contains information on the server side encryption method used in the S3 bucket.
// See S3 Server-Side Encryption
// (https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html) for
// more information.
type DefaultServerSideEncryption struct {

	// The type of encryption used for objects within the S3 bucket.
	EncryptionType *string

	// The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the
	// bucket EncryptionType is aws:kms.
	KmsMasterKeyArn *string

	noSmithyDocumentSerde
}

// Contains information about the publishing destination, including the ID, type,
// and status.
type Destination struct {

	// The unique ID of the publishing destination.
	//
	// This member is required.
	DestinationId *string

	// The type of resource used for the publishing destination. Currently, only Amazon
	// S3 buckets are supported.
	//
	// This member is required.
	DestinationType DestinationType

	// The status of the publishing destination.
	//
	// This member is required.
	Status PublishingStatus

	noSmithyDocumentSerde
}

// Contains the Amazon Resource Name (ARN) of the resource to publish to, such as
// an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
type DestinationProperties struct {

	// The ARN of the resource to publish to.
	DestinationArn *string

	// The ARN of the KMS key to use for encryption.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains information on the status of DNS logs as a data source.
type DNSLogsConfigurationResult struct {

	// Denotes whether DNS logs is enabled as a data source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the DNS_REQUEST action described in this finding.
type DnsRequestAction struct {

	// The domain information for the API request.
	Domain *string

	noSmithyDocumentSerde
}

// Contains information about the domain.
type DomainDetails struct {

	// The domain information for the AWS API call.
	Domain *string

	noSmithyDocumentSerde
}

// Contains information about the reason that the finding was generated.
type Evidence struct {

	// A list of threat intelligence details related to the evidence.
	ThreatIntelligenceDetails []ThreatIntelligenceDetail

	noSmithyDocumentSerde
}

// Contains information about the finding, which is generated when abnormal or
// suspicious activity is detected.
type Finding struct {

	// The ID of the account in which the finding was generated.
	//
	// This member is required.
	AccountId *string

	// The ARN of the finding.
	//
	// This member is required.
	Arn *string

	// The time and date when the finding was created.
	//
	// This member is required.
	CreatedAt *string

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Region where the finding was generated.
	//
	// This member is required.
	Region *string

	// Contains information about the AWS resource associated with the activity that
	// prompted GuardDuty to generate a finding.
	//
	// This member is required.
	Resource *Resource

	// The version of the schema used for the finding.
	//
	// This member is required.
	SchemaVersion *string

	// The severity of the finding.
	//
	// This member is required.
	Severity float64

	// The type of finding.
	//
	// This member is required.
	Type *string

	// The time and date when the finding was last updated.
	//
	// This member is required.
	UpdatedAt *string

	// The confidence score for the finding.
	Confidence float64

	// The description of the finding.
	Description *string

	// The partition associated with the finding.
	Partition *string

	// Contains additional information about the generated finding.
	Service *Service

	// The title of the finding.
	Title *string

	noSmithyDocumentSerde
}

// Contains information about the criteria used for querying findings.
type FindingCriteria struct {

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]Condition

	noSmithyDocumentSerde
}

// Contains information about finding statistics.
type FindingStatistics struct {

	// Represents a map of severity to count statistics for a set of findings.
	CountBySeverity map[string]int32

	noSmithyDocumentSerde
}

// Contains information on the status of VPC flow logs as a data source.
type FlowLogsConfigurationResult struct {

	// Denotes whether VPC flow logs is enabled as a data source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the location of the remote IP address.
type GeoLocation struct {

	// The latitude information of the remote IP address.
	Lat float64

	// The longitude information of the remote IP address.
	Lon float64

	noSmithyDocumentSerde
}

// Contains information about the EC2 instance profile.
type IamInstanceProfile struct {

	// The profile ARN of the EC2 instance.
	Arn *string

	// The profile ID of the EC2 instance.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about the details of an instance.
type InstanceDetails struct {

	// The Availability Zone of the EC2 instance.
	AvailabilityZone *string

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile

	// The image description of the EC2 instance.
	ImageDescription *string

	// The image ID of the EC2 instance.
	ImageId *string

	// The ID of the EC2 instance.
	InstanceId *string

	// The state of the EC2 instance.
	InstanceState *string

	// The type of the EC2 instance.
	InstanceType *string

	// The launch time of the EC2 instance.
	LaunchTime *string

	// The elastic network interface information of the EC2 instance.
	NetworkInterfaces []NetworkInterface

	// The Amazon Resource Name (ARN) of the AWS Outpost. Only applicable to AWS
	// Outposts instances.
	OutpostArn *string

	// The platform of the EC2 instance.
	Platform *string

	// The product code of the EC2 instance.
	ProductCodes []ProductCode

	// The tags of the EC2 instance.
	Tags []Tag

	noSmithyDocumentSerde
}

// Contains information about the invitation to become a member account.
type Invitation struct {

	// The ID of the account that the invitation was sent from.
	AccountId *string

	// The ID of the invitation. This value is used to validate the inviter account to
	// the member account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Contains information about the local IP address of the connection.
type LocalIpDetails struct {

	// The IPv4 local address of the connection.
	IpAddressV4 *string

	noSmithyDocumentSerde
}

// Contains information about the port for the local connection.
type LocalPortDetails struct {

	// The port number of the local connection.
	Port int32

	// The port name of the local connection.
	PortName *string

	noSmithyDocumentSerde
}

// Contains information about the administrator account and invitation.
type Master struct {

	// The ID of the account used as the administrator account.
	AccountId *string

	// The value used to validate the administrator account to the member account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the administrator and member accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Contains information about the member account.
type Member struct {

	// The ID of the member account.
	//
	// This member is required.
	AccountId *string

	// The email address of the member account.
	//
	// This member is required.
	Email *string

	// The administrator account ID.
	//
	// This member is required.
	MasterId *string

	// The status of the relationship between the member and the administrator.
	//
	// This member is required.
	RelationshipStatus *string

	// The last-updated timestamp of the member.
	//
	// This member is required.
	UpdatedAt *string

	// The detector ID of the member account.
	DetectorId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	noSmithyDocumentSerde
}

// Contains information on which data sources are enabled for a member account.
type MemberDataSourceConfiguration struct {

	// The account ID for the member account.
	//
	// This member is required.
	AccountId *string

	// Contains information on the status of data sources for the account.
	//
	// This member is required.
	DataSources *DataSourceConfigurationsResult

	noSmithyDocumentSerde
}

// Contains information about the NETWORK_CONNECTION action described in the
// finding.
type NetworkConnectionAction struct {

	// Indicates whether EC2 blocked the network connection to your instance.
	Blocked bool

	// The network connection direction.
	ConnectionDirection *string

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails

	// The network connection protocol.
	Protocol *string

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails

	// The remote port information of the connection.
	RemotePortDetails *RemotePortDetails

	noSmithyDocumentSerde
}

// Contains information about the elastic network interface of the EC2 instance.
type NetworkInterface struct {

	// A list of IPv6 addresses for the EC2 instance.
	Ipv6Addresses []string

	// The ID of the network interface.
	NetworkInterfaceId *string

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []PrivateIpAddressDetails

	// The public DNS name of the EC2 instance.
	PublicDnsName *string

	// The public IP address of the EC2 instance.
	PublicIp *string

	// The security groups associated with the EC2 instance.
	SecurityGroups []SecurityGroup

	// The subnet ID of the EC2 instance.
	SubnetId *string

	// The VPC ID of the EC2 instance.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the ISP organization of the remote IP address.
type Organization struct {

	// The Autonomous System Number (ASN) of the internet provider of the remote IP
	// address.
	Asn *string

	// The organization that registered this ASN.
	AsnOrg *string

	// The ISP information for the internet provider.
	Isp *string

	// The name of the internet provider.
	Org *string

	noSmithyDocumentSerde
}

// An object that contains information on which data sources will be configured to
// be automatically enabled for new members within the organization.
type OrganizationDataSourceConfigurations struct {

	// Describes whether S3 data event logs are enabled for new members of the
	// organization.
	S3Logs *OrganizationS3LogsConfiguration

	noSmithyDocumentSerde
}

// An object that contains information on which data sources are automatically
// enabled for new members within the organization.
type OrganizationDataSourceConfigurationsResult struct {

	// Describes whether S3 data event logs are enabled as a data source.
	//
	// This member is required.
	S3Logs *OrganizationS3LogsConfigurationResult

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be automatically enabled for new
// members of the organization.
type OrganizationS3LogsConfiguration struct {

	// A value that contains information on whether S3 data event logs will be enabled
	// automatically as a data source for the organization.
	//
	// This member is required.
	AutoEnable bool

	noSmithyDocumentSerde
}

// The current configuration of S3 data event logs as a data source for the
// organization.
type OrganizationS3LogsConfigurationResult struct {

	// A value that describes whether S3 data event logs are automatically enabled for
	// new members of the organization.
	//
	// This member is required.
	AutoEnable bool

	noSmithyDocumentSerde
}

// Contains information on the owner of the bucket.
type Owner struct {

	// The canonical user ID of the bucket owner. For information about locating your
	// canonical user ID see Finding Your Account Canonical User ID.
	// (https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId)
	Id *string

	noSmithyDocumentSerde
}

// Contains information about how permissions are configured for the S3 bucket.
type PermissionConfiguration struct {

	// Contains information about the account level permissions on the S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions

	// Contains information about the bucket level permissions for the S3 bucket.
	BucketLevelPermissions *BucketLevelPermissions

	noSmithyDocumentSerde
}

// Contains information about the PORT_PROBE action described in the finding.
type PortProbeAction struct {

	// Indicates whether EC2 blocked the port probe to the instance, such as with an
	// ACL.
	Blocked bool

	// A list of objects related to port probe details.
	PortProbeDetails []PortProbeDetail

	noSmithyDocumentSerde
}

// Contains information about the port probe details.
type PortProbeDetail struct {

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails

	noSmithyDocumentSerde
}

// Contains other private IP address information of the EC2 instance.
type PrivateIpAddressDetails struct {

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// Contains information about the product code for the EC2 instance.
type ProductCode struct {

	// The product code information.
	Code *string

	// The product code type.
	ProductType *string

	noSmithyDocumentSerde
}

// Describes the public access policies that apply to the S3 bucket.
type PublicAccess struct {

	// Describes the effective permission on this bucket after factoring all attached
	// policies.
	EffectivePermission *string

	// Contains information about how permissions are configured for the S3 bucket.
	PermissionConfiguration *PermissionConfiguration

	noSmithyDocumentSerde
}

// Contains information about the remote IP address of the connection.
type RemoteIpDetails struct {

	// The city information of the remote IP address.
	City *City

	// The country code of the remote IP address.
	Country *Country

	// The location information of the remote IP address.
	GeoLocation *GeoLocation

	// The IPv4 remote address of the connection.
	IpAddressV4 *string

	// The ISP organization information of the remote IP address.
	Organization *Organization

	noSmithyDocumentSerde
}

// Contains information about the remote port.
type RemotePortDetails struct {

	// The port number of the remote connection.
	Port int32

	// The port name of the remote connection.
	PortName *string

	noSmithyDocumentSerde
}

// Contains information about the AWS resource associated with the activity that
// prompted GuardDuty to generate a finding.
type Resource struct {

	// The IAM access key details (IAM user information) of a user that engaged in the
	// activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails

	// The type of AWS resource.
	ResourceType *string

	// Contains information on the S3 bucket.
	S3BucketDetails []S3BucketDetail

	noSmithyDocumentSerde
}

// Contains information on the S3 bucket.
type S3BucketDetail struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	Arn *string

	// The date and time the bucket was created at.
	CreatedAt *time.Time

	// Describes the server side encryption method used in the S3 bucket.
	DefaultServerSideEncryption *DefaultServerSideEncryption

	// The name of the S3 bucket.
	Name *string

	// The owner of the S3 bucket.
	Owner *Owner

	// Describes the public access policies that apply to the S3 bucket.
	PublicAccess *PublicAccess

	// All tags attached to the S3 bucket
	Tags []Tag

	// Describes whether the bucket is a source or destination bucket.
	Type *string

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfiguration struct {

	// The status of S3 data event logs as a data source.
	//
	// This member is required.
	Enable bool

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfigurationResult struct {

	// A value that describes whether S3 data event logs are automatically enabled for
	// new members of the organization.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the security groups associated with the EC2 instance.
type SecurityGroup struct {

	// The security group ID of the EC2 instance.
	GroupId *string

	// The security group name of the EC2 instance.
	GroupName *string

	noSmithyDocumentSerde
}

// Contains additional information about the generated finding.
type Service struct {

	// Information about the activity that is described in a finding.
	Action *Action

	// Indicates whether this finding is archived.
	Archived bool

	// The total count of the occurrences of this finding type.
	Count int32

	// The detector ID for the GuardDuty service.
	DetectorId *string

	// The first-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string

	// The last-seen timestamp of the activity that prompted GuardDuty to generate this
	// finding.
	EventLastSeen *string

	// An evidence object associated with the service.
	Evidence *Evidence

	// The resource role information for this finding.
	ResourceRole *string

	// The name of the AWS service (GuardDuty) that generated a finding.
	ServiceName *string

	// Feedback that was submitted about the finding.
	UserFeedback *string

	noSmithyDocumentSerde
}

// Contains information about the criteria used for sorting findings.
type SortCriteria struct {

	// Represents the finding attribute (for example, accountId) to sort findings by.
	AttributeName *string

	// The order by which the sorted findings are to be displayed.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Contains information about a tag associated with the EC2 instance.
type Tag struct {

	// The EC2 instance tag key.
	Key *string

	// The EC2 instance tag value.
	Value *string

	noSmithyDocumentSerde
}

// An instance of a threat intelligence detail that constitutes evidence for the
// finding.
type ThreatIntelligenceDetail struct {

	// The name of the threat intelligence list that triggered the finding.
	ThreatListName *string

	// A list of names of the threats in the threat intelligence list that triggered
	// the finding.
	ThreatNames []string

	noSmithyDocumentSerde
}

// Contains the total usage with the corresponding currency unit for that value.
type Total struct {

	// The total usage.
	Amount *string

	// The currency unit that the amount is given in.
	Unit *string

	noSmithyDocumentSerde
}

// Contains information about the accounts that weren't processed.
type UnprocessedAccount struct {

	// The AWS account ID.
	//
	// This member is required.
	AccountId *string

	// A reason why the account hasn't been processed.
	//
	// This member is required.
	Result *string

	noSmithyDocumentSerde
}

// Contains information on the total of usage based on account IDs.
type UsageAccountResult struct {

	// The Account ID that generated usage.
	AccountId *string

	// Represents the total of usage for the Account ID.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information about the criteria used to query usage statistics.
type UsageCriteria struct {

	// The data sources to aggregate usage statistics from.
	//
	// This member is required.
	DataSources []DataSource

	// The account IDs to aggregate usage statistics from.
	AccountIds []string

	// The resources to aggregate usage statistics from. Only accepts exact resource
	// names.
	Resources []string

	noSmithyDocumentSerde
}

// Contains information on the result of usage based on data source type.
type UsageDataSourceResult struct {

	// The data source type that generated usage.
	DataSource DataSource

	// Represents the total of usage for the specified data source.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information on the sum of usage based on an AWS resource.
type UsageResourceResult struct {

	// The AWS resource that generated usage.
	Resource *string

	// Represents the sum total of usage for the specified resource type.
	Total *Total

	noSmithyDocumentSerde
}

// Contains the result of GuardDuty usage. If a UsageStatisticType is provided the
// result for other types will be null.
type UsageStatistics struct {

	// The usage statistic sum organized by account ID.
	SumByAccount []UsageAccountResult

	// The usage statistic sum organized by on data source.
	SumByDataSource []UsageDataSourceResult

	// The usage statistic sum organized by resource.
	SumByResource []UsageResourceResult

	// Lists the top 50 resources that have generated the most GuardDuty usage, in
	// order from most to least expensive.
	TopResources []UsageResourceResult

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
