// Code generated by smithy-go-codegen DO NOT EDIT.

package groundstation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/groundstation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of Config objects.
func (c *Client) ListConfigs(ctx context.Context, params *ListConfigsInput, optFns ...func(*Options)) (*ListConfigsOutput, error) {
	if params == nil {
		params = &ListConfigsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfigs", params, optFns, c.addOperationListConfigsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfigsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

//
type ListConfigsInput struct {

	// Maximum number of Configs returned.
	MaxResults *int32

	// Next token returned in the request of a previous ListConfigs call. Used to get
	// the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

//
type ListConfigsOutput struct {

	// List of Config items.
	ConfigList []types.ConfigListItem

	// Next token returned in the response of a previous ListConfigs call. Used to get
	// the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfigsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfigs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConfigsAPIClient is a client that implements the ListConfigs operation.
type ListConfigsAPIClient interface {
	ListConfigs(context.Context, *ListConfigsInput, ...func(*Options)) (*ListConfigsOutput, error)
}

var _ ListConfigsAPIClient = (*Client)(nil)

// ListConfigsPaginatorOptions is the paginator options for ListConfigs
type ListConfigsPaginatorOptions struct {
	// Maximum number of Configs returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfigsPaginator is a paginator for ListConfigs
type ListConfigsPaginator struct {
	options   ListConfigsPaginatorOptions
	client    ListConfigsAPIClient
	params    *ListConfigsInput
	nextToken *string
	firstPage bool
}

// NewListConfigsPaginator returns a new ListConfigsPaginator
func NewListConfigsPaginator(client ListConfigsAPIClient, params *ListConfigsInput, optFns ...func(*ListConfigsPaginatorOptions)) *ListConfigsPaginator {
	if params == nil {
		params = &ListConfigsInput{}
	}

	options := ListConfigsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfigsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfigsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListConfigs page.
func (p *ListConfigsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfigsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListConfigs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListConfigs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "groundstation",
		OperationName: "ListConfigs",
	}
}
