// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Properties that describe an alias resource. Related actions CreateAlias |
// ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All
// APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type Alias struct {

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift alias resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::alias/alias-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a
	// GameLift alias ARN, the resource ID matches the alias ID value.
	AliasArn *string

	// A unique identifier for the alias. Alias IDs are unique within a Region.
	AliasId *string

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// A human-readable description of an alias.
	Description *string

	// The time that this data object was last modified. Format is a number expressed
	// in Unix time as milliseconds (for example "1469498468.057").
	LastUpdatedTime *time.Time

	// A descriptive label that is associated with an alias. Alias names do not need to
	// be unique.
	Name *string

	// The routing configuration, including routing type and fleet target, for the
	// alias.
	RoutingStrategy *RoutingStrategy

	noSmithyDocumentSerde
}

// Values for use in Player attribute key-value pairs. This object lets you specify
// an attribute value using any of the valid data types: string, number, string
// array, or data map. Each AttributeValue object can use only one of the available
// properties.
type AttributeValue struct {

	// For number values, expressed as double.
	N *float64

	// For single string values. Maximum string length is 100 characters.
	S *string

	// For a map of up to 10 data type:value pairs. Maximum length for each string
	// value is 100 characters.
	SDM map[string]float64

	// For a list of up to 10 strings. Maximum length for each string is 100
	// characters. Duplicate values are not recognized; all occurrences of the repeated
	// value after the first of a repeated value are ignored.
	SL []string

	noSmithyDocumentSerde
}

// Temporary access credentials used for uploading game build files to Amazon
// GameLift. They are valid for a limited time. If they expire before you upload
// your game build, get a new set by calling RequestUploadCredentials.
type AwsCredentials struct {

	// Temporary key allowing access to the Amazon GameLift S3 account.
	AccessKeyId *string

	// Temporary secret key allowing access to the Amazon GameLift S3 account.
	SecretAccessKey *string

	// Token used to associate a specific build ID with the files uploaded using these
	// credentials.
	SessionToken *string

	noSmithyDocumentSerde
}

// Properties describing a custom game build. Related actions CreateBuild |
// ListBuilds | DescribeBuild | UpdateBuild | DeleteBuild | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type Build struct {

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift build resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::build/build-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a
	// GameLift build ARN, the resource ID matches the BuildId value.
	BuildArn *string

	// A unique identifier for the build.
	BuildId *string

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// A descriptive label that is associated with a build. Build names do not need to
	// be unique. It can be set using CreateBuild or UpdateBuild.
	Name *string

	// Operating system that the game server binaries are built to run on. This value
	// determines the type of fleet resources that you can use for this build.
	OperatingSystem OperatingSystem

	// File size of the uploaded game build, expressed in bytes. When the build status
	// is INITIALIZED, this value is 0.
	SizeOnDisk *int64

	// Current status of the build. Possible build statuses include the following:
	//
	// *
	// INITIALIZED -- A new build has been defined, but no files have been uploaded.
	// You cannot create fleets for builds that are in this status. When a build is
	// successfully created, the build status is set to this value.
	//
	// * READY -- The
	// game build has been successfully uploaded. You can now create new fleets for
	// this build.
	//
	// * FAILED -- The game build upload failed. You cannot create new
	// fleets for this build.
	Status BuildStatus

	// Version information that is associated with a build or script. Version strings
	// do not need to be unique. This value can be set using CreateBuild or
	// UpdateBuild.
	Version *string

	noSmithyDocumentSerde
}

// Determines whether a TLS/SSL certificate is generated for a fleet. This feature
// must be enabled when creating the fleet. All instances in a fleet share the same
// certificate. The certificate can be retrieved by calling the GameLift Server SDK
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html)
// operation GetInstanceCertificate. A fleet's certificate configuration is part of
// FleetAttributes.
type CertificateConfiguration struct {

	// Indicates whether a TLS/SSL certificate is generated for a fleet. Valid values
	// include:
	//
	// * GENERATED - Generate a TLS/SSL certificate for this fleet.
	//
	// *
	// DISABLED - (default) Do not generate a TLS/SSL certificate for this fleet.
	//
	// This member is required.
	CertificateType CertificateType

	noSmithyDocumentSerde
}

// Player information for use when creating player sessions using a game session
// placement request with StartGameSessionPlacement.
type DesiredPlayerSession struct {

	// Developer-defined information related to a player. GameLift does not use this
	// data, so it can be formatted as needed for use in the game.
	PlayerData *string

	// A unique identifier for a player to associate with the player session.
	PlayerId *string

	noSmithyDocumentSerde
}

// Resource capacity settings. Fleet capacity is measured in EC2 instances. Pending
// and terminating counts are non-zero when the fleet capacity is adjusting to a
// scaling event or if access to resources is temporarily affected. EC2 instance
// counts are part of FleetCapacity.
type EC2InstanceCounts struct {

	// Actual number of instances that are ready to host game sessions.
	ACTIVE *int32

	// Ideal number of active instances. GameLift will always try to maintain the
	// desired number of instances. Capacity is scaled up or down by changing the
	// desired instances.
	DESIRED *int32

	// Number of active instances that are not currently hosting a game session.
	IDLE *int32

	// The maximum instance count value allowed.
	MAXIMUM *int32

	// The minimum instance count value allowed.
	MINIMUM *int32

	// Number of instances that are starting but not yet active.
	PENDING *int32

	// Number of instances that are no longer active but haven't yet been terminated.
	TERMINATING *int32

	noSmithyDocumentSerde
}

// The GameLift service limits for an EC2 instance type and current utilization.
// GameLift allows AWS accounts a maximum number of instances, per instance type,
// per AWS Region or location, for use with GameLift. You can request an limit
// increase for your account by using the Service limits page in the GameLift
// console. Related actions DescribeEC2InstanceLimits
type EC2InstanceLimit struct {

	// The number of instances for the specified type and location that are currently
	// being used by the AWS account.
	CurrentInstances *int32

	// The name of an EC2 instance type. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	EC2InstanceType EC2InstanceType

	// The number of instances that is allowed for the specified instance type and
	// location.
	InstanceLimit *int32

	// An AWS Region code, such as us-west-2.
	Location *string

	noSmithyDocumentSerde
}

// Log entry describing an event that involves GameLift resources (such as a
// fleet). In addition to tracking activity, event codes and messages can provide
// additional information for troubleshooting and debugging problems. Related
// actions DescribeFleetEvents
type Event struct {

	// The type of event being logged. Fleet creation events (ordered by fleet creation
	// activity):
	//
	// * FLEET_CREATED -- A fleet resource was successfully created with a
	// status of NEW. Event messaging includes the fleet ID.
	//
	// * FLEET_STATE_DOWNLOADING
	// -- Fleet status changed from NEW to DOWNLOADING. The compressed build has
	// started downloading to a fleet instance for installation.
	//
	// *
	// FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the fleet
	// instance.
	//
	// * FLEET_CREATION_EXTRACTING_BUILD – The game server build was
	// successfully downloaded to an instance, and the build files are now being
	// extracted from the uploaded build and saved to an instance. Failure at this
	// stage prevents a fleet from moving to ACTIVE status. Logs for this stage display
	// a list of the files that are extracted and saved on the instance. Access the
	// logs by using the URL in PreSignedLogUrl.
	//
	// * FLEET_CREATION_RUNNING_INSTALLER –
	// The game server build files were successfully extracted, and the GameLift is now
	// running the build's install script (if one is included). Failure in this stage
	// prevents a fleet from moving to ACTIVE status. Logs for this stage list the
	// installation steps and whether or not the install completed successfully. Access
	// the logs by using the URL in PreSignedLogUrl.
	//
	// *
	// FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful,
	// and the GameLift is now verifying that the game server launch paths, which are
	// specified in the fleet's runtime configuration, exist. If any listed launch path
	// exists, GameLift tries to launch a game server process and waits for the process
	// to report ready. Failures in this stage prevent a fleet from moving to ACTIVE
	// status. Logs for this stage list the launch paths in the runtime configuration
	// and indicate whether each is found. Access the logs by using the URL in
	// PreSignedLogUrl.
	//
	// * FLEET_STATE_VALIDATING -- Fleet status changed from
	// DOWNLOADING to VALIDATING.
	//
	// * FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND --
	// Validation of the runtime configuration failed because the executable specified
	// in a launch path does not exist on the instance.
	//
	// * FLEET_STATE_BUILDING --
	// Fleet status changed from VALIDATING to BUILDING.
	//
	// *
	// FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the runtime
	// configuration failed because the executable specified in a launch path failed to
	// run on the fleet instance.
	//
	// * FLEET_STATE_ACTIVATING -- Fleet status changed
	// from BUILDING to ACTIVATING.
	//
	// * FLEET_ACTIVATION_FAILED - The fleet failed to
	// successfully complete one of the steps in the fleet activation process. This
	// event code indicates that the game build was successfully downloaded to a fleet
	// instance, built, and validated, but was not able to start a server process.
	// Learn more at  Debug Fleet Creation Issues
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation)
	//
	// *
	// FLEET_STATE_ACTIVE -- The fleet's status changed from ACTIVATING to ACTIVE. The
	// fleet is now ready to host game sessions.
	//
	// VPC peering events:
	//
	// *
	// FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established
	// between the VPC for an GameLift fleet and a VPC in your AWS account.
	//
	// *
	// FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed. Event
	// details and status information (see DescribeVpcPeeringConnections) provide
	// additional detail. A common reason for peering failure is that the two VPCs have
	// overlapping CIDR blocks of IPv4 addresses. To resolve this, change the CIDR
	// block for the VPC in your AWS account. For more information on VPC peering
	// failures, see
	// https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html
	// (https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html)
	//
	// *
	// FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully
	// deleted.
	//
	// Spot instance events:
	//
	// * INSTANCE_INTERRUPTED -- A spot instance was
	// interrupted by EC2 with a two-minute notification.
	//
	// Other fleet events:
	//
	// *
	// FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings
	// (desired instances, minimum/maximum scaling limits). Event messaging includes
	// the new capacity settings.
	//
	// * FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED
	// -- A change was made to the fleet's game session protection policy setting.
	// Event messaging includes both the old and new policy setting.
	//
	// * FLEET_DELETED
	// -- A request to delete a fleet was initiated.
	//
	// * GENERIC_EVENT -- An unspecified
	// event has occurred.
	EventCode EventCode

	// A unique identifier for a fleet event.
	EventId *string

	// Time stamp indicating when this event occurred. Format is a number expressed in
	// Unix time as milliseconds (for example "1469498468.057").
	EventTime *time.Time

	// Additional information related to the event.
	Message *string

	// Location of stored logs with additional detail that is related to the event.
	// This is useful for debugging issues. The URL is valid for 15 minutes. You can
	// also access fleet creation logs through the GameLift console.
	PreSignedLogUrl *string

	// A unique identifier for an event resource, such as a fleet ID.
	ResourceId *string

	noSmithyDocumentSerde
}

// A list of fleet locations where a game session queue can place new game
// sessions. You can use a filter to temporarily turn off placements for specific
// locations. For queues that have multi-location fleets, you can use a filter
// configuration allow placement with some, but not all of these locations. Filter
// configurations are part of a GameSessionQueue.
type FilterConfiguration struct {

	// A list of locations to allow game session placement in, in the form of AWS
	// Region codes such as us-west-2.
	AllowedLocations []string

	noSmithyDocumentSerde
}

// Describes a GameLift fleet of game hosting resources. Related actions
// CreateFleet | DescribeFleetAttributes
type FleetAttributes struct {

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift build resource that is deployed on instances in this fleet. In
	// a GameLift build ARN, the resource ID matches the BuildId value.
	BuildArn *string

	// A unique identifier for the build resource that is deployed on instances in this
	// fleet.
	BuildId *string

	// Indicates whether a TLS/SSL certificate was generated for the fleet.
	CertificateConfiguration *CertificateConfiguration

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// A human-readable description of the fleet.
	Description *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift fleet resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912. In a
	// GameLift fleet ARN, the resource ID matches the FleetId value.
	FleetArn *string

	// A unique identifier for the fleet.
	FleetId *string

	// The kind of instances, On-Demand or Spot, that this fleet uses.
	FleetType FleetType

	// A unique identifier for an AWS IAM role that manages access to your AWS
	// services. With an instance role ARN set, any application that runs on an
	// instance in this fleet can assume the role, including install scripts, server
	// processes, and daemons (background processes). Create a role or look up a role's
	// ARN by using the IAM dashboard (https://console.aws.amazon.com/iam/) in the AWS
	// Management Console. Learn more about using on-box credentials for your game
	// servers at  Access external resources from a game server
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html).
	InstanceRoleArn *string

	// The EC2 instance type that determines the computing resources of each instance
	// in the fleet. Instance type defines the CPU, memory, storage, and networking
	// capacity. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	InstanceType EC2InstanceType

	// This parameter is no longer used. Game session log paths are now defined using
	// the GameLift server API ProcessReady()logParameters. See more information in the
	// Server API Reference
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api-ref.html#gamelift-sdk-server-api-ref-dataypes-process).
	LogPaths []string

	// Name of a metric group that metrics for this fleet are added to. In Amazon
	// CloudWatch, you can view aggregated metrics for fleets that are in a metric
	// group. A fleet can be included in only one metric group at a time.
	MetricGroups []string

	// A descriptive label that is associated with a fleet. Fleet names do not need to
	// be unique.
	Name *string

	// The type of game session protection to set on all new instances that are started
	// in the fleet.
	//
	// * NoProtection -- The game session can be terminated during a
	// scale-down event.
	//
	// * FullProtection -- If the game session is in an ACTIVE
	// status, it cannot be terminated during a scale-down event.
	NewGameSessionProtectionPolicy ProtectionPolicy

	// The operating system of the fleet's computing resources. A fleet's operating
	// system is determined by the OS of the build or script that is deployed on this
	// fleet.
	OperatingSystem OperatingSystem

	// The fleet policy that limits the number of game sessions an individual player
	// can create over a span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift script resource that is deployed on instances in this fleet.
	// In a GameLift script ARN, the resource ID matches the ScriptId value.
	ScriptArn *string

	// A unique identifier for the Realtime script resource that is deployed on
	// instances in this fleet.
	ScriptId *string

	// This parameter is no longer used. Server launch parameters are now defined using
	// the fleet's RuntimeConfiguration parameter. Requests that use this parameter
	// instead continue to be valid.
	ServerLaunchParameters *string

	// This parameter is no longer used. Server launch paths are now defined using the
	// fleet's RuntimeConfiguration parameter. Requests that use this parameter instead
	// continue to be valid.
	ServerLaunchPath *string

	// Current status of the fleet. Possible fleet statuses include the following:
	//
	// *
	// NEW -- A new fleet has been defined and desired instances is set to 1.
	//
	// *
	// DOWNLOADING/VALIDATING/BUILDING/ACTIVATING -- GameLift is setting up the new
	// fleet, creating new instances with the game build or Realtime script and
	// starting server processes.
	//
	// * ACTIVE -- Hosts can now accept game sessions.
	//
	// *
	// ERROR -- An error occurred when downloading, validating, building, or activating
	// the fleet.
	//
	// * DELETING -- Hosts are responding to a delete fleet request.
	//
	// *
	// TERMINATED -- The fleet no longer exists.
	Status FleetStatus

	// A list of fleet activity that has been suspended using StopFleetActions. This
	// includes fleet auto-scaling.
	StoppedActions []FleetAction

	// A time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time

	noSmithyDocumentSerde
}

// Current resource capacity settings in a specified fleet or location. The
// location value might refer to a fleet's remote location or its home Region.
// Related actions DescribeFleetCapacity | DescribeFleetLocationCapacity |
// UpdateFleetCapacity
type FleetCapacity struct {

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift fleet resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string

	// A unique identifier for the fleet associated with the location.
	FleetId *string

	// The current instance count and capacity settings for the fleet location.
	InstanceCounts *EC2InstanceCounts

	// The EC2 instance type that is used for all instances in a fleet. The instance
	// type determines the computing resources in use, including CPU, memory, storage,
	// and networking capacity. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	InstanceType EC2InstanceType

	// The fleet location for the instance count information, expressed as an AWS
	// Region code, such as us-west-2.
	Location *string

	noSmithyDocumentSerde
}

// Current resource utilization statistics in a specified fleet or location. The
// location value might refer to a fleet's remote location or its home Region.
// Related actions DescribeFleetUtilization | DescribeFleetLocationUtilization
type FleetUtilization struct {

	// The number of active game sessions that are currently being hosted across all
	// instances in the fleet location.
	ActiveGameSessionCount *int32

	// The number of server processes in ACTIVE status that are currently running
	// across all instances in the fleet location.
	ActiveServerProcessCount *int32

	// The number of active player sessions that are currently being hosted across all
	// instances in the fleet location.
	CurrentPlayerSessionCount *int32

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift fleet resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string

	// A unique identifier for the fleet associated with the location.
	FleetId *string

	// The fleet location for the fleet utilization information, expressed as an AWS
	// Region code, such as us-west-2.
	Location *string

	// The maximum number of players allowed across all game sessions that are
	// currently being hosted across all instances in the fleet location.
	MaximumPlayerSessionCount *int32

	noSmithyDocumentSerde
}

// Set of key-value pairs that contain information about a game session. When
// included in a game session request, these properties communicate details to be
// used when setting up the new game session. For example, a game property might
// specify a game mode, level, or map. Game properties are passed to the game
// server process when initiating a new game session. For more information, see the
// GameLift Developer Guide
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create).
type GameProperty struct {

	// The game property identifier.
	//
	// This member is required.
	Key *string

	// The game property value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups.
// Properties describing a game server that is running on an instance in a
// GameServerGroup. A game server is created by a successful call to
// RegisterGameServer and deleted by calling DeregisterGameServer. A game server is
// claimed to host a game session by calling ClaimGameServer. Related actions
// RegisterGameServer | ListGameServers | ClaimGameServer | DescribeGameServer |
// UpdateGameServer | DeregisterGameServer | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html)
type GameServer struct {

	// Indicates when an available game server has been reserved for gameplay but has
	// not yet started hosting a game. Once it is claimed, the game server remains in
	// CLAIMED status for a maximum of one minute. During this time, game clients
	// connect to the game server to start the game and trigger the game server to
	// update its utilization status. After one minute, the game server claim status
	// reverts to null.
	ClaimStatus GameServerClaimStatus

	// The port and IP address that must be used to establish a client connection to
	// the game server.
	ConnectionInfo *string

	// A set of custom game server properties, formatted as a single string value. This
	// data is passed to a game client or service when it requests information on game
	// servers using ListGameServers or ClaimGameServer.
	GameServerData *string

	// The ARN identifier for the game server group where the game server is located.
	GameServerGroupArn *string

	// A unique identifier for the game server group where the game server is running.
	// Use either the GameServerGroup name or ARN value.
	GameServerGroupName *string

	// A custom string that uniquely identifies the game server. Game server IDs are
	// developer-defined and are unique across all game server groups in an AWS
	// account.
	GameServerId *string

	// The unique identifier for the instance where the game server is running. This ID
	// is available in the instance metadata. EC2 instance IDs use a 17-character
	// format, for example: i-1234567890abcdef0.
	InstanceId *string

	// Timestamp that indicates the last time the game server was claimed with a
	// ClaimGameServer request. The format is a number expressed in Unix time as
	// milliseconds (for example "1469498468.057"). This value is used to calculate
	// when a claimed game server's status should revert to null.
	LastClaimTime *time.Time

	// Timestamp that indicates the last time the game server was updated with health
	// status using an UpdateGameServer request. The format is a number expressed in
	// Unix time as milliseconds (for example "1469498468.057"). After game server
	// registration, this property is only changed when a game server update specifies
	// a health check value.
	LastHealthCheckTime *time.Time

	// Timestamp that indicates when the game server was created with a
	// RegisterGameServer request. The format is a number expressed in Unix time as
	// milliseconds (for example "1469498468.057").
	RegistrationTime *time.Time

	// Indicates whether the game server is currently available for new games or is
	// busy. Possible statuses include:
	//
	// * AVAILABLE - The game server is available to
	// be claimed. A game server that has been claimed remains in this status until it
	// reports game hosting activity.
	//
	// * UTILIZED - The game server is currently
	// hosting a game session with players.
	UtilizationStatus GameServerUtilizationStatus

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups.
// Properties that describe a game server group resource. A game server group
// manages certain properties related to a corresponding EC2 Auto Scaling group. A
// game server group is created by a successful call to CreateGameServerGroup and
// deleted by calling DeleteGameServerGroup. Game server group activity can be
// temporarily suspended and resumed by calling SuspendGameServerGroup and
// ResumeGameServerGroup, respectively. Related actions CreateGameServerGroup |
// ListGameServerGroups | DescribeGameServerGroup | UpdateGameServerGroup |
// DeleteGameServerGroup | ResumeGameServerGroup | SuspendGameServerGroup |
// DescribeGameServerInstances | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html)
type GameServerGroup struct {

	// A generated unique ID for the EC2 Auto Scaling group that is associated with
	// this game server group.
	AutoScalingGroupArn *string

	// Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand
	// Instances in the game server group. Method options include the following:
	//
	// *
	// SPOT_ONLY - Only Spot Instances are used in the game server group. If Spot
	// Instances are unavailable or not viable for game hosting, the game server group
	// provides no hosting capacity until Spot Instances can again be used. Until then,
	// no new instances are started, and the existing nonviable Spot Instances are
	// terminated (after current gameplay ends) and are not replaced.
	//
	// * SPOT_PREFERRED
	// - (default value) Spot Instances are used whenever available in the game server
	// group. If Spot Instances are unavailable, the game server group continues to
	// provide hosting capacity by falling back to On-Demand Instances. Existing
	// nonviable Spot Instances are terminated (after current gameplay ends) and are
	// replaced with new On-Demand Instances.
	//
	// * ON_DEMAND_ONLY - Only On-Demand
	// Instances are used in the game server group. No Spot Instances are used, even
	// when available, while this balancing strategy is in force.
	BalancingStrategy BalancingStrategy

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// A generated unique ID for the game server group.
	GameServerGroupArn *string

	// A developer-defined identifier for the game server group. The name is unique for
	// each Region in each AWS account.
	GameServerGroupName *string

	// A flag that indicates whether instances in the game server group are protected
	// from early termination. Unprotected instances that have active game servers
	// running might be terminated during a scale-down event, causing players to be
	// dropped from the game. Protected instances cannot be terminated while there are
	// active game servers running except in the event of a forced game server group
	// deletion (see ). An exception to this is with Spot Instances, which can be
	// terminated by AWS regardless of protection status.
	GameServerProtectionPolicy GameServerProtectionPolicy

	// The set of EC2 instance types that GameLift FleetIQ can use when balancing and
	// automatically scaling instances in the corresponding Auto Scaling group.
	InstanceDefinitions []InstanceDefinition

	// A timestamp that indicates when this game server group was last updated.
	LastUpdatedTime *time.Time

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) for an IAM
	// role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
	RoleArn *string

	// The current status of the game server group. Possible statuses include:
	//
	// * NEW -
	// GameLift FleetIQ has validated the CreateGameServerGroup() request.
	//
	// *
	// ACTIVATING - GameLift FleetIQ is setting up a game server group, which includes
	// creating an Auto Scaling group in your AWS account.
	//
	// * ACTIVE - The game server
	// group has been successfully created.
	//
	// * DELETE_SCHEDULED - A request to delete
	// the game server group has been received.
	//
	// * DELETING - GameLift FleetIQ has
	// received a valid DeleteGameServerGroup() request and is processing it. GameLift
	// FleetIQ must first complete and release hosts before it deletes the Auto Scaling
	// group and the game server group.
	//
	// * DELETED - The game server group has been
	// successfully deleted.
	//
	// * ERROR - The asynchronous processes of activating or
	// deleting a game server group has failed, resulting in an error state.
	Status GameServerGroupStatus

	// Additional information about the current game server group status. This
	// information might provide additional insight on groups that are in ERROR status.
	StatusReason *string

	// A list of activities that are currently suspended for this game server group. If
	// this property is empty, all activities are occurring.
	SuspendedActions []GameServerGroupAction

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups.
// Configuration settings for intelligent automatic scaling that uses target
// tracking. These settings are used to add an Auto Scaling policy when creating
// the corresponding Auto Scaling group with CreateGameServerGroup. After the Auto
// Scaling group is created, all updates to Auto Scaling policies, including
// changing this policy and adding or removing other policies, is done directly on
// the Auto Scaling group.
type GameServerGroupAutoScalingPolicy struct {

	// Settings for a target-based scaling policy applied to Auto Scaling group. These
	// settings are used to create a target-based policy that tracks the GameLift
	// FleetIQ metric "PercentUtilizedGameServers" and specifies a target value for the
	// metric. As player usage changes, the policy triggers to adjust the game server
	// group capacity so that the metric returns to the target value.
	//
	// This member is required.
	TargetTrackingConfiguration *TargetTrackingConfiguration

	// Length of time, in seconds, it takes for a new instance to start new game server
	// processes and register with GameLift FleetIQ. Specifying a warm-up time can be
	// useful, particularly with game servers that take a long time to start up,
	// because it avoids prematurely starting new instances.
	EstimatedInstanceWarmup *int32

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups.
// Additional properties, including status, that describe an EC2 instance in a game
// server group. Instance configurations are set with game server group properties
// (see DescribeGameServerGroup and with the EC2 launch template that was used when
// creating the game server group. Retrieve game server instances for a game server
// group by calling DescribeGameServerInstances. Related actions
// CreateGameServerGroup | ListGameServerGroups | DescribeGameServerGroup |
// UpdateGameServerGroup | DeleteGameServerGroup | ResumeGameServerGroup |
// SuspendGameServerGroup | DescribeGameServerInstances | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html)
type GameServerInstance struct {

	// A generated unique identifier for the game server group that includes the game
	// server instance.
	GameServerGroupArn *string

	// A developer-defined identifier for the game server group that includes the game
	// server instance. The name is unique for each Region in each AWS account.
	GameServerGroupName *string

	// The unique identifier for the instance where the game server is running. This ID
	// is available in the instance metadata. EC2 instance IDs use a 17-character
	// format, for example: i-1234567890abcdef0.
	InstanceId *string

	// Current status of the game server instance.
	//
	// * ACTIVE -- The instance is viable
	// for hosting game servers.
	//
	// * DRAINING -- The instance is not viable for hosting
	// game servers. Existing game servers are in the process of ending, and new game
	// servers are not started on this instance unless no other resources are
	// available. When the instance is put in DRAINING, a new instance is started up to
	// replace it. Once the instance has no UTILIZED game servers, it will be
	// terminated in favor of the new instance.
	//
	// * SPOT_TERMINATING -- The instance is
	// in the process of shutting down due to a Spot instance interruption. No new game
	// servers are started on this instance.
	InstanceStatus GameServerInstanceStatus

	noSmithyDocumentSerde
}

// Properties describing a game session. A game session in ACTIVE status can host
// players. When a game session ends, its status is set to TERMINATED. Once the
// session ends, the game session object is retained for 30 days. This means you
// can reuse idempotency token values after this time. Game session logs are
// retained for 14 days. Related actions CreateGameSession | DescribeGameSessions |
// DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession |
// GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement
// | StopGameSessionPlacement | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type GameSession struct {

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// A unique identifier for a player. This ID is used to enforce a resource
	// protection policy (if one exists), that limits the number of game sessions a
	// player can create.
	CreatorId *string

	// Number of players currently in the game session.
	CurrentPlayerSessionCount *int32

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	// * TLS-enabled fleets:
	// ..amazongamelift.com.
	//
	// * Non-TLS-enabled fleets: ec2-.compute.amazonaws.com.
	// (See Amazon EC2 Instance IP Addressing
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When
	// connecting to a game session that is running on a TLS-enabled fleet, you must
	// use the DNS name, not the IP address.
	DnsName *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift fleet that this game session is running on.
	FleetArn *string

	// A unique identifier for the fleet that the game session is running on.
	FleetId *string

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session. You can search for active game
	// sessions based on this custom data with SearchGameSessions.
	GameProperties []GameProperty

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with a
	// request to start a new game session.
	GameSessionData *string

	// A unique identifier for the game session. A game session ARN has the following
	// format: arn:aws:gamelift:::gamesession//.
	GameSessionId *string

	// The IP address of the game session. To connect to a GameLift game server, an app
	// needs both the IP address and port number.
	IpAddress *string

	// The fleet location where the game session is running. This value might specify
	// the fleet's home Region or a remote location. Location is expressed as an AWS
	// Region code such as us-west-2.
	Location *string

	// Information about the matchmaking process that was used to create the game
	// session. It is in JSON syntax, formatted as a string. In addition the
	// matchmaking configuration used, it contains data on all players assigned to the
	// match, including player attributes and team assignments. For more details on
	// matchmaker data, see Match Data
	// (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data).
	// Matchmaker data is useful when requesting match backfills, and is updated
	// whenever new players are added during a successful backfill (see
	// StartMatchBackfill).
	MatchmakerData *string

	// The maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int32

	// A descriptive label that is associated with a game session. Session names do not
	// need to be unique.
	Name *string

	// Indicates whether or not the game session is accepting new players.
	PlayerSessionCreationPolicy PlayerSessionCreationPolicy

	// The port number for the game session. To connect to a GameLift game server, an
	// app needs both the IP address and port number.
	Port *int32

	// Current status of the game session. A game session must have an ACTIVE status to
	// have player sessions.
	Status GameSessionStatus

	// Provides additional information about game session status. INTERRUPTED indicates
	// that the game session was hosted on a spot instance that was reclaimed, causing
	// the active game session to be terminated.
	StatusReason GameSessionStatusReason

	// A time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time

	noSmithyDocumentSerde
}

// Connection information for a new game session that is created in response to a
// StartMatchmaking request. Once a match is made, the FlexMatch engine creates a
// new game session for it. This information, including the game session endpoint
// and player sessions for each player in the original matchmaking request, is
// added to the MatchmakingTicket, which can be retrieved by calling
// DescribeMatchmaking.
type GameSessionConnectionInfo struct {

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	// * TLS-enabled fleets:
	// ..amazongamelift.com.
	//
	// * Non-TLS-enabled fleets: ec2-.compute.amazonaws.com.
	// (See Amazon EC2 Instance IP Addressing
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When
	// connecting to a game session that is running on a TLS-enabled fleet, you must
	// use the DNS name, not the IP address.
	DnsName *string

	// A unique identifier for the game session. Use the game session ID.
	GameSessionArn *string

	// The IP address of the game session. To connect to a GameLift game server, an app
	// needs both the IP address and port number.
	IpAddress *string

	// A collection of player session IDs, one for each player ID that was included in
	// the original matchmaking request.
	MatchedPlayerSessions []MatchedPlayerSession

	// The port number for the game session. To connect to a GameLift game server, an
	// app needs both the IP address and port number.
	Port *int32

	noSmithyDocumentSerde
}

// A game session's properties plus the protection policy currently in force.
type GameSessionDetail struct {

	// Object that describes a game session.
	GameSession *GameSession

	// Current status of protection for the game session.
	//
	// * NoProtection -- The game
	// session can be terminated during a scale-down event.
	//
	// * FullProtection -- If the
	// game session is in an ACTIVE status, it cannot be terminated during a scale-down
	// event.
	ProtectionPolicy ProtectionPolicy

	noSmithyDocumentSerde
}

// Object that describes a StartGameSessionPlacement request. This object includes
// the full details of the original request plus the current status and start/end
// time stamps. Game session placement-related operations include:
//
// *
// StartGameSessionPlacement
//
// * DescribeGameSessionPlacement
//
// *
// StopGameSessionPlacement
type GameSessionPlacement struct {

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	// * TLS-enabled fleets:
	// ..amazongamelift.com.
	//
	// * Non-TLS-enabled fleets: ec2-.compute.amazonaws.com.
	// (See Amazon EC2 Instance IP Addressing
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When
	// connecting to a game session that is running on a TLS-enabled fleet, you must
	// use the DNS name, not the IP address.
	DnsName *string

	// Time stamp indicating when this request was completed, canceled, or timed out.
	EndTime *time.Time

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []GameProperty

	// Identifier for the game session created by this placement request. This value is
	// set once the new game session is placed (placement status is FULFILLED). This
	// identifier is unique across all Regions. You can use this value as a
	// GameSessionId value as needed.
	GameSessionArn *string

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with a
	// request to start a new game session (see Start a Game Session
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string

	// A unique identifier for the game session. This value is set once the new game
	// session is placed (placement status is FULFILLED).
	GameSessionId *string

	// A descriptive label that is associated with a game session. Session names do not
	// need to be unique.
	GameSessionName *string

	// A descriptive label that is associated with game session queue. Queue names must
	// be unique within each Region.
	GameSessionQueueName *string

	// Name of the Region where the game session created by this placement request is
	// running. This value is set once the new game session is placed (placement status
	// is FULFILLED).
	GameSessionRegion *string

	// The IP address of the game session. To connect to a GameLift game server, an app
	// needs both the IP address and port number. This value is set once the new game
	// session is placed (placement status is FULFILLED).
	IpAddress *string

	// Information on the matchmaking process for this game. Data is in JSON syntax,
	// formatted as a string. It identifies the matchmaking configuration used to
	// create the match, and contains data on all players assigned to the match,
	// including player attributes and team assignments. For more details on matchmaker
	// data, see Match Data
	// (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data).
	MatchmakerData *string

	// The maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int32

	// A collection of information on player sessions created in response to the game
	// session placement request. These player sessions are created only once a new
	// game session is successfully placed (placement status is FULFILLED). This
	// information includes the player ID (as provided in the placement request) and
	// the corresponding player session ID. Retrieve full player sessions by calling
	// DescribePlayerSessions with the player session ID.
	PlacedPlayerSessions []PlacedPlayerSession

	// A unique identifier for a game session placement.
	PlacementId *string

	// A set of values, expressed in milliseconds, that indicates the amount of latency
	// that a player experiences when connected to AWS Regions.
	PlayerLatencies []PlayerLatency

	// The port number for the game session. To connect to a GameLift game server, an
	// app needs both the IP address and port number. This value is set once the new
	// game session is placed (placement status is FULFILLED).
	Port *int32

	// Time stamp indicating when this request was placed in the queue. Format is a
	// number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time

	// Current status of the game session placement request.
	//
	// * PENDING -- The
	// placement request is currently in the queue waiting to be processed.
	//
	// *
	// FULFILLED -- A new game session and player sessions (if requested) have been
	// successfully created. Values for GameSessionArn and GameSessionRegion are
	// available.
	//
	// * CANCELLED -- The placement request was canceled with a call to
	// StopGameSessionPlacement.
	//
	// * TIMED_OUT -- A new game session was not
	// successfully created before the time limit expired. You can resubmit the
	// placement request as needed.
	//
	// * FAILED -- GameLift is not able to complete the
	// process of placing the game session. Common reasons are the game session
	// terminated before the placement process was completed, or an unexpected internal
	// error.
	Status GameSessionPlacementState

	noSmithyDocumentSerde
}

// Configuration for a game session placement mechanism that processes requests for
// new game sessions. A queue can be used on its own or as part of a matchmaking
// solution. Related actions CreateGameSessionQueue | DescribeGameSessionQueues |
// UpdateGameSessionQueue
type GameSessionQueue struct {

	// Information that is added to all events that are related to this game session
	// queue.
	CustomEventData *string

	// A list of fleets and/or fleet aliases that can be used to fulfill game session
	// placement requests in the queue. Destinations are identified by either a fleet
	// ARN or a fleet alias ARN, and are listed in order of placement preference.
	Destinations []GameSessionQueueDestination

	// A list of locations where a queue is allowed to place new game sessions.
	// Locations are specified in the form of AWS Region codes, such as us-west-2. If
	// this parameter is not set, game sessions can be placed in any queue location.
	FilterConfiguration *FilterConfiguration

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift game session queue resource and uniquely identifies it.
	// ARNs are unique across all Regions. Format is
	// arn:aws:gamelift:::gamesessionqueue/. In a GameLift game session queue ARN, the
	// resource ID matches the Name value.
	GameSessionQueueArn *string

	// A descriptive label that is associated with game session queue. Queue names must
	// be unique within each Region.
	Name *string

	// An SNS topic ARN that is set up to receive game session placement notifications.
	// See  Setting up notifications for game session placement
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/queue-notification.html).
	NotificationTarget *string

	// A set of policies that act as a sliding cap on player latency. FleetIQ works to
	// deliver low latency for most players in a game session. These policies ensure
	// that no individual player can be placed into a game with unreasonably high
	// latency. Use multiple policies to gradually relax latency requirements a step at
	// a time. Multiple policies are applied based on their maximum allowed latency,
	// starting with the lowest value.
	PlayerLatencyPolicies []PlayerLatencyPolicy

	// Custom settings to use when prioritizing destinations and locations for game
	// session placements. This configuration replaces the FleetIQ default
	// prioritization process. Priority types that are not explicitly named will be
	// automatically applied at the end of the prioritization process.
	PriorityConfiguration *PriorityConfiguration

	// The maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// A fleet or alias designated in a game session queue. Queues fulfill requests for
// new game sessions by placing a new game session on any of the queue's
// destinations. Destinations are part of a GameSessionQueue.
type GameSessionQueueDestination struct {

	// The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs,
	// which include a fleet ID or alias ID and a Region name, provide a unique
	// identifier across all Regions.
	DestinationArn *string

	noSmithyDocumentSerde
}

// Represents an EC2 instance of virtual computing resources that hosts one or more
// game servers. In GameLift, a fleet can contain zero or more instances. Related
// actions DescribeInstances
type Instance struct {

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	// * TLS-enabled fleets:
	// ..amazongamelift.com.
	//
	// * Non-TLS-enabled fleets: ec2-.compute.amazonaws.com.
	// (See Amazon EC2 Instance IP Addressing
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When
	// connecting to a game session that is running on a TLS-enabled fleet, you must
	// use the DNS name, not the IP address.
	DnsName *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift fleet resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string

	// A unique identifier for the fleet that the instance is in.
	FleetId *string

	// A unique identifier for the instance.
	InstanceId *string

	// IP address that is assigned to the instance.
	IpAddress *string

	// The fleet location of the instance, expressed as an AWS Region code, such as
	// us-west-2.
	Location *string

	// Operating system that is running on this instance.
	OperatingSystem OperatingSystem

	// Current status of the instance. Possible statuses include the following:
	//
	// *
	// PENDING -- The instance is in the process of being created and launching server
	// processes as defined in the fleet's run-time configuration.
	//
	// * ACTIVE -- The
	// instance has been successfully created and at least one server process has
	// successfully launched and reported back to GameLift that it is ready to host a
	// game session. The instance is now considered ready to host game sessions.
	//
	// *
	// TERMINATING -- The instance is in the process of shutting down. This may happen
	// to reduce capacity during a scaling down event or to recycle resources in the
	// event of a problem.
	Status InstanceStatus

	// EC2 instance type that defines the computing resources of this instance.
	Type EC2InstanceType

	noSmithyDocumentSerde
}

// Information required to remotely connect to a fleet instance. Access is
// requested by calling GetInstanceAccess.
type InstanceAccess struct {

	// Credentials required to access the instance.
	Credentials *InstanceCredentials

	// A unique identifier for the fleet containing the instance being accessed.
	FleetId *string

	// A unique identifier for the instance being accessed.
	InstanceId *string

	// IP address that is assigned to the instance.
	IpAddress *string

	// Operating system that is running on the instance.
	OperatingSystem OperatingSystem

	noSmithyDocumentSerde
}

// Set of credentials required to remotely access a fleet instance. Access
// credentials are requested by calling GetInstanceAccess and returned in an
// InstanceAccess object.
type InstanceCredentials struct {

	// Secret string. For Windows instances, the secret is a password for use with
	// Windows Remote Desktop. For Linux instances, it is a private key (which must be
	// saved as a .pem file) for use with SSH.
	Secret *string

	// User login string.
	UserName *string

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups. An
// allowed instance type for a GameServerGroup. All game server groups must have at
// least two instance types defined for it. GameLift FleetIQ periodically evaluates
// each defined instance type for viability. It then updates the Auto Scaling group
// with the list of viable instance types.
type InstanceDefinition struct {

	// An EC2 instance type designation.
	//
	// This member is required.
	InstanceType GameServerGroupInstanceType

	// Instance weighting that indicates how much this instance type contributes to the
	// total capacity of a game server group. Instance weights are used by GameLift
	// FleetIQ to calculate the instance type's cost per unit hour and better identify
	// the most cost-effective options. For detailed information on weighting instance
	// capacity, see Instance Weighting
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-weighting.html)
	// in the Amazon EC2 Auto Scaling User Guide. Default value is "1".
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// A range of IP addresses and port settings that allow inbound traffic to connect
// to server processes on an instance in a fleet. New game sessions are assigned an
// IP address/port number combination, which must fall into the fleet's allowed
// ranges. Fleets with custom game builds must have permissions explicitly set. For
// Realtime Servers fleets, GameLift automatically opens two port ranges, one for
// TCP messaging and one for UDP. Related actions DescribeFleetPortSettings
type IpPermission struct {

	// A starting value for a range of allowed port numbers.
	//
	// This member is required.
	FromPort *int32

	// A range of allowed IP addresses. This value must be expressed in CIDR notation.
	// Example: "000.000.000.000/[subnet mask]" or optionally the shortened version
	// "0.0.0.0/[subnet mask]".
	//
	// This member is required.
	IpRange *string

	// The network communication protocol used by the fleet.
	//
	// This member is required.
	Protocol IpProtocol

	// An ending value for a range of allowed port numbers. Port numbers are
	// end-inclusive. This value must be higher than FromPort.
	//
	// This member is required.
	ToPort *int32

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups. An EC2
// launch template that contains configuration settings and game server code to be
// deployed to all instances in a game server group. The launch template is
// specified when creating a new game server group with CreateGameServerGroup.
type LaunchTemplateSpecification struct {

	// A unique identifier for an existing EC2 launch template.
	LaunchTemplateId *string

	// A readable identifier for an existing EC2 launch template.
	LaunchTemplateName *string

	// The version of the EC2 launch template to use. If no version is specified, the
	// default version will be used. With Amazon EC2, you can specify a default version
	// for a launch template. If none is set, the default is the first version created.
	Version *string

	noSmithyDocumentSerde
}

// Represents a location in a multi-location fleet. Related actions
// DescribeFleetLocationAttributes
type LocationAttributes struct {

	// A fleet location and its current life-cycle state.
	LocationState *LocationState

	// A list of fleet actions that have been suspended in the fleet location.
	StoppedActions []FleetAction

	// The status of fleet activity updates to the location. The status PENDING_UPDATE
	// indicates that StopFleetActions or StartFleetActions has been requested but the
	// update has not yet been completed for the location.
	UpdateStatus LocationUpdateStatus

	noSmithyDocumentSerde
}

// A remote location where a multi-location fleet can deploy EC2 instances for game
// hosting. Related actions CreateFleet
type LocationConfiguration struct {

	// An AWS Region code, such as us-west-2.
	Location *string

	noSmithyDocumentSerde
}

// A fleet location and its life-cycle state. A location state object might be used
// to describe a fleet's remote location or home Region. Life-cycle state tracks
// the progress of launching the first instance in a new location and preparing it
// for game hosting, and then removing all instances and deleting the location from
// the fleet. Related actions CreateFleet | CreateFleetLocations |
// DeleteFleetLocations
type LocationState struct {

	// The fleet location, expressed as an AWS Region code such as us-west-2.
	Location *string

	// The life-cycle status of a fleet location.
	Status FleetStatus

	noSmithyDocumentSerde
}

// Represents a new player session that is created as a result of a successful
// FlexMatch match. A successful match automatically creates new player sessions
// for every player ID in the original matchmaking request. When players connect to
// the match's game session, they must include both player ID and player session ID
// in order to claim their assigned player slot.
type MatchedPlayerSession struct {

	// A unique identifier for a player
	PlayerId *string

	// A unique identifier for a player session
	PlayerSessionId *string

	noSmithyDocumentSerde
}

// Guidelines for use with FlexMatch to match players into games. All matchmaking
// requests must specify a matchmaking configuration.
type MatchmakingConfiguration struct {

	// A flag that indicates whether a match that was created with this configuration
	// must be accepted by the matched players. To require acceptance, set to TRUE.
	// When this option is enabled, matchmaking tickets use the status
	// REQUIRES_ACCEPTANCE to indicate when a completed potential match is waiting for
	// player acceptance.
	AcceptanceRequired *bool

	// The length of time (in seconds) to wait for players to accept a proposed match,
	// if acceptance is required. If any player rejects the match or fails to accept
	// before the timeout, the ticket continues to look for an acceptable match.
	AcceptanceTimeoutSeconds *int32

	// The number of player slots in a match to keep open for future players. For
	// example, if the configuration's rule set specifies a match for a single
	// 12-person team, and the additional player count is set to 2, only 10 players are
	// selected for the match. This parameter is not used when FlexMatchMode is set to
	// STANDALONE.
	AdditionalPlayerCount *int32

	// The method used to backfill game sessions created with this matchmaking
	// configuration. MANUAL indicates that the game makes backfill requests or does
	// not use the match backfill feature. AUTOMATIC indicates that GameLift creates
	// StartMatchBackfill requests whenever a game session has one or more open slots.
	// Learn more about manual and automatic backfill in Backfill existing games with
	// FlexMatch
	// (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html).
	// Automatic backfill is not available when FlexMatchMode is set to STANDALONE.
	BackfillMode BackfillMode

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift matchmaking configuration resource and uniquely
	// identifies it. ARNs are unique across all Regions. Format is
	// arn:aws:gamelift:::matchmakingconfiguration/. In a GameLift configuration ARN,
	// the resource ID matches the Name value.
	ConfigurationArn *string

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// Information to attach to all events related to the matchmaking configuration.
	CustomEventData *string

	// A descriptive label that is associated with matchmaking configuration.
	Description *string

	// Indicates whether this matchmaking configuration is being used with GameLift
	// hosting or as a standalone matchmaking solution.
	//
	// * STANDALONE - FlexMatch forms
	// matches and returns match information, including players and team assignments,
	// in a  MatchmakingSucceeded
	// (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded)
	// event.
	//
	// * WITH_QUEUE - FlexMatch forms matches and uses the specified GameLift
	// queue to start a game session for the match.
	FlexMatchMode FlexMatchMode

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for a
	// successful match. This parameter is not used when FlexMatchMode is set to
	// STANDALONE.
	GameProperties []GameProperty

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with a
	// request to start a new game session (see Start a Game Session
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for a
	// successful match. This parameter is not used when FlexMatchMode is set to
	// STANDALONE.
	GameSessionData *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift game session queue resource and uniquely identifies it.
	// ARNs are unique across all Regions. Format is
	// arn:aws:gamelift:::gamesessionqueue/. Queues can be located in any Region.
	// Queues are used to start new GameLift-hosted game sessions for matches that are
	// created with this matchmaking configuration. This property is not set when
	// FlexMatchMode is set to STANDALONE.
	GameSessionQueueArns []string

	// A unique identifier for the matchmaking configuration. This name is used to
	// identify the configuration associated with a matchmaking request or ticket.
	Name *string

	// An SNS topic ARN that is set up to receive matchmaking notifications.
	NotificationTarget *string

	// The maximum duration, in seconds, that a matchmaking ticket can remain in
	// process before timing out. Requests that fail due to timing out can be
	// resubmitted as needed.
	RequestTimeoutSeconds *int32

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift matchmaking rule set resource that this configuration uses.
	RuleSetArn *string

	// A unique identifier for the matchmaking rule set to use with this configuration.
	// A matchmaking configuration can only use rule sets that are defined in the same
	// Region.
	RuleSetName *string

	noSmithyDocumentSerde
}

// Set of rule statements, used with FlexMatch, that determine how to build your
// player matches. Each rule set describes a type of group to be created and
// defines the parameters for acceptable player matches. Rule sets are used in
// MatchmakingConfiguration objects. A rule set may define the following elements
// for a match. For detailed information and examples showing how to construct a
// rule set, see Build a FlexMatch rule set
// (https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html).
//
// *
// Teams -- Required. A rule set must define one or multiple teams for the match
// and set minimum and maximum team sizes. For example, a rule set might describe a
// 4x4 match that requires all eight slots to be filled.
//
// * Player attributes --
// Optional. These attributes specify a set of player characteristics to evaluate
// when looking for a match. Matchmaking requests that use a rule set with player
// attributes must provide the corresponding attribute values. For example, an
// attribute might specify a player's skill or level.
//
// * Rules -- Optional. Rules
// define how to evaluate potential players for a match based on player attributes.
// A rule might specify minimum requirements for individual players, teams, or
// entire matches. For example, a rule might require each player to meet a certain
// skill level, each team to have at least one player in a certain role, or the
// match to have a minimum average skill level. or may describe an entire
// group--such as all teams must be evenly matched or have at least one player in a
// certain role.
//
// * Expansions -- Optional. Expansions allow you to relax the rules
// after a period of time when no acceptable matches are found. This feature lets
// you balance getting players into games in a reasonable amount of time instead of
// making them wait indefinitely for the best possible match. For example, you
// might use an expansion to increase the maximum skill variance between players
// after 30 seconds.
type MatchmakingRuleSet struct {

	// A collection of matchmaking rules, formatted as a JSON string. Comments are not
	// allowed in JSON, but most elements support a description field.
	//
	// This member is required.
	RuleSetBody *string

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift matchmaking rule set resource and uniquely identifies it.
	// ARNs are unique across all Regions. Format is
	// arn:aws:gamelift:::matchmakingruleset/. In a GameLift rule set ARN, the resource
	// ID matches the RuleSetName value.
	RuleSetArn *string

	// A unique identifier for the matchmaking rule set
	RuleSetName *string

	noSmithyDocumentSerde
}

// Ticket generated to track the progress of a matchmaking request. Each ticket is
// uniquely identified by a ticket ID, supplied by the requester, when creating a
// matchmaking request with StartMatchmaking. Tickets can be retrieved by calling
// DescribeMatchmaking with the ticket ID.
type MatchmakingTicket struct {

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift matchmaking configuration resource that is used with this
	// ticket.
	ConfigurationArn *string

	// Name of the MatchmakingConfiguration that is used with this ticket. Matchmaking
	// configurations determine how players are grouped into a match and how a new game
	// session is created for the match.
	ConfigurationName *string

	// Time stamp indicating when this matchmaking request stopped being processed due
	// to success, failure, or cancellation. Format is a number expressed in Unix time
	// as milliseconds (for example "1469498468.057").
	EndTime *time.Time

	// Average amount of time (in seconds) that players are currently waiting for a
	// match. If there is not enough recent data, this property may be empty.
	EstimatedWaitTime *int32

	// Identifier and connection information of the game session created for the match.
	// This information is added to the ticket only after the matchmaking request has
	// been successfully completed. This parameter is not set when FlexMatch is being
	// used without GameLift hosting.
	GameSessionConnectionInfo *GameSessionConnectionInfo

	// A set of Player objects, each representing a player to find matches for. Players
	// are identified by a unique player ID and may include latency data for use during
	// matchmaking. If the ticket is in status COMPLETED, the Player objects include
	// the team the players were assigned to in the resulting match.
	Players []Player

	// Time stamp indicating when this matchmaking request was received. Format is a
	// number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time

	// Current status of the matchmaking request.
	//
	// * QUEUED -- The matchmaking request
	// has been received and is currently waiting to be processed.
	//
	// * SEARCHING -- The
	// matchmaking request is currently being processed.
	//
	// * REQUIRES_ACCEPTANCE -- A
	// match has been proposed and the players must accept the match (see AcceptMatch).
	// This status is used only with requests that use a matchmaking configuration with
	// a player acceptance requirement.
	//
	// * PLACING -- The FlexMatch engine has matched
	// players and is in the process of placing a new game session for the match.
	//
	// *
	// COMPLETED -- Players have been matched and a game session is ready to host the
	// players. A ticket in this state contains the necessary connection information
	// for players.
	//
	// * FAILED -- The matchmaking request was not completed.
	//
	// *
	// CANCELLED -- The matchmaking request was canceled. This may be the result of a
	// call to StopMatchmaking or a proposed match that one or more players failed to
	// accept.
	//
	// * TIMED_OUT -- The matchmaking request was not successful within the
	// duration specified in the matchmaking configuration.
	//
	// Matchmaking requests that
	// fail to successfully complete (statuses FAILED, CANCELLED, TIMED_OUT) can be
	// resubmitted as new requests with new ticket IDs.
	Status MatchmakingConfigurationStatus

	// Additional information about the current status.
	StatusMessage *string

	// Code to explain the current status. For example, a status reason may indicate
	// when a ticket has returned to SEARCHING status after a proposed match fails to
	// receive player acceptances.
	StatusReason *string

	// A unique identifier for a matchmaking ticket.
	TicketId *string

	noSmithyDocumentSerde
}

// Information about a player session that was created as part of a
// StartGameSessionPlacement request. This object contains only the player ID and
// player session ID. To retrieve full details on a player session, call
// DescribePlayerSessions with the player session ID. Related actions
// CreatePlayerSession | CreatePlayerSessions | DescribePlayerSessions |
// StartGameSessionPlacement | DescribeGameSessionPlacement |
// StopGameSessionPlacement | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type PlacedPlayerSession struct {

	// A unique identifier for a player that is associated with this player session.
	PlayerId *string

	// A unique identifier for a player session.
	PlayerSessionId *string

	noSmithyDocumentSerde
}

// Represents a player in matchmaking. When starting a matchmaking request, a
// player has a player ID, attributes, and may have latency data. Team information
// is added after a match has been successfully completed.
type Player struct {

	// A set of values, expressed in milliseconds, that indicates the amount of latency
	// that a player experiences when connected to AWS Regions. If this property is
	// present, FlexMatch considers placing the match only in Regions for which latency
	// is reported. If a matchmaker has a rule that evaluates player latency, players
	// must report latency in order to be matched. If no latency is reported in this
	// scenario, FlexMatch assumes that no Regions are available to the player and the
	// ticket is not matchable.
	LatencyInMs map[string]int32

	// A collection of key:value pairs containing player information for use in
	// matchmaking. Player attribute keys must match the playerAttributes used in a
	// matchmaking rule set. Example: "PlayerAttributes": {"skill": {"N": "23"},
	// "gameMode": {"S": "deathmatch"}}.
	PlayerAttributes map[string]AttributeValue

	// A unique identifier for a player
	PlayerId *string

	// Name of the team that the player is assigned to in a match. Team names are
	// defined in a matchmaking rule set.
	Team *string

	noSmithyDocumentSerde
}

// Regional latency information for a player, used when requesting a new game
// session with StartGameSessionPlacement. This value indicates the amount of time
// lag that exists when the player is connected to a fleet in the specified Region.
// The relative difference between a player's latency values for multiple Regions
// are used to determine which fleets are best suited to place a new game session
// for the player.
type PlayerLatency struct {

	// Amount of time that represents the time lag experienced by the player when
	// connected to the specified Region.
	LatencyInMilliseconds float32

	// A unique identifier for a player associated with the latency data.
	PlayerId *string

	// Name of the Region that is associated with the latency value.
	RegionIdentifier *string

	noSmithyDocumentSerde
}

// Sets a latency cap for individual players when placing a game session. With a
// latency policy in force, a game session cannot be placed in a fleet location
// where a player reports latency higher than the cap. Latency policies are used
// only with placement request that provide player latency information. Player
// latency policies can be stacked to gradually relax latency requirements over
// time. Latency policies are part of a GameSessionQueue.
type PlayerLatencyPolicy struct {

	// The maximum latency value that is allowed for any player, in milliseconds. All
	// policies must have a value set for this property.
	MaximumIndividualPlayerLatencyMilliseconds *int32

	// The length of time, in seconds, that the policy is enforced while placing a new
	// game session. A null value for this property means that the policy is enforced
	// until the queue times out.
	PolicyDurationSeconds *int32

	noSmithyDocumentSerde
}

// Represents a player session. Player sessions are created either for a specific
// game session, or as part of a game session placement or matchmaking request. A
// player session can represents a reserved player slot in a game session (when
// status is RESERVED) or actual player activity in a game session (when status is
// ACTIVE). A player session object, including player data, is automatically passed
// to a game session when the player connects to the game session and is validated.
// After the game session ends, player sessions information is retained for 30 days
// and then removed. Related actions CreatePlayerSession | CreatePlayerSessions |
// DescribePlayerSessions | StartGameSessionPlacement |
// DescribeGameSessionPlacement | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type PlayerSession struct {

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// The DNS identifier assigned to the instance that is running the game session.
	// Values have the following format:
	//
	// * TLS-enabled fleets:
	// ..amazongamelift.com.
	//
	// * Non-TLS-enabled fleets: ec2-.compute.amazonaws.com.
	// (See Amazon EC2 Instance IP Addressing
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)
	//
	// When
	// connecting to a game session that is running on a TLS-enabled fleet, you must
	// use the DNS name, not the IP address.
	DnsName *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift fleet that the player's game session is running on.
	FleetArn *string

	// A unique identifier for the fleet that the player's game session is running on.
	FleetId *string

	// A unique identifier for the game session that the player session is connected
	// to.
	GameSessionId *string

	// The IP address of the game session. To connect to a GameLift game server, an app
	// needs both the IP address and port number.
	IpAddress *string

	// Developer-defined information related to a player. GameLift does not use this
	// data, so it can be formatted as needed for use in the game.
	PlayerData *string

	// A unique identifier for a player that is associated with this player session.
	PlayerId *string

	// A unique identifier for a player session.
	PlayerSessionId *string

	// Port number for the game session. To connect to a Amazon GameLift server
	// process, an app needs both the IP address and port number.
	Port *int32

	// Current status of the player session. Possible player session statuses include
	// the following:
	//
	// * RESERVED -- The player session request has been received, but
	// the player has not yet connected to the server process and/or been validated.
	//
	// *
	// ACTIVE -- The player has been validated by the server process and is currently
	// connected.
	//
	// * COMPLETED -- The player connection has been dropped.
	//
	// * TIMEDOUT
	// -- A player session request was received, but the player did not connect and/or
	// was not validated within the timeout limit (60 seconds).
	Status PlayerSessionStatus

	// A time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time

	noSmithyDocumentSerde
}

// Custom prioritization settings for use by a game session queue when placing new
// game sessions with available game servers. When defined, this configuration
// replaces the default FleetIQ prioritization process, which is as follows:
//
// * If
// player latency data is included in a game session request, destinations and
// locations are prioritized first based on lowest average latency (1), then on
// lowest hosting cost (2), then on destination list order (3), and finally on
// location (alphabetical) (4). This approach ensures that the queue's top priority
// is to place game sessions where average player latency is lowest, and--if
// latency is the same--where the hosting cost is less, etc.
//
// * If player latency
// data is not included, destinations and locations are prioritized first on
// destination list order (1), and then on location (alphabetical) (2). This
// approach ensures that the queue's top priority is to place game sessions on the
// first destination fleet listed. If that fleet has multiple locations, the game
// session is placed on the first location (when listed alphabetically).
//
// Changing
// the priority order will affect how game sessions are placed. Priority
// configurations are part of a GameSessionQueue.
type PriorityConfiguration struct {

	// The prioritization order to use for fleet locations, when the PriorityOrder
	// property includes LOCATION. Locations are identified by AWS Region codes such as
	// us-west-2. Each location can only be listed once.
	LocationOrder []string

	// The recommended sequence to use when prioritizing where to place new game
	// sessions. Each type can only be listed once.
	//
	// * LATENCY -- FleetIQ prioritizes
	// locations where the average player latency (provided in each game session
	// request) is lowest.
	//
	// * COST -- FleetIQ prioritizes destinations with the lowest
	// current hosting costs. Cost is evaluated based on the location, instance type,
	// and fleet type (Spot or On-Demand) for each destination in the queue.
	//
	// *
	// DESTINATION -- FleetIQ prioritizes based on the order that destinations are
	// listed in the queue configuration.
	//
	// * LOCATION -- FleetIQ prioritizes based on
	// the provided order of locations, as defined in LocationOrder.
	PriorityOrder []PriorityType

	noSmithyDocumentSerde
}

// A policy that puts limits on the number of game sessions that a player can
// create within a specified span of time. With this policy, you can control
// players' ability to consume available resources. The policy is evaluated when a
// player tries to create a new game session. On receiving a CreateGameSession
// request, GameLift checks that the player (identified by CreatorId) has created
// fewer than game session limit in the specified time period. The resource
// creation limit policy is included in FleetAttributes.
type ResourceCreationLimitPolicy struct {

	// The maximum number of game sessions that an individual can create during the
	// policy period.
	NewGameSessionsPerCreator *int32

	// The time span used in evaluating the resource creation limit policy.
	PolicyPeriodInMinutes *int32

	noSmithyDocumentSerde
}

// The routing configuration for a fleet alias. Related actions CreateAlias |
// ListAliases | DescribeAlias | UpdateAlias | DeleteAlias | ResolveAlias | All
// APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type RoutingStrategy struct {

	// A unique identifier for the fleet that the alias points to. This value is the
	// fleet ID, not the fleet ARN.
	FleetId *string

	// The message text to be used with a terminal routing strategy.
	Message *string

	// The type of routing strategy for the alias. Possible routing types include the
	// following:
	//
	// * SIMPLE - The alias resolves to one specific fleet. Use this type
	// when routing to active fleets.
	//
	// * TERMINAL - The alias does not resolve to a
	// fleet but instead can be used to display a message to the user. A terminal alias
	// throws a TerminalRoutingStrategyException with the RoutingStrategy message
	// embedded.
	Type RoutingStrategyType

	noSmithyDocumentSerde
}

// A collection of server process configurations that describe the set of processes
// to run on each instance in a fleet. Server processes run either an executable in
// a custom game build or a Realtime Servers script. GameLift launches the
// configured processes, manages their life cycle, and replaces them as needed.
// Each instance checks regularly for an updated runtime configuration. A GameLift
// instance is limited to 50 processes running concurrently. To calculate the total
// number of processes in a runtime configuration, add the values of the
// ConcurrentExecutions parameter for each ServerProcess. Learn more about  Running
// Multiple Processes on a Fleet
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html).
// Related actions DescribeRuntimeConfiguration | UpdateRuntimeConfiguration
type RuntimeConfiguration struct {

	// The maximum amount of time (in seconds) allowed to launch a new game session and
	// have it report ready to host players. During this time, the game session is in
	// status ACTIVATING. If the game session does not become active before the
	// timeout, it is ended and the game session status is changed to TERMINATED.
	GameSessionActivationTimeoutSeconds *int32

	// The number of game sessions in status ACTIVATING to allow on an instance. This
	// setting limits the instance resources that can be used for new game activations
	// at any one time.
	MaxConcurrentGameSessionActivations *int32

	// A collection of server process configurations that identify what server
	// processes to run on each instance in a fleet.
	ServerProcesses []ServerProcess

	noSmithyDocumentSerde
}

// The location in Amazon S3 where build or script files are stored for access by
// Amazon GameLift. This location is specified in CreateBuild, CreateScript, and
// UpdateScript requests.
type S3Location struct {

	// An Amazon S3 bucket identifier. This is the name of the S3 bucket. GameLift
	// currently does not support uploading from Amazon S3 buckets with names that
	// contain a dot (.).
	Bucket *string

	// The name of the zip file that contains the build files or script files.
	Key *string

	// The version of the file, if object versioning is turned on for the bucket.
	// Amazon GameLift uses this information when retrieving files from an S3 bucket
	// that you own. Use this parameter to specify a specific version of the file. If
	// not set, the latest version of the file is retrieved.
	ObjectVersion *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) for an IAM
	// role that allows Amazon GameLift to access the S3 bucket.
	RoleArn *string

	noSmithyDocumentSerde
}

// Rule that controls how a fleet is scaled. Scaling policies are uniquely
// identified by the combination of name and fleet ID. Related actions
// DescribeFleetCapacity | UpdateFleetCapacity | DescribeEC2InstanceLimits |
// PutScalingPolicy | DescribeScalingPolicies | DeleteScalingPolicy |
// StopFleetActions | StartFleetActions | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type ScalingPolicy struct {

	// Comparison operator to use when measuring a metric against the threshold value.
	ComparisonOperator ComparisonOperatorType

	// Length of time (in minutes) the metric must be at or beyond the threshold before
	// a scaling event is triggered.
	EvaluationPeriods *int32

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift fleet resource and uniquely identifies it. ARNs are
	// unique across all Regions. Format is
	// arn:aws:gamelift:::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	FleetArn *string

	// A unique identifier for the fleet that is associated with this scaling policy.
	FleetId *string

	//
	Location *string

	// Name of the Amazon GameLift-defined metric that is used to trigger a scaling
	// adjustment. For detailed descriptions of fleet metrics, see Monitor Amazon
	// GameLift with Amazon CloudWatch
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html).
	//
	// *
	// ActivatingGameSessions -- Game sessions in the process of being created.
	//
	// *
	// ActiveGameSessions -- Game sessions that are currently running.
	//
	// *
	// ActiveInstances -- Fleet instances that are currently running at least one game
	// session.
	//
	// * AvailableGameSessions -- Additional game sessions that fleet could
	// host simultaneously, given current capacity.
	//
	// * AvailablePlayerSessions -- Empty
	// player slots in currently active game sessions. This includes game sessions that
	// are not currently accepting players. Reserved player slots are not included.
	//
	// *
	// CurrentPlayerSessions -- Player slots in active game sessions that are being
	// used by a player or are reserved for a player.
	//
	// * IdleInstances -- Active
	// instances that are currently hosting zero game sessions.
	//
	// *
	// PercentAvailableGameSessions -- Unused percentage of the total number of game
	// sessions that a fleet could host simultaneously, given current capacity. Use
	// this metric for a target-based scaling policy.
	//
	// * PercentIdleInstances --
	// Percentage of the total number of active instances that are hosting zero game
	// sessions.
	//
	// * QueueDepth -- Pending game session placement requests, in any
	// queue, where the current fleet is the top-priority destination.
	//
	// * WaitTime --
	// Current wait time for pending game session placement requests, in any queue,
	// where the current fleet is the top-priority destination.
	MetricName MetricName

	// A descriptive label that is associated with a fleet's scaling policy. Policy
	// names do not need to be unique.
	Name *string

	// The type of scaling policy to create. For a target-based policy, set the
	// parameter MetricName to 'PercentAvailableGameSessions' and specify a
	// TargetConfiguration. For a rule-based policy set the following parameters:
	// MetricName, ComparisonOperator, Threshold, EvaluationPeriods,
	// ScalingAdjustmentType, and ScalingAdjustment.
	PolicyType PolicyType

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment int32

	// The type of adjustment to make to a fleet's instance count (see
	// FleetCapacity):
	//
	// * ChangeInCapacity -- add (or subtract) the scaling adjustment
	// value from the current instance count. Positive values scale up while negative
	// values scale down.
	//
	// * ExactCapacity -- set the instance count to the scaling
	// adjustment value.
	//
	// * PercentChangeInCapacity -- increase or reduce the current
	// instance count by the scaling adjustment, read as a percentage. Positive values
	// scale up while negative values scale down.
	ScalingAdjustmentType ScalingAdjustmentType

	// Current status of the scaling policy. The scaling policy can be in force only
	// when in an ACTIVE status. Scaling policies can be suspended for individual
	// fleets (see StopFleetActions; if suspended for a fleet, the policy status does
	// not change. View a fleet's stopped actions by calling DescribeFleetCapacity.
	//
	// *
	// ACTIVE -- The scaling policy can be used for auto-scaling a fleet.
	//
	// *
	// UPDATE_REQUESTED -- A request to update the scaling policy has been received.
	//
	// *
	// UPDATING -- A change is being made to the scaling policy.
	//
	// * DELETE_REQUESTED --
	// A request to delete the scaling policy has been received.
	//
	// * DELETING -- The
	// scaling policy is being deleted.
	//
	// * DELETED -- The scaling policy has been
	// deleted.
	//
	// * ERROR -- An error occurred in creating the policy. It should be
	// removed and recreated.
	Status ScalingStatusType

	// An object that contains settings for a target-based scaling policy.
	TargetConfiguration *TargetConfiguration

	// Metric value used to trigger a scaling event.
	Threshold float64

	// The current status of the fleet's scaling policies in a requested fleet
	// location. The status PENDING_UPDATE indicates that an update was requested for
	// the fleet but has not yet been completed for the location.
	UpdateStatus LocationUpdateStatus

	noSmithyDocumentSerde
}

// Properties describing a Realtime script. Related actions CreateScript |
// ListScripts | DescribeScript | UpdateScript | DeleteScript | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type Script struct {

	// A time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// A descriptive label that is associated with a script. Script names do not need
	// to be unique.
	Name *string

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) that is
	// assigned to a GameLift script resource and uniquely identifies it. ARNs are
	// unique across all Regions. In a GameLift script ARN, the resource ID matches the
	// ScriptId value.
	ScriptArn *string

	// A unique identifier for the Realtime script
	ScriptId *string

	// The file size of the uploaded Realtime script, expressed in bytes. When files
	// are uploaded from an S3 location, this value remains at "0".
	SizeOnDisk *int64

	// The location in Amazon S3 where build or script files are stored for access by
	// Amazon GameLift. This location is specified in CreateBuild, CreateScript, and
	// UpdateScript requests.
	StorageLocation *S3Location

	// Version information that is associated with a build or script. Version strings
	// do not need to be unique.
	Version *string

	noSmithyDocumentSerde
}

// A set of instructions for launching server processes on each instance in a
// fleet. Server processes run either an executable in a custom game build or a
// Realtime Servers script. Server process configurations are part of a fleet's
// RuntimeConfiguration.
type ServerProcess struct {

	// The number of server processes using this configuration that run concurrently on
	// each instance.
	//
	// This member is required.
	ConcurrentExecutions *int32

	// The location of a game build executable or the Realtime script file that
	// contains the Init() function. Game builds and Realtime scripts are installed on
	// instances at the root:
	//
	// * Windows (custom game builds only): C:\game. Example:
	// "C:\game\MyGame\server.exe"
	//
	// * Linux: /local/game. Examples:
	// "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
	//
	// This member is required.
	LaunchPath *string

	// An optional list of parameters to pass to the server executable or Realtime
	// script on launch.
	Parameters *string

	noSmithyDocumentSerde
}

// A label that can be assigned to a GameLift resource. Learn more Tagging AWS
// Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in
// the AWS General Reference  AWS Tagging Strategies
// (http://aws.amazon.com/answers/account-management/aws-tagging-strategies/)
// Related actions TagResource | UntagResource | ListTagsForResource | All APIs by
// task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type Tag struct {

	// The key for a developer-defined key:value pair for tagging an AWS resource.
	//
	// This member is required.
	Key *string

	// The value for a developer-defined key:value pair for tagging an AWS resource.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Settings for a target-based scaling policy (see ScalingPolicy. A target-based
// policy tracks a particular fleet metric specifies a target value for the metric.
// As player usage changes, the policy triggers Amazon GameLift to adjust capacity
// so that the metric returns to the target value. The target configuration
// specifies settings as needed for the target based policy, including the target
// value. Related actions DescribeFleetCapacity | UpdateFleetCapacity |
// DescribeEC2InstanceLimits | PutScalingPolicy | DescribeScalingPolicies |
// DeleteScalingPolicy | StopFleetActions | StartFleetActions | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type TargetConfiguration struct {

	// Desired value to use with a target-based scaling policy. The value must be
	// relevant for whatever metric the scaling policy is using. For example, in a
	// policy using the metric PercentAvailableGameSessions, the target value should be
	// the preferred size of the fleet's buffer (the percent of capacity that should be
	// idle and ready for new game sessions).
	//
	// This member is required.
	TargetValue float64

	noSmithyDocumentSerde
}

// This data type is used with the GameLift FleetIQ and game server groups.
// Settings for a target-based scaling policy as part of a
// GameServerGroupAutoScalingPolicy. These settings are used to create a
// target-based policy that tracks the GameLift FleetIQ metric
// "PercentUtilizedGameServers" and specifies a target value for the metric. As
// player usage changes, the policy triggers to adjust the game server group
// capacity so that the metric returns to the target value.
type TargetTrackingConfiguration struct {

	// Desired value to use with a game server group target-based scaling policy.
	//
	// This member is required.
	TargetValue *float64

	noSmithyDocumentSerde
}

// Represents an authorization for a VPC peering connection between the VPC for an
// Amazon GameLift fleet and another VPC on an account you have access to. This
// authorization must exist and be valid for the peering connection to be
// established. Authorizations are valid for 24 hours after they are issued.
// Related actions CreateVpcPeeringAuthorization | DescribeVpcPeeringAuthorizations
// | DeleteVpcPeeringAuthorization | CreateVpcPeeringConnection |
// DescribeVpcPeeringConnections | DeleteVpcPeeringConnection | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type VpcPeeringAuthorization struct {

	// Time stamp indicating when this authorization was issued. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time

	// Time stamp indicating when this authorization expires (24 hours after issuance).
	// Format is a number expressed in Unix time as milliseconds (for example
	// "1469498468.057").
	ExpirationTime *time.Time

	// A unique identifier for the AWS account that you use to manage your GameLift
	// fleet. You can find your Account ID in the AWS Management Console under account
	// settings.
	GameLiftAwsAccountId *string

	//
	PeerVpcAwsAccountId *string

	// A unique identifier for a VPC with resources to be accessed by your GameLift
	// fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID,
	// use the VPC Dashboard (https://console.aws.amazon.com/vpc/) in the AWS
	// Management Console. Learn more about VPC peering in VPC Peering with GameLift
	// Fleets
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	PeerVpcId *string

	noSmithyDocumentSerde
}

// Represents a peering connection between a VPC on one of your AWS accounts and
// the VPC for your Amazon GameLift fleets. This record may be for an active
// peering connection or a pending connection that has not yet been established.
// Related actions CreateVpcPeeringAuthorization | DescribeVpcPeeringAuthorizations
// | DeleteVpcPeeringAuthorization | CreateVpcPeeringConnection |
// DescribeVpcPeeringConnections | DeleteVpcPeeringConnection | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
type VpcPeeringConnection struct {

	// The Amazon Resource Name (ARN
	// (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html)) associated
	// with the GameLift fleet resource for this connection.
	FleetArn *string

	// A unique identifier for the fleet. This ID determines the ID of the Amazon
	// GameLift VPC for your fleet.
	FleetId *string

	// A unique identifier for the VPC that contains the Amazon GameLift fleet for this
	// connection. This VPC is managed by Amazon GameLift and does not appear in your
	// AWS account.
	GameLiftVpcId *string

	// CIDR block of IPv4 addresses assigned to the VPC peering connection for the
	// GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with it;
	// these blocks cannot overlap or the peering connection cannot be created.
	IpV4CidrBlock *string

	// A unique identifier for a VPC with resources to be accessed by your GameLift
	// fleet. The VPC must be in the same Region as your fleet. To look up a VPC ID,
	// use the VPC Dashboard (https://console.aws.amazon.com/vpc/) in the AWS
	// Management Console. Learn more about VPC peering in VPC Peering with GameLift
	// Fleets
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	PeerVpcId *string

	// The status information about the connection. Status indicates if a connection is
	// pending, successful, or failed.
	Status *VpcPeeringConnectionStatus

	// A unique identifier that is automatically assigned to the connection record.
	// This ID is referenced in VPC peering connection events, and is used when
	// deleting a connection with DeleteVpcPeeringConnection.
	VpcPeeringConnectionId *string

	noSmithyDocumentSerde
}

// Represents status information for a VPC peering connection. Status is associated
// with a VpcPeeringConnection object. Status codes and messages are provided from
// EC2 (see VpcPeeringConnectionStateReason
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpcPeeringConnectionStateReason.html)).
// Connection status information is also communicated as a fleet Event.
type VpcPeeringConnectionStatus struct {

	// Code indicating the status of a VPC peering connection.
	Code *string

	// Additional messaging associated with the connection status.
	Message *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
