// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Marks an extension or extension version as DEPRECATED in the CloudFormation
// registry, removing it from active use. Deprecated extensions or extension
// versions cannot be used in CloudFormation operations. To deregister an entire
// extension, you must individually deregister all active versions of that
// extension. If an extension has only a single active version, deregistering that
// version results in the extension itself being deregistered and marked as
// deprecated in the registry. You cannot deregister the default version of an
// extension if there are other active version of that extension. If you do
// deregister the default version of an extension, the textensionype itself is
// deregistered as well and marked as deprecated. To view the deprecation status of
// an extension or extension version, use DescribeType
// (https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html).
func (c *Client) DeregisterType(ctx context.Context, params *DeregisterTypeInput, optFns ...func(*Options)) (*DeregisterTypeOutput, error) {
	if params == nil {
		params = &DeregisterTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeregisterType", params, optFns, c.addOperationDeregisterTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeregisterTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeregisterTypeInput struct {

	// The Amazon Resource Name (ARN) of the extension. Conditional: You must specify
	// either TypeName and Type, or Arn.
	Arn *string

	// The kind of extension. Conditional: You must specify either TypeName and Type,
	// or Arn.
	Type types.RegistryType

	// The name of the extension. Conditional: You must specify either TypeName and
	// Type, or Arn.
	TypeName *string

	// The ID of a specific version of the extension. The version ID is the value at
	// the end of the Amazon Resource Name (ARN) assigned to the extension version when
	// it is registered.
	VersionId *string

	noSmithyDocumentSerde
}

type DeregisterTypeOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeregisterTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDeregisterType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDeregisterType{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeregisterType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeregisterType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "cloudformation",
		OperationName: "DeregisterType",
	}
}
