// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCancelJob struct {
}

func (*awsRestjson1_serializeOpCancelJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/canceljob")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCancelJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelJobInput(v *CancelJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCancelJobInput(v *CancelJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	return nil
}

type awsRestjson1_serializeOpCreateComputeEnvironment struct {
}

func (*awsRestjson1_serializeOpCreateComputeEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateComputeEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateComputeEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/createcomputeenvironment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateComputeEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateComputeEnvironmentInput(v *CreateComputeEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateComputeEnvironmentInput(v *CreateComputeEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironmentName != nil {
		ok := object.Key("computeEnvironmentName")
		ok.String(*v.ComputeEnvironmentName)
	}

	if v.ComputeResources != nil {
		ok := object.Key("computeResources")
		if err := awsRestjson1_serializeDocumentComputeResource(v.ComputeResources, ok); err != nil {
			return err
		}
	}

	if v.ServiceRole != nil {
		ok := object.Key("serviceRole")
		ok.String(*v.ServiceRole)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagrisTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateJobQueue struct {
}

func (*awsRestjson1_serializeOpCreateJobQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJobQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/createjobqueue")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobQueueInput(v *CreateJobQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobQueueInput(v *CreateJobQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironmentOrder != nil {
		ok := object.Key("computeEnvironmentOrder")
		if err := awsRestjson1_serializeDocumentComputeEnvironmentOrders(v.ComputeEnvironmentOrder, ok); err != nil {
			return err
		}
	}

	if v.JobQueueName != nil {
		ok := object.Key("jobQueueName")
		ok.String(*v.JobQueueName)
	}

	{
		ok := object.Key("priority")
		ok.Integer(v.Priority)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagrisTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteComputeEnvironment struct {
}

func (*awsRestjson1_serializeOpDeleteComputeEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteComputeEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteComputeEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/deletecomputeenvironment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteComputeEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteComputeEnvironmentInput(v *DeleteComputeEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteComputeEnvironmentInput(v *DeleteComputeEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironment != nil {
		ok := object.Key("computeEnvironment")
		ok.String(*v.ComputeEnvironment)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteJobQueue struct {
}

func (*awsRestjson1_serializeOpDeleteJobQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteJobQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/deletejobqueue")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteJobQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteJobQueueInput(v *DeleteJobQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteJobQueueInput(v *DeleteJobQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobQueue != nil {
		ok := object.Key("jobQueue")
		ok.String(*v.JobQueue)
	}

	return nil
}

type awsRestjson1_serializeOpDeregisterJobDefinition struct {
}

func (*awsRestjson1_serializeOpDeregisterJobDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeregisterJobDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterJobDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/deregisterjobdefinition")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeregisterJobDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeregisterJobDefinitionInput(v *DeregisterJobDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeregisterJobDefinitionInput(v *DeregisterJobDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobDefinition != nil {
		ok := object.Key("jobDefinition")
		ok.String(*v.JobDefinition)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeComputeEnvironments struct {
}

func (*awsRestjson1_serializeOpDescribeComputeEnvironments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeComputeEnvironments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeComputeEnvironmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/describecomputeenvironments")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeComputeEnvironmentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeComputeEnvironmentsInput(v *DescribeComputeEnvironmentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeComputeEnvironmentsInput(v *DescribeComputeEnvironmentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironments != nil {
		ok := object.Key("computeEnvironments")
		if err := awsRestjson1_serializeDocumentStringList(v.ComputeEnvironments, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("maxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJobDefinitions struct {
}

func (*awsRestjson1_serializeOpDescribeJobDefinitions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJobDefinitions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobDefinitionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/describejobdefinitions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeJobDefinitionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobDefinitionsInput(v *DescribeJobDefinitionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeJobDefinitionsInput(v *DescribeJobDefinitionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobDefinitionName != nil {
		ok := object.Key("jobDefinitionName")
		ok.String(*v.JobDefinitionName)
	}

	if v.JobDefinitions != nil {
		ok := object.Key("jobDefinitions")
		if err := awsRestjson1_serializeDocumentStringList(v.JobDefinitions, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("maxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.Status != nil {
		ok := object.Key("status")
		ok.String(*v.Status)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJobQueues struct {
}

func (*awsRestjson1_serializeOpDescribeJobQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJobQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/describejobqueues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeJobQueuesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobQueuesInput(v *DescribeJobQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeJobQueuesInput(v *DescribeJobQueuesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobQueues != nil {
		ok := object.Key("jobQueues")
		if err := awsRestjson1_serializeDocumentStringList(v.JobQueues, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		ok := object.Key("maxResults")
		ok.Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeJobs struct {
}

func (*awsRestjson1_serializeOpDescribeJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/describejobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeJobsInput(v *DescribeJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeJobsInput(v *DescribeJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Jobs != nil {
		ok := object.Key("jobs")
		if err := awsRestjson1_serializeDocumentStringList(v.Jobs, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobs struct {
}

func (*awsRestjson1_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/listjobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsInput(v *ListJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListJobsInput(v *ListJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArrayJobId != nil {
		ok := object.Key("arrayJobId")
		ok.String(*v.ArrayJobId)
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentListJobsFilterList(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.JobQueue != nil {
		ok := object.Key("jobQueue")
		ok.String(*v.JobQueue)
	}

	if len(v.JobStatus) > 0 {
		ok := object.Key("jobStatus")
		ok.String(string(v.JobStatus))
	}

	if v.MaxResults != 0 {
		ok := object.Key("maxResults")
		ok.Integer(v.MaxResults)
	}

	if v.MultiNodeJobId != nil {
		ok := object.Key("multiNodeJobId")
		ok.String(*v.MultiNodeJobId)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRegisterJobDefinition struct {
}

func (*awsRestjson1_serializeOpRegisterJobDefinition) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterJobDefinition) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterJobDefinitionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/registerjobdefinition")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterJobDefinitionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterJobDefinitionInput(v *RegisterJobDefinitionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterJobDefinitionInput(v *RegisterJobDefinitionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerProperties != nil {
		ok := object.Key("containerProperties")
		if err := awsRestjson1_serializeDocumentContainerProperties(v.ContainerProperties, ok); err != nil {
			return err
		}
	}

	if v.JobDefinitionName != nil {
		ok := object.Key("jobDefinitionName")
		ok.String(*v.JobDefinitionName)
	}

	if v.NodeProperties != nil {
		ok := object.Key("nodeProperties")
		if err := awsRestjson1_serializeDocumentNodeProperties(v.NodeProperties, ok); err != nil {
			return err
		}
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.PlatformCapabilities != nil {
		ok := object.Key("platformCapabilities")
		if err := awsRestjson1_serializeDocumentPlatformCapabilityList(v.PlatformCapabilities, ok); err != nil {
			return err
		}
	}

	if v.PropagateTags {
		ok := object.Key("propagateTags")
		ok.Boolean(v.PropagateTags)
	}

	if v.RetryStrategy != nil {
		ok := object.Key("retryStrategy")
		if err := awsRestjson1_serializeDocumentRetryStrategy(v.RetryStrategy, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagrisTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		if err := awsRestjson1_serializeDocumentJobTimeout(v.Timeout, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpSubmitJob struct {
}

func (*awsRestjson1_serializeOpSubmitJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSubmitJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SubmitJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/submitjob")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSubmitJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSubmitJobInput(v *SubmitJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSubmitJobInput(v *SubmitJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ArrayProperties != nil {
		ok := object.Key("arrayProperties")
		if err := awsRestjson1_serializeDocumentArrayProperties(v.ArrayProperties, ok); err != nil {
			return err
		}
	}

	if v.ContainerOverrides != nil {
		ok := object.Key("containerOverrides")
		if err := awsRestjson1_serializeDocumentContainerOverrides(v.ContainerOverrides, ok); err != nil {
			return err
		}
	}

	if v.DependsOn != nil {
		ok := object.Key("dependsOn")
		if err := awsRestjson1_serializeDocumentJobDependencyList(v.DependsOn, ok); err != nil {
			return err
		}
	}

	if v.JobDefinition != nil {
		ok := object.Key("jobDefinition")
		ok.String(*v.JobDefinition)
	}

	if v.JobName != nil {
		ok := object.Key("jobName")
		ok.String(*v.JobName)
	}

	if v.JobQueue != nil {
		ok := object.Key("jobQueue")
		ok.String(*v.JobQueue)
	}

	if v.NodeOverrides != nil {
		ok := object.Key("nodeOverrides")
		if err := awsRestjson1_serializeDocumentNodeOverrides(v.NodeOverrides, ok); err != nil {
			return err
		}
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentParametersMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.PropagateTags {
		ok := object.Key("propagateTags")
		ok.Boolean(v.PropagateTags)
	}

	if v.RetryStrategy != nil {
		ok := object.Key("retryStrategy")
		if err := awsRestjson1_serializeDocumentRetryStrategy(v.RetryStrategy, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagrisTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Timeout != nil {
		ok := object.Key("timeout")
		if err := awsRestjson1_serializeDocumentJobTimeout(v.Timeout, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagrisTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTerminateJob struct {
}

func (*awsRestjson1_serializeOpTerminateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTerminateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TerminateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/terminatejob")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTerminateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTerminateJobInput(v *TerminateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTerminateJobInput(v *TerminateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if v.Reason != nil {
		ok := object.Key("reason")
		ok.String(*v.Reason)
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateComputeEnvironment struct {
}

func (*awsRestjson1_serializeOpUpdateComputeEnvironment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateComputeEnvironment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateComputeEnvironmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/updatecomputeenvironment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateComputeEnvironmentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateComputeEnvironmentInput(v *UpdateComputeEnvironmentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateComputeEnvironmentInput(v *UpdateComputeEnvironmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironment != nil {
		ok := object.Key("computeEnvironment")
		ok.String(*v.ComputeEnvironment)
	}

	if v.ComputeResources != nil {
		ok := object.Key("computeResources")
		if err := awsRestjson1_serializeDocumentComputeResourceUpdate(v.ComputeResources, ok); err != nil {
			return err
		}
	}

	if v.ServiceRole != nil {
		ok := object.Key("serviceRole")
		ok.String(*v.ServiceRole)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateJobQueue struct {
}

func (*awsRestjson1_serializeOpUpdateJobQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateJobQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/updatejobqueue")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateJobQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateJobQueueInput(v *UpdateJobQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateJobQueueInput(v *UpdateJobQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironmentOrder != nil {
		ok := object.Key("computeEnvironmentOrder")
		if err := awsRestjson1_serializeDocumentComputeEnvironmentOrders(v.ComputeEnvironmentOrder, ok); err != nil {
			return err
		}
	}

	if v.JobQueue != nil {
		ok := object.Key("jobQueue")
		ok.String(*v.JobQueue)
	}

	if v.Priority != 0 {
		ok := object.Key("priority")
		ok.Integer(v.Priority)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentArrayProperties(v *types.ArrayProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Size != 0 {
		ok := object.Key("size")
		ok.Integer(v.Size)
	}

	return nil
}

func awsRestjson1_serializeDocumentComputeEnvironmentOrder(v *types.ComputeEnvironmentOrder, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeEnvironment != nil {
		ok := object.Key("computeEnvironment")
		ok.String(*v.ComputeEnvironment)
	}

	{
		ok := object.Key("order")
		ok.Integer(v.Order)
	}

	return nil
}

func awsRestjson1_serializeDocumentComputeEnvironmentOrders(v []types.ComputeEnvironmentOrder, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComputeEnvironmentOrder(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComputeResource(v *types.ComputeResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AllocationStrategy) > 0 {
		ok := object.Key("allocationStrategy")
		ok.String(string(v.AllocationStrategy))
	}

	if v.BidPercentage != 0 {
		ok := object.Key("bidPercentage")
		ok.Integer(v.BidPercentage)
	}

	if v.DesiredvCpus != 0 {
		ok := object.Key("desiredvCpus")
		ok.Integer(v.DesiredvCpus)
	}

	if v.Ec2Configuration != nil {
		ok := object.Key("ec2Configuration")
		if err := awsRestjson1_serializeDocumentEc2ConfigurationList(v.Ec2Configuration, ok); err != nil {
			return err
		}
	}

	if v.Ec2KeyPair != nil {
		ok := object.Key("ec2KeyPair")
		ok.String(*v.Ec2KeyPair)
	}

	if v.ImageId != nil {
		ok := object.Key("imageId")
		ok.String(*v.ImageId)
	}

	if v.InstanceRole != nil {
		ok := object.Key("instanceRole")
		ok.String(*v.InstanceRole)
	}

	if v.InstanceTypes != nil {
		ok := object.Key("instanceTypes")
		if err := awsRestjson1_serializeDocumentStringList(v.InstanceTypes, ok); err != nil {
			return err
		}
	}

	if v.LaunchTemplate != nil {
		ok := object.Key("launchTemplate")
		if err := awsRestjson1_serializeDocumentLaunchTemplateSpecification(v.LaunchTemplate, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("maxvCpus")
		ok.Integer(v.MaxvCpus)
	}

	if v.MinvCpus != 0 {
		ok := object.Key("minvCpus")
		ok.Integer(v.MinvCpus)
	}

	if v.PlacementGroup != nil {
		ok := object.Key("placementGroup")
		ok.String(*v.PlacementGroup)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentStringList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SpotIamFleetRole != nil {
		ok := object.Key("spotIamFleetRole")
		ok.String(*v.SpotIamFleetRole)
	}

	if v.Subnets != nil {
		ok := object.Key("subnets")
		if err := awsRestjson1_serializeDocumentStringList(v.Subnets, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagsMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentComputeResourceUpdate(v *types.ComputeResourceUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DesiredvCpus != 0 {
		ok := object.Key("desiredvCpus")
		ok.Integer(v.DesiredvCpus)
	}

	if v.MaxvCpus != 0 {
		ok := object.Key("maxvCpus")
		ok.Integer(v.MaxvCpus)
	}

	if v.MinvCpus != 0 {
		ok := object.Key("minvCpus")
		ok.Integer(v.MinvCpus)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentStringList(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.Subnets != nil {
		ok := object.Key("subnets")
		if err := awsRestjson1_serializeDocumentStringList(v.Subnets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerOverrides(v *types.ContainerOverrides, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("command")
		if err := awsRestjson1_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Environment != nil {
		ok := object.Key("environment")
		if err := awsRestjson1_serializeDocumentEnvironmentVariables(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		ok := object.Key("instanceType")
		ok.String(*v.InstanceType)
	}

	if v.Memory != 0 {
		ok := object.Key("memory")
		ok.Integer(v.Memory)
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("resourceRequirements")
		if err := awsRestjson1_serializeDocumentResourceRequirements(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	if v.Vcpus != 0 {
		ok := object.Key("vcpus")
		ok.Integer(v.Vcpus)
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProperties(v *types.ContainerProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Command != nil {
		ok := object.Key("command")
		if err := awsRestjson1_serializeDocumentStringList(v.Command, ok); err != nil {
			return err
		}
	}

	if v.Environment != nil {
		ok := object.Key("environment")
		if err := awsRestjson1_serializeDocumentEnvironmentVariables(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("executionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.FargatePlatformConfiguration != nil {
		ok := object.Key("fargatePlatformConfiguration")
		if err := awsRestjson1_serializeDocumentFargatePlatformConfiguration(v.FargatePlatformConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Image != nil {
		ok := object.Key("image")
		ok.String(*v.Image)
	}

	if v.InstanceType != nil {
		ok := object.Key("instanceType")
		ok.String(*v.InstanceType)
	}

	if v.JobRoleArn != nil {
		ok := object.Key("jobRoleArn")
		ok.String(*v.JobRoleArn)
	}

	if v.LinuxParameters != nil {
		ok := object.Key("linuxParameters")
		if err := awsRestjson1_serializeDocumentLinuxParameters(v.LinuxParameters, ok); err != nil {
			return err
		}
	}

	if v.LogConfiguration != nil {
		ok := object.Key("logConfiguration")
		if err := awsRestjson1_serializeDocumentLogConfiguration(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Memory != 0 {
		ok := object.Key("memory")
		ok.Integer(v.Memory)
	}

	if v.MountPoints != nil {
		ok := object.Key("mountPoints")
		if err := awsRestjson1_serializeDocumentMountPoints(v.MountPoints, ok); err != nil {
			return err
		}
	}

	if v.NetworkConfiguration != nil {
		ok := object.Key("networkConfiguration")
		if err := awsRestjson1_serializeDocumentNetworkConfiguration(v.NetworkConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Privileged {
		ok := object.Key("privileged")
		ok.Boolean(v.Privileged)
	}

	if v.ReadonlyRootFilesystem {
		ok := object.Key("readonlyRootFilesystem")
		ok.Boolean(v.ReadonlyRootFilesystem)
	}

	if v.ResourceRequirements != nil {
		ok := object.Key("resourceRequirements")
		if err := awsRestjson1_serializeDocumentResourceRequirements(v.ResourceRequirements, ok); err != nil {
			return err
		}
	}

	if v.Secrets != nil {
		ok := object.Key("secrets")
		if err := awsRestjson1_serializeDocumentSecretList(v.Secrets, ok); err != nil {
			return err
		}
	}

	if v.Ulimits != nil {
		ok := object.Key("ulimits")
		if err := awsRestjson1_serializeDocumentUlimits(v.Ulimits, ok); err != nil {
			return err
		}
	}

	if v.User != nil {
		ok := object.Key("user")
		ok.String(*v.User)
	}

	if v.Vcpus != 0 {
		ok := object.Key("vcpus")
		ok.Integer(v.Vcpus)
	}

	if v.Volumes != nil {
		ok := object.Key("volumes")
		if err := awsRestjson1_serializeDocumentVolumes(v.Volumes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDevice(v *types.Device, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("containerPath")
		ok.String(*v.ContainerPath)
	}

	if v.HostPath != nil {
		ok := object.Key("hostPath")
		ok.String(*v.HostPath)
	}

	if v.Permissions != nil {
		ok := object.Key("permissions")
		if err := awsRestjson1_serializeDocumentDeviceCgroupPermissions(v.Permissions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDeviceCgroupPermissions(v []types.DeviceCgroupPermission, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDevicesList(v []types.Device, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDevice(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEc2Configuration(v *types.Ec2Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImageIdOverride != nil {
		ok := object.Key("imageIdOverride")
		ok.String(*v.ImageIdOverride)
	}

	if v.ImageType != nil {
		ok := object.Key("imageType")
		ok.String(*v.ImageType)
	}

	return nil
}

func awsRestjson1_serializeDocumentEc2ConfigurationList(v []types.Ec2Configuration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEc2Configuration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEFSAuthorizationConfig(v *types.EFSAuthorizationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessPointId != nil {
		ok := object.Key("accessPointId")
		ok.String(*v.AccessPointId)
	}

	if len(v.Iam) > 0 {
		ok := object.Key("iam")
		ok.String(string(v.Iam))
	}

	return nil
}

func awsRestjson1_serializeDocumentEFSVolumeConfiguration(v *types.EFSVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationConfig != nil {
		ok := object.Key("authorizationConfig")
		if err := awsRestjson1_serializeDocumentEFSAuthorizationConfig(v.AuthorizationConfig, ok); err != nil {
			return err
		}
	}

	if v.FileSystemId != nil {
		ok := object.Key("fileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.RootDirectory != nil {
		ok := object.Key("rootDirectory")
		ok.String(*v.RootDirectory)
	}

	if len(v.TransitEncryption) > 0 {
		ok := object.Key("transitEncryption")
		ok.String(string(v.TransitEncryption))
	}

	if v.TransitEncryptionPort != 0 {
		ok := object.Key("transitEncryptionPort")
		ok.Integer(v.TransitEncryptionPort)
	}

	return nil
}

func awsRestjson1_serializeDocumentEnvironmentVariables(v []types.KeyValuePair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentKeyValuePair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEvaluateOnExit(v *types.EvaluateOnExit, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("action")
		ok.String(string(v.Action))
	}

	if v.OnExitCode != nil {
		ok := object.Key("onExitCode")
		ok.String(*v.OnExitCode)
	}

	if v.OnReason != nil {
		ok := object.Key("onReason")
		ok.String(*v.OnReason)
	}

	if v.OnStatusReason != nil {
		ok := object.Key("onStatusReason")
		ok.String(*v.OnStatusReason)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvaluateOnExitList(v []types.EvaluateOnExit, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEvaluateOnExit(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFargatePlatformConfiguration(v *types.FargatePlatformConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PlatformVersion != nil {
		ok := object.Key("platformVersion")
		ok.String(*v.PlatformVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentHost(v *types.Host, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourcePath != nil {
		ok := object.Key("sourcePath")
		ok.String(*v.SourcePath)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobDependency(v *types.JobDependency, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("jobId")
		ok.String(*v.JobId)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentJobDependencyList(v []types.JobDependency, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentJobDependency(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentJobTimeout(v *types.JobTimeout, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttemptDurationSeconds != 0 {
		ok := object.Key("attemptDurationSeconds")
		ok.Integer(v.AttemptDurationSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyValuePair(v *types.KeyValuePair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyValuesPair(v *types.KeyValuesPair, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentStringList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLaunchTemplateSpecification(v *types.LaunchTemplateSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LaunchTemplateId != nil {
		ok := object.Key("launchTemplateId")
		ok.String(*v.LaunchTemplateId)
	}

	if v.LaunchTemplateName != nil {
		ok := object.Key("launchTemplateName")
		ok.String(*v.LaunchTemplateName)
	}

	if v.Version != nil {
		ok := object.Key("version")
		ok.String(*v.Version)
	}

	return nil
}

func awsRestjson1_serializeDocumentLinuxParameters(v *types.LinuxParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Devices != nil {
		ok := object.Key("devices")
		if err := awsRestjson1_serializeDocumentDevicesList(v.Devices, ok); err != nil {
			return err
		}
	}

	if v.InitProcessEnabled {
		ok := object.Key("initProcessEnabled")
		ok.Boolean(v.InitProcessEnabled)
	}

	if v.MaxSwap != 0 {
		ok := object.Key("maxSwap")
		ok.Integer(v.MaxSwap)
	}

	if v.SharedMemorySize != 0 {
		ok := object.Key("sharedMemorySize")
		ok.Integer(v.SharedMemorySize)
	}

	if v.Swappiness != 0 {
		ok := object.Key("swappiness")
		ok.Integer(v.Swappiness)
	}

	if v.Tmpfs != nil {
		ok := object.Key("tmpfs")
		if err := awsRestjson1_serializeDocumentTmpfsList(v.Tmpfs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentListJobsFilterList(v []types.KeyValuesPair, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentKeyValuesPair(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLogConfiguration(v *types.LogConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogDriver) > 0 {
		ok := object.Key("logDriver")
		ok.String(string(v.LogDriver))
	}

	if v.Options != nil {
		ok := object.Key("options")
		if err := awsRestjson1_serializeDocumentLogConfigurationOptionsMap(v.Options, ok); err != nil {
			return err
		}
	}

	if v.SecretOptions != nil {
		ok := object.Key("secretOptions")
		if err := awsRestjson1_serializeDocumentSecretList(v.SecretOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLogConfigurationOptionsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentMountPoint(v *types.MountPoint, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("containerPath")
		ok.String(*v.ContainerPath)
	}

	if v.ReadOnly {
		ok := object.Key("readOnly")
		ok.Boolean(v.ReadOnly)
	}

	if v.SourceVolume != nil {
		ok := object.Key("sourceVolume")
		ok.String(*v.SourceVolume)
	}

	return nil
}

func awsRestjson1_serializeDocumentMountPoints(v []types.MountPoint, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMountPoint(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNetworkConfiguration(v *types.NetworkConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AssignPublicIp) > 0 {
		ok := object.Key("assignPublicIp")
		ok.String(string(v.AssignPublicIp))
	}

	return nil
}

func awsRestjson1_serializeDocumentNodeOverrides(v *types.NodeOverrides, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NodePropertyOverrides != nil {
		ok := object.Key("nodePropertyOverrides")
		if err := awsRestjson1_serializeDocumentNodePropertyOverrides(v.NodePropertyOverrides, ok); err != nil {
			return err
		}
	}

	if v.NumNodes != 0 {
		ok := object.Key("numNodes")
		ok.Integer(v.NumNodes)
	}

	return nil
}

func awsRestjson1_serializeDocumentNodeProperties(v *types.NodeProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("mainNode")
		ok.Integer(v.MainNode)
	}

	if v.NodeRangeProperties != nil {
		ok := object.Key("nodeRangeProperties")
		if err := awsRestjson1_serializeDocumentNodeRangeProperties(v.NodeRangeProperties, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("numNodes")
		ok.Integer(v.NumNodes)
	}

	return nil
}

func awsRestjson1_serializeDocumentNodePropertyOverride(v *types.NodePropertyOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerOverrides != nil {
		ok := object.Key("containerOverrides")
		if err := awsRestjson1_serializeDocumentContainerOverrides(v.ContainerOverrides, ok); err != nil {
			return err
		}
	}

	if v.TargetNodes != nil {
		ok := object.Key("targetNodes")
		ok.String(*v.TargetNodes)
	}

	return nil
}

func awsRestjson1_serializeDocumentNodePropertyOverrides(v []types.NodePropertyOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNodePropertyOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNodeRangeProperties(v []types.NodeRangeProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNodeRangeProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNodeRangeProperty(v *types.NodeRangeProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Container != nil {
		ok := object.Key("container")
		if err := awsRestjson1_serializeDocumentContainerProperties(v.Container, ok); err != nil {
			return err
		}
	}

	if v.TargetNodes != nil {
		ok := object.Key("targetNodes")
		ok.String(*v.TargetNodes)
	}

	return nil
}

func awsRestjson1_serializeDocumentParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentPlatformCapabilityList(v []types.PlatformCapability, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentResourceRequirement(v *types.ResourceRequirement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceRequirements(v []types.ResourceRequirement, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentResourceRequirement(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRetryStrategy(v *types.RetryStrategy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attempts != 0 {
		ok := object.Key("attempts")
		ok.Integer(v.Attempts)
	}

	if v.EvaluateOnExit != nil {
		ok := object.Key("evaluateOnExit")
		if err := awsRestjson1_serializeDocumentEvaluateOnExitList(v.EvaluateOnExit, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSecret(v *types.Secret, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ValueFrom != nil {
		ok := object.Key("valueFrom")
		ok.String(*v.ValueFrom)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecretList(v []types.Secret, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSecret(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagrisTagsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagsMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTmpfs(v *types.Tmpfs, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerPath != nil {
		ok := object.Key("containerPath")
		ok.String(*v.ContainerPath)
	}

	if v.MountOptions != nil {
		ok := object.Key("mountOptions")
		if err := awsRestjson1_serializeDocumentStringList(v.MountOptions, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("size")
		ok.Integer(v.Size)
	}

	return nil
}

func awsRestjson1_serializeDocumentTmpfsList(v []types.Tmpfs, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTmpfs(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUlimit(v *types.Ulimit, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("hardLimit")
		ok.Integer(v.HardLimit)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	{
		ok := object.Key("softLimit")
		ok.Integer(v.SoftLimit)
	}

	return nil
}

func awsRestjson1_serializeDocumentUlimits(v []types.Ulimit, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUlimit(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentVolume(v *types.Volume, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EfsVolumeConfiguration != nil {
		ok := object.Key("efsVolumeConfiguration")
		if err := awsRestjson1_serializeDocumentEFSVolumeConfiguration(v.EfsVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Host != nil {
		ok := object.Key("host")
		if err := awsRestjson1_serializeDocumentHost(v.Host, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentVolumes(v []types.Volume, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVolume(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
