// Code generated by smithy-go-codegen DO NOT EDIT.

package apprunner

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/apprunner/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Create an AWS App Runner automatic scaling configuration resource. App Runner
// requires this resource when you create App Runner services that require
// non-default auto scaling settings. You can share an auto scaling configuration
// across multiple services. Create multiple revisions of a configuration by using
// the same AutoScalingConfigurationName and different
// AutoScalingConfigurationRevision values. When you create a service, you can set
// it to use the latest active revision of an auto scaling configuration or a
// specific revision. Configure a higher MinSize to increase the spread of your App
// Runner service over more Availability Zones in the AWS Region. The tradeoff is a
// higher minimal cost. Configure a lower MaxSize to control your cost. The
// tradeoff is lower responsiveness during peak demand.
func (c *Client) CreateAutoScalingConfiguration(ctx context.Context, params *CreateAutoScalingConfigurationInput, optFns ...func(*Options)) (*CreateAutoScalingConfigurationOutput, error) {
	if params == nil {
		params = &CreateAutoScalingConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAutoScalingConfiguration", params, optFns, c.addOperationCreateAutoScalingConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAutoScalingConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAutoScalingConfigurationInput struct {

	// A name for the auto scaling configuration. When you use it for the first time in
	// an AWS Region, App Runner creates revision number 1 of this name. When you use
	// the same name in subsequent calls, App Runner creates incremental revisions of
	// the configuration.
	//
	// This member is required.
	AutoScalingConfigurationName *string

	// The maximum number of concurrent requests that you want an instance to process.
	// If the number of concurrent requests exceeds this limit, App Runner scales up
	// your service. Default: 100
	MaxConcurrency *int32

	// The maximum number of instances that your service scales up to. At most MaxSize
	// instances actively serve traffic for your service. Default: 25
	MaxSize *int32

	// The minimum number of instances that App Runner provisions for your service. The
	// service always has at least MinSize provisioned instances. Some of them actively
	// serve traffic. The rest of them (provisioned and inactive instances) are a
	// cost-effective compute capacity reserve and are ready to be quickly activated.
	// You pay for memory usage of all the provisioned instances. You pay for CPU usage
	// of only the active subset. App Runner temporarily doubles the number of
	// provisioned instances during deployments, to maintain the same capacity for both
	// old and new code. Default: 1
	MinSize *int32

	// A list of metadata items that you can associate with your auto scaling
	// configuration resource. A tag is a key-value pair.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateAutoScalingConfigurationOutput struct {

	// A description of the App Runner auto scaling configuration that's created by
	// this request.
	//
	// This member is required.
	AutoScalingConfiguration *types.AutoScalingConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAutoScalingConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateAutoScalingConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateAutoScalingConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateAutoScalingConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAutoScalingConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateAutoScalingConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "apprunner",
		OperationName: "CreateAutoScalingConfiguration",
	}
}
