// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transfer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a user and associates them with an existing file transfer
// protocol-enabled server. You can only create and associate users with servers
// that have the IdentityProviderType set to SERVICE_MANAGED. Using parameters for
// CreateUser, you can specify the user name, set the home directory, store the
// user's public key, and assign the user's Amazon Web Services Identity and Access
// Management (IAM) role. You can also optionally add a scope-down policy, and
// assign metadata with tags that can be used to group and search for users.
func (c *Client) CreateUser(ctx context.Context, params *CreateUserInput, optFns ...func(*Options)) (*CreateUserOutput, error) {
	if params == nil {
		params = &CreateUserInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateUser", params, optFns, c.addOperationCreateUserMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateUserOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateUserInput struct {

	// Specifies the Amazon Resource Name (ARN) of the IAM role that controls your
	// users' access to your Amazon S3 bucket or EFS file system. The policies attached
	// to this role determine the level of access that you want to provide your users
	// when transferring files into and out of your Amazon S3 bucket or EFS file
	// system. The IAM role should also contain a trust relationship that allows the
	// server to access your resources when servicing your users' transfer requests.
	//
	// This member is required.
	Role *string

	// A system-assigned unique identifier for a server instance. This is the specific
	// server that you added your user to.
	//
	// This member is required.
	ServerId *string

	// A unique string that identifies a user and is associated with a as specified by
	// the ServerId. This user name must be a minimum of 3 and a maximum of 100
	// characters long. The following are valid characters: a-z, A-Z, 0-9, underscore
	// '_', hyphen '-', period '.', and at sign '@'. The user name can't start with a
	// hyphen, period, or at sign.
	//
	// This member is required.
	UserName *string

	// The landing directory (folder) for a user when they log in to the server using
	// the client. A HomeDirectory example is /bucket_name/home/mydirectory.
	HomeDirectory *string

	// Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and
	// keys should be visible to your user and how you want to make them visible. You
	// must specify the Entry and Target pair, where Entry shows how the path is made
	// visible and Target is the actual Amazon S3 or Amazon EFS path. If you only
	// specify a target, it is displayed as is. You also must ensure that your Amazon
	// Web Services Identity and Access Management (IAM) role provides access to paths
	// in Target. This value can only be set when HomeDirectoryType is set to LOGICAL.
	// The following is an Entry and Target pair example. [ { "Entry":
	// "your-personal-report.pdf", "Target":
	// "/bucket3/customized-reports/${transfer:UserName}.pdf" } ] In most cases, you
	// can use this value instead of the scope-down policy to lock your user down to
	// the designated home directory ("chroot"). To do this, you can set Entry to / and
	// set Target to the HomeDirectory parameter value. The following is an Entry and
	// Target pair example for chroot. [ { "Entry:": "/", "Target":
	// "/bucket_name/home/mydirectory" } ] If the target of a logical directory entry
	// does not exist in Amazon S3 or EFS, the entry is ignored. As a workaround, you
	// can use the Amazon S3 API or EFS API to create 0 byte objects as place holders
	// for your directory. If using the CLI, use the s3api or efsapi call instead of s3
	// or efs so you can use the put-object operation. For example, you use the
	// following: aws s3api put-object --bucket bucketname --key path/to/folder/. Make
	// sure that the end of the key name ends in a / for it to be considered a folder.
	HomeDirectoryMappings []types.HomeDirectoryMapEntry

	// The type of landing directory (folder) you want your users' home directory to be
	// when they log into the server. If you set it to PATH, the user will see the
	// absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol
	// clients. If you set it LOGICAL, you will need to provide mappings in the
	// HomeDirectoryMappings for how you want to make Amazon S3 or EFS paths visible to
	// your users.
	HomeDirectoryType types.HomeDirectoryType

	// A scope-down policy for your user so that you can use the same IAM role across
	// multiple users. This policy scopes down user access to portions of their Amazon
	// S3 bucket. Variables that you can use inside this policy include
	// ${Transfer:UserName}, ${Transfer:HomeDirectory}, and ${Transfer:HomeBucket}.
	// This only applies when domain of ServerId is S3. EFS does not use scope down
	// policy. For scope-down policies, Amazon Web Services Transfer Family stores the
	// policy as a JSON blob, instead of the Amazon Resource Name (ARN) of the policy.
	// You save the policy as a JSON blob and pass it in the Policy argument. For an
	// example of a scope-down policy, see Example scope-down policy
	// (https://docs.aws.amazon.com/transfer/latest/userguide/scope-down-policy.html).
	// For more information, see AssumeRole
	// (https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRole.html) in the
	// Amazon Web Services Security Token Service API Reference.
	Policy *string

	// Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and
	// any secondary groups IDs (SecondaryGids), that controls your users' access to
	// your Amazon EFS file systems. The POSIX permissions that are set on files and
	// directories in Amazon EFS determine the level of access your users get when
	// transferring files into and out of your Amazon EFS file systems.
	PosixProfile *types.PosixProfile

	// The public portion of the Secure Shell (SSH) key used to authenticate the user
	// to the server.
	SshPublicKeyBody *string

	// Key-value pairs that can be used to group and search for users. Tags are
	// metadata attached to users for any purpose.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateUserOutput struct {

	// The ID of the server that the user is attached to.
	//
	// This member is required.
	ServerId *string

	// A unique string that identifies a user account associated with a server.
	//
	// This member is required.
	UserName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateUserMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateUser{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateUser{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateUserValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateUser(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateUser(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transfer",
		OperationName: "CreateUser",
	}
}
