// Code generated by smithy-go-codegen DO NOT EDIT.

package shield

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/shield/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Protection objects for the account.
func (c *Client) ListProtections(ctx context.Context, params *ListProtectionsInput, optFns ...func(*Options)) (*ListProtectionsOutput, error) {
	if params == nil {
		params = &ListProtectionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListProtections", params, optFns, c.addOperationListProtectionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListProtectionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListProtectionsInput struct {

	// The maximum number of Protection objects to return. If you leave this blank,
	// Shield Advanced returns the first 20 results. This is a maximum value. Shield
	// Advanced might return the results in smaller batches. That is, the number of
	// objects returned could be less than MaxResults, even if there are still more
	// objects yet to return. If there are more objects to return, Shield Advanced
	// returns a value in NextToken that you can use in your next request, to get the
	// next batch of objects.
	MaxResults *int32

	// The ListProtectionsRequest.NextToken value from a previous call to
	// ListProtections. Pass null if this is the first call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListProtectionsOutput struct {

	// If you specify a value for MaxResults and you have more Protections than the
	// value of MaxResults, Shield Advanced returns a NextToken value in the response
	// that allows you to list another group of Protections. For the second and
	// subsequent ListProtections requests, specify the value of NextToken from the
	// previous response to get information about another batch of Protections. Shield
	// Advanced might return the list of Protection objects in batches smaller than the
	// number specified by MaxResults. If there are more Protection objects to return,
	// Shield Advanced will always also return a NextToken.
	NextToken *string

	// The array of enabled Protection objects.
	Protections []types.Protection

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListProtectionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListProtections{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListProtections{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListProtections(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListProtectionsAPIClient is a client that implements the ListProtections
// operation.
type ListProtectionsAPIClient interface {
	ListProtections(context.Context, *ListProtectionsInput, ...func(*Options)) (*ListProtectionsOutput, error)
}

var _ ListProtectionsAPIClient = (*Client)(nil)

// ListProtectionsPaginatorOptions is the paginator options for ListProtections
type ListProtectionsPaginatorOptions struct {
	// The maximum number of Protection objects to return. If you leave this blank,
	// Shield Advanced returns the first 20 results. This is a maximum value. Shield
	// Advanced might return the results in smaller batches. That is, the number of
	// objects returned could be less than MaxResults, even if there are still more
	// objects yet to return. If there are more objects to return, Shield Advanced
	// returns a value in NextToken that you can use in your next request, to get the
	// next batch of objects.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListProtectionsPaginator is a paginator for ListProtections
type ListProtectionsPaginator struct {
	options   ListProtectionsPaginatorOptions
	client    ListProtectionsAPIClient
	params    *ListProtectionsInput
	nextToken *string
	firstPage bool
}

// NewListProtectionsPaginator returns a new ListProtectionsPaginator
func NewListProtectionsPaginator(client ListProtectionsAPIClient, params *ListProtectionsInput, optFns ...func(*ListProtectionsPaginatorOptions)) *ListProtectionsPaginator {
	if params == nil {
		params = &ListProtectionsInput{}
	}

	options := ListProtectionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListProtectionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListProtectionsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next ListProtections page.
func (p *ListProtectionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListProtectionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListProtections(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListProtections(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "shield",
		OperationName: "ListProtections",
	}
}
