// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptAdministratorInvitation struct {
}

func (*validateOpAcceptAdministratorInvitation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptAdministratorInvitation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptAdministratorInvitationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptAdministratorInvitationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAcceptInvitation struct {
}

func (*validateOpAcceptInvitation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptInvitation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptInvitationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptInvitationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchDisableStandards struct {
}

func (*validateOpBatchDisableStandards) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchDisableStandards) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchDisableStandardsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchDisableStandardsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchEnableStandards struct {
}

func (*validateOpBatchEnableStandards) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchEnableStandards) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchEnableStandardsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchEnableStandardsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchImportFindings struct {
}

func (*validateOpBatchImportFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchImportFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchImportFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchImportFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchUpdateFindings struct {
}

func (*validateOpBatchUpdateFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchUpdateFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchUpdateFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchUpdateFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateActionTarget struct {
}

func (*validateOpCreateActionTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateActionTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateActionTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateActionTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateInsight struct {
}

func (*validateOpCreateInsight) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateInsight) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateInsightInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateInsightInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateMembers struct {
}

func (*validateOpCreateMembers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateMembers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateMembersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateMembersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeclineInvitations struct {
}

func (*validateOpDeclineInvitations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeclineInvitations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeclineInvitationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeclineInvitationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteActionTarget struct {
}

func (*validateOpDeleteActionTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteActionTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteActionTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteActionTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInsight struct {
}

func (*validateOpDeleteInsight) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInsight) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInsightInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInsightInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInvitations struct {
}

func (*validateOpDeleteInvitations) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInvitations) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInvitationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInvitationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteMembers struct {
}

func (*validateOpDeleteMembers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteMembers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteMembersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteMembersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeStandardsControls struct {
}

func (*validateOpDescribeStandardsControls) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeStandardsControls) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeStandardsControlsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeStandardsControlsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableImportFindingsForProduct struct {
}

func (*validateOpDisableImportFindingsForProduct) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableImportFindingsForProduct) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableImportFindingsForProductInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableImportFindingsForProductInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisableOrganizationAdminAccount struct {
}

func (*validateOpDisableOrganizationAdminAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisableOrganizationAdminAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisableOrganizationAdminAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisableOrganizationAdminAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateMembers struct {
}

func (*validateOpDisassociateMembers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateMembers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateMembersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateMembersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableImportFindingsForProduct struct {
}

func (*validateOpEnableImportFindingsForProduct) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableImportFindingsForProduct) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableImportFindingsForProductInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableImportFindingsForProductInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEnableOrganizationAdminAccount struct {
}

func (*validateOpEnableOrganizationAdminAccount) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEnableOrganizationAdminAccount) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EnableOrganizationAdminAccountInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEnableOrganizationAdminAccountInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInsightResults struct {
}

func (*validateOpGetInsightResults) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInsightResults) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInsightResultsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInsightResultsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetMembers struct {
}

func (*validateOpGetMembers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetMembers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetMembersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetMembersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInviteMembers struct {
}

func (*validateOpInviteMembers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInviteMembers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InviteMembersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInviteMembersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateActionTarget struct {
}

func (*validateOpUpdateActionTarget) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateActionTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateActionTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateActionTargetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFindings struct {
}

func (*validateOpUpdateFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateInsight struct {
}

func (*validateOpUpdateInsight) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateInsight) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateInsightInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateInsightInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateOrganizationConfiguration struct {
}

func (*validateOpUpdateOrganizationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateOrganizationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateOrganizationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateOrganizationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateStandardsControl struct {
}

func (*validateOpUpdateStandardsControl) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateStandardsControl) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateStandardsControlInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateStandardsControlInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptAdministratorInvitationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptAdministratorInvitation{}, middleware.After)
}

func addOpAcceptInvitationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptInvitation{}, middleware.After)
}

func addOpBatchDisableStandardsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchDisableStandards{}, middleware.After)
}

func addOpBatchEnableStandardsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchEnableStandards{}, middleware.After)
}

func addOpBatchImportFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchImportFindings{}, middleware.After)
}

func addOpBatchUpdateFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchUpdateFindings{}, middleware.After)
}

func addOpCreateActionTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateActionTarget{}, middleware.After)
}

func addOpCreateInsightValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateInsight{}, middleware.After)
}

func addOpCreateMembersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateMembers{}, middleware.After)
}

func addOpDeclineInvitationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeclineInvitations{}, middleware.After)
}

func addOpDeleteActionTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteActionTarget{}, middleware.After)
}

func addOpDeleteInsightValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInsight{}, middleware.After)
}

func addOpDeleteInvitationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInvitations{}, middleware.After)
}

func addOpDeleteMembersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteMembers{}, middleware.After)
}

func addOpDescribeStandardsControlsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeStandardsControls{}, middleware.After)
}

func addOpDisableImportFindingsForProductValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableImportFindingsForProduct{}, middleware.After)
}

func addOpDisableOrganizationAdminAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisableOrganizationAdminAccount{}, middleware.After)
}

func addOpDisassociateMembersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateMembers{}, middleware.After)
}

func addOpEnableImportFindingsForProductValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableImportFindingsForProduct{}, middleware.After)
}

func addOpEnableOrganizationAdminAccountValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEnableOrganizationAdminAccount{}, middleware.After)
}

func addOpGetInsightResultsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInsightResults{}, middleware.After)
}

func addOpGetMembersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetMembers{}, middleware.After)
}

func addOpInviteMembersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInviteMembers{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateActionTargetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateActionTarget{}, middleware.After)
}

func addOpUpdateFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFindings{}, middleware.After)
}

func addOpUpdateInsightValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateInsight{}, middleware.After)
}

func addOpUpdateOrganizationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateOrganizationConfiguration{}, middleware.After)
}

func addOpUpdateStandardsControlValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateStandardsControl{}, middleware.After)
}

func validateAccountDetails(v *types.AccountDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccountDetails"}
	if v.AccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAccountDetailsList(v []types.AccountDetails) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AccountDetailsList"}
	for i := range v {
		if err := validateAccountDetails(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsSecurityFinding(v *types.AwsSecurityFinding) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsSecurityFinding"}
	if v.SchemaVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SchemaVersion"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.ProductArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductArn"))
	}
	if v.GeneratorId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GeneratorId"))
	}
	if v.AwsAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsAccountId"))
	}
	if v.CreatedAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CreatedAt"))
	}
	if v.UpdatedAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdatedAt"))
	}
	if v.Title == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Title"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.Malware != nil {
		if err := validateMalwareList(v.Malware); err != nil {
			invalidParams.AddNested("Malware", err.(smithy.InvalidParamsError))
		}
	}
	if v.Resources == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Resources"))
	} else if v.Resources != nil {
		if err := validateResourceList(v.Resources); err != nil {
			invalidParams.AddNested("Resources", err.(smithy.InvalidParamsError))
		}
	}
	if v.Compliance != nil {
		if err := validateCompliance(v.Compliance); err != nil {
			invalidParams.AddNested("Compliance", err.(smithy.InvalidParamsError))
		}
	}
	if v.RelatedFindings != nil {
		if err := validateRelatedFindingList(v.RelatedFindings); err != nil {
			invalidParams.AddNested("RelatedFindings", err.(smithy.InvalidParamsError))
		}
	}
	if v.Note != nil {
		if err := validateNote(v.Note); err != nil {
			invalidParams.AddNested("Note", err.(smithy.InvalidParamsError))
		}
	}
	if v.Vulnerabilities != nil {
		if err := validateVulnerabilityList(v.Vulnerabilities); err != nil {
			invalidParams.AddNested("Vulnerabilities", err.(smithy.InvalidParamsError))
		}
	}
	if v.PatchSummary != nil {
		if err := validatePatchSummary(v.PatchSummary); err != nil {
			invalidParams.AddNested("PatchSummary", err.(smithy.InvalidParamsError))
		}
	}
	if v.FindingProviderFields != nil {
		if err := validateFindingProviderFields(v.FindingProviderFields); err != nil {
			invalidParams.AddNested("FindingProviderFields", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsSecurityFindingIdentifier(v *types.AwsSecurityFindingIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsSecurityFindingIdentifier"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.ProductArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAwsSecurityFindingIdentifierList(v []types.AwsSecurityFindingIdentifier) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AwsSecurityFindingIdentifierList"}
	for i := range v {
		if err := validateAwsSecurityFindingIdentifier(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBatchImportFindingsRequestFindingList(v []types.AwsSecurityFinding) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchImportFindingsRequestFindingList"}
	for i := range v {
		if err := validateAwsSecurityFinding(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCompliance(v *types.Compliance) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Compliance"}
	if v.StatusReasons != nil {
		if err := validateStatusReasonsList(v.StatusReasons); err != nil {
			invalidParams.AddNested("StatusReasons", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFindingProviderFields(v *types.FindingProviderFields) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FindingProviderFields"}
	if v.RelatedFindings != nil {
		if err := validateRelatedFindingList(v.RelatedFindings); err != nil {
			invalidParams.AddNested("RelatedFindings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMalware(v *types.Malware) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Malware"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMalwareList(v []types.Malware) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MalwareList"}
	for i := range v {
		if err := validateMalware(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNote(v *types.Note) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Note"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if v.UpdatedBy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdatedBy"))
	}
	if v.UpdatedAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdatedAt"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNoteUpdate(v *types.NoteUpdate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NoteUpdate"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if v.UpdatedBy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpdatedBy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePatchSummary(v *types.PatchSummary) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PatchSummary"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRelatedFinding(v *types.RelatedFinding) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RelatedFinding"}
	if v.ProductArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductArn"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRelatedFindingList(v []types.RelatedFinding) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RelatedFindingList"}
	for i := range v {
		if err := validateRelatedFinding(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResource(v *types.Resource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Resource"}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResourceList(v []types.Resource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResourceList"}
	for i := range v {
		if err := validateResource(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStandardsSubscriptionRequest(v *types.StandardsSubscriptionRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StandardsSubscriptionRequest"}
	if v.StandardsArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StandardsArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStandardsSubscriptionRequests(v []types.StandardsSubscriptionRequest) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StandardsSubscriptionRequests"}
	for i := range v {
		if err := validateStandardsSubscriptionRequest(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatusReason(v *types.StatusReason) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatusReason"}
	if v.ReasonCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReasonCode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStatusReasonsList(v []types.StatusReason) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StatusReasonsList"}
	for i := range v {
		if err := validateStatusReason(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVulnerability(v *types.Vulnerability) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Vulnerability"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.Vendor != nil {
		if err := validateVulnerabilityVendor(v.Vendor); err != nil {
			invalidParams.AddNested("Vendor", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVulnerabilityList(v []types.Vulnerability) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VulnerabilityList"}
	for i := range v {
		if err := validateVulnerability(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVulnerabilityVendor(v *types.VulnerabilityVendor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VulnerabilityVendor"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptAdministratorInvitationInput(v *AcceptAdministratorInvitationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptAdministratorInvitationInput"}
	if v.AdministratorId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AdministratorId"))
	}
	if v.InvitationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvitationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptInvitationInput(v *AcceptInvitationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptInvitationInput"}
	if v.MasterId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MasterId"))
	}
	if v.InvitationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InvitationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchDisableStandardsInput(v *BatchDisableStandardsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchDisableStandardsInput"}
	if v.StandardsSubscriptionArns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StandardsSubscriptionArns"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchEnableStandardsInput(v *BatchEnableStandardsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchEnableStandardsInput"}
	if v.StandardsSubscriptionRequests == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StandardsSubscriptionRequests"))
	} else if v.StandardsSubscriptionRequests != nil {
		if err := validateStandardsSubscriptionRequests(v.StandardsSubscriptionRequests); err != nil {
			invalidParams.AddNested("StandardsSubscriptionRequests", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchImportFindingsInput(v *BatchImportFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchImportFindingsInput"}
	if v.Findings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Findings"))
	} else if v.Findings != nil {
		if err := validateBatchImportFindingsRequestFindingList(v.Findings); err != nil {
			invalidParams.AddNested("Findings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchUpdateFindingsInput(v *BatchUpdateFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchUpdateFindingsInput"}
	if v.FindingIdentifiers == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FindingIdentifiers"))
	} else if v.FindingIdentifiers != nil {
		if err := validateAwsSecurityFindingIdentifierList(v.FindingIdentifiers); err != nil {
			invalidParams.AddNested("FindingIdentifiers", err.(smithy.InvalidParamsError))
		}
	}
	if v.Note != nil {
		if err := validateNoteUpdate(v.Note); err != nil {
			invalidParams.AddNested("Note", err.(smithy.InvalidParamsError))
		}
	}
	if v.RelatedFindings != nil {
		if err := validateRelatedFindingList(v.RelatedFindings); err != nil {
			invalidParams.AddNested("RelatedFindings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateActionTargetInput(v *CreateActionTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateActionTargetInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateInsightInput(v *CreateInsightInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateInsightInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Filters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filters"))
	}
	if v.GroupByAttribute == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GroupByAttribute"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateMembersInput(v *CreateMembersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateMembersInput"}
	if v.AccountDetails == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountDetails"))
	} else if v.AccountDetails != nil {
		if err := validateAccountDetailsList(v.AccountDetails); err != nil {
			invalidParams.AddNested("AccountDetails", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeclineInvitationsInput(v *DeclineInvitationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeclineInvitationsInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteActionTargetInput(v *DeleteActionTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteActionTargetInput"}
	if v.ActionTargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionTargetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInsightInput(v *DeleteInsightInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInsightInput"}
	if v.InsightArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InsightArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInvitationsInput(v *DeleteInvitationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInvitationsInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteMembersInput(v *DeleteMembersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteMembersInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeStandardsControlsInput(v *DescribeStandardsControlsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeStandardsControlsInput"}
	if v.StandardsSubscriptionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StandardsSubscriptionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableImportFindingsForProductInput(v *DisableImportFindingsForProductInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableImportFindingsForProductInput"}
	if v.ProductSubscriptionArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductSubscriptionArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisableOrganizationAdminAccountInput(v *DisableOrganizationAdminAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisableOrganizationAdminAccountInput"}
	if v.AdminAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AdminAccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateMembersInput(v *DisassociateMembersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateMembersInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableImportFindingsForProductInput(v *EnableImportFindingsForProductInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableImportFindingsForProductInput"}
	if v.ProductArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ProductArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEnableOrganizationAdminAccountInput(v *EnableOrganizationAdminAccountInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EnableOrganizationAdminAccountInput"}
	if v.AdminAccountId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AdminAccountId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInsightResultsInput(v *GetInsightResultsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInsightResultsInput"}
	if v.InsightArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InsightArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetMembersInput(v *GetMembersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetMembersInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInviteMembersInput(v *InviteMembersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InviteMembersInput"}
	if v.AccountIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AccountIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateActionTargetInput(v *UpdateActionTargetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateActionTargetInput"}
	if v.ActionTargetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionTargetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFindingsInput(v *UpdateFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFindingsInput"}
	if v.Filters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filters"))
	}
	if v.Note != nil {
		if err := validateNoteUpdate(v.Note); err != nil {
			invalidParams.AddNested("Note", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateInsightInput(v *UpdateInsightInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateInsightInput"}
	if v.InsightArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InsightArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateOrganizationConfigurationInput(v *UpdateOrganizationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOrganizationConfigurationInput"}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateStandardsControlInput(v *UpdateStandardsControlInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateStandardsControlInput"}
	if v.StandardsControlArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StandardsControlArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
