// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the permissions to a data source.
func (c *Client) UpdateDataSourcePermissions(ctx context.Context, params *UpdateDataSourcePermissionsInput, optFns ...func(*Options)) (*UpdateDataSourcePermissionsOutput, error) {
	if params == nil {
		params = &UpdateDataSourcePermissionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDataSourcePermissions", params, optFns, c.addOperationUpdateDataSourcePermissionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDataSourcePermissionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDataSourcePermissionsInput struct {

	// The Amazon Web Services account; ID.
	//
	// This member is required.
	AwsAccountId *string

	// The ID of the data source. This ID is unique per Amazon Web Services Region; for
	// each Amazon Web Services account;.
	//
	// This member is required.
	DataSourceId *string

	// A list of resource permissions that you want to grant on the data source.
	GrantPermissions []types.ResourcePermission

	// A list of resource permissions that you want to revoke on the data source.
	RevokePermissions []types.ResourcePermission

	noSmithyDocumentSerde
}

type UpdateDataSourcePermissionsOutput struct {

	// The Amazon Resource Name (ARN) of the data source.
	DataSourceArn *string

	// The ID of the data source. This ID is unique per Amazon Web Services Region; for
	// each Amazon Web Services account;.
	DataSourceId *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDataSourcePermissionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDataSourcePermissions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDataSourcePermissions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateDataSourcePermissionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDataSourcePermissions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDataSourcePermissions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "quicksight",
		OperationName: "UpdateDataSourcePermissions",
	}
}
