// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an analysis in Amazon QuickSight
func (c *Client) UpdateAnalysis(ctx context.Context, params *UpdateAnalysisInput, optFns ...func(*Options)) (*UpdateAnalysisOutput, error) {
	if params == nil {
		params = &UpdateAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAnalysis", params, optFns, c.addOperationUpdateAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAnalysisInput struct {

	// The ID for the analysis that you're updating. This ID displays in the URL of the
	// analysis.
	//
	// This member is required.
	AnalysisId *string

	// The ID of the Amazon Web Services account; that contains the analysis that
	// you're updating.
	//
	// This member is required.
	AwsAccountId *string

	// A descriptive name for the analysis that you're updating. This name displays for
	// the analysis in the QuickSight console.
	//
	// This member is required.
	Name *string

	// A source entity to use for the analysis that you're updating. This metadata
	// structure contains details that describe a source template and one or more
	// datasets.
	//
	// This member is required.
	SourceEntity *types.AnalysisSourceEntity

	// The parameter names and override values that you want to use. An analysis can
	// have any parameter type, and some parameters might accept multiple values.
	Parameters *types.Parameters

	// The Amazon Resource Name (ARN) for the theme to apply to the analysis that
	// you're creating. To see the theme in the QuickSight console, make sure that you
	// have access to it.
	ThemeArn *string

	noSmithyDocumentSerde
}

type UpdateAnalysisOutput struct {

	// The ID of the analysis.
	AnalysisId *string

	// The ARN of the analysis that you're updating.
	Arn *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// The update status of the last update that was made to the analysis.
	UpdateStatus types.ResourceStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateAnalysisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "quicksight",
		OperationName: "UpdateAnalysis",
	}
}
