// Code generated by smithy-go-codegen DO NOT EDIT.

package pi

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/pi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieve Performance Insights metrics for a set of data sources, over a time
// period. You can provide specific dimension groups and dimensions, and provide
// aggregation and filtering criteria for each group. Each response element returns
// a maximum of 500 bytes. For larger elements, such as SQL statements, only the
// first 500 bytes are returned.
func (c *Client) GetResourceMetrics(ctx context.Context, params *GetResourceMetricsInput, optFns ...func(*Options)) (*GetResourceMetricsOutput, error) {
	if params == nil {
		params = &GetResourceMetricsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceMetrics", params, optFns, c.addOperationGetResourceMetricsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceMetricsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceMetricsInput struct {

	// The date and time specifying the end of the requested time series data. The
	// value specified is exclusive - data points less than (but not equal to) EndTime
	// will be returned. The value for EndTime must be later than the value for
	// StartTime.
	//
	// This member is required.
	EndTime *time.Time

	// An immutable, AWS Region-unique identifier for a data source. Performance
	// Insights gathers metrics from this data source. To use a DB instance as a data
	// source, specify its DbiResourceId value. For example, specify
	// db-FAIHNTYBKTGAUSUZQYPDS2GW4A.
	//
	// This member is required.
	Identifier *string

	// An array of one or more queries to perform. Each query must specify a
	// Performance Insights metric, and can optionally specify aggregation and
	// filtering criteria.
	//
	// This member is required.
	MetricQueries []types.MetricQuery

	// The AWS service for which Performance Insights returns metrics. The only valid
	// value for ServiceType is RDS.
	//
	// This member is required.
	ServiceType types.ServiceType

	// The date and time specifying the beginning of the requested time series data.
	// You can't specify a StartTime that's earlier than 7 days ago. The value
	// specified is inclusive - data points equal to or greater than StartTime will be
	// returned. The value for StartTime must be earlier than the value for EndTime.
	//
	// This member is required.
	StartTime *time.Time

	// The maximum number of items to return in the response. If more items exist than
	// the specified MaxRecords value, a pagination token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int32

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to the
	// value specified by MaxRecords.
	NextToken *string

	// The granularity, in seconds, of the data points returned from Performance
	// Insights. A period can be as short as one second, or as long as one day (86400
	// seconds). Valid values are:
	//
	// * 1 (one second)
	//
	// * 60 (one minute)
	//
	// * 300 (five
	// minutes)
	//
	// * 3600 (one hour)
	//
	// * 86400 (twenty-four hours)
	//
	// If you don't specify
	// PeriodInSeconds, then Performance Insights will choose a value for you, with a
	// goal of returning roughly 100-200 data points in the response.
	PeriodInSeconds *int32

	noSmithyDocumentSerde
}

type GetResourceMetricsOutput struct {

	// The end time for the returned metrics, after alignment to a granular boundary
	// (as specified by PeriodInSeconds). AlignedEndTime will be greater than or equal
	// to the value of the user-specified Endtime.
	AlignedEndTime *time.Time

	// The start time for the returned metrics, after alignment to a granular boundary
	// (as specified by PeriodInSeconds). AlignedStartTime will be less than or equal
	// to the value of the user-specified StartTime.
	AlignedStartTime *time.Time

	// An immutable, AWS Region-unique identifier for a data source. Performance
	// Insights gathers metrics from this data source. To use a DB instance as a data
	// source, you specify its DbiResourceId value - for example:
	// db-FAIHNTYBKTGAUSUZQYPDS2GW4A
	Identifier *string

	// An array of metric results,, where each array element contains all of the data
	// points for a particular dimension.
	MetricList []types.MetricKeyDataPoints

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to the
	// value specified by MaxRecords.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceMetricsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetResourceMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetResourceMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetResourceMetricsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceMetrics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetResourceMetrics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "pi",
		OperationName: "GetResourceMetrics",
	}
}
