// Code generated by smithy-go-codegen DO NOT EDIT.

package lexruntimev2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/lexruntimev2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpDeleteSession struct {
}

func (*awsRestjson1_serializeOpDeleteSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSessionInput(v *DeleteSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSession struct {
}

func (*awsRestjson1_serializeOpGetSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSessionInput(v *GetSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutSession struct {
}

func (*awsRestjson1_serializeOpPutSession) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutSessionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutSessionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutSessionInput(v *PutSessionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.ResponseContentType != nil && len(*v.ResponseContentType) > 0 {
		locationName := "Responsecontenttype"
		encoder.SetHeader(locationName).String(*v.ResponseContentType)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutSessionInput(v *PutSessionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Messages != nil {
		ok := object.Key("messages")
		if err := awsRestjson1_serializeDocumentMessages(v.Messages, ok); err != nil {
			return err
		}
	}

	if v.RequestAttributes != nil {
		ok := object.Key("requestAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.RequestAttributes, ok); err != nil {
			return err
		}
	}

	if v.SessionState != nil {
		ok := object.Key("sessionState")
		if err := awsRestjson1_serializeDocumentSessionState(v.SessionState, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRecognizeText struct {
}

func (*awsRestjson1_serializeOpRecognizeText) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRecognizeText) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecognizeTextInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/text")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRecognizeTextInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRecognizeTextInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRecognizeTextInput(v *RecognizeTextInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRecognizeTextInput(v *RecognizeTextInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RequestAttributes != nil {
		ok := object.Key("requestAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.RequestAttributes, ok); err != nil {
			return err
		}
	}

	if v.SessionState != nil {
		ok := object.Key("sessionState")
		if err := awsRestjson1_serializeDocumentSessionState(v.SessionState, ok); err != nil {
			return err
		}
	}

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	return nil
}

type awsRestjson1_serializeOpRecognizeUtterance struct {
}

func (*awsRestjson1_serializeOpRecognizeUtterance) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRecognizeUtterance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecognizeUtteranceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botAliases/{botAliasId}/botLocales/{localeId}/sessions/{sessionId}/utterance")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRecognizeUtteranceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.InputStream != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/octet-stream")
		}

		payload := input.InputStream
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRecognizeUtteranceInput(v *RecognizeUtteranceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.RequestAttributes != nil && len(*v.RequestAttributes) > 0 {
		locationName := "X-Amz-Lex-Request-Attributes"
		encoder.SetHeader(locationName).String(*v.RequestAttributes)
	}

	if v.RequestContentType != nil && len(*v.RequestContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.RequestContentType)
	}

	if v.ResponseContentType != nil && len(*v.ResponseContentType) > 0 {
		locationName := "Response-Content-Type"
		encoder.SetHeader(locationName).String(*v.ResponseContentType)
	}

	if v.SessionId == nil || len(*v.SessionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sessionId must not be empty")}
	}
	if v.SessionId != nil {
		if err := encoder.SetURI("sessionId").String(*v.SessionId); err != nil {
			return err
		}
	}

	if v.SessionState != nil && len(*v.SessionState) > 0 {
		locationName := "X-Amz-Lex-Session-State"
		encoder.SetHeader(locationName).String(*v.SessionState)
	}

	return nil
}

func awsRestjson1_serializeDocumentActiveContext(v *types.ActiveContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContextAttributes != nil {
		ok := object.Key("contextAttributes")
		if err := awsRestjson1_serializeDocumentActiveContextParametersMap(v.ContextAttributes, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.TimeToLive != nil {
		ok := object.Key("timeToLive")
		if err := awsRestjson1_serializeDocumentActiveContextTimeToLive(v.TimeToLive, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActiveContextParametersMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentActiveContextsList(v []types.ActiveContext, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentActiveContext(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActiveContextTimeToLive(v *types.ActiveContextTimeToLive, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimeToLiveInSeconds != nil {
		ok := object.Key("timeToLiveInSeconds")
		ok.Integer(*v.TimeToLiveInSeconds)
	}

	if v.TurnsToLive != nil {
		ok := object.Key("turnsToLive")
		ok.Integer(*v.TurnsToLive)
	}

	return nil
}

func awsRestjson1_serializeDocumentButton(v *types.Button, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentButtonsList(v []types.Button, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentButton(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDialogAction(v *types.DialogAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SlotToElicit != nil {
		ok := object.Key("slotToElicit")
		ok.String(*v.SlotToElicit)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentImageResponseCard(v *types.ImageResponseCard, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Buttons != nil {
		ok := object.Key("buttons")
		if err := awsRestjson1_serializeDocumentButtonsList(v.Buttons, ok); err != nil {
			return err
		}
	}

	if v.ImageUrl != nil {
		ok := object.Key("imageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentIntent(v *types.Intent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConfirmationState) > 0 {
		ok := object.Key("confirmationState")
		ok.String(string(v.ConfirmationState))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Slots != nil {
		ok := object.Key("slots")
		if err := awsRestjson1_serializeDocumentSlots(v.Slots, ok); err != nil {
			return err
		}
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("content")
		ok.String(*v.Content)
	}

	if len(v.ContentType) > 0 {
		ok := object.Key("contentType")
		ok.String(string(v.ContentType))
	}

	if v.ImageResponseCard != nil {
		ok := object.Key("imageResponseCard")
		if err := awsRestjson1_serializeDocumentImageResponseCard(v.ImageResponseCard, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessages(v []types.Message, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSessionState(v *types.SessionState, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveContexts != nil {
		ok := object.Key("activeContexts")
		if err := awsRestjson1_serializeDocumentActiveContextsList(v.ActiveContexts, ok); err != nil {
			return err
		}
	}

	if v.DialogAction != nil {
		ok := object.Key("dialogAction")
		if err := awsRestjson1_serializeDocumentDialogAction(v.DialogAction, ok); err != nil {
			return err
		}
	}

	if v.Intent != nil {
		ok := object.Key("intent")
		if err := awsRestjson1_serializeDocumentIntent(v.Intent, ok); err != nil {
			return err
		}
	}

	if v.OriginatingRequestId != nil {
		ok := object.Key("originatingRequestId")
		ok.String(*v.OriginatingRequestId)
	}

	if v.SessionAttributes != nil {
		ok := object.Key("sessionAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.SessionAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlot(v *types.Slot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Shape) > 0 {
		ok := object.Key("shape")
		ok.String(string(v.Shape))
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentValue(v.Value, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlots(v map[string]types.Slot, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentSlot(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentStringList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentValue(v *types.Value, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InterpretedValue != nil {
		ok := object.Key("interpretedValue")
		ok.String(*v.InterpretedValue)
	}

	if v.OriginalValue != nil {
		ok := object.Key("originalValue")
		ok.String(*v.OriginalValue)
	}

	if v.ResolvedValues != nil {
		ok := object.Key("resolvedValues")
		if err := awsRestjson1_serializeDocumentStringList(v.ResolvedValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentValues(v []types.Slot, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlot(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
