// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A list of failures when performing a batch grant or batch revoke operation.
type BatchPermissionsFailureEntry struct {

	// An error message that applies to the failure of the entry.
	Error *ErrorDetail

	// An identifier for an entry of the batch request.
	RequestEntry *BatchPermissionsRequestEntry

	noSmithyDocumentSerde
}

// A permission to a resource granted by batch operation to the principal.
type BatchPermissionsRequestEntry struct {

	// A unique identifier for the batch permissions request entry.
	//
	// This member is required.
	Id *string

	// The permissions to be granted.
	Permissions []Permission

	// Indicates if the option to pass permissions is granted.
	PermissionsWithGrantOption []Permission

	// The principal to be granted a permission.
	Principal *DataLakePrincipal

	// The resource to which the principal is to be granted a permission.
	Resource *Resource

	noSmithyDocumentSerde
}

// A structure for the catalog object.
type CatalogResource struct {
	noSmithyDocumentSerde
}

// A structure containing the name of a column resource and the tags attached to
// it.
type ColumnLFTag struct {

	// The tags attached to a column resource.
	LFTags []LFTagPair

	// The name of a column resource.
	Name *string

	noSmithyDocumentSerde
}

// A wildcard object, consisting of an optional list of excluded column names or
// indexes.
type ColumnWildcard struct {

	// Excludes column names. Any column with this name will be excluded.
	ExcludedColumnNames []string

	noSmithyDocumentSerde
}

// A structure for the database object.
type DatabaseResource struct {

	// The name of the database resource. Unique to the Data Catalog.
	//
	// This member is required.
	Name *string

	// The identifier for the Data Catalog. By default, it is the account ID of the
	// caller.
	CatalogId *string

	noSmithyDocumentSerde
}

// The AWS Lake Formation principal. Supported principals are IAM users or IAM
// roles.
type DataLakePrincipal struct {

	// An identifier for the AWS Lake Formation principal.
	DataLakePrincipalIdentifier *string

	noSmithyDocumentSerde
}

// A structure representing a list of AWS Lake Formation principals designated as
// data lake administrators and lists of principal permission entries for default
// create database and default create table permissions.
type DataLakeSettings struct {

	// A structure representing a list of up to three principal permissions entries for
	// default create database permissions.
	CreateDatabaseDefaultPermissions []PrincipalPermissions

	// A structure representing a list of up to three principal permissions entries for
	// default create table permissions.
	CreateTableDefaultPermissions []PrincipalPermissions

	// A list of AWS Lake Formation principals. Supported principals are IAM users or
	// IAM roles.
	DataLakeAdmins []DataLakePrincipal

	// A list of the resource-owning account IDs that the caller's account can use to
	// share their user access details (user ARNs). The user ARNs can be logged in the
	// resource owner's AWS CloudTrail log. You may want to specify this property when
	// you are in a high-trust boundary, such as the same team or company.
	TrustedResourceOwners []string

	noSmithyDocumentSerde
}

// A structure for a data location object where permissions are granted or revoked.
type DataLocationResource struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the data location
	// resource.
	//
	// This member is required.
	ResourceArn *string

	// The identifier for the Data Catalog where the location is registered with AWS
	// Lake Formation. By default, it is the account ID of the caller.
	CatalogId *string

	noSmithyDocumentSerde
}

// A structure containing the additional details to be returned in the
// AdditionalDetails attribute of PrincipalResourcePermissions. If a catalog
// resource is shared through AWS Resource Access Manager (AWS RAM), then there
// will exist a corresponding RAM resource share ARN.
type DetailsMap struct {

	// A resource share ARN for a catalog resource shared through AWS Resource Access
	// Manager (AWS RAM).
	ResourceShare []string

	noSmithyDocumentSerde
}

// Contains details about an error.
type ErrorDetail struct {

	// The code associated with this error.
	ErrorCode *string

	// A message describing the error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// This structure describes the filtering of columns in a table based on a filter
// condition.
type FilterCondition struct {

	// The comparison operator used in the filter condition.
	ComparisonOperator ComparisonOperator

	// The field to filter in the filter condition.
	Field FieldNameString

	// A string with values used in evaluating the filter condition.
	StringValueList []string

	noSmithyDocumentSerde
}

// A structure that allows an admin to grant user permissions on certain
// conditions. For example, granting a role access to all columns not tagged 'PII'
// of tables tagged 'Prod'.
type LFTag struct {

	// The key-name for the tag.
	//
	// This member is required.
	TagKey *string

	// A list of possible values an attribute can take.
	//
	// This member is required.
	TagValues []string

	noSmithyDocumentSerde
}

// A structure containing an error related to a TagResource or UnTagResource
// operation.
type LFTagError struct {

	// An error that occurred with the attachment or detachment of the tag.
	Error *ErrorDetail

	// The key-name of the tag.
	LFTag *LFTagPair

	noSmithyDocumentSerde
}

// A structure containing a tag key and values for a resource.
type LFTagKeyResource struct {

	// The key-name for the tag.
	//
	// This member is required.
	TagKey *string

	// A list of possible values an attribute can take.
	//
	// This member is required.
	TagValues []string

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string

	noSmithyDocumentSerde
}

// A structure containing a tag key-value pair.
type LFTagPair struct {

	// The key-name for the tag.
	//
	// This member is required.
	TagKey *string

	// A list of possible values an attribute can take.
	//
	// This member is required.
	TagValues []string

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string

	noSmithyDocumentSerde
}

// A structure containing a list of tag conditions that apply to a resource's tag
// policy.
type LFTagPolicyResource struct {

	// A list of tag conditions that apply to the resource's tag policy.
	//
	// This member is required.
	Expression []LFTag

	// The resource type for which the tag policy applies.
	//
	// This member is required.
	ResourceType ResourceType

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	CatalogId *string

	noSmithyDocumentSerde
}

// Permissions granted to a principal.
type PrincipalPermissions struct {

	// The permissions that are granted to the principal.
	Permissions []Permission

	// The principal who is granted permissions.
	Principal *DataLakePrincipal

	noSmithyDocumentSerde
}

// The permissions granted or revoked on a resource.
type PrincipalResourcePermissions struct {

	// This attribute can be used to return any additional details of
	// PrincipalResourcePermissions. Currently returns only as a RAM resource share
	// ARN.
	AdditionalDetails *DetailsMap

	// The permissions to be granted or revoked on the resource.
	Permissions []Permission

	// Indicates whether to grant the ability to grant permissions (as a subset of
	// permissions granted).
	PermissionsWithGrantOption []Permission

	// The Data Lake principal to be granted or revoked permissions.
	Principal *DataLakePrincipal

	// The resource where permissions are to be granted or revoked.
	Resource *Resource

	noSmithyDocumentSerde
}

// A structure for the resource.
type Resource struct {

	// The identifier for the Data Catalog. By default, the account ID. The Data
	// Catalog is the persistent metadata store. It contains database definitions,
	// table definitions, and other control information to manage your AWS Lake
	// Formation environment.
	Catalog *CatalogResource

	// The location of an Amazon S3 path where permissions are granted or revoked.
	DataLocation *DataLocationResource

	// The database for the resource. Unique to the Data Catalog. A database is a set
	// of associated table definitions organized into a logical group. You can Grant
	// and Revoke database permissions to a principal.
	Database *DatabaseResource

	// The tag key and values attached to a resource.
	LFTag *LFTagKeyResource

	// A list of tag conditions that define a resource's tag policy.
	LFTagPolicy *LFTagPolicyResource

	// The table for the resource. A table is a metadata definition that represents
	// your data. You can Grant and Revoke table privileges to a principal.
	Table *TableResource

	// The table with columns for the resource. A principal with permissions to this
	// resource can select metadata from the columns of a table in the Data Catalog and
	// the underlying data in Amazon S3.
	TableWithColumns *TableWithColumnsResource

	noSmithyDocumentSerde
}

// A structure containing information about an AWS Lake Formation resource.
type ResourceInfo struct {

	// The date and time the resource was last modified.
	LastModified *time.Time

	// The Amazon Resource Name (ARN) of the resource.
	ResourceArn *string

	// The IAM role that registered a resource.
	RoleArn *string

	noSmithyDocumentSerde
}

// A structure for the table object. A table is a metadata definition that
// represents your data. You can Grant and Revoke table privileges to a principal.
type TableResource struct {

	// The name of the database for the table. Unique to a Data Catalog. A database is
	// a set of associated table definitions organized into a logical group. You can
	// Grant and Revoke database privileges to a principal.
	//
	// This member is required.
	DatabaseName *string

	// The identifier for the Data Catalog. By default, it is the account ID of the
	// caller.
	CatalogId *string

	// The name of the table.
	Name *string

	// A wildcard object representing every table under a database. At least one of
	// TableResource$Name or TableResource$TableWildcard is required.
	TableWildcard *TableWildcard

	noSmithyDocumentSerde
}

// A wildcard object representing every table under a database.
type TableWildcard struct {
	noSmithyDocumentSerde
}

// A structure for a table with columns object. This object is only used when
// granting a SELECT permission. This object must take a value for at least one of
// ColumnsNames, ColumnsIndexes, or ColumnsWildcard.
type TableWithColumnsResource struct {

	// The name of the database for the table with columns resource. Unique to the Data
	// Catalog. A database is a set of associated table definitions organized into a
	// logical group. You can Grant and Revoke database privileges to a principal.
	//
	// This member is required.
	DatabaseName *string

	// The name of the table resource. A table is a metadata definition that represents
	// your data. You can Grant and Revoke table privileges to a principal.
	//
	// This member is required.
	Name *string

	// The identifier for the Data Catalog. By default, it is the account ID of the
	// caller.
	CatalogId *string

	// The list of column names for the table. At least one of ColumnNames or
	// ColumnWildcard is required.
	ColumnNames []string

	// A wildcard specified by a ColumnWildcard object. At least one of ColumnNames or
	// ColumnWildcard is required.
	ColumnWildcard *ColumnWildcard

	noSmithyDocumentSerde
}

// A structure describing a database resource with tags.
type TaggedDatabase struct {

	// A database that has tags attached to it.
	Database *DatabaseResource

	// A list of tags attached to the database.
	LFTags []LFTagPair

	noSmithyDocumentSerde
}

// A structure describing a table resource with tags.
type TaggedTable struct {

	// A list of tags attached to the database where the table resides.
	LFTagOnDatabase []LFTagPair

	// A list of tags attached to columns in the table.
	LFTagsOnColumns []ColumnLFTag

	// A list of tags attached to the table.
	LFTagsOnTable []LFTagPair

	// A table that has tags attached to it.
	Table *TableResource

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
