// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A generic address associated with the customer that is not mailing, shipping, or
// billing.
type Address struct {

	// The first line of a customer address.
	Address1 *string

	// The second line of a customer address.
	Address2 *string

	// The third line of a customer address.
	Address3 *string

	// The fourth line of a customer address.
	Address4 *string

	// The city in which a customer lives.
	City *string

	// The country in which a customer lives.
	Country *string

	// The county in which a customer lives.
	County *string

	// The postal code of a customer address.
	PostalCode *string

	// The province in which a customer lives.
	Province *string

	// The state in which a customer lives.
	State *string

	noSmithyDocumentSerde
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {

	// The operation to be performed on the provided Marketo source fields.
	Marketo MarketoConnectorOperator

	// The operation to be performed on the provided Amazon S3 source fields.
	S3 S3ConnectorOperator

	// The operation to be performed on the provided Salesforce source fields.
	Salesforce SalesforceConnectorOperator

	// The operation to be performed on the provided ServiceNow source fields.
	ServiceNow ServiceNowConnectorOperator

	// The operation to be performed on the provided Zendesk source fields.
	Zendesk ZendeskConnectorOperator

	noSmithyDocumentSerde
}

// Usage-specific statistics about the domain.
type DomainStats struct {

	// The number of profiles that you are currently paying for in the domain. If you
	// have more than 100 objects associated with a single profile, that profile counts
	// as two profiles. If you have more than 200 objects, that profile counts as
	// three, and so on.
	MeteringProfileCount int64

	// The total number of objects in domain.
	ObjectCount int64

	// The total number of profiles currently in the domain.
	ProfileCount int64

	// The total size, in bytes, of all objects in the domain.
	TotalSize int64

	noSmithyDocumentSerde
}

// A duplicate customer profile that is to be merged into a main profile.
type FieldSourceProfileIds struct {

	// A unique identifier for the account number field to be merged.
	AccountNumber *string

	// A unique identifier for the additional information field to be merged.
	AdditionalInformation *string

	// A unique identifier for the party type field to be merged.
	Address *string

	// A unique identifier for the attributes field to be merged.
	Attributes map[string]string

	// A unique identifier for the billing type field to be merged.
	BillingAddress *string

	// A unique identifier for the birthdate field to be merged.
	BirthDate *string

	// A unique identifier for the party type field to be merged.
	BusinessEmailAddress *string

	// A unique identifier for the business name field to be merged.
	BusinessName *string

	// A unique identifier for the business phone number field to be merged.
	BusinessPhoneNumber *string

	// A unique identifier for the email address field to be merged.
	EmailAddress *string

	// A unique identifier for the first name field to be merged.
	FirstName *string

	// A unique identifier for the gender field to be merged.
	Gender *string

	// A unique identifier for the home phone number field to be merged.
	HomePhoneNumber *string

	// A unique identifier for the last name field to be merged.
	LastName *string

	// A unique identifier for the mailing address field to be merged.
	MailingAddress *string

	// A unique identifier for the middle name field to be merged.
	MiddleName *string

	// A unique identifier for the mobile phone number field to be merged.
	MobilePhoneNumber *string

	// A unique identifier for the party type field to be merged.
	PartyType *string

	// A unique identifier for the personal email address field to be merged.
	PersonalEmailAddress *string

	// A unique identifier for the phone number field to be merged.
	PhoneNumber *string

	// A unique identifier for the shipping address field to be merged.
	ShippingAddress *string

	noSmithyDocumentSerde
}

// The configurations that control how Customer Profiles retrieves data from the
// source, Amazon AppFlow. Customer Profiles uses this information to create an
// AppFlow flow on behalf of customers.
type FlowDefinition struct {

	// The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces
	// are not allowed.
	//
	// This member is required.
	FlowName *string

	// The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide
	// for encryption.
	//
	// This member is required.
	KmsArn *string

	// The configuration that controls how Customer Profiles retrieves data from the
	// source.
	//
	// This member is required.
	SourceFlowConfig *SourceFlowConfig

	// A list of tasks that Customer Profiles performs while transferring the data in
	// the flow run.
	//
	// This member is required.
	Tasks []Task

	// The trigger settings that determine how and when the flow runs.
	//
	// This member is required.
	TriggerConfig *TriggerConfig

	// A description of the flow you want to create.
	Description *string

	noSmithyDocumentSerde
}

// Specifies the configuration used when importing incremental records from the
// source.
type IncrementalPullConfig struct {

	// A field that specifies the date time or timestamp field as the criteria to use
	// when importing incremental records from the source.
	DatetimeTypeFieldName *string

	noSmithyDocumentSerde
}

// An object in a list that represents a domain.
type ListDomainItem struct {

	// The timestamp of when the domain was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The timestamp of when the domain was most recently edited.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// An integration in list of integrations.
type ListIntegrationItem struct {

	// The timestamp of when the domain was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The timestamp of when the domain was most recently edited.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the profile object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The URI of the S3 bucket or any other type of data source.
	//
	// This member is required.
	Uri *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A ProfileObject in a list of ProfileObjects.
type ListProfileObjectsItem struct {

	// A JSON representation of a ProfileObject that belongs to a profile.
	Object *string

	// Specifies the kind of object being added to a profile, such as
	// "Salesforce-Account."
	ObjectTypeName *string

	// The unique identifier of the ProfileObject generated by the service.
	ProfileObjectUniqueKey *string

	noSmithyDocumentSerde
}

// A ProfileObjectType instance.
type ListProfileObjectTypeItem struct {

	// Description of the profile object type.
	//
	// This member is required.
	Description *string

	// The name of the profile object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The timestamp of when the domain was created.
	CreatedAt *time.Time

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A ProfileObjectTypeTemplate in a list of ProfileObjectTypeTemplates.
type ListProfileObjectTypeTemplateItem struct {

	// The name of the source of the object template.
	SourceName *string

	// The source of the object template.
	SourceObject *string

	// A unique identifier for the object template.
	TemplateId *string

	noSmithyDocumentSerde
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {

	// The object specified in the Marketo flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The flag that enables the matching process of duplicate profiles.
type MatchingRequest struct {

	// The flag that enables the matching process of duplicate profiles.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// The flag that enables the matching process of duplicate profiles.
type MatchingResponse struct {

	// The flag that enables the matching process of duplicate profiles.
	Enabled *bool

	noSmithyDocumentSerde
}

// The Match group object.
type MatchItem struct {

	// The unique identifiers for this group of profiles that match.
	MatchId *string

	// A list of identifiers for profiles that match.
	ProfileIds []string

	noSmithyDocumentSerde
}

// The filter applied to ListProfileObjects response to include profile objects
// with the specified index values. This filter is only supported for
// ObjectTypeName _asset and _case.
type ObjectFilter struct {

	// A searchable identifier of a standard profile object. The predefined keys you
	// can use to search for _asset include: _assetId, _assetName, _serialNumber. The
	// predefined keys you can use to search for _case include: _caseId.
	//
	// This member is required.
	KeyName *string

	// A list of key values.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents a field in a ProfileObjectType.
type ObjectTypeField struct {

	// The content type of the field. Used for determining equality when searching.
	ContentType FieldContentType

	// A field of a ProfileObject. For example: _source.FirstName, where “_source” is a
	// ProfileObjectType of a Zendesk user and “FirstName” is a field in that
	// ObjectType.
	Source *string

	// The location of the data in the standard ProfileObject model. For example:
	// _profile.Address.PostalCode.
	Target *string

	noSmithyDocumentSerde
}

// An object that defines the Key element of a ProfileObject. A Key is a special
// element that can be used to search for a customer profile.
type ObjectTypeKey struct {

	// The reference for the key name of the fields map.
	FieldNames []string

	// The types of keys that a ProfileObject can have. Each ProfileObject can have
	// only 1 UNIQUE key but multiple PROFILE keys. PROFILE, ASSET or CASE means that
	// this key can be used to tie an object to a PROFILE, ASSET or CASE respectively.
	// UNIQUE means that it can be used to uniquely identify an object. If a key a is
	// marked as SECONDARY, it will be used to search for profiles after all other
	// PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a
	// profile but is not persisted to be used for searching of the profile. A NEW_ONLY
	// key is only used if the profile does not already exist before the object is
	// ingested, otherwise it is only used for matching objects to profiles.
	StandardIdentifiers []StandardIdentifier

	noSmithyDocumentSerde
}

// The standard profile of a customer.
type Profile struct {

	// A unique account number that you have given to the customer.
	AccountNumber *string

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string

	// A generic address associated with the customer that is not mailing, shipping, or
	// billing.
	Address *Address

	// A key value pair of attributes of a customer profile.
	Attributes map[string]string

	// The customer’s billing address.
	BillingAddress *Address

	// The customer’s birth date.
	BirthDate *string

	// The customer’s business email address.
	BusinessEmailAddress *string

	// The name of the customer’s business.
	BusinessName *string

	// The customer’s home phone number.
	BusinessPhoneNumber *string

	// The customer’s email address, which has not been specified as a personal or
	// business address.
	EmailAddress *string

	// The customer’s first name.
	FirstName *string

	// The gender with which the customer identifies.
	Gender Gender

	// The customer’s home phone number.
	HomePhoneNumber *string

	// The customer’s last name.
	LastName *string

	// The customer’s mailing address.
	MailingAddress *Address

	// The customer’s middle name.
	MiddleName *string

	// The customer’s mobile phone number.
	MobilePhoneNumber *string

	// The type of profile used to describe the customer.
	PartyType PartyType

	// The customer’s personal email address.
	PersonalEmailAddress *string

	// The customer's phone number, which has not been specified as a mobile, home, or
	// business number.
	PhoneNumber *string

	// The unique identifier of a customer profile.
	ProfileId *string

	// The customer’s shipping address.
	ShippingAddress *Address

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon S3 is being used as the flow source.
type S3SourceProperties struct {

	// The Amazon S3 bucket name where the source files are stored.
	//
	// This member is required.
	BucketName *string

	// The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string

	noSmithyDocumentSerde
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {

	// The object specified in the Salesforce flow source.
	//
	// This member is required.
	Object *string

	// The flag that enables dynamic fetching of new (recently added) fields in the
	// Salesforce objects while running a flow.
	EnableDynamicFieldUpdate bool

	// Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords bool

	noSmithyDocumentSerde
}

// Specifies the configuration details of a scheduled-trigger flow that you define.
// Currently, these settings only apply to the scheduled-trigger type.
type ScheduledTriggerProperties struct {

	// The scheduling expression that determines the rate at which the schedule will
	// run, for example rate (5 minutes).
	//
	// This member is required.
	ScheduleExpression *string

	// Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode DataPullMode

	// Specifies the date range for the records to import from the connector in the
	// first flow run.
	FirstExecutionFrom *time.Time

	// Specifies the scheduled end time for a scheduled-trigger flow.
	ScheduleEndTime *time.Time

	// Specifies the optional offset that is added to the time interval for a
	// schedule-triggered flow.
	ScheduleOffset int64

	// Specifies the scheduled start time for a scheduled-trigger flow.
	ScheduleStartTime *time.Time

	// Specifies the time zone used when referring to the date and time of a
	// scheduled-triggered flow, such as America/New_York.
	Timezone *string

	noSmithyDocumentSerde
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {

	// The object specified in the ServiceNow flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// Specifies the information that is required to query a particular Amazon AppFlow
// connector. Customer Profiles supports Salesforce, Zendesk, Marketo, ServiceNow
// and Amazon S3.
type SourceConnectorProperties struct {

	// The properties that are applied when Marketo is being used as a source.
	Marketo *MarketoSourceProperties

	// The properties that are applied when Amazon S3 is being used as the flow source.
	S3 *S3SourceProperties

	// The properties that are applied when Salesforce is being used as a source.
	Salesforce *SalesforceSourceProperties

	// The properties that are applied when ServiceNow is being used as a source.
	ServiceNow *ServiceNowSourceProperties

	// The properties that are applied when using Zendesk as a flow source.
	Zendesk *ZendeskSourceProperties

	noSmithyDocumentSerde
}

// Contains information about the configuration of the source connector used in the
// flow.
type SourceFlowConfig struct {

	// The type of connector, such as Salesforce, Marketo, and so on.
	//
	// This member is required.
	ConnectorType SourceConnectorType

	// Specifies the information that is required to query a particular source
	// connector.
	//
	// This member is required.
	SourceConnectorProperties *SourceConnectorProperties

	// The name of the AppFlow connector profile. This name must be unique for each
	// connector profile in the AWS account.
	ConnectorProfileName *string

	// Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are used
	// when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig

	noSmithyDocumentSerde
}

// A class for modeling different type of tasks. Task implementation varies based
// on the TaskType.
type Task struct {

	// The source fields to which a particular task is applied.
	//
	// This member is required.
	SourceFields []string

	// Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// This member is required.
	TaskType TaskType

	// The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator

	// A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string

	// A map used to store task-related information. The service looks for particular
	// information based on the TaskType.
	TaskProperties map[string]string

	noSmithyDocumentSerde
}

// The trigger settings that determine how and when Amazon AppFlow runs the
// specified flow.
type TriggerConfig struct {

	// Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.
	//
	// This member is required.
	TriggerType TriggerType

	// Specifies the configuration details of a schedule-triggered flow that you
	// define. Currently, these settings only apply to the Scheduled trigger type.
	TriggerProperties *TriggerProperties

	noSmithyDocumentSerde
}

// Specifies the configuration details that control the trigger for a flow.
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {

	// Specifies the configuration details of a schedule-triggered flow that you
	// define.
	Scheduled *ScheduledTriggerProperties

	noSmithyDocumentSerde
}

// Updates associated with the address properties of a customer profile.
type UpdateAddress struct {

	// The first line of a customer address.
	Address1 *string

	// The second line of a customer address.
	Address2 *string

	// The third line of a customer address.
	Address3 *string

	// The fourth line of a customer address.
	Address4 *string

	// The city in which a customer lives.
	City *string

	// The country in which a customer lives.
	Country *string

	// The county in which a customer lives.
	County *string

	// The postal code of a customer address.
	PostalCode *string

	// The province in which a customer lives.
	Province *string

	// The state in which a customer lives.
	State *string

	noSmithyDocumentSerde
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {

	// The object specified in the Zendesk flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
