// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new training plan in SageMaker to reserve compute capacity.
//
// Amazon SageMaker Training Plan is a capability within SageMaker that allows
// customers to reserve and manage GPU capacity for large-scale AI model training.
// It provides a way to secure predictable access to computational resources within
// specific timelines and budgets, without the need to manage underlying
// infrastructure.
//
// # How it works
//
// Plans can be created for specific resources such as SageMaker Training Jobs or
// SageMaker HyperPod clusters, automatically provisioning resources, setting up
// infrastructure, executing workloads, and handling infrastructure failures.
//
// Plan creation workflow
//
//   - Users search for available plan offerings based on their requirements
//     (e.g., instance type, count, start time, duration) using the [SearchTrainingPlanOfferings]API operation.
//
//   - They create a plan that best matches their needs using the ID of the plan
//     offering they want to use.
//
//   - After successful upfront payment, the plan's status becomes Scheduled .
//
//   - The plan can be used to:
//
//   - Queue training jobs.
//
//   - Allocate to an instance group of a SageMaker HyperPod cluster.
//
//   - When the plan start date arrives, it becomes Active . Based on available
//     reserved capacity:
//
//   - Training jobs are launched.
//
//   - Instance groups are provisioned.
//
// # Plan composition
//
// A plan can consist of one or more Reserved Capacities, each defined by a
// specific instance type, quantity, Availability Zone, duration, and start and end
// times. For more information about Reserved Capacity, see [ReservedCapacitySummary].
//
// [SearchTrainingPlanOfferings]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchTrainingPlanOfferings.html
// [ReservedCapacitySummary]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ReservedCapacitySummary.html
func (c *Client) CreateTrainingPlan(ctx context.Context, params *CreateTrainingPlanInput, optFns ...func(*Options)) (*CreateTrainingPlanOutput, error) {
	if params == nil {
		params = &CreateTrainingPlanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTrainingPlan", params, optFns, c.addOperationCreateTrainingPlanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTrainingPlanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTrainingPlanInput struct {

	// The name of the training plan to create.
	//
	// This member is required.
	TrainingPlanName *string

	// The unique identifier of the training plan offering to use for creating this
	// plan.
	//
	// This member is required.
	TrainingPlanOfferingId *string

	// Number of spare instances to reserve per UltraServer for enhanced resiliency.
	// Default is 1.
	SpareInstanceCountPerUltraServer *int32

	// An array of key-value pairs to apply to this training plan.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateTrainingPlanOutput struct {

	// The Amazon Resource Name (ARN); of the created training plan.
	//
	// This member is required.
	TrainingPlanArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTrainingPlanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateTrainingPlan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateTrainingPlan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTrainingPlan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTrainingPlanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTrainingPlan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTrainingPlan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTrainingPlan",
	}
}
