// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Begins a multipart read set upload.
func (c *Client) CreateMultipartReadSetUpload(ctx context.Context, params *CreateMultipartReadSetUploadInput, optFns ...func(*Options)) (*CreateMultipartReadSetUploadOutput, error) {
	if params == nil {
		params = &CreateMultipartReadSetUploadInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMultipartReadSetUpload", params, optFns, c.addOperationCreateMultipartReadSetUploadMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMultipartReadSetUploadOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMultipartReadSetUploadInput struct {

	// The name of the read set.
	//
	// This member is required.
	Name *string

	// The source's sample ID.
	//
	// This member is required.
	SampleId *string

	// The sequence store ID for the store that is the destination of the multipart
	// uploads.
	//
	// This member is required.
	SequenceStoreId *string

	// The type of file being uploaded.
	//
	// This member is required.
	SourceFileType types.FileType

	// The source's subject ID.
	//
	// This member is required.
	SubjectId *string

	// An idempotency token that can be used to avoid triggering multiple multipart
	// uploads.
	ClientToken *string

	// The description of the read set.
	Description *string

	// Where the source originated.
	GeneratedFrom *string

	// The ARN of the reference.
	ReferenceArn *string

	// Any tags to add to the read set.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateMultipartReadSetUploadOutput struct {

	// The creation time of the multipart upload.
	//
	// This member is required.
	CreationTime *time.Time

	// The read set source's reference ARN.
	//
	// This member is required.
	ReferenceArn *string

	// The source's sample ID.
	//
	// This member is required.
	SampleId *string

	// The sequence store ID for the store that the read set will be created in.
	//
	// This member is required.
	SequenceStoreId *string

	// The file type of the read set source.
	//
	// This member is required.
	SourceFileType types.FileType

	// The source's subject ID.
	//
	// This member is required.
	SubjectId *string

	// The ID for the initiated multipart upload.
	//
	// This member is required.
	UploadId *string

	// The description of the read set.
	Description *string

	// The source of the read set.
	GeneratedFrom *string

	// The name of the read set.
	Name *string

	// The tags to add to the read set.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMultipartReadSetUploadMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMultipartReadSetUpload{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMultipartReadSetUpload{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMultipartReadSetUpload"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateMultipartReadSetUploadMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateMultipartReadSetUploadValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMultipartReadSetUpload(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateMultipartReadSetUploadMiddleware struct {
}

func (*endpointPrefix_opCreateMultipartReadSetUploadMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateMultipartReadSetUploadMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "control-storage-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateMultipartReadSetUploadMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateMultipartReadSetUploadMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCreateMultipartReadSetUpload(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMultipartReadSetUpload",
	}
}
