// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns detailed information for a stateful rule group.
//
// For active threat defense Amazon Web Services managed rule groups, this
// operation provides insight into the protections enabled by the rule group, based
// on Suricata rule metadata fields. Summaries are available for rule groups you
// manage and for active threat defense Amazon Web Services managed rule groups.
//
// To modify how threat information appears in summaries, use the
// SummaryConfiguration parameter in UpdateRuleGroup.
func (c *Client) DescribeRuleGroupSummary(ctx context.Context, params *DescribeRuleGroupSummaryInput, optFns ...func(*Options)) (*DescribeRuleGroupSummaryOutput, error) {
	if params == nil {
		params = &DescribeRuleGroupSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRuleGroupSummary", params, optFns, c.addOperationDescribeRuleGroupSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRuleGroupSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRuleGroupSummaryInput struct {

	// Required. The Amazon Resource Name (ARN) of the rule group.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupArn *string

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// You must specify the ARN or the name, and you can specify both.
	RuleGroupName *string

	// The type of rule group you want a summary for. This is a required field.
	//
	// Valid value: STATEFUL
	//
	// Note that STATELESS exists but is not currently supported. If you provide
	// STATELESS , an exception is returned.
	Type types.RuleGroupType

	noSmithyDocumentSerde
}

type DescribeRuleGroupSummaryOutput struct {

	// The descriptive name of the rule group. You can't change the name of a rule
	// group after you create it.
	//
	// This member is required.
	RuleGroupName *string

	// A description of the rule group.
	Description *string

	// A complex type that contains rule information based on the rule group's
	// configured summary settings. The content varies depending on the fields that you
	// specified to extract in your SummaryConfiguration. When you haven't configured
	// any summary settings, this returns an empty array. The response might include:
	//
	//   - Rule identifiers
	//
	//   - Rule descriptions
	//
	//   - Any metadata fields that you specified in your SummaryConfiguration
	Summary *types.Summary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRuleGroupSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeRuleGroupSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeRuleGroupSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRuleGroupSummary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRuleGroupSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeRuleGroupSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRuleGroupSummary",
	}
}
