// Code generated by smithy-go-codegen DO NOT EDIT.

package licensemanagerlinuxsubscriptions

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/licensemanagerlinuxsubscriptions/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the running Amazon EC2 instances that were discovered with commercial
// Linux subscriptions.
func (c *Client) ListLinuxSubscriptionInstances(ctx context.Context, params *ListLinuxSubscriptionInstancesInput, optFns ...func(*Options)) (*ListLinuxSubscriptionInstancesOutput, error) {
	if params == nil {
		params = &ListLinuxSubscriptionInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLinuxSubscriptionInstances", params, optFns, c.addOperationListLinuxSubscriptionInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLinuxSubscriptionInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// NextToken length limit is half of ddb accepted limit. Increase this limit if
// parameters in request increases.
type ListLinuxSubscriptionInstancesInput struct {

	// An array of structures that you can use to filter the results by your specified
	// criteria. For example, you can specify Region in the Name , with the contains
	// operator to list all subscriptions that match a partial string in the Value ,
	// such as us-west .
	//
	// For each filter, you can specify one of the following values for the Name key
	// to streamline results:
	//
	//   - AccountID
	//
	//   - AmiID
	//
	//   - DualSubscription
	//
	//   - InstanceID
	//
	//   - InstanceType
	//
	//   - ProductCode
	//
	//   - Region
	//
	//   - Status
	//
	//   - UsageOperation
	//
	// For each filter, you can use one of the following Operator values to define the
	// behavior of the filter:
	//
	//   - contains
	//
	//   - equals
	//
	//   - Notequal
	Filters []types.Filter

	// The maximum items to return in a request.
	MaxResults *int32

	// A token to specify where to start paginating. This is the nextToken from a
	// previously truncated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListLinuxSubscriptionInstancesOutput struct {

	// An array that contains instance objects.
	Instances []types.Instance

	// The next token used for paginated responses. When this field isn't empty, there
	// are additional elements that the service hasn't included in this request. Use
	// this token with the next request to retrieve additional objects.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLinuxSubscriptionInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListLinuxSubscriptionInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListLinuxSubscriptionInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLinuxSubscriptionInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLinuxSubscriptionInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListLinuxSubscriptionInstancesPaginatorOptions is the paginator options for
// ListLinuxSubscriptionInstances
type ListLinuxSubscriptionInstancesPaginatorOptions struct {
	// The maximum items to return in a request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLinuxSubscriptionInstancesPaginator is a paginator for
// ListLinuxSubscriptionInstances
type ListLinuxSubscriptionInstancesPaginator struct {
	options   ListLinuxSubscriptionInstancesPaginatorOptions
	client    ListLinuxSubscriptionInstancesAPIClient
	params    *ListLinuxSubscriptionInstancesInput
	nextToken *string
	firstPage bool
}

// NewListLinuxSubscriptionInstancesPaginator returns a new
// ListLinuxSubscriptionInstancesPaginator
func NewListLinuxSubscriptionInstancesPaginator(client ListLinuxSubscriptionInstancesAPIClient, params *ListLinuxSubscriptionInstancesInput, optFns ...func(*ListLinuxSubscriptionInstancesPaginatorOptions)) *ListLinuxSubscriptionInstancesPaginator {
	if params == nil {
		params = &ListLinuxSubscriptionInstancesInput{}
	}

	options := ListLinuxSubscriptionInstancesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLinuxSubscriptionInstancesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLinuxSubscriptionInstancesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLinuxSubscriptionInstances page.
func (p *ListLinuxSubscriptionInstancesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLinuxSubscriptionInstancesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLinuxSubscriptionInstances(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLinuxSubscriptionInstancesAPIClient is a client that implements the
// ListLinuxSubscriptionInstances operation.
type ListLinuxSubscriptionInstancesAPIClient interface {
	ListLinuxSubscriptionInstances(context.Context, *ListLinuxSubscriptionInstancesInput, ...func(*Options)) (*ListLinuxSubscriptionInstancesOutput, error)
}

var _ ListLinuxSubscriptionInstancesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLinuxSubscriptionInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLinuxSubscriptionInstances",
	}
}
