// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a command. A command contains reusable configurations that can be
// applied before they are sent to the devices.
func (c *Client) CreateCommand(ctx context.Context, params *CreateCommandInput, optFns ...func(*Options)) (*CreateCommandOutput, error) {
	if params == nil {
		params = &CreateCommandInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateCommand", params, optFns, c.addOperationCreateCommandMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateCommandOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateCommandInput struct {

	// A unique identifier for the command. We recommend using UUID. Alpha-numeric
	// characters, hyphens, and underscores are valid for use here.
	//
	// This member is required.
	CommandId *string

	// A short text decription of the command.
	Description *string

	// The user-friendly name in the console for the command. This name doesn't have
	// to be unique. You can update the user-friendly name after you define it.
	DisplayName *string

	// A list of parameters that are required by the StartCommandExecution API. These
	// parameters need to be specified only when using the AWS-IoT-FleetWise
	// namespace. You can either specify them here or when running the command using
	// the StartCommandExecution API.
	MandatoryParameters []types.CommandParameter

	// The namespace of the command. The MQTT reserved topics and validations will be
	// used for command executions according to the namespace setting.
	Namespace types.CommandNamespace

	// The payload object for the command. You must specify this information when
	// using the AWS-IoT namespace.
	//
	// You can upload a static payload file from your local storage that contains the
	// instructions for the device to process. The payload file can use any format. To
	// make sure that the device correctly interprets the payload, we recommend you to
	// specify the payload content type.
	Payload *types.CommandPayload

	// The IAM role that you must provide when using the AWS-IoT-FleetWise namespace.
	// The role grants IoT Device Management the permission to access IoT FleetWise
	// resources for generating the payload for the command. This field is not required
	// when you use the AWS-IoT namespace.
	RoleArn *string

	// Name-value pairs that are used as metadata to manage a command.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateCommandOutput struct {

	// The Amazon Resource Number (ARN) of the command. For example,
	// arn:aws:iot:::command/
	CommandArn *string

	// The unique identifier for the command.
	CommandId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateCommandMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateCommand{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateCommand{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateCommand"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateCommandValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateCommand(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateCommand(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateCommand",
	}
}
