// Code generated by smithy-go-codegen DO NOT EDIT.

package evs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/evs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the hosts within an environment.
func (c *Client) ListEnvironmentHosts(ctx context.Context, params *ListEnvironmentHostsInput, optFns ...func(*Options)) (*ListEnvironmentHostsOutput, error) {
	if params == nil {
		params = &ListEnvironmentHostsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEnvironmentHosts", params, optFns, c.addOperationListEnvironmentHostsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEnvironmentHostsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEnvironmentHostsInput struct {

	// A unique ID for the environment.
	//
	// This member is required.
	EnvironmentId *string

	// The maximum number of results to return. If you specify MaxResults in the
	// request, the response includes information up to the limit specified.
	MaxResults *int32

	// A unique pagination token for each page. If nextToken is returned, there are
	// more results available. Make the call again using the returned token with all
	// other arguments unchanged to retrieve the next page. Each pagination token
	// expires after 24 hours. Using an expired pagination token will return an HTTP
	// 400 InvalidToken error.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEnvironmentHostsOutput struct {

	// A list of hosts in the environment.
	EnvironmentHosts []types.Host

	// A unique pagination token for next page results. Make the call again using this
	// token to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEnvironmentHostsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEnvironmentHosts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEnvironmentHosts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEnvironmentHosts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEnvironmentHostsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEnvironmentHosts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEnvironmentHostsPaginatorOptions is the paginator options for
// ListEnvironmentHosts
type ListEnvironmentHostsPaginatorOptions struct {
	// The maximum number of results to return. If you specify MaxResults in the
	// request, the response includes information up to the limit specified.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEnvironmentHostsPaginator is a paginator for ListEnvironmentHosts
type ListEnvironmentHostsPaginator struct {
	options   ListEnvironmentHostsPaginatorOptions
	client    ListEnvironmentHostsAPIClient
	params    *ListEnvironmentHostsInput
	nextToken *string
	firstPage bool
}

// NewListEnvironmentHostsPaginator returns a new ListEnvironmentHostsPaginator
func NewListEnvironmentHostsPaginator(client ListEnvironmentHostsAPIClient, params *ListEnvironmentHostsInput, optFns ...func(*ListEnvironmentHostsPaginatorOptions)) *ListEnvironmentHostsPaginator {
	if params == nil {
		params = &ListEnvironmentHostsInput{}
	}

	options := ListEnvironmentHostsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEnvironmentHostsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEnvironmentHostsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEnvironmentHosts page.
func (p *ListEnvironmentHostsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEnvironmentHostsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEnvironmentHosts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEnvironmentHostsAPIClient is a client that implements the
// ListEnvironmentHosts operation.
type ListEnvironmentHostsAPIClient interface {
	ListEnvironmentHosts(context.Context, *ListEnvironmentHostsInput, ...func(*Options)) (*ListEnvironmentHostsOutput, error)
}

var _ ListEnvironmentHostsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEnvironmentHosts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEnvironmentHosts",
	}
}
