// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all endpoints for a specific Amazon Secure Agent.
func (c *Client) ListAgentRuntimeEndpoints(ctx context.Context, params *ListAgentRuntimeEndpointsInput, optFns ...func(*Options)) (*ListAgentRuntimeEndpointsOutput, error) {
	if params == nil {
		params = &ListAgentRuntimeEndpointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAgentRuntimeEndpoints", params, optFns, c.addOperationListAgentRuntimeEndpointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAgentRuntimeEndpointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAgentRuntimeEndpointsInput struct {

	// The unique identifier of the agent runtime to list endpoints for.
	//
	// This member is required.
	AgentRuntimeId *string

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAgentRuntimeEndpointsOutput struct {

	// The list of agent runtime endpoints.
	//
	// This member is required.
	RuntimeEndpoints []types.AgentEndpoint

	// A token to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAgentRuntimeEndpointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAgentRuntimeEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAgentRuntimeEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAgentRuntimeEndpoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAgentRuntimeEndpointsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAgentRuntimeEndpoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAgentRuntimeEndpointsPaginatorOptions is the paginator options for
// ListAgentRuntimeEndpoints
type ListAgentRuntimeEndpointsPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAgentRuntimeEndpointsPaginator is a paginator for ListAgentRuntimeEndpoints
type ListAgentRuntimeEndpointsPaginator struct {
	options   ListAgentRuntimeEndpointsPaginatorOptions
	client    ListAgentRuntimeEndpointsAPIClient
	params    *ListAgentRuntimeEndpointsInput
	nextToken *string
	firstPage bool
}

// NewListAgentRuntimeEndpointsPaginator returns a new
// ListAgentRuntimeEndpointsPaginator
func NewListAgentRuntimeEndpointsPaginator(client ListAgentRuntimeEndpointsAPIClient, params *ListAgentRuntimeEndpointsInput, optFns ...func(*ListAgentRuntimeEndpointsPaginatorOptions)) *ListAgentRuntimeEndpointsPaginator {
	if params == nil {
		params = &ListAgentRuntimeEndpointsInput{}
	}

	options := ListAgentRuntimeEndpointsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAgentRuntimeEndpointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAgentRuntimeEndpointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAgentRuntimeEndpoints page.
func (p *ListAgentRuntimeEndpointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAgentRuntimeEndpointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAgentRuntimeEndpoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAgentRuntimeEndpointsAPIClient is a client that implements the
// ListAgentRuntimeEndpoints operation.
type ListAgentRuntimeEndpointsAPIClient interface {
	ListAgentRuntimeEndpoints(context.Context, *ListAgentRuntimeEndpointsInput, ...func(*Options)) (*ListAgentRuntimeEndpointsOutput, error)
}

var _ ListAgentRuntimeEndpointsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAgentRuntimeEndpoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAgentRuntimeEndpoints",
	}
}
